// Copyright (c) 2021 Emmanuel Gil Peyrot <linkmauve@linkmauve.fr>
//
// This Source Code Form is subject to the terms of the Mozilla Public
// License, v. 2.0. If a copy of the MPL was not distributed with this
// file, You can obtain one at http://mozilla.org/MPL/2.0/.

use hvif::Hvif;
use std::fs::File;
use std::io::{BufReader, Read};
use std::path::PathBuf;

fn main() {
    let args: Vec<_> = std::env::args().collect();
    if args.len() < 2 {
        eprintln!("Usage: {} <file.avif>", args[0]);
        return;
    }
    let filename = PathBuf::from(args[1].clone());
    let file = File::open(filename).unwrap();
    let mut file = BufReader::new(file);
    let mut data = Vec::new();
    file.read_to_end(&mut data).unwrap();
    let hvif = Hvif::parse(&data).unwrap();
    assert!(hvif.0.is_empty());
    println!("{:#?}", hvif.1);
}
