# institute_api

All URIs are relative to *https://dev-sg.portal.hocvienconggiao.com*

Method | HTTP request | Description
------------- | ------------- | -------------
**add_institute**](institute_api.md#add_institute) | **POST** /mutation-api/catholic-polity-service/institutes | Add new institute
**delete_institute**](institute_api.md#delete_institute) | **DELETE** /mutation-api/catholic-polity-service/institutes/{id} | Delete institute by ID
**get_institute_by_id**](institute_api.md#get_institute_by_id) | **GET** /query-api/catholic-polity-service/institutes/{id} | Find institute by ID
**get_institutes**](institute_api.md#get_institutes) | **GET** /query-api/catholic-polity-service/institutes | Get institutes
**update_institute**](institute_api.md#update_institute) | **PUT** /mutation-api/catholic-polity-service/institutes/{id} | Update an existing institute


# **add_institute**
> models::InstituteMutation add_institute(ctx, institute_mutation)
Add new institute

### Required Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **ctx** | **context.Context** | context containing the authentication | nil if no authentication
  **institute_mutation** | [**InstituteMutation**](InstituteMutation.md)| Institute object that needs to be added to the database | 

### Return type

[**models::InstituteMutation**](InstituteMutation.md)

### Authorization

[polity_auth](../README.md#polity_auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **delete_institute**
> delete_institute(ctx, id)
Delete institute by ID

### Required Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **ctx** | **context.Context** | context containing the authentication | nil if no authentication
  **id** | [****](.md)| ID of institute to delete | 

### Return type

 (empty response body)

### Authorization

[polity_auth](../README.md#polity_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_institute_by_id**
> models::InstituteView get_institute_by_id(ctx, id)
Find institute by ID

Returns a single institute

### Required Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **ctx** | **context.Context** | context containing the authentication | nil if no authentication
  **id** | [****](.md)| ID of institute to return | 

### Return type

[**models::InstituteView**](InstituteView.md)

### Authorization

[polity_auth](../README.md#polity_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_institutes**
> models::InstituteCollection get_institutes(ctx, optional)
Get institutes

Returns all institutes

### Required Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **ctx** | **context.Context** | context containing the authentication | nil if no authentication
 **optional** | **map[string]interface{}** | optional parameters | nil if no parameters

### Optional Parameters
Optional parameters are passed through a map[string]interface{}.

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **name** | **String**|  | 
 **offset** | **i32**| The number of institutes to skip before starting to collect the result set. | 
 **count** | **i32**| The number of institutes to return. | [default to 20]

### Return type

[**models::InstituteCollection**](InstituteCollection.md)

### Authorization

[polity_auth](../README.md#polity_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **update_institute**
> models::InstituteMutation update_institute(ctx, id, institute_mutation)
Update an existing institute

### Required Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **ctx** | **context.Context** | context containing the authentication | nil if no authentication
  **id** | [****](.md)| ID of institute to update | 
  **institute_mutation** | [**InstituteMutation**](InstituteMutation.md)| Institute object that needs to be added to the database | 

### Return type

[**models::InstituteMutation**](InstituteMutation.md)

### Authorization

[polity_auth](../README.md#polity_auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

