# deanery_api

All URIs are relative to *https://dev-sg.portal.hocvienconggiao.com*

Method | HTTP request | Description
------------- | ------------- | -------------
**add_deanery**](deanery_api.md#add_deanery) | **POST** /mutation-api/catholic-polity-service/deaneries | Add new deanery
**delete_deanery**](deanery_api.md#delete_deanery) | **DELETE** /mutation-api/catholic-polity-service/deaneries/{id} | Delete deanery by ID
**get_deaneries**](deanery_api.md#get_deaneries) | **GET** /query-api/catholic-polity-service/deaneries | Get deaneries
**get_deanery_by_id**](deanery_api.md#get_deanery_by_id) | **GET** /query-api/catholic-polity-service/deaneries/{id} | Find deanery by ID
**update_deanery**](deanery_api.md#update_deanery) | **PUT** /mutation-api/catholic-polity-service/deaneries/{id} | Update an existing deanery


# **add_deanery**
> models::DeaneryMutation add_deanery(ctx, deanery_mutation)
Add new deanery

### Required Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **ctx** | **context.Context** | context containing the authentication | nil if no authentication
  **deanery_mutation** | [**DeaneryMutation**](DeaneryMutation.md)| Parish object that needs to be added to the database | 

### Return type

[**models::DeaneryMutation**](DeaneryMutation.md)

### Authorization

[polity_auth](../README.md#polity_auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **delete_deanery**
> delete_deanery(ctx, id)
Delete deanery by ID

### Required Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **ctx** | **context.Context** | context containing the authentication | nil if no authentication
  **id** | [****](.md)| ID of deanery to delete | 

### Return type

 (empty response body)

### Authorization

[polity_auth](../README.md#polity_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_deaneries**
> models::DeaneryCollection get_deaneries(ctx, optional)
Get deaneries

Returns all deaneries

### Required Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **ctx** | **context.Context** | context containing the authentication | nil if no authentication
 **optional** | **map[string]interface{}** | optional parameters | nil if no parameters

### Optional Parameters
Optional parameters are passed through a map[string]interface{}.

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **diocese_id** | [****](.md)|  | 
 **name** | **String**|  | 
 **offset** | **i32**| The number of deaneries to skip before starting to collect the result set. | 
 **count** | **i32**| The number of deaneries to return. | [default to 20]

### Return type

[**models::DeaneryCollection**](DeaneryCollection.md)

### Authorization

[polity_auth](../README.md#polity_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_deanery_by_id**
> models::DeaneryView get_deanery_by_id(ctx, id)
Find deanery by ID

Returns a single deanery

### Required Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **ctx** | **context.Context** | context containing the authentication | nil if no authentication
  **id** | [****](.md)| ID of deanery to return | 

### Return type

[**models::DeaneryView**](DeaneryView.md)

### Authorization

[polity_auth](../README.md#polity_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **update_deanery**
> models::DeaneryMutation update_deanery(ctx, id, deanery_mutation)
Update an existing deanery

### Required Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **ctx** | **context.Context** | context containing the authentication | nil if no authentication
  **id** | [****](.md)| ID of deanery to update | 
  **deanery_mutation** | [**DeaneryMutation**](DeaneryMutation.md)| Parish object that needs to be added to the database | 

### Return type

[**models::DeaneryMutation**](DeaneryMutation.md)

### Authorization

[polity_auth](../README.md#polity_auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

