# diocese_api

All URIs are relative to *https://dev-sg.portal.hocvienconggiao.com*

Method | HTTP request | Description
------------- | ------------- | -------------
**add_diocese**](diocese_api.md#add_diocese) | **POST** /mutation-api/catholic-polity-service/dioceses | Add new diocese
**delete_diocese**](diocese_api.md#delete_diocese) | **DELETE** /mutation-api/catholic-polity-service/dioceses/{id} | Delete diocese by ID
**get_diocese_by_id**](diocese_api.md#get_diocese_by_id) | **GET** /query-api/catholic-polity-service/dioceses/{id} | Find diocese by ID
**get_dioceses**](diocese_api.md#get_dioceses) | **GET** /query-api/catholic-polity-service/dioceses | Get all dioceses
**update_diocese**](diocese_api.md#update_diocese) | **PUT** /mutation-api/catholic-polity-service/dioceses/{id} | Update an existing diocese


# **add_diocese**
> models::Diocese add_diocese(ctx, diocese)
Add new diocese

### Required Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **ctx** | **context.Context** | context containing the authentication | nil if no authentication
  **diocese** | [**Diocese**](Diocese.md)| Diocese object that needs to be added to the database | 

### Return type

[**models::Diocese**](Diocese.md)

### Authorization

[polity_auth](../README.md#polity_auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **delete_diocese**
> delete_diocese(ctx, id)
Delete diocese by ID

### Required Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **ctx** | **context.Context** | context containing the authentication | nil if no authentication
  **id** | [****](.md)| ID of diocese to delete | 

### Return type

 (empty response body)

### Authorization

[polity_auth](../README.md#polity_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_diocese_by_id**
> models::Diocese get_diocese_by_id(ctx, id)
Find diocese by ID

Returns a single diocese

### Required Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **ctx** | **context.Context** | context containing the authentication | nil if no authentication
  **id** | [****](.md)| ID of diocese to return | 

### Return type

[**models::Diocese**](Diocese.md)

### Authorization

[polity_auth](../README.md#polity_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_dioceses**
> models::DioceseCollection get_dioceses(ctx, optional)
Get all dioceses

Returns all dioceses

### Required Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **ctx** | **context.Context** | context containing the authentication | nil if no authentication
 **optional** | **map[string]interface{}** | optional parameters | nil if no parameters

### Optional Parameters
Optional parameters are passed through a map[string]interface{}.

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **province_id** | [****](.md)|  | 
 **province_code** | [****](.md)|  | 
 **name** | **String**|  | 
 **location_name** | **String**|  | 
 **location_address** | **String**|  | 
 **location_email** | **String**|  | 
 **sorts** | [**models::DioceseSortCriteria**](models::DioceseSortCriteria.md)|  | 
 **offset** | **i32**| The number of dioceses to skip before starting to collect the result set. | 
 **count** | **i32**| The number of dioceses to return. | [default to 20]

### Return type

[**models::DioceseCollection**](DioceseCollection.md)

### Authorization

[polity_auth](../README.md#polity_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **update_diocese**
> models::Diocese update_diocese(ctx, id, diocese)
Update an existing diocese

### Required Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **ctx** | **context.Context** | context containing the authentication | nil if no authentication
  **id** | [****](.md)| ID of diocese to update | 
  **diocese** | [**Diocese**](Diocese.md)| Diocese object that needs to be added to the database | 

### Return type

[**models::Diocese**](Diocese.md)

### Authorization

[polity_auth](../README.md#polity_auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

