# Rust API for hvcg_governance_openapi_catholic-polity

This is a server for Catholic Polity info.

## Overview

This client/server was generated by the [openapi-generator]
(https://openapi-generator.tech) project.  By using the
[OpenAPI-Spec](https://github.com/OAI/OpenAPI-Specification) from a remote
server, you can easily generate a server stub.

To see how to make this your own, look here:

[README]((https://openapi-generator.tech))

- API version: 0.7.0
- Build date: 2021-09-05T14:39:29.990473579Z[Etc/UTC]



This autogenerated project defines an API crate `hvcg_governance_openapi_catholic-polity` which contains:
* An `Api` trait defining the API in Rust.
* Data types representing the underlying data model.
* A `Client` type which implements `Api` and issues HTTP requests for each operation.
* A router which accepts HTTP requests and invokes the appropriate `Api` method for each operation.

It also contains an example server and client which make use of `hvcg_governance_openapi_catholic-polity`:

* The example server starts up a web server using the `hvcg_governance_openapi_catholic-polity`
    router, and supplies a trivial implementation of `Api` which returns failure
    for every operation.
* The example client provides a CLI which lets you invoke
    any single operation on the `hvcg_governance_openapi_catholic-polity` client by passing appropriate
    arguments on the command line.

You can use the example server and client as a basis for your own code.
See below for [more detail on implementing a server](#writing-a-server).

## Examples

Run examples with:

```
cargo run --example <example-name>
```

To pass in arguments to the examples, put them after `--`, for example:

```
cargo run --example client -- --help
```

### Running the example server
To run the server, follow these simple steps:

```
cargo run --example server
```

### Running the example client
To run a client, follow one of the following simple steps:

```
cargo run --example client DeleteDeanery
cargo run --example client GetDeaneries
cargo run --example client GetDeaneryById
cargo run --example client DeleteDiocese
cargo run --example client GetDioceseById
cargo run --example client GetDioceses
cargo run --example client DeleteInstitute
cargo run --example client GetInstituteById
cargo run --example client GetInstitutes
cargo run --example client AddParish
cargo run --example client DeleteParish
cargo run --example client GetParishById
cargo run --example client GetParishes
cargo run --example client UpdateParish
cargo run --example client AddProvince
cargo run --example client DeleteProvince
cargo run --example client GetProvinceById
cargo run --example client GetProvinces
cargo run --example client UpdateProvince
```

### HTTPS
The examples can be run in HTTPS mode by passing in the flag `--https`, for example:

```
cargo run --example server -- --https
```

This will use the keys/certificates from the examples directory. Note that the
server chain is signed with `CN=localhost`.

## Using the generated library

The generated library has a few optional features that can be activated through Cargo.

* `server`
    * This defaults to enabled and creates the basic skeleton of a server implementation based on hyper
    * To create the server stack you'll need to provide an implementation of the API trait to provide the server function.
* `client`
    * This defaults to enabled and creates the basic skeleton of a client implementation based on hyper
    * The constructed client implements the API trait by making remote API call.
* `conversions`
    * This defaults to disabled and creates extra derives on models to allow "transmogrification" between objects of structurally similar types.

See https://doc.rust-lang.org/cargo/reference/manifest.html#the-features-section for how to use features in your `Cargo.toml`.

## Documentation for API Endpoints

All URIs are relative to *https://dev-sg.portal.hocvienconggiao.com*

Method | HTTP request | Description
------------- | ------------- | -------------
[**add_deanery**](docs/deanery_api.md#add_deanery) | **POST** /mutation-api/catholic-polity-service/deaneries | Add new deanery
[**delete_deanery**](docs/deanery_api.md#delete_deanery) | **DELETE** /mutation-api/catholic-polity-service/deaneries/{id} | Delete deanery by ID
[**get_deaneries**](docs/deanery_api.md#get_deaneries) | **GET** /query-api/catholic-polity-service/deaneries | Get deaneries
[**get_deanery_by_id**](docs/deanery_api.md#get_deanery_by_id) | **GET** /query-api/catholic-polity-service/deaneries/{id} | Find deanery by ID
[**update_deanery**](docs/deanery_api.md#update_deanery) | **PUT** /mutation-api/catholic-polity-service/deaneries/{id} | Update an existing deanery
[**add_diocese**](docs/diocese_api.md#add_diocese) | **POST** /mutation-api/catholic-polity-service/dioceses | Add new diocese
[**delete_diocese**](docs/diocese_api.md#delete_diocese) | **DELETE** /mutation-api/catholic-polity-service/dioceses/{id} | Delete diocese by ID
[**get_diocese_by_id**](docs/diocese_api.md#get_diocese_by_id) | **GET** /query-api/catholic-polity-service/dioceses/{id} | Find diocese by ID
[**get_dioceses**](docs/diocese_api.md#get_dioceses) | **GET** /query-api/catholic-polity-service/dioceses | Get all dioceses
[**update_diocese**](docs/diocese_api.md#update_diocese) | **PUT** /mutation-api/catholic-polity-service/dioceses/{id} | Update an existing diocese
[**add_institute**](docs/institute_api.md#add_institute) | **POST** /mutation-api/catholic-polity-service/institutes | Add new institute
[**delete_institute**](docs/institute_api.md#delete_institute) | **DELETE** /mutation-api/catholic-polity-service/institutes/{id} | Delete institute by ID
[**get_institute_by_id**](docs/institute_api.md#get_institute_by_id) | **GET** /query-api/catholic-polity-service/institutes/{id} | Find institute by ID
[**get_institutes**](docs/institute_api.md#get_institutes) | **GET** /query-api/catholic-polity-service/institutes | Get institutes
[**update_institute**](docs/institute_api.md#update_institute) | **PUT** /mutation-api/catholic-polity-service/institutes/{id} | Update an existing institute
[**add_parish**](docs/parish_api.md#add_parish) | **POST** /mutation-api/catholic-polity-service/parishes | Add new parish
[**delete_parish**](docs/parish_api.md#delete_parish) | **DELETE** /mutation-api/catholic-polity-service/parishes/{id} | Delete parish by ID
[**get_parish_by_id**](docs/parish_api.md#get_parish_by_id) | **GET** /query-api/catholic-polity-service/parishes/{id} | Find parish by ID
[**get_parishes**](docs/parish_api.md#get_parishes) | **GET** /query-api/catholic-polity-service/parishes | Get all parishes
[**update_parish**](docs/parish_api.md#update_parish) | **PUT** /mutation-api/catholic-polity-service/parishes/{id} | Update an existing parish
[**add_province**](docs/province_api.md#add_province) | **POST** /mutation-api/catholic-polity-service/provinces | Add new province
[**delete_province**](docs/province_api.md#delete_province) | **DELETE** /mutation-api/catholic-polity-service/provinces/{id} | Delete province by ID
[**get_province_by_id**](docs/province_api.md#get_province_by_id) | **GET** /query-api/catholic-polity-service/provinces/{id} | Find province by ID
[**get_provinces**](docs/province_api.md#get_provinces) | **GET** /query-api/catholic-polity-service/provinces | Get all provinces
[**update_province**](docs/province_api.md#update_province) | **PUT** /mutation-api/catholic-polity-service/provinces/{id} | Update an existing province


## Documentation For Models

 - [Code](docs/Code.md)
 - [Deanery](docs/Deanery.md)
 - [DeaneryCollection](docs/DeaneryCollection.md)
 - [Diocese](docs/Diocese.md)
 - [DioceseCollection](docs/DioceseCollection.md)
 - [Institute](docs/Institute.md)
 - [InstituteCollection](docs/InstituteCollection.md)
 - [Parish](docs/Parish.md)
 - [ParishCollection](docs/ParishCollection.md)
 - [Polity](docs/Polity.md)
 - [Province](docs/Province.md)
 - [ProvinceCollection](docs/ProvinceCollection.md)


## Documentation For Authorization

## polity_auth
- **Type**: Bearer token authentication

Example
```
```

## Author



