# province_api

All URIs are relative to *https://dev-sg.portal.hocvienconggiao.com*

Method | HTTP request | Description
------------- | ------------- | -------------
**add_province**](province_api.md#add_province) | **POST** /mutation-api/catholic-polity-service/provinces | Add new province
**delete_province**](province_api.md#delete_province) | **DELETE** /mutation-api/catholic-polity-service/provinces/{id} | Delete province by ID
**get_province_by_id**](province_api.md#get_province_by_id) | **GET** /query-api/catholic-polity-service/provinces/{id} | Find province by ID
**get_provinces**](province_api.md#get_provinces) | **GET** /query-api/catholic-polity-service/provinces | Get all provinces
**update_province**](province_api.md#update_province) | **PUT** /mutation-api/catholic-polity-service/provinces/{id} | Update an existing province


# **add_province**
> models::Province add_province(ctx, optional)
Add new province

### Required Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **ctx** | **context.Context** | context containing the authentication | nil if no authentication
 **optional** | **map[string]interface{}** | optional parameters | nil if no parameters

### Optional Parameters
Optional parameters are passed through a map[string]interface{}.

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **province** | [**Province**](Province.md)|  | 

### Return type

[**models::Province**](Province.md)

### Authorization

[polity_auth](../README.md#polity_auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **delete_province**
> delete_province(ctx, id)
Delete province by ID

### Required Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **ctx** | **context.Context** | context containing the authentication | nil if no authentication
  **id** | [****](.md)| ID of province to delete | 

### Return type

 (empty response body)

### Authorization

[polity_auth](../README.md#polity_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_province_by_id**
> models::Province get_province_by_id(ctx, id)
Find province by ID

Returns a single province

### Required Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **ctx** | **context.Context** | context containing the authentication | nil if no authentication
  **id** | [****](.md)| ID of province to return | 

### Return type

[**models::Province**](Province.md)

### Authorization

[polity_auth](../README.md#polity_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_provinces**
> models::ProvinceCollection get_provinces(ctx, optional)
Get all provinces

Returns all provinces

### Required Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **ctx** | **context.Context** | context containing the authentication | nil if no authentication
 **optional** | **map[string]interface{}** | optional parameters | nil if no parameters

### Optional Parameters
Optional parameters are passed through a map[string]interface{}.

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **name** | **String**|  | 
 **province_code** | [****](.md)|  | 
 **offset** | **i32**| The number of provinces to skip before starting to collect the result set. | 
 **count** | **i32**| The number of provinces to return. | [default to 20]

### Return type

[**models::ProvinceCollection**](ProvinceCollection.md)

### Authorization

[polity_auth](../README.md#polity_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **update_province**
> models::Province update_province(ctx, id, optional)
Update an existing province

### Required Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **ctx** | **context.Context** | context containing the authentication | nil if no authentication
  **id** | [****](.md)| ID of province to update | 
 **optional** | **map[string]interface{}** | optional parameters | nil if no parameters

### Optional Parameters
Optional parameters are passed through a map[string]interface{}.

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | [****](.md)| ID of province to update | 
 **province** | [**Province**](Province.md)|  | 

### Return type

[**models::Province**](Province.md)

### Authorization

[polity_auth](../README.md#polity_auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

