#![allow(missing_docs, trivial_casts, unused_variables, unused_mut, unused_imports, unused_extern_crates, non_camel_case_types)]

use async_trait::async_trait;
use futures::Stream;
use std::error::Error;
use std::task::{Poll, Context};
use swagger::{ApiError, ContextWrapper};
use serde::{Serialize, Deserialize};

type ServiceError = Box<dyn Error + Send + Sync + 'static>;

pub const BASE_PATH: &'static str = "";
pub const API_VERSION: &'static str = "0.4.0";

#[derive(Debug, PartialEq, Serialize, Deserialize)]
#[must_use]
pub enum AddDeaneryResponse {
    /// successful operation
    SuccessfulOperation
    (models::Deanery)
    ,
    /// Invalid input
    InvalidInput
}

#[derive(Debug, PartialEq, Serialize, Deserialize)]
#[must_use]
pub enum DeleteDeaneryResponse {
    /// successful operation
    SuccessfulOperation
    ,
    /// Invalid ID supplied
    InvalidIDSupplied
    ,
    /// Deanery not found
    DeaneryNotFound
}

#[derive(Debug, PartialEq, Serialize, Deserialize)]
#[must_use]
pub enum GetDeaneriesResponse {
    /// successful operation
    SuccessfulOperation
    (models::DeaneryCollection)
    ,
    /// Invalid ID supplied
    InvalidIDSupplied
    ,
    /// Deanery not found
    DeaneryNotFound
}

#[derive(Debug, PartialEq, Serialize, Deserialize)]
#[must_use]
pub enum GetDeaneryByIdResponse {
    /// successful operation
    SuccessfulOperation
    (models::Deanery)
    ,
    /// Invalid ID supplied
    InvalidIDSupplied
    ,
    /// Deanery not found
    DeaneryNotFound
}

#[derive(Debug, PartialEq, Serialize, Deserialize)]
#[must_use]
pub enum UpdateDeaneryResponse {
    /// successful operation
    SuccessfulOperation
    (models::Deanery)
    ,
    /// Invalid ID supplied
    InvalidIDSupplied
    ,
    /// Deanery not found
    DeaneryNotFound
    ,
    /// Validation exception
    ValidationException
}

#[derive(Debug, PartialEq, Serialize, Deserialize)]
#[must_use]
pub enum AddDioceseResponse {
    /// successful operation
    SuccessfulOperation
    (models::Diocese)
    ,
    /// Invalid input
    InvalidInput
}

#[derive(Debug, PartialEq, Serialize, Deserialize)]
#[must_use]
pub enum DeleteDioceseResponse {
    /// successful operation
    SuccessfulOperation
    ,
    /// Invalid ID supplied
    InvalidIDSupplied
    ,
    /// Diocese not found
    DioceseNotFound
}

#[derive(Debug, PartialEq, Serialize, Deserialize)]
#[must_use]
pub enum GetDioceseByIdResponse {
    /// successful operation
    SuccessfulOperation
    (models::Diocese)
    ,
    /// Invalid ID supplied
    InvalidIDSupplied
    ,
    /// Diocese not found
    DioceseNotFound
}

#[derive(Debug, PartialEq, Serialize, Deserialize)]
#[must_use]
pub enum GetDiocesesResponse {
    /// successful operation
    SuccessfulOperation
    (models::DioceseCollection)
    ,
    /// Invalid ID supplied
    InvalidIDSupplied
    ,
    /// Diocese not found
    DioceseNotFound
}

#[derive(Debug, PartialEq, Serialize, Deserialize)]
#[must_use]
pub enum UpdateDioceseResponse {
    /// successful operation
    SuccessfulOperation
    (models::Diocese)
    ,
    /// Invalid ID supplied
    InvalidIDSupplied
    ,
    /// Diocese not found
    DioceseNotFound
    ,
    /// Validation exception
    ValidationException
}

#[derive(Debug, PartialEq, Serialize, Deserialize)]
#[must_use]
pub enum AddParishResponse {
    /// successful operation
    SuccessfulOperation
    (models::Parish)
    ,
    /// Invalid input
    InvalidInput
}

#[derive(Debug, PartialEq, Serialize, Deserialize)]
#[must_use]
pub enum DeleteParishResponse {
    /// successful operation
    SuccessfulOperation
    ,
    /// Invalid ID supplied
    InvalidIDSupplied
    ,
    /// Parish not found
    ParishNotFound
}

#[derive(Debug, PartialEq, Serialize, Deserialize)]
#[must_use]
pub enum GetParishByIdResponse {
    /// successful operation
    SuccessfulOperation
    (models::Parish)
    ,
    /// Invalid ID supplied
    InvalidIDSupplied
    ,
    /// Parish not found
    ParishNotFound
}

#[derive(Debug, PartialEq, Serialize, Deserialize)]
#[must_use]
pub enum GetParishesResponse {
    /// successful operation
    SuccessfulOperation
    (models::ParishCollection)
    ,
    /// Invalid ID supplied
    InvalidIDSupplied
    ,
    /// Parish not found
    ParishNotFound
}

#[derive(Debug, PartialEq, Serialize, Deserialize)]
#[must_use]
pub enum UpdateParishResponse {
    /// successful operation
    SuccessfulOperation
    (models::Parish)
    ,
    /// Invalid ID supplied
    InvalidIDSupplied
    ,
    /// Parish not found
    ParishNotFound
    ,
    /// Validation exception
    ValidationException
}

#[derive(Debug, PartialEq, Serialize, Deserialize)]
#[must_use]
pub enum AddProvinceResponse {
    /// successful operation
    SuccessfulOperation
    (models::Province)
    ,
    /// Invalid input
    InvalidInput
}

#[derive(Debug, PartialEq, Serialize, Deserialize)]
#[must_use]
pub enum DeleteProvinceResponse {
    /// successful operation
    SuccessfulOperation
    ,
    /// Invalid ID supplied
    InvalidIDSupplied
    ,
    /// Province not found
    ProvinceNotFound
}

#[derive(Debug, PartialEq, Serialize, Deserialize)]
#[must_use]
pub enum GetProvinceByIdResponse {
    /// successful operation
    SuccessfulOperation
    (models::Province)
    ,
    /// Invalid ID supplied
    InvalidIDSupplied
    ,
    /// Province not found
    ProvinceNotFound
}

#[derive(Debug, PartialEq, Serialize, Deserialize)]
#[must_use]
pub enum GetProvincesResponse {
    /// successful operation
    SuccessfulOperation
    (models::ProvinceCollection)
    ,
    /// Invalid ID supplied
    InvalidIDSupplied
    ,
    /// Province not found
    ProvinceNotFound
}

#[derive(Debug, PartialEq, Serialize, Deserialize)]
#[must_use]
pub enum UpdateProvinceResponse {
    /// successful operation
    SuccessfulOperation
    (models::Province)
    ,
    /// Invalid ID supplied
    InvalidIDSupplied
    ,
    /// Province not found
    ProvinceNotFound
    ,
    /// Validation exception
    ValidationException
}

/// API
#[async_trait]
pub trait Api<C: Send + Sync> {
    fn poll_ready(&self, _cx: &mut Context) -> Poll<Result<(), Box<dyn Error + Send + Sync + 'static>>> {
        Poll::Ready(Ok(()))
    }

    /// Add new deanery
    async fn add_deanery(
        &self,
        deanery: models::Deanery,
        context: &C) -> Result<AddDeaneryResponse, ApiError>;

    /// Delete deanery by ID
    async fn delete_deanery(
        &self,
        id: uuid::Uuid,
        context: &C) -> Result<DeleteDeaneryResponse, ApiError>;

    /// Get deaneries
    async fn get_deaneries(
        &self,
        diocese_id: Option<uuid::Uuid>,
        name: Option<String>,
        offset: Option<i32>,
        count: Option<i32>,
        context: &C) -> Result<GetDeaneriesResponse, ApiError>;

    /// Find deanery by ID
    async fn get_deanery_by_id(
        &self,
        id: uuid::Uuid,
        context: &C) -> Result<GetDeaneryByIdResponse, ApiError>;

    /// Update an existing deanery
    async fn update_deanery(
        &self,
        id: uuid::Uuid,
        deanery: models::Deanery,
        context: &C) -> Result<UpdateDeaneryResponse, ApiError>;

    /// Add new diocese
    async fn add_diocese(
        &self,
        diocese: models::Diocese,
        context: &C) -> Result<AddDioceseResponse, ApiError>;

    /// Delete diocese by ID
    async fn delete_diocese(
        &self,
        id: uuid::Uuid,
        context: &C) -> Result<DeleteDioceseResponse, ApiError>;

    /// Find diocese by ID
    async fn get_diocese_by_id(
        &self,
        id: uuid::Uuid,
        context: &C) -> Result<GetDioceseByIdResponse, ApiError>;

    /// Get all dioceses
    async fn get_dioceses(
        &self,
        province_id: Option<uuid::Uuid>,
        province_code: Option<models::Code>,
        name: Option<String>,
        offset: Option<i32>,
        count: Option<i32>,
        context: &C) -> Result<GetDiocesesResponse, ApiError>;

    /// Update an existing diocese
    async fn update_diocese(
        &self,
        id: uuid::Uuid,
        diocese: models::Diocese,
        context: &C) -> Result<UpdateDioceseResponse, ApiError>;

    /// Add new parish
    async fn add_parish(
        &self,
        parish: Option<models::Parish>,
        context: &C) -> Result<AddParishResponse, ApiError>;

    /// Delete parish by ID
    async fn delete_parish(
        &self,
        id: uuid::Uuid,
        context: &C) -> Result<DeleteParishResponse, ApiError>;

    /// Find parish by ID
    async fn get_parish_by_id(
        &self,
        id: uuid::Uuid,
        context: &C) -> Result<GetParishByIdResponse, ApiError>;

    /// Get all parishes
    async fn get_parishes(
        &self,
        deanery_id: Option<uuid::Uuid>,
        diocese_id: Option<uuid::Uuid>,
        name: Option<String>,
        offset: Option<i32>,
        count: Option<i32>,
        context: &C) -> Result<GetParishesResponse, ApiError>;

    /// Update an existing parish
    async fn update_parish(
        &self,
        id: uuid::Uuid,
        parish: Option<models::Parish>,
        context: &C) -> Result<UpdateParishResponse, ApiError>;

    /// Add new province
    async fn add_province(
        &self,
        province: Option<models::Province>,
        context: &C) -> Result<AddProvinceResponse, ApiError>;

    /// Delete province by ID
    async fn delete_province(
        &self,
        id: uuid::Uuid,
        context: &C) -> Result<DeleteProvinceResponse, ApiError>;

    /// Find province by ID
    async fn get_province_by_id(
        &self,
        id: uuid::Uuid,
        context: &C) -> Result<GetProvinceByIdResponse, ApiError>;

    /// Get all provinces
    async fn get_provinces(
        &self,
        name: Option<String>,
        province_code: Option<models::Code>,
        offset: Option<i32>,
        count: Option<i32>,
        context: &C) -> Result<GetProvincesResponse, ApiError>;

    /// Update an existing province
    async fn update_province(
        &self,
        id: uuid::Uuid,
        province: Option<models::Province>,
        context: &C) -> Result<UpdateProvinceResponse, ApiError>;

}

/// API where `Context` isn't passed on every API call
#[async_trait]
pub trait ApiNoContext<C: Send + Sync> {

    fn poll_ready(&self, _cx: &mut Context) -> Poll<Result<(), Box<dyn Error + Send + Sync + 'static>>>;

    fn context(&self) -> &C;

    /// Add new deanery
    async fn add_deanery(
        &self,
        deanery: models::Deanery,
        ) -> Result<AddDeaneryResponse, ApiError>;

    /// Delete deanery by ID
    async fn delete_deanery(
        &self,
        id: uuid::Uuid,
        ) -> Result<DeleteDeaneryResponse, ApiError>;

    /// Get deaneries
    async fn get_deaneries(
        &self,
        diocese_id: Option<uuid::Uuid>,
        name: Option<String>,
        offset: Option<i32>,
        count: Option<i32>,
        ) -> Result<GetDeaneriesResponse, ApiError>;

    /// Find deanery by ID
    async fn get_deanery_by_id(
        &self,
        id: uuid::Uuid,
        ) -> Result<GetDeaneryByIdResponse, ApiError>;

    /// Update an existing deanery
    async fn update_deanery(
        &self,
        id: uuid::Uuid,
        deanery: models::Deanery,
        ) -> Result<UpdateDeaneryResponse, ApiError>;

    /// Add new diocese
    async fn add_diocese(
        &self,
        diocese: models::Diocese,
        ) -> Result<AddDioceseResponse, ApiError>;

    /// Delete diocese by ID
    async fn delete_diocese(
        &self,
        id: uuid::Uuid,
        ) -> Result<DeleteDioceseResponse, ApiError>;

    /// Find diocese by ID
    async fn get_diocese_by_id(
        &self,
        id: uuid::Uuid,
        ) -> Result<GetDioceseByIdResponse, ApiError>;

    /// Get all dioceses
    async fn get_dioceses(
        &self,
        province_id: Option<uuid::Uuid>,
        province_code: Option<models::Code>,
        name: Option<String>,
        offset: Option<i32>,
        count: Option<i32>,
        ) -> Result<GetDiocesesResponse, ApiError>;

    /// Update an existing diocese
    async fn update_diocese(
        &self,
        id: uuid::Uuid,
        diocese: models::Diocese,
        ) -> Result<UpdateDioceseResponse, ApiError>;

    /// Add new parish
    async fn add_parish(
        &self,
        parish: Option<models::Parish>,
        ) -> Result<AddParishResponse, ApiError>;

    /// Delete parish by ID
    async fn delete_parish(
        &self,
        id: uuid::Uuid,
        ) -> Result<DeleteParishResponse, ApiError>;

    /// Find parish by ID
    async fn get_parish_by_id(
        &self,
        id: uuid::Uuid,
        ) -> Result<GetParishByIdResponse, ApiError>;

    /// Get all parishes
    async fn get_parishes(
        &self,
        deanery_id: Option<uuid::Uuid>,
        diocese_id: Option<uuid::Uuid>,
        name: Option<String>,
        offset: Option<i32>,
        count: Option<i32>,
        ) -> Result<GetParishesResponse, ApiError>;

    /// Update an existing parish
    async fn update_parish(
        &self,
        id: uuid::Uuid,
        parish: Option<models::Parish>,
        ) -> Result<UpdateParishResponse, ApiError>;

    /// Add new province
    async fn add_province(
        &self,
        province: Option<models::Province>,
        ) -> Result<AddProvinceResponse, ApiError>;

    /// Delete province by ID
    async fn delete_province(
        &self,
        id: uuid::Uuid,
        ) -> Result<DeleteProvinceResponse, ApiError>;

    /// Find province by ID
    async fn get_province_by_id(
        &self,
        id: uuid::Uuid,
        ) -> Result<GetProvinceByIdResponse, ApiError>;

    /// Get all provinces
    async fn get_provinces(
        &self,
        name: Option<String>,
        province_code: Option<models::Code>,
        offset: Option<i32>,
        count: Option<i32>,
        ) -> Result<GetProvincesResponse, ApiError>;

    /// Update an existing province
    async fn update_province(
        &self,
        id: uuid::Uuid,
        province: Option<models::Province>,
        ) -> Result<UpdateProvinceResponse, ApiError>;

}

/// Trait to extend an API to make it easy to bind it to a context.
pub trait ContextWrapperExt<C: Send + Sync> where Self: Sized
{
    /// Binds this API to a context.
    fn with_context(self: Self, context: C) -> ContextWrapper<Self, C>;
}

impl<T: Api<C> + Send + Sync, C: Clone + Send + Sync> ContextWrapperExt<C> for T {
    fn with_context(self: T, context: C) -> ContextWrapper<T, C> {
         ContextWrapper::<T, C>::new(self, context)
    }
}

#[async_trait]
impl<T: Api<C> + Send + Sync, C: Clone + Send + Sync> ApiNoContext<C> for ContextWrapper<T, C> {
    fn poll_ready(&self, cx: &mut Context) -> Poll<Result<(), ServiceError>> {
        self.api().poll_ready(cx)
    }

    fn context(&self) -> &C {
        ContextWrapper::context(self)
    }

    /// Add new deanery
    async fn add_deanery(
        &self,
        deanery: models::Deanery,
        ) -> Result<AddDeaneryResponse, ApiError>
    {
        let context = self.context().clone();
        self.api().add_deanery(deanery, &context).await
    }

    /// Delete deanery by ID
    async fn delete_deanery(
        &self,
        id: uuid::Uuid,
        ) -> Result<DeleteDeaneryResponse, ApiError>
    {
        let context = self.context().clone();
        self.api().delete_deanery(id, &context).await
    }

    /// Get deaneries
    async fn get_deaneries(
        &self,
        diocese_id: Option<uuid::Uuid>,
        name: Option<String>,
        offset: Option<i32>,
        count: Option<i32>,
        ) -> Result<GetDeaneriesResponse, ApiError>
    {
        let context = self.context().clone();
        self.api().get_deaneries(diocese_id, name, offset, count, &context).await
    }

    /// Find deanery by ID
    async fn get_deanery_by_id(
        &self,
        id: uuid::Uuid,
        ) -> Result<GetDeaneryByIdResponse, ApiError>
    {
        let context = self.context().clone();
        self.api().get_deanery_by_id(id, &context).await
    }

    /// Update an existing deanery
    async fn update_deanery(
        &self,
        id: uuid::Uuid,
        deanery: models::Deanery,
        ) -> Result<UpdateDeaneryResponse, ApiError>
    {
        let context = self.context().clone();
        self.api().update_deanery(id, deanery, &context).await
    }

    /// Add new diocese
    async fn add_diocese(
        &self,
        diocese: models::Diocese,
        ) -> Result<AddDioceseResponse, ApiError>
    {
        let context = self.context().clone();
        self.api().add_diocese(diocese, &context).await
    }

    /// Delete diocese by ID
    async fn delete_diocese(
        &self,
        id: uuid::Uuid,
        ) -> Result<DeleteDioceseResponse, ApiError>
    {
        let context = self.context().clone();
        self.api().delete_diocese(id, &context).await
    }

    /// Find diocese by ID
    async fn get_diocese_by_id(
        &self,
        id: uuid::Uuid,
        ) -> Result<GetDioceseByIdResponse, ApiError>
    {
        let context = self.context().clone();
        self.api().get_diocese_by_id(id, &context).await
    }

    /// Get all dioceses
    async fn get_dioceses(
        &self,
        province_id: Option<uuid::Uuid>,
        province_code: Option<models::Code>,
        name: Option<String>,
        offset: Option<i32>,
        count: Option<i32>,
        ) -> Result<GetDiocesesResponse, ApiError>
    {
        let context = self.context().clone();
        self.api().get_dioceses(province_id, province_code, name, offset, count, &context).await
    }

    /// Update an existing diocese
    async fn update_diocese(
        &self,
        id: uuid::Uuid,
        diocese: models::Diocese,
        ) -> Result<UpdateDioceseResponse, ApiError>
    {
        let context = self.context().clone();
        self.api().update_diocese(id, diocese, &context).await
    }

    /// Add new parish
    async fn add_parish(
        &self,
        parish: Option<models::Parish>,
        ) -> Result<AddParishResponse, ApiError>
    {
        let context = self.context().clone();
        self.api().add_parish(parish, &context).await
    }

    /// Delete parish by ID
    async fn delete_parish(
        &self,
        id: uuid::Uuid,
        ) -> Result<DeleteParishResponse, ApiError>
    {
        let context = self.context().clone();
        self.api().delete_parish(id, &context).await
    }

    /// Find parish by ID
    async fn get_parish_by_id(
        &self,
        id: uuid::Uuid,
        ) -> Result<GetParishByIdResponse, ApiError>
    {
        let context = self.context().clone();
        self.api().get_parish_by_id(id, &context).await
    }

    /// Get all parishes
    async fn get_parishes(
        &self,
        deanery_id: Option<uuid::Uuid>,
        diocese_id: Option<uuid::Uuid>,
        name: Option<String>,
        offset: Option<i32>,
        count: Option<i32>,
        ) -> Result<GetParishesResponse, ApiError>
    {
        let context = self.context().clone();
        self.api().get_parishes(deanery_id, diocese_id, name, offset, count, &context).await
    }

    /// Update an existing parish
    async fn update_parish(
        &self,
        id: uuid::Uuid,
        parish: Option<models::Parish>,
        ) -> Result<UpdateParishResponse, ApiError>
    {
        let context = self.context().clone();
        self.api().update_parish(id, parish, &context).await
    }

    /// Add new province
    async fn add_province(
        &self,
        province: Option<models::Province>,
        ) -> Result<AddProvinceResponse, ApiError>
    {
        let context = self.context().clone();
        self.api().add_province(province, &context).await
    }

    /// Delete province by ID
    async fn delete_province(
        &self,
        id: uuid::Uuid,
        ) -> Result<DeleteProvinceResponse, ApiError>
    {
        let context = self.context().clone();
        self.api().delete_province(id, &context).await
    }

    /// Find province by ID
    async fn get_province_by_id(
        &self,
        id: uuid::Uuid,
        ) -> Result<GetProvinceByIdResponse, ApiError>
    {
        let context = self.context().clone();
        self.api().get_province_by_id(id, &context).await
    }

    /// Get all provinces
    async fn get_provinces(
        &self,
        name: Option<String>,
        province_code: Option<models::Code>,
        offset: Option<i32>,
        count: Option<i32>,
        ) -> Result<GetProvincesResponse, ApiError>
    {
        let context = self.context().clone();
        self.api().get_provinces(name, province_code, offset, count, &context).await
    }

    /// Update an existing province
    async fn update_province(
        &self,
        id: uuid::Uuid,
        province: Option<models::Province>,
        ) -> Result<UpdateProvinceResponse, ApiError>
    {
        let context = self.context().clone();
        self.api().update_province(id, province, &context).await
    }

}


#[cfg(feature = "client")]
pub mod client;

// Re-export Client as a top-level name
#[cfg(feature = "client")]
pub use client::Client;

#[cfg(feature = "server")]
pub mod server;

// Re-export router() as a top-level name
#[cfg(feature = "server")]
pub use self::server::Service;

#[cfg(feature = "server")]
pub mod context;

pub mod models;

#[cfg(any(feature = "client", feature = "server"))]
pub(crate) mod header;
