use futures::{future, future::BoxFuture, Stream, stream, future::FutureExt, stream::TryStreamExt};
use hyper::{Request, Response, StatusCode, Body, HeaderMap};
use hyper::header::{HeaderName, HeaderValue, CONTENT_TYPE};
use log::warn;
#[allow(unused_imports)]
use std::convert::{TryFrom, TryInto};
use std::error::Error;
use std::future::Future;
use std::marker::PhantomData;
use std::task::{Context, Poll};
use swagger::{ApiError, BodyExt, Has, RequestParser, XSpanIdString};
pub use swagger::auth::Authorization;
use swagger::auth::Scopes;
use url::form_urlencoded;

#[allow(unused_imports)]
use crate::models;
use crate::header;

pub use crate::context;

type ServiceFuture = BoxFuture<'static, Result<Response<Body>, crate::ServiceError>>;

use crate::{Api,
     AddDeaneryResponse,
     DeleteDeaneryResponse,
     GetDeaneriesResponse,
     GetDeaneryByIdResponse,
     UpdateDeaneryResponse,
     AddDioceseResponse,
     DeleteDioceseResponse,
     GetDioceseByIdResponse,
     GetDiocesesResponse,
     UpdateDioceseResponse,
     AddInstituteResponse,
     DeleteInstituteResponse,
     GetInstituteByIdResponse,
     GetInstitutesResponse,
     UpdateInstituteResponse,
     AddParishResponse,
     DeleteParishResponse,
     GetParishByIdResponse,
     GetParishesResponse,
     UpdateParishResponse,
     AddProvinceResponse,
     DeleteProvinceResponse,
     GetProvinceByIdResponse,
     GetProvincesResponse,
     UpdateProvinceResponse
};

mod paths {
    use lazy_static::lazy_static;

    lazy_static! {
        pub static ref GLOBAL_REGEX_SET: regex::RegexSet = regex::RegexSet::new(vec![
            r"^/mutation-api/catholic-polity-service/deaneries$",
            r"^/mutation-api/catholic-polity-service/deaneries/(?P<id>[^/?#]*)$",
            r"^/mutation-api/catholic-polity-service/dioceses$",
            r"^/mutation-api/catholic-polity-service/dioceses/(?P<id>[^/?#]*)$",
            r"^/mutation-api/catholic-polity-service/institutes$",
            r"^/mutation-api/catholic-polity-service/institutes/(?P<id>[^/?#]*)$",
            r"^/mutation-api/catholic-polity-service/parishes$",
            r"^/mutation-api/catholic-polity-service/parishes/(?P<id>[^/?#]*)$",
            r"^/mutation-api/catholic-polity-service/provinces$",
            r"^/mutation-api/catholic-polity-service/provinces/(?P<id>[^/?#]*)$",
            r"^/query-api/catholic-polity-service/deaneries$",
            r"^/query-api/catholic-polity-service/deaneries/(?P<id>[^/?#]*)$",
            r"^/query-api/catholic-polity-service/dioceses$",
            r"^/query-api/catholic-polity-service/dioceses/(?P<id>[^/?#]*)$",
            r"^/query-api/catholic-polity-service/institutes$",
            r"^/query-api/catholic-polity-service/institutes/(?P<id>[^/?#]*)$",
            r"^/query-api/catholic-polity-service/parishes$",
            r"^/query-api/catholic-polity-service/parishes/(?P<id>[^/?#]*)$",
            r"^/query-api/catholic-polity-service/provinces$",
            r"^/query-api/catholic-polity-service/provinces/(?P<id>[^/?#]*)$"
        ])
        .expect("Unable to create global regex set");
    }
    pub(crate) static ID_MUTATION_API_CATHOLIC_POLITY_SERVICE_DEANERIES: usize = 0;
    pub(crate) static ID_MUTATION_API_CATHOLIC_POLITY_SERVICE_DEANERIES_ID: usize = 1;
    lazy_static! {
        pub static ref REGEX_MUTATION_API_CATHOLIC_POLITY_SERVICE_DEANERIES_ID: regex::Regex =
            regex::Regex::new(r"^/mutation-api/catholic-polity-service/deaneries/(?P<id>[^/?#]*)$")
                .expect("Unable to create regex for MUTATION_API_CATHOLIC_POLITY_SERVICE_DEANERIES_ID");
    }
    pub(crate) static ID_MUTATION_API_CATHOLIC_POLITY_SERVICE_DIOCESES: usize = 2;
    pub(crate) static ID_MUTATION_API_CATHOLIC_POLITY_SERVICE_DIOCESES_ID: usize = 3;
    lazy_static! {
        pub static ref REGEX_MUTATION_API_CATHOLIC_POLITY_SERVICE_DIOCESES_ID: regex::Regex =
            regex::Regex::new(r"^/mutation-api/catholic-polity-service/dioceses/(?P<id>[^/?#]*)$")
                .expect("Unable to create regex for MUTATION_API_CATHOLIC_POLITY_SERVICE_DIOCESES_ID");
    }
    pub(crate) static ID_MUTATION_API_CATHOLIC_POLITY_SERVICE_INSTITUTES: usize = 4;
    pub(crate) static ID_MUTATION_API_CATHOLIC_POLITY_SERVICE_INSTITUTES_ID: usize = 5;
    lazy_static! {
        pub static ref REGEX_MUTATION_API_CATHOLIC_POLITY_SERVICE_INSTITUTES_ID: regex::Regex =
            regex::Regex::new(r"^/mutation-api/catholic-polity-service/institutes/(?P<id>[^/?#]*)$")
                .expect("Unable to create regex for MUTATION_API_CATHOLIC_POLITY_SERVICE_INSTITUTES_ID");
    }
    pub(crate) static ID_MUTATION_API_CATHOLIC_POLITY_SERVICE_PARISHES: usize = 6;
    pub(crate) static ID_MUTATION_API_CATHOLIC_POLITY_SERVICE_PARISHES_ID: usize = 7;
    lazy_static! {
        pub static ref REGEX_MUTATION_API_CATHOLIC_POLITY_SERVICE_PARISHES_ID: regex::Regex =
            regex::Regex::new(r"^/mutation-api/catholic-polity-service/parishes/(?P<id>[^/?#]*)$")
                .expect("Unable to create regex for MUTATION_API_CATHOLIC_POLITY_SERVICE_PARISHES_ID");
    }
    pub(crate) static ID_MUTATION_API_CATHOLIC_POLITY_SERVICE_PROVINCES: usize = 8;
    pub(crate) static ID_MUTATION_API_CATHOLIC_POLITY_SERVICE_PROVINCES_ID: usize = 9;
    lazy_static! {
        pub static ref REGEX_MUTATION_API_CATHOLIC_POLITY_SERVICE_PROVINCES_ID: regex::Regex =
            regex::Regex::new(r"^/mutation-api/catholic-polity-service/provinces/(?P<id>[^/?#]*)$")
                .expect("Unable to create regex for MUTATION_API_CATHOLIC_POLITY_SERVICE_PROVINCES_ID");
    }
    pub(crate) static ID_QUERY_API_CATHOLIC_POLITY_SERVICE_DEANERIES: usize = 10;
    pub(crate) static ID_QUERY_API_CATHOLIC_POLITY_SERVICE_DEANERIES_ID: usize = 11;
    lazy_static! {
        pub static ref REGEX_QUERY_API_CATHOLIC_POLITY_SERVICE_DEANERIES_ID: regex::Regex =
            regex::Regex::new(r"^/query-api/catholic-polity-service/deaneries/(?P<id>[^/?#]*)$")
                .expect("Unable to create regex for QUERY_API_CATHOLIC_POLITY_SERVICE_DEANERIES_ID");
    }
    pub(crate) static ID_QUERY_API_CATHOLIC_POLITY_SERVICE_DIOCESES: usize = 12;
    pub(crate) static ID_QUERY_API_CATHOLIC_POLITY_SERVICE_DIOCESES_ID: usize = 13;
    lazy_static! {
        pub static ref REGEX_QUERY_API_CATHOLIC_POLITY_SERVICE_DIOCESES_ID: regex::Regex =
            regex::Regex::new(r"^/query-api/catholic-polity-service/dioceses/(?P<id>[^/?#]*)$")
                .expect("Unable to create regex for QUERY_API_CATHOLIC_POLITY_SERVICE_DIOCESES_ID");
    }
    pub(crate) static ID_QUERY_API_CATHOLIC_POLITY_SERVICE_INSTITUTES: usize = 14;
    pub(crate) static ID_QUERY_API_CATHOLIC_POLITY_SERVICE_INSTITUTES_ID: usize = 15;
    lazy_static! {
        pub static ref REGEX_QUERY_API_CATHOLIC_POLITY_SERVICE_INSTITUTES_ID: regex::Regex =
            regex::Regex::new(r"^/query-api/catholic-polity-service/institutes/(?P<id>[^/?#]*)$")
                .expect("Unable to create regex for QUERY_API_CATHOLIC_POLITY_SERVICE_INSTITUTES_ID");
    }
    pub(crate) static ID_QUERY_API_CATHOLIC_POLITY_SERVICE_PARISHES: usize = 16;
    pub(crate) static ID_QUERY_API_CATHOLIC_POLITY_SERVICE_PARISHES_ID: usize = 17;
    lazy_static! {
        pub static ref REGEX_QUERY_API_CATHOLIC_POLITY_SERVICE_PARISHES_ID: regex::Regex =
            regex::Regex::new(r"^/query-api/catholic-polity-service/parishes/(?P<id>[^/?#]*)$")
                .expect("Unable to create regex for QUERY_API_CATHOLIC_POLITY_SERVICE_PARISHES_ID");
    }
    pub(crate) static ID_QUERY_API_CATHOLIC_POLITY_SERVICE_PROVINCES: usize = 18;
    pub(crate) static ID_QUERY_API_CATHOLIC_POLITY_SERVICE_PROVINCES_ID: usize = 19;
    lazy_static! {
        pub static ref REGEX_QUERY_API_CATHOLIC_POLITY_SERVICE_PROVINCES_ID: regex::Regex =
            regex::Regex::new(r"^/query-api/catholic-polity-service/provinces/(?P<id>[^/?#]*)$")
                .expect("Unable to create regex for QUERY_API_CATHOLIC_POLITY_SERVICE_PROVINCES_ID");
    }
}

pub struct MakeService<T, C> where
    T: Api<C> + Clone + Send + 'static,
    C: Has<XSpanIdString> + Has<Option<Authorization>> + Send + Sync + 'static
{
    api_impl: T,
    marker: PhantomData<C>,
}

impl<T, C> MakeService<T, C> where
    T: Api<C> + Clone + Send + 'static,
    C: Has<XSpanIdString> + Has<Option<Authorization>> + Send + Sync + 'static
{
    pub fn new(api_impl: T) -> Self {
        MakeService {
            api_impl,
            marker: PhantomData
        }
    }
}

impl<T, C, Target> hyper::service::Service<Target> for MakeService<T, C> where
    T: Api<C> + Clone + Send + 'static,
    C: Has<XSpanIdString> + Has<Option<Authorization>> + Send + Sync + 'static
{
    type Response = Service<T, C>;
    type Error = crate::ServiceError;
    type Future = future::Ready<Result<Self::Response, Self::Error>>;

    fn poll_ready(&mut self, cx: &mut Context<'_>) -> Poll<Result<(), Self::Error>> {
        Poll::Ready(Ok(()))
    }

    fn call(&mut self, target: Target) -> Self::Future {
        futures::future::ok(Service::new(
            self.api_impl.clone(),
        ))
    }
}

fn method_not_allowed() -> Result<Response<Body>, crate::ServiceError> {
    Ok(
        Response::builder().status(StatusCode::METHOD_NOT_ALLOWED)
            .body(Body::empty())
            .expect("Unable to create Method Not Allowed response")
    )
}

pub struct Service<T, C> where
    T: Api<C> + Clone + Send + 'static,
    C: Has<XSpanIdString> + Has<Option<Authorization>> + Send + Sync + 'static
{
    api_impl: T,
    marker: PhantomData<C>,
}

impl<T, C> Service<T, C> where
    T: Api<C> + Clone + Send + 'static,
    C: Has<XSpanIdString> + Has<Option<Authorization>> + Send + Sync + 'static
{
    pub fn new(api_impl: T) -> Self {
        Service {
            api_impl: api_impl,
            marker: PhantomData
        }
    }
}

impl<T, C> Clone for Service<T, C> where
    T: Api<C> + Clone + Send + 'static,
    C: Has<XSpanIdString> + Has<Option<Authorization>> + Send + Sync + 'static
{
    fn clone(&self) -> Self {
        Service {
            api_impl: self.api_impl.clone(),
            marker: self.marker.clone(),
        }
    }
}

impl<T, C> hyper::service::Service<(Request<Body>, C)> for Service<T, C> where
    T: Api<C> + Clone + Send + Sync + 'static,
    C: Has<XSpanIdString> + Has<Option<Authorization>> + Send + Sync + 'static
{
    type Response = Response<Body>;
    type Error = crate::ServiceError;
    type Future = ServiceFuture;

    fn poll_ready(&mut self, cx: &mut Context) -> Poll<Result<(), Self::Error>> {
        self.api_impl.poll_ready(cx)
    }

    fn call(&mut self, req: (Request<Body>, C)) -> Self::Future { async fn run<T, C>(mut api_impl: T, req: (Request<Body>, C)) -> Result<Response<Body>, crate::ServiceError> where
        T: Api<C> + Clone + Send + 'static,
        C: Has<XSpanIdString> + Has<Option<Authorization>> + Send + Sync + 'static
    {
        let (request, context) = req;
        let (parts, body) = request.into_parts();
        let (method, uri, headers) = (parts.method, parts.uri, parts.headers);
        let path = paths::GLOBAL_REGEX_SET.matches(uri.path());

        match &method {

            // AddDeanery - POST /mutation-api/catholic-polity-service/deaneries
            &hyper::Method::POST if path.matched(paths::ID_MUTATION_API_CATHOLIC_POLITY_SERVICE_DEANERIES) => {
                {
                    let authorization = match (&context as &dyn Has<Option<Authorization>>).get() {
                        &Some(ref authorization) => authorization,
                        &None => return Ok(Response::builder()
                                                .status(StatusCode::FORBIDDEN)
                                                .body(Body::from("Unauthenticated"))
                                                .expect("Unable to create Authentication Forbidden response")),
                    };
                }

                // Body parameters (note that non-required body parameters will ignore garbage
                // values, rather than causing a 400 response). Produce warning header and logs for
                // any unused fields.
                let result = body.to_raw().await;
                match result {
                            Ok(body) => {
                                let mut unused_elements = Vec::new();
                                let param_deanery_mutation: Option<models::DeaneryMutation> = if !body.is_empty() {
                                    let deserializer = &mut serde_json::Deserializer::from_slice(&*body);
                                    match serde_ignored::deserialize(deserializer, |path| {
                                            warn!("Ignoring unknown field in body: {}", path);
                                            unused_elements.push(path.to_string());
                                    }) {
                                        Ok(param_deanery_mutation) => param_deanery_mutation,
                                        Err(e) => return Ok(Response::builder()
                                                        .status(StatusCode::BAD_REQUEST)
                                                        .body(Body::from(format!("Couldn't parse body parameter DeaneryMutation - doesn't match schema: {}", e)))
                                                        .expect("Unable to create Bad Request response for invalid body parameter DeaneryMutation due to schema")),
                                    }
                                } else {
                                    None
                                };
                                let param_deanery_mutation = match param_deanery_mutation {
                                    Some(param_deanery_mutation) => param_deanery_mutation,
                                    None => return Ok(Response::builder()
                                                        .status(StatusCode::BAD_REQUEST)
                                                        .body(Body::from("Missing required body parameter DeaneryMutation"))
                                                        .expect("Unable to create Bad Request response for missing body parameter DeaneryMutation")),
                                };

                                let result = api_impl.add_deanery(
                                            param_deanery_mutation,
                                        &context
                                    ).await;
                                let mut response = Response::new(Body::empty());
                                response.headers_mut().insert(
                                            HeaderName::from_static("x-span-id"),
                                            HeaderValue::from_str((&context as &dyn Has<XSpanIdString>).get().0.clone().to_string().as_str())
                                                .expect("Unable to create X-Span-ID header value"));

                                        if !unused_elements.is_empty() {
                                            response.headers_mut().insert(
                                                HeaderName::from_static("warning"),
                                                HeaderValue::from_str(format!("Ignoring unknown fields in body: {:?}", unused_elements).as_str())
                                                    .expect("Unable to create Warning header value"));
                                        }

                                        match result {
                                            Ok(rsp) => match rsp {
                                                AddDeaneryResponse::SuccessfulOperation
                                                    (body)
                                                => {
                                                    *response.status_mut() = StatusCode::from_u16(200).expect("Unable to turn 200 into a StatusCode");
                                                    response.headers_mut().insert(
                                                        CONTENT_TYPE,
                                                        HeaderValue::from_str("application/json")
                                                            .expect("Unable to create Content-Type header for ADD_DEANERY_SUCCESSFUL_OPERATION"));
                                                    let body = serde_json::to_string(&body).expect("impossible to fail to serialize");
                                                    *response.body_mut() = Body::from(body);
                                                },
                                                AddDeaneryResponse::InvalidInput
                                                => {
                                                    *response.status_mut() = StatusCode::from_u16(405).expect("Unable to turn 405 into a StatusCode");
                                                },
                                            },
                                            Err(_) => {
                                                // Application code returned an error. This should not happen, as the implementation should
                                                // return a valid response.
                                                *response.status_mut() = StatusCode::INTERNAL_SERVER_ERROR;
                                                *response.body_mut() = Body::from("An internal error occurred");
                                            },
                                        }

                                        Ok(response)
                            },
                            Err(e) => Ok(Response::builder()
                                                .status(StatusCode::BAD_REQUEST)
                                                .body(Body::from(format!("Couldn't read body parameter DeaneryMutation: {}", e)))
                                                .expect("Unable to create Bad Request response due to unable to read body parameter DeaneryMutation")),
                        }
            },

            // DeleteDeanery - DELETE /mutation-api/catholic-polity-service/deaneries/{id}
            &hyper::Method::DELETE if path.matched(paths::ID_MUTATION_API_CATHOLIC_POLITY_SERVICE_DEANERIES_ID) => {
                {
                    let authorization = match (&context as &dyn Has<Option<Authorization>>).get() {
                        &Some(ref authorization) => authorization,
                        &None => return Ok(Response::builder()
                                                .status(StatusCode::FORBIDDEN)
                                                .body(Body::from("Unauthenticated"))
                                                .expect("Unable to create Authentication Forbidden response")),
                    };
                }

                // Path parameters
                let path: &str = &uri.path().to_string();
                let path_params =
                    paths::REGEX_MUTATION_API_CATHOLIC_POLITY_SERVICE_DEANERIES_ID
                    .captures(&path)
                    .unwrap_or_else(||
                        panic!("Path {} matched RE MUTATION_API_CATHOLIC_POLITY_SERVICE_DEANERIES_ID in set but failed match against \"{}\"", path, paths::REGEX_MUTATION_API_CATHOLIC_POLITY_SERVICE_DEANERIES_ID.as_str())
                    );

                let param_id = match percent_encoding::percent_decode(path_params["id"].as_bytes()).decode_utf8() {
                    Ok(param_id) => match param_id.parse::<uuid::Uuid>() {
                        Ok(param_id) => param_id,
                        Err(e) => return Ok(Response::builder()
                                        .status(StatusCode::BAD_REQUEST)
                                        .body(Body::from(format!("Couldn't parse path parameter id: {}", e)))
                                        .expect("Unable to create Bad Request response for invalid path parameter")),
                    },
                    Err(_) => return Ok(Response::builder()
                                        .status(StatusCode::BAD_REQUEST)
                                        .body(Body::from(format!("Couldn't percent-decode path parameter as UTF-8: {}", &path_params["id"])))
                                        .expect("Unable to create Bad Request response for invalid percent decode"))
                };

                                let result = api_impl.delete_deanery(
                                            param_id,
                                        &context
                                    ).await;
                                let mut response = Response::new(Body::empty());
                                response.headers_mut().insert(
                                            HeaderName::from_static("x-span-id"),
                                            HeaderValue::from_str((&context as &dyn Has<XSpanIdString>).get().0.clone().to_string().as_str())
                                                .expect("Unable to create X-Span-ID header value"));

                                        match result {
                                            Ok(rsp) => match rsp {
                                                DeleteDeaneryResponse::SuccessfulOperation
                                                => {
                                                    *response.status_mut() = StatusCode::from_u16(204).expect("Unable to turn 204 into a StatusCode");
                                                },
                                                DeleteDeaneryResponse::InvalidIDSupplied
                                                => {
                                                    *response.status_mut() = StatusCode::from_u16(400).expect("Unable to turn 400 into a StatusCode");
                                                },
                                                DeleteDeaneryResponse::DeaneryNotFound
                                                => {
                                                    *response.status_mut() = StatusCode::from_u16(404).expect("Unable to turn 404 into a StatusCode");
                                                },
                                            },
                                            Err(_) => {
                                                // Application code returned an error. This should not happen, as the implementation should
                                                // return a valid response.
                                                *response.status_mut() = StatusCode::INTERNAL_SERVER_ERROR;
                                                *response.body_mut() = Body::from("An internal error occurred");
                                            },
                                        }

                                        Ok(response)
            },

            // GetDeaneries - GET /query-api/catholic-polity-service/deaneries
            &hyper::Method::GET if path.matched(paths::ID_QUERY_API_CATHOLIC_POLITY_SERVICE_DEANERIES) => {
                {
                    let authorization = match (&context as &dyn Has<Option<Authorization>>).get() {
                        &Some(ref authorization) => authorization,
                        &None => return Ok(Response::builder()
                                                .status(StatusCode::FORBIDDEN)
                                                .body(Body::from("Unauthenticated"))
                                                .expect("Unable to create Authentication Forbidden response")),
                    };
                }

                // Query parameters (note that non-required or collection query parameters will ignore garbage values, rather than causing a 400 response)
                let query_params = form_urlencoded::parse(uri.query().unwrap_or_default().as_bytes()).collect::<Vec<_>>();
                let param_diocese_id = query_params.iter().filter(|e| e.0 == "dioceseId").map(|e| e.1.to_owned())
                    .nth(0);
                let param_diocese_id = match param_diocese_id {
                    Some(param_diocese_id) => {
                        let param_diocese_id =
                            <uuid::Uuid as std::str::FromStr>::from_str
                                (&param_diocese_id);
                        match param_diocese_id {
                            Ok(param_diocese_id) => Some(param_diocese_id),
                            Err(e) => return Ok(Response::builder()
                                .status(StatusCode::BAD_REQUEST)
                                .body(Body::from(format!("Couldn't parse query parameter dioceseId - doesn't match schema: {}", e)))
                                .expect("Unable to create Bad Request response for invalid query parameter dioceseId")),
                        }
                    },
                    None => None,
                };
                let param_name = query_params.iter().filter(|e| e.0 == "name").map(|e| e.1.to_owned())
                    .nth(0);
                let param_name = match param_name {
                    Some(param_name) => {
                        let param_name =
                            <String as std::str::FromStr>::from_str
                                (&param_name);
                        match param_name {
                            Ok(param_name) => Some(param_name),
                            Err(e) => return Ok(Response::builder()
                                .status(StatusCode::BAD_REQUEST)
                                .body(Body::from(format!("Couldn't parse query parameter name - doesn't match schema: {}", e)))
                                .expect("Unable to create Bad Request response for invalid query parameter name")),
                        }
                    },
                    None => None,
                };
                let param_offset = query_params.iter().filter(|e| e.0 == "offset").map(|e| e.1.to_owned())
                    .nth(0);
                let param_offset = match param_offset {
                    Some(param_offset) => {
                        let param_offset =
                            <i32 as std::str::FromStr>::from_str
                                (&param_offset);
                        match param_offset {
                            Ok(param_offset) => Some(param_offset),
                            Err(e) => return Ok(Response::builder()
                                .status(StatusCode::BAD_REQUEST)
                                .body(Body::from(format!("Couldn't parse query parameter offset - doesn't match schema: {}", e)))
                                .expect("Unable to create Bad Request response for invalid query parameter offset")),
                        }
                    },
                    None => None,
                };
                let param_count = query_params.iter().filter(|e| e.0 == "count").map(|e| e.1.to_owned())
                    .nth(0);
                let param_count = match param_count {
                    Some(param_count) => {
                        let param_count =
                            <i32 as std::str::FromStr>::from_str
                                (&param_count);
                        match param_count {
                            Ok(param_count) => Some(param_count),
                            Err(e) => return Ok(Response::builder()
                                .status(StatusCode::BAD_REQUEST)
                                .body(Body::from(format!("Couldn't parse query parameter count - doesn't match schema: {}", e)))
                                .expect("Unable to create Bad Request response for invalid query parameter count")),
                        }
                    },
                    None => None,
                };

                                let result = api_impl.get_deaneries(
                                            param_diocese_id,
                                            param_name,
                                            param_offset,
                                            param_count,
                                        &context
                                    ).await;
                                let mut response = Response::new(Body::empty());
                                response.headers_mut().insert(
                                            HeaderName::from_static("x-span-id"),
                                            HeaderValue::from_str((&context as &dyn Has<XSpanIdString>).get().0.clone().to_string().as_str())
                                                .expect("Unable to create X-Span-ID header value"));

                                        match result {
                                            Ok(rsp) => match rsp {
                                                GetDeaneriesResponse::SuccessfulOperation
                                                    (body)
                                                => {
                                                    *response.status_mut() = StatusCode::from_u16(200).expect("Unable to turn 200 into a StatusCode");
                                                    response.headers_mut().insert(
                                                        CONTENT_TYPE,
                                                        HeaderValue::from_str("application/json")
                                                            .expect("Unable to create Content-Type header for GET_DEANERIES_SUCCESSFUL_OPERATION"));
                                                    let body = serde_json::to_string(&body).expect("impossible to fail to serialize");
                                                    *response.body_mut() = Body::from(body);
                                                },
                                                GetDeaneriesResponse::InvalidIDSupplied
                                                => {
                                                    *response.status_mut() = StatusCode::from_u16(400).expect("Unable to turn 400 into a StatusCode");
                                                },
                                                GetDeaneriesResponse::DeaneryNotFound
                                                => {
                                                    *response.status_mut() = StatusCode::from_u16(404).expect("Unable to turn 404 into a StatusCode");
                                                },
                                            },
                                            Err(_) => {
                                                // Application code returned an error. This should not happen, as the implementation should
                                                // return a valid response.
                                                *response.status_mut() = StatusCode::INTERNAL_SERVER_ERROR;
                                                *response.body_mut() = Body::from("An internal error occurred");
                                            },
                                        }

                                        Ok(response)
            },

            // GetDeaneryById - GET /query-api/catholic-polity-service/deaneries/{id}
            &hyper::Method::GET if path.matched(paths::ID_QUERY_API_CATHOLIC_POLITY_SERVICE_DEANERIES_ID) => {
                {
                    let authorization = match (&context as &dyn Has<Option<Authorization>>).get() {
                        &Some(ref authorization) => authorization,
                        &None => return Ok(Response::builder()
                                                .status(StatusCode::FORBIDDEN)
                                                .body(Body::from("Unauthenticated"))
                                                .expect("Unable to create Authentication Forbidden response")),
                    };
                }

                // Path parameters
                let path: &str = &uri.path().to_string();
                let path_params =
                    paths::REGEX_QUERY_API_CATHOLIC_POLITY_SERVICE_DEANERIES_ID
                    .captures(&path)
                    .unwrap_or_else(||
                        panic!("Path {} matched RE QUERY_API_CATHOLIC_POLITY_SERVICE_DEANERIES_ID in set but failed match against \"{}\"", path, paths::REGEX_QUERY_API_CATHOLIC_POLITY_SERVICE_DEANERIES_ID.as_str())
                    );

                let param_id = match percent_encoding::percent_decode(path_params["id"].as_bytes()).decode_utf8() {
                    Ok(param_id) => match param_id.parse::<uuid::Uuid>() {
                        Ok(param_id) => param_id,
                        Err(e) => return Ok(Response::builder()
                                        .status(StatusCode::BAD_REQUEST)
                                        .body(Body::from(format!("Couldn't parse path parameter id: {}", e)))
                                        .expect("Unable to create Bad Request response for invalid path parameter")),
                    },
                    Err(_) => return Ok(Response::builder()
                                        .status(StatusCode::BAD_REQUEST)
                                        .body(Body::from(format!("Couldn't percent-decode path parameter as UTF-8: {}", &path_params["id"])))
                                        .expect("Unable to create Bad Request response for invalid percent decode"))
                };

                                let result = api_impl.get_deanery_by_id(
                                            param_id,
                                        &context
                                    ).await;
                                let mut response = Response::new(Body::empty());
                                response.headers_mut().insert(
                                            HeaderName::from_static("x-span-id"),
                                            HeaderValue::from_str((&context as &dyn Has<XSpanIdString>).get().0.clone().to_string().as_str())
                                                .expect("Unable to create X-Span-ID header value"));

                                        match result {
                                            Ok(rsp) => match rsp {
                                                GetDeaneryByIdResponse::SuccessfulOperation
                                                    (body)
                                                => {
                                                    *response.status_mut() = StatusCode::from_u16(200).expect("Unable to turn 200 into a StatusCode");
                                                    response.headers_mut().insert(
                                                        CONTENT_TYPE,
                                                        HeaderValue::from_str("application/json")
                                                            .expect("Unable to create Content-Type header for GET_DEANERY_BY_ID_SUCCESSFUL_OPERATION"));
                                                    let body = serde_json::to_string(&body).expect("impossible to fail to serialize");
                                                    *response.body_mut() = Body::from(body);
                                                },
                                                GetDeaneryByIdResponse::InvalidIDSupplied
                                                => {
                                                    *response.status_mut() = StatusCode::from_u16(400).expect("Unable to turn 400 into a StatusCode");
                                                },
                                                GetDeaneryByIdResponse::DeaneryNotFound
                                                => {
                                                    *response.status_mut() = StatusCode::from_u16(404).expect("Unable to turn 404 into a StatusCode");
                                                },
                                            },
                                            Err(_) => {
                                                // Application code returned an error. This should not happen, as the implementation should
                                                // return a valid response.
                                                *response.status_mut() = StatusCode::INTERNAL_SERVER_ERROR;
                                                *response.body_mut() = Body::from("An internal error occurred");
                                            },
                                        }

                                        Ok(response)
            },

            // UpdateDeanery - PUT /mutation-api/catholic-polity-service/deaneries/{id}
            &hyper::Method::PUT if path.matched(paths::ID_MUTATION_API_CATHOLIC_POLITY_SERVICE_DEANERIES_ID) => {
                {
                    let authorization = match (&context as &dyn Has<Option<Authorization>>).get() {
                        &Some(ref authorization) => authorization,
                        &None => return Ok(Response::builder()
                                                .status(StatusCode::FORBIDDEN)
                                                .body(Body::from("Unauthenticated"))
                                                .expect("Unable to create Authentication Forbidden response")),
                    };
                }

                // Path parameters
                let path: &str = &uri.path().to_string();
                let path_params =
                    paths::REGEX_MUTATION_API_CATHOLIC_POLITY_SERVICE_DEANERIES_ID
                    .captures(&path)
                    .unwrap_or_else(||
                        panic!("Path {} matched RE MUTATION_API_CATHOLIC_POLITY_SERVICE_DEANERIES_ID in set but failed match against \"{}\"", path, paths::REGEX_MUTATION_API_CATHOLIC_POLITY_SERVICE_DEANERIES_ID.as_str())
                    );

                let param_id = match percent_encoding::percent_decode(path_params["id"].as_bytes()).decode_utf8() {
                    Ok(param_id) => match param_id.parse::<uuid::Uuid>() {
                        Ok(param_id) => param_id,
                        Err(e) => return Ok(Response::builder()
                                        .status(StatusCode::BAD_REQUEST)
                                        .body(Body::from(format!("Couldn't parse path parameter id: {}", e)))
                                        .expect("Unable to create Bad Request response for invalid path parameter")),
                    },
                    Err(_) => return Ok(Response::builder()
                                        .status(StatusCode::BAD_REQUEST)
                                        .body(Body::from(format!("Couldn't percent-decode path parameter as UTF-8: {}", &path_params["id"])))
                                        .expect("Unable to create Bad Request response for invalid percent decode"))
                };

                // Body parameters (note that non-required body parameters will ignore garbage
                // values, rather than causing a 400 response). Produce warning header and logs for
                // any unused fields.
                let result = body.to_raw().await;
                match result {
                            Ok(body) => {
                                let mut unused_elements = Vec::new();
                                let param_deanery_mutation: Option<models::DeaneryMutation> = if !body.is_empty() {
                                    let deserializer = &mut serde_json::Deserializer::from_slice(&*body);
                                    match serde_ignored::deserialize(deserializer, |path| {
                                            warn!("Ignoring unknown field in body: {}", path);
                                            unused_elements.push(path.to_string());
                                    }) {
                                        Ok(param_deanery_mutation) => param_deanery_mutation,
                                        Err(e) => return Ok(Response::builder()
                                                        .status(StatusCode::BAD_REQUEST)
                                                        .body(Body::from(format!("Couldn't parse body parameter DeaneryMutation - doesn't match schema: {}", e)))
                                                        .expect("Unable to create Bad Request response for invalid body parameter DeaneryMutation due to schema")),
                                    }
                                } else {
                                    None
                                };
                                let param_deanery_mutation = match param_deanery_mutation {
                                    Some(param_deanery_mutation) => param_deanery_mutation,
                                    None => return Ok(Response::builder()
                                                        .status(StatusCode::BAD_REQUEST)
                                                        .body(Body::from("Missing required body parameter DeaneryMutation"))
                                                        .expect("Unable to create Bad Request response for missing body parameter DeaneryMutation")),
                                };

                                let result = api_impl.update_deanery(
                                            param_id,
                                            param_deanery_mutation,
                                        &context
                                    ).await;
                                let mut response = Response::new(Body::empty());
                                response.headers_mut().insert(
                                            HeaderName::from_static("x-span-id"),
                                            HeaderValue::from_str((&context as &dyn Has<XSpanIdString>).get().0.clone().to_string().as_str())
                                                .expect("Unable to create X-Span-ID header value"));

                                        if !unused_elements.is_empty() {
                                            response.headers_mut().insert(
                                                HeaderName::from_static("warning"),
                                                HeaderValue::from_str(format!("Ignoring unknown fields in body: {:?}", unused_elements).as_str())
                                                    .expect("Unable to create Warning header value"));
                                        }

                                        match result {
                                            Ok(rsp) => match rsp {
                                                UpdateDeaneryResponse::SuccessfulOperation
                                                    (body)
                                                => {
                                                    *response.status_mut() = StatusCode::from_u16(200).expect("Unable to turn 200 into a StatusCode");
                                                    response.headers_mut().insert(
                                                        CONTENT_TYPE,
                                                        HeaderValue::from_str("application/json")
                                                            .expect("Unable to create Content-Type header for UPDATE_DEANERY_SUCCESSFUL_OPERATION"));
                                                    let body = serde_json::to_string(&body).expect("impossible to fail to serialize");
                                                    *response.body_mut() = Body::from(body);
                                                },
                                                UpdateDeaneryResponse::InvalidIDSupplied
                                                => {
                                                    *response.status_mut() = StatusCode::from_u16(400).expect("Unable to turn 400 into a StatusCode");
                                                },
                                                UpdateDeaneryResponse::DeaneryNotFound
                                                => {
                                                    *response.status_mut() = StatusCode::from_u16(404).expect("Unable to turn 404 into a StatusCode");
                                                },
                                                UpdateDeaneryResponse::ValidationException
                                                => {
                                                    *response.status_mut() = StatusCode::from_u16(405).expect("Unable to turn 405 into a StatusCode");
                                                },
                                            },
                                            Err(_) => {
                                                // Application code returned an error. This should not happen, as the implementation should
                                                // return a valid response.
                                                *response.status_mut() = StatusCode::INTERNAL_SERVER_ERROR;
                                                *response.body_mut() = Body::from("An internal error occurred");
                                            },
                                        }

                                        Ok(response)
                            },
                            Err(e) => Ok(Response::builder()
                                                .status(StatusCode::BAD_REQUEST)
                                                .body(Body::from(format!("Couldn't read body parameter DeaneryMutation: {}", e)))
                                                .expect("Unable to create Bad Request response due to unable to read body parameter DeaneryMutation")),
                        }
            },

            // AddDiocese - POST /mutation-api/catholic-polity-service/dioceses
            &hyper::Method::POST if path.matched(paths::ID_MUTATION_API_CATHOLIC_POLITY_SERVICE_DIOCESES) => {
                {
                    let authorization = match (&context as &dyn Has<Option<Authorization>>).get() {
                        &Some(ref authorization) => authorization,
                        &None => return Ok(Response::builder()
                                                .status(StatusCode::FORBIDDEN)
                                                .body(Body::from("Unauthenticated"))
                                                .expect("Unable to create Authentication Forbidden response")),
                    };
                }

                // Body parameters (note that non-required body parameters will ignore garbage
                // values, rather than causing a 400 response). Produce warning header and logs for
                // any unused fields.
                let result = body.to_raw().await;
                match result {
                            Ok(body) => {
                                let mut unused_elements = Vec::new();
                                let param_diocese_mutation: Option<models::DioceseMutation> = if !body.is_empty() {
                                    let deserializer = &mut serde_json::Deserializer::from_slice(&*body);
                                    match serde_ignored::deserialize(deserializer, |path| {
                                            warn!("Ignoring unknown field in body: {}", path);
                                            unused_elements.push(path.to_string());
                                    }) {
                                        Ok(param_diocese_mutation) => param_diocese_mutation,
                                        Err(e) => return Ok(Response::builder()
                                                        .status(StatusCode::BAD_REQUEST)
                                                        .body(Body::from(format!("Couldn't parse body parameter DioceseMutation - doesn't match schema: {}", e)))
                                                        .expect("Unable to create Bad Request response for invalid body parameter DioceseMutation due to schema")),
                                    }
                                } else {
                                    None
                                };
                                let param_diocese_mutation = match param_diocese_mutation {
                                    Some(param_diocese_mutation) => param_diocese_mutation,
                                    None => return Ok(Response::builder()
                                                        .status(StatusCode::BAD_REQUEST)
                                                        .body(Body::from("Missing required body parameter DioceseMutation"))
                                                        .expect("Unable to create Bad Request response for missing body parameter DioceseMutation")),
                                };

                                let result = api_impl.add_diocese(
                                            param_diocese_mutation,
                                        &context
                                    ).await;
                                let mut response = Response::new(Body::empty());
                                response.headers_mut().insert(
                                            HeaderName::from_static("x-span-id"),
                                            HeaderValue::from_str((&context as &dyn Has<XSpanIdString>).get().0.clone().to_string().as_str())
                                                .expect("Unable to create X-Span-ID header value"));

                                        if !unused_elements.is_empty() {
                                            response.headers_mut().insert(
                                                HeaderName::from_static("warning"),
                                                HeaderValue::from_str(format!("Ignoring unknown fields in body: {:?}", unused_elements).as_str())
                                                    .expect("Unable to create Warning header value"));
                                        }

                                        match result {
                                            Ok(rsp) => match rsp {
                                                AddDioceseResponse::SuccessfulOperation
                                                    (body)
                                                => {
                                                    *response.status_mut() = StatusCode::from_u16(200).expect("Unable to turn 200 into a StatusCode");
                                                    response.headers_mut().insert(
                                                        CONTENT_TYPE,
                                                        HeaderValue::from_str("application/json")
                                                            .expect("Unable to create Content-Type header for ADD_DIOCESE_SUCCESSFUL_OPERATION"));
                                                    let body = serde_json::to_string(&body).expect("impossible to fail to serialize");
                                                    *response.body_mut() = Body::from(body);
                                                },
                                                AddDioceseResponse::InvalidInput
                                                => {
                                                    *response.status_mut() = StatusCode::from_u16(405).expect("Unable to turn 405 into a StatusCode");
                                                },
                                            },
                                            Err(_) => {
                                                // Application code returned an error. This should not happen, as the implementation should
                                                // return a valid response.
                                                *response.status_mut() = StatusCode::INTERNAL_SERVER_ERROR;
                                                *response.body_mut() = Body::from("An internal error occurred");
                                            },
                                        }

                                        Ok(response)
                            },
                            Err(e) => Ok(Response::builder()
                                                .status(StatusCode::BAD_REQUEST)
                                                .body(Body::from(format!("Couldn't read body parameter DioceseMutation: {}", e)))
                                                .expect("Unable to create Bad Request response due to unable to read body parameter DioceseMutation")),
                        }
            },

            // DeleteDiocese - DELETE /mutation-api/catholic-polity-service/dioceses/{id}
            &hyper::Method::DELETE if path.matched(paths::ID_MUTATION_API_CATHOLIC_POLITY_SERVICE_DIOCESES_ID) => {
                {
                    let authorization = match (&context as &dyn Has<Option<Authorization>>).get() {
                        &Some(ref authorization) => authorization,
                        &None => return Ok(Response::builder()
                                                .status(StatusCode::FORBIDDEN)
                                                .body(Body::from("Unauthenticated"))
                                                .expect("Unable to create Authentication Forbidden response")),
                    };
                }

                // Path parameters
                let path: &str = &uri.path().to_string();
                let path_params =
                    paths::REGEX_MUTATION_API_CATHOLIC_POLITY_SERVICE_DIOCESES_ID
                    .captures(&path)
                    .unwrap_or_else(||
                        panic!("Path {} matched RE MUTATION_API_CATHOLIC_POLITY_SERVICE_DIOCESES_ID in set but failed match against \"{}\"", path, paths::REGEX_MUTATION_API_CATHOLIC_POLITY_SERVICE_DIOCESES_ID.as_str())
                    );

                let param_id = match percent_encoding::percent_decode(path_params["id"].as_bytes()).decode_utf8() {
                    Ok(param_id) => match param_id.parse::<uuid::Uuid>() {
                        Ok(param_id) => param_id,
                        Err(e) => return Ok(Response::builder()
                                        .status(StatusCode::BAD_REQUEST)
                                        .body(Body::from(format!("Couldn't parse path parameter id: {}", e)))
                                        .expect("Unable to create Bad Request response for invalid path parameter")),
                    },
                    Err(_) => return Ok(Response::builder()
                                        .status(StatusCode::BAD_REQUEST)
                                        .body(Body::from(format!("Couldn't percent-decode path parameter as UTF-8: {}", &path_params["id"])))
                                        .expect("Unable to create Bad Request response for invalid percent decode"))
                };

                                let result = api_impl.delete_diocese(
                                            param_id,
                                        &context
                                    ).await;
                                let mut response = Response::new(Body::empty());
                                response.headers_mut().insert(
                                            HeaderName::from_static("x-span-id"),
                                            HeaderValue::from_str((&context as &dyn Has<XSpanIdString>).get().0.clone().to_string().as_str())
                                                .expect("Unable to create X-Span-ID header value"));

                                        match result {
                                            Ok(rsp) => match rsp {
                                                DeleteDioceseResponse::SuccessfulOperation
                                                => {
                                                    *response.status_mut() = StatusCode::from_u16(204).expect("Unable to turn 204 into a StatusCode");
                                                },
                                                DeleteDioceseResponse::InvalidIDSupplied
                                                => {
                                                    *response.status_mut() = StatusCode::from_u16(400).expect("Unable to turn 400 into a StatusCode");
                                                },
                                                DeleteDioceseResponse::DioceseNotFound
                                                => {
                                                    *response.status_mut() = StatusCode::from_u16(404).expect("Unable to turn 404 into a StatusCode");
                                                },
                                            },
                                            Err(_) => {
                                                // Application code returned an error. This should not happen, as the implementation should
                                                // return a valid response.
                                                *response.status_mut() = StatusCode::INTERNAL_SERVER_ERROR;
                                                *response.body_mut() = Body::from("An internal error occurred");
                                            },
                                        }

                                        Ok(response)
            },

            // GetDioceseById - GET /query-api/catholic-polity-service/dioceses/{id}
            &hyper::Method::GET if path.matched(paths::ID_QUERY_API_CATHOLIC_POLITY_SERVICE_DIOCESES_ID) => {
                {
                    let authorization = match (&context as &dyn Has<Option<Authorization>>).get() {
                        &Some(ref authorization) => authorization,
                        &None => return Ok(Response::builder()
                                                .status(StatusCode::FORBIDDEN)
                                                .body(Body::from("Unauthenticated"))
                                                .expect("Unable to create Authentication Forbidden response")),
                    };
                }

                // Path parameters
                let path: &str = &uri.path().to_string();
                let path_params =
                    paths::REGEX_QUERY_API_CATHOLIC_POLITY_SERVICE_DIOCESES_ID
                    .captures(&path)
                    .unwrap_or_else(||
                        panic!("Path {} matched RE QUERY_API_CATHOLIC_POLITY_SERVICE_DIOCESES_ID in set but failed match against \"{}\"", path, paths::REGEX_QUERY_API_CATHOLIC_POLITY_SERVICE_DIOCESES_ID.as_str())
                    );

                let param_id = match percent_encoding::percent_decode(path_params["id"].as_bytes()).decode_utf8() {
                    Ok(param_id) => match param_id.parse::<uuid::Uuid>() {
                        Ok(param_id) => param_id,
                        Err(e) => return Ok(Response::builder()
                                        .status(StatusCode::BAD_REQUEST)
                                        .body(Body::from(format!("Couldn't parse path parameter id: {}", e)))
                                        .expect("Unable to create Bad Request response for invalid path parameter")),
                    },
                    Err(_) => return Ok(Response::builder()
                                        .status(StatusCode::BAD_REQUEST)
                                        .body(Body::from(format!("Couldn't percent-decode path parameter as UTF-8: {}", &path_params["id"])))
                                        .expect("Unable to create Bad Request response for invalid percent decode"))
                };

                                let result = api_impl.get_diocese_by_id(
                                            param_id,
                                        &context
                                    ).await;
                                let mut response = Response::new(Body::empty());
                                response.headers_mut().insert(
                                            HeaderName::from_static("x-span-id"),
                                            HeaderValue::from_str((&context as &dyn Has<XSpanIdString>).get().0.clone().to_string().as_str())
                                                .expect("Unable to create X-Span-ID header value"));

                                        match result {
                                            Ok(rsp) => match rsp {
                                                GetDioceseByIdResponse::SuccessfulOperation
                                                    (body)
                                                => {
                                                    *response.status_mut() = StatusCode::from_u16(200).expect("Unable to turn 200 into a StatusCode");
                                                    response.headers_mut().insert(
                                                        CONTENT_TYPE,
                                                        HeaderValue::from_str("application/json")
                                                            .expect("Unable to create Content-Type header for GET_DIOCESE_BY_ID_SUCCESSFUL_OPERATION"));
                                                    let body = serde_json::to_string(&body).expect("impossible to fail to serialize");
                                                    *response.body_mut() = Body::from(body);
                                                },
                                                GetDioceseByIdResponse::InvalidIDSupplied
                                                => {
                                                    *response.status_mut() = StatusCode::from_u16(400).expect("Unable to turn 400 into a StatusCode");
                                                },
                                                GetDioceseByIdResponse::DioceseNotFound
                                                => {
                                                    *response.status_mut() = StatusCode::from_u16(404).expect("Unable to turn 404 into a StatusCode");
                                                },
                                            },
                                            Err(_) => {
                                                // Application code returned an error. This should not happen, as the implementation should
                                                // return a valid response.
                                                *response.status_mut() = StatusCode::INTERNAL_SERVER_ERROR;
                                                *response.body_mut() = Body::from("An internal error occurred");
                                            },
                                        }

                                        Ok(response)
            },

            // GetDioceses - GET /query-api/catholic-polity-service/dioceses
            &hyper::Method::GET if path.matched(paths::ID_QUERY_API_CATHOLIC_POLITY_SERVICE_DIOCESES) => {
                {
                    let authorization = match (&context as &dyn Has<Option<Authorization>>).get() {
                        &Some(ref authorization) => authorization,
                        &None => return Ok(Response::builder()
                                                .status(StatusCode::FORBIDDEN)
                                                .body(Body::from("Unauthenticated"))
                                                .expect("Unable to create Authentication Forbidden response")),
                    };
                }

                // Query parameters (note that non-required or collection query parameters will ignore garbage values, rather than causing a 400 response)
                let query_params = form_urlencoded::parse(uri.query().unwrap_or_default().as_bytes()).collect::<Vec<_>>();
                let param_province_id = query_params.iter().filter(|e| e.0 == "provinceId").map(|e| e.1.to_owned())
                    .nth(0);
                let param_province_id = match param_province_id {
                    Some(param_province_id) => {
                        let param_province_id =
                            <uuid::Uuid as std::str::FromStr>::from_str
                                (&param_province_id);
                        match param_province_id {
                            Ok(param_province_id) => Some(param_province_id),
                            Err(e) => return Ok(Response::builder()
                                .status(StatusCode::BAD_REQUEST)
                                .body(Body::from(format!("Couldn't parse query parameter provinceId - doesn't match schema: {}", e)))
                                .expect("Unable to create Bad Request response for invalid query parameter provinceId")),
                        }
                    },
                    None => None,
                };
                let param_province_code = query_params.iter().filter(|e| e.0 == "provinceCode").map(|e| e.1.to_owned())
                    .nth(0);
                let param_province_code = match param_province_code {
                    Some(param_province_code) => {
                        let param_province_code =
                            <models::Code as std::str::FromStr>::from_str
                                (&param_province_code);
                        match param_province_code {
                            Ok(param_province_code) => Some(param_province_code),
                            Err(e) => return Ok(Response::builder()
                                .status(StatusCode::BAD_REQUEST)
                                .body(Body::from(format!("Couldn't parse query parameter provinceCode - doesn't match schema: {}", e)))
                                .expect("Unable to create Bad Request response for invalid query parameter provinceCode")),
                        }
                    },
                    None => None,
                };
                let param_province_name = query_params.iter().filter(|e| e.0 == "provinceName").map(|e| e.1.to_owned())
                    .nth(0);
                let param_province_name = match param_province_name {
                    Some(param_province_name) => {
                        let param_province_name =
                            <String as std::str::FromStr>::from_str
                                (&param_province_name);
                        match param_province_name {
                            Ok(param_province_name) => Some(param_province_name),
                            Err(e) => return Ok(Response::builder()
                                .status(StatusCode::BAD_REQUEST)
                                .body(Body::from(format!("Couldn't parse query parameter provinceName - doesn't match schema: {}", e)))
                                .expect("Unable to create Bad Request response for invalid query parameter provinceName")),
                        }
                    },
                    None => None,
                };
                let param_name = query_params.iter().filter(|e| e.0 == "name").map(|e| e.1.to_owned())
                    .nth(0);
                let param_name = match param_name {
                    Some(param_name) => {
                        let param_name =
                            <String as std::str::FromStr>::from_str
                                (&param_name);
                        match param_name {
                            Ok(param_name) => Some(param_name),
                            Err(e) => return Ok(Response::builder()
                                .status(StatusCode::BAD_REQUEST)
                                .body(Body::from(format!("Couldn't parse query parameter name - doesn't match schema: {}", e)))
                                .expect("Unable to create Bad Request response for invalid query parameter name")),
                        }
                    },
                    None => None,
                };
                let param_location_name = query_params.iter().filter(|e| e.0 == "locationName").map(|e| e.1.to_owned())
                    .nth(0);
                let param_location_name = match param_location_name {
                    Some(param_location_name) => {
                        let param_location_name =
                            <String as std::str::FromStr>::from_str
                                (&param_location_name);
                        match param_location_name {
                            Ok(param_location_name) => Some(param_location_name),
                            Err(e) => return Ok(Response::builder()
                                .status(StatusCode::BAD_REQUEST)
                                .body(Body::from(format!("Couldn't parse query parameter locationName - doesn't match schema: {}", e)))
                                .expect("Unable to create Bad Request response for invalid query parameter locationName")),
                        }
                    },
                    None => None,
                };
                let param_location_address = query_params.iter().filter(|e| e.0 == "locationAddress").map(|e| e.1.to_owned())
                    .nth(0);
                let param_location_address = match param_location_address {
                    Some(param_location_address) => {
                        let param_location_address =
                            <String as std::str::FromStr>::from_str
                                (&param_location_address);
                        match param_location_address {
                            Ok(param_location_address) => Some(param_location_address),
                            Err(e) => return Ok(Response::builder()
                                .status(StatusCode::BAD_REQUEST)
                                .body(Body::from(format!("Couldn't parse query parameter locationAddress - doesn't match schema: {}", e)))
                                .expect("Unable to create Bad Request response for invalid query parameter locationAddress")),
                        }
                    },
                    None => None,
                };
                let param_location_email = query_params.iter().filter(|e| e.0 == "locationEmail").map(|e| e.1.to_owned())
                    .nth(0);
                let param_location_email = match param_location_email {
                    Some(param_location_email) => {
                        let param_location_email =
                            <String as std::str::FromStr>::from_str
                                (&param_location_email);
                        match param_location_email {
                            Ok(param_location_email) => Some(param_location_email),
                            Err(e) => return Ok(Response::builder()
                                .status(StatusCode::BAD_REQUEST)
                                .body(Body::from(format!("Couldn't parse query parameter locationEmail - doesn't match schema: {}", e)))
                                .expect("Unable to create Bad Request response for invalid query parameter locationEmail")),
                        }
                    },
                    None => None,
                };
                let param_person_in_charge = query_params.iter().filter(|e| e.0 == "personInCharge").map(|e| e.1.to_owned())
                    .nth(0);
                let param_person_in_charge = match param_person_in_charge {
                    Some(param_person_in_charge) => {
                        let param_person_in_charge =
                            <String as std::str::FromStr>::from_str
                                (&param_person_in_charge);
                        match param_person_in_charge {
                            Ok(param_person_in_charge) => Some(param_person_in_charge),
                            Err(e) => return Ok(Response::builder()
                                .status(StatusCode::BAD_REQUEST)
                                .body(Body::from(format!("Couldn't parse query parameter personInCharge - doesn't match schema: {}", e)))
                                .expect("Unable to create Bad Request response for invalid query parameter personInCharge")),
                        }
                    },
                    None => None,
                };
                let param_sorts = query_params.iter().filter(|e| e.0 == "sorts").map(|e| e.1.to_owned())
                    .filter_map(|param_sorts| param_sorts.parse().ok())
                    .collect::<Vec<_>>();
                let param_sorts = if !param_sorts.is_empty() {
                    Some(param_sorts)
                } else {
                    None
                };
                let param_offset = query_params.iter().filter(|e| e.0 == "offset").map(|e| e.1.to_owned())
                    .nth(0);
                let param_offset = match param_offset {
                    Some(param_offset) => {
                        let param_offset =
                            <i32 as std::str::FromStr>::from_str
                                (&param_offset);
                        match param_offset {
                            Ok(param_offset) => Some(param_offset),
                            Err(e) => return Ok(Response::builder()
                                .status(StatusCode::BAD_REQUEST)
                                .body(Body::from(format!("Couldn't parse query parameter offset - doesn't match schema: {}", e)))
                                .expect("Unable to create Bad Request response for invalid query parameter offset")),
                        }
                    },
                    None => None,
                };
                let param_count = query_params.iter().filter(|e| e.0 == "count").map(|e| e.1.to_owned())
                    .nth(0);
                let param_count = match param_count {
                    Some(param_count) => {
                        let param_count =
                            <i32 as std::str::FromStr>::from_str
                                (&param_count);
                        match param_count {
                            Ok(param_count) => Some(param_count),
                            Err(e) => return Ok(Response::builder()
                                .status(StatusCode::BAD_REQUEST)
                                .body(Body::from(format!("Couldn't parse query parameter count - doesn't match schema: {}", e)))
                                .expect("Unable to create Bad Request response for invalid query parameter count")),
                        }
                    },
                    None => None,
                };

                                let result = api_impl.get_dioceses(
                                            param_province_id,
                                            param_province_code,
                                            param_province_name,
                                            param_name,
                                            param_location_name,
                                            param_location_address,
                                            param_location_email,
                                            param_person_in_charge,
                                            param_sorts.as_ref(),
                                            param_offset,
                                            param_count,
                                        &context
                                    ).await;
                                let mut response = Response::new(Body::empty());
                                response.headers_mut().insert(
                                            HeaderName::from_static("x-span-id"),
                                            HeaderValue::from_str((&context as &dyn Has<XSpanIdString>).get().0.clone().to_string().as_str())
                                                .expect("Unable to create X-Span-ID header value"));

                                        match result {
                                            Ok(rsp) => match rsp {
                                                GetDiocesesResponse::SuccessfulOperation
                                                    (body)
                                                => {
                                                    *response.status_mut() = StatusCode::from_u16(200).expect("Unable to turn 200 into a StatusCode");
                                                    response.headers_mut().insert(
                                                        CONTENT_TYPE,
                                                        HeaderValue::from_str("application/json")
                                                            .expect("Unable to create Content-Type header for GET_DIOCESES_SUCCESSFUL_OPERATION"));
                                                    let body = serde_json::to_string(&body).expect("impossible to fail to serialize");
                                                    *response.body_mut() = Body::from(body);
                                                },
                                                GetDiocesesResponse::InvalidIDSupplied
                                                => {
                                                    *response.status_mut() = StatusCode::from_u16(400).expect("Unable to turn 400 into a StatusCode");
                                                },
                                                GetDiocesesResponse::DioceseNotFound
                                                => {
                                                    *response.status_mut() = StatusCode::from_u16(404).expect("Unable to turn 404 into a StatusCode");
                                                },
                                            },
                                            Err(_) => {
                                                // Application code returned an error. This should not happen, as the implementation should
                                                // return a valid response.
                                                *response.status_mut() = StatusCode::INTERNAL_SERVER_ERROR;
                                                *response.body_mut() = Body::from("An internal error occurred");
                                            },
                                        }

                                        Ok(response)
            },

            // UpdateDiocese - PUT /mutation-api/catholic-polity-service/dioceses/{id}
            &hyper::Method::PUT if path.matched(paths::ID_MUTATION_API_CATHOLIC_POLITY_SERVICE_DIOCESES_ID) => {
                {
                    let authorization = match (&context as &dyn Has<Option<Authorization>>).get() {
                        &Some(ref authorization) => authorization,
                        &None => return Ok(Response::builder()
                                                .status(StatusCode::FORBIDDEN)
                                                .body(Body::from("Unauthenticated"))
                                                .expect("Unable to create Authentication Forbidden response")),
                    };
                }

                // Path parameters
                let path: &str = &uri.path().to_string();
                let path_params =
                    paths::REGEX_MUTATION_API_CATHOLIC_POLITY_SERVICE_DIOCESES_ID
                    .captures(&path)
                    .unwrap_or_else(||
                        panic!("Path {} matched RE MUTATION_API_CATHOLIC_POLITY_SERVICE_DIOCESES_ID in set but failed match against \"{}\"", path, paths::REGEX_MUTATION_API_CATHOLIC_POLITY_SERVICE_DIOCESES_ID.as_str())
                    );

                let param_id = match percent_encoding::percent_decode(path_params["id"].as_bytes()).decode_utf8() {
                    Ok(param_id) => match param_id.parse::<uuid::Uuid>() {
                        Ok(param_id) => param_id,
                        Err(e) => return Ok(Response::builder()
                                        .status(StatusCode::BAD_REQUEST)
                                        .body(Body::from(format!("Couldn't parse path parameter id: {}", e)))
                                        .expect("Unable to create Bad Request response for invalid path parameter")),
                    },
                    Err(_) => return Ok(Response::builder()
                                        .status(StatusCode::BAD_REQUEST)
                                        .body(Body::from(format!("Couldn't percent-decode path parameter as UTF-8: {}", &path_params["id"])))
                                        .expect("Unable to create Bad Request response for invalid percent decode"))
                };

                // Body parameters (note that non-required body parameters will ignore garbage
                // values, rather than causing a 400 response). Produce warning header and logs for
                // any unused fields.
                let result = body.to_raw().await;
                match result {
                            Ok(body) => {
                                let mut unused_elements = Vec::new();
                                let param_diocese_mutation: Option<models::DioceseMutation> = if !body.is_empty() {
                                    let deserializer = &mut serde_json::Deserializer::from_slice(&*body);
                                    match serde_ignored::deserialize(deserializer, |path| {
                                            warn!("Ignoring unknown field in body: {}", path);
                                            unused_elements.push(path.to_string());
                                    }) {
                                        Ok(param_diocese_mutation) => param_diocese_mutation,
                                        Err(e) => return Ok(Response::builder()
                                                        .status(StatusCode::BAD_REQUEST)
                                                        .body(Body::from(format!("Couldn't parse body parameter DioceseMutation - doesn't match schema: {}", e)))
                                                        .expect("Unable to create Bad Request response for invalid body parameter DioceseMutation due to schema")),
                                    }
                                } else {
                                    None
                                };
                                let param_diocese_mutation = match param_diocese_mutation {
                                    Some(param_diocese_mutation) => param_diocese_mutation,
                                    None => return Ok(Response::builder()
                                                        .status(StatusCode::BAD_REQUEST)
                                                        .body(Body::from("Missing required body parameter DioceseMutation"))
                                                        .expect("Unable to create Bad Request response for missing body parameter DioceseMutation")),
                                };

                                let result = api_impl.update_diocese(
                                            param_id,
                                            param_diocese_mutation,
                                        &context
                                    ).await;
                                let mut response = Response::new(Body::empty());
                                response.headers_mut().insert(
                                            HeaderName::from_static("x-span-id"),
                                            HeaderValue::from_str((&context as &dyn Has<XSpanIdString>).get().0.clone().to_string().as_str())
                                                .expect("Unable to create X-Span-ID header value"));

                                        if !unused_elements.is_empty() {
                                            response.headers_mut().insert(
                                                HeaderName::from_static("warning"),
                                                HeaderValue::from_str(format!("Ignoring unknown fields in body: {:?}", unused_elements).as_str())
                                                    .expect("Unable to create Warning header value"));
                                        }

                                        match result {
                                            Ok(rsp) => match rsp {
                                                UpdateDioceseResponse::SuccessfulOperation
                                                    (body)
                                                => {
                                                    *response.status_mut() = StatusCode::from_u16(200).expect("Unable to turn 200 into a StatusCode");
                                                    response.headers_mut().insert(
                                                        CONTENT_TYPE,
                                                        HeaderValue::from_str("application/json")
                                                            .expect("Unable to create Content-Type header for UPDATE_DIOCESE_SUCCESSFUL_OPERATION"));
                                                    let body = serde_json::to_string(&body).expect("impossible to fail to serialize");
                                                    *response.body_mut() = Body::from(body);
                                                },
                                                UpdateDioceseResponse::InvalidIDSupplied
                                                => {
                                                    *response.status_mut() = StatusCode::from_u16(400).expect("Unable to turn 400 into a StatusCode");
                                                },
                                                UpdateDioceseResponse::DioceseNotFound
                                                => {
                                                    *response.status_mut() = StatusCode::from_u16(404).expect("Unable to turn 404 into a StatusCode");
                                                },
                                                UpdateDioceseResponse::ValidationException
                                                => {
                                                    *response.status_mut() = StatusCode::from_u16(405).expect("Unable to turn 405 into a StatusCode");
                                                },
                                            },
                                            Err(_) => {
                                                // Application code returned an error. This should not happen, as the implementation should
                                                // return a valid response.
                                                *response.status_mut() = StatusCode::INTERNAL_SERVER_ERROR;
                                                *response.body_mut() = Body::from("An internal error occurred");
                                            },
                                        }

                                        Ok(response)
                            },
                            Err(e) => Ok(Response::builder()
                                                .status(StatusCode::BAD_REQUEST)
                                                .body(Body::from(format!("Couldn't read body parameter DioceseMutation: {}", e)))
                                                .expect("Unable to create Bad Request response due to unable to read body parameter DioceseMutation")),
                        }
            },

            // AddInstitute - POST /mutation-api/catholic-polity-service/institutes
            &hyper::Method::POST if path.matched(paths::ID_MUTATION_API_CATHOLIC_POLITY_SERVICE_INSTITUTES) => {
                {
                    let authorization = match (&context as &dyn Has<Option<Authorization>>).get() {
                        &Some(ref authorization) => authorization,
                        &None => return Ok(Response::builder()
                                                .status(StatusCode::FORBIDDEN)
                                                .body(Body::from("Unauthenticated"))
                                                .expect("Unable to create Authentication Forbidden response")),
                    };
                }

                // Body parameters (note that non-required body parameters will ignore garbage
                // values, rather than causing a 400 response). Produce warning header and logs for
                // any unused fields.
                let result = body.to_raw().await;
                match result {
                            Ok(body) => {
                                let mut unused_elements = Vec::new();
                                let param_institute_mutation: Option<models::InstituteMutation> = if !body.is_empty() {
                                    let deserializer = &mut serde_json::Deserializer::from_slice(&*body);
                                    match serde_ignored::deserialize(deserializer, |path| {
                                            warn!("Ignoring unknown field in body: {}", path);
                                            unused_elements.push(path.to_string());
                                    }) {
                                        Ok(param_institute_mutation) => param_institute_mutation,
                                        Err(e) => return Ok(Response::builder()
                                                        .status(StatusCode::BAD_REQUEST)
                                                        .body(Body::from(format!("Couldn't parse body parameter InstituteMutation - doesn't match schema: {}", e)))
                                                        .expect("Unable to create Bad Request response for invalid body parameter InstituteMutation due to schema")),
                                    }
                                } else {
                                    None
                                };
                                let param_institute_mutation = match param_institute_mutation {
                                    Some(param_institute_mutation) => param_institute_mutation,
                                    None => return Ok(Response::builder()
                                                        .status(StatusCode::BAD_REQUEST)
                                                        .body(Body::from("Missing required body parameter InstituteMutation"))
                                                        .expect("Unable to create Bad Request response for missing body parameter InstituteMutation")),
                                };

                                let result = api_impl.add_institute(
                                            param_institute_mutation,
                                        &context
                                    ).await;
                                let mut response = Response::new(Body::empty());
                                response.headers_mut().insert(
                                            HeaderName::from_static("x-span-id"),
                                            HeaderValue::from_str((&context as &dyn Has<XSpanIdString>).get().0.clone().to_string().as_str())
                                                .expect("Unable to create X-Span-ID header value"));

                                        if !unused_elements.is_empty() {
                                            response.headers_mut().insert(
                                                HeaderName::from_static("warning"),
                                                HeaderValue::from_str(format!("Ignoring unknown fields in body: {:?}", unused_elements).as_str())
                                                    .expect("Unable to create Warning header value"));
                                        }

                                        match result {
                                            Ok(rsp) => match rsp {
                                                AddInstituteResponse::SuccessfulOperation
                                                    (body)
                                                => {
                                                    *response.status_mut() = StatusCode::from_u16(200).expect("Unable to turn 200 into a StatusCode");
                                                    response.headers_mut().insert(
                                                        CONTENT_TYPE,
                                                        HeaderValue::from_str("application/json")
                                                            .expect("Unable to create Content-Type header for ADD_INSTITUTE_SUCCESSFUL_OPERATION"));
                                                    let body = serde_json::to_string(&body).expect("impossible to fail to serialize");
                                                    *response.body_mut() = Body::from(body);
                                                },
                                                AddInstituteResponse::InvalidInput
                                                => {
                                                    *response.status_mut() = StatusCode::from_u16(405).expect("Unable to turn 405 into a StatusCode");
                                                },
                                            },
                                            Err(_) => {
                                                // Application code returned an error. This should not happen, as the implementation should
                                                // return a valid response.
                                                *response.status_mut() = StatusCode::INTERNAL_SERVER_ERROR;
                                                *response.body_mut() = Body::from("An internal error occurred");
                                            },
                                        }

                                        Ok(response)
                            },
                            Err(e) => Ok(Response::builder()
                                                .status(StatusCode::BAD_REQUEST)
                                                .body(Body::from(format!("Couldn't read body parameter InstituteMutation: {}", e)))
                                                .expect("Unable to create Bad Request response due to unable to read body parameter InstituteMutation")),
                        }
            },

            // DeleteInstitute - DELETE /mutation-api/catholic-polity-service/institutes/{id}
            &hyper::Method::DELETE if path.matched(paths::ID_MUTATION_API_CATHOLIC_POLITY_SERVICE_INSTITUTES_ID) => {
                {
                    let authorization = match (&context as &dyn Has<Option<Authorization>>).get() {
                        &Some(ref authorization) => authorization,
                        &None => return Ok(Response::builder()
                                                .status(StatusCode::FORBIDDEN)
                                                .body(Body::from("Unauthenticated"))
                                                .expect("Unable to create Authentication Forbidden response")),
                    };
                }

                // Path parameters
                let path: &str = &uri.path().to_string();
                let path_params =
                    paths::REGEX_MUTATION_API_CATHOLIC_POLITY_SERVICE_INSTITUTES_ID
                    .captures(&path)
                    .unwrap_or_else(||
                        panic!("Path {} matched RE MUTATION_API_CATHOLIC_POLITY_SERVICE_INSTITUTES_ID in set but failed match against \"{}\"", path, paths::REGEX_MUTATION_API_CATHOLIC_POLITY_SERVICE_INSTITUTES_ID.as_str())
                    );

                let param_id = match percent_encoding::percent_decode(path_params["id"].as_bytes()).decode_utf8() {
                    Ok(param_id) => match param_id.parse::<uuid::Uuid>() {
                        Ok(param_id) => param_id,
                        Err(e) => return Ok(Response::builder()
                                        .status(StatusCode::BAD_REQUEST)
                                        .body(Body::from(format!("Couldn't parse path parameter id: {}", e)))
                                        .expect("Unable to create Bad Request response for invalid path parameter")),
                    },
                    Err(_) => return Ok(Response::builder()
                                        .status(StatusCode::BAD_REQUEST)
                                        .body(Body::from(format!("Couldn't percent-decode path parameter as UTF-8: {}", &path_params["id"])))
                                        .expect("Unable to create Bad Request response for invalid percent decode"))
                };

                                let result = api_impl.delete_institute(
                                            param_id,
                                        &context
                                    ).await;
                                let mut response = Response::new(Body::empty());
                                response.headers_mut().insert(
                                            HeaderName::from_static("x-span-id"),
                                            HeaderValue::from_str((&context as &dyn Has<XSpanIdString>).get().0.clone().to_string().as_str())
                                                .expect("Unable to create X-Span-ID header value"));

                                        match result {
                                            Ok(rsp) => match rsp {
                                                DeleteInstituteResponse::SuccessfulOperation
                                                => {
                                                    *response.status_mut() = StatusCode::from_u16(204).expect("Unable to turn 204 into a StatusCode");
                                                },
                                                DeleteInstituteResponse::InvalidIDSupplied
                                                => {
                                                    *response.status_mut() = StatusCode::from_u16(400).expect("Unable to turn 400 into a StatusCode");
                                                },
                                                DeleteInstituteResponse::InstituteNotFound
                                                => {
                                                    *response.status_mut() = StatusCode::from_u16(404).expect("Unable to turn 404 into a StatusCode");
                                                },
                                            },
                                            Err(_) => {
                                                // Application code returned an error. This should not happen, as the implementation should
                                                // return a valid response.
                                                *response.status_mut() = StatusCode::INTERNAL_SERVER_ERROR;
                                                *response.body_mut() = Body::from("An internal error occurred");
                                            },
                                        }

                                        Ok(response)
            },

            // GetInstituteById - GET /query-api/catholic-polity-service/institutes/{id}
            &hyper::Method::GET if path.matched(paths::ID_QUERY_API_CATHOLIC_POLITY_SERVICE_INSTITUTES_ID) => {
                {
                    let authorization = match (&context as &dyn Has<Option<Authorization>>).get() {
                        &Some(ref authorization) => authorization,
                        &None => return Ok(Response::builder()
                                                .status(StatusCode::FORBIDDEN)
                                                .body(Body::from("Unauthenticated"))
                                                .expect("Unable to create Authentication Forbidden response")),
                    };
                }

                // Path parameters
                let path: &str = &uri.path().to_string();
                let path_params =
                    paths::REGEX_QUERY_API_CATHOLIC_POLITY_SERVICE_INSTITUTES_ID
                    .captures(&path)
                    .unwrap_or_else(||
                        panic!("Path {} matched RE QUERY_API_CATHOLIC_POLITY_SERVICE_INSTITUTES_ID in set but failed match against \"{}\"", path, paths::REGEX_QUERY_API_CATHOLIC_POLITY_SERVICE_INSTITUTES_ID.as_str())
                    );

                let param_id = match percent_encoding::percent_decode(path_params["id"].as_bytes()).decode_utf8() {
                    Ok(param_id) => match param_id.parse::<uuid::Uuid>() {
                        Ok(param_id) => param_id,
                        Err(e) => return Ok(Response::builder()
                                        .status(StatusCode::BAD_REQUEST)
                                        .body(Body::from(format!("Couldn't parse path parameter id: {}", e)))
                                        .expect("Unable to create Bad Request response for invalid path parameter")),
                    },
                    Err(_) => return Ok(Response::builder()
                                        .status(StatusCode::BAD_REQUEST)
                                        .body(Body::from(format!("Couldn't percent-decode path parameter as UTF-8: {}", &path_params["id"])))
                                        .expect("Unable to create Bad Request response for invalid percent decode"))
                };

                                let result = api_impl.get_institute_by_id(
                                            param_id,
                                        &context
                                    ).await;
                                let mut response = Response::new(Body::empty());
                                response.headers_mut().insert(
                                            HeaderName::from_static("x-span-id"),
                                            HeaderValue::from_str((&context as &dyn Has<XSpanIdString>).get().0.clone().to_string().as_str())
                                                .expect("Unable to create X-Span-ID header value"));

                                        match result {
                                            Ok(rsp) => match rsp {
                                                GetInstituteByIdResponse::SuccessfulOperation
                                                    (body)
                                                => {
                                                    *response.status_mut() = StatusCode::from_u16(200).expect("Unable to turn 200 into a StatusCode");
                                                    response.headers_mut().insert(
                                                        CONTENT_TYPE,
                                                        HeaderValue::from_str("application/json")
                                                            .expect("Unable to create Content-Type header for GET_INSTITUTE_BY_ID_SUCCESSFUL_OPERATION"));
                                                    let body = serde_json::to_string(&body).expect("impossible to fail to serialize");
                                                    *response.body_mut() = Body::from(body);
                                                },
                                                GetInstituteByIdResponse::InvalidIDSupplied
                                                => {
                                                    *response.status_mut() = StatusCode::from_u16(400).expect("Unable to turn 400 into a StatusCode");
                                                },
                                                GetInstituteByIdResponse::InstituteNotFound
                                                => {
                                                    *response.status_mut() = StatusCode::from_u16(404).expect("Unable to turn 404 into a StatusCode");
                                                },
                                            },
                                            Err(_) => {
                                                // Application code returned an error. This should not happen, as the implementation should
                                                // return a valid response.
                                                *response.status_mut() = StatusCode::INTERNAL_SERVER_ERROR;
                                                *response.body_mut() = Body::from("An internal error occurred");
                                            },
                                        }

                                        Ok(response)
            },

            // GetInstitutes - GET /query-api/catholic-polity-service/institutes
            &hyper::Method::GET if path.matched(paths::ID_QUERY_API_CATHOLIC_POLITY_SERVICE_INSTITUTES) => {
                {
                    let authorization = match (&context as &dyn Has<Option<Authorization>>).get() {
                        &Some(ref authorization) => authorization,
                        &None => return Ok(Response::builder()
                                                .status(StatusCode::FORBIDDEN)
                                                .body(Body::from("Unauthenticated"))
                                                .expect("Unable to create Authentication Forbidden response")),
                    };
                }

                // Query parameters (note that non-required or collection query parameters will ignore garbage values, rather than causing a 400 response)
                let query_params = form_urlencoded::parse(uri.query().unwrap_or_default().as_bytes()).collect::<Vec<_>>();
                let param_name = query_params.iter().filter(|e| e.0 == "name").map(|e| e.1.to_owned())
                    .nth(0);
                let param_name = match param_name {
                    Some(param_name) => {
                        let param_name =
                            <String as std::str::FromStr>::from_str
                                (&param_name);
                        match param_name {
                            Ok(param_name) => Some(param_name),
                            Err(e) => return Ok(Response::builder()
                                .status(StatusCode::BAD_REQUEST)
                                .body(Body::from(format!("Couldn't parse query parameter name - doesn't match schema: {}", e)))
                                .expect("Unable to create Bad Request response for invalid query parameter name")),
                        }
                    },
                    None => None,
                };
                let param_location_name = query_params.iter().filter(|e| e.0 == "locationName").map(|e| e.1.to_owned())
                    .nth(0);
                let param_location_name = match param_location_name {
                    Some(param_location_name) => {
                        let param_location_name =
                            <String as std::str::FromStr>::from_str
                                (&param_location_name);
                        match param_location_name {
                            Ok(param_location_name) => Some(param_location_name),
                            Err(e) => return Ok(Response::builder()
                                .status(StatusCode::BAD_REQUEST)
                                .body(Body::from(format!("Couldn't parse query parameter locationName - doesn't match schema: {}", e)))
                                .expect("Unable to create Bad Request response for invalid query parameter locationName")),
                        }
                    },
                    None => None,
                };
                let param_location_address = query_params.iter().filter(|e| e.0 == "locationAddress").map(|e| e.1.to_owned())
                    .nth(0);
                let param_location_address = match param_location_address {
                    Some(param_location_address) => {
                        let param_location_address =
                            <String as std::str::FromStr>::from_str
                                (&param_location_address);
                        match param_location_address {
                            Ok(param_location_address) => Some(param_location_address),
                            Err(e) => return Ok(Response::builder()
                                .status(StatusCode::BAD_REQUEST)
                                .body(Body::from(format!("Couldn't parse query parameter locationAddress - doesn't match schema: {}", e)))
                                .expect("Unable to create Bad Request response for invalid query parameter locationAddress")),
                        }
                    },
                    None => None,
                };
                let param_location_email = query_params.iter().filter(|e| e.0 == "locationEmail").map(|e| e.1.to_owned())
                    .nth(0);
                let param_location_email = match param_location_email {
                    Some(param_location_email) => {
                        let param_location_email =
                            <String as std::str::FromStr>::from_str
                                (&param_location_email);
                        match param_location_email {
                            Ok(param_location_email) => Some(param_location_email),
                            Err(e) => return Ok(Response::builder()
                                .status(StatusCode::BAD_REQUEST)
                                .body(Body::from(format!("Couldn't parse query parameter locationEmail - doesn't match schema: {}", e)))
                                .expect("Unable to create Bad Request response for invalid query parameter locationEmail")),
                        }
                    },
                    None => None,
                };
                let param_person_in_charge = query_params.iter().filter(|e| e.0 == "personInCharge").map(|e| e.1.to_owned())
                    .nth(0);
                let param_person_in_charge = match param_person_in_charge {
                    Some(param_person_in_charge) => {
                        let param_person_in_charge =
                            <String as std::str::FromStr>::from_str
                                (&param_person_in_charge);
                        match param_person_in_charge {
                            Ok(param_person_in_charge) => Some(param_person_in_charge),
                            Err(e) => return Ok(Response::builder()
                                .status(StatusCode::BAD_REQUEST)
                                .body(Body::from(format!("Couldn't parse query parameter personInCharge - doesn't match schema: {}", e)))
                                .expect("Unable to create Bad Request response for invalid query parameter personInCharge")),
                        }
                    },
                    None => None,
                };
                let param_sorts = query_params.iter().filter(|e| e.0 == "sorts").map(|e| e.1.to_owned())
                    .filter_map(|param_sorts| param_sorts.parse().ok())
                    .collect::<Vec<_>>();
                let param_sorts = if !param_sorts.is_empty() {
                    Some(param_sorts)
                } else {
                    None
                };
                let param_offset = query_params.iter().filter(|e| e.0 == "offset").map(|e| e.1.to_owned())
                    .nth(0);
                let param_offset = match param_offset {
                    Some(param_offset) => {
                        let param_offset =
                            <i32 as std::str::FromStr>::from_str
                                (&param_offset);
                        match param_offset {
                            Ok(param_offset) => Some(param_offset),
                            Err(e) => return Ok(Response::builder()
                                .status(StatusCode::BAD_REQUEST)
                                .body(Body::from(format!("Couldn't parse query parameter offset - doesn't match schema: {}", e)))
                                .expect("Unable to create Bad Request response for invalid query parameter offset")),
                        }
                    },
                    None => None,
                };
                let param_count = query_params.iter().filter(|e| e.0 == "count").map(|e| e.1.to_owned())
                    .nth(0);
                let param_count = match param_count {
                    Some(param_count) => {
                        let param_count =
                            <i32 as std::str::FromStr>::from_str
                                (&param_count);
                        match param_count {
                            Ok(param_count) => Some(param_count),
                            Err(e) => return Ok(Response::builder()
                                .status(StatusCode::BAD_REQUEST)
                                .body(Body::from(format!("Couldn't parse query parameter count - doesn't match schema: {}", e)))
                                .expect("Unable to create Bad Request response for invalid query parameter count")),
                        }
                    },
                    None => None,
                };

                                let result = api_impl.get_institutes(
                                            param_name,
                                            param_location_name,
                                            param_location_address,
                                            param_location_email,
                                            param_person_in_charge,
                                            param_sorts.as_ref(),
                                            param_offset,
                                            param_count,
                                        &context
                                    ).await;
                                let mut response = Response::new(Body::empty());
                                response.headers_mut().insert(
                                            HeaderName::from_static("x-span-id"),
                                            HeaderValue::from_str((&context as &dyn Has<XSpanIdString>).get().0.clone().to_string().as_str())
                                                .expect("Unable to create X-Span-ID header value"));

                                        match result {
                                            Ok(rsp) => match rsp {
                                                GetInstitutesResponse::SuccessfulOperation
                                                    (body)
                                                => {
                                                    *response.status_mut() = StatusCode::from_u16(200).expect("Unable to turn 200 into a StatusCode");
                                                    response.headers_mut().insert(
                                                        CONTENT_TYPE,
                                                        HeaderValue::from_str("application/json")
                                                            .expect("Unable to create Content-Type header for GET_INSTITUTES_SUCCESSFUL_OPERATION"));
                                                    let body = serde_json::to_string(&body).expect("impossible to fail to serialize");
                                                    *response.body_mut() = Body::from(body);
                                                },
                                                GetInstitutesResponse::InvalidIDSupplied
                                                => {
                                                    *response.status_mut() = StatusCode::from_u16(400).expect("Unable to turn 400 into a StatusCode");
                                                },
                                                GetInstitutesResponse::InstituteNotFound
                                                => {
                                                    *response.status_mut() = StatusCode::from_u16(404).expect("Unable to turn 404 into a StatusCode");
                                                },
                                            },
                                            Err(_) => {
                                                // Application code returned an error. This should not happen, as the implementation should
                                                // return a valid response.
                                                *response.status_mut() = StatusCode::INTERNAL_SERVER_ERROR;
                                                *response.body_mut() = Body::from("An internal error occurred");
                                            },
                                        }

                                        Ok(response)
            },

            // UpdateInstitute - PUT /mutation-api/catholic-polity-service/institutes/{id}
            &hyper::Method::PUT if path.matched(paths::ID_MUTATION_API_CATHOLIC_POLITY_SERVICE_INSTITUTES_ID) => {
                {
                    let authorization = match (&context as &dyn Has<Option<Authorization>>).get() {
                        &Some(ref authorization) => authorization,
                        &None => return Ok(Response::builder()
                                                .status(StatusCode::FORBIDDEN)
                                                .body(Body::from("Unauthenticated"))
                                                .expect("Unable to create Authentication Forbidden response")),
                    };
                }

                // Path parameters
                let path: &str = &uri.path().to_string();
                let path_params =
                    paths::REGEX_MUTATION_API_CATHOLIC_POLITY_SERVICE_INSTITUTES_ID
                    .captures(&path)
                    .unwrap_or_else(||
                        panic!("Path {} matched RE MUTATION_API_CATHOLIC_POLITY_SERVICE_INSTITUTES_ID in set but failed match against \"{}\"", path, paths::REGEX_MUTATION_API_CATHOLIC_POLITY_SERVICE_INSTITUTES_ID.as_str())
                    );

                let param_id = match percent_encoding::percent_decode(path_params["id"].as_bytes()).decode_utf8() {
                    Ok(param_id) => match param_id.parse::<uuid::Uuid>() {
                        Ok(param_id) => param_id,
                        Err(e) => return Ok(Response::builder()
                                        .status(StatusCode::BAD_REQUEST)
                                        .body(Body::from(format!("Couldn't parse path parameter id: {}", e)))
                                        .expect("Unable to create Bad Request response for invalid path parameter")),
                    },
                    Err(_) => return Ok(Response::builder()
                                        .status(StatusCode::BAD_REQUEST)
                                        .body(Body::from(format!("Couldn't percent-decode path parameter as UTF-8: {}", &path_params["id"])))
                                        .expect("Unable to create Bad Request response for invalid percent decode"))
                };

                // Body parameters (note that non-required body parameters will ignore garbage
                // values, rather than causing a 400 response). Produce warning header and logs for
                // any unused fields.
                let result = body.to_raw().await;
                match result {
                            Ok(body) => {
                                let mut unused_elements = Vec::new();
                                let param_institute_mutation: Option<models::InstituteMutation> = if !body.is_empty() {
                                    let deserializer = &mut serde_json::Deserializer::from_slice(&*body);
                                    match serde_ignored::deserialize(deserializer, |path| {
                                            warn!("Ignoring unknown field in body: {}", path);
                                            unused_elements.push(path.to_string());
                                    }) {
                                        Ok(param_institute_mutation) => param_institute_mutation,
                                        Err(e) => return Ok(Response::builder()
                                                        .status(StatusCode::BAD_REQUEST)
                                                        .body(Body::from(format!("Couldn't parse body parameter InstituteMutation - doesn't match schema: {}", e)))
                                                        .expect("Unable to create Bad Request response for invalid body parameter InstituteMutation due to schema")),
                                    }
                                } else {
                                    None
                                };
                                let param_institute_mutation = match param_institute_mutation {
                                    Some(param_institute_mutation) => param_institute_mutation,
                                    None => return Ok(Response::builder()
                                                        .status(StatusCode::BAD_REQUEST)
                                                        .body(Body::from("Missing required body parameter InstituteMutation"))
                                                        .expect("Unable to create Bad Request response for missing body parameter InstituteMutation")),
                                };

                                let result = api_impl.update_institute(
                                            param_id,
                                            param_institute_mutation,
                                        &context
                                    ).await;
                                let mut response = Response::new(Body::empty());
                                response.headers_mut().insert(
                                            HeaderName::from_static("x-span-id"),
                                            HeaderValue::from_str((&context as &dyn Has<XSpanIdString>).get().0.clone().to_string().as_str())
                                                .expect("Unable to create X-Span-ID header value"));

                                        if !unused_elements.is_empty() {
                                            response.headers_mut().insert(
                                                HeaderName::from_static("warning"),
                                                HeaderValue::from_str(format!("Ignoring unknown fields in body: {:?}", unused_elements).as_str())
                                                    .expect("Unable to create Warning header value"));
                                        }

                                        match result {
                                            Ok(rsp) => match rsp {
                                                UpdateInstituteResponse::SuccessfulOperation
                                                    (body)
                                                => {
                                                    *response.status_mut() = StatusCode::from_u16(200).expect("Unable to turn 200 into a StatusCode");
                                                    response.headers_mut().insert(
                                                        CONTENT_TYPE,
                                                        HeaderValue::from_str("application/json")
                                                            .expect("Unable to create Content-Type header for UPDATE_INSTITUTE_SUCCESSFUL_OPERATION"));
                                                    let body = serde_json::to_string(&body).expect("impossible to fail to serialize");
                                                    *response.body_mut() = Body::from(body);
                                                },
                                                UpdateInstituteResponse::InvalidIDSupplied
                                                => {
                                                    *response.status_mut() = StatusCode::from_u16(400).expect("Unable to turn 400 into a StatusCode");
                                                },
                                                UpdateInstituteResponse::InstituteNotFound
                                                => {
                                                    *response.status_mut() = StatusCode::from_u16(404).expect("Unable to turn 404 into a StatusCode");
                                                },
                                                UpdateInstituteResponse::ValidationException
                                                => {
                                                    *response.status_mut() = StatusCode::from_u16(405).expect("Unable to turn 405 into a StatusCode");
                                                },
                                            },
                                            Err(_) => {
                                                // Application code returned an error. This should not happen, as the implementation should
                                                // return a valid response.
                                                *response.status_mut() = StatusCode::INTERNAL_SERVER_ERROR;
                                                *response.body_mut() = Body::from("An internal error occurred");
                                            },
                                        }

                                        Ok(response)
                            },
                            Err(e) => Ok(Response::builder()
                                                .status(StatusCode::BAD_REQUEST)
                                                .body(Body::from(format!("Couldn't read body parameter InstituteMutation: {}", e)))
                                                .expect("Unable to create Bad Request response due to unable to read body parameter InstituteMutation")),
                        }
            },

            // AddParish - POST /mutation-api/catholic-polity-service/parishes
            &hyper::Method::POST if path.matched(paths::ID_MUTATION_API_CATHOLIC_POLITY_SERVICE_PARISHES) => {
                {
                    let authorization = match (&context as &dyn Has<Option<Authorization>>).get() {
                        &Some(ref authorization) => authorization,
                        &None => return Ok(Response::builder()
                                                .status(StatusCode::FORBIDDEN)
                                                .body(Body::from("Unauthenticated"))
                                                .expect("Unable to create Authentication Forbidden response")),
                    };
                }

                // Body parameters (note that non-required body parameters will ignore garbage
                // values, rather than causing a 400 response). Produce warning header and logs for
                // any unused fields.
                let result = body.to_raw().await;
                match result {
                            Ok(body) => {
                                let mut unused_elements = Vec::new();
                                let param_parish_mutation: Option<models::ParishMutation> = if !body.is_empty() {
                                    let deserializer = &mut serde_json::Deserializer::from_slice(&*body);
                                    match serde_ignored::deserialize(deserializer, |path| {
                                            warn!("Ignoring unknown field in body: {}", path);
                                            unused_elements.push(path.to_string());
                                    }) {
                                        Ok(param_parish_mutation) => param_parish_mutation,
                                        Err(_) => None,
                                    }
                                } else {
                                    None
                                };

                                let result = api_impl.add_parish(
                                            param_parish_mutation,
                                        &context
                                    ).await;
                                let mut response = Response::new(Body::empty());
                                response.headers_mut().insert(
                                            HeaderName::from_static("x-span-id"),
                                            HeaderValue::from_str((&context as &dyn Has<XSpanIdString>).get().0.clone().to_string().as_str())
                                                .expect("Unable to create X-Span-ID header value"));

                                        if !unused_elements.is_empty() {
                                            response.headers_mut().insert(
                                                HeaderName::from_static("warning"),
                                                HeaderValue::from_str(format!("Ignoring unknown fields in body: {:?}", unused_elements).as_str())
                                                    .expect("Unable to create Warning header value"));
                                        }

                                        match result {
                                            Ok(rsp) => match rsp {
                                                AddParishResponse::SuccessfulOperation
                                                    (body)
                                                => {
                                                    *response.status_mut() = StatusCode::from_u16(200).expect("Unable to turn 200 into a StatusCode");
                                                    response.headers_mut().insert(
                                                        CONTENT_TYPE,
                                                        HeaderValue::from_str("application/json")
                                                            .expect("Unable to create Content-Type header for ADD_PARISH_SUCCESSFUL_OPERATION"));
                                                    let body = serde_json::to_string(&body).expect("impossible to fail to serialize");
                                                    *response.body_mut() = Body::from(body);
                                                },
                                                AddParishResponse::InvalidInput
                                                => {
                                                    *response.status_mut() = StatusCode::from_u16(405).expect("Unable to turn 405 into a StatusCode");
                                                },
                                            },
                                            Err(_) => {
                                                // Application code returned an error. This should not happen, as the implementation should
                                                // return a valid response.
                                                *response.status_mut() = StatusCode::INTERNAL_SERVER_ERROR;
                                                *response.body_mut() = Body::from("An internal error occurred");
                                            },
                                        }

                                        Ok(response)
                            },
                            Err(e) => Ok(Response::builder()
                                                .status(StatusCode::BAD_REQUEST)
                                                .body(Body::from(format!("Couldn't read body parameter ParishMutation: {}", e)))
                                                .expect("Unable to create Bad Request response due to unable to read body parameter ParishMutation")),
                        }
            },

            // DeleteParish - DELETE /mutation-api/catholic-polity-service/parishes/{id}
            &hyper::Method::DELETE if path.matched(paths::ID_MUTATION_API_CATHOLIC_POLITY_SERVICE_PARISHES_ID) => {
                {
                    let authorization = match (&context as &dyn Has<Option<Authorization>>).get() {
                        &Some(ref authorization) => authorization,
                        &None => return Ok(Response::builder()
                                                .status(StatusCode::FORBIDDEN)
                                                .body(Body::from("Unauthenticated"))
                                                .expect("Unable to create Authentication Forbidden response")),
                    };
                }

                // Path parameters
                let path: &str = &uri.path().to_string();
                let path_params =
                    paths::REGEX_MUTATION_API_CATHOLIC_POLITY_SERVICE_PARISHES_ID
                    .captures(&path)
                    .unwrap_or_else(||
                        panic!("Path {} matched RE MUTATION_API_CATHOLIC_POLITY_SERVICE_PARISHES_ID in set but failed match against \"{}\"", path, paths::REGEX_MUTATION_API_CATHOLIC_POLITY_SERVICE_PARISHES_ID.as_str())
                    );

                let param_id = match percent_encoding::percent_decode(path_params["id"].as_bytes()).decode_utf8() {
                    Ok(param_id) => match param_id.parse::<uuid::Uuid>() {
                        Ok(param_id) => param_id,
                        Err(e) => return Ok(Response::builder()
                                        .status(StatusCode::BAD_REQUEST)
                                        .body(Body::from(format!("Couldn't parse path parameter id: {}", e)))
                                        .expect("Unable to create Bad Request response for invalid path parameter")),
                    },
                    Err(_) => return Ok(Response::builder()
                                        .status(StatusCode::BAD_REQUEST)
                                        .body(Body::from(format!("Couldn't percent-decode path parameter as UTF-8: {}", &path_params["id"])))
                                        .expect("Unable to create Bad Request response for invalid percent decode"))
                };

                                let result = api_impl.delete_parish(
                                            param_id,
                                        &context
                                    ).await;
                                let mut response = Response::new(Body::empty());
                                response.headers_mut().insert(
                                            HeaderName::from_static("x-span-id"),
                                            HeaderValue::from_str((&context as &dyn Has<XSpanIdString>).get().0.clone().to_string().as_str())
                                                .expect("Unable to create X-Span-ID header value"));

                                        match result {
                                            Ok(rsp) => match rsp {
                                                DeleteParishResponse::SuccessfulOperation
                                                => {
                                                    *response.status_mut() = StatusCode::from_u16(204).expect("Unable to turn 204 into a StatusCode");
                                                },
                                                DeleteParishResponse::InvalidIDSupplied
                                                => {
                                                    *response.status_mut() = StatusCode::from_u16(400).expect("Unable to turn 400 into a StatusCode");
                                                },
                                                DeleteParishResponse::ParishNotFound
                                                => {
                                                    *response.status_mut() = StatusCode::from_u16(404).expect("Unable to turn 404 into a StatusCode");
                                                },
                                            },
                                            Err(_) => {
                                                // Application code returned an error. This should not happen, as the implementation should
                                                // return a valid response.
                                                *response.status_mut() = StatusCode::INTERNAL_SERVER_ERROR;
                                                *response.body_mut() = Body::from("An internal error occurred");
                                            },
                                        }

                                        Ok(response)
            },

            // GetParishById - GET /query-api/catholic-polity-service/parishes/{id}
            &hyper::Method::GET if path.matched(paths::ID_QUERY_API_CATHOLIC_POLITY_SERVICE_PARISHES_ID) => {
                {
                    let authorization = match (&context as &dyn Has<Option<Authorization>>).get() {
                        &Some(ref authorization) => authorization,
                        &None => return Ok(Response::builder()
                                                .status(StatusCode::FORBIDDEN)
                                                .body(Body::from("Unauthenticated"))
                                                .expect("Unable to create Authentication Forbidden response")),
                    };
                }

                // Path parameters
                let path: &str = &uri.path().to_string();
                let path_params =
                    paths::REGEX_QUERY_API_CATHOLIC_POLITY_SERVICE_PARISHES_ID
                    .captures(&path)
                    .unwrap_or_else(||
                        panic!("Path {} matched RE QUERY_API_CATHOLIC_POLITY_SERVICE_PARISHES_ID in set but failed match against \"{}\"", path, paths::REGEX_QUERY_API_CATHOLIC_POLITY_SERVICE_PARISHES_ID.as_str())
                    );

                let param_id = match percent_encoding::percent_decode(path_params["id"].as_bytes()).decode_utf8() {
                    Ok(param_id) => match param_id.parse::<uuid::Uuid>() {
                        Ok(param_id) => param_id,
                        Err(e) => return Ok(Response::builder()
                                        .status(StatusCode::BAD_REQUEST)
                                        .body(Body::from(format!("Couldn't parse path parameter id: {}", e)))
                                        .expect("Unable to create Bad Request response for invalid path parameter")),
                    },
                    Err(_) => return Ok(Response::builder()
                                        .status(StatusCode::BAD_REQUEST)
                                        .body(Body::from(format!("Couldn't percent-decode path parameter as UTF-8: {}", &path_params["id"])))
                                        .expect("Unable to create Bad Request response for invalid percent decode"))
                };

                                let result = api_impl.get_parish_by_id(
                                            param_id,
                                        &context
                                    ).await;
                                let mut response = Response::new(Body::empty());
                                response.headers_mut().insert(
                                            HeaderName::from_static("x-span-id"),
                                            HeaderValue::from_str((&context as &dyn Has<XSpanIdString>).get().0.clone().to_string().as_str())
                                                .expect("Unable to create X-Span-ID header value"));

                                        match result {
                                            Ok(rsp) => match rsp {
                                                GetParishByIdResponse::SuccessfulOperation
                                                    (body)
                                                => {
                                                    *response.status_mut() = StatusCode::from_u16(200).expect("Unable to turn 200 into a StatusCode");
                                                    response.headers_mut().insert(
                                                        CONTENT_TYPE,
                                                        HeaderValue::from_str("application/json")
                                                            .expect("Unable to create Content-Type header for GET_PARISH_BY_ID_SUCCESSFUL_OPERATION"));
                                                    let body = serde_json::to_string(&body).expect("impossible to fail to serialize");
                                                    *response.body_mut() = Body::from(body);
                                                },
                                                GetParishByIdResponse::InvalidIDSupplied
                                                => {
                                                    *response.status_mut() = StatusCode::from_u16(400).expect("Unable to turn 400 into a StatusCode");
                                                },
                                                GetParishByIdResponse::ParishNotFound
                                                => {
                                                    *response.status_mut() = StatusCode::from_u16(404).expect("Unable to turn 404 into a StatusCode");
                                                },
                                            },
                                            Err(_) => {
                                                // Application code returned an error. This should not happen, as the implementation should
                                                // return a valid response.
                                                *response.status_mut() = StatusCode::INTERNAL_SERVER_ERROR;
                                                *response.body_mut() = Body::from("An internal error occurred");
                                            },
                                        }

                                        Ok(response)
            },

            // GetParishes - GET /query-api/catholic-polity-service/parishes
            &hyper::Method::GET if path.matched(paths::ID_QUERY_API_CATHOLIC_POLITY_SERVICE_PARISHES) => {
                {
                    let authorization = match (&context as &dyn Has<Option<Authorization>>).get() {
                        &Some(ref authorization) => authorization,
                        &None => return Ok(Response::builder()
                                                .status(StatusCode::FORBIDDEN)
                                                .body(Body::from("Unauthenticated"))
                                                .expect("Unable to create Authentication Forbidden response")),
                    };
                }

                // Query parameters (note that non-required or collection query parameters will ignore garbage values, rather than causing a 400 response)
                let query_params = form_urlencoded::parse(uri.query().unwrap_or_default().as_bytes()).collect::<Vec<_>>();
                let param_deanery_id = query_params.iter().filter(|e| e.0 == "deaneryId").map(|e| e.1.to_owned())
                    .nth(0);
                let param_deanery_id = match param_deanery_id {
                    Some(param_deanery_id) => {
                        let param_deanery_id =
                            <uuid::Uuid as std::str::FromStr>::from_str
                                (&param_deanery_id);
                        match param_deanery_id {
                            Ok(param_deanery_id) => Some(param_deanery_id),
                            Err(e) => return Ok(Response::builder()
                                .status(StatusCode::BAD_REQUEST)
                                .body(Body::from(format!("Couldn't parse query parameter deaneryId - doesn't match schema: {}", e)))
                                .expect("Unable to create Bad Request response for invalid query parameter deaneryId")),
                        }
                    },
                    None => None,
                };
                let param_diocese_id = query_params.iter().filter(|e| e.0 == "dioceseId").map(|e| e.1.to_owned())
                    .nth(0);
                let param_diocese_id = match param_diocese_id {
                    Some(param_diocese_id) => {
                        let param_diocese_id =
                            <uuid::Uuid as std::str::FromStr>::from_str
                                (&param_diocese_id);
                        match param_diocese_id {
                            Ok(param_diocese_id) => Some(param_diocese_id),
                            Err(e) => return Ok(Response::builder()
                                .status(StatusCode::BAD_REQUEST)
                                .body(Body::from(format!("Couldn't parse query parameter dioceseId - doesn't match schema: {}", e)))
                                .expect("Unable to create Bad Request response for invalid query parameter dioceseId")),
                        }
                    },
                    None => None,
                };
                let param_name = query_params.iter().filter(|e| e.0 == "name").map(|e| e.1.to_owned())
                    .nth(0);
                let param_name = match param_name {
                    Some(param_name) => {
                        let param_name =
                            <String as std::str::FromStr>::from_str
                                (&param_name);
                        match param_name {
                            Ok(param_name) => Some(param_name),
                            Err(e) => return Ok(Response::builder()
                                .status(StatusCode::BAD_REQUEST)
                                .body(Body::from(format!("Couldn't parse query parameter name - doesn't match schema: {}", e)))
                                .expect("Unable to create Bad Request response for invalid query parameter name")),
                        }
                    },
                    None => None,
                };
                let param_offset = query_params.iter().filter(|e| e.0 == "offset").map(|e| e.1.to_owned())
                    .nth(0);
                let param_offset = match param_offset {
                    Some(param_offset) => {
                        let param_offset =
                            <i32 as std::str::FromStr>::from_str
                                (&param_offset);
                        match param_offset {
                            Ok(param_offset) => Some(param_offset),
                            Err(e) => return Ok(Response::builder()
                                .status(StatusCode::BAD_REQUEST)
                                .body(Body::from(format!("Couldn't parse query parameter offset - doesn't match schema: {}", e)))
                                .expect("Unable to create Bad Request response for invalid query parameter offset")),
                        }
                    },
                    None => None,
                };
                let param_count = query_params.iter().filter(|e| e.0 == "count").map(|e| e.1.to_owned())
                    .nth(0);
                let param_count = match param_count {
                    Some(param_count) => {
                        let param_count =
                            <i32 as std::str::FromStr>::from_str
                                (&param_count);
                        match param_count {
                            Ok(param_count) => Some(param_count),
                            Err(e) => return Ok(Response::builder()
                                .status(StatusCode::BAD_REQUEST)
                                .body(Body::from(format!("Couldn't parse query parameter count - doesn't match schema: {}", e)))
                                .expect("Unable to create Bad Request response for invalid query parameter count")),
                        }
                    },
                    None => None,
                };

                                let result = api_impl.get_parishes(
                                            param_deanery_id,
                                            param_diocese_id,
                                            param_name,
                                            param_offset,
                                            param_count,
                                        &context
                                    ).await;
                                let mut response = Response::new(Body::empty());
                                response.headers_mut().insert(
                                            HeaderName::from_static("x-span-id"),
                                            HeaderValue::from_str((&context as &dyn Has<XSpanIdString>).get().0.clone().to_string().as_str())
                                                .expect("Unable to create X-Span-ID header value"));

                                        match result {
                                            Ok(rsp) => match rsp {
                                                GetParishesResponse::SuccessfulOperation
                                                    (body)
                                                => {
                                                    *response.status_mut() = StatusCode::from_u16(200).expect("Unable to turn 200 into a StatusCode");
                                                    response.headers_mut().insert(
                                                        CONTENT_TYPE,
                                                        HeaderValue::from_str("application/json")
                                                            .expect("Unable to create Content-Type header for GET_PARISHES_SUCCESSFUL_OPERATION"));
                                                    let body = serde_json::to_string(&body).expect("impossible to fail to serialize");
                                                    *response.body_mut() = Body::from(body);
                                                },
                                                GetParishesResponse::InvalidIDSupplied
                                                => {
                                                    *response.status_mut() = StatusCode::from_u16(400).expect("Unable to turn 400 into a StatusCode");
                                                },
                                                GetParishesResponse::ParishNotFound
                                                => {
                                                    *response.status_mut() = StatusCode::from_u16(404).expect("Unable to turn 404 into a StatusCode");
                                                },
                                            },
                                            Err(_) => {
                                                // Application code returned an error. This should not happen, as the implementation should
                                                // return a valid response.
                                                *response.status_mut() = StatusCode::INTERNAL_SERVER_ERROR;
                                                *response.body_mut() = Body::from("An internal error occurred");
                                            },
                                        }

                                        Ok(response)
            },

            // UpdateParish - PUT /mutation-api/catholic-polity-service/parishes/{id}
            &hyper::Method::PUT if path.matched(paths::ID_MUTATION_API_CATHOLIC_POLITY_SERVICE_PARISHES_ID) => {
                {
                    let authorization = match (&context as &dyn Has<Option<Authorization>>).get() {
                        &Some(ref authorization) => authorization,
                        &None => return Ok(Response::builder()
                                                .status(StatusCode::FORBIDDEN)
                                                .body(Body::from("Unauthenticated"))
                                                .expect("Unable to create Authentication Forbidden response")),
                    };
                }

                // Path parameters
                let path: &str = &uri.path().to_string();
                let path_params =
                    paths::REGEX_MUTATION_API_CATHOLIC_POLITY_SERVICE_PARISHES_ID
                    .captures(&path)
                    .unwrap_or_else(||
                        panic!("Path {} matched RE MUTATION_API_CATHOLIC_POLITY_SERVICE_PARISHES_ID in set but failed match against \"{}\"", path, paths::REGEX_MUTATION_API_CATHOLIC_POLITY_SERVICE_PARISHES_ID.as_str())
                    );

                let param_id = match percent_encoding::percent_decode(path_params["id"].as_bytes()).decode_utf8() {
                    Ok(param_id) => match param_id.parse::<uuid::Uuid>() {
                        Ok(param_id) => param_id,
                        Err(e) => return Ok(Response::builder()
                                        .status(StatusCode::BAD_REQUEST)
                                        .body(Body::from(format!("Couldn't parse path parameter id: {}", e)))
                                        .expect("Unable to create Bad Request response for invalid path parameter")),
                    },
                    Err(_) => return Ok(Response::builder()
                                        .status(StatusCode::BAD_REQUEST)
                                        .body(Body::from(format!("Couldn't percent-decode path parameter as UTF-8: {}", &path_params["id"])))
                                        .expect("Unable to create Bad Request response for invalid percent decode"))
                };

                // Body parameters (note that non-required body parameters will ignore garbage
                // values, rather than causing a 400 response). Produce warning header and logs for
                // any unused fields.
                let result = body.to_raw().await;
                match result {
                            Ok(body) => {
                                let mut unused_elements = Vec::new();
                                let param_parish_mutation: Option<models::ParishMutation> = if !body.is_empty() {
                                    let deserializer = &mut serde_json::Deserializer::from_slice(&*body);
                                    match serde_ignored::deserialize(deserializer, |path| {
                                            warn!("Ignoring unknown field in body: {}", path);
                                            unused_elements.push(path.to_string());
                                    }) {
                                        Ok(param_parish_mutation) => param_parish_mutation,
                                        Err(_) => None,
                                    }
                                } else {
                                    None
                                };

                                let result = api_impl.update_parish(
                                            param_id,
                                            param_parish_mutation,
                                        &context
                                    ).await;
                                let mut response = Response::new(Body::empty());
                                response.headers_mut().insert(
                                            HeaderName::from_static("x-span-id"),
                                            HeaderValue::from_str((&context as &dyn Has<XSpanIdString>).get().0.clone().to_string().as_str())
                                                .expect("Unable to create X-Span-ID header value"));

                                        if !unused_elements.is_empty() {
                                            response.headers_mut().insert(
                                                HeaderName::from_static("warning"),
                                                HeaderValue::from_str(format!("Ignoring unknown fields in body: {:?}", unused_elements).as_str())
                                                    .expect("Unable to create Warning header value"));
                                        }

                                        match result {
                                            Ok(rsp) => match rsp {
                                                UpdateParishResponse::SuccessfulOperation
                                                    (body)
                                                => {
                                                    *response.status_mut() = StatusCode::from_u16(200).expect("Unable to turn 200 into a StatusCode");
                                                    response.headers_mut().insert(
                                                        CONTENT_TYPE,
                                                        HeaderValue::from_str("application/json")
                                                            .expect("Unable to create Content-Type header for UPDATE_PARISH_SUCCESSFUL_OPERATION"));
                                                    let body = serde_json::to_string(&body).expect("impossible to fail to serialize");
                                                    *response.body_mut() = Body::from(body);
                                                },
                                                UpdateParishResponse::InvalidIDSupplied
                                                => {
                                                    *response.status_mut() = StatusCode::from_u16(400).expect("Unable to turn 400 into a StatusCode");
                                                },
                                                UpdateParishResponse::ParishNotFound
                                                => {
                                                    *response.status_mut() = StatusCode::from_u16(404).expect("Unable to turn 404 into a StatusCode");
                                                },
                                                UpdateParishResponse::ValidationException
                                                => {
                                                    *response.status_mut() = StatusCode::from_u16(405).expect("Unable to turn 405 into a StatusCode");
                                                },
                                            },
                                            Err(_) => {
                                                // Application code returned an error. This should not happen, as the implementation should
                                                // return a valid response.
                                                *response.status_mut() = StatusCode::INTERNAL_SERVER_ERROR;
                                                *response.body_mut() = Body::from("An internal error occurred");
                                            },
                                        }

                                        Ok(response)
                            },
                            Err(e) => Ok(Response::builder()
                                                .status(StatusCode::BAD_REQUEST)
                                                .body(Body::from(format!("Couldn't read body parameter ParishMutation: {}", e)))
                                                .expect("Unable to create Bad Request response due to unable to read body parameter ParishMutation")),
                        }
            },

            // AddProvince - POST /mutation-api/catholic-polity-service/provinces
            &hyper::Method::POST if path.matched(paths::ID_MUTATION_API_CATHOLIC_POLITY_SERVICE_PROVINCES) => {
                {
                    let authorization = match (&context as &dyn Has<Option<Authorization>>).get() {
                        &Some(ref authorization) => authorization,
                        &None => return Ok(Response::builder()
                                                .status(StatusCode::FORBIDDEN)
                                                .body(Body::from("Unauthenticated"))
                                                .expect("Unable to create Authentication Forbidden response")),
                    };
                }

                // Body parameters (note that non-required body parameters will ignore garbage
                // values, rather than causing a 400 response). Produce warning header and logs for
                // any unused fields.
                let result = body.to_raw().await;
                match result {
                            Ok(body) => {
                                let mut unused_elements = Vec::new();
                                let param_province_mutation: Option<models::ProvinceMutation> = if !body.is_empty() {
                                    let deserializer = &mut serde_json::Deserializer::from_slice(&*body);
                                    match serde_ignored::deserialize(deserializer, |path| {
                                            warn!("Ignoring unknown field in body: {}", path);
                                            unused_elements.push(path.to_string());
                                    }) {
                                        Ok(param_province_mutation) => param_province_mutation,
                                        Err(_) => None,
                                    }
                                } else {
                                    None
                                };

                                let result = api_impl.add_province(
                                            param_province_mutation,
                                        &context
                                    ).await;
                                let mut response = Response::new(Body::empty());
                                response.headers_mut().insert(
                                            HeaderName::from_static("x-span-id"),
                                            HeaderValue::from_str((&context as &dyn Has<XSpanIdString>).get().0.clone().to_string().as_str())
                                                .expect("Unable to create X-Span-ID header value"));

                                        if !unused_elements.is_empty() {
                                            response.headers_mut().insert(
                                                HeaderName::from_static("warning"),
                                                HeaderValue::from_str(format!("Ignoring unknown fields in body: {:?}", unused_elements).as_str())
                                                    .expect("Unable to create Warning header value"));
                                        }

                                        match result {
                                            Ok(rsp) => match rsp {
                                                AddProvinceResponse::SuccessfulOperation
                                                    (body)
                                                => {
                                                    *response.status_mut() = StatusCode::from_u16(200).expect("Unable to turn 200 into a StatusCode");
                                                    response.headers_mut().insert(
                                                        CONTENT_TYPE,
                                                        HeaderValue::from_str("application/json")
                                                            .expect("Unable to create Content-Type header for ADD_PROVINCE_SUCCESSFUL_OPERATION"));
                                                    let body = serde_json::to_string(&body).expect("impossible to fail to serialize");
                                                    *response.body_mut() = Body::from(body);
                                                },
                                                AddProvinceResponse::InvalidInput
                                                => {
                                                    *response.status_mut() = StatusCode::from_u16(405).expect("Unable to turn 405 into a StatusCode");
                                                },
                                            },
                                            Err(_) => {
                                                // Application code returned an error. This should not happen, as the implementation should
                                                // return a valid response.
                                                *response.status_mut() = StatusCode::INTERNAL_SERVER_ERROR;
                                                *response.body_mut() = Body::from("An internal error occurred");
                                            },
                                        }

                                        Ok(response)
                            },
                            Err(e) => Ok(Response::builder()
                                                .status(StatusCode::BAD_REQUEST)
                                                .body(Body::from(format!("Couldn't read body parameter ProvinceMutation: {}", e)))
                                                .expect("Unable to create Bad Request response due to unable to read body parameter ProvinceMutation")),
                        }
            },

            // DeleteProvince - DELETE /mutation-api/catholic-polity-service/provinces/{id}
            &hyper::Method::DELETE if path.matched(paths::ID_MUTATION_API_CATHOLIC_POLITY_SERVICE_PROVINCES_ID) => {
                {
                    let authorization = match (&context as &dyn Has<Option<Authorization>>).get() {
                        &Some(ref authorization) => authorization,
                        &None => return Ok(Response::builder()
                                                .status(StatusCode::FORBIDDEN)
                                                .body(Body::from("Unauthenticated"))
                                                .expect("Unable to create Authentication Forbidden response")),
                    };
                }

                // Path parameters
                let path: &str = &uri.path().to_string();
                let path_params =
                    paths::REGEX_MUTATION_API_CATHOLIC_POLITY_SERVICE_PROVINCES_ID
                    .captures(&path)
                    .unwrap_or_else(||
                        panic!("Path {} matched RE MUTATION_API_CATHOLIC_POLITY_SERVICE_PROVINCES_ID in set but failed match against \"{}\"", path, paths::REGEX_MUTATION_API_CATHOLIC_POLITY_SERVICE_PROVINCES_ID.as_str())
                    );

                let param_id = match percent_encoding::percent_decode(path_params["id"].as_bytes()).decode_utf8() {
                    Ok(param_id) => match param_id.parse::<uuid::Uuid>() {
                        Ok(param_id) => param_id,
                        Err(e) => return Ok(Response::builder()
                                        .status(StatusCode::BAD_REQUEST)
                                        .body(Body::from(format!("Couldn't parse path parameter id: {}", e)))
                                        .expect("Unable to create Bad Request response for invalid path parameter")),
                    },
                    Err(_) => return Ok(Response::builder()
                                        .status(StatusCode::BAD_REQUEST)
                                        .body(Body::from(format!("Couldn't percent-decode path parameter as UTF-8: {}", &path_params["id"])))
                                        .expect("Unable to create Bad Request response for invalid percent decode"))
                };

                                let result = api_impl.delete_province(
                                            param_id,
                                        &context
                                    ).await;
                                let mut response = Response::new(Body::empty());
                                response.headers_mut().insert(
                                            HeaderName::from_static("x-span-id"),
                                            HeaderValue::from_str((&context as &dyn Has<XSpanIdString>).get().0.clone().to_string().as_str())
                                                .expect("Unable to create X-Span-ID header value"));

                                        match result {
                                            Ok(rsp) => match rsp {
                                                DeleteProvinceResponse::SuccessfulOperation
                                                => {
                                                    *response.status_mut() = StatusCode::from_u16(204).expect("Unable to turn 204 into a StatusCode");
                                                },
                                                DeleteProvinceResponse::InvalidIDSupplied
                                                => {
                                                    *response.status_mut() = StatusCode::from_u16(400).expect("Unable to turn 400 into a StatusCode");
                                                },
                                                DeleteProvinceResponse::ProvinceNotFound
                                                => {
                                                    *response.status_mut() = StatusCode::from_u16(404).expect("Unable to turn 404 into a StatusCode");
                                                },
                                            },
                                            Err(_) => {
                                                // Application code returned an error. This should not happen, as the implementation should
                                                // return a valid response.
                                                *response.status_mut() = StatusCode::INTERNAL_SERVER_ERROR;
                                                *response.body_mut() = Body::from("An internal error occurred");
                                            },
                                        }

                                        Ok(response)
            },

            // GetProvinceById - GET /query-api/catholic-polity-service/provinces/{id}
            &hyper::Method::GET if path.matched(paths::ID_QUERY_API_CATHOLIC_POLITY_SERVICE_PROVINCES_ID) => {
                {
                    let authorization = match (&context as &dyn Has<Option<Authorization>>).get() {
                        &Some(ref authorization) => authorization,
                        &None => return Ok(Response::builder()
                                                .status(StatusCode::FORBIDDEN)
                                                .body(Body::from("Unauthenticated"))
                                                .expect("Unable to create Authentication Forbidden response")),
                    };
                }

                // Path parameters
                let path: &str = &uri.path().to_string();
                let path_params =
                    paths::REGEX_QUERY_API_CATHOLIC_POLITY_SERVICE_PROVINCES_ID
                    .captures(&path)
                    .unwrap_or_else(||
                        panic!("Path {} matched RE QUERY_API_CATHOLIC_POLITY_SERVICE_PROVINCES_ID in set but failed match against \"{}\"", path, paths::REGEX_QUERY_API_CATHOLIC_POLITY_SERVICE_PROVINCES_ID.as_str())
                    );

                let param_id = match percent_encoding::percent_decode(path_params["id"].as_bytes()).decode_utf8() {
                    Ok(param_id) => match param_id.parse::<uuid::Uuid>() {
                        Ok(param_id) => param_id,
                        Err(e) => return Ok(Response::builder()
                                        .status(StatusCode::BAD_REQUEST)
                                        .body(Body::from(format!("Couldn't parse path parameter id: {}", e)))
                                        .expect("Unable to create Bad Request response for invalid path parameter")),
                    },
                    Err(_) => return Ok(Response::builder()
                                        .status(StatusCode::BAD_REQUEST)
                                        .body(Body::from(format!("Couldn't percent-decode path parameter as UTF-8: {}", &path_params["id"])))
                                        .expect("Unable to create Bad Request response for invalid percent decode"))
                };

                                let result = api_impl.get_province_by_id(
                                            param_id,
                                        &context
                                    ).await;
                                let mut response = Response::new(Body::empty());
                                response.headers_mut().insert(
                                            HeaderName::from_static("x-span-id"),
                                            HeaderValue::from_str((&context as &dyn Has<XSpanIdString>).get().0.clone().to_string().as_str())
                                                .expect("Unable to create X-Span-ID header value"));

                                        match result {
                                            Ok(rsp) => match rsp {
                                                GetProvinceByIdResponse::SuccessfulOperation
                                                    (body)
                                                => {
                                                    *response.status_mut() = StatusCode::from_u16(200).expect("Unable to turn 200 into a StatusCode");
                                                    response.headers_mut().insert(
                                                        CONTENT_TYPE,
                                                        HeaderValue::from_str("application/json")
                                                            .expect("Unable to create Content-Type header for GET_PROVINCE_BY_ID_SUCCESSFUL_OPERATION"));
                                                    let body = serde_json::to_string(&body).expect("impossible to fail to serialize");
                                                    *response.body_mut() = Body::from(body);
                                                },
                                                GetProvinceByIdResponse::InvalidIDSupplied
                                                => {
                                                    *response.status_mut() = StatusCode::from_u16(400).expect("Unable to turn 400 into a StatusCode");
                                                },
                                                GetProvinceByIdResponse::ProvinceNotFound
                                                => {
                                                    *response.status_mut() = StatusCode::from_u16(404).expect("Unable to turn 404 into a StatusCode");
                                                },
                                            },
                                            Err(_) => {
                                                // Application code returned an error. This should not happen, as the implementation should
                                                // return a valid response.
                                                *response.status_mut() = StatusCode::INTERNAL_SERVER_ERROR;
                                                *response.body_mut() = Body::from("An internal error occurred");
                                            },
                                        }

                                        Ok(response)
            },

            // GetProvinces - GET /query-api/catholic-polity-service/provinces
            &hyper::Method::GET if path.matched(paths::ID_QUERY_API_CATHOLIC_POLITY_SERVICE_PROVINCES) => {
                {
                    let authorization = match (&context as &dyn Has<Option<Authorization>>).get() {
                        &Some(ref authorization) => authorization,
                        &None => return Ok(Response::builder()
                                                .status(StatusCode::FORBIDDEN)
                                                .body(Body::from("Unauthenticated"))
                                                .expect("Unable to create Authentication Forbidden response")),
                    };
                }

                // Query parameters (note that non-required or collection query parameters will ignore garbage values, rather than causing a 400 response)
                let query_params = form_urlencoded::parse(uri.query().unwrap_or_default().as_bytes()).collect::<Vec<_>>();
                let param_name = query_params.iter().filter(|e| e.0 == "name").map(|e| e.1.to_owned())
                    .nth(0);
                let param_name = match param_name {
                    Some(param_name) => {
                        let param_name =
                            <String as std::str::FromStr>::from_str
                                (&param_name);
                        match param_name {
                            Ok(param_name) => Some(param_name),
                            Err(e) => return Ok(Response::builder()
                                .status(StatusCode::BAD_REQUEST)
                                .body(Body::from(format!("Couldn't parse query parameter name - doesn't match schema: {}", e)))
                                .expect("Unable to create Bad Request response for invalid query parameter name")),
                        }
                    },
                    None => None,
                };
                let param_province_code = query_params.iter().filter(|e| e.0 == "provinceCode").map(|e| e.1.to_owned())
                    .nth(0);
                let param_province_code = match param_province_code {
                    Some(param_province_code) => {
                        let param_province_code =
                            <models::Code as std::str::FromStr>::from_str
                                (&param_province_code);
                        match param_province_code {
                            Ok(param_province_code) => Some(param_province_code),
                            Err(e) => return Ok(Response::builder()
                                .status(StatusCode::BAD_REQUEST)
                                .body(Body::from(format!("Couldn't parse query parameter provinceCode - doesn't match schema: {}", e)))
                                .expect("Unable to create Bad Request response for invalid query parameter provinceCode")),
                        }
                    },
                    None => None,
                };
                let param_offset = query_params.iter().filter(|e| e.0 == "offset").map(|e| e.1.to_owned())
                    .nth(0);
                let param_offset = match param_offset {
                    Some(param_offset) => {
                        let param_offset =
                            <i32 as std::str::FromStr>::from_str
                                (&param_offset);
                        match param_offset {
                            Ok(param_offset) => Some(param_offset),
                            Err(e) => return Ok(Response::builder()
                                .status(StatusCode::BAD_REQUEST)
                                .body(Body::from(format!("Couldn't parse query parameter offset - doesn't match schema: {}", e)))
                                .expect("Unable to create Bad Request response for invalid query parameter offset")),
                        }
                    },
                    None => None,
                };
                let param_count = query_params.iter().filter(|e| e.0 == "count").map(|e| e.1.to_owned())
                    .nth(0);
                let param_count = match param_count {
                    Some(param_count) => {
                        let param_count =
                            <i32 as std::str::FromStr>::from_str
                                (&param_count);
                        match param_count {
                            Ok(param_count) => Some(param_count),
                            Err(e) => return Ok(Response::builder()
                                .status(StatusCode::BAD_REQUEST)
                                .body(Body::from(format!("Couldn't parse query parameter count - doesn't match schema: {}", e)))
                                .expect("Unable to create Bad Request response for invalid query parameter count")),
                        }
                    },
                    None => None,
                };

                                let result = api_impl.get_provinces(
                                            param_name,
                                            param_province_code,
                                            param_offset,
                                            param_count,
                                        &context
                                    ).await;
                                let mut response = Response::new(Body::empty());
                                response.headers_mut().insert(
                                            HeaderName::from_static("x-span-id"),
                                            HeaderValue::from_str((&context as &dyn Has<XSpanIdString>).get().0.clone().to_string().as_str())
                                                .expect("Unable to create X-Span-ID header value"));

                                        match result {
                                            Ok(rsp) => match rsp {
                                                GetProvincesResponse::SuccessfulOperation
                                                    (body)
                                                => {
                                                    *response.status_mut() = StatusCode::from_u16(200).expect("Unable to turn 200 into a StatusCode");
                                                    response.headers_mut().insert(
                                                        CONTENT_TYPE,
                                                        HeaderValue::from_str("application/json")
                                                            .expect("Unable to create Content-Type header for GET_PROVINCES_SUCCESSFUL_OPERATION"));
                                                    let body = serde_json::to_string(&body).expect("impossible to fail to serialize");
                                                    *response.body_mut() = Body::from(body);
                                                },
                                                GetProvincesResponse::InvalidIDSupplied
                                                => {
                                                    *response.status_mut() = StatusCode::from_u16(400).expect("Unable to turn 400 into a StatusCode");
                                                },
                                                GetProvincesResponse::ProvinceNotFound
                                                => {
                                                    *response.status_mut() = StatusCode::from_u16(404).expect("Unable to turn 404 into a StatusCode");
                                                },
                                            },
                                            Err(_) => {
                                                // Application code returned an error. This should not happen, as the implementation should
                                                // return a valid response.
                                                *response.status_mut() = StatusCode::INTERNAL_SERVER_ERROR;
                                                *response.body_mut() = Body::from("An internal error occurred");
                                            },
                                        }

                                        Ok(response)
            },

            // UpdateProvince - PUT /mutation-api/catholic-polity-service/provinces/{id}
            &hyper::Method::PUT if path.matched(paths::ID_MUTATION_API_CATHOLIC_POLITY_SERVICE_PROVINCES_ID) => {
                {
                    let authorization = match (&context as &dyn Has<Option<Authorization>>).get() {
                        &Some(ref authorization) => authorization,
                        &None => return Ok(Response::builder()
                                                .status(StatusCode::FORBIDDEN)
                                                .body(Body::from("Unauthenticated"))
                                                .expect("Unable to create Authentication Forbidden response")),
                    };
                }

                // Path parameters
                let path: &str = &uri.path().to_string();
                let path_params =
                    paths::REGEX_MUTATION_API_CATHOLIC_POLITY_SERVICE_PROVINCES_ID
                    .captures(&path)
                    .unwrap_or_else(||
                        panic!("Path {} matched RE MUTATION_API_CATHOLIC_POLITY_SERVICE_PROVINCES_ID in set but failed match against \"{}\"", path, paths::REGEX_MUTATION_API_CATHOLIC_POLITY_SERVICE_PROVINCES_ID.as_str())
                    );

                let param_id = match percent_encoding::percent_decode(path_params["id"].as_bytes()).decode_utf8() {
                    Ok(param_id) => match param_id.parse::<uuid::Uuid>() {
                        Ok(param_id) => param_id,
                        Err(e) => return Ok(Response::builder()
                                        .status(StatusCode::BAD_REQUEST)
                                        .body(Body::from(format!("Couldn't parse path parameter id: {}", e)))
                                        .expect("Unable to create Bad Request response for invalid path parameter")),
                    },
                    Err(_) => return Ok(Response::builder()
                                        .status(StatusCode::BAD_REQUEST)
                                        .body(Body::from(format!("Couldn't percent-decode path parameter as UTF-8: {}", &path_params["id"])))
                                        .expect("Unable to create Bad Request response for invalid percent decode"))
                };

                // Body parameters (note that non-required body parameters will ignore garbage
                // values, rather than causing a 400 response). Produce warning header and logs for
                // any unused fields.
                let result = body.to_raw().await;
                match result {
                            Ok(body) => {
                                let mut unused_elements = Vec::new();
                                let param_province_mutation: Option<models::ProvinceMutation> = if !body.is_empty() {
                                    let deserializer = &mut serde_json::Deserializer::from_slice(&*body);
                                    match serde_ignored::deserialize(deserializer, |path| {
                                            warn!("Ignoring unknown field in body: {}", path);
                                            unused_elements.push(path.to_string());
                                    }) {
                                        Ok(param_province_mutation) => param_province_mutation,
                                        Err(_) => None,
                                    }
                                } else {
                                    None
                                };

                                let result = api_impl.update_province(
                                            param_id,
                                            param_province_mutation,
                                        &context
                                    ).await;
                                let mut response = Response::new(Body::empty());
                                response.headers_mut().insert(
                                            HeaderName::from_static("x-span-id"),
                                            HeaderValue::from_str((&context as &dyn Has<XSpanIdString>).get().0.clone().to_string().as_str())
                                                .expect("Unable to create X-Span-ID header value"));

                                        if !unused_elements.is_empty() {
                                            response.headers_mut().insert(
                                                HeaderName::from_static("warning"),
                                                HeaderValue::from_str(format!("Ignoring unknown fields in body: {:?}", unused_elements).as_str())
                                                    .expect("Unable to create Warning header value"));
                                        }

                                        match result {
                                            Ok(rsp) => match rsp {
                                                UpdateProvinceResponse::SuccessfulOperation
                                                    (body)
                                                => {
                                                    *response.status_mut() = StatusCode::from_u16(200).expect("Unable to turn 200 into a StatusCode");
                                                    response.headers_mut().insert(
                                                        CONTENT_TYPE,
                                                        HeaderValue::from_str("application/json")
                                                            .expect("Unable to create Content-Type header for UPDATE_PROVINCE_SUCCESSFUL_OPERATION"));
                                                    let body = serde_json::to_string(&body).expect("impossible to fail to serialize");
                                                    *response.body_mut() = Body::from(body);
                                                },
                                                UpdateProvinceResponse::InvalidIDSupplied
                                                => {
                                                    *response.status_mut() = StatusCode::from_u16(400).expect("Unable to turn 400 into a StatusCode");
                                                },
                                                UpdateProvinceResponse::ProvinceNotFound
                                                => {
                                                    *response.status_mut() = StatusCode::from_u16(404).expect("Unable to turn 404 into a StatusCode");
                                                },
                                                UpdateProvinceResponse::ValidationException
                                                => {
                                                    *response.status_mut() = StatusCode::from_u16(405).expect("Unable to turn 405 into a StatusCode");
                                                },
                                            },
                                            Err(_) => {
                                                // Application code returned an error. This should not happen, as the implementation should
                                                // return a valid response.
                                                *response.status_mut() = StatusCode::INTERNAL_SERVER_ERROR;
                                                *response.body_mut() = Body::from("An internal error occurred");
                                            },
                                        }

                                        Ok(response)
                            },
                            Err(e) => Ok(Response::builder()
                                                .status(StatusCode::BAD_REQUEST)
                                                .body(Body::from(format!("Couldn't read body parameter ProvinceMutation: {}", e)))
                                                .expect("Unable to create Bad Request response due to unable to read body parameter ProvinceMutation")),
                        }
            },

            _ if path.matched(paths::ID_MUTATION_API_CATHOLIC_POLITY_SERVICE_DEANERIES) => method_not_allowed(),
            _ if path.matched(paths::ID_MUTATION_API_CATHOLIC_POLITY_SERVICE_DEANERIES_ID) => method_not_allowed(),
            _ if path.matched(paths::ID_MUTATION_API_CATHOLIC_POLITY_SERVICE_DIOCESES) => method_not_allowed(),
            _ if path.matched(paths::ID_MUTATION_API_CATHOLIC_POLITY_SERVICE_DIOCESES_ID) => method_not_allowed(),
            _ if path.matched(paths::ID_MUTATION_API_CATHOLIC_POLITY_SERVICE_INSTITUTES) => method_not_allowed(),
            _ if path.matched(paths::ID_MUTATION_API_CATHOLIC_POLITY_SERVICE_INSTITUTES_ID) => method_not_allowed(),
            _ if path.matched(paths::ID_MUTATION_API_CATHOLIC_POLITY_SERVICE_PARISHES) => method_not_allowed(),
            _ if path.matched(paths::ID_MUTATION_API_CATHOLIC_POLITY_SERVICE_PARISHES_ID) => method_not_allowed(),
            _ if path.matched(paths::ID_MUTATION_API_CATHOLIC_POLITY_SERVICE_PROVINCES) => method_not_allowed(),
            _ if path.matched(paths::ID_MUTATION_API_CATHOLIC_POLITY_SERVICE_PROVINCES_ID) => method_not_allowed(),
            _ if path.matched(paths::ID_QUERY_API_CATHOLIC_POLITY_SERVICE_DEANERIES) => method_not_allowed(),
            _ if path.matched(paths::ID_QUERY_API_CATHOLIC_POLITY_SERVICE_DEANERIES_ID) => method_not_allowed(),
            _ if path.matched(paths::ID_QUERY_API_CATHOLIC_POLITY_SERVICE_DIOCESES) => method_not_allowed(),
            _ if path.matched(paths::ID_QUERY_API_CATHOLIC_POLITY_SERVICE_DIOCESES_ID) => method_not_allowed(),
            _ if path.matched(paths::ID_QUERY_API_CATHOLIC_POLITY_SERVICE_INSTITUTES) => method_not_allowed(),
            _ if path.matched(paths::ID_QUERY_API_CATHOLIC_POLITY_SERVICE_INSTITUTES_ID) => method_not_allowed(),
            _ if path.matched(paths::ID_QUERY_API_CATHOLIC_POLITY_SERVICE_PARISHES) => method_not_allowed(),
            _ if path.matched(paths::ID_QUERY_API_CATHOLIC_POLITY_SERVICE_PARISHES_ID) => method_not_allowed(),
            _ if path.matched(paths::ID_QUERY_API_CATHOLIC_POLITY_SERVICE_PROVINCES) => method_not_allowed(),
            _ if path.matched(paths::ID_QUERY_API_CATHOLIC_POLITY_SERVICE_PROVINCES_ID) => method_not_allowed(),
            _ => Ok(Response::builder().status(StatusCode::NOT_FOUND)
                    .body(Body::empty())
                    .expect("Unable to create Not Found response"))
        }
    } Box::pin(run(self.api_impl.clone(), req)) }
}

/// Request parser for `Api`.
pub struct ApiRequestParser;
impl<T> RequestParser<T> for ApiRequestParser {
    fn parse_operation_id(request: &Request<T>) -> Result<&'static str, ()> {
        let path = paths::GLOBAL_REGEX_SET.matches(request.uri().path());
        match request.method() {
            // AddDeanery - POST /mutation-api/catholic-polity-service/deaneries
            &hyper::Method::POST if path.matched(paths::ID_MUTATION_API_CATHOLIC_POLITY_SERVICE_DEANERIES) => Ok("AddDeanery"),
            // DeleteDeanery - DELETE /mutation-api/catholic-polity-service/deaneries/{id}
            &hyper::Method::DELETE if path.matched(paths::ID_MUTATION_API_CATHOLIC_POLITY_SERVICE_DEANERIES_ID) => Ok("DeleteDeanery"),
            // GetDeaneries - GET /query-api/catholic-polity-service/deaneries
            &hyper::Method::GET if path.matched(paths::ID_QUERY_API_CATHOLIC_POLITY_SERVICE_DEANERIES) => Ok("GetDeaneries"),
            // GetDeaneryById - GET /query-api/catholic-polity-service/deaneries/{id}
            &hyper::Method::GET if path.matched(paths::ID_QUERY_API_CATHOLIC_POLITY_SERVICE_DEANERIES_ID) => Ok("GetDeaneryById"),
            // UpdateDeanery - PUT /mutation-api/catholic-polity-service/deaneries/{id}
            &hyper::Method::PUT if path.matched(paths::ID_MUTATION_API_CATHOLIC_POLITY_SERVICE_DEANERIES_ID) => Ok("UpdateDeanery"),
            // AddDiocese - POST /mutation-api/catholic-polity-service/dioceses
            &hyper::Method::POST if path.matched(paths::ID_MUTATION_API_CATHOLIC_POLITY_SERVICE_DIOCESES) => Ok("AddDiocese"),
            // DeleteDiocese - DELETE /mutation-api/catholic-polity-service/dioceses/{id}
            &hyper::Method::DELETE if path.matched(paths::ID_MUTATION_API_CATHOLIC_POLITY_SERVICE_DIOCESES_ID) => Ok("DeleteDiocese"),
            // GetDioceseById - GET /query-api/catholic-polity-service/dioceses/{id}
            &hyper::Method::GET if path.matched(paths::ID_QUERY_API_CATHOLIC_POLITY_SERVICE_DIOCESES_ID) => Ok("GetDioceseById"),
            // GetDioceses - GET /query-api/catholic-polity-service/dioceses
            &hyper::Method::GET if path.matched(paths::ID_QUERY_API_CATHOLIC_POLITY_SERVICE_DIOCESES) => Ok("GetDioceses"),
            // UpdateDiocese - PUT /mutation-api/catholic-polity-service/dioceses/{id}
            &hyper::Method::PUT if path.matched(paths::ID_MUTATION_API_CATHOLIC_POLITY_SERVICE_DIOCESES_ID) => Ok("UpdateDiocese"),
            // AddInstitute - POST /mutation-api/catholic-polity-service/institutes
            &hyper::Method::POST if path.matched(paths::ID_MUTATION_API_CATHOLIC_POLITY_SERVICE_INSTITUTES) => Ok("AddInstitute"),
            // DeleteInstitute - DELETE /mutation-api/catholic-polity-service/institutes/{id}
            &hyper::Method::DELETE if path.matched(paths::ID_MUTATION_API_CATHOLIC_POLITY_SERVICE_INSTITUTES_ID) => Ok("DeleteInstitute"),
            // GetInstituteById - GET /query-api/catholic-polity-service/institutes/{id}
            &hyper::Method::GET if path.matched(paths::ID_QUERY_API_CATHOLIC_POLITY_SERVICE_INSTITUTES_ID) => Ok("GetInstituteById"),
            // GetInstitutes - GET /query-api/catholic-polity-service/institutes
            &hyper::Method::GET if path.matched(paths::ID_QUERY_API_CATHOLIC_POLITY_SERVICE_INSTITUTES) => Ok("GetInstitutes"),
            // UpdateInstitute - PUT /mutation-api/catholic-polity-service/institutes/{id}
            &hyper::Method::PUT if path.matched(paths::ID_MUTATION_API_CATHOLIC_POLITY_SERVICE_INSTITUTES_ID) => Ok("UpdateInstitute"),
            // AddParish - POST /mutation-api/catholic-polity-service/parishes
            &hyper::Method::POST if path.matched(paths::ID_MUTATION_API_CATHOLIC_POLITY_SERVICE_PARISHES) => Ok("AddParish"),
            // DeleteParish - DELETE /mutation-api/catholic-polity-service/parishes/{id}
            &hyper::Method::DELETE if path.matched(paths::ID_MUTATION_API_CATHOLIC_POLITY_SERVICE_PARISHES_ID) => Ok("DeleteParish"),
            // GetParishById - GET /query-api/catholic-polity-service/parishes/{id}
            &hyper::Method::GET if path.matched(paths::ID_QUERY_API_CATHOLIC_POLITY_SERVICE_PARISHES_ID) => Ok("GetParishById"),
            // GetParishes - GET /query-api/catholic-polity-service/parishes
            &hyper::Method::GET if path.matched(paths::ID_QUERY_API_CATHOLIC_POLITY_SERVICE_PARISHES) => Ok("GetParishes"),
            // UpdateParish - PUT /mutation-api/catholic-polity-service/parishes/{id}
            &hyper::Method::PUT if path.matched(paths::ID_MUTATION_API_CATHOLIC_POLITY_SERVICE_PARISHES_ID) => Ok("UpdateParish"),
            // AddProvince - POST /mutation-api/catholic-polity-service/provinces
            &hyper::Method::POST if path.matched(paths::ID_MUTATION_API_CATHOLIC_POLITY_SERVICE_PROVINCES) => Ok("AddProvince"),
            // DeleteProvince - DELETE /mutation-api/catholic-polity-service/provinces/{id}
            &hyper::Method::DELETE if path.matched(paths::ID_MUTATION_API_CATHOLIC_POLITY_SERVICE_PROVINCES_ID) => Ok("DeleteProvince"),
            // GetProvinceById - GET /query-api/catholic-polity-service/provinces/{id}
            &hyper::Method::GET if path.matched(paths::ID_QUERY_API_CATHOLIC_POLITY_SERVICE_PROVINCES_ID) => Ok("GetProvinceById"),
            // GetProvinces - GET /query-api/catholic-polity-service/provinces
            &hyper::Method::GET if path.matched(paths::ID_QUERY_API_CATHOLIC_POLITY_SERVICE_PROVINCES) => Ok("GetProvinces"),
            // UpdateProvince - PUT /mutation-api/catholic-polity-service/provinces/{id}
            &hyper::Method::PUT if path.matched(paths::ID_MUTATION_API_CATHOLIC_POLITY_SERVICE_PROVINCES_ID) => Ok("UpdateProvince"),
            _ => Err(()),
        }
    }
}
