# province_api

All URIs are relative to *https://dev-sg.portal.hocvienconggiao.com*

Method | HTTP request | Description
------------- | ------------- | -------------
**addProvince**](province_api.md#addProvince) | **POST** /mutation-api/catholic-polity-service/provinces | Add new province
**deleteProvince**](province_api.md#deleteProvince) | **DELETE** /mutation-api/catholic-polity-service/provinces/{id} | Delete province by ID
**getProvinceById**](province_api.md#getProvinceById) | **GET** /query-api/catholic-polity-service/provinces/{id} | Find province by ID
**getProvinces**](province_api.md#getProvinces) | **GET** /query-api/catholic-polity-service/provinces | Get all provinces
**updateProvince**](province_api.md#updateProvince) | **PUT** /mutation-api/catholic-polity-service/provinces/{id} | Update an existing province


# **addProvince**
> models::ProvinceMutation addProvince(ctx, optional)
Add new province

### Required Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **ctx** | **context.Context** | context containing the authentication | nil if no authentication
 **optional** | **map[string]interface{}** | optional parameters | nil if no parameters

### Optional Parameters
Optional parameters are passed through a map[string]interface{}.

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **province_mutation** | [**ProvinceMutation**](ProvinceMutation.md)|  | 

### Return type

[**models::ProvinceMutation**](ProvinceMutation.md)

### Authorization

[polity_auth](../README.md#polity_auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **deleteProvince**
> deleteProvince(ctx, id)
Delete province by ID

### Required Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **ctx** | **context.Context** | context containing the authentication | nil if no authentication
  **id** | [****](.md)| ID of province to delete | 

### Return type

 (empty response body)

### Authorization

[polity_auth](../README.md#polity_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **getProvinceById**
> models::ProvinceView getProvinceById(ctx, id)
Find province by ID

Returns a single province

### Required Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **ctx** | **context.Context** | context containing the authentication | nil if no authentication
  **id** | [****](.md)| ID of province to return | 

### Return type

[**models::ProvinceView**](ProvinceView.md)

### Authorization

[polity_auth](../README.md#polity_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **getProvinces**
> models::ProvinceCollection getProvinces(ctx, optional)
Get all provinces

Returns all provinces

### Required Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **ctx** | **context.Context** | context containing the authentication | nil if no authentication
 **optional** | **map[string]interface{}** | optional parameters | nil if no parameters

### Optional Parameters
Optional parameters are passed through a map[string]interface{}.

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **name** | **String**|  | 
 **province_code** | [****](.md)|  | 
 **offset** | **i32**| The number of provinces to skip before starting to collect the result set. | 
 **count** | **i32**| The number of provinces to return. | [default to 20]

### Return type

[**models::ProvinceCollection**](ProvinceCollection.md)

### Authorization

[polity_auth](../README.md#polity_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **updateProvince**
> models::ProvinceMutation updateProvince(ctx, id, optional)
Update an existing province

### Required Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **ctx** | **context.Context** | context containing the authentication | nil if no authentication
  **id** | [****](.md)| ID of province to update | 
 **optional** | **map[string]interface{}** | optional parameters | nil if no parameters

### Optional Parameters
Optional parameters are passed through a map[string]interface{}.

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | [****](.md)| ID of province to update | 
 **province_mutation** | [**ProvinceMutation**](ProvinceMutation.md)|  | 

### Return type

[**models::ProvinceMutation**](ProvinceMutation.md)

### Authorization

[polity_auth](../README.md#polity_auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

