# parish_api

All URIs are relative to *https://dev-sg.portal.hocvienconggiao.com*

Method | HTTP request | Description
------------- | ------------- | -------------
**addParish**](parish_api.md#addParish) | **POST** /mutation-api/catholic-polity-service/parishes | Add new parish
**deleteParish**](parish_api.md#deleteParish) | **DELETE** /mutation-api/catholic-polity-service/parishes/{id} | Delete parish by ID
**getParishById**](parish_api.md#getParishById) | **GET** /query-api/catholic-polity-service/parishes/{id} | Find parish by ID
**getParishes**](parish_api.md#getParishes) | **GET** /query-api/catholic-polity-service/parishes | Get all parishes
**updateParish**](parish_api.md#updateParish) | **PUT** /mutation-api/catholic-polity-service/parishes/{id} | Update an existing parish


# **addParish**
> models::ParishMutation addParish(ctx, optional)
Add new parish

### Required Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **ctx** | **context.Context** | context containing the authentication | nil if no authentication
 **optional** | **map[string]interface{}** | optional parameters | nil if no parameters

### Optional Parameters
Optional parameters are passed through a map[string]interface{}.

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **parish_mutation** | [**ParishMutation**](ParishMutation.md)|  | 

### Return type

[**models::ParishMutation**](ParishMutation.md)

### Authorization

[polity_auth](../README.md#polity_auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **deleteParish**
> deleteParish(ctx, id)
Delete parish by ID

### Required Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **ctx** | **context.Context** | context containing the authentication | nil if no authentication
  **id** | [****](.md)| ID of parish to delete | 

### Return type

 (empty response body)

### Authorization

[polity_auth](../README.md#polity_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **getParishById**
> models::ParishView getParishById(ctx, id)
Find parish by ID

Returns a single parish

### Required Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **ctx** | **context.Context** | context containing the authentication | nil if no authentication
  **id** | [****](.md)| ID of parish to return | 

### Return type

[**models::ParishView**](ParishView.md)

### Authorization

[polity_auth](../README.md#polity_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **getParishes**
> models::ParishCollection getParishes(ctx, optional)
Get all parishes

Returns all parishes

### Required Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **ctx** | **context.Context** | context containing the authentication | nil if no authentication
 **optional** | **map[string]interface{}** | optional parameters | nil if no parameters

### Optional Parameters
Optional parameters are passed through a map[string]interface{}.

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **deanery_id** | [****](.md)|  | 
 **diocese_id** | [****](.md)|  | 
 **name** | **String**|  | 
 **offset** | **i32**| The number of parishes to skip before starting to collect the result set. | 
 **count** | **i32**| The number of parishes to return. | [default to 20]

### Return type

[**models::ParishCollection**](ParishCollection.md)

### Authorization

[polity_auth](../README.md#polity_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **updateParish**
> models::ParishMutation updateParish(ctx, id, optional)
Update an existing parish

### Required Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **ctx** | **context.Context** | context containing the authentication | nil if no authentication
  **id** | [****](.md)| ID of parish to update | 
 **optional** | **map[string]interface{}** | optional parameters | nil if no parameters

### Optional Parameters
Optional parameters are passed through a map[string]interface{}.

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | [****](.md)| ID of parish to update | 
 **parish_mutation** | [**ParishMutation**](ParishMutation.md)|  | 

### Return type

[**models::ParishMutation**](ParishMutation.md)

### Authorization

[polity_auth](../README.md#polity_auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

