# institute_api

All URIs are relative to *https://dev-sg.portal.hocvienconggiao.com*

Method | HTTP request | Description
------------- | ------------- | -------------
**addInstitute**](institute_api.md#addInstitute) | **POST** /mutation-api/catholic-polity-service/institutes | Add new institute
**deleteInstitute**](institute_api.md#deleteInstitute) | **DELETE** /mutation-api/catholic-polity-service/institutes/{id} | Delete institute by ID
**getInstituteById**](institute_api.md#getInstituteById) | **GET** /query-api/catholic-polity-service/institutes/{id} | Find institute by ID
**getInstitutes**](institute_api.md#getInstitutes) | **GET** /query-api/catholic-polity-service/institutes | Get institutes
**updateInstitute**](institute_api.md#updateInstitute) | **PUT** /mutation-api/catholic-polity-service/institutes/{id} | Update an existing institute


# **addInstitute**
> models::InstituteMutation addInstitute(ctx, institute_mutation)
Add new institute

### Required Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **ctx** | **context.Context** | context containing the authentication | nil if no authentication
  **institute_mutation** | [**InstituteMutation**](InstituteMutation.md)| Institute object that needs to be added to the database | 

### Return type

[**models::InstituteMutation**](InstituteMutation.md)

### Authorization

[polity_auth](../README.md#polity_auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **deleteInstitute**
> deleteInstitute(ctx, id)
Delete institute by ID

### Required Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **ctx** | **context.Context** | context containing the authentication | nil if no authentication
  **id** | [****](.md)| ID of institute to delete | 

### Return type

 (empty response body)

### Authorization

[polity_auth](../README.md#polity_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **getInstituteById**
> models::InstituteView getInstituteById(ctx, id)
Find institute by ID

Returns a single institute

### Required Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **ctx** | **context.Context** | context containing the authentication | nil if no authentication
  **id** | [****](.md)| ID of institute to return | 

### Return type

[**models::InstituteView**](InstituteView.md)

### Authorization

[polity_auth](../README.md#polity_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **getInstitutes**
> models::InstituteCollection getInstitutes(ctx, optional)
Get institutes

Returns all institutes

### Required Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **ctx** | **context.Context** | context containing the authentication | nil if no authentication
 **optional** | **map[string]interface{}** | optional parameters | nil if no parameters

### Optional Parameters
Optional parameters are passed through a map[string]interface{}.

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **name** | **String**|  | 
 **location_name** | **String**|  | 
 **location_address** | **String**|  | 
 **location_email** | **String**|  | 
 **person_in_charge** | **String**|  | 
 **sorts** | [**models::InstituteSortCriteria**](models::InstituteSortCriteria.md)|  | 
 **offset** | **i32**| The number of institutes to skip before starting to collect the result set. | 
 **count** | **i32**| The number of institutes to return. | [default to 20]

### Return type

[**models::InstituteCollection**](InstituteCollection.md)

### Authorization

[polity_auth](../README.md#polity_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **updateInstitute**
> models::InstituteMutation updateInstitute(ctx, id, institute_mutation)
Update an existing institute

### Required Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **ctx** | **context.Context** | context containing the authentication | nil if no authentication
  **id** | [****](.md)| ID of institute to update | 
  **institute_mutation** | [**InstituteMutation**](InstituteMutation.md)| Institute object that needs to be added to the database | 

### Return type

[**models::InstituteMutation**](InstituteMutation.md)

### Authorization

[polity_auth](../README.md#polity_auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

