# diocese_api

All URIs are relative to *https://dev-sg.portal.hocvienconggiao.com*

Method | HTTP request | Description
------------- | ------------- | -------------
**addDiocese**](diocese_api.md#addDiocese) | **POST** /mutation-api/catholic-polity-service/dioceses | Add new diocese
**deleteDiocese**](diocese_api.md#deleteDiocese) | **DELETE** /mutation-api/catholic-polity-service/dioceses/{id} | Delete diocese by ID
**getDioceseById**](diocese_api.md#getDioceseById) | **GET** /query-api/catholic-polity-service/dioceses/{id} | Find diocese by ID
**getDioceses**](diocese_api.md#getDioceses) | **GET** /query-api/catholic-polity-service/dioceses | Get all dioceses
**updateDiocese**](diocese_api.md#updateDiocese) | **PUT** /mutation-api/catholic-polity-service/dioceses/{id} | Update an existing diocese


# **addDiocese**
> models::DioceseMutation addDiocese(ctx, diocese_mutation)
Add new diocese

### Required Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **ctx** | **context.Context** | context containing the authentication | nil if no authentication
  **diocese_mutation** | [**DioceseMutation**](DioceseMutation.md)| Diocese object that needs to be added to the database | 

### Return type

[**models::DioceseMutation**](DioceseMutation.md)

### Authorization

[polity_auth](../README.md#polity_auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **deleteDiocese**
> deleteDiocese(ctx, id)
Delete diocese by ID

### Required Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **ctx** | **context.Context** | context containing the authentication | nil if no authentication
  **id** | [****](.md)| ID of diocese to delete | 

### Return type

 (empty response body)

### Authorization

[polity_auth](../README.md#polity_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **getDioceseById**
> models::DioceseView getDioceseById(ctx, id)
Find diocese by ID

Returns a single diocese

### Required Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **ctx** | **context.Context** | context containing the authentication | nil if no authentication
  **id** | [****](.md)| ID of diocese to return | 

### Return type

[**models::DioceseView**](DioceseView.md)

### Authorization

[polity_auth](../README.md#polity_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **getDioceses**
> models::DioceseCollection getDioceses(ctx, optional)
Get all dioceses

Returns all dioceses

### Required Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **ctx** | **context.Context** | context containing the authentication | nil if no authentication
 **optional** | **map[string]interface{}** | optional parameters | nil if no parameters

### Optional Parameters
Optional parameters are passed through a map[string]interface{}.

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **province_id** | [****](.md)|  | 
 **province_code** | [****](.md)|  | 
 **province_name** | **String**|  | 
 **name** | **String**|  | 
 **location_name** | **String**|  | 
 **location_address** | **String**|  | 
 **location_email** | **String**|  | 
 **person_in_charge** | **String**|  | 
 **sorts** | [**models::DioceseSortCriteria**](models::DioceseSortCriteria.md)|  | 
 **offset** | **i32**| The number of dioceses to skip before starting to collect the result set. | 
 **count** | **i32**| The number of dioceses to return. | [default to 20]

### Return type

[**models::DioceseCollection**](DioceseCollection.md)

### Authorization

[polity_auth](../README.md#polity_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **updateDiocese**
> models::DioceseMutation updateDiocese(ctx, id, diocese_mutation)
Update an existing diocese

### Required Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **ctx** | **context.Context** | context containing the authentication | nil if no authentication
  **id** | [****](.md)| ID of diocese to update | 
  **diocese_mutation** | [**DioceseMutation**](DioceseMutation.md)| Diocese object that needs to be added to the database | 

### Return type

[**models::DioceseMutation**](DioceseMutation.md)

### Authorization

[polity_auth](../README.md#polity_auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

