# deanery_api

All URIs are relative to *https://dev-sg.portal.hocvienconggiao.com*

Method | HTTP request | Description
------------- | ------------- | -------------
**addDeanery**](deanery_api.md#addDeanery) | **POST** /mutation-api/catholic-polity-service/deaneries | Add new deanery
**deleteDeanery**](deanery_api.md#deleteDeanery) | **DELETE** /mutation-api/catholic-polity-service/deaneries/{id} | Delete deanery by ID
**getDeaneries**](deanery_api.md#getDeaneries) | **GET** /query-api/catholic-polity-service/deaneries | Get deaneries
**getDeaneryById**](deanery_api.md#getDeaneryById) | **GET** /query-api/catholic-polity-service/deaneries/{id} | Find deanery by ID
**updateDeanery**](deanery_api.md#updateDeanery) | **PUT** /mutation-api/catholic-polity-service/deaneries/{id} | Update an existing deanery


# **addDeanery**
> models::DeaneryMutation addDeanery(ctx, deanery_mutation)
Add new deanery

### Required Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **ctx** | **context.Context** | context containing the authentication | nil if no authentication
  **deanery_mutation** | [**DeaneryMutation**](DeaneryMutation.md)| Parish object that needs to be added to the database | 

### Return type

[**models::DeaneryMutation**](DeaneryMutation.md)

### Authorization

[polity_auth](../README.md#polity_auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **deleteDeanery**
> deleteDeanery(ctx, id)
Delete deanery by ID

### Required Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **ctx** | **context.Context** | context containing the authentication | nil if no authentication
  **id** | [****](.md)| ID of deanery to delete | 

### Return type

 (empty response body)

### Authorization

[polity_auth](../README.md#polity_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **getDeaneries**
> models::DeaneryCollection getDeaneries(ctx, optional)
Get deaneries

Returns all deaneries

### Required Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **ctx** | **context.Context** | context containing the authentication | nil if no authentication
 **optional** | **map[string]interface{}** | optional parameters | nil if no parameters

### Optional Parameters
Optional parameters are passed through a map[string]interface{}.

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **diocese_id** | [****](.md)|  | 
 **name** | **String**|  | 
 **offset** | **i32**| The number of deaneries to skip before starting to collect the result set. | 
 **count** | **i32**| The number of deaneries to return. | [default to 20]

### Return type

[**models::DeaneryCollection**](DeaneryCollection.md)

### Authorization

[polity_auth](../README.md#polity_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **getDeaneryById**
> models::DeaneryView getDeaneryById(ctx, id)
Find deanery by ID

Returns a single deanery

### Required Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **ctx** | **context.Context** | context containing the authentication | nil if no authentication
  **id** | [****](.md)| ID of deanery to return | 

### Return type

[**models::DeaneryView**](DeaneryView.md)

### Authorization

[polity_auth](../README.md#polity_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **updateDeanery**
> models::DeaneryMutation updateDeanery(ctx, id, deanery_mutation)
Update an existing deanery

### Required Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **ctx** | **context.Context** | context containing the authentication | nil if no authentication
  **id** | [****](.md)| ID of deanery to update | 
  **deanery_mutation** | [**DeaneryMutation**](DeaneryMutation.md)| Parish object that needs to be added to the database | 

### Return type

[**models::DeaneryMutation**](DeaneryMutation.md)

### Authorization

[polity_auth](../README.md#polity_auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

