# Rust API for hvcg_governance_openapi_catholic-polity

This is a server for Catholic Polity info.

## Overview

This client/server was generated by the [openapi-generator]
(https://openapi-generator.tech) project.  By using the
[OpenAPI-Spec](https://github.com/OAI/OpenAPI-Specification) from a remote
server, you can easily generate a server stub.

To see how to make this your own, look here:

[README]((https://openapi-generator.tech))

- API version: 0.11.0
- Build date: 2021-11-08T08:22:53.842619534Z[Etc/UTC]



This autogenerated project defines an API crate `hvcg_governance_openapi_catholic-polity` which contains:
* An `Api` trait defining the API in Rust.
* Data types representing the underlying data model.
* A `Client` type which implements `Api` and issues HTTP requests for each operation.
* A router which accepts HTTP requests and invokes the appropriate `Api` method for each operation.

It also contains an example server and client which make use of `hvcg_governance_openapi_catholic-polity`:

* The example server starts up a web server using the `hvcg_governance_openapi_catholic-polity`
    router, and supplies a trivial implementation of `Api` which returns failure
    for every operation.
* The example client provides a CLI which lets you invoke
    any single operation on the `hvcg_governance_openapi_catholic-polity` client by passing appropriate
    arguments on the command line.

You can use the example server and client as a basis for your own code.
See below for [more detail on implementing a server](#writing-a-server).

## Examples

Run examples with:

```
cargo run --example <example-name>
```

To pass in arguments to the examples, put them after `--`, for example:

```
cargo run --example client -- --help
```

### Running the example server
To run the server, follow these simple steps:

```
cargo run --example server
```

### Running the example client
To run a client, follow one of the following simple steps:

```
cargo run --example client DeleteDeanery
cargo run --example client GetDeaneries
cargo run --example client GetDeaneryById
cargo run --example client DeleteDiocese
cargo run --example client GetDioceseById
cargo run --example client GetDioceses
cargo run --example client DeleteInstitute
cargo run --example client GetInstituteById
cargo run --example client GetInstitutes
cargo run --example client AddParish
cargo run --example client DeleteParish
cargo run --example client GetParishById
cargo run --example client GetParishes
cargo run --example client UpdateParish
cargo run --example client AddProvince
cargo run --example client DeleteProvince
cargo run --example client GetProvinceById
cargo run --example client GetProvinces
cargo run --example client UpdateProvince
```

### HTTPS
The examples can be run in HTTPS mode by passing in the flag `--https`, for example:

```
cargo run --example server -- --https
```

This will use the keys/certificates from the examples directory. Note that the
server chain is signed with `CN=localhost`.

## Using the generated library

The generated library has a few optional features that can be activated through Cargo.

* `server`
    * This defaults to enabled and creates the basic skeleton of a server implementation based on hyper
    * To create the server stack you'll need to provide an implementation of the API trait to provide the server function.
* `client`
    * This defaults to enabled and creates the basic skeleton of a client implementation based on hyper
    * The constructed client implements the API trait by making remote API call.
* `conversions`
    * This defaults to disabled and creates extra derives on models to allow "transmogrification" between objects of structurally similar types.

See https://doc.rust-lang.org/cargo/reference/manifest.html#the-features-section for how to use features in your `Cargo.toml`.

## Documentation for API Endpoints

All URIs are relative to *https://dev-sg.portal.hocvienconggiao.com*

Method | HTTP request | Description
------------- | ------------- | -------------
[**addDeanery**](docs/deanery_api.md#addDeanery) | **POST** /mutation-api/catholic-polity-service/deaneries | Add new deanery
[**deleteDeanery**](docs/deanery_api.md#deleteDeanery) | **DELETE** /mutation-api/catholic-polity-service/deaneries/{id} | Delete deanery by ID
[**getDeaneries**](docs/deanery_api.md#getDeaneries) | **GET** /query-api/catholic-polity-service/deaneries | Get deaneries
[**getDeaneryById**](docs/deanery_api.md#getDeaneryById) | **GET** /query-api/catholic-polity-service/deaneries/{id} | Find deanery by ID
[**updateDeanery**](docs/deanery_api.md#updateDeanery) | **PUT** /mutation-api/catholic-polity-service/deaneries/{id} | Update an existing deanery
[**addDiocese**](docs/diocese_api.md#addDiocese) | **POST** /mutation-api/catholic-polity-service/dioceses | Add new diocese
[**deleteDiocese**](docs/diocese_api.md#deleteDiocese) | **DELETE** /mutation-api/catholic-polity-service/dioceses/{id} | Delete diocese by ID
[**getDioceseById**](docs/diocese_api.md#getDioceseById) | **GET** /query-api/catholic-polity-service/dioceses/{id} | Find diocese by ID
[**getDioceses**](docs/diocese_api.md#getDioceses) | **GET** /query-api/catholic-polity-service/dioceses | Get all dioceses
[**updateDiocese**](docs/diocese_api.md#updateDiocese) | **PUT** /mutation-api/catholic-polity-service/dioceses/{id} | Update an existing diocese
[**addInstitute**](docs/institute_api.md#addInstitute) | **POST** /mutation-api/catholic-polity-service/institutes | Add new institute
[**deleteInstitute**](docs/institute_api.md#deleteInstitute) | **DELETE** /mutation-api/catholic-polity-service/institutes/{id} | Delete institute by ID
[**getInstituteById**](docs/institute_api.md#getInstituteById) | **GET** /query-api/catholic-polity-service/institutes/{id} | Find institute by ID
[**getInstitutes**](docs/institute_api.md#getInstitutes) | **GET** /query-api/catholic-polity-service/institutes | Get institutes
[**updateInstitute**](docs/institute_api.md#updateInstitute) | **PUT** /mutation-api/catholic-polity-service/institutes/{id} | Update an existing institute
[**addParish**](docs/parish_api.md#addParish) | **POST** /mutation-api/catholic-polity-service/parishes | Add new parish
[**deleteParish**](docs/parish_api.md#deleteParish) | **DELETE** /mutation-api/catholic-polity-service/parishes/{id} | Delete parish by ID
[**getParishById**](docs/parish_api.md#getParishById) | **GET** /query-api/catholic-polity-service/parishes/{id} | Find parish by ID
[**getParishes**](docs/parish_api.md#getParishes) | **GET** /query-api/catholic-polity-service/parishes | Get all parishes
[**updateParish**](docs/parish_api.md#updateParish) | **PUT** /mutation-api/catholic-polity-service/parishes/{id} | Update an existing parish
[**addProvince**](docs/province_api.md#addProvince) | **POST** /mutation-api/catholic-polity-service/provinces | Add new province
[**deleteProvince**](docs/province_api.md#deleteProvince) | **DELETE** /mutation-api/catholic-polity-service/provinces/{id} | Delete province by ID
[**getProvinceById**](docs/province_api.md#getProvinceById) | **GET** /query-api/catholic-polity-service/provinces/{id} | Find province by ID
[**getProvinces**](docs/province_api.md#getProvinces) | **GET** /query-api/catholic-polity-service/provinces | Get all provinces
[**updateProvince**](docs/province_api.md#updateProvince) | **PUT** /mutation-api/catholic-polity-service/provinces/{id} | Update an existing province


## Documentation For Models

 - [Code](docs/Code.md)
 - [DeaneryCollection](docs/DeaneryCollection.md)
 - [DeaneryMutation](docs/DeaneryMutation.md)
 - [DeaneryView](docs/DeaneryView.md)
 - [DioceseCollection](docs/DioceseCollection.md)
 - [DioceseMutation](docs/DioceseMutation.md)
 - [DioceseSortCriteria](docs/DioceseSortCriteria.md)
 - [DioceseView](docs/DioceseView.md)
 - [InstituteCollection](docs/InstituteCollection.md)
 - [InstituteMutation](docs/InstituteMutation.md)
 - [InstituteSortCriteria](docs/InstituteSortCriteria.md)
 - [InstituteView](docs/InstituteView.md)
 - [ParishCollection](docs/ParishCollection.md)
 - [ParishMutation](docs/ParishMutation.md)
 - [ParishView](docs/ParishView.md)
 - [Polity](docs/Polity.md)
 - [ProvinceCollection](docs/ProvinceCollection.md)
 - [ProvinceMutation](docs/ProvinceMutation.md)
 - [ProvinceView](docs/ProvinceView.md)


## Documentation For Authorization

## polity_auth
- **Type**: Bearer token authentication

Example
```
```

## Author



