# parish_api

All URIs are relative to *http://dev-sg.portal.hocvienconggiao.com*

Method | HTTP request | Description
------------- | ------------- | -------------
**add_parish**](parish_api.md#add_parish) | **POST** /mutation-api/parishes | Add new parish
**delete_parish**](parish_api.md#delete_parish) | **DELETE** /mutation-api/parish | Delete parish by ID
**get_parish_by_id**](parish_api.md#get_parish_by_id) | **GET** /query-api/parishes/{id} | Find parish by ID
**get_parishes**](parish_api.md#get_parishes) | **GET** /query-api/parishes | Get all parishes
**update_parish**](parish_api.md#update_parish) | **PUT** /mutation-api/parish | Update an existing parish


# **add_parish**
> models::Parish add_parish(ctx, optional)
Add new parish

### Required Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **ctx** | **context.Context** | context containing the authentication | nil if no authentication
 **optional** | **map[string]interface{}** | optional parameters | nil if no parameters

### Optional Parameters
Optional parameters are passed through a map[string]interface{}.

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **parish** | [**Parish**](Parish.md)|  | 

### Return type

[**models::Parish**](Parish.md)

### Authorization

[polity_auth](../README.md#polity_auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **delete_parish**
> delete_parish(ctx, )
Delete parish by ID

### Required Parameters
This endpoint does not need any parameter.

### Return type

 (empty response body)

### Authorization

[polity_auth](../README.md#polity_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_parish_by_id**
> models::Parish get_parish_by_id(ctx, id)
Find parish by ID

Returns a single parish

### Required Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **ctx** | **context.Context** | context containing the authentication | nil if no authentication
  **id** | [****](.md)| ID of parish to return | 

### Return type

[**models::Parish**](Parish.md)

### Authorization

[polity_auth](../README.md#polity_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_parishes**
> models::Parish get_parishes(ctx, optional)
Get all parishes

Returns all parishes

### Required Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **ctx** | **context.Context** | context containing the authentication | nil if no authentication
 **optional** | **map[string]interface{}** | optional parameters | nil if no parameters

### Optional Parameters
Optional parameters are passed through a map[string]interface{}.

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **diocese_name** | **String**|  | 
 **diocese_id** | [****](.md)|  | 
 **name** | **String**|  | 
 **offset** | [****](.md)| The number of parishes to skip before starting to collect the result set. | 
 **count** | **i32**| The number of parishes to return. | [default to 20]

### Return type

[**models::Parish**](Parish.md)

### Authorization

[polity_auth](../README.md#polity_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **update_parish**
> models::Parish update_parish(ctx, optional)
Update an existing parish

### Required Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **ctx** | **context.Context** | context containing the authentication | nil if no authentication
 **optional** | **map[string]interface{}** | optional parameters | nil if no parameters

### Optional Parameters
Optional parameters are passed through a map[string]interface{}.

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **parish** | [**Parish**](Parish.md)|  | 

### Return type

[**models::Parish**](Parish.md)

### Authorization

[polity_auth](../README.md#polity_auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

