# deanery_api

All URIs are relative to *http://dev-sg.portal.hocvienconggiao.com*

Method | HTTP request | Description
------------- | ------------- | -------------
**add_deanery**](deanery_api.md#add_deanery) | **POST** /mutation-api/deaneries | Add new deanery
**delete_deanery**](deanery_api.md#delete_deanery) | **DELETE** /mutation-api/diocese | Delete deanery by ID
**get_deaneries**](deanery_api.md#get_deaneries) | **GET** /query-api/deaneries | Get deaneries
**get_deanery_by_id**](deanery_api.md#get_deanery_by_id) | **GET** /query-api/deaneries/{id} | Find deanery by ID
**update_deanery**](deanery_api.md#update_deanery) | **PUT** /mutation-api/deanery | Update an existing deanery


# **add_deanery**
> models::Deanery add_deanery(ctx, deanery)
Add new deanery

### Required Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **ctx** | **context.Context** | context containing the authentication | nil if no authentication
  **deanery** | [**Deanery**](Deanery.md)| Parish object that needs to be added to the database | 

### Return type

[**models::Deanery**](Deanery.md)

### Authorization

[polity_auth](../README.md#polity_auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **delete_deanery**
> delete_deanery(ctx, )
Delete deanery by ID

### Required Parameters
This endpoint does not need any parameter.

### Return type

 (empty response body)

### Authorization

[polity_auth](../README.md#polity_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_deaneries**
> models::Deanery get_deaneries(ctx, optional)
Get deaneries

Returns all deaneries

### Required Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **ctx** | **context.Context** | context containing the authentication | nil if no authentication
 **optional** | **map[string]interface{}** | optional parameters | nil if no parameters

### Optional Parameters
Optional parameters are passed through a map[string]interface{}.

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **province_name** | **String**|  | 
 **name** | **String**|  | 

### Return type

[**models::Deanery**](Deanery.md)

### Authorization

[polity_auth](../README.md#polity_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_deanery_by_id**
> models::Deanery get_deanery_by_id(ctx, id)
Find deanery by ID

Returns a single deanery

### Required Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **ctx** | **context.Context** | context containing the authentication | nil if no authentication
  **id** | [****](.md)| ID of deanery to return | 

### Return type

[**models::Deanery**](Deanery.md)

### Authorization

[polity_auth](../README.md#polity_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **update_deanery**
> models::Parish update_deanery(ctx, deanery)
Update an existing deanery

### Required Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **ctx** | **context.Context** | context containing the authentication | nil if no authentication
  **deanery** | [**Deanery**](Deanery.md)| Parish object that needs to be added to the database | 

### Return type

[**models::Parish**](Parish.md)

### Authorization

[polity_auth](../README.md#polity_auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

