# diocese_api

All URIs are relative to *http://dev-sg.portal.hocvienconggiao.com*

Method | HTTP request | Description
------------- | ------------- | -------------
**addDiocese**](diocese_api.md#addDiocese) | **POST** /mutation-api/dioceses | Add new diocese
**deleteDiocese**](diocese_api.md#deleteDiocese) | **DELETE** /mutation-api/deanery/{id} | Delete diocese by ID
**getAllDioceses**](diocese_api.md#getAllDioceses) | **GET** /query-api/dioceses | Get all dioceses
**getDioceseById**](diocese_api.md#getDioceseById) | **GET** /query-api/diocese/{id} | Find diocese by ID
**updateDiocese**](diocese_api.md#updateDiocese) | **PUT** /mutation-api/diocese/{id} | Update an existing diocese


# **addDiocese**
> models::Diocese addDiocese(ctx, diocese)
Add new diocese

### Required Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **ctx** | **context.Context** | context containing the authentication | nil if no authentication
  **diocese** | [**Diocese**](Diocese.md)| Diocese object that needs to be added to the database | 

### Return type

[**models::Diocese**](Diocese.md)

### Authorization

[polity_auth](../README.md#polity_auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **deleteDiocese**
> deleteDiocese(ctx, id)
Delete diocese by ID

### Required Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **ctx** | **context.Context** | context containing the authentication | nil if no authentication
  **id** | [****](.md)| ID of diocese that needs to be deleted | 

### Return type

 (empty response body)

### Authorization

[polity_auth](../README.md#polity_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **getAllDioceses**
> models::Diocese getAllDioceses(ctx, optional)
Get all dioceses

Returns all dioceses

### Required Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **ctx** | **context.Context** | context containing the authentication | nil if no authentication
 **optional** | **map[string]interface{}** | optional parameters | nil if no parameters

### Optional Parameters
Optional parameters are passed through a map[string]interface{}.

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **province** | [****](.md)|  | 
 **name** | **String**|  | 

### Return type

[**models::Diocese**](Diocese.md)

### Authorization

[polity_auth](../README.md#polity_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **getDioceseById**
> models::Diocese getDioceseById(ctx, id)
Find diocese by ID

Returns a single diocese

### Required Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **ctx** | **context.Context** | context containing the authentication | nil if no authentication
  **id** | [****](.md)| ID of diocese to return | 

### Return type

[**models::Diocese**](Diocese.md)

### Authorization

[polity_auth](../README.md#polity_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **updateDiocese**
> models::Parish updateDiocese(ctx, id, diocese)
Update an existing diocese

### Required Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **ctx** | **context.Context** | context containing the authentication | nil if no authentication
  **id** | [****](.md)| ID of diocese to update | 
  **diocese** | [**Diocese**](Diocese.md)| Diocese object that needs to be added to the database | 

### Return type

[**models::Parish**](Parish.md)

### Authorization

[polity_auth](../README.md#polity_auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

