# deanery_api

All URIs are relative to *http://dev-sg.portal.hocvienconggiao.com*

Method | HTTP request | Description
------------- | ------------- | -------------
**addDeanery**](deanery_api.md#addDeanery) | **POST** /mutation-api/deaneries | Add new deanery
**deleteDeanery**](deanery_api.md#deleteDeanery) | **DELETE** /mutation-api/diocese/{id} | Delete deanery by ID
**getAllDeaneries**](deanery_api.md#getAllDeaneries) | **GET** /query-api/deaneries | Get all deaneries
**getDeaneryById**](deanery_api.md#getDeaneryById) | **GET** /query-api/deanery/{id} | Find deanery by ID
**updateDeanery**](deanery_api.md#updateDeanery) | **PUT** /mutation-api/deanery/{id} | Update an existing deanery


# **addDeanery**
> models::Deanery addDeanery(ctx, deanery)
Add new deanery

### Required Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **ctx** | **context.Context** | context containing the authentication | nil if no authentication
  **deanery** | [**Deanery**](Deanery.md)| Parish object that needs to be added to the database | 

### Return type

[**models::Deanery**](Deanery.md)

### Authorization

[polity_auth](../README.md#polity_auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **deleteDeanery**
> deleteDeanery(ctx, id)
Delete deanery by ID

### Required Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **ctx** | **context.Context** | context containing the authentication | nil if no authentication
  **id** | [****](.md)| ID of deanery that needs to be deleted | 

### Return type

 (empty response body)

### Authorization

[polity_auth](../README.md#polity_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **getAllDeaneries**
> models::Deanery getAllDeaneries(ctx, optional)
Get all deaneries

Returns all deaneries

### Required Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **ctx** | **context.Context** | context containing the authentication | nil if no authentication
 **optional** | **map[string]interface{}** | optional parameters | nil if no parameters

### Optional Parameters
Optional parameters are passed through a map[string]interface{}.

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **province** | [****](.md)|  | 
 **name** | **String**|  | 

### Return type

[**models::Deanery**](Deanery.md)

### Authorization

[polity_auth](../README.md#polity_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **getDeaneryById**
> models::Deanery getDeaneryById(ctx, id)
Find deanery by ID

Returns a single deanery

### Required Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **ctx** | **context.Context** | context containing the authentication | nil if no authentication
  **id** | [****](.md)| ID of deanery to return | 

### Return type

[**models::Deanery**](Deanery.md)

### Authorization

[polity_auth](../README.md#polity_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **updateDeanery**
> models::Parish updateDeanery(ctx, id, deanery)
Update an existing deanery

### Required Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **ctx** | **context.Context** | context containing the authentication | nil if no authentication
  **id** | [****](.md)| ID of deanery to update | 
  **deanery** | [**Deanery**](Deanery.md)| Parish object that needs to be added to the database | 

### Return type

[**models::Parish**](Parish.md)

### Authorization

[polity_auth](../README.md#polity_auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

