# Rust API for hvcg_governance_openapi_catholic-polity

This is a server for Catholic Polity info.

## Overview

This client/server was generated by the [openapi-generator]
(https://openapi-generator.tech) project.  By using the
[OpenAPI-Spec](https://github.com/OAI/OpenAPI-Specification) from a remote
server, you can easily generate a server stub.

To see how to make this your own, look here:

[README]((https://openapi-generator.tech))

- API version: 0.1.1
- Build date: 2021-06-25T07:52:46.350117538Z[Etc/UTC]



This autogenerated project defines an API crate `hvcg_governance_openapi_catholic-polity` which contains:
* An `Api` trait defining the API in Rust.
* Data types representing the underlying data model.
* A `Client` type which implements `Api` and issues HTTP requests for each operation.
* A router which accepts HTTP requests and invokes the appropriate `Api` method for each operation.

It also contains an example server and client which make use of `hvcg_governance_openapi_catholic-polity`:

* The example server starts up a web server using the `hvcg_governance_openapi_catholic-polity`
    router, and supplies a trivial implementation of `Api` which returns failure
    for every operation.
* The example client provides a CLI which lets you invoke
    any single operation on the `hvcg_governance_openapi_catholic-polity` client by passing appropriate
    arguments on the command line.

You can use the example server and client as a basis for your own code.
See below for [more detail on implementing a server](#writing-a-server).

## Examples

Run examples with:

```
cargo run --example <example-name>
```

To pass in arguments to the examples, put them after `--`, for example:

```
cargo run --example client -- --help
```

### Running the example server
To run the server, follow these simple steps:

```
cargo run --example server
```

### Running the example client
To run a client, follow one of the following simple steps:

```
cargo run --example client DeleteDeanery
cargo run --example client GetAllDeaneries
cargo run --example client GetDeaneryById
cargo run --example client DeleteDiocese
cargo run --example client GetAllDioceses
cargo run --example client GetDioceseById
cargo run --example client AddParish
cargo run --example client DeleteParish
cargo run --example client GetAllParishes
cargo run --example client GetParishById
cargo run --example client UpdateParish
```

### HTTPS
The examples can be run in HTTPS mode by passing in the flag `--https`, for example:

```
cargo run --example server -- --https
```

This will use the keys/certificates from the examples directory. Note that the
server chain is signed with `CN=localhost`.

## Using the generated library

The generated library has a few optional features that can be activated through Cargo.

* `server`
    * This defaults to enabled and creates the basic skeleton of a server implementation based on hyper
    * To create the server stack you'll need to provide an implementation of the API trait to provide the server function.
* `client`
    * This defaults to enabled and creates the basic skeleton of a client implementation based on hyper
    * The constructed client implements the API trait by making remote API call.
* `conversions`
    * This defaults to disabled and creates extra derives on models to allow "transmogrification" between objects of structurally similar types.

See https://doc.rust-lang.org/cargo/reference/manifest.html#the-features-section for how to use features in your `Cargo.toml`.

## Documentation for API Endpoints

All URIs are relative to *http://dev-sg.portal.hocvienconggiao.com*

Method | HTTP request | Description
------------- | ------------- | -------------
[**addDeanery**](docs/deanery_api.md#addDeanery) | **POST** /mutation-api/deaneries | Add new deanery
[**deleteDeanery**](docs/deanery_api.md#deleteDeanery) | **DELETE** /mutation-api/diocese/{id} | Delete deanery by ID
[**getAllDeaneries**](docs/deanery_api.md#getAllDeaneries) | **GET** /query-api/deaneries | Get all deaneries
[**getDeaneryById**](docs/deanery_api.md#getDeaneryById) | **GET** /query-api/deanery/{id} | Find deanery by ID
[**updateDeanery**](docs/deanery_api.md#updateDeanery) | **PUT** /mutation-api/deanery/{id} | Update an existing deanery
[**addDiocese**](docs/diocese_api.md#addDiocese) | **POST** /mutation-api/dioceses | Add new diocese
[**deleteDiocese**](docs/diocese_api.md#deleteDiocese) | **DELETE** /mutation-api/deanery/{id} | Delete diocese by ID
[**getAllDioceses**](docs/diocese_api.md#getAllDioceses) | **GET** /query-api/dioceses | Get all dioceses
[**getDioceseById**](docs/diocese_api.md#getDioceseById) | **GET** /query-api/diocese/{id} | Find diocese by ID
[**updateDiocese**](docs/diocese_api.md#updateDiocese) | **PUT** /mutation-api/diocese/{id} | Update an existing diocese
[**addParish**](docs/parish_api.md#addParish) | **POST** /mutation-api/parishes | Add new parish
[**deleteParish**](docs/parish_api.md#deleteParish) | **DELETE** /mutation-api/parish/{id} | Delete parish by ID
[**getAllParishes**](docs/parish_api.md#getAllParishes) | **GET** /query-api/parishes | Get all parishes
[**getParishById**](docs/parish_api.md#getParishById) | **GET** /query-api/parish/{id} | Find parish by ID
[**updateParish**](docs/parish_api.md#updateParish) | **PUT** /mutation-api/parish/{id} | Update an existing parish


## Documentation For Models

 - [Deanery](docs/Deanery.md)
 - [Diocese](docs/Diocese.md)
 - [EcclesiasticalProvince](docs/EcclesiasticalProvince.md)
 - [Parish](docs/Parish.md)
 - [Polity](docs/Polity.md)


## Documentation For Authorization

## polity_auth
- **Type**: Bearer token authentication

Example
```
```

## Author



