#![allow(unused_qualifications)]

use crate::models;
#[cfg(any(feature = "client", feature = "server"))]
use crate::header;

/// An area controlled by a diocese
#[derive(Debug, Clone, PartialEq, serde::Serialize, serde::Deserialize)]
#[cfg_attr(feature = "conversion", derive(frunk::LabelledGeneric))]
pub struct Deanery {
    #[serde(rename = "Diocese")]
    #[serde(skip_serializing_if="Option::is_none")]
    pub diocese: Option<models::Diocese>,

    #[serde(rename = "id")]
    #[serde(skip_serializing_if="Option::is_none")]
    pub id: Option<uuid::Uuid>,

    #[serde(rename = "name")]
    pub name: String,

    #[serde(rename = "inCharge")]
    pub in_charge: String,

}

impl Deanery {
    pub fn new(name: String, in_charge: String, ) -> Deanery {
        Deanery {
            diocese: None,
            id: None,
            name: name,
            in_charge: in_charge,
        }
    }
}

/// Converts the Deanery value to the Query Parameters representation (style=form, explode=false)
/// specified in https://swagger.io/docs/specification/serialization/
/// Should be implemented in a serde serializer
impl std::string::ToString for Deanery {
    fn to_string(&self) -> String {
        let mut params: Vec<String> = vec![];
        // Skipping Diocese in query parameter serialization

        // Skipping id in query parameter serialization


        params.push("name".to_string());
        params.push(self.name.to_string());


        params.push("inCharge".to_string());
        params.push(self.in_charge.to_string());

        params.join(",").to_string()
    }
}

/// Converts Query Parameters representation (style=form, explode=false) to a Deanery value
/// as specified in https://swagger.io/docs/specification/serialization/
/// Should be implemented in a serde deserializer
impl std::str::FromStr for Deanery {
    type Err = String;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        #[derive(Default)]
        // An intermediate representation of the struct to use for parsing.
        struct IntermediateRep {
            pub diocese: Vec<models::Diocese>,
            pub id: Vec<uuid::Uuid>,
            pub name: Vec<String>,
            pub in_charge: Vec<String>,
        }

        let mut intermediate_rep = IntermediateRep::default();

        // Parse into intermediate representation
        let mut string_iter = s.split(',').into_iter();
        let mut key_result = string_iter.next();

        while key_result.is_some() {
            let val = match string_iter.next() {
                Some(x) => x,
                None => return std::result::Result::Err("Missing value while parsing Deanery".to_string())
            };

            if let Some(key) = key_result {
                match key {
                    "Diocese" => intermediate_rep.diocese.push(<models::Diocese as std::str::FromStr>::from_str(val).map_err(|x| format!("{}", x))?),
                    "id" => intermediate_rep.id.push(<uuid::Uuid as std::str::FromStr>::from_str(val).map_err(|x| format!("{}", x))?),
                    "name" => intermediate_rep.name.push(<String as std::str::FromStr>::from_str(val).map_err(|x| format!("{}", x))?),
                    "inCharge" => intermediate_rep.in_charge.push(<String as std::str::FromStr>::from_str(val).map_err(|x| format!("{}", x))?),
                    _ => return std::result::Result::Err("Unexpected key while parsing Deanery".to_string())
                }
            }

            // Get the next key
            key_result = string_iter.next();
        }

        // Use the intermediate representation to return the struct
        std::result::Result::Ok(Deanery {
            diocese: intermediate_rep.diocese.into_iter().next(),
            id: intermediate_rep.id.into_iter().next(),
            name: intermediate_rep.name.into_iter().next().ok_or("name missing in Deanery".to_string())?,
            in_charge: intermediate_rep.in_charge.into_iter().next().ok_or("inCharge missing in Deanery".to_string())?,
        })
    }
}

// Methods for converting between header::IntoHeaderValue<Deanery> and hyper::header::HeaderValue

#[cfg(any(feature = "client", feature = "server"))]
impl std::convert::TryFrom<header::IntoHeaderValue<Deanery>> for hyper::header::HeaderValue {
    type Error = String;

    fn try_from(hdr_value: header::IntoHeaderValue<Deanery>) -> std::result::Result<Self, Self::Error> {
        let hdr_value = hdr_value.to_string();
        match hyper::header::HeaderValue::from_str(&hdr_value) {
             std::result::Result::Ok(value) => std::result::Result::Ok(value),
             std::result::Result::Err(e) => std::result::Result::Err(
                 format!("Invalid header value for Deanery - value: {} is invalid {}",
                     hdr_value, e))
        }
    }
}

#[cfg(any(feature = "client", feature = "server"))]
impl std::convert::TryFrom<hyper::header::HeaderValue> for header::IntoHeaderValue<Deanery> {
    type Error = String;

    fn try_from(hdr_value: hyper::header::HeaderValue) -> std::result::Result<Self, Self::Error> {
        match hdr_value.to_str() {
             std::result::Result::Ok(value) => {
                    match <Deanery as std::str::FromStr>::from_str(value) {
                        std::result::Result::Ok(value) => std::result::Result::Ok(header::IntoHeaderValue(value)),
                        std::result::Result::Err(err) => std::result::Result::Err(
                            format!("Unable to convert header value '{}' into Deanery - {}",
                                value, err))
                    }
             },
             std::result::Result::Err(e) => std::result::Result::Err(
                 format!("Unable to convert header: {:?} to string: {}",
                     hdr_value, e))
        }
    }
}


/// An area controlled by a ecclesiastical province
#[derive(Debug, Clone, PartialEq, serde::Serialize, serde::Deserialize)]
#[cfg_attr(feature = "conversion", derive(frunk::LabelledGeneric))]
pub struct Diocese {
    #[serde(rename = "ecclesiasticalProvince")]
    pub ecclesiastical_province: models::EcclesiasticalProvince,

    #[serde(rename = "id")]
    #[serde(skip_serializing_if="Option::is_none")]
    pub id: Option<uuid::Uuid>,

    #[serde(rename = "name")]
    pub name: String,

    #[serde(rename = "inCharge")]
    pub in_charge: String,

}

impl Diocese {
    pub fn new(ecclesiastical_province: models::EcclesiasticalProvince, name: String, in_charge: String, ) -> Diocese {
        Diocese {
            ecclesiastical_province: ecclesiastical_province,
            id: None,
            name: name,
            in_charge: in_charge,
        }
    }
}

/// Converts the Diocese value to the Query Parameters representation (style=form, explode=false)
/// specified in https://swagger.io/docs/specification/serialization/
/// Should be implemented in a serde serializer
impl std::string::ToString for Diocese {
    fn to_string(&self) -> String {
        let mut params: Vec<String> = vec![];
        // Skipping ecclesiasticalProvince in query parameter serialization

        // Skipping id in query parameter serialization


        params.push("name".to_string());
        params.push(self.name.to_string());


        params.push("inCharge".to_string());
        params.push(self.in_charge.to_string());

        params.join(",").to_string()
    }
}

/// Converts Query Parameters representation (style=form, explode=false) to a Diocese value
/// as specified in https://swagger.io/docs/specification/serialization/
/// Should be implemented in a serde deserializer
impl std::str::FromStr for Diocese {
    type Err = String;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        #[derive(Default)]
        // An intermediate representation of the struct to use for parsing.
        struct IntermediateRep {
            pub ecclesiastical_province: Vec<models::EcclesiasticalProvince>,
            pub id: Vec<uuid::Uuid>,
            pub name: Vec<String>,
            pub in_charge: Vec<String>,
        }

        let mut intermediate_rep = IntermediateRep::default();

        // Parse into intermediate representation
        let mut string_iter = s.split(',').into_iter();
        let mut key_result = string_iter.next();

        while key_result.is_some() {
            let val = match string_iter.next() {
                Some(x) => x,
                None => return std::result::Result::Err("Missing value while parsing Diocese".to_string())
            };

            if let Some(key) = key_result {
                match key {
                    "ecclesiasticalProvince" => intermediate_rep.ecclesiastical_province.push(<models::EcclesiasticalProvince as std::str::FromStr>::from_str(val).map_err(|x| format!("{}", x))?),
                    "id" => intermediate_rep.id.push(<uuid::Uuid as std::str::FromStr>::from_str(val).map_err(|x| format!("{}", x))?),
                    "name" => intermediate_rep.name.push(<String as std::str::FromStr>::from_str(val).map_err(|x| format!("{}", x))?),
                    "inCharge" => intermediate_rep.in_charge.push(<String as std::str::FromStr>::from_str(val).map_err(|x| format!("{}", x))?),
                    _ => return std::result::Result::Err("Unexpected key while parsing Diocese".to_string())
                }
            }

            // Get the next key
            key_result = string_iter.next();
        }

        // Use the intermediate representation to return the struct
        std::result::Result::Ok(Diocese {
            ecclesiastical_province: intermediate_rep.ecclesiastical_province.into_iter().next().ok_or("ecclesiasticalProvince missing in Diocese".to_string())?,
            id: intermediate_rep.id.into_iter().next(),
            name: intermediate_rep.name.into_iter().next().ok_or("name missing in Diocese".to_string())?,
            in_charge: intermediate_rep.in_charge.into_iter().next().ok_or("inCharge missing in Diocese".to_string())?,
        })
    }
}

// Methods for converting between header::IntoHeaderValue<Diocese> and hyper::header::HeaderValue

#[cfg(any(feature = "client", feature = "server"))]
impl std::convert::TryFrom<header::IntoHeaderValue<Diocese>> for hyper::header::HeaderValue {
    type Error = String;

    fn try_from(hdr_value: header::IntoHeaderValue<Diocese>) -> std::result::Result<Self, Self::Error> {
        let hdr_value = hdr_value.to_string();
        match hyper::header::HeaderValue::from_str(&hdr_value) {
             std::result::Result::Ok(value) => std::result::Result::Ok(value),
             std::result::Result::Err(e) => std::result::Result::Err(
                 format!("Invalid header value for Diocese - value: {} is invalid {}",
                     hdr_value, e))
        }
    }
}

#[cfg(any(feature = "client", feature = "server"))]
impl std::convert::TryFrom<hyper::header::HeaderValue> for header::IntoHeaderValue<Diocese> {
    type Error = String;

    fn try_from(hdr_value: hyper::header::HeaderValue) -> std::result::Result<Self, Self::Error> {
        match hdr_value.to_str() {
             std::result::Result::Ok(value) => {
                    match <Diocese as std::str::FromStr>::from_str(value) {
                        std::result::Result::Ok(value) => std::result::Result::Ok(header::IntoHeaderValue(value)),
                        std::result::Result::Err(err) => std::result::Result::Err(
                            format!("Unable to convert header value '{}' into Diocese - {}",
                                value, err))
                    }
             },
             std::result::Result::Err(e) => std::result::Result::Err(
                 format!("Unable to convert header: {:?} to string: {}",
                     hdr_value, e))
        }
    }
}


/// Enumeration of values.
/// Since this enum's variants do not hold data, we can easily define them them as `#[repr(C)]`
/// which helps with FFI.
#[allow(non_camel_case_types)]
#[repr(C)]
#[derive(Debug, Clone, Copy, PartialEq, Eq, PartialOrd, Ord, serde::Serialize, serde::Deserialize)]
#[cfg_attr(feature = "conversion", derive(frunk_enum_derive::LabelledGenericEnum))]
pub enum EcclesiasticalProvince {
    #[serde(rename = "HA_NOI")]
    HA_NOI,
    #[serde(rename = "HUE")]
    HUE,
    #[serde(rename = "SAI_GON")]
    SAI_GON,
}

impl std::fmt::Display for EcclesiasticalProvince {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match *self {
            EcclesiasticalProvince::HA_NOI => write!(f, "{}", "HA_NOI"),
            EcclesiasticalProvince::HUE => write!(f, "{}", "HUE"),
            EcclesiasticalProvince::SAI_GON => write!(f, "{}", "SAI_GON"),
        }
    }
}

impl std::str::FromStr for EcclesiasticalProvince {
    type Err = String;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        match s {
            "HA_NOI" => std::result::Result::Ok(EcclesiasticalProvince::HA_NOI),
            "HUE" => std::result::Result::Ok(EcclesiasticalProvince::HUE),
            "SAI_GON" => std::result::Result::Ok(EcclesiasticalProvince::SAI_GON),
            _ => std::result::Result::Err(format!("Value not valid: {}", s)),
        }
    }
}

#[derive(Debug, Clone, PartialEq, serde::Serialize, serde::Deserialize)]
#[cfg_attr(feature = "conversion", derive(frunk::LabelledGeneric))]
pub struct Parish {
    #[serde(rename = "diocese")]
    pub diocese: models::Diocese,

    #[serde(rename = "deanery")]
    pub deanery: models::Deanery,

    #[serde(rename = "id")]
    #[serde(skip_serializing_if="Option::is_none")]
    pub id: Option<uuid::Uuid>,

    #[serde(rename = "name")]
    pub name: String,

    #[serde(rename = "inCharge")]
    pub in_charge: String,

}

impl Parish {
    pub fn new(diocese: models::Diocese, deanery: models::Deanery, name: String, in_charge: String, ) -> Parish {
        Parish {
            diocese: diocese,
            deanery: deanery,
            id: None,
            name: name,
            in_charge: in_charge,
        }
    }
}

/// Converts the Parish value to the Query Parameters representation (style=form, explode=false)
/// specified in https://swagger.io/docs/specification/serialization/
/// Should be implemented in a serde serializer
impl std::string::ToString for Parish {
    fn to_string(&self) -> String {
        let mut params: Vec<String> = vec![];
        // Skipping diocese in query parameter serialization

        // Skipping deanery in query parameter serialization

        // Skipping id in query parameter serialization


        params.push("name".to_string());
        params.push(self.name.to_string());


        params.push("inCharge".to_string());
        params.push(self.in_charge.to_string());

        params.join(",").to_string()
    }
}

/// Converts Query Parameters representation (style=form, explode=false) to a Parish value
/// as specified in https://swagger.io/docs/specification/serialization/
/// Should be implemented in a serde deserializer
impl std::str::FromStr for Parish {
    type Err = String;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        #[derive(Default)]
        // An intermediate representation of the struct to use for parsing.
        struct IntermediateRep {
            pub diocese: Vec<models::Diocese>,
            pub deanery: Vec<models::Deanery>,
            pub id: Vec<uuid::Uuid>,
            pub name: Vec<String>,
            pub in_charge: Vec<String>,
        }

        let mut intermediate_rep = IntermediateRep::default();

        // Parse into intermediate representation
        let mut string_iter = s.split(',').into_iter();
        let mut key_result = string_iter.next();

        while key_result.is_some() {
            let val = match string_iter.next() {
                Some(x) => x,
                None => return std::result::Result::Err("Missing value while parsing Parish".to_string())
            };

            if let Some(key) = key_result {
                match key {
                    "diocese" => intermediate_rep.diocese.push(<models::Diocese as std::str::FromStr>::from_str(val).map_err(|x| format!("{}", x))?),
                    "deanery" => intermediate_rep.deanery.push(<models::Deanery as std::str::FromStr>::from_str(val).map_err(|x| format!("{}", x))?),
                    "id" => intermediate_rep.id.push(<uuid::Uuid as std::str::FromStr>::from_str(val).map_err(|x| format!("{}", x))?),
                    "name" => intermediate_rep.name.push(<String as std::str::FromStr>::from_str(val).map_err(|x| format!("{}", x))?),
                    "inCharge" => intermediate_rep.in_charge.push(<String as std::str::FromStr>::from_str(val).map_err(|x| format!("{}", x))?),
                    _ => return std::result::Result::Err("Unexpected key while parsing Parish".to_string())
                }
            }

            // Get the next key
            key_result = string_iter.next();
        }

        // Use the intermediate representation to return the struct
        std::result::Result::Ok(Parish {
            diocese: intermediate_rep.diocese.into_iter().next().ok_or("diocese missing in Parish".to_string())?,
            deanery: intermediate_rep.deanery.into_iter().next().ok_or("deanery missing in Parish".to_string())?,
            id: intermediate_rep.id.into_iter().next(),
            name: intermediate_rep.name.into_iter().next().ok_or("name missing in Parish".to_string())?,
            in_charge: intermediate_rep.in_charge.into_iter().next().ok_or("inCharge missing in Parish".to_string())?,
        })
    }
}

// Methods for converting between header::IntoHeaderValue<Parish> and hyper::header::HeaderValue

#[cfg(any(feature = "client", feature = "server"))]
impl std::convert::TryFrom<header::IntoHeaderValue<Parish>> for hyper::header::HeaderValue {
    type Error = String;

    fn try_from(hdr_value: header::IntoHeaderValue<Parish>) -> std::result::Result<Self, Self::Error> {
        let hdr_value = hdr_value.to_string();
        match hyper::header::HeaderValue::from_str(&hdr_value) {
             std::result::Result::Ok(value) => std::result::Result::Ok(value),
             std::result::Result::Err(e) => std::result::Result::Err(
                 format!("Invalid header value for Parish - value: {} is invalid {}",
                     hdr_value, e))
        }
    }
}

#[cfg(any(feature = "client", feature = "server"))]
impl std::convert::TryFrom<hyper::header::HeaderValue> for header::IntoHeaderValue<Parish> {
    type Error = String;

    fn try_from(hdr_value: hyper::header::HeaderValue) -> std::result::Result<Self, Self::Error> {
        match hdr_value.to_str() {
             std::result::Result::Ok(value) => {
                    match <Parish as std::str::FromStr>::from_str(value) {
                        std::result::Result::Ok(value) => std::result::Result::Ok(header::IntoHeaderValue(value)),
                        std::result::Result::Err(err) => std::result::Result::Err(
                            format!("Unable to convert header value '{}' into Parish - {}",
                                value, err))
                    }
             },
             std::result::Result::Err(e) => std::result::Result::Err(
                 format!("Unable to convert header: {:?} to string: {}",
                     hdr_value, e))
        }
    }
}


#[derive(Debug, Clone, PartialEq, serde::Serialize, serde::Deserialize)]
#[cfg_attr(feature = "conversion", derive(frunk::LabelledGeneric))]
pub struct Polity {
    #[serde(rename = "id")]
    #[serde(skip_serializing_if="Option::is_none")]
    pub id: Option<uuid::Uuid>,

    #[serde(rename = "name")]
    pub name: String,

    #[serde(rename = "inCharge")]
    pub in_charge: String,

}

impl Polity {
    pub fn new(name: String, in_charge: String, ) -> Polity {
        Polity {
            id: None,
            name: name,
            in_charge: in_charge,
        }
    }
}

/// Converts the Polity value to the Query Parameters representation (style=form, explode=false)
/// specified in https://swagger.io/docs/specification/serialization/
/// Should be implemented in a serde serializer
impl std::string::ToString for Polity {
    fn to_string(&self) -> String {
        let mut params: Vec<String> = vec![];
        // Skipping id in query parameter serialization


        params.push("name".to_string());
        params.push(self.name.to_string());


        params.push("inCharge".to_string());
        params.push(self.in_charge.to_string());

        params.join(",").to_string()
    }
}

/// Converts Query Parameters representation (style=form, explode=false) to a Polity value
/// as specified in https://swagger.io/docs/specification/serialization/
/// Should be implemented in a serde deserializer
impl std::str::FromStr for Polity {
    type Err = String;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        #[derive(Default)]
        // An intermediate representation of the struct to use for parsing.
        struct IntermediateRep {
            pub id: Vec<uuid::Uuid>,
            pub name: Vec<String>,
            pub in_charge: Vec<String>,
        }

        let mut intermediate_rep = IntermediateRep::default();

        // Parse into intermediate representation
        let mut string_iter = s.split(',').into_iter();
        let mut key_result = string_iter.next();

        while key_result.is_some() {
            let val = match string_iter.next() {
                Some(x) => x,
                None => return std::result::Result::Err("Missing value while parsing Polity".to_string())
            };

            if let Some(key) = key_result {
                match key {
                    "id" => intermediate_rep.id.push(<uuid::Uuid as std::str::FromStr>::from_str(val).map_err(|x| format!("{}", x))?),
                    "name" => intermediate_rep.name.push(<String as std::str::FromStr>::from_str(val).map_err(|x| format!("{}", x))?),
                    "inCharge" => intermediate_rep.in_charge.push(<String as std::str::FromStr>::from_str(val).map_err(|x| format!("{}", x))?),
                    _ => return std::result::Result::Err("Unexpected key while parsing Polity".to_string())
                }
            }

            // Get the next key
            key_result = string_iter.next();
        }

        // Use the intermediate representation to return the struct
        std::result::Result::Ok(Polity {
            id: intermediate_rep.id.into_iter().next(),
            name: intermediate_rep.name.into_iter().next().ok_or("name missing in Polity".to_string())?,
            in_charge: intermediate_rep.in_charge.into_iter().next().ok_or("inCharge missing in Polity".to_string())?,
        })
    }
}

// Methods for converting between header::IntoHeaderValue<Polity> and hyper::header::HeaderValue

#[cfg(any(feature = "client", feature = "server"))]
impl std::convert::TryFrom<header::IntoHeaderValue<Polity>> for hyper::header::HeaderValue {
    type Error = String;

    fn try_from(hdr_value: header::IntoHeaderValue<Polity>) -> std::result::Result<Self, Self::Error> {
        let hdr_value = hdr_value.to_string();
        match hyper::header::HeaderValue::from_str(&hdr_value) {
             std::result::Result::Ok(value) => std::result::Result::Ok(value),
             std::result::Result::Err(e) => std::result::Result::Err(
                 format!("Invalid header value for Polity - value: {} is invalid {}",
                     hdr_value, e))
        }
    }
}

#[cfg(any(feature = "client", feature = "server"))]
impl std::convert::TryFrom<hyper::header::HeaderValue> for header::IntoHeaderValue<Polity> {
    type Error = String;

    fn try_from(hdr_value: hyper::header::HeaderValue) -> std::result::Result<Self, Self::Error> {
        match hdr_value.to_str() {
             std::result::Result::Ok(value) => {
                    match <Polity as std::str::FromStr>::from_str(value) {
                        std::result::Result::Ok(value) => std::result::Result::Ok(header::IntoHeaderValue(value)),
                        std::result::Result::Err(err) => std::result::Result::Err(
                            format!("Unable to convert header value '{}' into Polity - {}",
                                value, err))
                    }
             },
             std::result::Result::Err(e) => std::result::Result::Err(
                 format!("Unable to convert header: {:?} to string: {}",
                     hdr_value, e))
        }
    }
}

