# parish_api

All URIs are relative to *http://dev-sg.portal.hocvienconggiao.com*

Method | HTTP request | Description
------------- | ------------- | -------------
**addParish**](parish_api.md#addParish) | **POST** /mutation-api/parishes | Add new parish
**deleteParish**](parish_api.md#deleteParish) | **DELETE** /mutation-api/parish/{id} | Delete parish by ID
**getAllParishes**](parish_api.md#getAllParishes) | **GET** /query-api/parishes | Get all parishes
**getParishById**](parish_api.md#getParishById) | **GET** /query-api/parish/{id} | Find parish by ID
**updateParish**](parish_api.md#updateParish) | **PUT** /mutation-api/parish/{id} | Update an existing parish


# **addParish**
> models::Parish addParish(ctx, optional)
Add new parish

### Required Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **ctx** | **context.Context** | context containing the authentication | nil if no authentication
 **optional** | **map[string]interface{}** | optional parameters | nil if no parameters

### Optional Parameters
Optional parameters are passed through a map[string]interface{}.

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **parish** | [**Parish**](Parish.md)|  | 

### Return type

[**models::Parish**](Parish.md)

### Authorization

[polity_auth](../README.md#polity_auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **deleteParish**
> deleteParish(ctx, id)
Delete parish by ID

### Required Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **ctx** | **context.Context** | context containing the authentication | nil if no authentication
  **id** | [****](.md)| ID of Catholic parish that needs to be deleted | 

### Return type

 (empty response body)

### Authorization

[polity_auth](../README.md#polity_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **getAllParishes**
> models::Parish getAllParishes(ctx, optional)
Get all parishes

Returns all parishes

### Required Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **ctx** | **context.Context** | context containing the authentication | nil if no authentication
 **optional** | **map[string]interface{}** | optional parameters | nil if no parameters

### Optional Parameters
Optional parameters are passed through a map[string]interface{}.

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **diocese** | [****](.md)|  | 
 **name** | **String**|  | 
 **offset** | [****](.md)| The number of parishes to skip before starting to collect the result set. | 
 **count** | **i32**| The number of parishes to return. | [default to 20]

### Return type

[**models::Parish**](Parish.md)

### Authorization

[polity_auth](../README.md#polity_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **getParishById**
> models::Parish getParishById(ctx, id)
Find parish by ID

Returns a single parish

### Required Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **ctx** | **context.Context** | context containing the authentication | nil if no authentication
  **id** | [****](.md)| ID of parish to return | 

### Return type

[**models::Parish**](Parish.md)

### Authorization

[polity_auth](../README.md#polity_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **updateParish**
> models::Parish updateParish(ctx, id, optional)
Update an existing parish

### Required Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **ctx** | **context.Context** | context containing the authentication | nil if no authentication
  **id** | [****](.md)| ID of parish to update | 
 **optional** | **map[string]interface{}** | optional parameters | nil if no parameters

### Optional Parameters
Optional parameters are passed through a map[string]interface{}.

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | [****](.md)| ID of parish to update | 
 **parish** | [**Parish**](Parish.md)|  | 

### Return type

[**models::Parish**](Parish.md)

### Authorization

[polity_auth](../README.md#polity_auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

