# program_query_api

All URIs are relative to *https://dev-sg.portal.hocvienconggiao.com*

Method | HTTP request | Description
------------- | ------------- | -------------
**getProgramById**](program_query_api.md#getProgramById) | **GET** /query-api/enrolable-service/programs/{id} | Find program by ID
**getPrograms**](program_query_api.md#getPrograms) | **GET** /query-api/enrolable-service/programs | Get all programs


# **getProgramById**
> models::Program getProgramById(ctx, id)
Find program by ID

Returns a single program

### Required Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **ctx** | **context.Context** | context containing the authentication | nil if no authentication
  **id** | [****](.md)| ID of program to return | 

### Return type

[**models::Program**](Program.md)

### Authorization

[program_auth](../README.md#program_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **getPrograms**
> models::ProgramViewCollection getPrograms(ctx, optional)
Get all programs

Returns all programs

### Required Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **ctx** | **context.Context** | context containing the authentication | nil if no authentication
 **optional** | **map[string]interface{}** | optional parameters | nil if no parameters

### Optional Parameters
Optional parameters are passed through a map[string]interface{}.

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **name** | **String**|  | 
 **email** | **String**|  | 
 **phone** | **String**|  | 
 **undergraduate_school** | **String**|  | 
 **date_of_birth** | **chrono::DateTime::<chrono::Utc>**|  | 
 **place_of_birth** | **String**|  | 
 **polity_name** | **String**|  | 
 **specialism** | **String**|  | 
 **sorts** | [**models::ProgramSortCriteria**](models::ProgramSortCriteria.md)| to sort +displayName for ASC and -displayName for DESC | 
 **offset** | **i32**| The number of programs to skip before starting to collect the result set. | 
 **count** | **i32**| The number of programs to return. | [default to 20]

### Return type

[**models::ProgramViewCollection**](ProgramViewCollection.md)

### Authorization

[program_auth](../README.md#program_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

