# Rust API for hvcg_academics_openapi_student

This is a sample server Student info server. For this sample, you can use the api key `special-key` to test the authorization filters.

## Overview

This client/server was generated by the [openapi-generator]
(https://openapi-generator.tech) project.  By using the
[OpenAPI-Spec](https://github.com/OAI/OpenAPI-Specification) from a remote
server, you can easily generate a server stub.

To see how to make this your own, look here:

[README]((https://openapi-generator.tech))

- API version: 0.2.2
- Build date: 2021-09-10T02:37:36.704281299Z[Etc/UTC]



This autogenerated project defines an API crate `hvcg_academics_openapi_student` which contains:
* An `Api` trait defining the API in Rust.
* Data types representing the underlying data model.
* A `Client` type which implements `Api` and issues HTTP requests for each operation.
* A router which accepts HTTP requests and invokes the appropriate `Api` method for each operation.

It also contains an example server and client which make use of `hvcg_academics_openapi_student`:

* The example server starts up a web server using the `hvcg_academics_openapi_student`
    router, and supplies a trivial implementation of `Api` which returns failure
    for every operation.
* The example client provides a CLI which lets you invoke
    any single operation on the `hvcg_academics_openapi_student` client by passing appropriate
    arguments on the command line.

You can use the example server and client as a basis for your own code.
See below for [more detail on implementing a server](#writing-a-server).

## Examples

Run examples with:

```
cargo run --example <example-name>
```

To pass in arguments to the examples, put them after `--`, for example:

```
cargo run --example client -- --help
```

### Running the example server
To run the server, follow these simple steps:

```
cargo run --example server
```

### Running the example client
To run a client, follow one of the following simple steps:

```
cargo run --example client DeleteStudent
cargo run --example client GetStudentById
cargo run --example client GetStudents
```

### HTTPS
The examples can be run in HTTPS mode by passing in the flag `--https`, for example:

```
cargo run --example server -- --https
```

This will use the keys/certificates from the examples directory. Note that the
server chain is signed with `CN=localhost`.

## Using the generated library

The generated library has a few optional features that can be activated through Cargo.

* `server`
    * This defaults to enabled and creates the basic skeleton of a server implementation based on hyper
    * To create the server stack you'll need to provide an implementation of the API trait to provide the server function.
* `client`
    * This defaults to enabled and creates the basic skeleton of a client implementation based on hyper
    * The constructed client implements the API trait by making remote API call.
* `conversions`
    * This defaults to disabled and creates extra derives on models to allow "transmogrification" between objects of structurally similar types.

See https://doc.rust-lang.org/cargo/reference/manifest.html#the-features-section for how to use features in your `Cargo.toml`.

## Documentation for API Endpoints

All URIs are relative to *https://dev-sg.portal.hocvienconggiao.com*

Method | HTTP request | Description
------------- | ------------- | -------------
[**addStudent**](docs/student_mutation_api.md#addStudent) | **POST** /mutation-api/student-service/students | Add new student
[**deleteStudent**](docs/student_mutation_api.md#deleteStudent) | **DELETE** /mutation-api/student-service/students/{id} | Deletes a student
[**updateStudent**](docs/student_mutation_api.md#updateStudent) | **PUT** /mutation-api/student-service/students/{id} | Update an existing student
[**getStudentById**](docs/student_query_api.md#getStudentById) | **GET** /query-api/student-service/students/{id} | Find student by ID
[**getStudents**](docs/student_query_api.md#getStudents) | **GET** /query-api/student-service/students | Get all students


## Documentation For Models

 - [Student](docs/Student.md)
 - [StudentSortCriteria](docs/StudentSortCriteria.md)
 - [StudentView](docs/StudentView.md)
 - [StudentViewCollection](docs/StudentViewCollection.md)


## Documentation For Authorization

## student_auth
- **Type**: Bearer token authentication

Example
```
```

## Author



