#[cfg(test)]
mod tests {
    use bytes::Bytes;
    use hvcg_commons_lambda_client::http_request::{invoke, Headers, Request, RequestContext};
    use hvcg_example_openapi_entity::models::Pet;
    use serde::{Deserialize, Serialize};
    use serde_json::{json, Value};
    use std::path::PathBuf;
    use std::sync::Once;

    static INIT: Once = Once::new();

    fn initialise() {
        INIT.call_once(|| {
            let my_path = PathBuf::new().join(".env.test");
            dotenv::from_path(my_path.as_path()).ok();
            // println!("testing env {}", std::env::var("HELLO").unwrap());
        });
    }

    #[tokio::test]
    async fn invoke_example_service_test2() {
        initialise();
        let pet = Pet {
            name: "my-pet".to_owned(),
            id: None,
            category: None,
            photo_urls: Default::default(),
            status: Option::from("500".to_owned()),
            tags: Default::default(),
        };

        let hello_str = invoke(
            "example-service_test2".to_string(),
            "/testing".to_string(),
            "GET".to_string(),
            Option::from(pet),
        )
        .await
        .unwrap();

        println!("Res is {:?}", hello_str);

        let test_res: TestResponse = serde_json::from_str(&*hello_str).unwrap();
        println!(" message is {} ", test_res.status_code)
    }

    #[test]
    fn it_works() {
        let test = 5;
        assert_eq!(2 + 3, test);
    }

    #[derive(Default, Debug, Clone, PartialEq, Serialize, Deserialize)]
    #[serde(rename_all = "camelCase")]
    struct TestResponse {
        status_code: i16,
    }
}
