use bytes::Bytes;
use rusoto_core::RusotoError;
use rusoto_lambda::{InvocationRequest, InvocationResponse, InvokeError, Lambda, LambdaClient};
use serde::{Deserialize, Serialize};
use serde_json::{json, Value};
use std::env;

pub async fn invoke<P>(
    function_name: String,
    path: String,
    method: String,
    body_option: Option<P>,
) -> Result<String, RusotoError<InvokeError>>
where
    P: Serialize,
{
    let body: Value;
    if body_option.is_none() {
        body = Default::default();
    } else {
        body = json!(json!(body_option.unwrap()).to_string());
    }

    let request = Request {
        resource: path.clone(),
        path: path.clone(),
        http_method: method.clone(),
        headers: Headers {
            accept: "text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,image/apng,*/*;q=0.8,application/signed-exchange;v=b3;q=0.9".to_string(),
            accept_encoding: "gzip, deflate, br".to_string(),
            accept_language: "en-US,en;q=0.9".to_string(),
            cookie: "s_fid=7AAB6XMPLAFD9BBF-0643XMPL09956DE2; regStatus=pre-register".to_string(),
            content_type: "application/json".to_string(),
            host: "70ixmpl4fl.execute-api.us-east-2.amazonaws.com".to_string(),
            sec_fetch_dest: "document".to_string(),
            sec_fetch_mode: "navigate".to_string(),
            sec_fetch_site: "none".to_string(),
            upgrade_insecure_requests: "1".to_string(),
            user_agent: "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36".to_string(),
            x_amzn_trace_id: "Root=1-5e66d96f-7491f09xmpl79d18acf3d050".to_string(),
            x_forwarded_for: "52.255.255.12".to_string(),
            x_forwarded_port: "443".to_string(),
            x_forwarded_proto: "https".to_string()
        },
        multi_value_headers: Default::default(),
        query_string_parameters: Default::default(),
        multi_value_query_string_parameters: Default::default(),
        path_parameters: Default::default(),
        stage_variables: Default::default(),
        request_context: RequestContext {
            resource_id: "id123".to_string(),
            resource_path: path.clone(),
            http_method: method,
            extended_request_id: "ext123".to_string(),
            request_time: "10/Mar/2020:00:03:59 +0000".to_string(),
            path: path.clone(),
            account_id: "123456789012".to_string(),
            protocol: "HTTP/1.1".to_string(),
            stage: "dev".to_string(),
            domain_prefix: "prefix123".to_string(),
            request_time_epoch: 1583798639428,
            request_id: "id123".to_string(),
            identity: Default::default(),
            domain_name: "".to_string(),
            api_id: "".to_string()
        },
        body,
        is_base64_encoded: false
    };
    let json_request: Value = json!(request);
    let json_request_string = serde_json::to_string(&json_request).unwrap();
    println!("invoking with {}", json_request_string);
    let json_request_bytes = json_request_string.into_bytes();

    let lambda_client = LambdaClient::new("ap-southeast-1".parse().unwrap());
    let res = lambda_client
        .invoke(InvocationRequest {
            client_context: None,
            function_name: (env::var("APP_ENV").unwrap() + "_" + &*function_name)
                .parse()
                .unwrap(),
            invocation_type: None,
            log_type: None,
            payload: Option::from(Bytes::from(json_request_bytes)),
            qualifier: None,
        })
        .await;
    if res.is_err() {
        Err(res.err().unwrap())
    } else {
        let payload_bytes = res.unwrap().payload.unwrap();
        // let res_string = String::from_utf8(payload_bytes.to_vec()).unwrap();
        // let res_string_static: &'a str = &*res_string;
        // // let res_str: &'a str = &*res_string;
        // let p: P = serde_json::from_str(&*res_string).unwrap();
        Ok(String::from_utf8(payload_bytes.to_vec()).unwrap())
    }
}

#[derive(Default, Debug, Clone, PartialEq, Serialize, Deserialize)]
#[serde(rename_all = "camelCase")]
pub struct Request {
    pub resource: String,
    pub path: String,
    pub http_method: String,
    pub headers: Headers,
    pub multi_value_headers: MultiValueHeaders,
    pub query_string_parameters: ::serde_json::Value,
    pub multi_value_query_string_parameters: ::serde_json::Value,
    pub path_parameters: ::serde_json::Value,
    pub stage_variables: ::serde_json::Value,
    pub request_context: RequestContext,
    pub body: ::serde_json::Value,
    pub is_base64_encoded: bool,
}

#[derive(Default, Debug, Clone, PartialEq, Serialize, Deserialize)]
#[serde(rename_all = "camelCase")]
pub struct Headers {
    pub accept: String,
    #[serde(rename = "accept-encoding")]
    pub accept_encoding: String,
    #[serde(rename = "accept-language")]
    pub accept_language: String,
    pub cookie: String,
    #[serde(rename = "content-type")]
    pub content_type: String,
    #[serde(rename = "Host")]
    pub host: String,
    #[serde(rename = "sec-fetch-dest")]
    pub sec_fetch_dest: String,
    #[serde(rename = "sec-fetch-mode")]
    pub sec_fetch_mode: String,
    #[serde(rename = "sec-fetch-site")]
    pub sec_fetch_site: String,
    #[serde(rename = "upgrade-insecure-requests")]
    pub upgrade_insecure_requests: String,
    #[serde(rename = "User-Agent")]
    pub user_agent: String,
    #[serde(rename = "X-Amzn-Trace-Id")]
    pub x_amzn_trace_id: String,
    #[serde(rename = "X-Forwarded-For")]
    pub x_forwarded_for: String,
    #[serde(rename = "X-Forwarded-Port")]
    pub x_forwarded_port: String,
    #[serde(rename = "X-Forwarded-Proto")]
    pub x_forwarded_proto: String,
}

#[derive(Default, Debug, Clone, PartialEq, Serialize, Deserialize)]
#[serde(rename_all = "camelCase")]
pub struct MultiValueHeaders {
    pub accept: Vec<String>,
    #[serde(rename = "accept-encoding")]
    pub accept_encoding: Vec<String>,
    #[serde(rename = "accept-language")]
    pub accept_language: Vec<String>,
    pub cookie: Vec<String>,
    #[serde(rename = "Host")]
    pub host: Vec<String>,
    #[serde(rename = "sec-fetch-dest")]
    pub sec_fetch_dest: Vec<String>,
    #[serde(rename = "sec-fetch-mode")]
    pub sec_fetch_mode: Vec<String>,
    #[serde(rename = "sec-fetch-site")]
    pub sec_fetch_site: Vec<String>,
    #[serde(rename = "upgrade-insecure-requests")]
    pub upgrade_insecure_requests: Vec<String>,
    #[serde(rename = "User-Agent")]
    pub user_agent: Vec<String>,
    #[serde(rename = "X-Amzn-Trace-Id")]
    pub x_amzn_trace_id: Vec<String>,
    #[serde(rename = "X-Forwarded-For")]
    pub x_forwarded_for: Vec<String>,
    #[serde(rename = "X-Forwarded-Port")]
    pub x_forwarded_port: Vec<String>,
    #[serde(rename = "X-Forwarded-Proto")]
    pub x_forwarded_proto: Vec<String>,
}

#[derive(Default, Debug, Clone, PartialEq, Serialize, Deserialize)]
#[serde(rename_all = "camelCase")]
pub struct RequestContext {
    pub resource_id: String,
    pub resource_path: String,
    pub http_method: String,
    pub extended_request_id: String,
    pub request_time: String,
    pub path: String,
    pub account_id: String,
    pub protocol: String,
    pub stage: String,
    pub domain_prefix: String,
    pub request_time_epoch: i64,
    pub request_id: String,
    pub identity: Identity,
    pub domain_name: String,
    pub api_id: String,
}

#[derive(Default, Debug, Clone, PartialEq, Serialize, Deserialize)]
#[serde(rename_all = "camelCase")]
pub struct Identity {
    pub cognito_identity_pool_id: ::serde_json::Value,
    pub account_id: ::serde_json::Value,
    pub cognito_identity_id: ::serde_json::Value,
    pub caller: ::serde_json::Value,
    pub source_ip: String,
    pub principal_org_id: ::serde_json::Value,
    pub access_key: ::serde_json::Value,
    pub cognito_authentication_type: ::serde_json::Value,
    pub cognito_authentication_provider: ::serde_json::Value,
    pub user_arn: ::serde_json::Value,
    pub user_agent: String,
    pub user: ::serde_json::Value,
}
