use crate::sys;

/// Type of an ARM register.
#[allow(non_camel_case_types)]
#[repr(u32)]
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub enum Reg {
    X0 = sys::hv_reg_t_HV_REG_X0,
    X1 = sys::hv_reg_t_HV_REG_X1,
    X2 = sys::hv_reg_t_HV_REG_X2,
    X3 = sys::hv_reg_t_HV_REG_X3,
    X4 = sys::hv_reg_t_HV_REG_X4,
    X5 = sys::hv_reg_t_HV_REG_X5,
    X6 = sys::hv_reg_t_HV_REG_X6,
    X7 = sys::hv_reg_t_HV_REG_X7,
    X8 = sys::hv_reg_t_HV_REG_X8,
    X9 = sys::hv_reg_t_HV_REG_X9,
    X10 = sys::hv_reg_t_HV_REG_X10,
    X11 = sys::hv_reg_t_HV_REG_X11,
    X12 = sys::hv_reg_t_HV_REG_X12,
    X13 = sys::hv_reg_t_HV_REG_X13,
    X14 = sys::hv_reg_t_HV_REG_X14,
    X15 = sys::hv_reg_t_HV_REG_X15,
    X16 = sys::hv_reg_t_HV_REG_X16,
    X17 = sys::hv_reg_t_HV_REG_X17,
    X18 = sys::hv_reg_t_HV_REG_X18,
    X19 = sys::hv_reg_t_HV_REG_X19,
    X20 = sys::hv_reg_t_HV_REG_X20,
    X21 = sys::hv_reg_t_HV_REG_X21,
    X22 = sys::hv_reg_t_HV_REG_X22,
    X23 = sys::hv_reg_t_HV_REG_X23,
    X24 = sys::hv_reg_t_HV_REG_X24,
    X25 = sys::hv_reg_t_HV_REG_X25,
    X26 = sys::hv_reg_t_HV_REG_X26,
    X27 = sys::hv_reg_t_HV_REG_X27,
    X28 = sys::hv_reg_t_HV_REG_X28,
    X29 = sys::hv_reg_t_HV_REG_X29,
    X30 = sys::hv_reg_t_HV_REG_X30,
    PC = sys::hv_reg_t_HV_REG_PC,
    FPCR = sys::hv_reg_t_HV_REG_FPCR,
    FPSR = sys::hv_reg_t_HV_REG_FPSR,
    CPSR = sys::hv_reg_t_HV_REG_CPSR,
}

pub const REG_FP: Reg = Reg::X29;
pub const REG_LR: Reg = Reg::X30;

pub type SimdFpUchar16 = sys::hv_simd_fp_uchar16_t;

/// Type of an ARM SIMD & FP register.
#[allow(non_camel_case_types)]
#[repr(u32)]
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub enum SimdFpReg {
    Q0 = sys::hv_simd_fp_reg_t_HV_SIMD_FP_REG_Q0,
    Q1 = sys::hv_simd_fp_reg_t_HV_SIMD_FP_REG_Q1,
    Q2 = sys::hv_simd_fp_reg_t_HV_SIMD_FP_REG_Q2,
    Q3 = sys::hv_simd_fp_reg_t_HV_SIMD_FP_REG_Q3,
    Q4 = sys::hv_simd_fp_reg_t_HV_SIMD_FP_REG_Q4,
    Q5 = sys::hv_simd_fp_reg_t_HV_SIMD_FP_REG_Q5,
    Q6 = sys::hv_simd_fp_reg_t_HV_SIMD_FP_REG_Q6,
    Q7 = sys::hv_simd_fp_reg_t_HV_SIMD_FP_REG_Q7,
    Q8 = sys::hv_simd_fp_reg_t_HV_SIMD_FP_REG_Q8,
    Q9 = sys::hv_simd_fp_reg_t_HV_SIMD_FP_REG_Q9,
    Q10 = sys::hv_simd_fp_reg_t_HV_SIMD_FP_REG_Q10,
    Q11 = sys::hv_simd_fp_reg_t_HV_SIMD_FP_REG_Q11,
    Q12 = sys::hv_simd_fp_reg_t_HV_SIMD_FP_REG_Q12,
    Q13 = sys::hv_simd_fp_reg_t_HV_SIMD_FP_REG_Q13,
    Q14 = sys::hv_simd_fp_reg_t_HV_SIMD_FP_REG_Q14,
    Q15 = sys::hv_simd_fp_reg_t_HV_SIMD_FP_REG_Q15,
    Q16 = sys::hv_simd_fp_reg_t_HV_SIMD_FP_REG_Q16,
    Q17 = sys::hv_simd_fp_reg_t_HV_SIMD_FP_REG_Q17,
    Q18 = sys::hv_simd_fp_reg_t_HV_SIMD_FP_REG_Q18,
    Q19 = sys::hv_simd_fp_reg_t_HV_SIMD_FP_REG_Q19,
    Q20 = sys::hv_simd_fp_reg_t_HV_SIMD_FP_REG_Q20,
    Q21 = sys::hv_simd_fp_reg_t_HV_SIMD_FP_REG_Q21,
    Q22 = sys::hv_simd_fp_reg_t_HV_SIMD_FP_REG_Q22,
    Q23 = sys::hv_simd_fp_reg_t_HV_SIMD_FP_REG_Q23,
    Q24 = sys::hv_simd_fp_reg_t_HV_SIMD_FP_REG_Q24,
    Q25 = sys::hv_simd_fp_reg_t_HV_SIMD_FP_REG_Q25,
    Q26 = sys::hv_simd_fp_reg_t_HV_SIMD_FP_REG_Q26,
    Q27 = sys::hv_simd_fp_reg_t_HV_SIMD_FP_REG_Q27,
    Q28 = sys::hv_simd_fp_reg_t_HV_SIMD_FP_REG_Q28,
    Q29 = sys::hv_simd_fp_reg_t_HV_SIMD_FP_REG_Q29,
    Q30 = sys::hv_simd_fp_reg_t_HV_SIMD_FP_REG_Q30,
    Q31 = sys::hv_simd_fp_reg_t_HV_SIMD_FP_REG_Q31,
}

/// Type of an ARM system register.
#[allow(non_camel_case_types)]
#[repr(u16)]
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub enum SysReg {
    DBGBVR0_EL1 = sys::hv_sys_reg_t_HV_SYS_REG_DBGBVR0_EL1,
    DBGBCR0_EL1 = sys::hv_sys_reg_t_HV_SYS_REG_DBGBCR0_EL1,
    DBGWVR0_EL1 = sys::hv_sys_reg_t_HV_SYS_REG_DBGWVR0_EL1,
    DBGWCR0_EL1 = sys::hv_sys_reg_t_HV_SYS_REG_DBGWCR0_EL1,
    DBGBVR1_EL1 = sys::hv_sys_reg_t_HV_SYS_REG_DBGBVR1_EL1,
    DBGBCR1_EL1 = sys::hv_sys_reg_t_HV_SYS_REG_DBGBCR1_EL1,
    DBGWVR1_EL1 = sys::hv_sys_reg_t_HV_SYS_REG_DBGWVR1_EL1,
    DBGWCR1_EL1 = sys::hv_sys_reg_t_HV_SYS_REG_DBGWCR1_EL1,
    MDCCINT_EL1 = sys::hv_sys_reg_t_HV_SYS_REG_MDCCINT_EL1,
    MDSCR_EL1 = sys::hv_sys_reg_t_HV_SYS_REG_MDSCR_EL1,
    DBGBVR2_EL1 = sys::hv_sys_reg_t_HV_SYS_REG_DBGBVR2_EL1,
    DBGBCR2_EL1 = sys::hv_sys_reg_t_HV_SYS_REG_DBGBCR2_EL1,
    DBGWVR2_EL1 = sys::hv_sys_reg_t_HV_SYS_REG_DBGWVR2_EL1,
    DBGWCR2_EL1 = sys::hv_sys_reg_t_HV_SYS_REG_DBGWCR2_EL1,
    DBGBVR3_EL1 = sys::hv_sys_reg_t_HV_SYS_REG_DBGBVR3_EL1,
    DBGBCR3_EL1 = sys::hv_sys_reg_t_HV_SYS_REG_DBGBCR3_EL1,
    DBGWVR3_EL1 = sys::hv_sys_reg_t_HV_SYS_REG_DBGWVR3_EL1,
    DBGWCR3_EL1 = sys::hv_sys_reg_t_HV_SYS_REG_DBGWCR3_EL1,
    DBGBVR4_EL1 = sys::hv_sys_reg_t_HV_SYS_REG_DBGBVR4_EL1,
    DBGBCR4_EL1 = sys::hv_sys_reg_t_HV_SYS_REG_DBGBCR4_EL1,
    DBGWVR4_EL1 = sys::hv_sys_reg_t_HV_SYS_REG_DBGWVR4_EL1,
    DBGWCR4_EL1 = sys::hv_sys_reg_t_HV_SYS_REG_DBGWCR4_EL1,
    DBGBVR5_EL1 = sys::hv_sys_reg_t_HV_SYS_REG_DBGBVR5_EL1,
    DBGBCR5_EL1 = sys::hv_sys_reg_t_HV_SYS_REG_DBGBCR5_EL1,
    DBGWVR5_EL1 = sys::hv_sys_reg_t_HV_SYS_REG_DBGWVR5_EL1,
    DBGWCR5_EL1 = sys::hv_sys_reg_t_HV_SYS_REG_DBGWCR5_EL1,
    DBGBVR6_EL1 = sys::hv_sys_reg_t_HV_SYS_REG_DBGBVR6_EL1,
    DBGBCR6_EL1 = sys::hv_sys_reg_t_HV_SYS_REG_DBGBCR6_EL1,
    DBGWVR6_EL1 = sys::hv_sys_reg_t_HV_SYS_REG_DBGWVR6_EL1,
    DBGWCR6_EL1 = sys::hv_sys_reg_t_HV_SYS_REG_DBGWCR6_EL1,
    DBGBVR7_EL1 = sys::hv_sys_reg_t_HV_SYS_REG_DBGBVR7_EL1,
    DBGBCR7_EL1 = sys::hv_sys_reg_t_HV_SYS_REG_DBGBCR7_EL1,
    DBGWVR7_EL1 = sys::hv_sys_reg_t_HV_SYS_REG_DBGWVR7_EL1,
    DBGWCR7_EL1 = sys::hv_sys_reg_t_HV_SYS_REG_DBGWCR7_EL1,
    DBGBVR8_EL1 = sys::hv_sys_reg_t_HV_SYS_REG_DBGBVR8_EL1,
    DBGBCR8_EL1 = sys::hv_sys_reg_t_HV_SYS_REG_DBGBCR8_EL1,
    DBGWVR8_EL1 = sys::hv_sys_reg_t_HV_SYS_REG_DBGWVR8_EL1,
    DBGWCR8_EL1 = sys::hv_sys_reg_t_HV_SYS_REG_DBGWCR8_EL1,
    DBGBVR9_EL1 = sys::hv_sys_reg_t_HV_SYS_REG_DBGBVR9_EL1,
    DBGBCR9_EL1 = sys::hv_sys_reg_t_HV_SYS_REG_DBGBCR9_EL1,
    DBGWVR9_EL1 = sys::hv_sys_reg_t_HV_SYS_REG_DBGWVR9_EL1,
    DBGWCR9_EL1 = sys::hv_sys_reg_t_HV_SYS_REG_DBGWCR9_EL1,
    DBGBVR10_EL1 = sys::hv_sys_reg_t_HV_SYS_REG_DBGBVR10_EL1,
    DBGBCR10_EL1 = sys::hv_sys_reg_t_HV_SYS_REG_DBGBCR10_EL1,
    DBGWVR10_EL1 = sys::hv_sys_reg_t_HV_SYS_REG_DBGWVR10_EL1,
    DBGWCR10_EL1 = sys::hv_sys_reg_t_HV_SYS_REG_DBGWCR10_EL1,
    DBGBVR11_EL1 = sys::hv_sys_reg_t_HV_SYS_REG_DBGBVR11_EL1,
    DBGBCR11_EL1 = sys::hv_sys_reg_t_HV_SYS_REG_DBGBCR11_EL1,
    DBGWVR11_EL1 = sys::hv_sys_reg_t_HV_SYS_REG_DBGWVR11_EL1,
    DBGWCR11_EL1 = sys::hv_sys_reg_t_HV_SYS_REG_DBGWCR11_EL1,
    DBGBVR12_EL1 = sys::hv_sys_reg_t_HV_SYS_REG_DBGBVR12_EL1,
    DBGBCR12_EL1 = sys::hv_sys_reg_t_HV_SYS_REG_DBGBCR12_EL1,
    DBGWVR12_EL1 = sys::hv_sys_reg_t_HV_SYS_REG_DBGWVR12_EL1,
    DBGWCR12_EL1 = sys::hv_sys_reg_t_HV_SYS_REG_DBGWCR12_EL1,
    DBGBVR13_EL1 = sys::hv_sys_reg_t_HV_SYS_REG_DBGBVR13_EL1,
    DBGBCR13_EL1 = sys::hv_sys_reg_t_HV_SYS_REG_DBGBCR13_EL1,
    DBGWVR13_EL1 = sys::hv_sys_reg_t_HV_SYS_REG_DBGWVR13_EL1,
    DBGWCR13_EL1 = sys::hv_sys_reg_t_HV_SYS_REG_DBGWCR13_EL1,
    DBGBVR14_EL1 = sys::hv_sys_reg_t_HV_SYS_REG_DBGBVR14_EL1,
    DBGBCR14_EL1 = sys::hv_sys_reg_t_HV_SYS_REG_DBGBCR14_EL1,
    DBGWVR14_EL1 = sys::hv_sys_reg_t_HV_SYS_REG_DBGWVR14_EL1,
    DBGWCR14_EL1 = sys::hv_sys_reg_t_HV_SYS_REG_DBGWCR14_EL1,
    DBGBVR15_EL1 = sys::hv_sys_reg_t_HV_SYS_REG_DBGBVR15_EL1,
    DBGBCR15_EL1 = sys::hv_sys_reg_t_HV_SYS_REG_DBGBCR15_EL1,
    DBGWVR15_EL1 = sys::hv_sys_reg_t_HV_SYS_REG_DBGWVR15_EL1,
    DBGWCR15_EL1 = sys::hv_sys_reg_t_HV_SYS_REG_DBGWCR15_EL1,
    MIDR_EL1 = sys::hv_sys_reg_t_HV_SYS_REG_MIDR_EL1,
    MPIDR_EL1 = sys::hv_sys_reg_t_HV_SYS_REG_MPIDR_EL1,
    ID_AA64PFR0_EL1 = sys::hv_sys_reg_t_HV_SYS_REG_ID_AA64PFR0_EL1,
    ID_AA64PFR1_EL1 = sys::hv_sys_reg_t_HV_SYS_REG_ID_AA64PFR1_EL1,
    ID_AA64DFR0_EL1 = sys::hv_sys_reg_t_HV_SYS_REG_ID_AA64DFR0_EL1,
    ID_AA64DFR1_EL1 = sys::hv_sys_reg_t_HV_SYS_REG_ID_AA64DFR1_EL1,
    ID_AA64ISAR0_EL1 = sys::hv_sys_reg_t_HV_SYS_REG_ID_AA64ISAR0_EL1,
    ID_AA64ISAR1_EL1 = sys::hv_sys_reg_t_HV_SYS_REG_ID_AA64ISAR1_EL1,
    ID_AA64MMFR0_EL1 = sys::hv_sys_reg_t_HV_SYS_REG_ID_AA64MMFR0_EL1,
    ID_AA64MMFR1_EL1 = sys::hv_sys_reg_t_HV_SYS_REG_ID_AA64MMFR1_EL1,
    ID_AA64MMFR2_EL1 = sys::hv_sys_reg_t_HV_SYS_REG_ID_AA64MMFR2_EL1,
    SCTLR_EL1 = sys::hv_sys_reg_t_HV_SYS_REG_SCTLR_EL1,
    CPACR_EL1 = sys::hv_sys_reg_t_HV_SYS_REG_CPACR_EL1,
    TTBR0_EL1 = sys::hv_sys_reg_t_HV_SYS_REG_TTBR0_EL1,
    TTBR1_EL1 = sys::hv_sys_reg_t_HV_SYS_REG_TTBR1_EL1,
    TCR_EL1 = sys::hv_sys_reg_t_HV_SYS_REG_TCR_EL1,
    APIAKEYLO_EL1 = sys::hv_sys_reg_t_HV_SYS_REG_APIAKEYLO_EL1,
    APIAKEYHI_EL1 = sys::hv_sys_reg_t_HV_SYS_REG_APIAKEYHI_EL1,
    APIBKEYLO_EL1 = sys::hv_sys_reg_t_HV_SYS_REG_APIBKEYLO_EL1,
    APIBKEYHI_EL1 = sys::hv_sys_reg_t_HV_SYS_REG_APIBKEYHI_EL1,
    APDAKEYLO_EL1 = sys::hv_sys_reg_t_HV_SYS_REG_APDAKEYLO_EL1,
    APDAKEYHI_EL1 = sys::hv_sys_reg_t_HV_SYS_REG_APDAKEYHI_EL1,
    APDBKEYLO_EL1 = sys::hv_sys_reg_t_HV_SYS_REG_APDBKEYLO_EL1,
    APDBKEYHI_EL1 = sys::hv_sys_reg_t_HV_SYS_REG_APDBKEYHI_EL1,
    APGAKEYLO_EL1 = sys::hv_sys_reg_t_HV_SYS_REG_APGAKEYLO_EL1,
    APGAKEYHI_EL1 = sys::hv_sys_reg_t_HV_SYS_REG_APGAKEYHI_EL1,
    SPSR_EL1 = sys::hv_sys_reg_t_HV_SYS_REG_SPSR_EL1,
    ELR_EL1 = sys::hv_sys_reg_t_HV_SYS_REG_ELR_EL1,
    SP_EL0 = sys::hv_sys_reg_t_HV_SYS_REG_SP_EL0,
    AFSR0_EL1 = sys::hv_sys_reg_t_HV_SYS_REG_AFSR0_EL1,
    AFSR1_EL1 = sys::hv_sys_reg_t_HV_SYS_REG_AFSR1_EL1,
    ESR_EL1 = sys::hv_sys_reg_t_HV_SYS_REG_ESR_EL1,
    FAR_EL1 = sys::hv_sys_reg_t_HV_SYS_REG_FAR_EL1,
    PAR_EL1 = sys::hv_sys_reg_t_HV_SYS_REG_PAR_EL1,
    MAIR_EL1 = sys::hv_sys_reg_t_HV_SYS_REG_MAIR_EL1,
    AMAIR_EL1 = sys::hv_sys_reg_t_HV_SYS_REG_AMAIR_EL1,
    VBAR_EL1 = sys::hv_sys_reg_t_HV_SYS_REG_VBAR_EL1,
    CONTEXTIDR_EL1 = sys::hv_sys_reg_t_HV_SYS_REG_CONTEXTIDR_EL1,
    TPIDR_EL1 = sys::hv_sys_reg_t_HV_SYS_REG_TPIDR_EL1,
    CNTKCTL_EL1 = sys::hv_sys_reg_t_HV_SYS_REG_CNTKCTL_EL1,
    CSSELR_EL1 = sys::hv_sys_reg_t_HV_SYS_REG_CSSELR_EL1,
    TPIDR_EL0 = sys::hv_sys_reg_t_HV_SYS_REG_TPIDR_EL0,
    TPIDRRO_EL0 = sys::hv_sys_reg_t_HV_SYS_REG_TPIDRRO_EL0,
    CNTV_CTL_EL0 = sys::hv_sys_reg_t_HV_SYS_REG_CNTV_CTL_EL0,
    CNTV_CVAL_EL0 = sys::hv_sys_reg_t_HV_SYS_REG_CNTV_CVAL_EL0,
    SP_EL1 = sys::hv_sys_reg_t_HV_SYS_REG_SP_EL1,
}
