use crate::util::sha1::SHA1Hash;

#[test]
fn test_short_hash() {
    let input = "foo";
    let hash = input.hash();
    let expected = [
        0x0b, 0xee, 0xc7, 0xb5, 0xea, 0x3f, 0x0f, 0xdb, 0xc9, 0x5d, 0x0d, 0xd4, 0x7f, 0x3c, 0x5b,
        0xc2, 0x75, 0xda, 0x8a, 0x33,
    ];

    assert_eq!(hash, expected);
}

#[test]
fn test_chunked_hash() {
    let input: [u8; 128] = [0x69; 128];
    let hash = input.hash();
    let expected = [
        0x12, 0xb2, 0x1b, 0xec, 0x7c, 0x75, 0xa2, 0x0f, 0xa8, 0xc5, 0xac, 0xe0, 0x22, 0x17, 0x9a,
        0x81, 0x5c, 0xd7, 0x95, 0xa1,
    ];

    assert_eq!(hash, expected);
}

#[test]
fn test_empty_hash() {
    let input: [u8; 0] = [];
    let hash = input.hash();
    let expected = [
        0xda, 0x39, 0xa3, 0xee, 0x5e, 0x6b, 0x4b, 0x0d, 0x32, 0x55, 0xbf, 0xef, 0x95, 0x60, 0x18,
        0x90, 0xaf, 0xd8, 0x07, 0x09,
    ];

    assert_eq!(hash, expected);
}
