//! Functions for performing logical operations

use super::humanregex::HumanRegex;

/// A function for establishing an OR relationship between two or more possible matches
/// ```
/// use human_regex::{text, logical::or};
/// let regex_string = text("gr") + or(&[text("a"), text("e")]) + text("y");
/// println!("{}", regex_string.to_string());
/// assert!(regex_string.to_regex().is_match("grey"));
/// assert!(regex_string.to_regex().is_match("gray"));
/// assert!(!regex_string.to_regex().is_match("graey"));
/// ```
pub fn or(options: &[HumanRegex]) -> HumanRegex {
    let mut regex_string = format!("{}", options[0].to_string());
    for idx in 1..options.len() {
        regex_string = format!("{}|{}", regex_string, options[idx].to_string())
    }
    HumanRegex(format!("(:?{})", regex_string))
}

/// A function for establishing an AND relationship between two or more possible matches
pub fn and(options: &[HumanRegex]) -> HumanRegex {
    let mut regex_string = format!("{}", options[0].to_string());
    for idx in 1..options.len() {
        regex_string = format!("{}&&{}", regex_string, options[idx].to_string())
    }
    HumanRegex(format!("(:?{})", regex_string))
}
