//! This module marks orthogonal types
use super::normal::{HttpUriNormalizationOrthogonal, NormalHttpUri};
use super::sans_component::fragment::HttpUriSansFragment;
use super::sans_component::query::HttpUriSansQuery;
use super::with_component::fragment::HttpUriWithFragment;
use super::with_component::query::HttpUriWithQuery;
use super::with_component::tslash::HttpUriWithTslash;
use crate::HttpUri;

#[macro_export(local_inner_macros)]
macro_rules! mark_http_uri_normalization_orthogonal {
    (
        $($Invariant:ident,)*
    ) => {
        $(
            unsafe impl<'uri, HUI> $crate::invariant::normal::HttpUriNormalizationOrthogonal<'uri>
                for $Invariant<'uri, HUI> where HUI: $crate::base::tdd::invariant::TypeInvariant<$crate::HttpUri<'uri>> + Clone,
            {
            }
        )*
    };
}

mark_http_uri_normalization_orthogonal!(
    NormalHttpUri,
    HttpUriWithFragment,
    HttpUriWithQuery,
    HttpUriWithTslash,
    HttpUriSansFragment,
    HttpUriSansQuery,
);

unsafe impl<'uri> HttpUriNormalizationOrthogonal<'uri> for HttpUri<'uri> {}
