# http_uri

This crate exports types for that represents http uri and some of it's invariants.
All types are wrappers around [`uriparse::URI`] type, and enforces their corresponding invariants

1. [`HttpUri`]: It guarantees uri is valid, http(s), with valid host
2. [`invariant::normal::NormalHttpUri`]: Invariant of [`HttpUri`] that guarantees, the inner uri is a normalized http uri. Check type docs for what it entails to be normal

There are few other invariants based on presence/absence of certain components in modules `invariant::with_component::*`, `invariant::sans_component::*`.

One can chain invariants, to get their desired mixin, like fallowing:

1. `NormalHttpUri<HttpUriSansFragment<HttpUri>>`: Invariant for http uris, which doesn't have fragment, and also in their normal form



License: MIT OR Apache-2.0
