use std::borrow::Borrow;

pub mod define;

/// A trait that marks a type as invariant of other base type.
pub trait TypeInvariant<BaseType>: Into<BaseType> + Borrow<BaseType> {}

impl<T> TypeInvariant<T> for T {}

/// A marker type for types, that encodes requirement of a type invariant, from it's base-type
pub trait InvariantRequirement: Clone {}

#[derive(Debug, thiserror::Error)]
pub struct InvariantRequirementViolation<V, RQ: Clone> {
    pub value: V,
    pub requirement: RQ,
}
