use sha2::{Sha224, Sha256, Sha384, Sha512, Sha512Trunc224, Sha512Trunc256};

use super::DigestCreate;

fn create(digest: &mut impl sha2::Digest, input: &[u8]) -> String {
    digest.update(input);
    base64::encode(&digest.finalize_reset())
}

impl DigestCreate for Sha224 {
    const NAME: &'static str = "SHA-224";

    fn compute(&mut self, input: &[u8]) -> String {
        create(self, input)
    }
}

impl DigestCreate for Sha256 {
    const NAME: &'static str = "SHA-256";

    fn compute(&mut self, input: &[u8]) -> String {
        create(self, input)
    }
}

impl DigestCreate for Sha384 {
    const NAME: &'static str = "SHA-384";

    fn compute(&mut self, input: &[u8]) -> String {
        create(self, input)
    }
}

impl DigestCreate for Sha512 {
    const NAME: &'static str = "SHA-512";

    fn compute(&mut self, input: &[u8]) -> String {
        create(self, input)
    }
}

impl DigestCreate for Sha512Trunc224 {
    const NAME: &'static str = "SHA-512-224";

    fn compute(&mut self, input: &[u8]) -> String {
        create(self, input)
    }
}

impl DigestCreate for Sha512Trunc256 {
    const NAME: &'static str = "SHA-512-256";

    fn compute(&mut self, input: &[u8]) -> String {
        create(self, input)
    }
}
