//! https://datatracker.ietf.org/doc/html/rfc2616#section-5.1.2

#[derive(Debug, Copy, Clone, PartialEq, Eq, PartialOrd, Ord, Hash)]
pub enum RequestUri<'a> {
    Asterisk,
    AbsoluteUri {
        scheme: &'a str,
        username: Option<&'a str>,
        password: Option<&'a str>,
        host: &'a str,
        port: Option<u16>,
        path: &'a str,
        query: Option<&'a str>,
        fragment: Option<&'a str>,
    },
    AbsPath {
        path: &'a str,
        query: Option<&'a str>,
        fragment: Option<&'a str>,
    },
    Authority {
        host: &'a str,
        port: Option<u16>,
    },
}

#[cfg(feature = "with-http")]
mod impl_http;
