use core::fmt::{self, Debug};

use downcast_rs::{impl_downcast, DowncastSync};
use dyn_clone::{clone_trait_object, DynClone};

mod impl_handler_data;
mod impl_internal;

//
pub trait HandlerDataTrait: DowncastSync + DynClone {}

impl_downcast!(HandlerDataTrait);
clone_trait_object!(HandlerDataTrait);

impl Debug for (dyn HandlerDataTrait) {
    fn fmt(&self, f: &mut fmt::Formatter<'_>) -> fmt::Result {
        f.debug_tuple("HandlerDataTrait")
            .field(&format_args!("_"))
            .finish()
    }
}
impl Debug for (dyn HandlerDataTrait + Send + Sync) {
    fn fmt(&self, f: &mut fmt::Formatter<'_>) -> fmt::Result {
        f.debug_tuple("HandlerDataTrait")
            .field(&format_args!("_"))
            .finish()
    }
}

#[cfg(test)]
mod tests {
    use super::*;

    use alloc::{
        boxed::Box,
        string::{String, ToString as _},
        vec,
        vec::Vec,
    };

    #[derive(Debug, Clone)]
    struct HandlerDataTraitStorage(Vec<Box<dyn HandlerDataTrait>>);

    #[test]
    fn test_handler_data_trait_dyn_clone_and_debug() {
        let handler_data_trait_list =
            HandlerDataTraitStorage(vec![Box::new(1), Box::new("foo".to_string())]);
        #[allow(clippy::redundant_clone)]
        let handler_data_trait_list = handler_data_trait_list.clone();
        #[cfg(feature = "std")]
        println!("handler_data_trait_list: {:?}", handler_data_trait_list);
        assert_eq!(handler_data_trait_list.0.len(), 2);
    }

    #[test]
    fn test_handler_data_trait_downcast() {
        let handler_data_trait: Box<dyn HandlerDataTrait> = Box::new("foo".to_string());
        assert_eq!(handler_data_trait.downcast_ref::<String>().unwrap(), "foo");
    }
}
