use core::{
    cmp::PartialEq,
    fmt::{self, Debug},
};

//
#[derive(Clone)]
pub struct HandlerData<T>(pub T)
where
    T: Clone;

impl<T> Debug for HandlerData<T>
where
    T: Clone + Debug,
{
    fn fmt(&self, f: &mut fmt::Formatter<'_>) -> fmt::Result {
        f.debug_tuple("HandlerData").field(&self.0).finish()
    }
}

impl<T> PartialEq for HandlerData<T>
where
    T: Clone + PartialEq,
{
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
