/* automatically generated by rust-bindgen */

#[repr(C)]
#[derive(Copy, Clone, Debug, Default, Eq, Hash, Ord, PartialEq, PartialOrd)]
pub struct __BindgenBitfieldUnit<Storage, Align> {
    storage: Storage,
    align: [Align; 0],
}
impl<Storage, Align> __BindgenBitfieldUnit<Storage, Align> {
    #[inline]
    pub const fn new(storage: Storage) -> Self {
        Self { storage, align: [] }
    }
}
impl<Storage, Align> __BindgenBitfieldUnit<Storage, Align>
where
    Storage: AsRef<[u8]> + AsMut<[u8]>,
{
    #[inline]
    pub fn get_bit(&self, index: usize) -> bool {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = self.storage.as_ref()[byte_index];
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        byte & mask == mask
    }
    #[inline]
    pub fn set_bit(&mut self, index: usize, val: bool) {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = &mut self.storage.as_mut()[byte_index];
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        if val {
            *byte |= mask;
        } else {
            *byte &= !mask;
        }
    }
    #[inline]
    pub fn get(&self, bit_offset: usize, bit_width: u8) -> u64 {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        let mut val = 0;
        for i in 0..(bit_width as usize) {
            if self.get_bit(i + bit_offset) {
                let index = if cfg!(target_endian = "big") {
                    bit_width as usize - 1 - i
                } else {
                    i
                };
                val |= 1 << index;
            }
        }
        val
    }
    #[inline]
    pub fn set(&mut self, bit_offset: usize, bit_width: u8, val: u64) {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        for i in 0..(bit_width as usize) {
            let mask = 1 << i;
            let val_bit_is_set = val & mask == mask;
            let index = if cfg!(target_endian = "big") {
                bit_width as usize - 1 - i
            } else {
                i
            };
            self.set_bit(index + bit_offset, val_bit_is_set);
        }
    }
}
pub const __WORDSIZE: u32 = 64;
pub const __DARWIN_ONLY_64_BIT_INO_T: u32 = 0;
pub const __DARWIN_ONLY_VERS_1050: u32 = 0;
pub const __DARWIN_ONLY_UNIX_CONFORMANCE: u32 = 1;
pub const __DARWIN_UNIX03: u32 = 1;
pub const __DARWIN_64_BIT_INO_T: u32 = 1;
pub const __DARWIN_VERS_1050: u32 = 1;
pub const __DARWIN_NON_CANCELABLE: u32 = 0;
pub const __DARWIN_SUF_64_BIT_INO_T: &'static [u8; 9usize] = b"$INODE64\0";
pub const __DARWIN_SUF_1050: &'static [u8; 6usize] = b"$1050\0";
pub const __DARWIN_SUF_EXTSN: &'static [u8; 14usize] = b"$DARWIN_EXTSN\0";
pub const __DARWIN_C_ANSI: u32 = 4096;
pub const __DARWIN_C_FULL: u32 = 900000;
pub const __DARWIN_C_LEVEL: u32 = 900000;
pub const __STDC_WANT_LIB_EXT1__: u32 = 1;
pub const __DARWIN_NO_LONG_LONG: u32 = 0;
pub const _DARWIN_FEATURE_64_BIT_INODE: u32 = 1;
pub const _DARWIN_FEATURE_ONLY_UNIX_CONFORMANCE: u32 = 1;
pub const _DARWIN_FEATURE_UNIX_CONFORMANCE: u32 = 3;
pub const __PTHREAD_SIZE__: u32 = 8176;
pub const __PTHREAD_ATTR_SIZE__: u32 = 56;
pub const __PTHREAD_MUTEXATTR_SIZE__: u32 = 8;
pub const __PTHREAD_MUTEX_SIZE__: u32 = 56;
pub const __PTHREAD_CONDATTR_SIZE__: u32 = 8;
pub const __PTHREAD_COND_SIZE__: u32 = 40;
pub const __PTHREAD_ONCE_SIZE__: u32 = 8;
pub const __PTHREAD_RWLOCK_SIZE__: u32 = 192;
pub const __PTHREAD_RWLOCKATTR_SIZE__: u32 = 16;
pub const INT8_MAX: u32 = 127;
pub const INT16_MAX: u32 = 32767;
pub const INT32_MAX: u32 = 2147483647;
pub const INT64_MAX: u64 = 9223372036854775807;
pub const INT8_MIN: i32 = -128;
pub const INT16_MIN: i32 = -32768;
pub const INT32_MIN: i32 = -2147483648;
pub const INT64_MIN: i64 = -9223372036854775808;
pub const UINT8_MAX: u32 = 255;
pub const UINT16_MAX: u32 = 65535;
pub const UINT32_MAX: u32 = 4294967295;
pub const UINT64_MAX: i32 = -1;
pub const INT_LEAST8_MIN: i32 = -128;
pub const INT_LEAST16_MIN: i32 = -32768;
pub const INT_LEAST32_MIN: i32 = -2147483648;
pub const INT_LEAST64_MIN: i64 = -9223372036854775808;
pub const INT_LEAST8_MAX: u32 = 127;
pub const INT_LEAST16_MAX: u32 = 32767;
pub const INT_LEAST32_MAX: u32 = 2147483647;
pub const INT_LEAST64_MAX: u64 = 9223372036854775807;
pub const UINT_LEAST8_MAX: u32 = 255;
pub const UINT_LEAST16_MAX: u32 = 65535;
pub const UINT_LEAST32_MAX: u32 = 4294967295;
pub const UINT_LEAST64_MAX: i32 = -1;
pub const INT_FAST8_MIN: i32 = -128;
pub const INT_FAST16_MIN: i32 = -32768;
pub const INT_FAST32_MIN: i32 = -2147483648;
pub const INT_FAST64_MIN: i64 = -9223372036854775808;
pub const INT_FAST8_MAX: u32 = 127;
pub const INT_FAST16_MAX: u32 = 32767;
pub const INT_FAST32_MAX: u32 = 2147483647;
pub const INT_FAST64_MAX: u64 = 9223372036854775807;
pub const UINT_FAST8_MAX: u32 = 255;
pub const UINT_FAST16_MAX: u32 = 65535;
pub const UINT_FAST32_MAX: u32 = 4294967295;
pub const UINT_FAST64_MAX: i32 = -1;
pub const INTPTR_MAX: u64 = 9223372036854775807;
pub const INTPTR_MIN: i64 = -9223372036854775808;
pub const UINTPTR_MAX: i32 = -1;
pub const SIZE_MAX: i32 = -1;
pub const RSIZE_MAX: i32 = -1;
pub const WINT_MIN: i32 = -2147483648;
pub const WINT_MAX: u32 = 2147483647;
pub const SIG_ATOMIC_MIN: i32 = -2147483648;
pub const SIG_ATOMIC_MAX: u32 = 2147483647;
pub const __PRI_8_LENGTH_MODIFIER__: &'static [u8; 3usize] = b"hh\0";
pub const __PRI_64_LENGTH_MODIFIER__: &'static [u8; 3usize] = b"ll\0";
pub const __SCN_64_LENGTH_MODIFIER__: &'static [u8; 3usize] = b"ll\0";
pub const __PRI_MAX_LENGTH_MODIFIER__: &'static [u8; 2usize] = b"j\0";
pub const __SCN_MAX_LENGTH_MODIFIER__: &'static [u8; 2usize] = b"j\0";
pub const PRId8: &'static [u8; 4usize] = b"hhd\0";
pub const PRIi8: &'static [u8; 4usize] = b"hhi\0";
pub const PRIo8: &'static [u8; 4usize] = b"hho\0";
pub const PRIu8: &'static [u8; 4usize] = b"hhu\0";
pub const PRIx8: &'static [u8; 4usize] = b"hhx\0";
pub const PRIX8: &'static [u8; 4usize] = b"hhX\0";
pub const PRId16: &'static [u8; 3usize] = b"hd\0";
pub const PRIi16: &'static [u8; 3usize] = b"hi\0";
pub const PRIo16: &'static [u8; 3usize] = b"ho\0";
pub const PRIu16: &'static [u8; 3usize] = b"hu\0";
pub const PRIx16: &'static [u8; 3usize] = b"hx\0";
pub const PRIX16: &'static [u8; 3usize] = b"hX\0";
pub const PRId32: &'static [u8; 2usize] = b"d\0";
pub const PRIi32: &'static [u8; 2usize] = b"i\0";
pub const PRIo32: &'static [u8; 2usize] = b"o\0";
pub const PRIu32: &'static [u8; 2usize] = b"u\0";
pub const PRIx32: &'static [u8; 2usize] = b"x\0";
pub const PRIX32: &'static [u8; 2usize] = b"X\0";
pub const PRId64: &'static [u8; 4usize] = b"lld\0";
pub const PRIi64: &'static [u8; 4usize] = b"lli\0";
pub const PRIo64: &'static [u8; 4usize] = b"llo\0";
pub const PRIu64: &'static [u8; 4usize] = b"llu\0";
pub const PRIx64: &'static [u8; 4usize] = b"llx\0";
pub const PRIX64: &'static [u8; 4usize] = b"llX\0";
pub const PRIdLEAST8: &'static [u8; 4usize] = b"hhd\0";
pub const PRIiLEAST8: &'static [u8; 4usize] = b"hhi\0";
pub const PRIoLEAST8: &'static [u8; 4usize] = b"hho\0";
pub const PRIuLEAST8: &'static [u8; 4usize] = b"hhu\0";
pub const PRIxLEAST8: &'static [u8; 4usize] = b"hhx\0";
pub const PRIXLEAST8: &'static [u8; 4usize] = b"hhX\0";
pub const PRIdLEAST16: &'static [u8; 3usize] = b"hd\0";
pub const PRIiLEAST16: &'static [u8; 3usize] = b"hi\0";
pub const PRIoLEAST16: &'static [u8; 3usize] = b"ho\0";
pub const PRIuLEAST16: &'static [u8; 3usize] = b"hu\0";
pub const PRIxLEAST16: &'static [u8; 3usize] = b"hx\0";
pub const PRIXLEAST16: &'static [u8; 3usize] = b"hX\0";
pub const PRIdLEAST32: &'static [u8; 2usize] = b"d\0";
pub const PRIiLEAST32: &'static [u8; 2usize] = b"i\0";
pub const PRIoLEAST32: &'static [u8; 2usize] = b"o\0";
pub const PRIuLEAST32: &'static [u8; 2usize] = b"u\0";
pub const PRIxLEAST32: &'static [u8; 2usize] = b"x\0";
pub const PRIXLEAST32: &'static [u8; 2usize] = b"X\0";
pub const PRIdLEAST64: &'static [u8; 4usize] = b"lld\0";
pub const PRIiLEAST64: &'static [u8; 4usize] = b"lli\0";
pub const PRIoLEAST64: &'static [u8; 4usize] = b"llo\0";
pub const PRIuLEAST64: &'static [u8; 4usize] = b"llu\0";
pub const PRIxLEAST64: &'static [u8; 4usize] = b"llx\0";
pub const PRIXLEAST64: &'static [u8; 4usize] = b"llX\0";
pub const PRIdFAST8: &'static [u8; 4usize] = b"hhd\0";
pub const PRIiFAST8: &'static [u8; 4usize] = b"hhi\0";
pub const PRIoFAST8: &'static [u8; 4usize] = b"hho\0";
pub const PRIuFAST8: &'static [u8; 4usize] = b"hhu\0";
pub const PRIxFAST8: &'static [u8; 4usize] = b"hhx\0";
pub const PRIXFAST8: &'static [u8; 4usize] = b"hhX\0";
pub const PRIdFAST16: &'static [u8; 3usize] = b"hd\0";
pub const PRIiFAST16: &'static [u8; 3usize] = b"hi\0";
pub const PRIoFAST16: &'static [u8; 3usize] = b"ho\0";
pub const PRIuFAST16: &'static [u8; 3usize] = b"hu\0";
pub const PRIxFAST16: &'static [u8; 3usize] = b"hx\0";
pub const PRIXFAST16: &'static [u8; 3usize] = b"hX\0";
pub const PRIdFAST32: &'static [u8; 2usize] = b"d\0";
pub const PRIiFAST32: &'static [u8; 2usize] = b"i\0";
pub const PRIoFAST32: &'static [u8; 2usize] = b"o\0";
pub const PRIuFAST32: &'static [u8; 2usize] = b"u\0";
pub const PRIxFAST32: &'static [u8; 2usize] = b"x\0";
pub const PRIXFAST32: &'static [u8; 2usize] = b"X\0";
pub const PRIdFAST64: &'static [u8; 4usize] = b"lld\0";
pub const PRIiFAST64: &'static [u8; 4usize] = b"lli\0";
pub const PRIoFAST64: &'static [u8; 4usize] = b"llo\0";
pub const PRIuFAST64: &'static [u8; 4usize] = b"llu\0";
pub const PRIxFAST64: &'static [u8; 4usize] = b"llx\0";
pub const PRIXFAST64: &'static [u8; 4usize] = b"llX\0";
pub const PRIdPTR: &'static [u8; 3usize] = b"ld\0";
pub const PRIiPTR: &'static [u8; 3usize] = b"li\0";
pub const PRIoPTR: &'static [u8; 3usize] = b"lo\0";
pub const PRIuPTR: &'static [u8; 3usize] = b"lu\0";
pub const PRIxPTR: &'static [u8; 3usize] = b"lx\0";
pub const PRIXPTR: &'static [u8; 3usize] = b"lX\0";
pub const PRIdMAX: &'static [u8; 3usize] = b"jd\0";
pub const PRIiMAX: &'static [u8; 3usize] = b"ji\0";
pub const PRIoMAX: &'static [u8; 3usize] = b"jo\0";
pub const PRIuMAX: &'static [u8; 3usize] = b"ju\0";
pub const PRIxMAX: &'static [u8; 3usize] = b"jx\0";
pub const PRIXMAX: &'static [u8; 3usize] = b"jX\0";
pub const SCNd8: &'static [u8; 4usize] = b"hhd\0";
pub const SCNi8: &'static [u8; 4usize] = b"hhi\0";
pub const SCNo8: &'static [u8; 4usize] = b"hho\0";
pub const SCNu8: &'static [u8; 4usize] = b"hhu\0";
pub const SCNx8: &'static [u8; 4usize] = b"hhx\0";
pub const SCNd16: &'static [u8; 3usize] = b"hd\0";
pub const SCNi16: &'static [u8; 3usize] = b"hi\0";
pub const SCNo16: &'static [u8; 3usize] = b"ho\0";
pub const SCNu16: &'static [u8; 3usize] = b"hu\0";
pub const SCNx16: &'static [u8; 3usize] = b"hx\0";
pub const SCNd32: &'static [u8; 2usize] = b"d\0";
pub const SCNi32: &'static [u8; 2usize] = b"i\0";
pub const SCNo32: &'static [u8; 2usize] = b"o\0";
pub const SCNu32: &'static [u8; 2usize] = b"u\0";
pub const SCNx32: &'static [u8; 2usize] = b"x\0";
pub const SCNd64: &'static [u8; 4usize] = b"lld\0";
pub const SCNi64: &'static [u8; 4usize] = b"lli\0";
pub const SCNo64: &'static [u8; 4usize] = b"llo\0";
pub const SCNu64: &'static [u8; 4usize] = b"llu\0";
pub const SCNx64: &'static [u8; 4usize] = b"llx\0";
pub const SCNdLEAST8: &'static [u8; 4usize] = b"hhd\0";
pub const SCNiLEAST8: &'static [u8; 4usize] = b"hhi\0";
pub const SCNoLEAST8: &'static [u8; 4usize] = b"hho\0";
pub const SCNuLEAST8: &'static [u8; 4usize] = b"hhu\0";
pub const SCNxLEAST8: &'static [u8; 4usize] = b"hhx\0";
pub const SCNdLEAST16: &'static [u8; 3usize] = b"hd\0";
pub const SCNiLEAST16: &'static [u8; 3usize] = b"hi\0";
pub const SCNoLEAST16: &'static [u8; 3usize] = b"ho\0";
pub const SCNuLEAST16: &'static [u8; 3usize] = b"hu\0";
pub const SCNxLEAST16: &'static [u8; 3usize] = b"hx\0";
pub const SCNdLEAST32: &'static [u8; 2usize] = b"d\0";
pub const SCNiLEAST32: &'static [u8; 2usize] = b"i\0";
pub const SCNoLEAST32: &'static [u8; 2usize] = b"o\0";
pub const SCNuLEAST32: &'static [u8; 2usize] = b"u\0";
pub const SCNxLEAST32: &'static [u8; 2usize] = b"x\0";
pub const SCNdLEAST64: &'static [u8; 4usize] = b"lld\0";
pub const SCNiLEAST64: &'static [u8; 4usize] = b"lli\0";
pub const SCNoLEAST64: &'static [u8; 4usize] = b"llo\0";
pub const SCNuLEAST64: &'static [u8; 4usize] = b"llu\0";
pub const SCNxLEAST64: &'static [u8; 4usize] = b"llx\0";
pub const SCNdFAST8: &'static [u8; 4usize] = b"hhd\0";
pub const SCNiFAST8: &'static [u8; 4usize] = b"hhi\0";
pub const SCNoFAST8: &'static [u8; 4usize] = b"hho\0";
pub const SCNuFAST8: &'static [u8; 4usize] = b"hhu\0";
pub const SCNxFAST8: &'static [u8; 4usize] = b"hhx\0";
pub const SCNdFAST16: &'static [u8; 3usize] = b"hd\0";
pub const SCNiFAST16: &'static [u8; 3usize] = b"hi\0";
pub const SCNoFAST16: &'static [u8; 3usize] = b"ho\0";
pub const SCNuFAST16: &'static [u8; 3usize] = b"hu\0";
pub const SCNxFAST16: &'static [u8; 3usize] = b"hx\0";
pub const SCNdFAST32: &'static [u8; 2usize] = b"d\0";
pub const SCNiFAST32: &'static [u8; 2usize] = b"i\0";
pub const SCNoFAST32: &'static [u8; 2usize] = b"o\0";
pub const SCNuFAST32: &'static [u8; 2usize] = b"u\0";
pub const SCNxFAST32: &'static [u8; 2usize] = b"x\0";
pub const SCNdFAST64: &'static [u8; 4usize] = b"lld\0";
pub const SCNiFAST64: &'static [u8; 4usize] = b"lli\0";
pub const SCNoFAST64: &'static [u8; 4usize] = b"llo\0";
pub const SCNuFAST64: &'static [u8; 4usize] = b"llu\0";
pub const SCNxFAST64: &'static [u8; 4usize] = b"llx\0";
pub const SCNdPTR: &'static [u8; 3usize] = b"ld\0";
pub const SCNiPTR: &'static [u8; 3usize] = b"li\0";
pub const SCNoPTR: &'static [u8; 3usize] = b"lo\0";
pub const SCNuPTR: &'static [u8; 3usize] = b"lu\0";
pub const SCNxPTR: &'static [u8; 3usize] = b"lx\0";
pub const SCNdMAX: &'static [u8; 3usize] = b"jd\0";
pub const SCNiMAX: &'static [u8; 3usize] = b"ji\0";
pub const SCNoMAX: &'static [u8; 3usize] = b"jo\0";
pub const SCNuMAX: &'static [u8; 3usize] = b"ju\0";
pub const SCNxMAX: &'static [u8; 3usize] = b"jx\0";
pub const __API_TO_BE_DEPRECATED: u32 = 100000;
pub const __MAC_10_0: u32 = 1000;
pub const __MAC_10_1: u32 = 1010;
pub const __MAC_10_2: u32 = 1020;
pub const __MAC_10_3: u32 = 1030;
pub const __MAC_10_4: u32 = 1040;
pub const __MAC_10_5: u32 = 1050;
pub const __MAC_10_6: u32 = 1060;
pub const __MAC_10_7: u32 = 1070;
pub const __MAC_10_8: u32 = 1080;
pub const __MAC_10_9: u32 = 1090;
pub const __MAC_10_10: u32 = 101000;
pub const __MAC_10_10_2: u32 = 101002;
pub const __MAC_10_10_3: u32 = 101003;
pub const __MAC_10_11: u32 = 101100;
pub const __MAC_10_11_2: u32 = 101102;
pub const __MAC_10_11_3: u32 = 101103;
pub const __MAC_10_11_4: u32 = 101104;
pub const __MAC_10_12: u32 = 101200;
pub const __MAC_10_12_1: u32 = 101201;
pub const __MAC_10_12_2: u32 = 101202;
pub const __MAC_10_12_4: u32 = 101204;
pub const __MAC_10_13: u32 = 101300;
pub const __MAC_10_13_1: u32 = 101301;
pub const __MAC_10_13_2: u32 = 101302;
pub const __MAC_10_13_4: u32 = 101304;
pub const __MAC_10_14: u32 = 101400;
pub const __MAC_10_14_1: u32 = 101401;
pub const __MAC_10_14_4: u32 = 101404;
pub const __MAC_10_15: u32 = 101500;
pub const __MAC_10_15_1: u32 = 101501;
pub const __MAC_10_15_4: u32 = 101504;
pub const __IPHONE_2_0: u32 = 20000;
pub const __IPHONE_2_1: u32 = 20100;
pub const __IPHONE_2_2: u32 = 20200;
pub const __IPHONE_3_0: u32 = 30000;
pub const __IPHONE_3_1: u32 = 30100;
pub const __IPHONE_3_2: u32 = 30200;
pub const __IPHONE_4_0: u32 = 40000;
pub const __IPHONE_4_1: u32 = 40100;
pub const __IPHONE_4_2: u32 = 40200;
pub const __IPHONE_4_3: u32 = 40300;
pub const __IPHONE_5_0: u32 = 50000;
pub const __IPHONE_5_1: u32 = 50100;
pub const __IPHONE_6_0: u32 = 60000;
pub const __IPHONE_6_1: u32 = 60100;
pub const __IPHONE_7_0: u32 = 70000;
pub const __IPHONE_7_1: u32 = 70100;
pub const __IPHONE_8_0: u32 = 80000;
pub const __IPHONE_8_1: u32 = 80100;
pub const __IPHONE_8_2: u32 = 80200;
pub const __IPHONE_8_3: u32 = 80300;
pub const __IPHONE_8_4: u32 = 80400;
pub const __IPHONE_9_0: u32 = 90000;
pub const __IPHONE_9_1: u32 = 90100;
pub const __IPHONE_9_2: u32 = 90200;
pub const __IPHONE_9_3: u32 = 90300;
pub const __IPHONE_10_0: u32 = 100000;
pub const __IPHONE_10_1: u32 = 100100;
pub const __IPHONE_10_2: u32 = 100200;
pub const __IPHONE_10_3: u32 = 100300;
pub const __IPHONE_11_0: u32 = 110000;
pub const __IPHONE_11_1: u32 = 110100;
pub const __IPHONE_11_2: u32 = 110200;
pub const __IPHONE_11_3: u32 = 110300;
pub const __IPHONE_11_4: u32 = 110400;
pub const __IPHONE_12_0: u32 = 120000;
pub const __IPHONE_12_1: u32 = 120100;
pub const __IPHONE_12_2: u32 = 120200;
pub const __IPHONE_12_3: u32 = 120300;
pub const __IPHONE_13_0: u32 = 130000;
pub const __IPHONE_13_1: u32 = 130100;
pub const __IPHONE_13_2: u32 = 130200;
pub const __IPHONE_13_3: u32 = 130300;
pub const __IPHONE_13_4: u32 = 130400;
pub const __TVOS_9_0: u32 = 90000;
pub const __TVOS_9_1: u32 = 90100;
pub const __TVOS_9_2: u32 = 90200;
pub const __TVOS_10_0: u32 = 100000;
pub const __TVOS_10_0_1: u32 = 100001;
pub const __TVOS_10_1: u32 = 100100;
pub const __TVOS_10_2: u32 = 100200;
pub const __TVOS_11_0: u32 = 110000;
pub const __TVOS_11_1: u32 = 110100;
pub const __TVOS_11_2: u32 = 110200;
pub const __TVOS_11_3: u32 = 110300;
pub const __TVOS_11_4: u32 = 110400;
pub const __TVOS_12_0: u32 = 120000;
pub const __TVOS_12_1: u32 = 120100;
pub const __TVOS_12_2: u32 = 120200;
pub const __TVOS_12_3: u32 = 120300;
pub const __TVOS_13_0: u32 = 130000;
pub const __TVOS_13_2: u32 = 130200;
pub const __TVOS_13_3: u32 = 130300;
pub const __TVOS_13_4: u32 = 130400;
pub const __WATCHOS_1_0: u32 = 10000;
pub const __WATCHOS_2_0: u32 = 20000;
pub const __WATCHOS_2_1: u32 = 20100;
pub const __WATCHOS_2_2: u32 = 20200;
pub const __WATCHOS_3_0: u32 = 30000;
pub const __WATCHOS_3_1: u32 = 30100;
pub const __WATCHOS_3_1_1: u32 = 30101;
pub const __WATCHOS_3_2: u32 = 30200;
pub const __WATCHOS_4_0: u32 = 40000;
pub const __WATCHOS_4_1: u32 = 40100;
pub const __WATCHOS_4_2: u32 = 40200;
pub const __WATCHOS_4_3: u32 = 40300;
pub const __WATCHOS_5_0: u32 = 50000;
pub const __WATCHOS_5_1: u32 = 50100;
pub const __WATCHOS_5_2: u32 = 50200;
pub const __WATCHOS_6_0: u32 = 60000;
pub const __WATCHOS_6_1: u32 = 60100;
pub const __WATCHOS_6_2: u32 = 60200;
pub const __DRIVERKIT_19_0: u32 = 190000;
pub const __MAC_OS_X_VERSION_MAX_ALLOWED: u32 = 101500;
pub const __ENABLE_LEGACY_MAC_AVAILABILITY: u32 = 1;
pub const __DARWIN_WCHAR_MIN: i32 = -2147483648;
pub const _FORTIFY_SOURCE: u32 = 2;
pub const __DARWIN_NSIG: u32 = 32;
pub const NSIG: u32 = 32;
pub const _I386_SIGNAL_H_: u32 = 1;
pub const SIGHUP: u32 = 1;
pub const SIGINT: u32 = 2;
pub const SIGQUIT: u32 = 3;
pub const SIGILL: u32 = 4;
pub const SIGTRAP: u32 = 5;
pub const SIGABRT: u32 = 6;
pub const SIGIOT: u32 = 6;
pub const SIGEMT: u32 = 7;
pub const SIGFPE: u32 = 8;
pub const SIGKILL: u32 = 9;
pub const SIGBUS: u32 = 10;
pub const SIGSEGV: u32 = 11;
pub const SIGSYS: u32 = 12;
pub const SIGPIPE: u32 = 13;
pub const SIGALRM: u32 = 14;
pub const SIGTERM: u32 = 15;
pub const SIGURG: u32 = 16;
pub const SIGSTOP: u32 = 17;
pub const SIGTSTP: u32 = 18;
pub const SIGCONT: u32 = 19;
pub const SIGCHLD: u32 = 20;
pub const SIGTTIN: u32 = 21;
pub const SIGTTOU: u32 = 22;
pub const SIGIO: u32 = 23;
pub const SIGXCPU: u32 = 24;
pub const SIGXFSZ: u32 = 25;
pub const SIGVTALRM: u32 = 26;
pub const SIGPROF: u32 = 27;
pub const SIGWINCH: u32 = 28;
pub const SIGINFO: u32 = 29;
pub const SIGUSR1: u32 = 30;
pub const SIGUSR2: u32 = 31;
pub const FP_PREC_24B: u32 = 0;
pub const FP_PREC_53B: u32 = 2;
pub const FP_PREC_64B: u32 = 3;
pub const FP_RND_NEAR: u32 = 0;
pub const FP_RND_DOWN: u32 = 1;
pub const FP_RND_UP: u32 = 2;
pub const FP_CHOP: u32 = 3;
pub const FP_STATE_BYTES: u32 = 512;
pub const SIGEV_NONE: u32 = 0;
pub const SIGEV_SIGNAL: u32 = 1;
pub const SIGEV_THREAD: u32 = 3;
pub const ILL_NOOP: u32 = 0;
pub const ILL_ILLOPC: u32 = 1;
pub const ILL_ILLTRP: u32 = 2;
pub const ILL_PRVOPC: u32 = 3;
pub const ILL_ILLOPN: u32 = 4;
pub const ILL_ILLADR: u32 = 5;
pub const ILL_PRVREG: u32 = 6;
pub const ILL_COPROC: u32 = 7;
pub const ILL_BADSTK: u32 = 8;
pub const FPE_NOOP: u32 = 0;
pub const FPE_FLTDIV: u32 = 1;
pub const FPE_FLTOVF: u32 = 2;
pub const FPE_FLTUND: u32 = 3;
pub const FPE_FLTRES: u32 = 4;
pub const FPE_FLTINV: u32 = 5;
pub const FPE_FLTSUB: u32 = 6;
pub const FPE_INTDIV: u32 = 7;
pub const FPE_INTOVF: u32 = 8;
pub const SEGV_NOOP: u32 = 0;
pub const SEGV_MAPERR: u32 = 1;
pub const SEGV_ACCERR: u32 = 2;
pub const BUS_NOOP: u32 = 0;
pub const BUS_ADRALN: u32 = 1;
pub const BUS_ADRERR: u32 = 2;
pub const BUS_OBJERR: u32 = 3;
pub const TRAP_BRKPT: u32 = 1;
pub const TRAP_TRACE: u32 = 2;
pub const CLD_NOOP: u32 = 0;
pub const CLD_EXITED: u32 = 1;
pub const CLD_KILLED: u32 = 2;
pub const CLD_DUMPED: u32 = 3;
pub const CLD_TRAPPED: u32 = 4;
pub const CLD_STOPPED: u32 = 5;
pub const CLD_CONTINUED: u32 = 6;
pub const POLL_IN: u32 = 1;
pub const POLL_OUT: u32 = 2;
pub const POLL_MSG: u32 = 3;
pub const POLL_ERR: u32 = 4;
pub const POLL_PRI: u32 = 5;
pub const POLL_HUP: u32 = 6;
pub const SA_ONSTACK: u32 = 1;
pub const SA_RESTART: u32 = 2;
pub const SA_RESETHAND: u32 = 4;
pub const SA_NOCLDSTOP: u32 = 8;
pub const SA_NODEFER: u32 = 16;
pub const SA_NOCLDWAIT: u32 = 32;
pub const SA_SIGINFO: u32 = 64;
pub const SA_USERTRAMP: u32 = 256;
pub const SA_64REGSET: u32 = 512;
pub const SA_USERSPACE_MASK: u32 = 127;
pub const SIG_BLOCK: u32 = 1;
pub const SIG_UNBLOCK: u32 = 2;
pub const SIG_SETMASK: u32 = 3;
pub const SI_USER: u32 = 65537;
pub const SI_QUEUE: u32 = 65538;
pub const SI_TIMER: u32 = 65539;
pub const SI_ASYNCIO: u32 = 65540;
pub const SI_MESGQ: u32 = 65541;
pub const SS_ONSTACK: u32 = 1;
pub const SS_DISABLE: u32 = 4;
pub const MINSIGSTKSZ: u32 = 32768;
pub const SIGSTKSZ: u32 = 131072;
pub const SV_ONSTACK: u32 = 1;
pub const SV_INTERRUPT: u32 = 2;
pub const SV_RESETHAND: u32 = 4;
pub const SV_NODEFER: u32 = 16;
pub const SV_NOCLDSTOP: u32 = 8;
pub const SV_SIGINFO: u32 = 64;
pub const PRIO_PROCESS: u32 = 0;
pub const PRIO_PGRP: u32 = 1;
pub const PRIO_USER: u32 = 2;
pub const PRIO_DARWIN_THREAD: u32 = 3;
pub const PRIO_DARWIN_PROCESS: u32 = 4;
pub const PRIO_MIN: i32 = -20;
pub const PRIO_MAX: u32 = 20;
pub const PRIO_DARWIN_BG: u32 = 4096;
pub const PRIO_DARWIN_NONUI: u32 = 4097;
pub const RUSAGE_SELF: u32 = 0;
pub const RUSAGE_CHILDREN: i32 = -1;
pub const RUSAGE_INFO_V0: u32 = 0;
pub const RUSAGE_INFO_V1: u32 = 1;
pub const RUSAGE_INFO_V2: u32 = 2;
pub const RUSAGE_INFO_V3: u32 = 3;
pub const RUSAGE_INFO_V4: u32 = 4;
pub const RUSAGE_INFO_CURRENT: u32 = 4;
pub const RLIMIT_CPU: u32 = 0;
pub const RLIMIT_FSIZE: u32 = 1;
pub const RLIMIT_DATA: u32 = 2;
pub const RLIMIT_STACK: u32 = 3;
pub const RLIMIT_CORE: u32 = 4;
pub const RLIMIT_AS: u32 = 5;
pub const RLIMIT_RSS: u32 = 5;
pub const RLIMIT_MEMLOCK: u32 = 6;
pub const RLIMIT_NPROC: u32 = 7;
pub const RLIMIT_NOFILE: u32 = 8;
pub const RLIM_NLIMITS: u32 = 9;
pub const _RLIMIT_POSIX_FLAG: u32 = 4096;
pub const RLIMIT_WAKEUPS_MONITOR: u32 = 1;
pub const RLIMIT_CPU_USAGE_MONITOR: u32 = 2;
pub const RLIMIT_THREAD_CPULIMITS: u32 = 3;
pub const RLIMIT_FOOTPRINT_INTERVAL: u32 = 4;
pub const WAKEMON_ENABLE: u32 = 1;
pub const WAKEMON_DISABLE: u32 = 2;
pub const WAKEMON_GET_PARAMS: u32 = 4;
pub const WAKEMON_SET_DEFAULTS: u32 = 8;
pub const WAKEMON_MAKE_FATAL: u32 = 16;
pub const CPUMON_MAKE_FATAL: u32 = 4096;
pub const FOOTPRINT_INTERVAL_RESET: u32 = 1;
pub const IOPOL_TYPE_DISK: u32 = 0;
pub const IOPOL_TYPE_VFS_ATIME_UPDATES: u32 = 2;
pub const IOPOL_TYPE_VFS_MATERIALIZE_DATALESS_FILES: u32 = 3;
pub const IOPOL_TYPE_VFS_STATFS_NO_DATA_VOLUME: u32 = 4;
pub const IOPOL_SCOPE_PROCESS: u32 = 0;
pub const IOPOL_SCOPE_THREAD: u32 = 1;
pub const IOPOL_SCOPE_DARWIN_BG: u32 = 2;
pub const IOPOL_DEFAULT: u32 = 0;
pub const IOPOL_IMPORTANT: u32 = 1;
pub const IOPOL_PASSIVE: u32 = 2;
pub const IOPOL_THROTTLE: u32 = 3;
pub const IOPOL_UTILITY: u32 = 4;
pub const IOPOL_STANDARD: u32 = 5;
pub const IOPOL_APPLICATION: u32 = 5;
pub const IOPOL_NORMAL: u32 = 1;
pub const IOPOL_ATIME_UPDATES_DEFAULT: u32 = 0;
pub const IOPOL_ATIME_UPDATES_OFF: u32 = 1;
pub const IOPOL_MATERIALIZE_DATALESS_FILES_DEFAULT: u32 = 0;
pub const IOPOL_MATERIALIZE_DATALESS_FILES_OFF: u32 = 1;
pub const IOPOL_MATERIALIZE_DATALESS_FILES_ON: u32 = 2;
pub const IOPOL_VFS_STATFS_NO_DATA_VOLUME_DEFAULT: u32 = 0;
pub const IOPOL_VFS_STATFS_FORCE_NO_DATA_VOLUME: u32 = 1;
pub const WNOHANG: u32 = 1;
pub const WUNTRACED: u32 = 2;
pub const WCOREFLAG: u32 = 128;
pub const _WSTOPPED: u32 = 127;
pub const WEXITED: u32 = 4;
pub const WSTOPPED: u32 = 8;
pub const WCONTINUED: u32 = 16;
pub const WNOWAIT: u32 = 32;
pub const WAIT_ANY: i32 = -1;
pub const WAIT_MYPGRP: u32 = 0;
pub const _QUAD_HIGHWORD: u32 = 1;
pub const _QUAD_LOWWORD: u32 = 0;
pub const __DARWIN_LITTLE_ENDIAN: u32 = 1234;
pub const __DARWIN_BIG_ENDIAN: u32 = 4321;
pub const __DARWIN_PDP_ENDIAN: u32 = 3412;
pub const __DARWIN_BYTE_ORDER: u32 = 1234;
pub const LITTLE_ENDIAN: u32 = 1234;
pub const BIG_ENDIAN: u32 = 4321;
pub const PDP_ENDIAN: u32 = 3412;
pub const BYTE_ORDER: u32 = 1234;
pub const EXIT_FAILURE: u32 = 1;
pub const EXIT_SUCCESS: u32 = 0;
pub const RAND_MAX: u32 = 2147483647;
pub const _USE_FORTIFY_LEVEL: u32 = 2;
pub const __HAS_FIXED_CHK_PROTOTYPES: u32 = 1;
pub const __GNUC_VA_LIST: u32 = 1;
pub const RENAME_SECLUDE: u32 = 1;
pub const RENAME_SWAP: u32 = 2;
pub const RENAME_EXCL: u32 = 4;
pub const __SLBF: u32 = 1;
pub const __SNBF: u32 = 2;
pub const __SRD: u32 = 4;
pub const __SWR: u32 = 8;
pub const __SRW: u32 = 16;
pub const __SEOF: u32 = 32;
pub const __SERR: u32 = 64;
pub const __SMBF: u32 = 128;
pub const __SAPP: u32 = 256;
pub const __SSTR: u32 = 512;
pub const __SOPT: u32 = 1024;
pub const __SNPT: u32 = 2048;
pub const __SOFF: u32 = 4096;
pub const __SMOD: u32 = 8192;
pub const __SALC: u32 = 16384;
pub const __SIGN: u32 = 32768;
pub const _IOFBF: u32 = 0;
pub const _IOLBF: u32 = 1;
pub const _IONBF: u32 = 2;
pub const BUFSIZ: u32 = 1024;
pub const EOF: i32 = -1;
pub const FOPEN_MAX: u32 = 20;
pub const FILENAME_MAX: u32 = 1024;
pub const P_tmpdir: &'static [u8; 10usize] = b"/var/tmp/\0";
pub const L_tmpnam: u32 = 1024;
pub const TMP_MAX: u32 = 308915776;
pub const SEEK_SET: u32 = 0;
pub const SEEK_CUR: u32 = 1;
pub const SEEK_END: u32 = 2;
pub const L_ctermid: u32 = 1024;
pub const __DARWIN_CLK_TCK: u32 = 100;
pub const CHAR_BIT: u32 = 8;
pub const MB_LEN_MAX: u32 = 6;
pub const CLK_TCK: u32 = 100;
pub const SCHAR_MAX: u32 = 127;
pub const SCHAR_MIN: i32 = -128;
pub const UCHAR_MAX: u32 = 255;
pub const CHAR_MAX: u32 = 127;
pub const CHAR_MIN: i32 = -128;
pub const USHRT_MAX: u32 = 65535;
pub const SHRT_MAX: u32 = 32767;
pub const SHRT_MIN: i32 = -32768;
pub const UINT_MAX: u32 = 4294967295;
pub const INT_MAX: u32 = 2147483647;
pub const INT_MIN: i32 = -2147483648;
pub const ULONG_MAX: i32 = -1;
pub const LONG_MAX: u64 = 9223372036854775807;
pub const LONG_MIN: i64 = -9223372036854775808;
pub const ULLONG_MAX: i32 = -1;
pub const LLONG_MAX: u64 = 9223372036854775807;
pub const LLONG_MIN: i64 = -9223372036854775808;
pub const LONG_BIT: u32 = 64;
pub const SSIZE_MAX: u64 = 9223372036854775807;
pub const WORD_BIT: u32 = 32;
pub const SIZE_T_MAX: i32 = -1;
pub const UQUAD_MAX: i32 = -1;
pub const QUAD_MAX: u64 = 9223372036854775807;
pub const QUAD_MIN: i64 = -9223372036854775808;
pub const ARG_MAX: u32 = 262144;
pub const CHILD_MAX: u32 = 266;
pub const GID_MAX: u32 = 2147483647;
pub const LINK_MAX: u32 = 32767;
pub const MAX_CANON: u32 = 1024;
pub const MAX_INPUT: u32 = 1024;
pub const NAME_MAX: u32 = 255;
pub const NGROUPS_MAX: u32 = 16;
pub const UID_MAX: u32 = 2147483647;
pub const OPEN_MAX: u32 = 10240;
pub const PATH_MAX: u32 = 1024;
pub const PIPE_BUF: u32 = 512;
pub const BC_BASE_MAX: u32 = 99;
pub const BC_DIM_MAX: u32 = 2048;
pub const BC_SCALE_MAX: u32 = 99;
pub const BC_STRING_MAX: u32 = 1000;
pub const CHARCLASS_NAME_MAX: u32 = 14;
pub const COLL_WEIGHTS_MAX: u32 = 2;
pub const EQUIV_CLASS_MAX: u32 = 2;
pub const EXPR_NEST_MAX: u32 = 32;
pub const LINE_MAX: u32 = 2048;
pub const RE_DUP_MAX: u32 = 255;
pub const NZERO: u32 = 20;
pub const _POSIX_ARG_MAX: u32 = 4096;
pub const _POSIX_CHILD_MAX: u32 = 25;
pub const _POSIX_LINK_MAX: u32 = 8;
pub const _POSIX_MAX_CANON: u32 = 255;
pub const _POSIX_MAX_INPUT: u32 = 255;
pub const _POSIX_NAME_MAX: u32 = 14;
pub const _POSIX_NGROUPS_MAX: u32 = 8;
pub const _POSIX_OPEN_MAX: u32 = 20;
pub const _POSIX_PATH_MAX: u32 = 256;
pub const _POSIX_PIPE_BUF: u32 = 512;
pub const _POSIX_SSIZE_MAX: u32 = 32767;
pub const _POSIX_STREAM_MAX: u32 = 8;
pub const _POSIX_TZNAME_MAX: u32 = 6;
pub const _POSIX2_BC_BASE_MAX: u32 = 99;
pub const _POSIX2_BC_DIM_MAX: u32 = 2048;
pub const _POSIX2_BC_SCALE_MAX: u32 = 99;
pub const _POSIX2_BC_STRING_MAX: u32 = 1000;
pub const _POSIX2_EQUIV_CLASS_MAX: u32 = 2;
pub const _POSIX2_EXPR_NEST_MAX: u32 = 32;
pub const _POSIX2_LINE_MAX: u32 = 2048;
pub const _POSIX2_RE_DUP_MAX: u32 = 255;
pub const _POSIX_AIO_LISTIO_MAX: u32 = 2;
pub const _POSIX_AIO_MAX: u32 = 1;
pub const _POSIX_DELAYTIMER_MAX: u32 = 32;
pub const _POSIX_MQ_OPEN_MAX: u32 = 8;
pub const _POSIX_MQ_PRIO_MAX: u32 = 32;
pub const _POSIX_RTSIG_MAX: u32 = 8;
pub const _POSIX_SEM_NSEMS_MAX: u32 = 256;
pub const _POSIX_SEM_VALUE_MAX: u32 = 32767;
pub const _POSIX_SIGQUEUE_MAX: u32 = 32;
pub const _POSIX_TIMER_MAX: u32 = 32;
pub const _POSIX_CLOCKRES_MIN: u32 = 20000000;
pub const _POSIX_THREAD_DESTRUCTOR_ITERATIONS: u32 = 4;
pub const _POSIX_THREAD_KEYS_MAX: u32 = 128;
pub const _POSIX_THREAD_THREADS_MAX: u32 = 64;
pub const PTHREAD_DESTRUCTOR_ITERATIONS: u32 = 4;
pub const PTHREAD_KEYS_MAX: u32 = 512;
pub const PTHREAD_STACK_MIN: u32 = 8192;
pub const _POSIX_HOST_NAME_MAX: u32 = 255;
pub const _POSIX_LOGIN_NAME_MAX: u32 = 9;
pub const _POSIX_SS_REPL_MAX: u32 = 4;
pub const _POSIX_SYMLINK_MAX: u32 = 255;
pub const _POSIX_SYMLOOP_MAX: u32 = 8;
pub const _POSIX_TRACE_EVENT_NAME_MAX: u32 = 30;
pub const _POSIX_TRACE_NAME_MAX: u32 = 8;
pub const _POSIX_TRACE_SYS_MAX: u32 = 8;
pub const _POSIX_TRACE_USER_EVENT_MAX: u32 = 32;
pub const _POSIX_TTY_NAME_MAX: u32 = 9;
pub const _POSIX2_CHARCLASS_NAME_MAX: u32 = 14;
pub const _POSIX2_COLL_WEIGHTS_MAX: u32 = 2;
pub const _POSIX_RE_DUP_MAX: u32 = 255;
pub const OFF_MIN: i64 = -9223372036854775808;
pub const OFF_MAX: u64 = 9223372036854775807;
pub const PASS_MAX: u32 = 128;
pub const NL_ARGMAX: u32 = 9;
pub const NL_LANGMAX: u32 = 14;
pub const NL_MSGMAX: u32 = 32767;
pub const NL_NMAX: u32 = 1;
pub const NL_SETMAX: u32 = 255;
pub const NL_TEXTMAX: u32 = 2048;
pub const _XOPEN_IOV_MAX: u32 = 16;
pub const IOV_MAX: u32 = 1024;
pub const _XOPEN_NAME_MAX: u32 = 255;
pub const _XOPEN_PATH_MAX: u32 = 1024;
pub const EPERM: u32 = 1;
pub const ENOENT: u32 = 2;
pub const ESRCH: u32 = 3;
pub const EINTR: u32 = 4;
pub const EIO: u32 = 5;
pub const ENXIO: u32 = 6;
pub const E2BIG: u32 = 7;
pub const ENOEXEC: u32 = 8;
pub const EBADF: u32 = 9;
pub const ECHILD: u32 = 10;
pub const EDEADLK: u32 = 11;
pub const ENOMEM: u32 = 12;
pub const EACCES: u32 = 13;
pub const EFAULT: u32 = 14;
pub const ENOTBLK: u32 = 15;
pub const EBUSY: u32 = 16;
pub const EEXIST: u32 = 17;
pub const EXDEV: u32 = 18;
pub const ENODEV: u32 = 19;
pub const ENOTDIR: u32 = 20;
pub const EISDIR: u32 = 21;
pub const EINVAL: u32 = 22;
pub const ENFILE: u32 = 23;
pub const EMFILE: u32 = 24;
pub const ENOTTY: u32 = 25;
pub const ETXTBSY: u32 = 26;
pub const EFBIG: u32 = 27;
pub const ENOSPC: u32 = 28;
pub const ESPIPE: u32 = 29;
pub const EROFS: u32 = 30;
pub const EMLINK: u32 = 31;
pub const EPIPE: u32 = 32;
pub const EDOM: u32 = 33;
pub const ERANGE: u32 = 34;
pub const EAGAIN: u32 = 35;
pub const EWOULDBLOCK: u32 = 35;
pub const EINPROGRESS: u32 = 36;
pub const EALREADY: u32 = 37;
pub const ENOTSOCK: u32 = 38;
pub const EDESTADDRREQ: u32 = 39;
pub const EMSGSIZE: u32 = 40;
pub const EPROTOTYPE: u32 = 41;
pub const ENOPROTOOPT: u32 = 42;
pub const EPROTONOSUPPORT: u32 = 43;
pub const ESOCKTNOSUPPORT: u32 = 44;
pub const ENOTSUP: u32 = 45;
pub const EPFNOSUPPORT: u32 = 46;
pub const EAFNOSUPPORT: u32 = 47;
pub const EADDRINUSE: u32 = 48;
pub const EADDRNOTAVAIL: u32 = 49;
pub const ENETDOWN: u32 = 50;
pub const ENETUNREACH: u32 = 51;
pub const ENETRESET: u32 = 52;
pub const ECONNABORTED: u32 = 53;
pub const ECONNRESET: u32 = 54;
pub const ENOBUFS: u32 = 55;
pub const EISCONN: u32 = 56;
pub const ENOTCONN: u32 = 57;
pub const ESHUTDOWN: u32 = 58;
pub const ETOOMANYREFS: u32 = 59;
pub const ETIMEDOUT: u32 = 60;
pub const ECONNREFUSED: u32 = 61;
pub const ELOOP: u32 = 62;
pub const ENAMETOOLONG: u32 = 63;
pub const EHOSTDOWN: u32 = 64;
pub const EHOSTUNREACH: u32 = 65;
pub const ENOTEMPTY: u32 = 66;
pub const EPROCLIM: u32 = 67;
pub const EUSERS: u32 = 68;
pub const EDQUOT: u32 = 69;
pub const ESTALE: u32 = 70;
pub const EREMOTE: u32 = 71;
pub const EBADRPC: u32 = 72;
pub const ERPCMISMATCH: u32 = 73;
pub const EPROGUNAVAIL: u32 = 74;
pub const EPROGMISMATCH: u32 = 75;
pub const EPROCUNAVAIL: u32 = 76;
pub const ENOLCK: u32 = 77;
pub const ENOSYS: u32 = 78;
pub const EFTYPE: u32 = 79;
pub const EAUTH: u32 = 80;
pub const ENEEDAUTH: u32 = 81;
pub const EPWROFF: u32 = 82;
pub const EDEVERR: u32 = 83;
pub const EOVERFLOW: u32 = 84;
pub const EBADEXEC: u32 = 85;
pub const EBADARCH: u32 = 86;
pub const ESHLIBVERS: u32 = 87;
pub const EBADMACHO: u32 = 88;
pub const ECANCELED: u32 = 89;
pub const EIDRM: u32 = 90;
pub const ENOMSG: u32 = 91;
pub const EILSEQ: u32 = 92;
pub const ENOATTR: u32 = 93;
pub const EBADMSG: u32 = 94;
pub const EMULTIHOP: u32 = 95;
pub const ENODATA: u32 = 96;
pub const ENOLINK: u32 = 97;
pub const ENOSR: u32 = 98;
pub const ENOSTR: u32 = 99;
pub const EPROTO: u32 = 100;
pub const ETIME: u32 = 101;
pub const EOPNOTSUPP: u32 = 102;
pub const ENOPOLICY: u32 = 103;
pub const ENOTRECOVERABLE: u32 = 104;
pub const EOWNERDEAD: u32 = 105;
pub const EQFULL: u32 = 106;
pub const ELAST: u32 = 106;
pub const __DARWIN_FD_SETSIZE: u32 = 1024;
pub const __DARWIN_NBBY: u32 = 8;
pub const NBBY: u32 = 8;
pub const FD_SETSIZE: u32 = 1024;
pub const HAVE___BUILTIN_CLZ: u32 = 1;
pub const HTS_PATH_SEPARATOR_CHAR: u8 = 58u8;
pub const HTS_PATH_SEPARATOR_STR: &'static [u8; 2usize] = b":\0";
pub const HTS_RESIZE_CLEAR: u32 = 1;
pub const HTS_IDX_DELIM: &'static [u8; 8usize] = b"##idx##\0";
pub const HTS_VERSION: u32 = 101190;
pub const HTS_IDX_NOCOOR: i32 = -2;
pub const HTS_IDX_START: i32 = -3;
pub const HTS_IDX_REST: i32 = -4;
pub const HTS_IDX_NONE: i32 = -5;
pub const HTS_FMT_CSI: u32 = 0;
pub const HTS_FMT_BAI: u32 = 1;
pub const HTS_FMT_TBI: u32 = 2;
pub const HTS_FMT_CRAI: u32 = 3;
pub const HTS_FMT_FAI: u32 = 4;
pub const HTS_POS_MIN: i64 = -9223372036854775808;
pub const PRIhts_pos: &'static [u8; 4usize] = b"lld\0";
pub const HTS_IDX_SAVE_REMOTE: u32 = 1;
pub const HTS_IDX_SILENT_FAIL: u32 = 2;
pub const HTS_PARSE_THOUSANDS_SEP: u32 = 1;
pub const HTS_PARSE_ONE_COORD: u32 = 2;
pub const HTS_PARSE_LIST: u32 = 4;
pub const FT_UNKN: u32 = 0;
pub const FT_GZ: u32 = 1;
pub const FT_VCF: u32 = 2;
pub const FT_VCF_GZ: u32 = 3;
pub const FT_BCF: u32 = 4;
pub const FT_BCF_GZ: u32 = 5;
pub const FT_STDIN: u32 = 8;
pub const HTS_ALLOW_UNALIGNED: u32 = 1;
pub const BCF_HL_FLT: u32 = 0;
pub const BCF_HL_INFO: u32 = 1;
pub const BCF_HL_FMT: u32 = 2;
pub const BCF_HL_CTG: u32 = 3;
pub const BCF_HL_STR: u32 = 4;
pub const BCF_HL_GEN: u32 = 5;
pub const BCF_HT_FLAG: u32 = 0;
pub const BCF_HT_INT: u32 = 1;
pub const BCF_HT_REAL: u32 = 2;
pub const BCF_HT_STR: u32 = 3;
pub const BCF_HT_LONG: u32 = 257;
pub const BCF_VL_FIXED: u32 = 0;
pub const BCF_VL_VAR: u32 = 1;
pub const BCF_VL_A: u32 = 2;
pub const BCF_VL_G: u32 = 3;
pub const BCF_VL_R: u32 = 4;
pub const BCF_DT_ID: u32 = 0;
pub const BCF_DT_CTG: u32 = 1;
pub const BCF_DT_SAMPLE: u32 = 2;
pub const BCF_BT_NULL: u32 = 0;
pub const BCF_BT_INT8: u32 = 1;
pub const BCF_BT_INT16: u32 = 2;
pub const BCF_BT_INT32: u32 = 3;
pub const BCF_BT_INT64: u32 = 4;
pub const BCF_BT_FLOAT: u32 = 5;
pub const BCF_BT_CHAR: u32 = 7;
pub const VCF_REF: u32 = 0;
pub const VCF_SNP: u32 = 1;
pub const VCF_MNP: u32 = 2;
pub const VCF_INDEL: u32 = 4;
pub const VCF_OTHER: u32 = 8;
pub const VCF_BND: u32 = 16;
pub const VCF_OVERLAP: u32 = 32;
pub const BCF1_DIRTY_ID: u32 = 1;
pub const BCF1_DIRTY_ALS: u32 = 2;
pub const BCF1_DIRTY_FLT: u32 = 4;
pub const BCF1_DIRTY_INF: u32 = 8;
pub const BCF_ERR_CTG_UNDEF: u32 = 1;
pub const BCF_ERR_TAG_UNDEF: u32 = 2;
pub const BCF_ERR_NCOLS: u32 = 4;
pub const BCF_ERR_LIMITS: u32 = 8;
pub const BCF_ERR_CHAR: u32 = 16;
pub const BCF_ERR_CTG_INVALID: u32 = 32;
pub const BCF_ERR_TAG_INVALID: u32 = 64;
pub const BCF_UN_STR: u32 = 1;
pub const BCF_UN_FLT: u32 = 2;
pub const BCF_UN_INFO: u32 = 4;
pub const BCF_UN_SHR: u32 = 7;
pub const BCF_UN_FMT: u32 = 8;
pub const BCF_UN_IND: u32 = 8;
pub const BCF_UN_ALL: u32 = 15;
pub const bcf_gt_missing: u32 = 0;
pub const bcf_int8_vector_end: i32 = -127;
pub const bcf_int16_vector_end: i32 = -32767;
pub const bcf_int32_vector_end: i32 = -2147483647;
pub const bcf_int64_vector_end: i64 = -9223372036854775807;
pub const bcf_str_vector_end: u32 = 0;
pub const bcf_int8_missing: i32 = -128;
pub const bcf_int16_missing: i32 = -32768;
pub const bcf_int32_missing: i32 = -2147483648;
pub const bcf_int64_missing: i64 = -9223372036854775808;
pub const bcf_str_missing: u32 = 7;
pub const BCF_MAX_BT_INT8: u32 = 127;
pub const BCF_MAX_BT_INT16: u32 = 32767;
pub const BCF_MAX_BT_INT32: u32 = 2147483647;
pub const BCF_MIN_BT_INT8: i32 = -120;
pub const BCF_MIN_BT_INT16: i32 = -32760;
pub const BCF_MIN_BT_INT32: i32 = -2147483640;
pub const SAM_FORMAT_VERSION: &'static [u8; 4usize] = b"1.6\0";
pub const BAM_CMATCH: u32 = 0;
pub const BAM_CINS: u32 = 1;
pub const BAM_CDEL: u32 = 2;
pub const BAM_CREF_SKIP: u32 = 3;
pub const BAM_CSOFT_CLIP: u32 = 4;
pub const BAM_CHARD_CLIP: u32 = 5;
pub const BAM_CPAD: u32 = 6;
pub const BAM_CEQUAL: u32 = 7;
pub const BAM_CDIFF: u32 = 8;
pub const BAM_CBACK: u32 = 9;
pub const BAM_CIGAR_STR: &'static [u8; 11usize] = b"MIDNSHP=XB\0";
pub const BAM_CIGAR_SHIFT: u32 = 4;
pub const BAM_CIGAR_MASK: u32 = 15;
pub const BAM_CIGAR_TYPE: u32 = 246183;
pub const BAM_FPAIRED: u32 = 1;
pub const BAM_FPROPER_PAIR: u32 = 2;
pub const BAM_FUNMAP: u32 = 4;
pub const BAM_FMUNMAP: u32 = 8;
pub const BAM_FREVERSE: u32 = 16;
pub const BAM_FMREVERSE: u32 = 32;
pub const BAM_FREAD1: u32 = 64;
pub const BAM_FREAD2: u32 = 128;
pub const BAM_FSECONDARY: u32 = 256;
pub const BAM_FQCFAIL: u32 = 512;
pub const BAM_FDUP: u32 = 1024;
pub const BAM_FSUPPLEMENTARY: u32 = 2048;
pub const BAM_USER_OWNS_STRUCT: u32 = 1;
pub const BAM_USER_OWNS_DATA: u32 = 2;
pub const BGZF_BLOCK_SIZE: u32 = 65280;
pub const BGZF_MAX_BLOCK_SIZE: u32 = 65536;
pub const BGZF_ERR_ZLIB: u32 = 1;
pub const BGZF_ERR_HEADER: u32 = 2;
pub const BGZF_ERR_IO: u32 = 4;
pub const BGZF_ERR_MISUSE: u32 = 8;
pub const BGZF_ERR_MT: u32 = 16;
pub const BGZF_ERR_CRC: u32 = 32;
pub const GT_HOM_RR: u32 = 0;
pub const GT_HOM_AA: u32 = 1;
pub const GT_HET_RA: u32 = 2;
pub const GT_HET_AA: u32 = 3;
pub const GT_HAPL_R: u32 = 4;
pub const GT_HAPL_A: u32 = 5;
pub const GT_UNKN: u32 = 6;
pub const TBX_MAX_SHIFT: u32 = 31;
pub const TBX_GENERIC: u32 = 0;
pub const TBX_SAM: u32 = 1;
pub const TBX_VCF: u32 = 2;
pub const TBX_UCSC: u32 = 65536;
pub const COLLAPSE_NONE: u32 = 0;
pub const COLLAPSE_SNPS: u32 = 1;
pub const COLLAPSE_INDELS: u32 = 2;
pub const COLLAPSE_ANY: u32 = 4;
pub const COLLAPSE_SOME: u32 = 8;
pub const COLLAPSE_BOTH: u32 = 3;
pub const BCF_SR_PAIR_SNPS: u32 = 1;
pub const BCF_SR_PAIR_INDELS: u32 = 2;
pub const BCF_SR_PAIR_ANY: u32 = 4;
pub const BCF_SR_PAIR_SOME: u32 = 8;
pub const BCF_SR_PAIR_SNP_REF: u32 = 16;
pub const BCF_SR_PAIR_INDEL_REF: u32 = 32;
pub const BCF_SR_PAIR_EXACT: u32 = 64;
pub const BCF_SR_PAIR_BOTH: u32 = 3;
pub const BCF_SR_PAIR_BOTH_REF: u32 = 51;
pub type size_t = ::std::os::raw::c_ulong;
pub type wchar_t = ::std::os::raw::c_int;
pub type int_least8_t = i8;
pub type int_least16_t = i16;
pub type int_least32_t = i32;
pub type int_least64_t = i64;
pub type uint_least8_t = u8;
pub type uint_least16_t = u16;
pub type uint_least32_t = u32;
pub type uint_least64_t = u64;
pub type int_fast8_t = i8;
pub type int_fast16_t = i16;
pub type int_fast32_t = i32;
pub type int_fast64_t = i64;
pub type uint_fast8_t = u8;
pub type uint_fast16_t = u16;
pub type uint_fast32_t = u32;
pub type uint_fast64_t = u64;
pub type __int8_t = ::std::os::raw::c_schar;
pub type __uint8_t = ::std::os::raw::c_uchar;
pub type __int16_t = ::std::os::raw::c_short;
pub type __uint16_t = ::std::os::raw::c_ushort;
pub type __int32_t = ::std::os::raw::c_int;
pub type __uint32_t = ::std::os::raw::c_uint;
pub type __int64_t = ::std::os::raw::c_longlong;
pub type __uint64_t = ::std::os::raw::c_ulonglong;
pub type __darwin_intptr_t = ::std::os::raw::c_long;
pub type __darwin_natural_t = ::std::os::raw::c_uint;
pub type __darwin_ct_rune_t = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Copy, Clone)]
pub union __mbstate_t {
    pub __mbstate8: [::std::os::raw::c_char; 128usize],
    pub _mbstateL: ::std::os::raw::c_longlong,
    _bindgen_union_align: [u64; 16usize],
}
#[test]
fn bindgen_test_layout___mbstate_t() {
    assert_eq!(
        ::std::mem::size_of::<__mbstate_t>(),
        128usize,
        concat!("Size of: ", stringify!(__mbstate_t))
    );
    assert_eq!(
        ::std::mem::align_of::<__mbstate_t>(),
        8usize,
        concat!("Alignment of ", stringify!(__mbstate_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__mbstate_t>())).__mbstate8 as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__mbstate_t),
            "::",
            stringify!(__mbstate8)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__mbstate_t>()))._mbstateL as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__mbstate_t),
            "::",
            stringify!(_mbstateL)
        )
    );
}
pub type __darwin_mbstate_t = __mbstate_t;
pub type __darwin_ptrdiff_t = ::std::os::raw::c_long;
pub type __darwin_size_t = ::std::os::raw::c_ulong;
pub type __darwin_va_list = __builtin_va_list;
pub type __darwin_wchar_t = ::std::os::raw::c_int;
pub type __darwin_rune_t = __darwin_wchar_t;
pub type __darwin_wint_t = ::std::os::raw::c_int;
pub type __darwin_clock_t = ::std::os::raw::c_ulong;
pub type __darwin_socklen_t = __uint32_t;
pub type __darwin_ssize_t = ::std::os::raw::c_long;
pub type __darwin_time_t = ::std::os::raw::c_long;
pub type __darwin_blkcnt_t = __int64_t;
pub type __darwin_blksize_t = __int32_t;
pub type __darwin_dev_t = __int32_t;
pub type __darwin_fsblkcnt_t = ::std::os::raw::c_uint;
pub type __darwin_fsfilcnt_t = ::std::os::raw::c_uint;
pub type __darwin_gid_t = __uint32_t;
pub type __darwin_id_t = __uint32_t;
pub type __darwin_ino64_t = __uint64_t;
pub type __darwin_ino_t = __darwin_ino64_t;
pub type __darwin_mach_port_name_t = __darwin_natural_t;
pub type __darwin_mach_port_t = __darwin_mach_port_name_t;
pub type __darwin_mode_t = __uint16_t;
pub type __darwin_off_t = __int64_t;
pub type __darwin_pid_t = __int32_t;
pub type __darwin_sigset_t = __uint32_t;
pub type __darwin_suseconds_t = __int32_t;
pub type __darwin_uid_t = __uint32_t;
pub type __darwin_useconds_t = __uint32_t;
pub type __darwin_uuid_t = [::std::os::raw::c_uchar; 16usize];
pub type __darwin_uuid_string_t = [::std::os::raw::c_char; 37usize];
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_pthread_handler_rec {
    pub __routine: ::std::option::Option<unsafe extern "C" fn(arg1: *mut ::std::os::raw::c_void)>,
    pub __arg: *mut ::std::os::raw::c_void,
    pub __next: *mut __darwin_pthread_handler_rec,
}
#[test]
fn bindgen_test_layout___darwin_pthread_handler_rec() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_pthread_handler_rec>(),
        24usize,
        concat!("Size of: ", stringify!(__darwin_pthread_handler_rec))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_pthread_handler_rec>(),
        8usize,
        concat!("Alignment of ", stringify!(__darwin_pthread_handler_rec))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_pthread_handler_rec>())).__routine as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_pthread_handler_rec),
            "::",
            stringify!(__routine)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_pthread_handler_rec>())).__arg as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_pthread_handler_rec),
            "::",
            stringify!(__arg)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_pthread_handler_rec>())).__next as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_pthread_handler_rec),
            "::",
            stringify!(__next)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _opaque_pthread_attr_t {
    pub __sig: ::std::os::raw::c_long,
    pub __opaque: [::std::os::raw::c_char; 56usize],
}
#[test]
fn bindgen_test_layout__opaque_pthread_attr_t() {
    assert_eq!(
        ::std::mem::size_of::<_opaque_pthread_attr_t>(),
        64usize,
        concat!("Size of: ", stringify!(_opaque_pthread_attr_t))
    );
    assert_eq!(
        ::std::mem::align_of::<_opaque_pthread_attr_t>(),
        8usize,
        concat!("Alignment of ", stringify!(_opaque_pthread_attr_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_opaque_pthread_attr_t>())).__sig as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_attr_t),
            "::",
            stringify!(__sig)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_opaque_pthread_attr_t>())).__opaque as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_attr_t),
            "::",
            stringify!(__opaque)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _opaque_pthread_cond_t {
    pub __sig: ::std::os::raw::c_long,
    pub __opaque: [::std::os::raw::c_char; 40usize],
}
#[test]
fn bindgen_test_layout__opaque_pthread_cond_t() {
    assert_eq!(
        ::std::mem::size_of::<_opaque_pthread_cond_t>(),
        48usize,
        concat!("Size of: ", stringify!(_opaque_pthread_cond_t))
    );
    assert_eq!(
        ::std::mem::align_of::<_opaque_pthread_cond_t>(),
        8usize,
        concat!("Alignment of ", stringify!(_opaque_pthread_cond_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_opaque_pthread_cond_t>())).__sig as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_cond_t),
            "::",
            stringify!(__sig)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_opaque_pthread_cond_t>())).__opaque as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_cond_t),
            "::",
            stringify!(__opaque)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _opaque_pthread_condattr_t {
    pub __sig: ::std::os::raw::c_long,
    pub __opaque: [::std::os::raw::c_char; 8usize],
}
#[test]
fn bindgen_test_layout__opaque_pthread_condattr_t() {
    assert_eq!(
        ::std::mem::size_of::<_opaque_pthread_condattr_t>(),
        16usize,
        concat!("Size of: ", stringify!(_opaque_pthread_condattr_t))
    );
    assert_eq!(
        ::std::mem::align_of::<_opaque_pthread_condattr_t>(),
        8usize,
        concat!("Alignment of ", stringify!(_opaque_pthread_condattr_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_opaque_pthread_condattr_t>())).__sig as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_condattr_t),
            "::",
            stringify!(__sig)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_opaque_pthread_condattr_t>())).__opaque as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_condattr_t),
            "::",
            stringify!(__opaque)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _opaque_pthread_mutex_t {
    pub __sig: ::std::os::raw::c_long,
    pub __opaque: [::std::os::raw::c_char; 56usize],
}
#[test]
fn bindgen_test_layout__opaque_pthread_mutex_t() {
    assert_eq!(
        ::std::mem::size_of::<_opaque_pthread_mutex_t>(),
        64usize,
        concat!("Size of: ", stringify!(_opaque_pthread_mutex_t))
    );
    assert_eq!(
        ::std::mem::align_of::<_opaque_pthread_mutex_t>(),
        8usize,
        concat!("Alignment of ", stringify!(_opaque_pthread_mutex_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_opaque_pthread_mutex_t>())).__sig as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_mutex_t),
            "::",
            stringify!(__sig)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_opaque_pthread_mutex_t>())).__opaque as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_mutex_t),
            "::",
            stringify!(__opaque)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _opaque_pthread_mutexattr_t {
    pub __sig: ::std::os::raw::c_long,
    pub __opaque: [::std::os::raw::c_char; 8usize],
}
#[test]
fn bindgen_test_layout__opaque_pthread_mutexattr_t() {
    assert_eq!(
        ::std::mem::size_of::<_opaque_pthread_mutexattr_t>(),
        16usize,
        concat!("Size of: ", stringify!(_opaque_pthread_mutexattr_t))
    );
    assert_eq!(
        ::std::mem::align_of::<_opaque_pthread_mutexattr_t>(),
        8usize,
        concat!("Alignment of ", stringify!(_opaque_pthread_mutexattr_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_opaque_pthread_mutexattr_t>())).__sig as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_mutexattr_t),
            "::",
            stringify!(__sig)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_opaque_pthread_mutexattr_t>())).__opaque as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_mutexattr_t),
            "::",
            stringify!(__opaque)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _opaque_pthread_once_t {
    pub __sig: ::std::os::raw::c_long,
    pub __opaque: [::std::os::raw::c_char; 8usize],
}
#[test]
fn bindgen_test_layout__opaque_pthread_once_t() {
    assert_eq!(
        ::std::mem::size_of::<_opaque_pthread_once_t>(),
        16usize,
        concat!("Size of: ", stringify!(_opaque_pthread_once_t))
    );
    assert_eq!(
        ::std::mem::align_of::<_opaque_pthread_once_t>(),
        8usize,
        concat!("Alignment of ", stringify!(_opaque_pthread_once_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_opaque_pthread_once_t>())).__sig as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_once_t),
            "::",
            stringify!(__sig)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_opaque_pthread_once_t>())).__opaque as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_once_t),
            "::",
            stringify!(__opaque)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _opaque_pthread_rwlock_t {
    pub __sig: ::std::os::raw::c_long,
    pub __opaque: [::std::os::raw::c_char; 192usize],
}
#[test]
fn bindgen_test_layout__opaque_pthread_rwlock_t() {
    assert_eq!(
        ::std::mem::size_of::<_opaque_pthread_rwlock_t>(),
        200usize,
        concat!("Size of: ", stringify!(_opaque_pthread_rwlock_t))
    );
    assert_eq!(
        ::std::mem::align_of::<_opaque_pthread_rwlock_t>(),
        8usize,
        concat!("Alignment of ", stringify!(_opaque_pthread_rwlock_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_opaque_pthread_rwlock_t>())).__sig as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_rwlock_t),
            "::",
            stringify!(__sig)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_opaque_pthread_rwlock_t>())).__opaque as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_rwlock_t),
            "::",
            stringify!(__opaque)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _opaque_pthread_rwlockattr_t {
    pub __sig: ::std::os::raw::c_long,
    pub __opaque: [::std::os::raw::c_char; 16usize],
}
#[test]
fn bindgen_test_layout__opaque_pthread_rwlockattr_t() {
    assert_eq!(
        ::std::mem::size_of::<_opaque_pthread_rwlockattr_t>(),
        24usize,
        concat!("Size of: ", stringify!(_opaque_pthread_rwlockattr_t))
    );
    assert_eq!(
        ::std::mem::align_of::<_opaque_pthread_rwlockattr_t>(),
        8usize,
        concat!("Alignment of ", stringify!(_opaque_pthread_rwlockattr_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_opaque_pthread_rwlockattr_t>())).__sig as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_rwlockattr_t),
            "::",
            stringify!(__sig)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_opaque_pthread_rwlockattr_t>())).__opaque as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_rwlockattr_t),
            "::",
            stringify!(__opaque)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _opaque_pthread_t {
    pub __sig: ::std::os::raw::c_long,
    pub __cleanup_stack: *mut __darwin_pthread_handler_rec,
    pub __opaque: [::std::os::raw::c_char; 8176usize],
}
#[test]
fn bindgen_test_layout__opaque_pthread_t() {
    assert_eq!(
        ::std::mem::size_of::<_opaque_pthread_t>(),
        8192usize,
        concat!("Size of: ", stringify!(_opaque_pthread_t))
    );
    assert_eq!(
        ::std::mem::align_of::<_opaque_pthread_t>(),
        8usize,
        concat!("Alignment of ", stringify!(_opaque_pthread_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_opaque_pthread_t>())).__sig as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_t),
            "::",
            stringify!(__sig)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_opaque_pthread_t>())).__cleanup_stack as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_t),
            "::",
            stringify!(__cleanup_stack)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_opaque_pthread_t>())).__opaque as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_t),
            "::",
            stringify!(__opaque)
        )
    );
}
pub type __darwin_pthread_attr_t = _opaque_pthread_attr_t;
pub type __darwin_pthread_cond_t = _opaque_pthread_cond_t;
pub type __darwin_pthread_condattr_t = _opaque_pthread_condattr_t;
pub type __darwin_pthread_key_t = ::std::os::raw::c_ulong;
pub type __darwin_pthread_mutex_t = _opaque_pthread_mutex_t;
pub type __darwin_pthread_mutexattr_t = _opaque_pthread_mutexattr_t;
pub type __darwin_pthread_once_t = _opaque_pthread_once_t;
pub type __darwin_pthread_rwlock_t = _opaque_pthread_rwlock_t;
pub type __darwin_pthread_rwlockattr_t = _opaque_pthread_rwlockattr_t;
pub type __darwin_pthread_t = *mut _opaque_pthread_t;
pub type u_int8_t = ::std::os::raw::c_uchar;
pub type u_int16_t = ::std::os::raw::c_ushort;
pub type u_int32_t = ::std::os::raw::c_uint;
pub type u_int64_t = ::std::os::raw::c_ulonglong;
pub type register_t = i64;
pub type user_addr_t = u_int64_t;
pub type user_size_t = u_int64_t;
pub type user_ssize_t = i64;
pub type user_long_t = i64;
pub type user_ulong_t = u_int64_t;
pub type user_time_t = i64;
pub type user_off_t = i64;
pub type syscall_arg_t = u_int64_t;
pub type intmax_t = ::std::os::raw::c_long;
pub type uintmax_t = ::std::os::raw::c_ulong;
pub type __darwin_nl_item = ::std::os::raw::c_int;
pub type __darwin_wctrans_t = ::std::os::raw::c_int;
pub type __darwin_wctype_t = __uint32_t;
extern "C" {
    pub fn imaxabs(j: intmax_t) -> intmax_t;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct imaxdiv_t {
    pub quot: intmax_t,
    pub rem: intmax_t,
}
#[test]
fn bindgen_test_layout_imaxdiv_t() {
    assert_eq!(
        ::std::mem::size_of::<imaxdiv_t>(),
        16usize,
        concat!("Size of: ", stringify!(imaxdiv_t))
    );
    assert_eq!(
        ::std::mem::align_of::<imaxdiv_t>(),
        8usize,
        concat!("Alignment of ", stringify!(imaxdiv_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<imaxdiv_t>())).quot as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(imaxdiv_t),
            "::",
            stringify!(quot)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<imaxdiv_t>())).rem as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(imaxdiv_t),
            "::",
            stringify!(rem)
        )
    );
}
extern "C" {
    pub fn imaxdiv(__numer: intmax_t, __denom: intmax_t) -> imaxdiv_t;
}
extern "C" {
    pub fn strtoimax(
        __nptr: *const ::std::os::raw::c_char,
        __endptr: *mut *mut ::std::os::raw::c_char,
        __base: ::std::os::raw::c_int,
    ) -> intmax_t;
}
extern "C" {
    pub fn strtoumax(
        __nptr: *const ::std::os::raw::c_char,
        __endptr: *mut *mut ::std::os::raw::c_char,
        __base: ::std::os::raw::c_int,
    ) -> uintmax_t;
}
extern "C" {
    pub fn wcstoimax(
        __nptr: *const wchar_t,
        __endptr: *mut *mut wchar_t,
        __base: ::std::os::raw::c_int,
    ) -> intmax_t;
}
extern "C" {
    pub fn wcstoumax(
        __nptr: *const wchar_t,
        __endptr: *mut *mut wchar_t,
        __base: ::std::os::raw::c_int,
    ) -> uintmax_t;
}
pub const htsLogLevel_HTS_LOG_OFF: htsLogLevel = 0;
pub const htsLogLevel_HTS_LOG_ERROR: htsLogLevel = 1;
pub const htsLogLevel_HTS_LOG_WARNING: htsLogLevel = 3;
pub const htsLogLevel_HTS_LOG_INFO: htsLogLevel = 4;
pub const htsLogLevel_HTS_LOG_DEBUG: htsLogLevel = 5;
pub const htsLogLevel_HTS_LOG_TRACE: htsLogLevel = 6;
pub type htsLogLevel = u32;
extern "C" {
    pub fn hts_set_log_level(level: htsLogLevel);
}
extern "C" {
    pub fn hts_get_log_level() -> htsLogLevel;
}
extern "C" {
    pub static mut hts_verbose: ::std::os::raw::c_int;
}
extern "C" {
    pub fn hts_log(
        severity: htsLogLevel,
        context: *const ::std::os::raw::c_char,
        format: *const ::std::os::raw::c_char,
        ...
    );
}
pub const idtype_t_P_ALL: idtype_t = 0;
pub const idtype_t_P_PID: idtype_t = 1;
pub const idtype_t_P_PGID: idtype_t = 2;
pub type idtype_t = u32;
pub type pid_t = __darwin_pid_t;
pub type id_t = __darwin_id_t;
pub type sig_atomic_t = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_i386_thread_state {
    pub __eax: ::std::os::raw::c_uint,
    pub __ebx: ::std::os::raw::c_uint,
    pub __ecx: ::std::os::raw::c_uint,
    pub __edx: ::std::os::raw::c_uint,
    pub __edi: ::std::os::raw::c_uint,
    pub __esi: ::std::os::raw::c_uint,
    pub __ebp: ::std::os::raw::c_uint,
    pub __esp: ::std::os::raw::c_uint,
    pub __ss: ::std::os::raw::c_uint,
    pub __eflags: ::std::os::raw::c_uint,
    pub __eip: ::std::os::raw::c_uint,
    pub __cs: ::std::os::raw::c_uint,
    pub __ds: ::std::os::raw::c_uint,
    pub __es: ::std::os::raw::c_uint,
    pub __fs: ::std::os::raw::c_uint,
    pub __gs: ::std::os::raw::c_uint,
}
#[test]
fn bindgen_test_layout___darwin_i386_thread_state() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_i386_thread_state>(),
        64usize,
        concat!("Size of: ", stringify!(__darwin_i386_thread_state))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_i386_thread_state>(),
        4usize,
        concat!("Alignment of ", stringify!(__darwin_i386_thread_state))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_thread_state>())).__eax as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_thread_state),
            "::",
            stringify!(__eax)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_thread_state>())).__ebx as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_thread_state),
            "::",
            stringify!(__ebx)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_thread_state>())).__ecx as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_thread_state),
            "::",
            stringify!(__ecx)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_thread_state>())).__edx as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_thread_state),
            "::",
            stringify!(__edx)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_thread_state>())).__edi as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_thread_state),
            "::",
            stringify!(__edi)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_thread_state>())).__esi as *const _ as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_thread_state),
            "::",
            stringify!(__esi)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_thread_state>())).__ebp as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_thread_state),
            "::",
            stringify!(__ebp)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_thread_state>())).__esp as *const _ as usize
        },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_thread_state),
            "::",
            stringify!(__esp)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_i386_thread_state>())).__ss as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_thread_state),
            "::",
            stringify!(__ss)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_thread_state>())).__eflags as *const _ as usize
        },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_thread_state),
            "::",
            stringify!(__eflags)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_thread_state>())).__eip as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_thread_state),
            "::",
            stringify!(__eip)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_i386_thread_state>())).__cs as *const _ as usize },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_thread_state),
            "::",
            stringify!(__cs)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_i386_thread_state>())).__ds as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_thread_state),
            "::",
            stringify!(__ds)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_i386_thread_state>())).__es as *const _ as usize },
        52usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_thread_state),
            "::",
            stringify!(__es)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_i386_thread_state>())).__fs as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_thread_state),
            "::",
            stringify!(__fs)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_i386_thread_state>())).__gs as *const _ as usize },
        60usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_thread_state),
            "::",
            stringify!(__gs)
        )
    );
}
#[repr(C)]
#[repr(align(2))]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_fp_control {
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 2usize], u8>,
}
#[test]
fn bindgen_test_layout___darwin_fp_control() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_fp_control>(),
        2usize,
        concat!("Size of: ", stringify!(__darwin_fp_control))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_fp_control>(),
        2usize,
        concat!("Alignment of ", stringify!(__darwin_fp_control))
    );
}
impl __darwin_fp_control {
    #[inline]
    pub fn __invalid(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___invalid(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __denorm(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___denorm(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __zdiv(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___zdiv(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __ovrfl(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___ovrfl(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __undfl(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___undfl(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __precis(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(5usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___precis(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(5usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __pc(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(8usize, 2u8) as u16) }
    }
    #[inline]
    pub fn set___pc(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(8usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub fn __rc(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(10usize, 2u8) as u16) }
    }
    #[inline]
    pub fn set___rc(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(10usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        __invalid: ::std::os::raw::c_ushort,
        __denorm: ::std::os::raw::c_ushort,
        __zdiv: ::std::os::raw::c_ushort,
        __ovrfl: ::std::os::raw::c_ushort,
        __undfl: ::std::os::raw::c_ushort,
        __precis: ::std::os::raw::c_ushort,
        __pc: ::std::os::raw::c_ushort,
        __rc: ::std::os::raw::c_ushort,
    ) -> __BindgenBitfieldUnit<[u8; 2usize], u8> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 2usize], u8> =
            Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let __invalid: u16 = unsafe { ::std::mem::transmute(__invalid) };
            __invalid as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let __denorm: u16 = unsafe { ::std::mem::transmute(__denorm) };
            __denorm as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let __zdiv: u16 = unsafe { ::std::mem::transmute(__zdiv) };
            __zdiv as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let __ovrfl: u16 = unsafe { ::std::mem::transmute(__ovrfl) };
            __ovrfl as u64
        });
        __bindgen_bitfield_unit.set(4usize, 1u8, {
            let __undfl: u16 = unsafe { ::std::mem::transmute(__undfl) };
            __undfl as u64
        });
        __bindgen_bitfield_unit.set(5usize, 1u8, {
            let __precis: u16 = unsafe { ::std::mem::transmute(__precis) };
            __precis as u64
        });
        __bindgen_bitfield_unit.set(8usize, 2u8, {
            let __pc: u16 = unsafe { ::std::mem::transmute(__pc) };
            __pc as u64
        });
        __bindgen_bitfield_unit.set(10usize, 2u8, {
            let __rc: u16 = unsafe { ::std::mem::transmute(__rc) };
            __rc as u64
        });
        __bindgen_bitfield_unit
    }
}
pub type __darwin_fp_control_t = __darwin_fp_control;
#[repr(C)]
#[repr(align(2))]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_fp_status {
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 2usize], u8>,
}
#[test]
fn bindgen_test_layout___darwin_fp_status() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_fp_status>(),
        2usize,
        concat!("Size of: ", stringify!(__darwin_fp_status))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_fp_status>(),
        2usize,
        concat!("Alignment of ", stringify!(__darwin_fp_status))
    );
}
impl __darwin_fp_status {
    #[inline]
    pub fn __invalid(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___invalid(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __denorm(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___denorm(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __zdiv(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___zdiv(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __ovrfl(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___ovrfl(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __undfl(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___undfl(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __precis(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(5usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___precis(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(5usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __stkflt(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(6usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___stkflt(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(6usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __errsumm(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(7usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___errsumm(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(7usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __c0(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(8usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___c0(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(8usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __c1(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(9usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___c1(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(9usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __c2(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(10usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___c2(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(10usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __tos(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(11usize, 3u8) as u16) }
    }
    #[inline]
    pub fn set___tos(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(11usize, 3u8, val as u64)
        }
    }
    #[inline]
    pub fn __c3(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(14usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___c3(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(14usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __busy(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(15usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___busy(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(15usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        __invalid: ::std::os::raw::c_ushort,
        __denorm: ::std::os::raw::c_ushort,
        __zdiv: ::std::os::raw::c_ushort,
        __ovrfl: ::std::os::raw::c_ushort,
        __undfl: ::std::os::raw::c_ushort,
        __precis: ::std::os::raw::c_ushort,
        __stkflt: ::std::os::raw::c_ushort,
        __errsumm: ::std::os::raw::c_ushort,
        __c0: ::std::os::raw::c_ushort,
        __c1: ::std::os::raw::c_ushort,
        __c2: ::std::os::raw::c_ushort,
        __tos: ::std::os::raw::c_ushort,
        __c3: ::std::os::raw::c_ushort,
        __busy: ::std::os::raw::c_ushort,
    ) -> __BindgenBitfieldUnit<[u8; 2usize], u8> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 2usize], u8> =
            Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let __invalid: u16 = unsafe { ::std::mem::transmute(__invalid) };
            __invalid as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let __denorm: u16 = unsafe { ::std::mem::transmute(__denorm) };
            __denorm as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let __zdiv: u16 = unsafe { ::std::mem::transmute(__zdiv) };
            __zdiv as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let __ovrfl: u16 = unsafe { ::std::mem::transmute(__ovrfl) };
            __ovrfl as u64
        });
        __bindgen_bitfield_unit.set(4usize, 1u8, {
            let __undfl: u16 = unsafe { ::std::mem::transmute(__undfl) };
            __undfl as u64
        });
        __bindgen_bitfield_unit.set(5usize, 1u8, {
            let __precis: u16 = unsafe { ::std::mem::transmute(__precis) };
            __precis as u64
        });
        __bindgen_bitfield_unit.set(6usize, 1u8, {
            let __stkflt: u16 = unsafe { ::std::mem::transmute(__stkflt) };
            __stkflt as u64
        });
        __bindgen_bitfield_unit.set(7usize, 1u8, {
            let __errsumm: u16 = unsafe { ::std::mem::transmute(__errsumm) };
            __errsumm as u64
        });
        __bindgen_bitfield_unit.set(8usize, 1u8, {
            let __c0: u16 = unsafe { ::std::mem::transmute(__c0) };
            __c0 as u64
        });
        __bindgen_bitfield_unit.set(9usize, 1u8, {
            let __c1: u16 = unsafe { ::std::mem::transmute(__c1) };
            __c1 as u64
        });
        __bindgen_bitfield_unit.set(10usize, 1u8, {
            let __c2: u16 = unsafe { ::std::mem::transmute(__c2) };
            __c2 as u64
        });
        __bindgen_bitfield_unit.set(11usize, 3u8, {
            let __tos: u16 = unsafe { ::std::mem::transmute(__tos) };
            __tos as u64
        });
        __bindgen_bitfield_unit.set(14usize, 1u8, {
            let __c3: u16 = unsafe { ::std::mem::transmute(__c3) };
            __c3 as u64
        });
        __bindgen_bitfield_unit.set(15usize, 1u8, {
            let __busy: u16 = unsafe { ::std::mem::transmute(__busy) };
            __busy as u64
        });
        __bindgen_bitfield_unit
    }
}
pub type __darwin_fp_status_t = __darwin_fp_status;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_mmst_reg {
    pub __mmst_reg: [::std::os::raw::c_char; 10usize],
    pub __mmst_rsrv: [::std::os::raw::c_char; 6usize],
}
#[test]
fn bindgen_test_layout___darwin_mmst_reg() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_mmst_reg>(),
        16usize,
        concat!("Size of: ", stringify!(__darwin_mmst_reg))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_mmst_reg>(),
        1usize,
        concat!("Alignment of ", stringify!(__darwin_mmst_reg))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_mmst_reg>())).__mmst_reg as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mmst_reg),
            "::",
            stringify!(__mmst_reg)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_mmst_reg>())).__mmst_rsrv as *const _ as usize },
        10usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mmst_reg),
            "::",
            stringify!(__mmst_rsrv)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_xmm_reg {
    pub __xmm_reg: [::std::os::raw::c_char; 16usize],
}
#[test]
fn bindgen_test_layout___darwin_xmm_reg() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_xmm_reg>(),
        16usize,
        concat!("Size of: ", stringify!(__darwin_xmm_reg))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_xmm_reg>(),
        1usize,
        concat!("Alignment of ", stringify!(__darwin_xmm_reg))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_xmm_reg>())).__xmm_reg as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_xmm_reg),
            "::",
            stringify!(__xmm_reg)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_ymm_reg {
    pub __ymm_reg: [::std::os::raw::c_char; 32usize],
}
#[test]
fn bindgen_test_layout___darwin_ymm_reg() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_ymm_reg>(),
        32usize,
        concat!("Size of: ", stringify!(__darwin_ymm_reg))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_ymm_reg>(),
        1usize,
        concat!("Alignment of ", stringify!(__darwin_ymm_reg))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_ymm_reg>())).__ymm_reg as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_ymm_reg),
            "::",
            stringify!(__ymm_reg)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct __darwin_zmm_reg {
    pub __zmm_reg: [::std::os::raw::c_char; 64usize],
}
#[test]
fn bindgen_test_layout___darwin_zmm_reg() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_zmm_reg>(),
        64usize,
        concat!("Size of: ", stringify!(__darwin_zmm_reg))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_zmm_reg>(),
        1usize,
        concat!("Alignment of ", stringify!(__darwin_zmm_reg))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_zmm_reg>())).__zmm_reg as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_zmm_reg),
            "::",
            stringify!(__zmm_reg)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_opmask_reg {
    pub __opmask_reg: [::std::os::raw::c_char; 8usize],
}
#[test]
fn bindgen_test_layout___darwin_opmask_reg() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_opmask_reg>(),
        8usize,
        concat!("Size of: ", stringify!(__darwin_opmask_reg))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_opmask_reg>(),
        1usize,
        concat!("Alignment of ", stringify!(__darwin_opmask_reg))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_opmask_reg>())).__opmask_reg as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_opmask_reg),
            "::",
            stringify!(__opmask_reg)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct __darwin_i386_float_state {
    pub __fpu_reserved: [::std::os::raw::c_int; 2usize],
    pub __fpu_fcw: __darwin_fp_control,
    pub __fpu_fsw: __darwin_fp_status,
    pub __fpu_ftw: __uint8_t,
    pub __fpu_rsrv1: __uint8_t,
    pub __fpu_fop: __uint16_t,
    pub __fpu_ip: __uint32_t,
    pub __fpu_cs: __uint16_t,
    pub __fpu_rsrv2: __uint16_t,
    pub __fpu_dp: __uint32_t,
    pub __fpu_ds: __uint16_t,
    pub __fpu_rsrv3: __uint16_t,
    pub __fpu_mxcsr: __uint32_t,
    pub __fpu_mxcsrmask: __uint32_t,
    pub __fpu_stmm0: __darwin_mmst_reg,
    pub __fpu_stmm1: __darwin_mmst_reg,
    pub __fpu_stmm2: __darwin_mmst_reg,
    pub __fpu_stmm3: __darwin_mmst_reg,
    pub __fpu_stmm4: __darwin_mmst_reg,
    pub __fpu_stmm5: __darwin_mmst_reg,
    pub __fpu_stmm6: __darwin_mmst_reg,
    pub __fpu_stmm7: __darwin_mmst_reg,
    pub __fpu_xmm0: __darwin_xmm_reg,
    pub __fpu_xmm1: __darwin_xmm_reg,
    pub __fpu_xmm2: __darwin_xmm_reg,
    pub __fpu_xmm3: __darwin_xmm_reg,
    pub __fpu_xmm4: __darwin_xmm_reg,
    pub __fpu_xmm5: __darwin_xmm_reg,
    pub __fpu_xmm6: __darwin_xmm_reg,
    pub __fpu_xmm7: __darwin_xmm_reg,
    pub __fpu_rsrv4: [::std::os::raw::c_char; 224usize],
    pub __fpu_reserved1: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout___darwin_i386_float_state() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_i386_float_state>(),
        524usize,
        concat!("Size of: ", stringify!(__darwin_i386_float_state))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_i386_float_state>(),
        4usize,
        concat!("Alignment of ", stringify!(__darwin_i386_float_state))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_reserved as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_reserved)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_fcw as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_fcw)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_fsw as *const _ as usize
        },
        10usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_fsw)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_ftw as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_ftw)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_rsrv1 as *const _ as usize
        },
        13usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_rsrv1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_fop as *const _ as usize
        },
        14usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_fop)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_ip as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_ip)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_cs as *const _ as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_cs)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_rsrv2 as *const _ as usize
        },
        22usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_rsrv2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_dp as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_dp)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_ds as *const _ as usize
        },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_ds)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_rsrv3 as *const _ as usize
        },
        30usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_rsrv3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_mxcsr as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_mxcsr)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_mxcsrmask as *const _
                as usize
        },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_mxcsrmask)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_stmm0 as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_stmm0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_stmm1 as *const _ as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_stmm1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_stmm2 as *const _ as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_stmm2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_stmm3 as *const _ as usize
        },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_stmm3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_stmm4 as *const _ as usize
        },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_stmm4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_stmm5 as *const _ as usize
        },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_stmm5)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_stmm6 as *const _ as usize
        },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_stmm6)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_stmm7 as *const _ as usize
        },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_stmm7)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_xmm0 as *const _ as usize
        },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_xmm0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_xmm1 as *const _ as usize
        },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_xmm1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_xmm2 as *const _ as usize
        },
        200usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_xmm2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_xmm3 as *const _ as usize
        },
        216usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_xmm3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_xmm4 as *const _ as usize
        },
        232usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_xmm4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_xmm5 as *const _ as usize
        },
        248usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_xmm5)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_xmm6 as *const _ as usize
        },
        264usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_xmm6)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_xmm7 as *const _ as usize
        },
        280usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_xmm7)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_rsrv4 as *const _ as usize
        },
        296usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_rsrv4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_reserved1 as *const _
                as usize
        },
        520usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_reserved1)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct __darwin_i386_avx_state {
    pub __fpu_reserved: [::std::os::raw::c_int; 2usize],
    pub __fpu_fcw: __darwin_fp_control,
    pub __fpu_fsw: __darwin_fp_status,
    pub __fpu_ftw: __uint8_t,
    pub __fpu_rsrv1: __uint8_t,
    pub __fpu_fop: __uint16_t,
    pub __fpu_ip: __uint32_t,
    pub __fpu_cs: __uint16_t,
    pub __fpu_rsrv2: __uint16_t,
    pub __fpu_dp: __uint32_t,
    pub __fpu_ds: __uint16_t,
    pub __fpu_rsrv3: __uint16_t,
    pub __fpu_mxcsr: __uint32_t,
    pub __fpu_mxcsrmask: __uint32_t,
    pub __fpu_stmm0: __darwin_mmst_reg,
    pub __fpu_stmm1: __darwin_mmst_reg,
    pub __fpu_stmm2: __darwin_mmst_reg,
    pub __fpu_stmm3: __darwin_mmst_reg,
    pub __fpu_stmm4: __darwin_mmst_reg,
    pub __fpu_stmm5: __darwin_mmst_reg,
    pub __fpu_stmm6: __darwin_mmst_reg,
    pub __fpu_stmm7: __darwin_mmst_reg,
    pub __fpu_xmm0: __darwin_xmm_reg,
    pub __fpu_xmm1: __darwin_xmm_reg,
    pub __fpu_xmm2: __darwin_xmm_reg,
    pub __fpu_xmm3: __darwin_xmm_reg,
    pub __fpu_xmm4: __darwin_xmm_reg,
    pub __fpu_xmm5: __darwin_xmm_reg,
    pub __fpu_xmm6: __darwin_xmm_reg,
    pub __fpu_xmm7: __darwin_xmm_reg,
    pub __fpu_rsrv4: [::std::os::raw::c_char; 224usize],
    pub __fpu_reserved1: ::std::os::raw::c_int,
    pub __avx_reserved1: [::std::os::raw::c_char; 64usize],
    pub __fpu_ymmh0: __darwin_xmm_reg,
    pub __fpu_ymmh1: __darwin_xmm_reg,
    pub __fpu_ymmh2: __darwin_xmm_reg,
    pub __fpu_ymmh3: __darwin_xmm_reg,
    pub __fpu_ymmh4: __darwin_xmm_reg,
    pub __fpu_ymmh5: __darwin_xmm_reg,
    pub __fpu_ymmh6: __darwin_xmm_reg,
    pub __fpu_ymmh7: __darwin_xmm_reg,
}
#[test]
fn bindgen_test_layout___darwin_i386_avx_state() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_i386_avx_state>(),
        716usize,
        concat!("Size of: ", stringify!(__darwin_i386_avx_state))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_i386_avx_state>(),
        4usize,
        concat!("Alignment of ", stringify!(__darwin_i386_avx_state))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_reserved as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_reserved)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_fcw as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_fcw)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_fsw as *const _ as usize
        },
        10usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_fsw)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_ftw as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_ftw)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_rsrv1 as *const _ as usize
        },
        13usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_rsrv1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_fop as *const _ as usize
        },
        14usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_fop)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_ip as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_ip)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_cs as *const _ as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_cs)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_rsrv2 as *const _ as usize
        },
        22usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_rsrv2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_dp as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_dp)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_ds as *const _ as usize
        },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_ds)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_rsrv3 as *const _ as usize
        },
        30usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_rsrv3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_mxcsr as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_mxcsr)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_mxcsrmask as *const _ as usize
        },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_mxcsrmask)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_stmm0 as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_stmm0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_stmm1 as *const _ as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_stmm1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_stmm2 as *const _ as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_stmm2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_stmm3 as *const _ as usize
        },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_stmm3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_stmm4 as *const _ as usize
        },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_stmm4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_stmm5 as *const _ as usize
        },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_stmm5)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_stmm6 as *const _ as usize
        },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_stmm6)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_stmm7 as *const _ as usize
        },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_stmm7)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_xmm0 as *const _ as usize
        },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_xmm0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_xmm1 as *const _ as usize
        },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_xmm1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_xmm2 as *const _ as usize
        },
        200usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_xmm2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_xmm3 as *const _ as usize
        },
        216usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_xmm3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_xmm4 as *const _ as usize
        },
        232usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_xmm4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_xmm5 as *const _ as usize
        },
        248usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_xmm5)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_xmm6 as *const _ as usize
        },
        264usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_xmm6)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_xmm7 as *const _ as usize
        },
        280usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_xmm7)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_rsrv4 as *const _ as usize
        },
        296usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_rsrv4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_reserved1 as *const _ as usize
        },
        520usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_reserved1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__avx_reserved1 as *const _ as usize
        },
        524usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__avx_reserved1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_ymmh0 as *const _ as usize
        },
        588usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_ymmh0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_ymmh1 as *const _ as usize
        },
        604usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_ymmh1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_ymmh2 as *const _ as usize
        },
        620usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_ymmh2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_ymmh3 as *const _ as usize
        },
        636usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_ymmh3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_ymmh4 as *const _ as usize
        },
        652usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_ymmh4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_ymmh5 as *const _ as usize
        },
        668usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_ymmh5)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_ymmh6 as *const _ as usize
        },
        684usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_ymmh6)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_ymmh7 as *const _ as usize
        },
        700usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_ymmh7)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct __darwin_i386_avx512_state {
    pub __fpu_reserved: [::std::os::raw::c_int; 2usize],
    pub __fpu_fcw: __darwin_fp_control,
    pub __fpu_fsw: __darwin_fp_status,
    pub __fpu_ftw: __uint8_t,
    pub __fpu_rsrv1: __uint8_t,
    pub __fpu_fop: __uint16_t,
    pub __fpu_ip: __uint32_t,
    pub __fpu_cs: __uint16_t,
    pub __fpu_rsrv2: __uint16_t,
    pub __fpu_dp: __uint32_t,
    pub __fpu_ds: __uint16_t,
    pub __fpu_rsrv3: __uint16_t,
    pub __fpu_mxcsr: __uint32_t,
    pub __fpu_mxcsrmask: __uint32_t,
    pub __fpu_stmm0: __darwin_mmst_reg,
    pub __fpu_stmm1: __darwin_mmst_reg,
    pub __fpu_stmm2: __darwin_mmst_reg,
    pub __fpu_stmm3: __darwin_mmst_reg,
    pub __fpu_stmm4: __darwin_mmst_reg,
    pub __fpu_stmm5: __darwin_mmst_reg,
    pub __fpu_stmm6: __darwin_mmst_reg,
    pub __fpu_stmm7: __darwin_mmst_reg,
    pub __fpu_xmm0: __darwin_xmm_reg,
    pub __fpu_xmm1: __darwin_xmm_reg,
    pub __fpu_xmm2: __darwin_xmm_reg,
    pub __fpu_xmm3: __darwin_xmm_reg,
    pub __fpu_xmm4: __darwin_xmm_reg,
    pub __fpu_xmm5: __darwin_xmm_reg,
    pub __fpu_xmm6: __darwin_xmm_reg,
    pub __fpu_xmm7: __darwin_xmm_reg,
    pub __fpu_rsrv4: [::std::os::raw::c_char; 224usize],
    pub __fpu_reserved1: ::std::os::raw::c_int,
    pub __avx_reserved1: [::std::os::raw::c_char; 64usize],
    pub __fpu_ymmh0: __darwin_xmm_reg,
    pub __fpu_ymmh1: __darwin_xmm_reg,
    pub __fpu_ymmh2: __darwin_xmm_reg,
    pub __fpu_ymmh3: __darwin_xmm_reg,
    pub __fpu_ymmh4: __darwin_xmm_reg,
    pub __fpu_ymmh5: __darwin_xmm_reg,
    pub __fpu_ymmh6: __darwin_xmm_reg,
    pub __fpu_ymmh7: __darwin_xmm_reg,
    pub __fpu_k0: __darwin_opmask_reg,
    pub __fpu_k1: __darwin_opmask_reg,
    pub __fpu_k2: __darwin_opmask_reg,
    pub __fpu_k3: __darwin_opmask_reg,
    pub __fpu_k4: __darwin_opmask_reg,
    pub __fpu_k5: __darwin_opmask_reg,
    pub __fpu_k6: __darwin_opmask_reg,
    pub __fpu_k7: __darwin_opmask_reg,
    pub __fpu_zmmh0: __darwin_ymm_reg,
    pub __fpu_zmmh1: __darwin_ymm_reg,
    pub __fpu_zmmh2: __darwin_ymm_reg,
    pub __fpu_zmmh3: __darwin_ymm_reg,
    pub __fpu_zmmh4: __darwin_ymm_reg,
    pub __fpu_zmmh5: __darwin_ymm_reg,
    pub __fpu_zmmh6: __darwin_ymm_reg,
    pub __fpu_zmmh7: __darwin_ymm_reg,
}
#[test]
fn bindgen_test_layout___darwin_i386_avx512_state() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_i386_avx512_state>(),
        1036usize,
        concat!("Size of: ", stringify!(__darwin_i386_avx512_state))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_i386_avx512_state>(),
        4usize,
        concat!("Alignment of ", stringify!(__darwin_i386_avx512_state))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_reserved as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_reserved)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_fcw as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_fcw)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_fsw as *const _ as usize
        },
        10usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_fsw)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_ftw as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_ftw)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_rsrv1 as *const _ as usize
        },
        13usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_rsrv1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_fop as *const _ as usize
        },
        14usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_fop)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_ip as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_ip)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_cs as *const _ as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_cs)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_rsrv2 as *const _ as usize
        },
        22usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_rsrv2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_dp as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_dp)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_ds as *const _ as usize
        },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_ds)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_rsrv3 as *const _ as usize
        },
        30usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_rsrv3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_mxcsr as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_mxcsr)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_mxcsrmask as *const _
                as usize
        },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_mxcsrmask)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_stmm0 as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_stmm0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_stmm1 as *const _ as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_stmm1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_stmm2 as *const _ as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_stmm2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_stmm3 as *const _ as usize
        },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_stmm3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_stmm4 as *const _ as usize
        },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_stmm4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_stmm5 as *const _ as usize
        },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_stmm5)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_stmm6 as *const _ as usize
        },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_stmm6)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_stmm7 as *const _ as usize
        },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_stmm7)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_xmm0 as *const _ as usize
        },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_xmm0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_xmm1 as *const _ as usize
        },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_xmm1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_xmm2 as *const _ as usize
        },
        200usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_xmm2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_xmm3 as *const _ as usize
        },
        216usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_xmm3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_xmm4 as *const _ as usize
        },
        232usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_xmm4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_xmm5 as *const _ as usize
        },
        248usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_xmm5)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_xmm6 as *const _ as usize
        },
        264usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_xmm6)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_xmm7 as *const _ as usize
        },
        280usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_xmm7)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_rsrv4 as *const _ as usize
        },
        296usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_rsrv4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_reserved1 as *const _
                as usize
        },
        520usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_reserved1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__avx_reserved1 as *const _
                as usize
        },
        524usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__avx_reserved1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_ymmh0 as *const _ as usize
        },
        588usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_ymmh0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_ymmh1 as *const _ as usize
        },
        604usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_ymmh1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_ymmh2 as *const _ as usize
        },
        620usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_ymmh2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_ymmh3 as *const _ as usize
        },
        636usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_ymmh3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_ymmh4 as *const _ as usize
        },
        652usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_ymmh4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_ymmh5 as *const _ as usize
        },
        668usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_ymmh5)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_ymmh6 as *const _ as usize
        },
        684usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_ymmh6)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_ymmh7 as *const _ as usize
        },
        700usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_ymmh7)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_k0 as *const _ as usize
        },
        716usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_k0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_k1 as *const _ as usize
        },
        724usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_k1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_k2 as *const _ as usize
        },
        732usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_k2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_k3 as *const _ as usize
        },
        740usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_k3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_k4 as *const _ as usize
        },
        748usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_k4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_k5 as *const _ as usize
        },
        756usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_k5)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_k6 as *const _ as usize
        },
        764usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_k6)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_k7 as *const _ as usize
        },
        772usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_k7)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_zmmh0 as *const _ as usize
        },
        780usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_zmmh0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_zmmh1 as *const _ as usize
        },
        812usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_zmmh1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_zmmh2 as *const _ as usize
        },
        844usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_zmmh2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_zmmh3 as *const _ as usize
        },
        876usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_zmmh3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_zmmh4 as *const _ as usize
        },
        908usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_zmmh4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_zmmh5 as *const _ as usize
        },
        940usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_zmmh5)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_zmmh6 as *const _ as usize
        },
        972usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_zmmh6)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_zmmh7 as *const _ as usize
        },
        1004usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_zmmh7)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_i386_exception_state {
    pub __trapno: __uint16_t,
    pub __cpu: __uint16_t,
    pub __err: __uint32_t,
    pub __faultvaddr: __uint32_t,
}
#[test]
fn bindgen_test_layout___darwin_i386_exception_state() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_i386_exception_state>(),
        12usize,
        concat!("Size of: ", stringify!(__darwin_i386_exception_state))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_i386_exception_state>(),
        4usize,
        concat!("Alignment of ", stringify!(__darwin_i386_exception_state))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_exception_state>())).__trapno as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_exception_state),
            "::",
            stringify!(__trapno)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_exception_state>())).__cpu as *const _ as usize
        },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_exception_state),
            "::",
            stringify!(__cpu)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_exception_state>())).__err as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_exception_state),
            "::",
            stringify!(__err)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_exception_state>())).__faultvaddr as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_exception_state),
            "::",
            stringify!(__faultvaddr)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_x86_debug_state32 {
    pub __dr0: ::std::os::raw::c_uint,
    pub __dr1: ::std::os::raw::c_uint,
    pub __dr2: ::std::os::raw::c_uint,
    pub __dr3: ::std::os::raw::c_uint,
    pub __dr4: ::std::os::raw::c_uint,
    pub __dr5: ::std::os::raw::c_uint,
    pub __dr6: ::std::os::raw::c_uint,
    pub __dr7: ::std::os::raw::c_uint,
}
#[test]
fn bindgen_test_layout___darwin_x86_debug_state32() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_x86_debug_state32>(),
        32usize,
        concat!("Size of: ", stringify!(__darwin_x86_debug_state32))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_x86_debug_state32>(),
        4usize,
        concat!("Alignment of ", stringify!(__darwin_x86_debug_state32))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_debug_state32>())).__dr0 as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_debug_state32),
            "::",
            stringify!(__dr0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_debug_state32>())).__dr1 as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_debug_state32),
            "::",
            stringify!(__dr1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_debug_state32>())).__dr2 as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_debug_state32),
            "::",
            stringify!(__dr2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_debug_state32>())).__dr3 as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_debug_state32),
            "::",
            stringify!(__dr3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_debug_state32>())).__dr4 as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_debug_state32),
            "::",
            stringify!(__dr4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_debug_state32>())).__dr5 as *const _ as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_debug_state32),
            "::",
            stringify!(__dr5)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_debug_state32>())).__dr6 as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_debug_state32),
            "::",
            stringify!(__dr6)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_debug_state32>())).__dr7 as *const _ as usize
        },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_debug_state32),
            "::",
            stringify!(__dr7)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __x86_pagein_state {
    pub __pagein_error: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout___x86_pagein_state() {
    assert_eq!(
        ::std::mem::size_of::<__x86_pagein_state>(),
        4usize,
        concat!("Size of: ", stringify!(__x86_pagein_state))
    );
    assert_eq!(
        ::std::mem::align_of::<__x86_pagein_state>(),
        4usize,
        concat!("Alignment of ", stringify!(__x86_pagein_state))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__x86_pagein_state>())).__pagein_error as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__x86_pagein_state),
            "::",
            stringify!(__pagein_error)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_x86_thread_state64 {
    pub __rax: __uint64_t,
    pub __rbx: __uint64_t,
    pub __rcx: __uint64_t,
    pub __rdx: __uint64_t,
    pub __rdi: __uint64_t,
    pub __rsi: __uint64_t,
    pub __rbp: __uint64_t,
    pub __rsp: __uint64_t,
    pub __r8: __uint64_t,
    pub __r9: __uint64_t,
    pub __r10: __uint64_t,
    pub __r11: __uint64_t,
    pub __r12: __uint64_t,
    pub __r13: __uint64_t,
    pub __r14: __uint64_t,
    pub __r15: __uint64_t,
    pub __rip: __uint64_t,
    pub __rflags: __uint64_t,
    pub __cs: __uint64_t,
    pub __fs: __uint64_t,
    pub __gs: __uint64_t,
}
#[test]
fn bindgen_test_layout___darwin_x86_thread_state64() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_x86_thread_state64>(),
        168usize,
        concat!("Size of: ", stringify!(__darwin_x86_thread_state64))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_x86_thread_state64>(),
        8usize,
        concat!("Alignment of ", stringify!(__darwin_x86_thread_state64))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_state64>())).__rax as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__rax)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_state64>())).__rbx as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__rbx)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_state64>())).__rcx as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__rcx)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_state64>())).__rdx as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__rdx)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_state64>())).__rdi as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__rdi)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_state64>())).__rsi as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__rsi)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_state64>())).__rbp as *const _ as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__rbp)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_state64>())).__rsp as *const _ as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__rsp)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_state64>())).__r8 as *const _ as usize
        },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__r8)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_state64>())).__r9 as *const _ as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__r9)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_state64>())).__r10 as *const _ as usize
        },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__r10)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_state64>())).__r11 as *const _ as usize
        },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__r11)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_state64>())).__r12 as *const _ as usize
        },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__r12)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_state64>())).__r13 as *const _ as usize
        },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__r13)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_state64>())).__r14 as *const _ as usize
        },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__r14)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_state64>())).__r15 as *const _ as usize
        },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__r15)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_state64>())).__rip as *const _ as usize
        },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__rip)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_state64>())).__rflags as *const _ as usize
        },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__rflags)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_state64>())).__cs as *const _ as usize
        },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__cs)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_state64>())).__fs as *const _ as usize
        },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__fs)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_state64>())).__gs as *const _ as usize
        },
        160usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__gs)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_x86_thread_full_state64 {
    pub __ss64: __darwin_x86_thread_state64,
    pub __ds: __uint64_t,
    pub __es: __uint64_t,
    pub __ss: __uint64_t,
    pub __gsbase: __uint64_t,
}
#[test]
fn bindgen_test_layout___darwin_x86_thread_full_state64() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_x86_thread_full_state64>(),
        200usize,
        concat!("Size of: ", stringify!(__darwin_x86_thread_full_state64))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_x86_thread_full_state64>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__darwin_x86_thread_full_state64)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_full_state64>())).__ss64 as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_full_state64),
            "::",
            stringify!(__ss64)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_full_state64>())).__ds as *const _ as usize
        },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_full_state64),
            "::",
            stringify!(__ds)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_full_state64>())).__es as *const _ as usize
        },
        176usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_full_state64),
            "::",
            stringify!(__es)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_full_state64>())).__ss as *const _ as usize
        },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_full_state64),
            "::",
            stringify!(__ss)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_full_state64>())).__gsbase as *const _
                as usize
        },
        192usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_full_state64),
            "::",
            stringify!(__gsbase)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct __darwin_x86_float_state64 {
    pub __fpu_reserved: [::std::os::raw::c_int; 2usize],
    pub __fpu_fcw: __darwin_fp_control,
    pub __fpu_fsw: __darwin_fp_status,
    pub __fpu_ftw: __uint8_t,
    pub __fpu_rsrv1: __uint8_t,
    pub __fpu_fop: __uint16_t,
    pub __fpu_ip: __uint32_t,
    pub __fpu_cs: __uint16_t,
    pub __fpu_rsrv2: __uint16_t,
    pub __fpu_dp: __uint32_t,
    pub __fpu_ds: __uint16_t,
    pub __fpu_rsrv3: __uint16_t,
    pub __fpu_mxcsr: __uint32_t,
    pub __fpu_mxcsrmask: __uint32_t,
    pub __fpu_stmm0: __darwin_mmst_reg,
    pub __fpu_stmm1: __darwin_mmst_reg,
    pub __fpu_stmm2: __darwin_mmst_reg,
    pub __fpu_stmm3: __darwin_mmst_reg,
    pub __fpu_stmm4: __darwin_mmst_reg,
    pub __fpu_stmm5: __darwin_mmst_reg,
    pub __fpu_stmm6: __darwin_mmst_reg,
    pub __fpu_stmm7: __darwin_mmst_reg,
    pub __fpu_xmm0: __darwin_xmm_reg,
    pub __fpu_xmm1: __darwin_xmm_reg,
    pub __fpu_xmm2: __darwin_xmm_reg,
    pub __fpu_xmm3: __darwin_xmm_reg,
    pub __fpu_xmm4: __darwin_xmm_reg,
    pub __fpu_xmm5: __darwin_xmm_reg,
    pub __fpu_xmm6: __darwin_xmm_reg,
    pub __fpu_xmm7: __darwin_xmm_reg,
    pub __fpu_xmm8: __darwin_xmm_reg,
    pub __fpu_xmm9: __darwin_xmm_reg,
    pub __fpu_xmm10: __darwin_xmm_reg,
    pub __fpu_xmm11: __darwin_xmm_reg,
    pub __fpu_xmm12: __darwin_xmm_reg,
    pub __fpu_xmm13: __darwin_xmm_reg,
    pub __fpu_xmm14: __darwin_xmm_reg,
    pub __fpu_xmm15: __darwin_xmm_reg,
    pub __fpu_rsrv4: [::std::os::raw::c_char; 96usize],
    pub __fpu_reserved1: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout___darwin_x86_float_state64() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_x86_float_state64>(),
        524usize,
        concat!("Size of: ", stringify!(__darwin_x86_float_state64))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_x86_float_state64>(),
        4usize,
        concat!("Alignment of ", stringify!(__darwin_x86_float_state64))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_reserved as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_reserved)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_fcw as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_fcw)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_fsw as *const _ as usize
        },
        10usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_fsw)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_ftw as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_ftw)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_rsrv1 as *const _ as usize
        },
        13usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_rsrv1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_fop as *const _ as usize
        },
        14usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_fop)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_ip as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_ip)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_cs as *const _ as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_cs)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_rsrv2 as *const _ as usize
        },
        22usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_rsrv2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_dp as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_dp)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_ds as *const _ as usize
        },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_ds)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_rsrv3 as *const _ as usize
        },
        30usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_rsrv3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_mxcsr as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_mxcsr)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_mxcsrmask as *const _
                as usize
        },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_mxcsrmask)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_stmm0 as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_stmm0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_stmm1 as *const _ as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_stmm1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_stmm2 as *const _ as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_stmm2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_stmm3 as *const _ as usize
        },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_stmm3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_stmm4 as *const _ as usize
        },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_stmm4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_stmm5 as *const _ as usize
        },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_stmm5)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_stmm6 as *const _ as usize
        },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_stmm6)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_stmm7 as *const _ as usize
        },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_stmm7)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_xmm0 as *const _ as usize
        },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_xmm0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_xmm1 as *const _ as usize
        },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_xmm1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_xmm2 as *const _ as usize
        },
        200usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_xmm2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_xmm3 as *const _ as usize
        },
        216usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_xmm3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_xmm4 as *const _ as usize
        },
        232usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_xmm4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_xmm5 as *const _ as usize
        },
        248usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_xmm5)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_xmm6 as *const _ as usize
        },
        264usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_xmm6)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_xmm7 as *const _ as usize
        },
        280usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_xmm7)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_xmm8 as *const _ as usize
        },
        296usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_xmm8)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_xmm9 as *const _ as usize
        },
        312usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_xmm9)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_xmm10 as *const _ as usize
        },
        328usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_xmm10)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_xmm11 as *const _ as usize
        },
        344usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_xmm11)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_xmm12 as *const _ as usize
        },
        360usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_xmm12)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_xmm13 as *const _ as usize
        },
        376usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_xmm13)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_xmm14 as *const _ as usize
        },
        392usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_xmm14)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_xmm15 as *const _ as usize
        },
        408usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_xmm15)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_rsrv4 as *const _ as usize
        },
        424usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_rsrv4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_reserved1 as *const _
                as usize
        },
        520usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_reserved1)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct __darwin_x86_avx_state64 {
    pub __fpu_reserved: [::std::os::raw::c_int; 2usize],
    pub __fpu_fcw: __darwin_fp_control,
    pub __fpu_fsw: __darwin_fp_status,
    pub __fpu_ftw: __uint8_t,
    pub __fpu_rsrv1: __uint8_t,
    pub __fpu_fop: __uint16_t,
    pub __fpu_ip: __uint32_t,
    pub __fpu_cs: __uint16_t,
    pub __fpu_rsrv2: __uint16_t,
    pub __fpu_dp: __uint32_t,
    pub __fpu_ds: __uint16_t,
    pub __fpu_rsrv3: __uint16_t,
    pub __fpu_mxcsr: __uint32_t,
    pub __fpu_mxcsrmask: __uint32_t,
    pub __fpu_stmm0: __darwin_mmst_reg,
    pub __fpu_stmm1: __darwin_mmst_reg,
    pub __fpu_stmm2: __darwin_mmst_reg,
    pub __fpu_stmm3: __darwin_mmst_reg,
    pub __fpu_stmm4: __darwin_mmst_reg,
    pub __fpu_stmm5: __darwin_mmst_reg,
    pub __fpu_stmm6: __darwin_mmst_reg,
    pub __fpu_stmm7: __darwin_mmst_reg,
    pub __fpu_xmm0: __darwin_xmm_reg,
    pub __fpu_xmm1: __darwin_xmm_reg,
    pub __fpu_xmm2: __darwin_xmm_reg,
    pub __fpu_xmm3: __darwin_xmm_reg,
    pub __fpu_xmm4: __darwin_xmm_reg,
    pub __fpu_xmm5: __darwin_xmm_reg,
    pub __fpu_xmm6: __darwin_xmm_reg,
    pub __fpu_xmm7: __darwin_xmm_reg,
    pub __fpu_xmm8: __darwin_xmm_reg,
    pub __fpu_xmm9: __darwin_xmm_reg,
    pub __fpu_xmm10: __darwin_xmm_reg,
    pub __fpu_xmm11: __darwin_xmm_reg,
    pub __fpu_xmm12: __darwin_xmm_reg,
    pub __fpu_xmm13: __darwin_xmm_reg,
    pub __fpu_xmm14: __darwin_xmm_reg,
    pub __fpu_xmm15: __darwin_xmm_reg,
    pub __fpu_rsrv4: [::std::os::raw::c_char; 96usize],
    pub __fpu_reserved1: ::std::os::raw::c_int,
    pub __avx_reserved1: [::std::os::raw::c_char; 64usize],
    pub __fpu_ymmh0: __darwin_xmm_reg,
    pub __fpu_ymmh1: __darwin_xmm_reg,
    pub __fpu_ymmh2: __darwin_xmm_reg,
    pub __fpu_ymmh3: __darwin_xmm_reg,
    pub __fpu_ymmh4: __darwin_xmm_reg,
    pub __fpu_ymmh5: __darwin_xmm_reg,
    pub __fpu_ymmh6: __darwin_xmm_reg,
    pub __fpu_ymmh7: __darwin_xmm_reg,
    pub __fpu_ymmh8: __darwin_xmm_reg,
    pub __fpu_ymmh9: __darwin_xmm_reg,
    pub __fpu_ymmh10: __darwin_xmm_reg,
    pub __fpu_ymmh11: __darwin_xmm_reg,
    pub __fpu_ymmh12: __darwin_xmm_reg,
    pub __fpu_ymmh13: __darwin_xmm_reg,
    pub __fpu_ymmh14: __darwin_xmm_reg,
    pub __fpu_ymmh15: __darwin_xmm_reg,
}
#[test]
fn bindgen_test_layout___darwin_x86_avx_state64() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_x86_avx_state64>(),
        844usize,
        concat!("Size of: ", stringify!(__darwin_x86_avx_state64))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_x86_avx_state64>(),
        4usize,
        concat!("Alignment of ", stringify!(__darwin_x86_avx_state64))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_reserved as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_reserved)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_fcw as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_fcw)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_fsw as *const _ as usize
        },
        10usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_fsw)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_ftw as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_ftw)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_rsrv1 as *const _ as usize
        },
        13usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_rsrv1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_fop as *const _ as usize
        },
        14usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_fop)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_ip as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_ip)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_cs as *const _ as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_cs)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_rsrv2 as *const _ as usize
        },
        22usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_rsrv2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_dp as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_dp)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_ds as *const _ as usize
        },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_ds)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_rsrv3 as *const _ as usize
        },
        30usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_rsrv3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_mxcsr as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_mxcsr)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_mxcsrmask as *const _
                as usize
        },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_mxcsrmask)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_stmm0 as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_stmm0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_stmm1 as *const _ as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_stmm1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_stmm2 as *const _ as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_stmm2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_stmm3 as *const _ as usize
        },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_stmm3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_stmm4 as *const _ as usize
        },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_stmm4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_stmm5 as *const _ as usize
        },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_stmm5)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_stmm6 as *const _ as usize
        },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_stmm6)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_stmm7 as *const _ as usize
        },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_stmm7)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_xmm0 as *const _ as usize
        },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_xmm0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_xmm1 as *const _ as usize
        },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_xmm1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_xmm2 as *const _ as usize
        },
        200usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_xmm2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_xmm3 as *const _ as usize
        },
        216usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_xmm3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_xmm4 as *const _ as usize
        },
        232usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_xmm4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_xmm5 as *const _ as usize
        },
        248usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_xmm5)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_xmm6 as *const _ as usize
        },
        264usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_xmm6)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_xmm7 as *const _ as usize
        },
        280usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_xmm7)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_xmm8 as *const _ as usize
        },
        296usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_xmm8)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_xmm9 as *const _ as usize
        },
        312usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_xmm9)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_xmm10 as *const _ as usize
        },
        328usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_xmm10)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_xmm11 as *const _ as usize
        },
        344usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_xmm11)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_xmm12 as *const _ as usize
        },
        360usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_xmm12)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_xmm13 as *const _ as usize
        },
        376usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_xmm13)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_xmm14 as *const _ as usize
        },
        392usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_xmm14)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_xmm15 as *const _ as usize
        },
        408usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_xmm15)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_rsrv4 as *const _ as usize
        },
        424usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_rsrv4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_reserved1 as *const _
                as usize
        },
        520usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_reserved1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__avx_reserved1 as *const _
                as usize
        },
        524usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__avx_reserved1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_ymmh0 as *const _ as usize
        },
        588usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_ymmh0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_ymmh1 as *const _ as usize
        },
        604usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_ymmh1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_ymmh2 as *const _ as usize
        },
        620usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_ymmh2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_ymmh3 as *const _ as usize
        },
        636usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_ymmh3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_ymmh4 as *const _ as usize
        },
        652usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_ymmh4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_ymmh5 as *const _ as usize
        },
        668usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_ymmh5)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_ymmh6 as *const _ as usize
        },
        684usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_ymmh6)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_ymmh7 as *const _ as usize
        },
        700usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_ymmh7)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_ymmh8 as *const _ as usize
        },
        716usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_ymmh8)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_ymmh9 as *const _ as usize
        },
        732usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_ymmh9)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_ymmh10 as *const _ as usize
        },
        748usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_ymmh10)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_ymmh11 as *const _ as usize
        },
        764usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_ymmh11)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_ymmh12 as *const _ as usize
        },
        780usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_ymmh12)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_ymmh13 as *const _ as usize
        },
        796usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_ymmh13)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_ymmh14 as *const _ as usize
        },
        812usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_ymmh14)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_ymmh15 as *const _ as usize
        },
        828usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_ymmh15)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct __darwin_x86_avx512_state64 {
    pub __fpu_reserved: [::std::os::raw::c_int; 2usize],
    pub __fpu_fcw: __darwin_fp_control,
    pub __fpu_fsw: __darwin_fp_status,
    pub __fpu_ftw: __uint8_t,
    pub __fpu_rsrv1: __uint8_t,
    pub __fpu_fop: __uint16_t,
    pub __fpu_ip: __uint32_t,
    pub __fpu_cs: __uint16_t,
    pub __fpu_rsrv2: __uint16_t,
    pub __fpu_dp: __uint32_t,
    pub __fpu_ds: __uint16_t,
    pub __fpu_rsrv3: __uint16_t,
    pub __fpu_mxcsr: __uint32_t,
    pub __fpu_mxcsrmask: __uint32_t,
    pub __fpu_stmm0: __darwin_mmst_reg,
    pub __fpu_stmm1: __darwin_mmst_reg,
    pub __fpu_stmm2: __darwin_mmst_reg,
    pub __fpu_stmm3: __darwin_mmst_reg,
    pub __fpu_stmm4: __darwin_mmst_reg,
    pub __fpu_stmm5: __darwin_mmst_reg,
    pub __fpu_stmm6: __darwin_mmst_reg,
    pub __fpu_stmm7: __darwin_mmst_reg,
    pub __fpu_xmm0: __darwin_xmm_reg,
    pub __fpu_xmm1: __darwin_xmm_reg,
    pub __fpu_xmm2: __darwin_xmm_reg,
    pub __fpu_xmm3: __darwin_xmm_reg,
    pub __fpu_xmm4: __darwin_xmm_reg,
    pub __fpu_xmm5: __darwin_xmm_reg,
    pub __fpu_xmm6: __darwin_xmm_reg,
    pub __fpu_xmm7: __darwin_xmm_reg,
    pub __fpu_xmm8: __darwin_xmm_reg,
    pub __fpu_xmm9: __darwin_xmm_reg,
    pub __fpu_xmm10: __darwin_xmm_reg,
    pub __fpu_xmm11: __darwin_xmm_reg,
    pub __fpu_xmm12: __darwin_xmm_reg,
    pub __fpu_xmm13: __darwin_xmm_reg,
    pub __fpu_xmm14: __darwin_xmm_reg,
    pub __fpu_xmm15: __darwin_xmm_reg,
    pub __fpu_rsrv4: [::std::os::raw::c_char; 96usize],
    pub __fpu_reserved1: ::std::os::raw::c_int,
    pub __avx_reserved1: [::std::os::raw::c_char; 64usize],
    pub __fpu_ymmh0: __darwin_xmm_reg,
    pub __fpu_ymmh1: __darwin_xmm_reg,
    pub __fpu_ymmh2: __darwin_xmm_reg,
    pub __fpu_ymmh3: __darwin_xmm_reg,
    pub __fpu_ymmh4: __darwin_xmm_reg,
    pub __fpu_ymmh5: __darwin_xmm_reg,
    pub __fpu_ymmh6: __darwin_xmm_reg,
    pub __fpu_ymmh7: __darwin_xmm_reg,
    pub __fpu_ymmh8: __darwin_xmm_reg,
    pub __fpu_ymmh9: __darwin_xmm_reg,
    pub __fpu_ymmh10: __darwin_xmm_reg,
    pub __fpu_ymmh11: __darwin_xmm_reg,
    pub __fpu_ymmh12: __darwin_xmm_reg,
    pub __fpu_ymmh13: __darwin_xmm_reg,
    pub __fpu_ymmh14: __darwin_xmm_reg,
    pub __fpu_ymmh15: __darwin_xmm_reg,
    pub __fpu_k0: __darwin_opmask_reg,
    pub __fpu_k1: __darwin_opmask_reg,
    pub __fpu_k2: __darwin_opmask_reg,
    pub __fpu_k3: __darwin_opmask_reg,
    pub __fpu_k4: __darwin_opmask_reg,
    pub __fpu_k5: __darwin_opmask_reg,
    pub __fpu_k6: __darwin_opmask_reg,
    pub __fpu_k7: __darwin_opmask_reg,
    pub __fpu_zmmh0: __darwin_ymm_reg,
    pub __fpu_zmmh1: __darwin_ymm_reg,
    pub __fpu_zmmh2: __darwin_ymm_reg,
    pub __fpu_zmmh3: __darwin_ymm_reg,
    pub __fpu_zmmh4: __darwin_ymm_reg,
    pub __fpu_zmmh5: __darwin_ymm_reg,
    pub __fpu_zmmh6: __darwin_ymm_reg,
    pub __fpu_zmmh7: __darwin_ymm_reg,
    pub __fpu_zmmh8: __darwin_ymm_reg,
    pub __fpu_zmmh9: __darwin_ymm_reg,
    pub __fpu_zmmh10: __darwin_ymm_reg,
    pub __fpu_zmmh11: __darwin_ymm_reg,
    pub __fpu_zmmh12: __darwin_ymm_reg,
    pub __fpu_zmmh13: __darwin_ymm_reg,
    pub __fpu_zmmh14: __darwin_ymm_reg,
    pub __fpu_zmmh15: __darwin_ymm_reg,
    pub __fpu_zmm16: __darwin_zmm_reg,
    pub __fpu_zmm17: __darwin_zmm_reg,
    pub __fpu_zmm18: __darwin_zmm_reg,
    pub __fpu_zmm19: __darwin_zmm_reg,
    pub __fpu_zmm20: __darwin_zmm_reg,
    pub __fpu_zmm21: __darwin_zmm_reg,
    pub __fpu_zmm22: __darwin_zmm_reg,
    pub __fpu_zmm23: __darwin_zmm_reg,
    pub __fpu_zmm24: __darwin_zmm_reg,
    pub __fpu_zmm25: __darwin_zmm_reg,
    pub __fpu_zmm26: __darwin_zmm_reg,
    pub __fpu_zmm27: __darwin_zmm_reg,
    pub __fpu_zmm28: __darwin_zmm_reg,
    pub __fpu_zmm29: __darwin_zmm_reg,
    pub __fpu_zmm30: __darwin_zmm_reg,
    pub __fpu_zmm31: __darwin_zmm_reg,
}
#[test]
fn bindgen_test_layout___darwin_x86_avx512_state64() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_x86_avx512_state64>(),
        2444usize,
        concat!("Size of: ", stringify!(__darwin_x86_avx512_state64))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_x86_avx512_state64>(),
        4usize,
        concat!("Alignment of ", stringify!(__darwin_x86_avx512_state64))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_reserved as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_reserved)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_fcw as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_fcw)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_fsw as *const _ as usize
        },
        10usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_fsw)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_ftw as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_ftw)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_rsrv1 as *const _ as usize
        },
        13usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_rsrv1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_fop as *const _ as usize
        },
        14usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_fop)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_ip as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_ip)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_cs as *const _ as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_cs)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_rsrv2 as *const _ as usize
        },
        22usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_rsrv2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_dp as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_dp)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_ds as *const _ as usize
        },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_ds)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_rsrv3 as *const _ as usize
        },
        30usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_rsrv3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_mxcsr as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_mxcsr)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_mxcsrmask as *const _
                as usize
        },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_mxcsrmask)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_stmm0 as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_stmm0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_stmm1 as *const _ as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_stmm1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_stmm2 as *const _ as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_stmm2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_stmm3 as *const _ as usize
        },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_stmm3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_stmm4 as *const _ as usize
        },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_stmm4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_stmm5 as *const _ as usize
        },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_stmm5)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_stmm6 as *const _ as usize
        },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_stmm6)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_stmm7 as *const _ as usize
        },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_stmm7)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_xmm0 as *const _ as usize
        },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_xmm0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_xmm1 as *const _ as usize
        },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_xmm1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_xmm2 as *const _ as usize
        },
        200usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_xmm2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_xmm3 as *const _ as usize
        },
        216usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_xmm3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_xmm4 as *const _ as usize
        },
        232usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_xmm4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_xmm5 as *const _ as usize
        },
        248usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_xmm5)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_xmm6 as *const _ as usize
        },
        264usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_xmm6)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_xmm7 as *const _ as usize
        },
        280usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_xmm7)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_xmm8 as *const _ as usize
        },
        296usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_xmm8)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_xmm9 as *const _ as usize
        },
        312usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_xmm9)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_xmm10 as *const _ as usize
        },
        328usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_xmm10)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_xmm11 as *const _ as usize
        },
        344usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_xmm11)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_xmm12 as *const _ as usize
        },
        360usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_xmm12)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_xmm13 as *const _ as usize
        },
        376usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_xmm13)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_xmm14 as *const _ as usize
        },
        392usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_xmm14)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_xmm15 as *const _ as usize
        },
        408usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_xmm15)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_rsrv4 as *const _ as usize
        },
        424usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_rsrv4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_reserved1 as *const _
                as usize
        },
        520usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_reserved1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__avx_reserved1 as *const _
                as usize
        },
        524usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__avx_reserved1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_ymmh0 as *const _ as usize
        },
        588usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_ymmh0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_ymmh1 as *const _ as usize
        },
        604usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_ymmh1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_ymmh2 as *const _ as usize
        },
        620usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_ymmh2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_ymmh3 as *const _ as usize
        },
        636usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_ymmh3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_ymmh4 as *const _ as usize
        },
        652usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_ymmh4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_ymmh5 as *const _ as usize
        },
        668usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_ymmh5)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_ymmh6 as *const _ as usize
        },
        684usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_ymmh6)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_ymmh7 as *const _ as usize
        },
        700usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_ymmh7)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_ymmh8 as *const _ as usize
        },
        716usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_ymmh8)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_ymmh9 as *const _ as usize
        },
        732usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_ymmh9)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_ymmh10 as *const _
                as usize
        },
        748usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_ymmh10)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_ymmh11 as *const _
                as usize
        },
        764usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_ymmh11)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_ymmh12 as *const _
                as usize
        },
        780usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_ymmh12)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_ymmh13 as *const _
                as usize
        },
        796usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_ymmh13)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_ymmh14 as *const _
                as usize
        },
        812usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_ymmh14)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_ymmh15 as *const _
                as usize
        },
        828usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_ymmh15)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_k0 as *const _ as usize
        },
        844usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_k0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_k1 as *const _ as usize
        },
        852usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_k1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_k2 as *const _ as usize
        },
        860usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_k2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_k3 as *const _ as usize
        },
        868usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_k3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_k4 as *const _ as usize
        },
        876usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_k4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_k5 as *const _ as usize
        },
        884usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_k5)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_k6 as *const _ as usize
        },
        892usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_k6)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_k7 as *const _ as usize
        },
        900usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_k7)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmmh0 as *const _ as usize
        },
        908usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmmh0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmmh1 as *const _ as usize
        },
        940usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmmh1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmmh2 as *const _ as usize
        },
        972usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmmh2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmmh3 as *const _ as usize
        },
        1004usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmmh3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmmh4 as *const _ as usize
        },
        1036usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmmh4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmmh5 as *const _ as usize
        },
        1068usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmmh5)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmmh6 as *const _ as usize
        },
        1100usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmmh6)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmmh7 as *const _ as usize
        },
        1132usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmmh7)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmmh8 as *const _ as usize
        },
        1164usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmmh8)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmmh9 as *const _ as usize
        },
        1196usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmmh9)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmmh10 as *const _
                as usize
        },
        1228usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmmh10)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmmh11 as *const _
                as usize
        },
        1260usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmmh11)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmmh12 as *const _
                as usize
        },
        1292usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmmh12)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmmh13 as *const _
                as usize
        },
        1324usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmmh13)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmmh14 as *const _
                as usize
        },
        1356usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmmh14)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmmh15 as *const _
                as usize
        },
        1388usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmmh15)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmm16 as *const _ as usize
        },
        1420usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmm16)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmm17 as *const _ as usize
        },
        1484usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmm17)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmm18 as *const _ as usize
        },
        1548usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmm18)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmm19 as *const _ as usize
        },
        1612usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmm19)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmm20 as *const _ as usize
        },
        1676usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmm20)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmm21 as *const _ as usize
        },
        1740usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmm21)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmm22 as *const _ as usize
        },
        1804usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmm22)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmm23 as *const _ as usize
        },
        1868usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmm23)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmm24 as *const _ as usize
        },
        1932usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmm24)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmm25 as *const _ as usize
        },
        1996usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmm25)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmm26 as *const _ as usize
        },
        2060usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmm26)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmm27 as *const _ as usize
        },
        2124usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmm27)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmm28 as *const _ as usize
        },
        2188usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmm28)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmm29 as *const _ as usize
        },
        2252usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmm29)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmm30 as *const _ as usize
        },
        2316usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmm30)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmm31 as *const _ as usize
        },
        2380usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmm31)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_x86_exception_state64 {
    pub __trapno: __uint16_t,
    pub __cpu: __uint16_t,
    pub __err: __uint32_t,
    pub __faultvaddr: __uint64_t,
}
#[test]
fn bindgen_test_layout___darwin_x86_exception_state64() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_x86_exception_state64>(),
        16usize,
        concat!("Size of: ", stringify!(__darwin_x86_exception_state64))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_x86_exception_state64>(),
        8usize,
        concat!("Alignment of ", stringify!(__darwin_x86_exception_state64))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_exception_state64>())).__trapno as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_exception_state64),
            "::",
            stringify!(__trapno)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_exception_state64>())).__cpu as *const _ as usize
        },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_exception_state64),
            "::",
            stringify!(__cpu)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_exception_state64>())).__err as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_exception_state64),
            "::",
            stringify!(__err)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_exception_state64>())).__faultvaddr as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_exception_state64),
            "::",
            stringify!(__faultvaddr)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_x86_debug_state64 {
    pub __dr0: __uint64_t,
    pub __dr1: __uint64_t,
    pub __dr2: __uint64_t,
    pub __dr3: __uint64_t,
    pub __dr4: __uint64_t,
    pub __dr5: __uint64_t,
    pub __dr6: __uint64_t,
    pub __dr7: __uint64_t,
}
#[test]
fn bindgen_test_layout___darwin_x86_debug_state64() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_x86_debug_state64>(),
        64usize,
        concat!("Size of: ", stringify!(__darwin_x86_debug_state64))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_x86_debug_state64>(),
        8usize,
        concat!("Alignment of ", stringify!(__darwin_x86_debug_state64))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_debug_state64>())).__dr0 as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_debug_state64),
            "::",
            stringify!(__dr0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_debug_state64>())).__dr1 as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_debug_state64),
            "::",
            stringify!(__dr1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_debug_state64>())).__dr2 as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_debug_state64),
            "::",
            stringify!(__dr2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_debug_state64>())).__dr3 as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_debug_state64),
            "::",
            stringify!(__dr3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_debug_state64>())).__dr4 as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_debug_state64),
            "::",
            stringify!(__dr4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_debug_state64>())).__dr5 as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_debug_state64),
            "::",
            stringify!(__dr5)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_debug_state64>())).__dr6 as *const _ as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_debug_state64),
            "::",
            stringify!(__dr6)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_debug_state64>())).__dr7 as *const _ as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_debug_state64),
            "::",
            stringify!(__dr7)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_x86_cpmu_state64 {
    pub __ctrs: [__uint64_t; 16usize],
}
#[test]
fn bindgen_test_layout___darwin_x86_cpmu_state64() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_x86_cpmu_state64>(),
        128usize,
        concat!("Size of: ", stringify!(__darwin_x86_cpmu_state64))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_x86_cpmu_state64>(),
        8usize,
        concat!("Alignment of ", stringify!(__darwin_x86_cpmu_state64))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_cpmu_state64>())).__ctrs as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_cpmu_state64),
            "::",
            stringify!(__ctrs)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct __darwin_mcontext32 {
    pub __es: __darwin_i386_exception_state,
    pub __ss: __darwin_i386_thread_state,
    pub __fs: __darwin_i386_float_state,
}
#[test]
fn bindgen_test_layout___darwin_mcontext32() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_mcontext32>(),
        600usize,
        concat!("Size of: ", stringify!(__darwin_mcontext32))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_mcontext32>(),
        4usize,
        concat!("Alignment of ", stringify!(__darwin_mcontext32))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_mcontext32>())).__es as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext32),
            "::",
            stringify!(__es)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_mcontext32>())).__ss as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext32),
            "::",
            stringify!(__ss)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_mcontext32>())).__fs as *const _ as usize },
        76usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext32),
            "::",
            stringify!(__fs)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct __darwin_mcontext_avx32 {
    pub __es: __darwin_i386_exception_state,
    pub __ss: __darwin_i386_thread_state,
    pub __fs: __darwin_i386_avx_state,
}
#[test]
fn bindgen_test_layout___darwin_mcontext_avx32() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_mcontext_avx32>(),
        792usize,
        concat!("Size of: ", stringify!(__darwin_mcontext_avx32))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_mcontext_avx32>(),
        4usize,
        concat!("Alignment of ", stringify!(__darwin_mcontext_avx32))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_mcontext_avx32>())).__es as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext_avx32),
            "::",
            stringify!(__es)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_mcontext_avx32>())).__ss as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext_avx32),
            "::",
            stringify!(__ss)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_mcontext_avx32>())).__fs as *const _ as usize },
        76usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext_avx32),
            "::",
            stringify!(__fs)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct __darwin_mcontext_avx512_32 {
    pub __es: __darwin_i386_exception_state,
    pub __ss: __darwin_i386_thread_state,
    pub __fs: __darwin_i386_avx512_state,
}
#[test]
fn bindgen_test_layout___darwin_mcontext_avx512_32() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_mcontext_avx512_32>(),
        1112usize,
        concat!("Size of: ", stringify!(__darwin_mcontext_avx512_32))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_mcontext_avx512_32>(),
        4usize,
        concat!("Alignment of ", stringify!(__darwin_mcontext_avx512_32))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_mcontext_avx512_32>())).__es as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext_avx512_32),
            "::",
            stringify!(__es)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_mcontext_avx512_32>())).__ss as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext_avx512_32),
            "::",
            stringify!(__ss)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_mcontext_avx512_32>())).__fs as *const _ as usize
        },
        76usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext_avx512_32),
            "::",
            stringify!(__fs)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct __darwin_mcontext64 {
    pub __es: __darwin_x86_exception_state64,
    pub __ss: __darwin_x86_thread_state64,
    pub __fs: __darwin_x86_float_state64,
}
#[test]
fn bindgen_test_layout___darwin_mcontext64() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_mcontext64>(),
        712usize,
        concat!("Size of: ", stringify!(__darwin_mcontext64))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_mcontext64>(),
        8usize,
        concat!("Alignment of ", stringify!(__darwin_mcontext64))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_mcontext64>())).__es as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext64),
            "::",
            stringify!(__es)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_mcontext64>())).__ss as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext64),
            "::",
            stringify!(__ss)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_mcontext64>())).__fs as *const _ as usize },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext64),
            "::",
            stringify!(__fs)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct __darwin_mcontext64_full {
    pub __es: __darwin_x86_exception_state64,
    pub __ss: __darwin_x86_thread_full_state64,
    pub __fs: __darwin_x86_float_state64,
}
#[test]
fn bindgen_test_layout___darwin_mcontext64_full() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_mcontext64_full>(),
        744usize,
        concat!("Size of: ", stringify!(__darwin_mcontext64_full))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_mcontext64_full>(),
        8usize,
        concat!("Alignment of ", stringify!(__darwin_mcontext64_full))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_mcontext64_full>())).__es as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext64_full),
            "::",
            stringify!(__es)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_mcontext64_full>())).__ss as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext64_full),
            "::",
            stringify!(__ss)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_mcontext64_full>())).__fs as *const _ as usize },
        216usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext64_full),
            "::",
            stringify!(__fs)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct __darwin_mcontext_avx64 {
    pub __es: __darwin_x86_exception_state64,
    pub __ss: __darwin_x86_thread_state64,
    pub __fs: __darwin_x86_avx_state64,
}
#[test]
fn bindgen_test_layout___darwin_mcontext_avx64() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_mcontext_avx64>(),
        1032usize,
        concat!("Size of: ", stringify!(__darwin_mcontext_avx64))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_mcontext_avx64>(),
        8usize,
        concat!("Alignment of ", stringify!(__darwin_mcontext_avx64))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_mcontext_avx64>())).__es as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext_avx64),
            "::",
            stringify!(__es)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_mcontext_avx64>())).__ss as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext_avx64),
            "::",
            stringify!(__ss)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_mcontext_avx64>())).__fs as *const _ as usize },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext_avx64),
            "::",
            stringify!(__fs)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct __darwin_mcontext_avx64_full {
    pub __es: __darwin_x86_exception_state64,
    pub __ss: __darwin_x86_thread_full_state64,
    pub __fs: __darwin_x86_avx_state64,
}
#[test]
fn bindgen_test_layout___darwin_mcontext_avx64_full() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_mcontext_avx64_full>(),
        1064usize,
        concat!("Size of: ", stringify!(__darwin_mcontext_avx64_full))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_mcontext_avx64_full>(),
        8usize,
        concat!("Alignment of ", stringify!(__darwin_mcontext_avx64_full))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_mcontext_avx64_full>())).__es as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext_avx64_full),
            "::",
            stringify!(__es)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_mcontext_avx64_full>())).__ss as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext_avx64_full),
            "::",
            stringify!(__ss)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_mcontext_avx64_full>())).__fs as *const _ as usize
        },
        216usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext_avx64_full),
            "::",
            stringify!(__fs)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct __darwin_mcontext_avx512_64 {
    pub __es: __darwin_x86_exception_state64,
    pub __ss: __darwin_x86_thread_state64,
    pub __fs: __darwin_x86_avx512_state64,
}
#[test]
fn bindgen_test_layout___darwin_mcontext_avx512_64() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_mcontext_avx512_64>(),
        2632usize,
        concat!("Size of: ", stringify!(__darwin_mcontext_avx512_64))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_mcontext_avx512_64>(),
        8usize,
        concat!("Alignment of ", stringify!(__darwin_mcontext_avx512_64))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_mcontext_avx512_64>())).__es as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext_avx512_64),
            "::",
            stringify!(__es)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_mcontext_avx512_64>())).__ss as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext_avx512_64),
            "::",
            stringify!(__ss)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_mcontext_avx512_64>())).__fs as *const _ as usize
        },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext_avx512_64),
            "::",
            stringify!(__fs)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct __darwin_mcontext_avx512_64_full {
    pub __es: __darwin_x86_exception_state64,
    pub __ss: __darwin_x86_thread_full_state64,
    pub __fs: __darwin_x86_avx512_state64,
}
#[test]
fn bindgen_test_layout___darwin_mcontext_avx512_64_full() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_mcontext_avx512_64_full>(),
        2664usize,
        concat!("Size of: ", stringify!(__darwin_mcontext_avx512_64_full))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_mcontext_avx512_64_full>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__darwin_mcontext_avx512_64_full)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_mcontext_avx512_64_full>())).__es as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext_avx512_64_full),
            "::",
            stringify!(__es)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_mcontext_avx512_64_full>())).__ss as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext_avx512_64_full),
            "::",
            stringify!(__ss)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_mcontext_avx512_64_full>())).__fs as *const _ as usize
        },
        216usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext_avx512_64_full),
            "::",
            stringify!(__fs)
        )
    );
}
pub type mcontext_t = *mut __darwin_mcontext64;
pub type pthread_attr_t = __darwin_pthread_attr_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_sigaltstack {
    pub ss_sp: *mut ::std::os::raw::c_void,
    pub ss_size: __darwin_size_t,
    pub ss_flags: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout___darwin_sigaltstack() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_sigaltstack>(),
        24usize,
        concat!("Size of: ", stringify!(__darwin_sigaltstack))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_sigaltstack>(),
        8usize,
        concat!("Alignment of ", stringify!(__darwin_sigaltstack))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_sigaltstack>())).ss_sp as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_sigaltstack),
            "::",
            stringify!(ss_sp)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_sigaltstack>())).ss_size as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_sigaltstack),
            "::",
            stringify!(ss_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_sigaltstack>())).ss_flags as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_sigaltstack),
            "::",
            stringify!(ss_flags)
        )
    );
}
pub type stack_t = __darwin_sigaltstack;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_ucontext {
    pub uc_onstack: ::std::os::raw::c_int,
    pub uc_sigmask: __darwin_sigset_t,
    pub uc_stack: __darwin_sigaltstack,
    pub uc_link: *mut __darwin_ucontext,
    pub uc_mcsize: __darwin_size_t,
    pub uc_mcontext: *mut __darwin_mcontext64,
}
#[test]
fn bindgen_test_layout___darwin_ucontext() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_ucontext>(),
        56usize,
        concat!("Size of: ", stringify!(__darwin_ucontext))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_ucontext>(),
        8usize,
        concat!("Alignment of ", stringify!(__darwin_ucontext))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_ucontext>())).uc_onstack as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_ucontext),
            "::",
            stringify!(uc_onstack)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_ucontext>())).uc_sigmask as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_ucontext),
            "::",
            stringify!(uc_sigmask)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_ucontext>())).uc_stack as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_ucontext),
            "::",
            stringify!(uc_stack)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_ucontext>())).uc_link as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_ucontext),
            "::",
            stringify!(uc_link)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_ucontext>())).uc_mcsize as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_ucontext),
            "::",
            stringify!(uc_mcsize)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_ucontext>())).uc_mcontext as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_ucontext),
            "::",
            stringify!(uc_mcontext)
        )
    );
}
pub type ucontext_t = __darwin_ucontext;
pub type sigset_t = __darwin_sigset_t;
pub type uid_t = __darwin_uid_t;
#[repr(C)]
#[derive(Copy, Clone)]
pub union sigval {
    pub sival_int: ::std::os::raw::c_int,
    pub sival_ptr: *mut ::std::os::raw::c_void,
    _bindgen_union_align: u64,
}
#[test]
fn bindgen_test_layout_sigval() {
    assert_eq!(
        ::std::mem::size_of::<sigval>(),
        8usize,
        concat!("Size of: ", stringify!(sigval))
    );
    assert_eq!(
        ::std::mem::align_of::<sigval>(),
        8usize,
        concat!("Alignment of ", stringify!(sigval))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigval>())).sival_int as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(sigval),
            "::",
            stringify!(sival_int)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigval>())).sival_ptr as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(sigval),
            "::",
            stringify!(sival_ptr)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct sigevent {
    pub sigev_notify: ::std::os::raw::c_int,
    pub sigev_signo: ::std::os::raw::c_int,
    pub sigev_value: sigval,
    pub sigev_notify_function: ::std::option::Option<unsafe extern "C" fn(arg1: sigval)>,
    pub sigev_notify_attributes: *mut pthread_attr_t,
}
#[test]
fn bindgen_test_layout_sigevent() {
    assert_eq!(
        ::std::mem::size_of::<sigevent>(),
        32usize,
        concat!("Size of: ", stringify!(sigevent))
    );
    assert_eq!(
        ::std::mem::align_of::<sigevent>(),
        8usize,
        concat!("Alignment of ", stringify!(sigevent))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigevent>())).sigev_notify as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(sigevent),
            "::",
            stringify!(sigev_notify)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigevent>())).sigev_signo as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(sigevent),
            "::",
            stringify!(sigev_signo)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigevent>())).sigev_value as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(sigevent),
            "::",
            stringify!(sigev_value)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigevent>())).sigev_notify_function as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(sigevent),
            "::",
            stringify!(sigev_notify_function)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<sigevent>())).sigev_notify_attributes as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(sigevent),
            "::",
            stringify!(sigev_notify_attributes)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct __siginfo {
    pub si_signo: ::std::os::raw::c_int,
    pub si_errno: ::std::os::raw::c_int,
    pub si_code: ::std::os::raw::c_int,
    pub si_pid: pid_t,
    pub si_uid: uid_t,
    pub si_status: ::std::os::raw::c_int,
    pub si_addr: *mut ::std::os::raw::c_void,
    pub si_value: sigval,
    pub si_band: ::std::os::raw::c_long,
    pub __pad: [::std::os::raw::c_ulong; 7usize],
}
#[test]
fn bindgen_test_layout___siginfo() {
    assert_eq!(
        ::std::mem::size_of::<__siginfo>(),
        104usize,
        concat!("Size of: ", stringify!(__siginfo))
    );
    assert_eq!(
        ::std::mem::align_of::<__siginfo>(),
        8usize,
        concat!("Alignment of ", stringify!(__siginfo))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__siginfo>())).si_signo as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__siginfo),
            "::",
            stringify!(si_signo)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__siginfo>())).si_errno as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(__siginfo),
            "::",
            stringify!(si_errno)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__siginfo>())).si_code as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__siginfo),
            "::",
            stringify!(si_code)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__siginfo>())).si_pid as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(__siginfo),
            "::",
            stringify!(si_pid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__siginfo>())).si_uid as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__siginfo),
            "::",
            stringify!(si_uid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__siginfo>())).si_status as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(__siginfo),
            "::",
            stringify!(si_status)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__siginfo>())).si_addr as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__siginfo),
            "::",
            stringify!(si_addr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__siginfo>())).si_value as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__siginfo),
            "::",
            stringify!(si_value)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__siginfo>())).si_band as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(__siginfo),
            "::",
            stringify!(si_band)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__siginfo>())).__pad as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(__siginfo),
            "::",
            stringify!(__pad)
        )
    );
}
pub type siginfo_t = __siginfo;
#[repr(C)]
#[derive(Copy, Clone)]
pub union __sigaction_u {
    pub __sa_handler: ::std::option::Option<unsafe extern "C" fn(arg1: ::std::os::raw::c_int)>,
    pub __sa_sigaction: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: ::std::os::raw::c_int,
            arg2: *mut __siginfo,
            arg3: *mut ::std::os::raw::c_void,
        ),
    >,
    _bindgen_union_align: u64,
}
#[test]
fn bindgen_test_layout___sigaction_u() {
    assert_eq!(
        ::std::mem::size_of::<__sigaction_u>(),
        8usize,
        concat!("Size of: ", stringify!(__sigaction_u))
    );
    assert_eq!(
        ::std::mem::align_of::<__sigaction_u>(),
        8usize,
        concat!("Alignment of ", stringify!(__sigaction_u))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sigaction_u>())).__sa_handler as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__sigaction_u),
            "::",
            stringify!(__sa_handler)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sigaction_u>())).__sa_sigaction as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__sigaction_u),
            "::",
            stringify!(__sa_sigaction)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct __sigaction {
    pub __sigaction_u: __sigaction_u,
    pub sa_tramp: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *mut ::std::os::raw::c_void,
            arg2: ::std::os::raw::c_int,
            arg3: ::std::os::raw::c_int,
            arg4: *mut siginfo_t,
            arg5: *mut ::std::os::raw::c_void,
        ),
    >,
    pub sa_mask: sigset_t,
    pub sa_flags: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout___sigaction() {
    assert_eq!(
        ::std::mem::size_of::<__sigaction>(),
        24usize,
        concat!("Size of: ", stringify!(__sigaction))
    );
    assert_eq!(
        ::std::mem::align_of::<__sigaction>(),
        8usize,
        concat!("Alignment of ", stringify!(__sigaction))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sigaction>())).__sigaction_u as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__sigaction),
            "::",
            stringify!(__sigaction_u)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sigaction>())).sa_tramp as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__sigaction),
            "::",
            stringify!(sa_tramp)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sigaction>())).sa_mask as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__sigaction),
            "::",
            stringify!(sa_mask)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sigaction>())).sa_flags as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(__sigaction),
            "::",
            stringify!(sa_flags)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct sigaction {
    pub __sigaction_u: __sigaction_u,
    pub sa_mask: sigset_t,
    pub sa_flags: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_sigaction() {
    assert_eq!(
        ::std::mem::size_of::<sigaction>(),
        16usize,
        concat!("Size of: ", stringify!(sigaction))
    );
    assert_eq!(
        ::std::mem::align_of::<sigaction>(),
        8usize,
        concat!("Alignment of ", stringify!(sigaction))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigaction>())).__sigaction_u as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(sigaction),
            "::",
            stringify!(__sigaction_u)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigaction>())).sa_mask as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(sigaction),
            "::",
            stringify!(sa_mask)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigaction>())).sa_flags as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(sigaction),
            "::",
            stringify!(sa_flags)
        )
    );
}
pub type sig_t = ::std::option::Option<unsafe extern "C" fn(arg1: ::std::os::raw::c_int)>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct sigvec {
    pub sv_handler: ::std::option::Option<unsafe extern "C" fn(arg1: ::std::os::raw::c_int)>,
    pub sv_mask: ::std::os::raw::c_int,
    pub sv_flags: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_sigvec() {
    assert_eq!(
        ::std::mem::size_of::<sigvec>(),
        16usize,
        concat!("Size of: ", stringify!(sigvec))
    );
    assert_eq!(
        ::std::mem::align_of::<sigvec>(),
        8usize,
        concat!("Alignment of ", stringify!(sigvec))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigvec>())).sv_handler as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(sigvec),
            "::",
            stringify!(sv_handler)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigvec>())).sv_mask as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(sigvec),
            "::",
            stringify!(sv_mask)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigvec>())).sv_flags as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(sigvec),
            "::",
            stringify!(sv_flags)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct sigstack {
    pub ss_sp: *mut ::std::os::raw::c_char,
    pub ss_onstack: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_sigstack() {
    assert_eq!(
        ::std::mem::size_of::<sigstack>(),
        16usize,
        concat!("Size of: ", stringify!(sigstack))
    );
    assert_eq!(
        ::std::mem::align_of::<sigstack>(),
        8usize,
        concat!("Alignment of ", stringify!(sigstack))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigstack>())).ss_sp as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(sigstack),
            "::",
            stringify!(ss_sp)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigstack>())).ss_onstack as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(sigstack),
            "::",
            stringify!(ss_onstack)
        )
    );
}
extern "C" {
    pub fn signal(
        arg1: ::std::os::raw::c_int,
        arg2: ::std::option::Option<unsafe extern "C" fn(arg1: ::std::os::raw::c_int)>,
    ) -> ::std::option::Option<
        unsafe extern "C" fn(
            arg1: ::std::os::raw::c_int,
            arg2: ::std::option::Option<unsafe extern "C" fn(arg1: ::std::os::raw::c_int)>,
        ),
    >;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct timeval {
    pub tv_sec: __darwin_time_t,
    pub tv_usec: __darwin_suseconds_t,
}
#[test]
fn bindgen_test_layout_timeval() {
    assert_eq!(
        ::std::mem::size_of::<timeval>(),
        16usize,
        concat!("Size of: ", stringify!(timeval))
    );
    assert_eq!(
        ::std::mem::align_of::<timeval>(),
        8usize,
        concat!("Alignment of ", stringify!(timeval))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<timeval>())).tv_sec as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(timeval),
            "::",
            stringify!(tv_sec)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<timeval>())).tv_usec as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(timeval),
            "::",
            stringify!(tv_usec)
        )
    );
}
pub type rlim_t = __uint64_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rusage {
    pub ru_utime: timeval,
    pub ru_stime: timeval,
    pub ru_maxrss: ::std::os::raw::c_long,
    pub ru_ixrss: ::std::os::raw::c_long,
    pub ru_idrss: ::std::os::raw::c_long,
    pub ru_isrss: ::std::os::raw::c_long,
    pub ru_minflt: ::std::os::raw::c_long,
    pub ru_majflt: ::std::os::raw::c_long,
    pub ru_nswap: ::std::os::raw::c_long,
    pub ru_inblock: ::std::os::raw::c_long,
    pub ru_oublock: ::std::os::raw::c_long,
    pub ru_msgsnd: ::std::os::raw::c_long,
    pub ru_msgrcv: ::std::os::raw::c_long,
    pub ru_nsignals: ::std::os::raw::c_long,
    pub ru_nvcsw: ::std::os::raw::c_long,
    pub ru_nivcsw: ::std::os::raw::c_long,
}
#[test]
fn bindgen_test_layout_rusage() {
    assert_eq!(
        ::std::mem::size_of::<rusage>(),
        144usize,
        concat!("Size of: ", stringify!(rusage))
    );
    assert_eq!(
        ::std::mem::align_of::<rusage>(),
        8usize,
        concat!("Alignment of ", stringify!(rusage))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage>())).ru_utime as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage),
            "::",
            stringify!(ru_utime)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage>())).ru_stime as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage),
            "::",
            stringify!(ru_stime)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage>())).ru_maxrss as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage),
            "::",
            stringify!(ru_maxrss)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage>())).ru_ixrss as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage),
            "::",
            stringify!(ru_ixrss)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage>())).ru_idrss as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage),
            "::",
            stringify!(ru_idrss)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage>())).ru_isrss as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage),
            "::",
            stringify!(ru_isrss)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage>())).ru_minflt as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage),
            "::",
            stringify!(ru_minflt)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage>())).ru_majflt as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage),
            "::",
            stringify!(ru_majflt)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage>())).ru_nswap as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage),
            "::",
            stringify!(ru_nswap)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage>())).ru_inblock as *const _ as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage),
            "::",
            stringify!(ru_inblock)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage>())).ru_oublock as *const _ as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage),
            "::",
            stringify!(ru_oublock)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage>())).ru_msgsnd as *const _ as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage),
            "::",
            stringify!(ru_msgsnd)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage>())).ru_msgrcv as *const _ as usize },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage),
            "::",
            stringify!(ru_msgrcv)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage>())).ru_nsignals as *const _ as usize },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage),
            "::",
            stringify!(ru_nsignals)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage>())).ru_nvcsw as *const _ as usize },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage),
            "::",
            stringify!(ru_nvcsw)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage>())).ru_nivcsw as *const _ as usize },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage),
            "::",
            stringify!(ru_nivcsw)
        )
    );
}
pub type rusage_info_t = *mut ::std::os::raw::c_void;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rusage_info_v0 {
    pub ri_uuid: [u8; 16usize],
    pub ri_user_time: u64,
    pub ri_system_time: u64,
    pub ri_pkg_idle_wkups: u64,
    pub ri_interrupt_wkups: u64,
    pub ri_pageins: u64,
    pub ri_wired_size: u64,
    pub ri_resident_size: u64,
    pub ri_phys_footprint: u64,
    pub ri_proc_start_abstime: u64,
    pub ri_proc_exit_abstime: u64,
}
#[test]
fn bindgen_test_layout_rusage_info_v0() {
    assert_eq!(
        ::std::mem::size_of::<rusage_info_v0>(),
        96usize,
        concat!("Size of: ", stringify!(rusage_info_v0))
    );
    assert_eq!(
        ::std::mem::align_of::<rusage_info_v0>(),
        8usize,
        concat!("Alignment of ", stringify!(rusage_info_v0))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v0>())).ri_uuid as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v0),
            "::",
            stringify!(ri_uuid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v0>())).ri_user_time as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v0),
            "::",
            stringify!(ri_user_time)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v0>())).ri_system_time as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v0),
            "::",
            stringify!(ri_system_time)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v0>())).ri_pkg_idle_wkups as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v0),
            "::",
            stringify!(ri_pkg_idle_wkups)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v0>())).ri_interrupt_wkups as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v0),
            "::",
            stringify!(ri_interrupt_wkups)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v0>())).ri_pageins as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v0),
            "::",
            stringify!(ri_pageins)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v0>())).ri_wired_size as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v0),
            "::",
            stringify!(ri_wired_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v0>())).ri_resident_size as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v0),
            "::",
            stringify!(ri_resident_size)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v0>())).ri_phys_footprint as *const _ as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v0),
            "::",
            stringify!(ri_phys_footprint)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v0>())).ri_proc_start_abstime as *const _ as usize
        },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v0),
            "::",
            stringify!(ri_proc_start_abstime)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v0>())).ri_proc_exit_abstime as *const _ as usize
        },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v0),
            "::",
            stringify!(ri_proc_exit_abstime)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rusage_info_v1 {
    pub ri_uuid: [u8; 16usize],
    pub ri_user_time: u64,
    pub ri_system_time: u64,
    pub ri_pkg_idle_wkups: u64,
    pub ri_interrupt_wkups: u64,
    pub ri_pageins: u64,
    pub ri_wired_size: u64,
    pub ri_resident_size: u64,
    pub ri_phys_footprint: u64,
    pub ri_proc_start_abstime: u64,
    pub ri_proc_exit_abstime: u64,
    pub ri_child_user_time: u64,
    pub ri_child_system_time: u64,
    pub ri_child_pkg_idle_wkups: u64,
    pub ri_child_interrupt_wkups: u64,
    pub ri_child_pageins: u64,
    pub ri_child_elapsed_abstime: u64,
}
#[test]
fn bindgen_test_layout_rusage_info_v1() {
    assert_eq!(
        ::std::mem::size_of::<rusage_info_v1>(),
        144usize,
        concat!("Size of: ", stringify!(rusage_info_v1))
    );
    assert_eq!(
        ::std::mem::align_of::<rusage_info_v1>(),
        8usize,
        concat!("Alignment of ", stringify!(rusage_info_v1))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v1>())).ri_uuid as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v1),
            "::",
            stringify!(ri_uuid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v1>())).ri_user_time as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v1),
            "::",
            stringify!(ri_user_time)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v1>())).ri_system_time as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v1),
            "::",
            stringify!(ri_system_time)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v1>())).ri_pkg_idle_wkups as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v1),
            "::",
            stringify!(ri_pkg_idle_wkups)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v1>())).ri_interrupt_wkups as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v1),
            "::",
            stringify!(ri_interrupt_wkups)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v1>())).ri_pageins as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v1),
            "::",
            stringify!(ri_pageins)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v1>())).ri_wired_size as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v1),
            "::",
            stringify!(ri_wired_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v1>())).ri_resident_size as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v1),
            "::",
            stringify!(ri_resident_size)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v1>())).ri_phys_footprint as *const _ as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v1),
            "::",
            stringify!(ri_phys_footprint)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v1>())).ri_proc_start_abstime as *const _ as usize
        },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v1),
            "::",
            stringify!(ri_proc_start_abstime)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v1>())).ri_proc_exit_abstime as *const _ as usize
        },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v1),
            "::",
            stringify!(ri_proc_exit_abstime)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v1>())).ri_child_user_time as *const _ as usize
        },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v1),
            "::",
            stringify!(ri_child_user_time)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v1>())).ri_child_system_time as *const _ as usize
        },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v1),
            "::",
            stringify!(ri_child_system_time)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v1>())).ri_child_pkg_idle_wkups as *const _ as usize
        },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v1),
            "::",
            stringify!(ri_child_pkg_idle_wkups)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v1>())).ri_child_interrupt_wkups as *const _ as usize
        },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v1),
            "::",
            stringify!(ri_child_interrupt_wkups)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v1>())).ri_child_pageins as *const _ as usize },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v1),
            "::",
            stringify!(ri_child_pageins)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v1>())).ri_child_elapsed_abstime as *const _ as usize
        },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v1),
            "::",
            stringify!(ri_child_elapsed_abstime)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rusage_info_v2 {
    pub ri_uuid: [u8; 16usize],
    pub ri_user_time: u64,
    pub ri_system_time: u64,
    pub ri_pkg_idle_wkups: u64,
    pub ri_interrupt_wkups: u64,
    pub ri_pageins: u64,
    pub ri_wired_size: u64,
    pub ri_resident_size: u64,
    pub ri_phys_footprint: u64,
    pub ri_proc_start_abstime: u64,
    pub ri_proc_exit_abstime: u64,
    pub ri_child_user_time: u64,
    pub ri_child_system_time: u64,
    pub ri_child_pkg_idle_wkups: u64,
    pub ri_child_interrupt_wkups: u64,
    pub ri_child_pageins: u64,
    pub ri_child_elapsed_abstime: u64,
    pub ri_diskio_bytesread: u64,
    pub ri_diskio_byteswritten: u64,
}
#[test]
fn bindgen_test_layout_rusage_info_v2() {
    assert_eq!(
        ::std::mem::size_of::<rusage_info_v2>(),
        160usize,
        concat!("Size of: ", stringify!(rusage_info_v2))
    );
    assert_eq!(
        ::std::mem::align_of::<rusage_info_v2>(),
        8usize,
        concat!("Alignment of ", stringify!(rusage_info_v2))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v2>())).ri_uuid as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v2),
            "::",
            stringify!(ri_uuid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v2>())).ri_user_time as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v2),
            "::",
            stringify!(ri_user_time)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v2>())).ri_system_time as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v2),
            "::",
            stringify!(ri_system_time)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v2>())).ri_pkg_idle_wkups as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v2),
            "::",
            stringify!(ri_pkg_idle_wkups)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v2>())).ri_interrupt_wkups as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v2),
            "::",
            stringify!(ri_interrupt_wkups)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v2>())).ri_pageins as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v2),
            "::",
            stringify!(ri_pageins)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v2>())).ri_wired_size as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v2),
            "::",
            stringify!(ri_wired_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v2>())).ri_resident_size as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v2),
            "::",
            stringify!(ri_resident_size)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v2>())).ri_phys_footprint as *const _ as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v2),
            "::",
            stringify!(ri_phys_footprint)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v2>())).ri_proc_start_abstime as *const _ as usize
        },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v2),
            "::",
            stringify!(ri_proc_start_abstime)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v2>())).ri_proc_exit_abstime as *const _ as usize
        },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v2),
            "::",
            stringify!(ri_proc_exit_abstime)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v2>())).ri_child_user_time as *const _ as usize
        },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v2),
            "::",
            stringify!(ri_child_user_time)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v2>())).ri_child_system_time as *const _ as usize
        },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v2),
            "::",
            stringify!(ri_child_system_time)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v2>())).ri_child_pkg_idle_wkups as *const _ as usize
        },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v2),
            "::",
            stringify!(ri_child_pkg_idle_wkups)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v2>())).ri_child_interrupt_wkups as *const _ as usize
        },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v2),
            "::",
            stringify!(ri_child_interrupt_wkups)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v2>())).ri_child_pageins as *const _ as usize },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v2),
            "::",
            stringify!(ri_child_pageins)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v2>())).ri_child_elapsed_abstime as *const _ as usize
        },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v2),
            "::",
            stringify!(ri_child_elapsed_abstime)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v2>())).ri_diskio_bytesread as *const _ as usize
        },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v2),
            "::",
            stringify!(ri_diskio_bytesread)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v2>())).ri_diskio_byteswritten as *const _ as usize
        },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v2),
            "::",
            stringify!(ri_diskio_byteswritten)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rusage_info_v3 {
    pub ri_uuid: [u8; 16usize],
    pub ri_user_time: u64,
    pub ri_system_time: u64,
    pub ri_pkg_idle_wkups: u64,
    pub ri_interrupt_wkups: u64,
    pub ri_pageins: u64,
    pub ri_wired_size: u64,
    pub ri_resident_size: u64,
    pub ri_phys_footprint: u64,
    pub ri_proc_start_abstime: u64,
    pub ri_proc_exit_abstime: u64,
    pub ri_child_user_time: u64,
    pub ri_child_system_time: u64,
    pub ri_child_pkg_idle_wkups: u64,
    pub ri_child_interrupt_wkups: u64,
    pub ri_child_pageins: u64,
    pub ri_child_elapsed_abstime: u64,
    pub ri_diskio_bytesread: u64,
    pub ri_diskio_byteswritten: u64,
    pub ri_cpu_time_qos_default: u64,
    pub ri_cpu_time_qos_maintenance: u64,
    pub ri_cpu_time_qos_background: u64,
    pub ri_cpu_time_qos_utility: u64,
    pub ri_cpu_time_qos_legacy: u64,
    pub ri_cpu_time_qos_user_initiated: u64,
    pub ri_cpu_time_qos_user_interactive: u64,
    pub ri_billed_system_time: u64,
    pub ri_serviced_system_time: u64,
}
#[test]
fn bindgen_test_layout_rusage_info_v3() {
    assert_eq!(
        ::std::mem::size_of::<rusage_info_v3>(),
        232usize,
        concat!("Size of: ", stringify!(rusage_info_v3))
    );
    assert_eq!(
        ::std::mem::align_of::<rusage_info_v3>(),
        8usize,
        concat!("Alignment of ", stringify!(rusage_info_v3))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v3>())).ri_uuid as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_uuid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v3>())).ri_user_time as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_user_time)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v3>())).ri_system_time as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_system_time)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v3>())).ri_pkg_idle_wkups as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_pkg_idle_wkups)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v3>())).ri_interrupt_wkups as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_interrupt_wkups)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v3>())).ri_pageins as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_pageins)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v3>())).ri_wired_size as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_wired_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v3>())).ri_resident_size as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_resident_size)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v3>())).ri_phys_footprint as *const _ as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_phys_footprint)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v3>())).ri_proc_start_abstime as *const _ as usize
        },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_proc_start_abstime)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v3>())).ri_proc_exit_abstime as *const _ as usize
        },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_proc_exit_abstime)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v3>())).ri_child_user_time as *const _ as usize
        },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_child_user_time)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v3>())).ri_child_system_time as *const _ as usize
        },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_child_system_time)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v3>())).ri_child_pkg_idle_wkups as *const _ as usize
        },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_child_pkg_idle_wkups)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v3>())).ri_child_interrupt_wkups as *const _ as usize
        },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_child_interrupt_wkups)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v3>())).ri_child_pageins as *const _ as usize },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_child_pageins)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v3>())).ri_child_elapsed_abstime as *const _ as usize
        },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_child_elapsed_abstime)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v3>())).ri_diskio_bytesread as *const _ as usize
        },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_diskio_bytesread)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v3>())).ri_diskio_byteswritten as *const _ as usize
        },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_diskio_byteswritten)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v3>())).ri_cpu_time_qos_default as *const _ as usize
        },
        160usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_cpu_time_qos_default)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v3>())).ri_cpu_time_qos_maintenance as *const _
                as usize
        },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_cpu_time_qos_maintenance)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v3>())).ri_cpu_time_qos_background as *const _
                as usize
        },
        176usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_cpu_time_qos_background)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v3>())).ri_cpu_time_qos_utility as *const _ as usize
        },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_cpu_time_qos_utility)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v3>())).ri_cpu_time_qos_legacy as *const _ as usize
        },
        192usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_cpu_time_qos_legacy)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v3>())).ri_cpu_time_qos_user_initiated as *const _
                as usize
        },
        200usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_cpu_time_qos_user_initiated)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v3>())).ri_cpu_time_qos_user_interactive as *const _
                as usize
        },
        208usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_cpu_time_qos_user_interactive)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v3>())).ri_billed_system_time as *const _ as usize
        },
        216usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_billed_system_time)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v3>())).ri_serviced_system_time as *const _ as usize
        },
        224usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_serviced_system_time)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rusage_info_v4 {
    pub ri_uuid: [u8; 16usize],
    pub ri_user_time: u64,
    pub ri_system_time: u64,
    pub ri_pkg_idle_wkups: u64,
    pub ri_interrupt_wkups: u64,
    pub ri_pageins: u64,
    pub ri_wired_size: u64,
    pub ri_resident_size: u64,
    pub ri_phys_footprint: u64,
    pub ri_proc_start_abstime: u64,
    pub ri_proc_exit_abstime: u64,
    pub ri_child_user_time: u64,
    pub ri_child_system_time: u64,
    pub ri_child_pkg_idle_wkups: u64,
    pub ri_child_interrupt_wkups: u64,
    pub ri_child_pageins: u64,
    pub ri_child_elapsed_abstime: u64,
    pub ri_diskio_bytesread: u64,
    pub ri_diskio_byteswritten: u64,
    pub ri_cpu_time_qos_default: u64,
    pub ri_cpu_time_qos_maintenance: u64,
    pub ri_cpu_time_qos_background: u64,
    pub ri_cpu_time_qos_utility: u64,
    pub ri_cpu_time_qos_legacy: u64,
    pub ri_cpu_time_qos_user_initiated: u64,
    pub ri_cpu_time_qos_user_interactive: u64,
    pub ri_billed_system_time: u64,
    pub ri_serviced_system_time: u64,
    pub ri_logical_writes: u64,
    pub ri_lifetime_max_phys_footprint: u64,
    pub ri_instructions: u64,
    pub ri_cycles: u64,
    pub ri_billed_energy: u64,
    pub ri_serviced_energy: u64,
    pub ri_interval_max_phys_footprint: u64,
    pub ri_runnable_time: u64,
}
#[test]
fn bindgen_test_layout_rusage_info_v4() {
    assert_eq!(
        ::std::mem::size_of::<rusage_info_v4>(),
        296usize,
        concat!("Size of: ", stringify!(rusage_info_v4))
    );
    assert_eq!(
        ::std::mem::align_of::<rusage_info_v4>(),
        8usize,
        concat!("Alignment of ", stringify!(rusage_info_v4))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v4>())).ri_uuid as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_uuid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v4>())).ri_user_time as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_user_time)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v4>())).ri_system_time as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_system_time)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v4>())).ri_pkg_idle_wkups as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_pkg_idle_wkups)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v4>())).ri_interrupt_wkups as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_interrupt_wkups)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v4>())).ri_pageins as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_pageins)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v4>())).ri_wired_size as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_wired_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v4>())).ri_resident_size as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_resident_size)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v4>())).ri_phys_footprint as *const _ as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_phys_footprint)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v4>())).ri_proc_start_abstime as *const _ as usize
        },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_proc_start_abstime)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v4>())).ri_proc_exit_abstime as *const _ as usize
        },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_proc_exit_abstime)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v4>())).ri_child_user_time as *const _ as usize
        },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_child_user_time)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v4>())).ri_child_system_time as *const _ as usize
        },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_child_system_time)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v4>())).ri_child_pkg_idle_wkups as *const _ as usize
        },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_child_pkg_idle_wkups)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v4>())).ri_child_interrupt_wkups as *const _ as usize
        },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_child_interrupt_wkups)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v4>())).ri_child_pageins as *const _ as usize },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_child_pageins)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v4>())).ri_child_elapsed_abstime as *const _ as usize
        },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_child_elapsed_abstime)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v4>())).ri_diskio_bytesread as *const _ as usize
        },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_diskio_bytesread)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v4>())).ri_diskio_byteswritten as *const _ as usize
        },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_diskio_byteswritten)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v4>())).ri_cpu_time_qos_default as *const _ as usize
        },
        160usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_cpu_time_qos_default)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v4>())).ri_cpu_time_qos_maintenance as *const _
                as usize
        },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_cpu_time_qos_maintenance)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v4>())).ri_cpu_time_qos_background as *const _
                as usize
        },
        176usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_cpu_time_qos_background)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v4>())).ri_cpu_time_qos_utility as *const _ as usize
        },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_cpu_time_qos_utility)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v4>())).ri_cpu_time_qos_legacy as *const _ as usize
        },
        192usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_cpu_time_qos_legacy)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v4>())).ri_cpu_time_qos_user_initiated as *const _
                as usize
        },
        200usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_cpu_time_qos_user_initiated)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v4>())).ri_cpu_time_qos_user_interactive as *const _
                as usize
        },
        208usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_cpu_time_qos_user_interactive)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v4>())).ri_billed_system_time as *const _ as usize
        },
        216usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_billed_system_time)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v4>())).ri_serviced_system_time as *const _ as usize
        },
        224usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_serviced_system_time)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v4>())).ri_logical_writes as *const _ as usize
        },
        232usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_logical_writes)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v4>())).ri_lifetime_max_phys_footprint as *const _
                as usize
        },
        240usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_lifetime_max_phys_footprint)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v4>())).ri_instructions as *const _ as usize },
        248usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_instructions)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v4>())).ri_cycles as *const _ as usize },
        256usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_cycles)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v4>())).ri_billed_energy as *const _ as usize },
        264usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_billed_energy)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v4>())).ri_serviced_energy as *const _ as usize
        },
        272usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_serviced_energy)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v4>())).ri_interval_max_phys_footprint as *const _
                as usize
        },
        280usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_interval_max_phys_footprint)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v4>())).ri_runnable_time as *const _ as usize },
        288usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_runnable_time)
        )
    );
}
pub type rusage_info_current = rusage_info_v4;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rlimit {
    pub rlim_cur: rlim_t,
    pub rlim_max: rlim_t,
}
#[test]
fn bindgen_test_layout_rlimit() {
    assert_eq!(
        ::std::mem::size_of::<rlimit>(),
        16usize,
        concat!("Size of: ", stringify!(rlimit))
    );
    assert_eq!(
        ::std::mem::align_of::<rlimit>(),
        8usize,
        concat!("Alignment of ", stringify!(rlimit))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rlimit>())).rlim_cur as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(rlimit),
            "::",
            stringify!(rlim_cur)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rlimit>())).rlim_max as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(rlimit),
            "::",
            stringify!(rlim_max)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct proc_rlimit_control_wakeupmon {
    pub wm_flags: u32,
    pub wm_rate: i32,
}
#[test]
fn bindgen_test_layout_proc_rlimit_control_wakeupmon() {
    assert_eq!(
        ::std::mem::size_of::<proc_rlimit_control_wakeupmon>(),
        8usize,
        concat!("Size of: ", stringify!(proc_rlimit_control_wakeupmon))
    );
    assert_eq!(
        ::std::mem::align_of::<proc_rlimit_control_wakeupmon>(),
        4usize,
        concat!("Alignment of ", stringify!(proc_rlimit_control_wakeupmon))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<proc_rlimit_control_wakeupmon>())).wm_flags as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(proc_rlimit_control_wakeupmon),
            "::",
            stringify!(wm_flags)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<proc_rlimit_control_wakeupmon>())).wm_rate as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(proc_rlimit_control_wakeupmon),
            "::",
            stringify!(wm_rate)
        )
    );
}
extern "C" {
    pub fn getpriority(arg1: ::std::os::raw::c_int, arg2: id_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getiopolicy_np(
        arg1: ::std::os::raw::c_int,
        arg2: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getrlimit(arg1: ::std::os::raw::c_int, arg2: *mut rlimit) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getrusage(arg1: ::std::os::raw::c_int, arg2: *mut rusage) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn setpriority(
        arg1: ::std::os::raw::c_int,
        arg2: id_t,
        arg3: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn setiopolicy_np(
        arg1: ::std::os::raw::c_int,
        arg2: ::std::os::raw::c_int,
        arg3: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn setrlimit(arg1: ::std::os::raw::c_int, arg2: *const rlimit) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union wait {
    pub w_status: ::std::os::raw::c_int,
    pub w_T: wait__bindgen_ty_1,
    pub w_S: wait__bindgen_ty_2,
    _bindgen_union_align: u32,
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Copy, Clone)]
pub struct wait__bindgen_ty_1 {
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize], u16>,
}
#[test]
fn bindgen_test_layout_wait__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<wait__bindgen_ty_1>(),
        4usize,
        concat!("Size of: ", stringify!(wait__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<wait__bindgen_ty_1>(),
        4usize,
        concat!("Alignment of ", stringify!(wait__bindgen_ty_1))
    );
}
impl wait__bindgen_ty_1 {
    #[inline]
    pub fn w_Termsig(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 7u8) as u32) }
    }
    #[inline]
    pub fn set_w_Termsig(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 7u8, val as u64)
        }
    }
    #[inline]
    pub fn w_Coredump(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(7usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_w_Coredump(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(7usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn w_Retcode(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(8usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_w_Retcode(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(8usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn w_Filler(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(16usize, 16u8) as u32) }
    }
    #[inline]
    pub fn set_w_Filler(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(16usize, 16u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        w_Termsig: ::std::os::raw::c_uint,
        w_Coredump: ::std::os::raw::c_uint,
        w_Retcode: ::std::os::raw::c_uint,
        w_Filler: ::std::os::raw::c_uint,
    ) -> __BindgenBitfieldUnit<[u8; 4usize], u16> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize], u16> =
            Default::default();
        __bindgen_bitfield_unit.set(0usize, 7u8, {
            let w_Termsig: u32 = unsafe { ::std::mem::transmute(w_Termsig) };
            w_Termsig as u64
        });
        __bindgen_bitfield_unit.set(7usize, 1u8, {
            let w_Coredump: u32 = unsafe { ::std::mem::transmute(w_Coredump) };
            w_Coredump as u64
        });
        __bindgen_bitfield_unit.set(8usize, 8u8, {
            let w_Retcode: u32 = unsafe { ::std::mem::transmute(w_Retcode) };
            w_Retcode as u64
        });
        __bindgen_bitfield_unit.set(16usize, 16u8, {
            let w_Filler: u32 = unsafe { ::std::mem::transmute(w_Filler) };
            w_Filler as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Copy, Clone)]
pub struct wait__bindgen_ty_2 {
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize], u16>,
}
#[test]
fn bindgen_test_layout_wait__bindgen_ty_2() {
    assert_eq!(
        ::std::mem::size_of::<wait__bindgen_ty_2>(),
        4usize,
        concat!("Size of: ", stringify!(wait__bindgen_ty_2))
    );
    assert_eq!(
        ::std::mem::align_of::<wait__bindgen_ty_2>(),
        4usize,
        concat!("Alignment of ", stringify!(wait__bindgen_ty_2))
    );
}
impl wait__bindgen_ty_2 {
    #[inline]
    pub fn w_Stopval(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_w_Stopval(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn w_Stopsig(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(8usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_w_Stopsig(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(8usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn w_Filler(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(16usize, 16u8) as u32) }
    }
    #[inline]
    pub fn set_w_Filler(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(16usize, 16u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        w_Stopval: ::std::os::raw::c_uint,
        w_Stopsig: ::std::os::raw::c_uint,
        w_Filler: ::std::os::raw::c_uint,
    ) -> __BindgenBitfieldUnit<[u8; 4usize], u16> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize], u16> =
            Default::default();
        __bindgen_bitfield_unit.set(0usize, 8u8, {
            let w_Stopval: u32 = unsafe { ::std::mem::transmute(w_Stopval) };
            w_Stopval as u64
        });
        __bindgen_bitfield_unit.set(8usize, 8u8, {
            let w_Stopsig: u32 = unsafe { ::std::mem::transmute(w_Stopsig) };
            w_Stopsig as u64
        });
        __bindgen_bitfield_unit.set(16usize, 16u8, {
            let w_Filler: u32 = unsafe { ::std::mem::transmute(w_Filler) };
            w_Filler as u64
        });
        __bindgen_bitfield_unit
    }
}
#[test]
fn bindgen_test_layout_wait() {
    assert_eq!(
        ::std::mem::size_of::<wait>(),
        4usize,
        concat!("Size of: ", stringify!(wait))
    );
    assert_eq!(
        ::std::mem::align_of::<wait>(),
        4usize,
        concat!("Alignment of ", stringify!(wait))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<wait>())).w_status as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(wait),
            "::",
            stringify!(w_status)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<wait>())).w_T as *const _ as usize },
        0usize,
        concat!("Offset of field: ", stringify!(wait), "::", stringify!(w_T))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<wait>())).w_S as *const _ as usize },
        0usize,
        concat!("Offset of field: ", stringify!(wait), "::", stringify!(w_S))
    );
}
extern "C" {
    pub fn wait(arg1: *mut ::std::os::raw::c_int) -> pid_t;
}
extern "C" {
    pub fn waitpid(
        arg1: pid_t,
        arg2: *mut ::std::os::raw::c_int,
        arg3: ::std::os::raw::c_int,
    ) -> pid_t;
}
extern "C" {
    pub fn waitid(
        arg1: idtype_t,
        arg2: id_t,
        arg3: *mut siginfo_t,
        arg4: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn wait3(
        arg1: *mut ::std::os::raw::c_int,
        arg2: ::std::os::raw::c_int,
        arg3: *mut rusage,
    ) -> pid_t;
}
extern "C" {
    pub fn wait4(
        arg1: pid_t,
        arg2: *mut ::std::os::raw::c_int,
        arg3: ::std::os::raw::c_int,
        arg4: *mut rusage,
    ) -> pid_t;
}
extern "C" {
    pub fn alloca(arg1: ::std::os::raw::c_ulong) -> *mut ::std::os::raw::c_void;
}
pub type ct_rune_t = __darwin_ct_rune_t;
pub type rune_t = __darwin_rune_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct div_t {
    pub quot: ::std::os::raw::c_int,
    pub rem: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_div_t() {
    assert_eq!(
        ::std::mem::size_of::<div_t>(),
        8usize,
        concat!("Size of: ", stringify!(div_t))
    );
    assert_eq!(
        ::std::mem::align_of::<div_t>(),
        4usize,
        concat!("Alignment of ", stringify!(div_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<div_t>())).quot as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(div_t),
            "::",
            stringify!(quot)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<div_t>())).rem as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(div_t),
            "::",
            stringify!(rem)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ldiv_t {
    pub quot: ::std::os::raw::c_long,
    pub rem: ::std::os::raw::c_long,
}
#[test]
fn bindgen_test_layout_ldiv_t() {
    assert_eq!(
        ::std::mem::size_of::<ldiv_t>(),
        16usize,
        concat!("Size of: ", stringify!(ldiv_t))
    );
    assert_eq!(
        ::std::mem::align_of::<ldiv_t>(),
        8usize,
        concat!("Alignment of ", stringify!(ldiv_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ldiv_t>())).quot as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(ldiv_t),
            "::",
            stringify!(quot)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ldiv_t>())).rem as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(ldiv_t),
            "::",
            stringify!(rem)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct lldiv_t {
    pub quot: ::std::os::raw::c_longlong,
    pub rem: ::std::os::raw::c_longlong,
}
#[test]
fn bindgen_test_layout_lldiv_t() {
    assert_eq!(
        ::std::mem::size_of::<lldiv_t>(),
        16usize,
        concat!("Size of: ", stringify!(lldiv_t))
    );
    assert_eq!(
        ::std::mem::align_of::<lldiv_t>(),
        8usize,
        concat!("Alignment of ", stringify!(lldiv_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<lldiv_t>())).quot as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lldiv_t),
            "::",
            stringify!(quot)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<lldiv_t>())).rem as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(lldiv_t),
            "::",
            stringify!(rem)
        )
    );
}
extern "C" {
    pub static mut __mb_cur_max: ::std::os::raw::c_int;
}
extern "C" {
    pub fn malloc(__size: ::std::os::raw::c_ulong) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn calloc(
        __count: ::std::os::raw::c_ulong,
        __size: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn free(arg1: *mut ::std::os::raw::c_void);
}
extern "C" {
    pub fn realloc(
        __ptr: *mut ::std::os::raw::c_void,
        __size: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn valloc(arg1: size_t) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn aligned_alloc(__alignment: size_t, __size: size_t) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn posix_memalign(
        __memptr: *mut *mut ::std::os::raw::c_void,
        __alignment: size_t,
        __size: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn abort();
}
extern "C" {
    pub fn abs(arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn atexit(arg1: ::std::option::Option<unsafe extern "C" fn()>) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn atof(arg1: *const ::std::os::raw::c_char) -> f64;
}
extern "C" {
    pub fn atoi(arg1: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn atol(arg1: *const ::std::os::raw::c_char) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn atoll(arg1: *const ::std::os::raw::c_char) -> ::std::os::raw::c_longlong;
}
extern "C" {
    pub fn bsearch(
        __key: *const ::std::os::raw::c_void,
        __base: *const ::std::os::raw::c_void,
        __nel: size_t,
        __width: size_t,
        __compar: ::std::option::Option<
            unsafe extern "C" fn(
                arg1: *const ::std::os::raw::c_void,
                arg2: *const ::std::os::raw::c_void,
            ) -> ::std::os::raw::c_int,
        >,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn div(arg1: ::std::os::raw::c_int, arg2: ::std::os::raw::c_int) -> div_t;
}
extern "C" {
    pub fn exit(arg1: ::std::os::raw::c_int);
}
extern "C" {
    pub fn getenv(arg1: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn labs(arg1: ::std::os::raw::c_long) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn ldiv(arg1: ::std::os::raw::c_long, arg2: ::std::os::raw::c_long) -> ldiv_t;
}
extern "C" {
    pub fn llabs(arg1: ::std::os::raw::c_longlong) -> ::std::os::raw::c_longlong;
}
extern "C" {
    pub fn lldiv(arg1: ::std::os::raw::c_longlong, arg2: ::std::os::raw::c_longlong) -> lldiv_t;
}
extern "C" {
    pub fn mblen(__s: *const ::std::os::raw::c_char, __n: size_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mbstowcs(
        arg1: *mut wchar_t,
        arg2: *const ::std::os::raw::c_char,
        arg3: size_t,
    ) -> size_t;
}
extern "C" {
    pub fn mbtowc(
        arg1: *mut wchar_t,
        arg2: *const ::std::os::raw::c_char,
        arg3: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn qsort(
        __base: *mut ::std::os::raw::c_void,
        __nel: size_t,
        __width: size_t,
        __compar: ::std::option::Option<
            unsafe extern "C" fn(
                arg1: *const ::std::os::raw::c_void,
                arg2: *const ::std::os::raw::c_void,
            ) -> ::std::os::raw::c_int,
        >,
    );
}
extern "C" {
    pub fn rand() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn srand(arg1: ::std::os::raw::c_uint);
}
extern "C" {
    pub fn strtod(
        arg1: *const ::std::os::raw::c_char,
        arg2: *mut *mut ::std::os::raw::c_char,
    ) -> f64;
}
extern "C" {
    pub fn strtof(
        arg1: *const ::std::os::raw::c_char,
        arg2: *mut *mut ::std::os::raw::c_char,
    ) -> f32;
}
extern "C" {
    pub fn strtol(
        __str: *const ::std::os::raw::c_char,
        __endptr: *mut *mut ::std::os::raw::c_char,
        __base: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn strtoll(
        __str: *const ::std::os::raw::c_char,
        __endptr: *mut *mut ::std::os::raw::c_char,
        __base: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_longlong;
}
extern "C" {
    pub fn strtoul(
        __str: *const ::std::os::raw::c_char,
        __endptr: *mut *mut ::std::os::raw::c_char,
        __base: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_ulong;
}
extern "C" {
    pub fn strtoull(
        __str: *const ::std::os::raw::c_char,
        __endptr: *mut *mut ::std::os::raw::c_char,
        __base: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_ulonglong;
}
extern "C" {
    pub fn system(arg1: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn wcstombs(
        arg1: *mut ::std::os::raw::c_char,
        arg2: *const wchar_t,
        arg3: size_t,
    ) -> size_t;
}
extern "C" {
    pub fn wctomb(arg1: *mut ::std::os::raw::c_char, arg2: wchar_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _Exit(arg1: ::std::os::raw::c_int);
}
extern "C" {
    pub fn a64l(arg1: *const ::std::os::raw::c_char) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn drand48() -> f64;
}
extern "C" {
    pub fn ecvt(
        arg1: f64,
        arg2: ::std::os::raw::c_int,
        arg3: *mut ::std::os::raw::c_int,
        arg4: *mut ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn erand48(arg1: *mut ::std::os::raw::c_ushort) -> f64;
}
extern "C" {
    pub fn fcvt(
        arg1: f64,
        arg2: ::std::os::raw::c_int,
        arg3: *mut ::std::os::raw::c_int,
        arg4: *mut ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn gcvt(
        arg1: f64,
        arg2: ::std::os::raw::c_int,
        arg3: *mut ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn getsubopt(
        arg1: *mut *mut ::std::os::raw::c_char,
        arg2: *const *mut ::std::os::raw::c_char,
        arg3: *mut *mut ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn grantpt(arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn initstate(
        arg1: ::std::os::raw::c_uint,
        arg2: *mut ::std::os::raw::c_char,
        arg3: size_t,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn jrand48(arg1: *mut ::std::os::raw::c_ushort) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn l64a(arg1: ::std::os::raw::c_long) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn lcong48(arg1: *mut ::std::os::raw::c_ushort);
}
extern "C" {
    pub fn lrand48() -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn mktemp(arg1: *mut ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn mkstemp(arg1: *mut ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mrand48() -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn nrand48(arg1: *mut ::std::os::raw::c_ushort) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn posix_openpt(arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ptsname(arg1: ::std::os::raw::c_int) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn ptsname_r(
        fildes: ::std::os::raw::c_int,
        buffer: *mut ::std::os::raw::c_char,
        buflen: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn putenv(arg1: *mut ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn random() -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn rand_r(arg1: *mut ::std::os::raw::c_uint) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}_realpath$DARWIN_EXTSN"]
    pub fn realpath(
        arg1: *const ::std::os::raw::c_char,
        arg2: *mut ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn seed48(arg1: *mut ::std::os::raw::c_ushort) -> *mut ::std::os::raw::c_ushort;
}
extern "C" {
    pub fn setenv(
        __name: *const ::std::os::raw::c_char,
        __value: *const ::std::os::raw::c_char,
        __overwrite: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn setkey(arg1: *const ::std::os::raw::c_char);
}
extern "C" {
    pub fn setstate(arg1: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn srand48(arg1: ::std::os::raw::c_long);
}
extern "C" {
    pub fn srandom(arg1: ::std::os::raw::c_uint);
}
extern "C" {
    pub fn unlockpt(arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn unsetenv(arg1: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
pub type dev_t = __darwin_dev_t;
pub type mode_t = __darwin_mode_t;
extern "C" {
    pub fn arc4random() -> u32;
}
extern "C" {
    pub fn arc4random_addrandom(arg1: *mut ::std::os::raw::c_uchar, arg2: ::std::os::raw::c_int);
}
extern "C" {
    pub fn arc4random_buf(__buf: *mut ::std::os::raw::c_void, __nbytes: size_t);
}
extern "C" {
    pub fn arc4random_stir();
}
extern "C" {
    pub fn arc4random_uniform(__upper_bound: u32) -> u32;
}
extern "C" {
    pub fn atexit_b(arg1: *mut ::std::os::raw::c_void) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bsearch_b(
        __key: *const ::std::os::raw::c_void,
        __base: *const ::std::os::raw::c_void,
        __nel: size_t,
        __width: size_t,
        __compar: *mut ::std::os::raw::c_void,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn cgetcap(
        arg1: *mut ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
        arg3: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn cgetclose() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn cgetent(
        arg1: *mut *mut ::std::os::raw::c_char,
        arg2: *mut *mut ::std::os::raw::c_char,
        arg3: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn cgetfirst(
        arg1: *mut *mut ::std::os::raw::c_char,
        arg2: *mut *mut ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn cgetmatch(
        arg1: *const ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn cgetnext(
        arg1: *mut *mut ::std::os::raw::c_char,
        arg2: *mut *mut ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn cgetnum(
        arg1: *mut ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
        arg3: *mut ::std::os::raw::c_long,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn cgetset(arg1: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn cgetstr(
        arg1: *mut ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
        arg3: *mut *mut ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn cgetustr(
        arg1: *mut ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
        arg3: *mut *mut ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}_daemon$1050"]
    pub fn daemon(
        arg1: ::std::os::raw::c_int,
        arg2: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn devname(arg1: dev_t, arg2: mode_t) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn devname_r(
        arg1: dev_t,
        arg2: mode_t,
        buf: *mut ::std::os::raw::c_char,
        len: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn getbsize(
        arg1: *mut ::std::os::raw::c_int,
        arg2: *mut ::std::os::raw::c_long,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn getloadavg(arg1: *mut f64, arg2: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getprogname() -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn setprogname(arg1: *const ::std::os::raw::c_char);
}
extern "C" {
    pub fn heapsort(
        __base: *mut ::std::os::raw::c_void,
        __nel: size_t,
        __width: size_t,
        __compar: ::std::option::Option<
            unsafe extern "C" fn(
                arg1: *const ::std::os::raw::c_void,
                arg2: *const ::std::os::raw::c_void,
            ) -> ::std::os::raw::c_int,
        >,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn heapsort_b(
        __base: *mut ::std::os::raw::c_void,
        __nel: size_t,
        __width: size_t,
        __compar: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mergesort(
        __base: *mut ::std::os::raw::c_void,
        __nel: size_t,
        __width: size_t,
        __compar: ::std::option::Option<
            unsafe extern "C" fn(
                arg1: *const ::std::os::raw::c_void,
                arg2: *const ::std::os::raw::c_void,
            ) -> ::std::os::raw::c_int,
        >,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mergesort_b(
        __base: *mut ::std::os::raw::c_void,
        __nel: size_t,
        __width: size_t,
        __compar: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn psort(
        __base: *mut ::std::os::raw::c_void,
        __nel: size_t,
        __width: size_t,
        __compar: ::std::option::Option<
            unsafe extern "C" fn(
                arg1: *const ::std::os::raw::c_void,
                arg2: *const ::std::os::raw::c_void,
            ) -> ::std::os::raw::c_int,
        >,
    );
}
extern "C" {
    pub fn psort_b(
        __base: *mut ::std::os::raw::c_void,
        __nel: size_t,
        __width: size_t,
        __compar: *mut ::std::os::raw::c_void,
    );
}
extern "C" {
    pub fn psort_r(
        __base: *mut ::std::os::raw::c_void,
        __nel: size_t,
        __width: size_t,
        arg1: *mut ::std::os::raw::c_void,
        __compar: ::std::option::Option<
            unsafe extern "C" fn(
                arg1: *mut ::std::os::raw::c_void,
                arg2: *const ::std::os::raw::c_void,
                arg3: *const ::std::os::raw::c_void,
            ) -> ::std::os::raw::c_int,
        >,
    );
}
extern "C" {
    pub fn qsort_b(
        __base: *mut ::std::os::raw::c_void,
        __nel: size_t,
        __width: size_t,
        __compar: *mut ::std::os::raw::c_void,
    );
}
extern "C" {
    pub fn qsort_r(
        __base: *mut ::std::os::raw::c_void,
        __nel: size_t,
        __width: size_t,
        arg1: *mut ::std::os::raw::c_void,
        __compar: ::std::option::Option<
            unsafe extern "C" fn(
                arg1: *mut ::std::os::raw::c_void,
                arg2: *const ::std::os::raw::c_void,
                arg3: *const ::std::os::raw::c_void,
            ) -> ::std::os::raw::c_int,
        >,
    );
}
extern "C" {
    pub fn radixsort(
        __base: *mut *const ::std::os::raw::c_uchar,
        __nel: ::std::os::raw::c_int,
        __table: *const ::std::os::raw::c_uchar,
        __endbyte: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rpmatch(arg1: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sradixsort(
        __base: *mut *const ::std::os::raw::c_uchar,
        __nel: ::std::os::raw::c_int,
        __table: *const ::std::os::raw::c_uchar,
        __endbyte: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sranddev();
}
extern "C" {
    pub fn srandomdev();
}
extern "C" {
    pub fn reallocf(
        __ptr: *mut ::std::os::raw::c_void,
        __size: size_t,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn strtoq(
        __str: *const ::std::os::raw::c_char,
        __endptr: *mut *mut ::std::os::raw::c_char,
        __base: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_longlong;
}
extern "C" {
    pub fn strtouq(
        __str: *const ::std::os::raw::c_char,
        __endptr: *mut *mut ::std::os::raw::c_char,
        __base: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_ulonglong;
}
extern "C" {
    pub static mut suboptarg: *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn memchr(
        __s: *const ::std::os::raw::c_void,
        __c: ::std::os::raw::c_int,
        __n: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn memcmp(
        __s1: *const ::std::os::raw::c_void,
        __s2: *const ::std::os::raw::c_void,
        __n: ::std::os::raw::c_ulong,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn memcpy(
        __dst: *mut ::std::os::raw::c_void,
        __src: *const ::std::os::raw::c_void,
        __n: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn memmove(
        __dst: *mut ::std::os::raw::c_void,
        __src: *const ::std::os::raw::c_void,
        __len: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn memset(
        __b: *mut ::std::os::raw::c_void,
        __c: ::std::os::raw::c_int,
        __len: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn strcat(
        __s1: *mut ::std::os::raw::c_char,
        __s2: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strchr(
        __s: *const ::std::os::raw::c_char,
        __c: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strcmp(
        __s1: *const ::std::os::raw::c_char,
        __s2: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn strcoll(
        __s1: *const ::std::os::raw::c_char,
        __s2: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn strcpy(
        __dst: *mut ::std::os::raw::c_char,
        __src: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strcspn(
        __s: *const ::std::os::raw::c_char,
        __charset: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_ulong;
}
extern "C" {
    pub fn strerror(__errnum: ::std::os::raw::c_int) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strlen(__s: *const ::std::os::raw::c_char) -> ::std::os::raw::c_ulong;
}
extern "C" {
    pub fn strncat(
        __s1: *mut ::std::os::raw::c_char,
        __s2: *const ::std::os::raw::c_char,
        __n: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strncmp(
        __s1: *const ::std::os::raw::c_char,
        __s2: *const ::std::os::raw::c_char,
        __n: ::std::os::raw::c_ulong,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn strncpy(
        __dst: *mut ::std::os::raw::c_char,
        __src: *const ::std::os::raw::c_char,
        __n: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strpbrk(
        __s: *const ::std::os::raw::c_char,
        __charset: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strrchr(
        __s: *const ::std::os::raw::c_char,
        __c: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strspn(
        __s: *const ::std::os::raw::c_char,
        __charset: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_ulong;
}
extern "C" {
    pub fn strstr(
        __big: *const ::std::os::raw::c_char,
        __little: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strtok(
        __str: *mut ::std::os::raw::c_char,
        __sep: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strxfrm(
        __s1: *mut ::std::os::raw::c_char,
        __s2: *const ::std::os::raw::c_char,
        __n: ::std::os::raw::c_ulong,
    ) -> ::std::os::raw::c_ulong;
}
extern "C" {
    pub fn strtok_r(
        __str: *mut ::std::os::raw::c_char,
        __sep: *const ::std::os::raw::c_char,
        __lasts: *mut *mut ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strerror_r(
        __errnum: ::std::os::raw::c_int,
        __strerrbuf: *mut ::std::os::raw::c_char,
        __buflen: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn strdup(__s1: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn memccpy(
        __dst: *mut ::std::os::raw::c_void,
        __src: *const ::std::os::raw::c_void,
        __c: ::std::os::raw::c_int,
        __n: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn stpcpy(
        __dst: *mut ::std::os::raw::c_char,
        __src: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn stpncpy(
        __dst: *mut ::std::os::raw::c_char,
        __src: *const ::std::os::raw::c_char,
        __n: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strndup(
        __s1: *const ::std::os::raw::c_char,
        __n: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strnlen(__s1: *const ::std::os::raw::c_char, __n: size_t) -> size_t;
}
extern "C" {
    pub fn strsignal(__sig: ::std::os::raw::c_int) -> *mut ::std::os::raw::c_char;
}
pub type rsize_t = __darwin_size_t;
pub type errno_t = ::std::os::raw::c_int;
extern "C" {
    pub fn memset_s(
        __s: *mut ::std::os::raw::c_void,
        __smax: rsize_t,
        __c: ::std::os::raw::c_int,
        __n: rsize_t,
    ) -> errno_t;
}
pub type ssize_t = __darwin_ssize_t;
extern "C" {
    pub fn memmem(
        __big: *const ::std::os::raw::c_void,
        __big_len: size_t,
        __little: *const ::std::os::raw::c_void,
        __little_len: size_t,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn memset_pattern4(
        __b: *mut ::std::os::raw::c_void,
        __pattern4: *const ::std::os::raw::c_void,
        __len: size_t,
    );
}
extern "C" {
    pub fn memset_pattern8(
        __b: *mut ::std::os::raw::c_void,
        __pattern8: *const ::std::os::raw::c_void,
        __len: size_t,
    );
}
extern "C" {
    pub fn memset_pattern16(
        __b: *mut ::std::os::raw::c_void,
        __pattern16: *const ::std::os::raw::c_void,
        __len: size_t,
    );
}
extern "C" {
    pub fn strcasestr(
        __big: *const ::std::os::raw::c_char,
        __little: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strnstr(
        __big: *const ::std::os::raw::c_char,
        __little: *const ::std::os::raw::c_char,
        __len: size_t,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strlcat(
        __dst: *mut ::std::os::raw::c_char,
        __source: *const ::std::os::raw::c_char,
        __size: ::std::os::raw::c_ulong,
    ) -> ::std::os::raw::c_ulong;
}
extern "C" {
    pub fn strlcpy(
        __dst: *mut ::std::os::raw::c_char,
        __source: *const ::std::os::raw::c_char,
        __size: ::std::os::raw::c_ulong,
    ) -> ::std::os::raw::c_ulong;
}
extern "C" {
    pub fn strmode(__mode: ::std::os::raw::c_int, __bp: *mut ::std::os::raw::c_char);
}
extern "C" {
    pub fn strsep(
        __stringp: *mut *mut ::std::os::raw::c_char,
        __delim: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn swab(
        arg1: *const ::std::os::raw::c_void,
        arg2: *mut ::std::os::raw::c_void,
        arg3: ssize_t,
    );
}
extern "C" {
    pub fn timingsafe_bcmp(
        __b1: *const ::std::os::raw::c_void,
        __b2: *const ::std::os::raw::c_void,
        __len: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcmp(
        arg1: *const ::std::os::raw::c_void,
        arg2: *const ::std::os::raw::c_void,
        arg3: ::std::os::raw::c_ulong,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcopy(
        arg1: *const ::std::os::raw::c_void,
        arg2: *mut ::std::os::raw::c_void,
        arg3: size_t,
    );
}
extern "C" {
    pub fn bzero(arg1: *mut ::std::os::raw::c_void, arg2: ::std::os::raw::c_ulong);
}
extern "C" {
    pub fn index(
        arg1: *const ::std::os::raw::c_char,
        arg2: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn rindex(
        arg1: *const ::std::os::raw::c_char,
        arg2: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn ffs(arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn strcasecmp(
        arg1: *const ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn strncasecmp(
        arg1: *const ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
        arg3: ::std::os::raw::c_ulong,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ffsl(arg1: ::std::os::raw::c_long) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ffsll(arg1: ::std::os::raw::c_longlong) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fls(arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn flsl(arg1: ::std::os::raw::c_long) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn flsll(arg1: ::std::os::raw::c_longlong) -> ::std::os::raw::c_int;
}
pub type va_list = __builtin_va_list;
pub type __gnuc_va_list = __builtin_va_list;
extern "C" {
    pub fn renameat(
        arg1: ::std::os::raw::c_int,
        arg2: *const ::std::os::raw::c_char,
        arg3: ::std::os::raw::c_int,
        arg4: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn renamex_np(
        arg1: *const ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
        arg3: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn renameatx_np(
        arg1: ::std::os::raw::c_int,
        arg2: *const ::std::os::raw::c_char,
        arg3: ::std::os::raw::c_int,
        arg4: *const ::std::os::raw::c_char,
        arg5: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
pub type fpos_t = __darwin_off_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __sbuf {
    pub _base: *mut ::std::os::raw::c_uchar,
    pub _size: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout___sbuf() {
    assert_eq!(
        ::std::mem::size_of::<__sbuf>(),
        16usize,
        concat!("Size of: ", stringify!(__sbuf))
    );
    assert_eq!(
        ::std::mem::align_of::<__sbuf>(),
        8usize,
        concat!("Alignment of ", stringify!(__sbuf))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sbuf>()))._base as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__sbuf),
            "::",
            stringify!(_base)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sbuf>()))._size as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__sbuf),
            "::",
            stringify!(_size)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __sFILEX {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __sFILE {
    pub _p: *mut ::std::os::raw::c_uchar,
    pub _r: ::std::os::raw::c_int,
    pub _w: ::std::os::raw::c_int,
    pub _flags: ::std::os::raw::c_short,
    pub _file: ::std::os::raw::c_short,
    pub _bf: __sbuf,
    pub _lbfsize: ::std::os::raw::c_int,
    pub _cookie: *mut ::std::os::raw::c_void,
    pub _close: ::std::option::Option<
        unsafe extern "C" fn(arg1: *mut ::std::os::raw::c_void) -> ::std::os::raw::c_int,
    >,
    pub _read: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *mut ::std::os::raw::c_void,
            arg2: *mut ::std::os::raw::c_char,
            arg3: ::std::os::raw::c_int,
        ) -> ::std::os::raw::c_int,
    >,
    pub _seek: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *mut ::std::os::raw::c_void,
            arg2: fpos_t,
            arg3: ::std::os::raw::c_int,
        ) -> fpos_t,
    >,
    pub _write: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *mut ::std::os::raw::c_void,
            arg2: *const ::std::os::raw::c_char,
            arg3: ::std::os::raw::c_int,
        ) -> ::std::os::raw::c_int,
    >,
    pub _ub: __sbuf,
    pub _extra: *mut __sFILEX,
    pub _ur: ::std::os::raw::c_int,
    pub _ubuf: [::std::os::raw::c_uchar; 3usize],
    pub _nbuf: [::std::os::raw::c_uchar; 1usize],
    pub _lb: __sbuf,
    pub _blksize: ::std::os::raw::c_int,
    pub _offset: fpos_t,
}
#[test]
fn bindgen_test_layout___sFILE() {
    assert_eq!(
        ::std::mem::size_of::<__sFILE>(),
        152usize,
        concat!("Size of: ", stringify!(__sFILE))
    );
    assert_eq!(
        ::std::mem::align_of::<__sFILE>(),
        8usize,
        concat!("Alignment of ", stringify!(__sFILE))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sFILE>()))._p as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__sFILE),
            "::",
            stringify!(_p)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sFILE>()))._r as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__sFILE),
            "::",
            stringify!(_r)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sFILE>()))._w as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(__sFILE),
            "::",
            stringify!(_w)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sFILE>()))._flags as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__sFILE),
            "::",
            stringify!(_flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sFILE>()))._file as *const _ as usize },
        18usize,
        concat!(
            "Offset of field: ",
            stringify!(__sFILE),
            "::",
            stringify!(_file)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sFILE>()))._bf as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__sFILE),
            "::",
            stringify!(_bf)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sFILE>()))._lbfsize as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(__sFILE),
            "::",
            stringify!(_lbfsize)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sFILE>()))._cookie as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(__sFILE),
            "::",
            stringify!(_cookie)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sFILE>()))._close as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(__sFILE),
            "::",
            stringify!(_close)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sFILE>()))._read as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(__sFILE),
            "::",
            stringify!(_read)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sFILE>()))._seek as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(__sFILE),
            "::",
            stringify!(_seek)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sFILE>()))._write as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(__sFILE),
            "::",
            stringify!(_write)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sFILE>()))._ub as *const _ as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(__sFILE),
            "::",
            stringify!(_ub)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sFILE>()))._extra as *const _ as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(__sFILE),
            "::",
            stringify!(_extra)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sFILE>()))._ur as *const _ as usize },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(__sFILE),
            "::",
            stringify!(_ur)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sFILE>()))._ubuf as *const _ as usize },
        116usize,
        concat!(
            "Offset of field: ",
            stringify!(__sFILE),
            "::",
            stringify!(_ubuf)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sFILE>()))._nbuf as *const _ as usize },
        119usize,
        concat!(
            "Offset of field: ",
            stringify!(__sFILE),
            "::",
            stringify!(_nbuf)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sFILE>()))._lb as *const _ as usize },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(__sFILE),
            "::",
            stringify!(_lb)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sFILE>()))._blksize as *const _ as usize },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(__sFILE),
            "::",
            stringify!(_blksize)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sFILE>()))._offset as *const _ as usize },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(__sFILE),
            "::",
            stringify!(_offset)
        )
    );
}
pub type FILE = __sFILE;
extern "C" {
    pub static mut __stdinp: *mut FILE;
}
extern "C" {
    pub static mut __stdoutp: *mut FILE;
}
extern "C" {
    pub static mut __stderrp: *mut FILE;
}
extern "C" {
    pub fn clearerr(arg1: *mut FILE);
}
extern "C" {
    pub fn fclose(arg1: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn feof(arg1: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ferror(arg1: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fflush(arg1: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fgetc(arg1: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fgetpos(arg1: *mut FILE, arg2: *mut fpos_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fgets(
        arg1: *mut ::std::os::raw::c_char,
        arg2: ::std::os::raw::c_int,
        arg3: *mut FILE,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn fopen(
        __filename: *const ::std::os::raw::c_char,
        __mode: *const ::std::os::raw::c_char,
    ) -> *mut FILE;
}
extern "C" {
    pub fn fprintf(
        arg1: *mut FILE,
        arg2: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fputc(arg1: ::std::os::raw::c_int, arg2: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fputs(arg1: *const ::std::os::raw::c_char, arg2: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fread(
        __ptr: *mut ::std::os::raw::c_void,
        __size: ::std::os::raw::c_ulong,
        __nitems: ::std::os::raw::c_ulong,
        __stream: *mut FILE,
    ) -> ::std::os::raw::c_ulong;
}
extern "C" {
    pub fn freopen(
        arg1: *const ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
        arg3: *mut FILE,
    ) -> *mut FILE;
}
extern "C" {
    pub fn fscanf(
        arg1: *mut FILE,
        arg2: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fseek(
        arg1: *mut FILE,
        arg2: ::std::os::raw::c_long,
        arg3: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fsetpos(arg1: *mut FILE, arg2: *const fpos_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ftell(arg1: *mut FILE) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn fwrite(
        __ptr: *const ::std::os::raw::c_void,
        __size: ::std::os::raw::c_ulong,
        __nitems: ::std::os::raw::c_ulong,
        __stream: *mut FILE,
    ) -> ::std::os::raw::c_ulong;
}
extern "C" {
    pub fn getc(arg1: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getchar() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn gets(arg1: *mut ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn perror(arg1: *const ::std::os::raw::c_char);
}
extern "C" {
    pub fn printf(arg1: *const ::std::os::raw::c_char, ...) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn putc(arg1: ::std::os::raw::c_int, arg2: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn putchar(arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn puts(arg1: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn remove(arg1: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rename(
        __old: *const ::std::os::raw::c_char,
        __new: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rewind(arg1: *mut FILE);
}
extern "C" {
    pub fn scanf(arg1: *const ::std::os::raw::c_char, ...) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn setbuf(arg1: *mut FILE, arg2: *mut ::std::os::raw::c_char);
}
extern "C" {
    pub fn setvbuf(
        arg1: *mut FILE,
        arg2: *mut ::std::os::raw::c_char,
        arg3: ::std::os::raw::c_int,
        arg4: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sprintf(
        arg1: *mut ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sscanf(
        arg1: *const ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn tmpfile() -> *mut FILE;
}
extern "C" {
    pub fn tmpnam(arg1: *mut ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn ungetc(arg1: ::std::os::raw::c_int, arg2: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn vfprintf(
        arg1: *mut FILE,
        arg2: *const ::std::os::raw::c_char,
        arg3: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn vprintf(
        arg1: *const ::std::os::raw::c_char,
        arg2: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn vsprintf(
        arg1: *mut ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
        arg3: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ctermid(arg1: *mut ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn fdopen(arg1: ::std::os::raw::c_int, arg2: *const ::std::os::raw::c_char) -> *mut FILE;
}
extern "C" {
    pub fn fileno(arg1: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pclose(arg1: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn popen(
        arg1: *const ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
    ) -> *mut FILE;
}
extern "C" {
    pub fn __srget(arg1: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __svfscanf(
        arg1: *mut FILE,
        arg2: *const ::std::os::raw::c_char,
        arg3: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __swbuf(arg1: ::std::os::raw::c_int, arg2: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn flockfile(arg1: *mut FILE);
}
extern "C" {
    pub fn ftrylockfile(arg1: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn funlockfile(arg1: *mut FILE);
}
extern "C" {
    pub fn getc_unlocked(arg1: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getchar_unlocked() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn putc_unlocked(arg1: ::std::os::raw::c_int, arg2: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn putchar_unlocked(arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getw(arg1: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn putw(arg1: ::std::os::raw::c_int, arg2: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn tempnam(
        __dir: *const ::std::os::raw::c_char,
        __prefix: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
pub type off_t = __darwin_off_t;
extern "C" {
    pub fn fseeko(
        __stream: *mut FILE,
        __offset: off_t,
        __whence: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ftello(__stream: *mut FILE) -> off_t;
}
extern "C" {
    pub fn snprintf(
        __str: *mut ::std::os::raw::c_char,
        __size: ::std::os::raw::c_ulong,
        __format: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn vfscanf(
        __stream: *mut FILE,
        __format: *const ::std::os::raw::c_char,
        arg1: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn vscanf(
        __format: *const ::std::os::raw::c_char,
        arg1: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn vsnprintf(
        __str: *mut ::std::os::raw::c_char,
        __size: ::std::os::raw::c_ulong,
        __format: *const ::std::os::raw::c_char,
        arg1: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn vsscanf(
        __str: *const ::std::os::raw::c_char,
        __format: *const ::std::os::raw::c_char,
        arg1: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn dprintf(
        arg1: ::std::os::raw::c_int,
        arg2: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn vdprintf(
        arg1: ::std::os::raw::c_int,
        arg2: *const ::std::os::raw::c_char,
        arg3: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getdelim(
        __linep: *mut *mut ::std::os::raw::c_char,
        __linecapp: *mut size_t,
        __delimiter: ::std::os::raw::c_int,
        __stream: *mut FILE,
    ) -> ssize_t;
}
extern "C" {
    pub fn getline(
        __linep: *mut *mut ::std::os::raw::c_char,
        __linecapp: *mut size_t,
        __stream: *mut FILE,
    ) -> ssize_t;
}
extern "C" {
    pub fn fmemopen(
        __buf: *mut ::std::os::raw::c_void,
        __size: size_t,
        __mode: *const ::std::os::raw::c_char,
    ) -> *mut FILE;
}
extern "C" {
    pub fn open_memstream(
        __bufp: *mut *mut ::std::os::raw::c_char,
        __sizep: *mut size_t,
    ) -> *mut FILE;
}
extern "C" {
    pub static sys_nerr: ::std::os::raw::c_int;
}
extern "C" {
    pub static mut sys_errlist: [*const ::std::os::raw::c_char; 0usize];
}
extern "C" {
    pub fn asprintf(
        arg1: *mut *mut ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ctermid_r(arg1: *mut ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn fgetln(arg1: *mut FILE, arg2: *mut size_t) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn fmtcheck(
        arg1: *const ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn fpurge(arg1: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn setbuffer(
        arg1: *mut FILE,
        arg2: *mut ::std::os::raw::c_char,
        arg3: ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn setlinebuf(arg1: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn vasprintf(
        arg1: *mut *mut ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
        arg3: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn zopen(
        arg1: *const ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
        arg3: ::std::os::raw::c_int,
    ) -> *mut FILE;
}
extern "C" {
    pub fn funopen(
        arg1: *const ::std::os::raw::c_void,
        arg2: ::std::option::Option<
            unsafe extern "C" fn(
                arg1: *mut ::std::os::raw::c_void,
                arg2: *mut ::std::os::raw::c_char,
                arg3: ::std::os::raw::c_int,
            ) -> ::std::os::raw::c_int,
        >,
        arg3: ::std::option::Option<
            unsafe extern "C" fn(
                arg1: *mut ::std::os::raw::c_void,
                arg2: *const ::std::os::raw::c_char,
                arg3: ::std::os::raw::c_int,
            ) -> ::std::os::raw::c_int,
        >,
        arg4: ::std::option::Option<
            unsafe extern "C" fn(
                arg1: *mut ::std::os::raw::c_void,
                arg2: fpos_t,
                arg3: ::std::os::raw::c_int,
            ) -> fpos_t,
        >,
        arg5: ::std::option::Option<
            unsafe extern "C" fn(arg1: *mut ::std::os::raw::c_void) -> ::std::os::raw::c_int,
        >,
    ) -> *mut FILE;
}
extern "C" {
    pub fn __sprintf_chk(
        arg1: *mut ::std::os::raw::c_char,
        arg2: ::std::os::raw::c_int,
        arg3: size_t,
        arg4: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __snprintf_chk(
        arg1: *mut ::std::os::raw::c_char,
        arg2: size_t,
        arg3: ::std::os::raw::c_int,
        arg4: size_t,
        arg5: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __vsprintf_chk(
        arg1: *mut ::std::os::raw::c_char,
        arg2: ::std::os::raw::c_int,
        arg3: size_t,
        arg4: *const ::std::os::raw::c_char,
        arg5: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __vsnprintf_chk(
        arg1: *mut ::std::os::raw::c_char,
        arg2: size_t,
        arg3: ::std::os::raw::c_int,
        arg4: size_t,
        arg5: *const ::std::os::raw::c_char,
        arg6: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __error() -> *mut ::std::os::raw::c_int;
}
pub type u_char = ::std::os::raw::c_uchar;
pub type u_short = ::std::os::raw::c_ushort;
pub type u_int = ::std::os::raw::c_uint;
pub type u_long = ::std::os::raw::c_ulong;
pub type ushort = ::std::os::raw::c_ushort;
pub type uint = ::std::os::raw::c_uint;
pub type u_quad_t = u_int64_t;
pub type quad_t = i64;
pub type qaddr_t = *mut quad_t;
pub type caddr_t = *mut ::std::os::raw::c_char;
pub type daddr_t = i32;
pub type fixpt_t = u_int32_t;
pub type blkcnt_t = __darwin_blkcnt_t;
pub type blksize_t = __darwin_blksize_t;
pub type gid_t = __darwin_gid_t;
pub type in_addr_t = __uint32_t;
pub type in_port_t = __uint16_t;
pub type ino_t = __darwin_ino_t;
pub type ino64_t = __darwin_ino64_t;
pub type key_t = __int32_t;
pub type nlink_t = __uint16_t;
pub type segsz_t = i32;
pub type swblk_t = i32;
pub type clock_t = __darwin_clock_t;
pub type time_t = __darwin_time_t;
pub type useconds_t = __darwin_useconds_t;
pub type suseconds_t = __darwin_suseconds_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct fd_set {
    pub fds_bits: [__int32_t; 32usize],
}
#[test]
fn bindgen_test_layout_fd_set() {
    assert_eq!(
        ::std::mem::size_of::<fd_set>(),
        128usize,
        concat!("Size of: ", stringify!(fd_set))
    );
    assert_eq!(
        ::std::mem::align_of::<fd_set>(),
        4usize,
        concat!("Alignment of ", stringify!(fd_set))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<fd_set>())).fds_bits as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(fd_set),
            "::",
            stringify!(fds_bits)
        )
    );
}
extern "C" {
    pub fn __darwin_check_fd_set_overflow(
        arg1: ::std::os::raw::c_int,
        arg2: *const ::std::os::raw::c_void,
        arg3: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
pub type fd_mask = __int32_t;
pub type pthread_cond_t = __darwin_pthread_cond_t;
pub type pthread_condattr_t = __darwin_pthread_condattr_t;
pub type pthread_mutex_t = __darwin_pthread_mutex_t;
pub type pthread_mutexattr_t = __darwin_pthread_mutexattr_t;
pub type pthread_once_t = __darwin_pthread_once_t;
pub type pthread_rwlock_t = __darwin_pthread_rwlock_t;
pub type pthread_rwlockattr_t = __darwin_pthread_rwlockattr_t;
pub type pthread_t = __darwin_pthread_t;
pub type pthread_key_t = __darwin_pthread_key_t;
pub type fsblkcnt_t = __darwin_fsblkcnt_t;
pub type fsfilcnt_t = __darwin_fsfilcnt_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct kstring_t {
    pub l: size_t,
    pub m: size_t,
    pub s: *mut ::std::os::raw::c_char,
}
#[test]
fn bindgen_test_layout_kstring_t() {
    assert_eq!(
        ::std::mem::size_of::<kstring_t>(),
        24usize,
        concat!("Size of: ", stringify!(kstring_t))
    );
    assert_eq!(
        ::std::mem::align_of::<kstring_t>(),
        8usize,
        concat!("Alignment of ", stringify!(kstring_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kstring_t>())).l as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kstring_t),
            "::",
            stringify!(l)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kstring_t>())).m as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kstring_t),
            "::",
            stringify!(m)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kstring_t>())).s as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(kstring_t),
            "::",
            stringify!(s)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ks_tokaux_t {
    pub tab: [u64; 4usize],
    pub sep: ::std::os::raw::c_int,
    pub finished: ::std::os::raw::c_int,
    pub p: *const ::std::os::raw::c_char,
}
#[test]
fn bindgen_test_layout_ks_tokaux_t() {
    assert_eq!(
        ::std::mem::size_of::<ks_tokaux_t>(),
        48usize,
        concat!("Size of: ", stringify!(ks_tokaux_t))
    );
    assert_eq!(
        ::std::mem::align_of::<ks_tokaux_t>(),
        8usize,
        concat!("Alignment of ", stringify!(ks_tokaux_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ks_tokaux_t>())).tab as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(ks_tokaux_t),
            "::",
            stringify!(tab)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ks_tokaux_t>())).sep as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(ks_tokaux_t),
            "::",
            stringify!(sep)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ks_tokaux_t>())).finished as *const _ as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(ks_tokaux_t),
            "::",
            stringify!(finished)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ks_tokaux_t>())).p as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(ks_tokaux_t),
            "::",
            stringify!(p)
        )
    );
}
extern "C" {
    pub fn kvsprintf(
        s: *mut kstring_t,
        fmt: *const ::std::os::raw::c_char,
        ap: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ksprintf(
        s: *mut kstring_t,
        fmt: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn kputd(d: f64, s: *mut kstring_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ksplit_core(
        s: *mut ::std::os::raw::c_char,
        delimiter: ::std::os::raw::c_int,
        _max: *mut ::std::os::raw::c_int,
        _offsets: *mut *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn kstrstr(
        str: *const ::std::os::raw::c_char,
        pat: *const ::std::os::raw::c_char,
        _prep: *mut *mut ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn kstrnstr(
        str: *const ::std::os::raw::c_char,
        pat: *const ::std::os::raw::c_char,
        n: ::std::os::raw::c_int,
        _prep: *mut *mut ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn kmemmem(
        _str: *const ::std::os::raw::c_void,
        n: ::std::os::raw::c_int,
        _pat: *const ::std::os::raw::c_void,
        m: ::std::os::raw::c_int,
        _prep: *mut *mut ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn kstrtok(
        str: *const ::std::os::raw::c_char,
        sep: *const ::std::os::raw::c_char,
        aux: *mut ks_tokaux_t,
    ) -> *mut ::std::os::raw::c_char;
}
pub type kgets_func = ::std::option::Option<
    unsafe extern "C" fn(
        arg1: *mut ::std::os::raw::c_char,
        arg2: ::std::os::raw::c_int,
        arg3: *mut ::std::os::raw::c_void,
    ) -> *mut ::std::os::raw::c_char,
>;
extern "C" {
    pub fn kgetline(
        s: *mut kstring_t,
        fgets_fn: kgets_func,
        fp: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
pub type kgets_func2 = ::std::option::Option<
    unsafe extern "C" fn(
        arg1: *mut ::std::os::raw::c_char,
        arg2: size_t,
        arg3: *mut ::std::os::raw::c_void,
    ) -> ssize_t,
>;
extern "C" {
    pub fn kgetline2(
        s: *mut kstring_t,
        fgets_fn: kgets_func2,
        fp: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cram_fd {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hFILE {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hts_tpool {
    _unused: [u8; 0],
}
extern "C" {
    pub fn hts_resize_array_(
        arg1: size_t,
        arg2: size_t,
        arg3: size_t,
        arg4: *mut ::std::os::raw::c_void,
        arg5: *mut *mut ::std::os::raw::c_void,
        arg6: ::std::os::raw::c_int,
        arg7: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn hts_lib_shutdown();
}
extern "C" {
    pub fn hts_free(ptr: *mut ::std::os::raw::c_void);
}
pub const htsFormatCategory_unknown_category: htsFormatCategory = 0;
pub const htsFormatCategory_sequence_data: htsFormatCategory = 1;
pub const htsFormatCategory_variant_data: htsFormatCategory = 2;
pub const htsFormatCategory_index_file: htsFormatCategory = 3;
pub const htsFormatCategory_region_list: htsFormatCategory = 4;
pub const htsFormatCategory_category_maximum: htsFormatCategory = 32767;
pub type htsFormatCategory = u32;
pub const htsExactFormat_unknown_format: htsExactFormat = 0;
pub const htsExactFormat_binary_format: htsExactFormat = 1;
pub const htsExactFormat_text_format: htsExactFormat = 2;
pub const htsExactFormat_sam: htsExactFormat = 3;
pub const htsExactFormat_bam: htsExactFormat = 4;
pub const htsExactFormat_bai: htsExactFormat = 5;
pub const htsExactFormat_cram: htsExactFormat = 6;
pub const htsExactFormat_crai: htsExactFormat = 7;
pub const htsExactFormat_vcf: htsExactFormat = 8;
pub const htsExactFormat_bcf: htsExactFormat = 9;
pub const htsExactFormat_csi: htsExactFormat = 10;
pub const htsExactFormat_gzi: htsExactFormat = 11;
pub const htsExactFormat_tbi: htsExactFormat = 12;
pub const htsExactFormat_bed: htsExactFormat = 13;
pub const htsExactFormat_htsget: htsExactFormat = 14;
pub const htsExactFormat_json: htsExactFormat = 14;
pub const htsExactFormat_empty_format: htsExactFormat = 15;
pub const htsExactFormat_fasta_format: htsExactFormat = 16;
pub const htsExactFormat_fastq_format: htsExactFormat = 17;
pub const htsExactFormat_fai_format: htsExactFormat = 18;
pub const htsExactFormat_fqi_format: htsExactFormat = 19;
pub const htsExactFormat_hts_crypt4gh_format: htsExactFormat = 20;
pub const htsExactFormat_format_maximum: htsExactFormat = 32767;
pub type htsExactFormat = u32;
pub const htsCompression_no_compression: htsCompression = 0;
pub const htsCompression_gzip: htsCompression = 1;
pub const htsCompression_bgzf: htsCompression = 2;
pub const htsCompression_custom: htsCompression = 3;
pub const htsCompression_bzip2_compression: htsCompression = 4;
pub const htsCompression_compression_maximum: htsCompression = 32767;
pub type htsCompression = u32;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct htsFormat {
    pub category: htsFormatCategory,
    pub format: htsExactFormat,
    pub version: htsFormat__bindgen_ty_1,
    pub compression: htsCompression,
    pub compression_level: ::std::os::raw::c_short,
    pub specific: *mut ::std::os::raw::c_void,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct htsFormat__bindgen_ty_1 {
    pub major: ::std::os::raw::c_short,
    pub minor: ::std::os::raw::c_short,
}
#[test]
fn bindgen_test_layout_htsFormat__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<htsFormat__bindgen_ty_1>(),
        4usize,
        concat!("Size of: ", stringify!(htsFormat__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<htsFormat__bindgen_ty_1>(),
        2usize,
        concat!("Alignment of ", stringify!(htsFormat__bindgen_ty_1))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<htsFormat__bindgen_ty_1>())).major as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(htsFormat__bindgen_ty_1),
            "::",
            stringify!(major)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<htsFormat__bindgen_ty_1>())).minor as *const _ as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(htsFormat__bindgen_ty_1),
            "::",
            stringify!(minor)
        )
    );
}
#[test]
fn bindgen_test_layout_htsFormat() {
    assert_eq!(
        ::std::mem::size_of::<htsFormat>(),
        32usize,
        concat!("Size of: ", stringify!(htsFormat))
    );
    assert_eq!(
        ::std::mem::align_of::<htsFormat>(),
        8usize,
        concat!("Alignment of ", stringify!(htsFormat))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<htsFormat>())).category as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(htsFormat),
            "::",
            stringify!(category)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<htsFormat>())).format as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(htsFormat),
            "::",
            stringify!(format)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<htsFormat>())).version as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(htsFormat),
            "::",
            stringify!(version)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<htsFormat>())).compression as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(htsFormat),
            "::",
            stringify!(compression)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<htsFormat>())).compression_level as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(htsFormat),
            "::",
            stringify!(compression_level)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<htsFormat>())).specific as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(htsFormat),
            "::",
            stringify!(specific)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hts_idx_t {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct htsFile {
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize], u32>,
    pub lineno: i64,
    pub line: kstring_t,
    pub fn_: *mut ::std::os::raw::c_char,
    pub fn_aux: *mut ::std::os::raw::c_char,
    pub fp: htsFile__bindgen_ty_1,
    pub state: *mut ::std::os::raw::c_void,
    pub format: htsFormat,
    pub idx: *mut hts_idx_t,
    pub fnidx: *const ::std::os::raw::c_char,
    pub bam_header: *mut sam_hdr_t,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union htsFile__bindgen_ty_1 {
    pub bgzf: *mut BGZF,
    pub cram: *mut cram_fd,
    pub hfile: *mut hFILE,
    _bindgen_union_align: u64,
}
#[test]
fn bindgen_test_layout_htsFile__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<htsFile__bindgen_ty_1>(),
        8usize,
        concat!("Size of: ", stringify!(htsFile__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<htsFile__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(htsFile__bindgen_ty_1))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<htsFile__bindgen_ty_1>())).bgzf as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(htsFile__bindgen_ty_1),
            "::",
            stringify!(bgzf)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<htsFile__bindgen_ty_1>())).cram as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(htsFile__bindgen_ty_1),
            "::",
            stringify!(cram)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<htsFile__bindgen_ty_1>())).hfile as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(htsFile__bindgen_ty_1),
            "::",
            stringify!(hfile)
        )
    );
}
#[test]
fn bindgen_test_layout_htsFile() {
    assert_eq!(
        ::std::mem::size_of::<htsFile>(),
        128usize,
        concat!("Size of: ", stringify!(htsFile))
    );
    assert_eq!(
        ::std::mem::align_of::<htsFile>(),
        8usize,
        concat!("Alignment of ", stringify!(htsFile))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<htsFile>())).lineno as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(htsFile),
            "::",
            stringify!(lineno)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<htsFile>())).line as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(htsFile),
            "::",
            stringify!(line)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<htsFile>())).fn_ as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(htsFile),
            "::",
            stringify!(fn_)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<htsFile>())).fn_aux as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(htsFile),
            "::",
            stringify!(fn_aux)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<htsFile>())).fp as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(htsFile),
            "::",
            stringify!(fp)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<htsFile>())).state as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(htsFile),
            "::",
            stringify!(state)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<htsFile>())).format as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(htsFile),
            "::",
            stringify!(format)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<htsFile>())).idx as *const _ as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(htsFile),
            "::",
            stringify!(idx)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<htsFile>())).fnidx as *const _ as usize },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(htsFile),
            "::",
            stringify!(fnidx)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<htsFile>())).bam_header as *const _ as usize },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(htsFile),
            "::",
            stringify!(bam_header)
        )
    );
}
impl htsFile {
    #[inline]
    pub fn is_bin(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_is_bin(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn is_write(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_is_write(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn is_be(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_is_be(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn is_cram(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_is_cram(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn is_bgzf(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_is_bgzf(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn dummy(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(5usize, 27u8) as u32) }
    }
    #[inline]
    pub fn set_dummy(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(5usize, 27u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        is_bin: u32,
        is_write: u32,
        is_be: u32,
        is_cram: u32,
        is_bgzf: u32,
        dummy: u32,
    ) -> __BindgenBitfieldUnit<[u8; 4usize], u32> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize], u32> =
            Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let is_bin: u32 = unsafe { ::std::mem::transmute(is_bin) };
            is_bin as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let is_write: u32 = unsafe { ::std::mem::transmute(is_write) };
            is_write as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let is_be: u32 = unsafe { ::std::mem::transmute(is_be) };
            is_be as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let is_cram: u32 = unsafe { ::std::mem::transmute(is_cram) };
            is_cram as u64
        });
        __bindgen_bitfield_unit.set(4usize, 1u8, {
            let is_bgzf: u32 = unsafe { ::std::mem::transmute(is_bgzf) };
            is_bgzf as u64
        });
        __bindgen_bitfield_unit.set(5usize, 27u8, {
            let dummy: u32 = unsafe { ::std::mem::transmute(dummy) };
            dummy as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct htsThreadPool {
    pub pool: *mut hts_tpool,
    pub qsize: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_htsThreadPool() {
    assert_eq!(
        ::std::mem::size_of::<htsThreadPool>(),
        16usize,
        concat!("Size of: ", stringify!(htsThreadPool))
    );
    assert_eq!(
        ::std::mem::align_of::<htsThreadPool>(),
        8usize,
        concat!("Alignment of ", stringify!(htsThreadPool))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<htsThreadPool>())).pool as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(htsThreadPool),
            "::",
            stringify!(pool)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<htsThreadPool>())).qsize as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(htsThreadPool),
            "::",
            stringify!(qsize)
        )
    );
}
pub const sam_fields_SAM_QNAME: sam_fields = 1;
pub const sam_fields_SAM_FLAG: sam_fields = 2;
pub const sam_fields_SAM_RNAME: sam_fields = 4;
pub const sam_fields_SAM_POS: sam_fields = 8;
pub const sam_fields_SAM_MAPQ: sam_fields = 16;
pub const sam_fields_SAM_CIGAR: sam_fields = 32;
pub const sam_fields_SAM_RNEXT: sam_fields = 64;
pub const sam_fields_SAM_PNEXT: sam_fields = 128;
pub const sam_fields_SAM_TLEN: sam_fields = 256;
pub const sam_fields_SAM_SEQ: sam_fields = 512;
pub const sam_fields_SAM_QUAL: sam_fields = 1024;
pub const sam_fields_SAM_AUX: sam_fields = 2048;
pub const sam_fields_SAM_RGAUX: sam_fields = 4096;
pub type sam_fields = u32;
pub const hts_fmt_option_CRAM_OPT_DECODE_MD: hts_fmt_option = 0;
pub const hts_fmt_option_CRAM_OPT_PREFIX: hts_fmt_option = 1;
pub const hts_fmt_option_CRAM_OPT_VERBOSITY: hts_fmt_option = 2;
pub const hts_fmt_option_CRAM_OPT_SEQS_PER_SLICE: hts_fmt_option = 3;
pub const hts_fmt_option_CRAM_OPT_SLICES_PER_CONTAINER: hts_fmt_option = 4;
pub const hts_fmt_option_CRAM_OPT_RANGE: hts_fmt_option = 5;
pub const hts_fmt_option_CRAM_OPT_VERSION: hts_fmt_option = 6;
pub const hts_fmt_option_CRAM_OPT_EMBED_REF: hts_fmt_option = 7;
pub const hts_fmt_option_CRAM_OPT_IGNORE_MD5: hts_fmt_option = 8;
pub const hts_fmt_option_CRAM_OPT_REFERENCE: hts_fmt_option = 9;
pub const hts_fmt_option_CRAM_OPT_MULTI_SEQ_PER_SLICE: hts_fmt_option = 10;
pub const hts_fmt_option_CRAM_OPT_NO_REF: hts_fmt_option = 11;
pub const hts_fmt_option_CRAM_OPT_USE_BZIP2: hts_fmt_option = 12;
pub const hts_fmt_option_CRAM_OPT_SHARED_REF: hts_fmt_option = 13;
pub const hts_fmt_option_CRAM_OPT_NTHREADS: hts_fmt_option = 14;
pub const hts_fmt_option_CRAM_OPT_THREAD_POOL: hts_fmt_option = 15;
pub const hts_fmt_option_CRAM_OPT_USE_LZMA: hts_fmt_option = 16;
pub const hts_fmt_option_CRAM_OPT_USE_RANS: hts_fmt_option = 17;
pub const hts_fmt_option_CRAM_OPT_REQUIRED_FIELDS: hts_fmt_option = 18;
pub const hts_fmt_option_CRAM_OPT_LOSSY_NAMES: hts_fmt_option = 19;
pub const hts_fmt_option_CRAM_OPT_BASES_PER_SLICE: hts_fmt_option = 20;
pub const hts_fmt_option_CRAM_OPT_STORE_MD: hts_fmt_option = 21;
pub const hts_fmt_option_CRAM_OPT_STORE_NM: hts_fmt_option = 22;
pub const hts_fmt_option_CRAM_OPT_RANGE_NOSEEK: hts_fmt_option = 23;
pub const hts_fmt_option_HTS_OPT_COMPRESSION_LEVEL: hts_fmt_option = 100;
pub const hts_fmt_option_HTS_OPT_NTHREADS: hts_fmt_option = 101;
pub const hts_fmt_option_HTS_OPT_THREAD_POOL: hts_fmt_option = 102;
pub const hts_fmt_option_HTS_OPT_CACHE_SIZE: hts_fmt_option = 103;
pub const hts_fmt_option_HTS_OPT_BLOCK_SIZE: hts_fmt_option = 104;
pub type hts_fmt_option = u32;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct hts_opt {
    pub arg: *mut ::std::os::raw::c_char,
    pub opt: hts_fmt_option,
    pub val: hts_opt__bindgen_ty_1,
    pub next: *mut hts_opt,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union hts_opt__bindgen_ty_1 {
    pub i: ::std::os::raw::c_int,
    pub s: *mut ::std::os::raw::c_char,
    _bindgen_union_align: u64,
}
#[test]
fn bindgen_test_layout_hts_opt__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<hts_opt__bindgen_ty_1>(),
        8usize,
        concat!("Size of: ", stringify!(hts_opt__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<hts_opt__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(hts_opt__bindgen_ty_1))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hts_opt__bindgen_ty_1>())).i as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(hts_opt__bindgen_ty_1),
            "::",
            stringify!(i)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hts_opt__bindgen_ty_1>())).s as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(hts_opt__bindgen_ty_1),
            "::",
            stringify!(s)
        )
    );
}
#[test]
fn bindgen_test_layout_hts_opt() {
    assert_eq!(
        ::std::mem::size_of::<hts_opt>(),
        32usize,
        concat!("Size of: ", stringify!(hts_opt))
    );
    assert_eq!(
        ::std::mem::align_of::<hts_opt>(),
        8usize,
        concat!("Alignment of ", stringify!(hts_opt))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hts_opt>())).arg as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(hts_opt),
            "::",
            stringify!(arg)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hts_opt>())).opt as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(hts_opt),
            "::",
            stringify!(opt)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hts_opt>())).val as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(hts_opt),
            "::",
            stringify!(val)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hts_opt>())).next as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(hts_opt),
            "::",
            stringify!(next)
        )
    );
}
extern "C" {
    pub fn hts_opt_add(
        opts: *mut *mut hts_opt,
        c_arg: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn hts_opt_apply(fp: *mut htsFile, opts: *mut hts_opt) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn hts_opt_free(opts: *mut hts_opt);
}
extern "C" {
    pub fn hts_parse_format(
        opt: *mut htsFormat,
        str: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn hts_parse_opt_list(
        opt: *mut htsFormat,
        str: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub static seq_nt16_table: [::std::os::raw::c_uchar; 256usize];
}
extern "C" {
    pub static mut seq_nt16_str: [::std::os::raw::c_char; 0usize];
}
extern "C" {
    pub static mut seq_nt16_int: [::std::os::raw::c_int; 0usize];
}
extern "C" {
    pub fn hts_version() -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn hts_detect_format(fp: *mut hFILE, fmt: *mut htsFormat) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn hts_format_description(format: *const htsFormat) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn hts_open(
        fn_: *const ::std::os::raw::c_char,
        mode: *const ::std::os::raw::c_char,
    ) -> *mut htsFile;
}
extern "C" {
    pub fn hts_open_format(
        fn_: *const ::std::os::raw::c_char,
        mode: *const ::std::os::raw::c_char,
        fmt: *const htsFormat,
    ) -> *mut htsFile;
}
extern "C" {
    pub fn hts_hopen(
        fp: *mut hFILE,
        fn_: *const ::std::os::raw::c_char,
        mode: *const ::std::os::raw::c_char,
    ) -> *mut htsFile;
}
extern "C" {
    pub fn hts_close(fp: *mut htsFile) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn hts_get_format(fp: *mut htsFile) -> *const htsFormat;
}
extern "C" {
    pub fn hts_format_file_extension(format: *const htsFormat) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn hts_set_opt(fp: *mut htsFile, opt: hts_fmt_option, ...) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn hts_getline(
        fp: *mut htsFile,
        delimiter: ::std::os::raw::c_int,
        str: *mut kstring_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn hts_readlines(
        fn_: *const ::std::os::raw::c_char,
        _n: *mut ::std::os::raw::c_int,
    ) -> *mut *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn hts_readlist(
        fn_: *const ::std::os::raw::c_char,
        is_file: ::std::os::raw::c_int,
        _n: *mut ::std::os::raw::c_int,
    ) -> *mut *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn hts_set_threads(fp: *mut htsFile, n: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn hts_set_thread_pool(fp: *mut htsFile, p: *mut htsThreadPool) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn hts_set_cache_size(fp: *mut htsFile, n: ::std::os::raw::c_int);
}
extern "C" {
    pub fn hts_set_fai_filename(
        fp: *mut htsFile,
        fn_aux: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn hts_check_EOF(fp: *mut htsFile) -> ::std::os::raw::c_int;
}
pub type hts_pos_t = i64;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hts_pair_pos_t {
    pub beg: hts_pos_t,
    pub end: hts_pos_t,
}
#[test]
fn bindgen_test_layout_hts_pair_pos_t() {
    assert_eq!(
        ::std::mem::size_of::<hts_pair_pos_t>(),
        16usize,
        concat!("Size of: ", stringify!(hts_pair_pos_t))
    );
    assert_eq!(
        ::std::mem::align_of::<hts_pair_pos_t>(),
        8usize,
        concat!("Alignment of ", stringify!(hts_pair_pos_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hts_pair_pos_t>())).beg as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(hts_pair_pos_t),
            "::",
            stringify!(beg)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hts_pair_pos_t>())).end as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(hts_pair_pos_t),
            "::",
            stringify!(end)
        )
    );
}
pub type hts_pair32_t = hts_pair_pos_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hts_pair64_t {
    pub u: u64,
    pub v: u64,
}
#[test]
fn bindgen_test_layout_hts_pair64_t() {
    assert_eq!(
        ::std::mem::size_of::<hts_pair64_t>(),
        16usize,
        concat!("Size of: ", stringify!(hts_pair64_t))
    );
    assert_eq!(
        ::std::mem::align_of::<hts_pair64_t>(),
        8usize,
        concat!("Alignment of ", stringify!(hts_pair64_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hts_pair64_t>())).u as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(hts_pair64_t),
            "::",
            stringify!(u)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hts_pair64_t>())).v as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(hts_pair64_t),
            "::",
            stringify!(v)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hts_pair64_max_t {
    pub u: u64,
    pub v: u64,
    pub max: u64,
}
#[test]
fn bindgen_test_layout_hts_pair64_max_t() {
    assert_eq!(
        ::std::mem::size_of::<hts_pair64_max_t>(),
        24usize,
        concat!("Size of: ", stringify!(hts_pair64_max_t))
    );
    assert_eq!(
        ::std::mem::align_of::<hts_pair64_max_t>(),
        8usize,
        concat!("Alignment of ", stringify!(hts_pair64_max_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hts_pair64_max_t>())).u as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(hts_pair64_max_t),
            "::",
            stringify!(u)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hts_pair64_max_t>())).v as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(hts_pair64_max_t),
            "::",
            stringify!(v)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hts_pair64_max_t>())).max as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(hts_pair64_max_t),
            "::",
            stringify!(max)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hts_reglist_t {
    pub reg: *const ::std::os::raw::c_char,
    pub intervals: *mut hts_pair_pos_t,
    pub tid: ::std::os::raw::c_int,
    pub count: u32,
    pub min_beg: hts_pos_t,
    pub max_end: hts_pos_t,
}
#[test]
fn bindgen_test_layout_hts_reglist_t() {
    assert_eq!(
        ::std::mem::size_of::<hts_reglist_t>(),
        40usize,
        concat!("Size of: ", stringify!(hts_reglist_t))
    );
    assert_eq!(
        ::std::mem::align_of::<hts_reglist_t>(),
        8usize,
        concat!("Alignment of ", stringify!(hts_reglist_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hts_reglist_t>())).reg as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(hts_reglist_t),
            "::",
            stringify!(reg)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hts_reglist_t>())).intervals as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(hts_reglist_t),
            "::",
            stringify!(intervals)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hts_reglist_t>())).tid as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(hts_reglist_t),
            "::",
            stringify!(tid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hts_reglist_t>())).count as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(hts_reglist_t),
            "::",
            stringify!(count)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hts_reglist_t>())).min_beg as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(hts_reglist_t),
            "::",
            stringify!(min_beg)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hts_reglist_t>())).max_end as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(hts_reglist_t),
            "::",
            stringify!(max_end)
        )
    );
}
pub type hts_readrec_func = ::std::option::Option<
    unsafe extern "C" fn(
        fp: *mut BGZF,
        data: *mut ::std::os::raw::c_void,
        r: *mut ::std::os::raw::c_void,
        tid: *mut ::std::os::raw::c_int,
        beg: *mut hts_pos_t,
        end: *mut hts_pos_t,
    ) -> ::std::os::raw::c_int,
>;
pub type hts_seek_func = ::std::option::Option<
    unsafe extern "C" fn(
        fp: *mut ::std::os::raw::c_void,
        offset: i64,
        where_: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int,
>;
pub type hts_tell_func =
    ::std::option::Option<unsafe extern "C" fn(fp: *mut ::std::os::raw::c_void) -> i64>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hts_itr_t {
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize], u32>,
    pub tid: ::std::os::raw::c_int,
    pub n_off: ::std::os::raw::c_int,
    pub i: ::std::os::raw::c_int,
    pub n_reg: ::std::os::raw::c_int,
    pub beg: hts_pos_t,
    pub end: hts_pos_t,
    pub reg_list: *mut hts_reglist_t,
    pub curr_tid: ::std::os::raw::c_int,
    pub curr_reg: ::std::os::raw::c_int,
    pub curr_intv: ::std::os::raw::c_int,
    pub curr_beg: hts_pos_t,
    pub curr_end: hts_pos_t,
    pub curr_off: u64,
    pub nocoor_off: u64,
    pub off: *mut hts_pair64_max_t,
    pub readrec: hts_readrec_func,
    pub seek: hts_seek_func,
    pub tell: hts_tell_func,
    pub bins: hts_itr_t__bindgen_ty_1,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hts_itr_t__bindgen_ty_1 {
    pub n: ::std::os::raw::c_int,
    pub m: ::std::os::raw::c_int,
    pub a: *mut ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_hts_itr_t__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<hts_itr_t__bindgen_ty_1>(),
        16usize,
        concat!("Size of: ", stringify!(hts_itr_t__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<hts_itr_t__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(hts_itr_t__bindgen_ty_1))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hts_itr_t__bindgen_ty_1>())).n as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(hts_itr_t__bindgen_ty_1),
            "::",
            stringify!(n)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hts_itr_t__bindgen_ty_1>())).m as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(hts_itr_t__bindgen_ty_1),
            "::",
            stringify!(m)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hts_itr_t__bindgen_ty_1>())).a as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(hts_itr_t__bindgen_ty_1),
            "::",
            stringify!(a)
        )
    );
}
#[test]
fn bindgen_test_layout_hts_itr_t() {
    assert_eq!(
        ::std::mem::size_of::<hts_itr_t>(),
        144usize,
        concat!("Size of: ", stringify!(hts_itr_t))
    );
    assert_eq!(
        ::std::mem::align_of::<hts_itr_t>(),
        8usize,
        concat!("Alignment of ", stringify!(hts_itr_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hts_itr_t>())).tid as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(hts_itr_t),
            "::",
            stringify!(tid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hts_itr_t>())).n_off as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(hts_itr_t),
            "::",
            stringify!(n_off)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hts_itr_t>())).i as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(hts_itr_t),
            "::",
            stringify!(i)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hts_itr_t>())).n_reg as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(hts_itr_t),
            "::",
            stringify!(n_reg)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hts_itr_t>())).beg as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(hts_itr_t),
            "::",
            stringify!(beg)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hts_itr_t>())).end as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(hts_itr_t),
            "::",
            stringify!(end)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hts_itr_t>())).reg_list as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(hts_itr_t),
            "::",
            stringify!(reg_list)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hts_itr_t>())).curr_tid as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(hts_itr_t),
            "::",
            stringify!(curr_tid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hts_itr_t>())).curr_reg as *const _ as usize },
        52usize,
        concat!(
            "Offset of field: ",
            stringify!(hts_itr_t),
            "::",
            stringify!(curr_reg)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hts_itr_t>())).curr_intv as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(hts_itr_t),
            "::",
            stringify!(curr_intv)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hts_itr_t>())).curr_beg as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(hts_itr_t),
            "::",
            stringify!(curr_beg)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hts_itr_t>())).curr_end as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(hts_itr_t),
            "::",
            stringify!(curr_end)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hts_itr_t>())).curr_off as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(hts_itr_t),
            "::",
            stringify!(curr_off)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hts_itr_t>())).nocoor_off as *const _ as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(hts_itr_t),
            "::",
            stringify!(nocoor_off)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hts_itr_t>())).off as *const _ as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(hts_itr_t),
            "::",
            stringify!(off)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hts_itr_t>())).readrec as *const _ as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(hts_itr_t),
            "::",
            stringify!(readrec)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hts_itr_t>())).seek as *const _ as usize },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(hts_itr_t),
            "::",
            stringify!(seek)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hts_itr_t>())).tell as *const _ as usize },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(hts_itr_t),
            "::",
            stringify!(tell)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hts_itr_t>())).bins as *const _ as usize },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(hts_itr_t),
            "::",
            stringify!(bins)
        )
    );
}
impl hts_itr_t {
    #[inline]
    pub fn read_rest(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_read_rest(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn finished(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_finished(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn is_cram(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_is_cram(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn nocoor(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_nocoor(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn multi(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_multi(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn dummy(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(5usize, 27u8) as u32) }
    }
    #[inline]
    pub fn set_dummy(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(5usize, 27u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        read_rest: u32,
        finished: u32,
        is_cram: u32,
        nocoor: u32,
        multi: u32,
        dummy: u32,
    ) -> __BindgenBitfieldUnit<[u8; 4usize], u32> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize], u32> =
            Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let read_rest: u32 = unsafe { ::std::mem::transmute(read_rest) };
            read_rest as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let finished: u32 = unsafe { ::std::mem::transmute(finished) };
            finished as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let is_cram: u32 = unsafe { ::std::mem::transmute(is_cram) };
            is_cram as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let nocoor: u32 = unsafe { ::std::mem::transmute(nocoor) };
            nocoor as u64
        });
        __bindgen_bitfield_unit.set(4usize, 1u8, {
            let multi: u32 = unsafe { ::std::mem::transmute(multi) };
            multi as u64
        });
        __bindgen_bitfield_unit.set(5usize, 27u8, {
            let dummy: u32 = unsafe { ::std::mem::transmute(dummy) };
            dummy as u64
        });
        __bindgen_bitfield_unit
    }
}
pub type hts_itr_multi_t = hts_itr_t;
extern "C" {
    pub fn hts_idx_init(
        n: ::std::os::raw::c_int,
        fmt: ::std::os::raw::c_int,
        offset0: u64,
        min_shift: ::std::os::raw::c_int,
        n_lvls: ::std::os::raw::c_int,
    ) -> *mut hts_idx_t;
}
extern "C" {
    pub fn hts_idx_destroy(idx: *mut hts_idx_t);
}
extern "C" {
    pub fn hts_idx_push(
        idx: *mut hts_idx_t,
        tid: ::std::os::raw::c_int,
        beg: hts_pos_t,
        end: hts_pos_t,
        offset: u64,
        is_mapped: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn hts_idx_finish(idx: *mut hts_idx_t, final_offset: u64) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn hts_idx_fmt(idx: *mut hts_idx_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn hts_idx_tbi_name(
        idx: *mut hts_idx_t,
        tid: ::std::os::raw::c_int,
        name: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn hts_idx_save(
        idx: *const hts_idx_t,
        fn_: *const ::std::os::raw::c_char,
        fmt: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn hts_idx_save_as(
        idx: *const hts_idx_t,
        fn_: *const ::std::os::raw::c_char,
        fnidx: *const ::std::os::raw::c_char,
        fmt: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn hts_idx_load(
        fn_: *const ::std::os::raw::c_char,
        fmt: ::std::os::raw::c_int,
    ) -> *mut hts_idx_t;
}
extern "C" {
    pub fn hts_idx_load2(
        fn_: *const ::std::os::raw::c_char,
        fnidx: *const ::std::os::raw::c_char,
    ) -> *mut hts_idx_t;
}
extern "C" {
    pub fn hts_idx_load3(
        fn_: *const ::std::os::raw::c_char,
        fnidx: *const ::std::os::raw::c_char,
        fmt: ::std::os::raw::c_int,
        flags: ::std::os::raw::c_int,
    ) -> *mut hts_idx_t;
}
extern "C" {
    pub fn hts_idx_get_meta(idx: *mut hts_idx_t, l_meta: *mut u32) -> *mut u8;
}
extern "C" {
    pub fn hts_idx_set_meta(
        idx: *mut hts_idx_t,
        l_meta: u32,
        meta: *mut u8,
        is_copy: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn hts_idx_get_stat(
        idx: *const hts_idx_t,
        tid: ::std::os::raw::c_int,
        mapped: *mut u64,
        unmapped: *mut u64,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn hts_idx_get_n_no_coor(idx: *const hts_idx_t) -> u64;
}
extern "C" {
    pub fn hts_parse_decimal(
        str: *const ::std::os::raw::c_char,
        strend: *mut *mut ::std::os::raw::c_char,
        flags: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_longlong;
}
pub type hts_name2id_f = ::std::option::Option<
    unsafe extern "C" fn(
        arg1: *mut ::std::os::raw::c_void,
        arg2: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int,
>;
pub type hts_id2name_f = ::std::option::Option<
    unsafe extern "C" fn(
        arg1: *mut ::std::os::raw::c_void,
        arg2: ::std::os::raw::c_int,
    ) -> *const ::std::os::raw::c_char,
>;
extern "C" {
    pub fn hts_parse_reg64(
        str: *const ::std::os::raw::c_char,
        beg: *mut hts_pos_t,
        end: *mut hts_pos_t,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn hts_parse_reg(
        str: *const ::std::os::raw::c_char,
        beg: *mut ::std::os::raw::c_int,
        end: *mut ::std::os::raw::c_int,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn hts_parse_region(
        s: *const ::std::os::raw::c_char,
        tid: *mut ::std::os::raw::c_int,
        beg: *mut hts_pos_t,
        end: *mut hts_pos_t,
        getid: hts_name2id_f,
        hdr: *mut ::std::os::raw::c_void,
        flags: ::std::os::raw::c_int,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn hts_itr_query(
        idx: *const hts_idx_t,
        tid: ::std::os::raw::c_int,
        beg: hts_pos_t,
        end: hts_pos_t,
        readrec: hts_readrec_func,
    ) -> *mut hts_itr_t;
}
extern "C" {
    pub fn hts_itr_destroy(iter: *mut hts_itr_t);
}
pub type hts_itr_query_func = ::std::option::Option<
    unsafe extern "C" fn(
        idx: *const hts_idx_t,
        tid: ::std::os::raw::c_int,
        beg: hts_pos_t,
        end: hts_pos_t,
        readrec: hts_readrec_func,
    ) -> *mut hts_itr_t,
>;
extern "C" {
    pub fn hts_itr_querys(
        idx: *const hts_idx_t,
        reg: *const ::std::os::raw::c_char,
        getid: hts_name2id_f,
        hdr: *mut ::std::os::raw::c_void,
        itr_query: hts_itr_query_func,
        readrec: hts_readrec_func,
    ) -> *mut hts_itr_t;
}
extern "C" {
    pub fn hts_itr_next(
        fp: *mut BGZF,
        iter: *mut hts_itr_t,
        r: *mut ::std::os::raw::c_void,
        data: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn hts_idx_seqnames(
        idx: *const hts_idx_t,
        n: *mut ::std::os::raw::c_int,
        getid: hts_id2name_f,
        hdr: *mut ::std::os::raw::c_void,
    ) -> *mut *const ::std::os::raw::c_char;
}
pub type hts_itr_multi_query_func = ::std::option::Option<
    unsafe extern "C" fn(idx: *const hts_idx_t, itr: *mut hts_itr_t) -> ::std::os::raw::c_int,
>;
extern "C" {
    pub fn hts_itr_multi_bam(idx: *const hts_idx_t, iter: *mut hts_itr_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn hts_itr_multi_cram(idx: *const hts_idx_t, iter: *mut hts_itr_t)
        -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn hts_itr_regions(
        idx: *const hts_idx_t,
        reglist: *mut hts_reglist_t,
        count: ::std::os::raw::c_int,
        getid: hts_name2id_f,
        hdr: *mut ::std::os::raw::c_void,
        itr_specific: hts_itr_multi_query_func,
        readrec: hts_readrec_func,
        seek: hts_seek_func,
        tell: hts_tell_func,
    ) -> *mut hts_itr_t;
}
extern "C" {
    pub fn hts_itr_multi_next(
        fd: *mut htsFile,
        iter: *mut hts_itr_t,
        r: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn hts_reglist_create(
        argv: *mut *mut ::std::os::raw::c_char,
        argc: ::std::os::raw::c_int,
        r_count: *mut ::std::os::raw::c_int,
        hdr: *mut ::std::os::raw::c_void,
        getid: hts_name2id_f,
    ) -> *mut hts_reglist_t;
}
extern "C" {
    pub fn hts_reglist_free(reglist: *mut hts_reglist_t, count: ::std::os::raw::c_int);
}
extern "C" {
    pub fn hts_file_type(fname: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct errmod_t {
    _unused: [u8; 0],
}
extern "C" {
    pub fn errmod_init(depcorr: f64) -> *mut errmod_t;
}
extern "C" {
    pub fn errmod_destroy(em: *mut errmod_t);
}
extern "C" {
    pub fn errmod_cal(
        em: *const errmod_t,
        n: ::std::os::raw::c_int,
        m: ::std::os::raw::c_int,
        bases: *mut u16,
        q: *mut f32,
    ) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct probaln_par_t {
    pub d: f32,
    pub e: f32,
    pub bw: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_probaln_par_t() {
    assert_eq!(
        ::std::mem::size_of::<probaln_par_t>(),
        12usize,
        concat!("Size of: ", stringify!(probaln_par_t))
    );
    assert_eq!(
        ::std::mem::align_of::<probaln_par_t>(),
        4usize,
        concat!("Alignment of ", stringify!(probaln_par_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<probaln_par_t>())).d as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(probaln_par_t),
            "::",
            stringify!(d)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<probaln_par_t>())).e as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(probaln_par_t),
            "::",
            stringify!(e)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<probaln_par_t>())).bw as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(probaln_par_t),
            "::",
            stringify!(bw)
        )
    );
}
extern "C" {
    pub fn probaln_glocal(
        ref_: *const u8,
        l_ref: ::std::os::raw::c_int,
        query: *const u8,
        l_query: ::std::os::raw::c_int,
        iqual: *const u8,
        c: *const probaln_par_t,
        state: *mut ::std::os::raw::c_int,
        q: *mut u8,
    ) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hts_md5_context {
    _unused: [u8; 0],
}
extern "C" {
    pub fn hts_md5_init() -> *mut hts_md5_context;
}
extern "C" {
    pub fn hts_md5_update(
        ctx: *mut hts_md5_context,
        data: *const ::std::os::raw::c_void,
        size: ::std::os::raw::c_ulong,
    );
}
extern "C" {
    pub fn hts_md5_final(digest: *mut ::std::os::raw::c_uchar, ctx: *mut hts_md5_context);
}
extern "C" {
    pub fn hts_md5_reset(ctx: *mut hts_md5_context);
}
extern "C" {
    pub fn hts_md5_hex(hex: *mut ::std::os::raw::c_char, digest: *const ::std::os::raw::c_uchar);
}
extern "C" {
    pub fn hts_md5_destroy(ctx: *mut hts_md5_context);
}
pub type uint16_u = u16;
pub type uint32_u = u32;
pub type uint64_u = u64;
extern "C" {
    pub fn __assert_rtn(
        arg1: *const ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
        arg3: ::std::os::raw::c_int,
        arg4: *const ::std::os::raw::c_char,
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct bcf_hrec_t {
    pub type_: ::std::os::raw::c_int,
    pub key: *mut ::std::os::raw::c_char,
    pub value: *mut ::std::os::raw::c_char,
    pub nkeys: ::std::os::raw::c_int,
    pub keys: *mut *mut ::std::os::raw::c_char,
    pub vals: *mut *mut ::std::os::raw::c_char,
}
#[test]
fn bindgen_test_layout_bcf_hrec_t() {
    assert_eq!(
        ::std::mem::size_of::<bcf_hrec_t>(),
        48usize,
        concat!("Size of: ", stringify!(bcf_hrec_t))
    );
    assert_eq!(
        ::std::mem::align_of::<bcf_hrec_t>(),
        8usize,
        concat!("Alignment of ", stringify!(bcf_hrec_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_hrec_t>())).type_ as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_hrec_t),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_hrec_t>())).key as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_hrec_t),
            "::",
            stringify!(key)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_hrec_t>())).value as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_hrec_t),
            "::",
            stringify!(value)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_hrec_t>())).nkeys as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_hrec_t),
            "::",
            stringify!(nkeys)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_hrec_t>())).keys as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_hrec_t),
            "::",
            stringify!(keys)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_hrec_t>())).vals as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_hrec_t),
            "::",
            stringify!(vals)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct bcf_idinfo_t {
    pub info: [u64; 3usize],
    pub hrec: [*mut bcf_hrec_t; 3usize],
    pub id: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_bcf_idinfo_t() {
    assert_eq!(
        ::std::mem::size_of::<bcf_idinfo_t>(),
        56usize,
        concat!("Size of: ", stringify!(bcf_idinfo_t))
    );
    assert_eq!(
        ::std::mem::align_of::<bcf_idinfo_t>(),
        8usize,
        concat!("Alignment of ", stringify!(bcf_idinfo_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_idinfo_t>())).info as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_idinfo_t),
            "::",
            stringify!(info)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_idinfo_t>())).hrec as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_idinfo_t),
            "::",
            stringify!(hrec)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_idinfo_t>())).id as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_idinfo_t),
            "::",
            stringify!(id)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct bcf_idpair_t {
    pub key: *const ::std::os::raw::c_char,
    pub val: *const bcf_idinfo_t,
}
#[test]
fn bindgen_test_layout_bcf_idpair_t() {
    assert_eq!(
        ::std::mem::size_of::<bcf_idpair_t>(),
        16usize,
        concat!("Size of: ", stringify!(bcf_idpair_t))
    );
    assert_eq!(
        ::std::mem::align_of::<bcf_idpair_t>(),
        8usize,
        concat!("Alignment of ", stringify!(bcf_idpair_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_idpair_t>())).key as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_idpair_t),
            "::",
            stringify!(key)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_idpair_t>())).val as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_idpair_t),
            "::",
            stringify!(val)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct bcf_hdr_t {
    pub n: [i32; 3usize],
    pub id: [*mut bcf_idpair_t; 3usize],
    pub dict: [*mut ::std::os::raw::c_void; 3usize],
    pub samples: *mut *mut ::std::os::raw::c_char,
    pub hrec: *mut *mut bcf_hrec_t,
    pub nhrec: ::std::os::raw::c_int,
    pub dirty: ::std::os::raw::c_int,
    pub ntransl: ::std::os::raw::c_int,
    pub transl: [*mut ::std::os::raw::c_int; 2usize],
    pub nsamples_ori: ::std::os::raw::c_int,
    pub keep_samples: *mut u8,
    pub mem: kstring_t,
    pub m: [i32; 3usize],
}
#[test]
fn bindgen_test_layout_bcf_hdr_t() {
    assert_eq!(
        ::std::mem::size_of::<bcf_hdr_t>(),
        168usize,
        concat!("Size of: ", stringify!(bcf_hdr_t))
    );
    assert_eq!(
        ::std::mem::align_of::<bcf_hdr_t>(),
        8usize,
        concat!("Alignment of ", stringify!(bcf_hdr_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_hdr_t>())).n as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_hdr_t),
            "::",
            stringify!(n)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_hdr_t>())).id as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_hdr_t),
            "::",
            stringify!(id)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_hdr_t>())).dict as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_hdr_t),
            "::",
            stringify!(dict)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_hdr_t>())).samples as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_hdr_t),
            "::",
            stringify!(samples)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_hdr_t>())).hrec as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_hdr_t),
            "::",
            stringify!(hrec)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_hdr_t>())).nhrec as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_hdr_t),
            "::",
            stringify!(nhrec)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_hdr_t>())).dirty as *const _ as usize },
        84usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_hdr_t),
            "::",
            stringify!(dirty)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_hdr_t>())).ntransl as *const _ as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_hdr_t),
            "::",
            stringify!(ntransl)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_hdr_t>())).transl as *const _ as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_hdr_t),
            "::",
            stringify!(transl)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_hdr_t>())).nsamples_ori as *const _ as usize },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_hdr_t),
            "::",
            stringify!(nsamples_ori)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_hdr_t>())).keep_samples as *const _ as usize },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_hdr_t),
            "::",
            stringify!(keep_samples)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_hdr_t>())).mem as *const _ as usize },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_hdr_t),
            "::",
            stringify!(mem)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_hdr_t>())).m as *const _ as usize },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_hdr_t),
            "::",
            stringify!(m)
        )
    );
}
extern "C" {
    pub static mut bcf_type_shift: [u8; 0usize];
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct bcf_variant_t {
    pub type_: ::std::os::raw::c_int,
    pub n: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_bcf_variant_t() {
    assert_eq!(
        ::std::mem::size_of::<bcf_variant_t>(),
        8usize,
        concat!("Size of: ", stringify!(bcf_variant_t))
    );
    assert_eq!(
        ::std::mem::align_of::<bcf_variant_t>(),
        4usize,
        concat!("Alignment of ", stringify!(bcf_variant_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_variant_t>())).type_ as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_variant_t),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_variant_t>())).n as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_variant_t),
            "::",
            stringify!(n)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct bcf_fmt_t {
    pub id: ::std::os::raw::c_int,
    pub n: ::std::os::raw::c_int,
    pub size: ::std::os::raw::c_int,
    pub type_: ::std::os::raw::c_int,
    pub p: *mut u8,
    pub p_len: u32,
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize], u32>,
}
#[test]
fn bindgen_test_layout_bcf_fmt_t() {
    assert_eq!(
        ::std::mem::size_of::<bcf_fmt_t>(),
        32usize,
        concat!("Size of: ", stringify!(bcf_fmt_t))
    );
    assert_eq!(
        ::std::mem::align_of::<bcf_fmt_t>(),
        8usize,
        concat!("Alignment of ", stringify!(bcf_fmt_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_fmt_t>())).id as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_fmt_t),
            "::",
            stringify!(id)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_fmt_t>())).n as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_fmt_t),
            "::",
            stringify!(n)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_fmt_t>())).size as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_fmt_t),
            "::",
            stringify!(size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_fmt_t>())).type_ as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_fmt_t),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_fmt_t>())).p as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_fmt_t),
            "::",
            stringify!(p)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_fmt_t>())).p_len as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_fmt_t),
            "::",
            stringify!(p_len)
        )
    );
}
impl bcf_fmt_t {
    #[inline]
    pub fn p_off(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 31u8) as u32) }
    }
    #[inline]
    pub fn set_p_off(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 31u8, val as u64)
        }
    }
    #[inline]
    pub fn p_free(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(31usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_p_free(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(31usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(p_off: u32, p_free: u32) -> __BindgenBitfieldUnit<[u8; 4usize], u32> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize], u32> =
            Default::default();
        __bindgen_bitfield_unit.set(0usize, 31u8, {
            let p_off: u32 = unsafe { ::std::mem::transmute(p_off) };
            p_off as u64
        });
        __bindgen_bitfield_unit.set(31usize, 1u8, {
            let p_free: u32 = unsafe { ::std::mem::transmute(p_free) };
            p_free as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct bcf_info_t {
    pub key: ::std::os::raw::c_int,
    pub type_: ::std::os::raw::c_int,
    pub v1: bcf_info_t__bindgen_ty_1,
    pub vptr: *mut u8,
    pub vptr_len: u32,
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize], u32>,
    pub len: ::std::os::raw::c_int,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union bcf_info_t__bindgen_ty_1 {
    pub i: i64,
    pub f: f32,
    _bindgen_union_align: u64,
}
#[test]
fn bindgen_test_layout_bcf_info_t__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<bcf_info_t__bindgen_ty_1>(),
        8usize,
        concat!("Size of: ", stringify!(bcf_info_t__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<bcf_info_t__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(bcf_info_t__bindgen_ty_1))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_info_t__bindgen_ty_1>())).i as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_info_t__bindgen_ty_1),
            "::",
            stringify!(i)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_info_t__bindgen_ty_1>())).f as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_info_t__bindgen_ty_1),
            "::",
            stringify!(f)
        )
    );
}
#[test]
fn bindgen_test_layout_bcf_info_t() {
    assert_eq!(
        ::std::mem::size_of::<bcf_info_t>(),
        40usize,
        concat!("Size of: ", stringify!(bcf_info_t))
    );
    assert_eq!(
        ::std::mem::align_of::<bcf_info_t>(),
        8usize,
        concat!("Alignment of ", stringify!(bcf_info_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_info_t>())).key as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_info_t),
            "::",
            stringify!(key)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_info_t>())).type_ as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_info_t),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_info_t>())).v1 as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_info_t),
            "::",
            stringify!(v1)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_info_t>())).vptr as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_info_t),
            "::",
            stringify!(vptr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_info_t>())).vptr_len as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_info_t),
            "::",
            stringify!(vptr_len)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_info_t>())).len as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_info_t),
            "::",
            stringify!(len)
        )
    );
}
impl bcf_info_t {
    #[inline]
    pub fn vptr_off(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 31u8) as u32) }
    }
    #[inline]
    pub fn set_vptr_off(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 31u8, val as u64)
        }
    }
    #[inline]
    pub fn vptr_free(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(31usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_vptr_free(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(31usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        vptr_off: u32,
        vptr_free: u32,
    ) -> __BindgenBitfieldUnit<[u8; 4usize], u32> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize], u32> =
            Default::default();
        __bindgen_bitfield_unit.set(0usize, 31u8, {
            let vptr_off: u32 = unsafe { ::std::mem::transmute(vptr_off) };
            vptr_off as u64
        });
        __bindgen_bitfield_unit.set(31usize, 1u8, {
            let vptr_free: u32 = unsafe { ::std::mem::transmute(vptr_free) };
            vptr_free as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct bcf_dec_t {
    pub m_fmt: ::std::os::raw::c_int,
    pub m_info: ::std::os::raw::c_int,
    pub m_id: ::std::os::raw::c_int,
    pub m_als: ::std::os::raw::c_int,
    pub m_allele: ::std::os::raw::c_int,
    pub m_flt: ::std::os::raw::c_int,
    pub n_flt: ::std::os::raw::c_int,
    pub flt: *mut ::std::os::raw::c_int,
    pub id: *mut ::std::os::raw::c_char,
    pub als: *mut ::std::os::raw::c_char,
    pub allele: *mut *mut ::std::os::raw::c_char,
    pub info: *mut bcf_info_t,
    pub fmt: *mut bcf_fmt_t,
    pub var: *mut bcf_variant_t,
    pub n_var: ::std::os::raw::c_int,
    pub var_type: ::std::os::raw::c_int,
    pub shared_dirty: ::std::os::raw::c_int,
    pub indiv_dirty: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_bcf_dec_t() {
    assert_eq!(
        ::std::mem::size_of::<bcf_dec_t>(),
        104usize,
        concat!("Size of: ", stringify!(bcf_dec_t))
    );
    assert_eq!(
        ::std::mem::align_of::<bcf_dec_t>(),
        8usize,
        concat!("Alignment of ", stringify!(bcf_dec_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_dec_t>())).m_fmt as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_dec_t),
            "::",
            stringify!(m_fmt)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_dec_t>())).m_info as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_dec_t),
            "::",
            stringify!(m_info)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_dec_t>())).m_id as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_dec_t),
            "::",
            stringify!(m_id)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_dec_t>())).m_als as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_dec_t),
            "::",
            stringify!(m_als)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_dec_t>())).m_allele as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_dec_t),
            "::",
            stringify!(m_allele)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_dec_t>())).m_flt as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_dec_t),
            "::",
            stringify!(m_flt)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_dec_t>())).n_flt as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_dec_t),
            "::",
            stringify!(n_flt)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_dec_t>())).flt as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_dec_t),
            "::",
            stringify!(flt)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_dec_t>())).id as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_dec_t),
            "::",
            stringify!(id)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_dec_t>())).als as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_dec_t),
            "::",
            stringify!(als)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_dec_t>())).allele as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_dec_t),
            "::",
            stringify!(allele)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_dec_t>())).info as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_dec_t),
            "::",
            stringify!(info)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_dec_t>())).fmt as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_dec_t),
            "::",
            stringify!(fmt)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_dec_t>())).var as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_dec_t),
            "::",
            stringify!(var)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_dec_t>())).n_var as *const _ as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_dec_t),
            "::",
            stringify!(n_var)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_dec_t>())).var_type as *const _ as usize },
        92usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_dec_t),
            "::",
            stringify!(var_type)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_dec_t>())).shared_dirty as *const _ as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_dec_t),
            "::",
            stringify!(shared_dirty)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_dec_t>())).indiv_dirty as *const _ as usize },
        100usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_dec_t),
            "::",
            stringify!(indiv_dirty)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct bcf1_t {
    pub pos: hts_pos_t,
    pub rlen: hts_pos_t,
    pub rid: i32,
    pub qual: f32,
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 8usize], u32>,
    pub shared: kstring_t,
    pub indiv: kstring_t,
    pub d: bcf_dec_t,
    pub max_unpack: ::std::os::raw::c_int,
    pub unpacked: ::std::os::raw::c_int,
    pub unpack_size: [::std::os::raw::c_int; 3usize],
    pub errcode: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_bcf1_t() {
    assert_eq!(
        ::std::mem::size_of::<bcf1_t>(),
        208usize,
        concat!("Size of: ", stringify!(bcf1_t))
    );
    assert_eq!(
        ::std::mem::align_of::<bcf1_t>(),
        8usize,
        concat!("Alignment of ", stringify!(bcf1_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf1_t>())).pos as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf1_t),
            "::",
            stringify!(pos)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf1_t>())).rlen as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf1_t),
            "::",
            stringify!(rlen)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf1_t>())).rid as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf1_t),
            "::",
            stringify!(rid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf1_t>())).qual as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf1_t),
            "::",
            stringify!(qual)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf1_t>())).shared as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf1_t),
            "::",
            stringify!(shared)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf1_t>())).indiv as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf1_t),
            "::",
            stringify!(indiv)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf1_t>())).d as *const _ as usize },
        80usize,
        concat!("Offset of field: ", stringify!(bcf1_t), "::", stringify!(d))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf1_t>())).max_unpack as *const _ as usize },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf1_t),
            "::",
            stringify!(max_unpack)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf1_t>())).unpacked as *const _ as usize },
        188usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf1_t),
            "::",
            stringify!(unpacked)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf1_t>())).unpack_size as *const _ as usize },
        192usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf1_t),
            "::",
            stringify!(unpack_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf1_t>())).errcode as *const _ as usize },
        204usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf1_t),
            "::",
            stringify!(errcode)
        )
    );
}
impl bcf1_t {
    #[inline]
    pub fn n_info(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 16u8) as u32) }
    }
    #[inline]
    pub fn set_n_info(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 16u8, val as u64)
        }
    }
    #[inline]
    pub fn n_allele(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(16usize, 16u8) as u32) }
    }
    #[inline]
    pub fn set_n_allele(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(16usize, 16u8, val as u64)
        }
    }
    #[inline]
    pub fn n_fmt(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(32usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_n_fmt(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(32usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn n_sample(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(40usize, 24u8) as u32) }
    }
    #[inline]
    pub fn set_n_sample(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(40usize, 24u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        n_info: u32,
        n_allele: u32,
        n_fmt: u32,
        n_sample: u32,
    ) -> __BindgenBitfieldUnit<[u8; 8usize], u32> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 8usize], u32> =
            Default::default();
        __bindgen_bitfield_unit.set(0usize, 16u8, {
            let n_info: u32 = unsafe { ::std::mem::transmute(n_info) };
            n_info as u64
        });
        __bindgen_bitfield_unit.set(16usize, 16u8, {
            let n_allele: u32 = unsafe { ::std::mem::transmute(n_allele) };
            n_allele as u64
        });
        __bindgen_bitfield_unit.set(32usize, 8u8, {
            let n_fmt: u32 = unsafe { ::std::mem::transmute(n_fmt) };
            n_fmt as u64
        });
        __bindgen_bitfield_unit.set(40usize, 24u8, {
            let n_sample: u32 = unsafe { ::std::mem::transmute(n_sample) };
            n_sample as u64
        });
        __bindgen_bitfield_unit
    }
}
extern "C" {
    pub fn bcf_hdr_init(mode: *const ::std::os::raw::c_char) -> *mut bcf_hdr_t;
}
extern "C" {
    pub fn bcf_hdr_destroy(h: *mut bcf_hdr_t);
}
extern "C" {
    pub fn bcf_init() -> *mut bcf1_t;
}
extern "C" {
    pub fn bcf_destroy(v: *mut bcf1_t);
}
extern "C" {
    pub fn bcf_empty(v: *mut bcf1_t);
}
extern "C" {
    pub fn bcf_clear(v: *mut bcf1_t);
}
pub type vcfFile = htsFile;
extern "C" {
    pub fn bcf_hdr_read(fp: *mut htsFile) -> *mut bcf_hdr_t;
}
extern "C" {
    pub fn bcf_hdr_set_samples(
        hdr: *mut bcf_hdr_t,
        samples: *const ::std::os::raw::c_char,
        is_file: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcf_subset_format(hdr: *const bcf_hdr_t, rec: *mut bcf1_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcf_hdr_write(fp: *mut htsFile, h: *mut bcf_hdr_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn vcf_parse(
        s: *mut kstring_t,
        h: *const bcf_hdr_t,
        v: *mut bcf1_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn vcf_open_mode(
        mode: *mut ::std::os::raw::c_char,
        fn_: *const ::std::os::raw::c_char,
        format: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn vcf_format(
        h: *const bcf_hdr_t,
        v: *const bcf1_t,
        s: *mut kstring_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcf_read(fp: *mut htsFile, h: *const bcf_hdr_t, v: *mut bcf1_t)
        -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcf_unpack(b: *mut bcf1_t, which: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcf_dup(src: *mut bcf1_t) -> *mut bcf1_t;
}
extern "C" {
    pub fn bcf_copy(dst: *mut bcf1_t, src: *mut bcf1_t) -> *mut bcf1_t;
}
extern "C" {
    pub fn bcf_write(fp: *mut htsFile, h: *mut bcf_hdr_t, v: *mut bcf1_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn vcf_hdr_read(fp: *mut htsFile) -> *mut bcf_hdr_t;
}
extern "C" {
    pub fn vcf_hdr_write(fp: *mut htsFile, h: *const bcf_hdr_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn vcf_read(fp: *mut htsFile, h: *const bcf_hdr_t, v: *mut bcf1_t)
        -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn vcf_write(
        fp: *mut htsFile,
        h: *const bcf_hdr_t,
        v: *mut bcf1_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcf_readrec(
        fp: *mut BGZF,
        null: *mut ::std::os::raw::c_void,
        v: *mut ::std::os::raw::c_void,
        tid: *mut ::std::os::raw::c_int,
        beg: *mut hts_pos_t,
        end: *mut hts_pos_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn vcf_write_line(fp: *mut htsFile, line: *mut kstring_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcf_hdr_dup(hdr: *const bcf_hdr_t) -> *mut bcf_hdr_t;
}
extern "C" {
    pub fn bcf_hdr_combine(dst: *mut bcf_hdr_t, src: *const bcf_hdr_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcf_hdr_merge(dst: *mut bcf_hdr_t, src: *const bcf_hdr_t) -> *mut bcf_hdr_t;
}
extern "C" {
    pub fn bcf_hdr_add_sample(
        hdr: *mut bcf_hdr_t,
        sample: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcf_hdr_set(
        hdr: *mut bcf_hdr_t,
        fname: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcf_hdr_format(
        hdr: *const bcf_hdr_t,
        is_bcf: ::std::os::raw::c_int,
        str: *mut kstring_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcf_hdr_fmt_text(
        hdr: *const bcf_hdr_t,
        is_bcf: ::std::os::raw::c_int,
        len: *mut ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn bcf_hdr_append(
        h: *mut bcf_hdr_t,
        line: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcf_hdr_printf(
        h: *mut bcf_hdr_t,
        format: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcf_hdr_get_version(hdr: *const bcf_hdr_t) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn bcf_hdr_set_version(
        hdr: *mut bcf_hdr_t,
        version: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcf_hdr_remove(
        h: *mut bcf_hdr_t,
        type_: ::std::os::raw::c_int,
        key: *const ::std::os::raw::c_char,
    );
}
extern "C" {
    pub fn bcf_hdr_subset(
        h0: *const bcf_hdr_t,
        n: ::std::os::raw::c_int,
        samples: *const *mut ::std::os::raw::c_char,
        imap: *mut ::std::os::raw::c_int,
    ) -> *mut bcf_hdr_t;
}
extern "C" {
    pub fn bcf_hdr_seqnames(
        h: *const bcf_hdr_t,
        nseqs: *mut ::std::os::raw::c_int,
    ) -> *mut *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn bcf_hdr_parse(
        hdr: *mut bcf_hdr_t,
        htxt: *mut ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcf_hdr_sync(h: *mut bcf_hdr_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcf_hdr_parse_line(
        h: *const bcf_hdr_t,
        line: *const ::std::os::raw::c_char,
        len: *mut ::std::os::raw::c_int,
    ) -> *mut bcf_hrec_t;
}
extern "C" {
    pub fn bcf_hrec_format(hrec: *const bcf_hrec_t, str: *mut kstring_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcf_hdr_add_hrec(hdr: *mut bcf_hdr_t, hrec: *mut bcf_hrec_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcf_hdr_get_hrec(
        hdr: *const bcf_hdr_t,
        type_: ::std::os::raw::c_int,
        key: *const ::std::os::raw::c_char,
        value: *const ::std::os::raw::c_char,
        str_class: *const ::std::os::raw::c_char,
    ) -> *mut bcf_hrec_t;
}
extern "C" {
    pub fn bcf_hrec_dup(hrec: *mut bcf_hrec_t) -> *mut bcf_hrec_t;
}
extern "C" {
    pub fn bcf_hrec_add_key(
        hrec: *mut bcf_hrec_t,
        str: *const ::std::os::raw::c_char,
        len: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcf_hrec_set_val(
        hrec: *mut bcf_hrec_t,
        i: ::std::os::raw::c_int,
        str: *const ::std::os::raw::c_char,
        len: size_t,
        is_quoted: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcf_hrec_find_key(
        hrec: *mut bcf_hrec_t,
        key: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn hrec_add_idx(hrec: *mut bcf_hrec_t, idx: ::std::os::raw::c_int)
        -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcf_hrec_destroy(hrec: *mut bcf_hrec_t);
}
extern "C" {
    pub fn bcf_subset(
        h: *const bcf_hdr_t,
        v: *mut bcf1_t,
        n: ::std::os::raw::c_int,
        imap: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcf_translate(
        dst_hdr: *const bcf_hdr_t,
        src_hdr: *mut bcf_hdr_t,
        src_line: *mut bcf1_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcf_get_variant_types(rec: *mut bcf1_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcf_get_variant_type(
        rec: *mut bcf1_t,
        ith_allele: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcf_is_snp(v: *mut bcf1_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcf_update_filter(
        hdr: *const bcf_hdr_t,
        line: *mut bcf1_t,
        flt_ids: *mut ::std::os::raw::c_int,
        n: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcf_add_filter(
        hdr: *const bcf_hdr_t,
        line: *mut bcf1_t,
        flt_id: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcf_remove_filter(
        hdr: *const bcf_hdr_t,
        line: *mut bcf1_t,
        flt_id: ::std::os::raw::c_int,
        pass: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcf_has_filter(
        hdr: *const bcf_hdr_t,
        line: *mut bcf1_t,
        filter: *mut ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcf_update_alleles(
        hdr: *const bcf_hdr_t,
        line: *mut bcf1_t,
        alleles: *mut *const ::std::os::raw::c_char,
        nals: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcf_update_alleles_str(
        hdr: *const bcf_hdr_t,
        line: *mut bcf1_t,
        alleles_string: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcf_update_id(
        hdr: *const bcf_hdr_t,
        line: *mut bcf1_t,
        id: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcf_add_id(
        hdr: *const bcf_hdr_t,
        line: *mut bcf1_t,
        id: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcf_update_info(
        hdr: *const bcf_hdr_t,
        line: *mut bcf1_t,
        key: *const ::std::os::raw::c_char,
        values: *const ::std::os::raw::c_void,
        n: ::std::os::raw::c_int,
        type_: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcf_update_format_string(
        hdr: *const bcf_hdr_t,
        line: *mut bcf1_t,
        key: *const ::std::os::raw::c_char,
        values: *mut *const ::std::os::raw::c_char,
        n: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcf_update_format(
        hdr: *const bcf_hdr_t,
        line: *mut bcf1_t,
        key: *const ::std::os::raw::c_char,
        values: *const ::std::os::raw::c_void,
        n: ::std::os::raw::c_int,
        type_: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcf_get_fmt(
        hdr: *const bcf_hdr_t,
        line: *mut bcf1_t,
        key: *const ::std::os::raw::c_char,
    ) -> *mut bcf_fmt_t;
}
extern "C" {
    pub fn bcf_get_info(
        hdr: *const bcf_hdr_t,
        line: *mut bcf1_t,
        key: *const ::std::os::raw::c_char,
    ) -> *mut bcf_info_t;
}
extern "C" {
    pub fn bcf_get_fmt_id(line: *mut bcf1_t, id: ::std::os::raw::c_int) -> *mut bcf_fmt_t;
}
extern "C" {
    pub fn bcf_get_info_id(line: *mut bcf1_t, id: ::std::os::raw::c_int) -> *mut bcf_info_t;
}
extern "C" {
    pub fn bcf_get_info_values(
        hdr: *const bcf_hdr_t,
        line: *mut bcf1_t,
        tag: *const ::std::os::raw::c_char,
        dst: *mut *mut ::std::os::raw::c_void,
        ndst: *mut ::std::os::raw::c_int,
        type_: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcf_get_format_string(
        hdr: *const bcf_hdr_t,
        line: *mut bcf1_t,
        tag: *const ::std::os::raw::c_char,
        dst: *mut *mut *mut ::std::os::raw::c_char,
        ndst: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcf_get_format_values(
        hdr: *const bcf_hdr_t,
        line: *mut bcf1_t,
        tag: *const ::std::os::raw::c_char,
        dst: *mut *mut ::std::os::raw::c_void,
        ndst: *mut ::std::os::raw::c_int,
        type_: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcf_hdr_id2int(
        hdr: *const bcf_hdr_t,
        type_: ::std::os::raw::c_int,
        id: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcf_fmt_array(
        s: *mut kstring_t,
        n: ::std::os::raw::c_int,
        type_: ::std::os::raw::c_int,
        data: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcf_fmt_sized_array(s: *mut kstring_t, ptr: *mut u8) -> *mut u8;
}
extern "C" {
    pub fn bcf_enc_vchar(
        s: *mut kstring_t,
        l: ::std::os::raw::c_int,
        a: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcf_enc_vint(
        s: *mut kstring_t,
        n: ::std::os::raw::c_int,
        a: *mut i32,
        wsize: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcf_enc_vfloat(
        s: *mut kstring_t,
        n: ::std::os::raw::c_int,
        a: *mut f32,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcf_index_load2(
        fn_: *const ::std::os::raw::c_char,
        fnidx: *const ::std::os::raw::c_char,
    ) -> *mut hts_idx_t;
}
extern "C" {
    pub fn bcf_index_load3(
        fn_: *const ::std::os::raw::c_char,
        fnidx: *const ::std::os::raw::c_char,
        flags: ::std::os::raw::c_int,
    ) -> *mut hts_idx_t;
}
extern "C" {
    pub fn bcf_index_build(
        fn_: *const ::std::os::raw::c_char,
        min_shift: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcf_index_build2(
        fn_: *const ::std::os::raw::c_char,
        fnidx: *const ::std::os::raw::c_char,
        min_shift: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcf_index_build3(
        fn_: *const ::std::os::raw::c_char,
        fnidx: *const ::std::os::raw::c_char,
        min_shift: ::std::os::raw::c_int,
        n_threads: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcf_idx_init(
        fp: *mut htsFile,
        h: *mut bcf_hdr_t,
        min_shift: ::std::os::raw::c_int,
        fnidx: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcf_idx_save(fp: *mut htsFile) -> ::std::os::raw::c_int;
}
extern "C" {
    pub static mut bcf_float_vector_end: u32;
}
extern "C" {
    pub static mut bcf_float_missing: u32;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct sam_hrecs_t {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct sam_hdr_t {
    pub n_targets: i32,
    pub ignore_sam_err: i32,
    pub l_text: size_t,
    pub target_len: *mut u32,
    pub cigar_tab: *const i8,
    pub target_name: *mut *mut ::std::os::raw::c_char,
    pub text: *mut ::std::os::raw::c_char,
    pub sdict: *mut ::std::os::raw::c_void,
    pub hrecs: *mut sam_hrecs_t,
    pub ref_count: u32,
}
#[test]
fn bindgen_test_layout_sam_hdr_t() {
    assert_eq!(
        ::std::mem::size_of::<sam_hdr_t>(),
        72usize,
        concat!("Size of: ", stringify!(sam_hdr_t))
    );
    assert_eq!(
        ::std::mem::align_of::<sam_hdr_t>(),
        8usize,
        concat!("Alignment of ", stringify!(sam_hdr_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sam_hdr_t>())).n_targets as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(sam_hdr_t),
            "::",
            stringify!(n_targets)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sam_hdr_t>())).ignore_sam_err as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(sam_hdr_t),
            "::",
            stringify!(ignore_sam_err)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sam_hdr_t>())).l_text as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(sam_hdr_t),
            "::",
            stringify!(l_text)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sam_hdr_t>())).target_len as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(sam_hdr_t),
            "::",
            stringify!(target_len)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sam_hdr_t>())).cigar_tab as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(sam_hdr_t),
            "::",
            stringify!(cigar_tab)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sam_hdr_t>())).target_name as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(sam_hdr_t),
            "::",
            stringify!(target_name)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sam_hdr_t>())).text as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(sam_hdr_t),
            "::",
            stringify!(text)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sam_hdr_t>())).sdict as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(sam_hdr_t),
            "::",
            stringify!(sdict)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sam_hdr_t>())).hrecs as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(sam_hdr_t),
            "::",
            stringify!(hrecs)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sam_hdr_t>())).ref_count as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(sam_hdr_t),
            "::",
            stringify!(ref_count)
        )
    );
}
pub type bam_hdr_t = sam_hdr_t;
extern "C" {
    pub static bam_cigar_table: [i8; 256usize];
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct bam1_core_t {
    pub pos: hts_pos_t,
    pub tid: i32,
    pub bin: u16,
    pub qual: u8,
    pub l_extranul: u8,
    pub flag: u16,
    pub l_qname: u16,
    pub n_cigar: u32,
    pub l_qseq: i32,
    pub mtid: i32,
    pub mpos: hts_pos_t,
    pub isize: hts_pos_t,
}
#[test]
fn bindgen_test_layout_bam1_core_t() {
    assert_eq!(
        ::std::mem::size_of::<bam1_core_t>(),
        48usize,
        concat!("Size of: ", stringify!(bam1_core_t))
    );
    assert_eq!(
        ::std::mem::align_of::<bam1_core_t>(),
        8usize,
        concat!("Alignment of ", stringify!(bam1_core_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bam1_core_t>())).pos as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bam1_core_t),
            "::",
            stringify!(pos)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bam1_core_t>())).tid as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(bam1_core_t),
            "::",
            stringify!(tid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bam1_core_t>())).bin as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(bam1_core_t),
            "::",
            stringify!(bin)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bam1_core_t>())).qual as *const _ as usize },
        14usize,
        concat!(
            "Offset of field: ",
            stringify!(bam1_core_t),
            "::",
            stringify!(qual)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bam1_core_t>())).l_extranul as *const _ as usize },
        15usize,
        concat!(
            "Offset of field: ",
            stringify!(bam1_core_t),
            "::",
            stringify!(l_extranul)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bam1_core_t>())).flag as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(bam1_core_t),
            "::",
            stringify!(flag)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bam1_core_t>())).l_qname as *const _ as usize },
        18usize,
        concat!(
            "Offset of field: ",
            stringify!(bam1_core_t),
            "::",
            stringify!(l_qname)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bam1_core_t>())).n_cigar as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(bam1_core_t),
            "::",
            stringify!(n_cigar)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bam1_core_t>())).l_qseq as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(bam1_core_t),
            "::",
            stringify!(l_qseq)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bam1_core_t>())).mtid as *const _ as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(bam1_core_t),
            "::",
            stringify!(mtid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bam1_core_t>())).mpos as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(bam1_core_t),
            "::",
            stringify!(mpos)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bam1_core_t>())).isize as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(bam1_core_t),
            "::",
            stringify!(isize)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct bam1_t {
    pub core: bam1_core_t,
    pub id: u64,
    pub data: *mut u8,
    pub l_data: ::std::os::raw::c_int,
    pub m_data: u32,
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize], u8>,
    pub __bindgen_padding_0: u32,
}
#[test]
fn bindgen_test_layout_bam1_t() {
    assert_eq!(
        ::std::mem::size_of::<bam1_t>(),
        80usize,
        concat!("Size of: ", stringify!(bam1_t))
    );
    assert_eq!(
        ::std::mem::align_of::<bam1_t>(),
        8usize,
        concat!("Alignment of ", stringify!(bam1_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bam1_t>())).core as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bam1_t),
            "::",
            stringify!(core)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bam1_t>())).id as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(bam1_t),
            "::",
            stringify!(id)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bam1_t>())).data as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(bam1_t),
            "::",
            stringify!(data)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bam1_t>())).l_data as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(bam1_t),
            "::",
            stringify!(l_data)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bam1_t>())).m_data as *const _ as usize },
        68usize,
        concat!(
            "Offset of field: ",
            stringify!(bam1_t),
            "::",
            stringify!(m_data)
        )
    );
}
impl bam1_t {
    #[inline]
    pub fn mempolicy(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 2u8) as u32) }
    }
    #[inline]
    pub fn set_mempolicy(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(mempolicy: u32) -> __BindgenBitfieldUnit<[u8; 4usize], u8> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize], u8> =
            Default::default();
        __bindgen_bitfield_unit.set(0usize, 2u8, {
            let mempolicy: u32 = unsafe { ::std::mem::transmute(mempolicy) };
            mempolicy as u64
        });
        __bindgen_bitfield_unit
    }
}
extern "C" {
    pub fn sam_hdr_init() -> *mut sam_hdr_t;
}
extern "C" {
    pub fn bam_hdr_read(fp: *mut BGZF) -> *mut sam_hdr_t;
}
extern "C" {
    pub fn bam_hdr_write(fp: *mut BGZF, h: *const sam_hdr_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sam_hdr_destroy(h: *mut sam_hdr_t);
}
extern "C" {
    pub fn sam_hdr_dup(h0: *const sam_hdr_t) -> *mut sam_hdr_t;
}
pub type samFile = htsFile;
extern "C" {
    pub fn sam_hdr_parse(l_text: size_t, text: *const ::std::os::raw::c_char) -> *mut sam_hdr_t;
}
extern "C" {
    pub fn sam_hdr_read(fp: *mut samFile) -> *mut sam_hdr_t;
}
extern "C" {
    pub fn sam_hdr_write(fp: *mut samFile, h: *const sam_hdr_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sam_hdr_length(h: *mut sam_hdr_t) -> size_t;
}
extern "C" {
    pub fn sam_hdr_str(h: *mut sam_hdr_t) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn sam_hdr_nref(h: *const sam_hdr_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sam_hdr_add_lines(
        h: *mut sam_hdr_t,
        lines: *const ::std::os::raw::c_char,
        len: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sam_hdr_add_line(
        h: *mut sam_hdr_t,
        type_: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sam_hdr_find_line_id(
        h: *mut sam_hdr_t,
        type_: *const ::std::os::raw::c_char,
        ID_key: *const ::std::os::raw::c_char,
        ID_val: *const ::std::os::raw::c_char,
        ks: *mut kstring_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sam_hdr_find_line_pos(
        h: *mut sam_hdr_t,
        type_: *const ::std::os::raw::c_char,
        pos: ::std::os::raw::c_int,
        ks: *mut kstring_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sam_hdr_remove_line_id(
        h: *mut sam_hdr_t,
        type_: *const ::std::os::raw::c_char,
        ID_key: *const ::std::os::raw::c_char,
        ID_value: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sam_hdr_remove_line_pos(
        h: *mut sam_hdr_t,
        type_: *const ::std::os::raw::c_char,
        position: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sam_hdr_update_line(
        h: *mut sam_hdr_t,
        type_: *const ::std::os::raw::c_char,
        ID_key: *const ::std::os::raw::c_char,
        ID_value: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sam_hdr_remove_except(
        h: *mut sam_hdr_t,
        type_: *const ::std::os::raw::c_char,
        ID_key: *const ::std::os::raw::c_char,
        ID_value: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sam_hdr_remove_lines(
        h: *mut sam_hdr_t,
        type_: *const ::std::os::raw::c_char,
        id: *const ::std::os::raw::c_char,
        rh: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sam_hdr_count_lines(
        h: *mut sam_hdr_t,
        type_: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sam_hdr_line_index(
        bh: *mut sam_hdr_t,
        type_: *const ::std::os::raw::c_char,
        key: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sam_hdr_line_name(
        bh: *mut sam_hdr_t,
        type_: *const ::std::os::raw::c_char,
        pos: ::std::os::raw::c_int,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn sam_hdr_find_tag_id(
        h: *mut sam_hdr_t,
        type_: *const ::std::os::raw::c_char,
        ID_key: *const ::std::os::raw::c_char,
        ID_value: *const ::std::os::raw::c_char,
        key: *const ::std::os::raw::c_char,
        ks: *mut kstring_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sam_hdr_find_tag_pos(
        h: *mut sam_hdr_t,
        type_: *const ::std::os::raw::c_char,
        pos: ::std::os::raw::c_int,
        key: *const ::std::os::raw::c_char,
        ks: *mut kstring_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sam_hdr_remove_tag_id(
        h: *mut sam_hdr_t,
        type_: *const ::std::os::raw::c_char,
        ID_key: *const ::std::os::raw::c_char,
        ID_value: *const ::std::os::raw::c_char,
        key: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sam_hdr_name2tid(
        h: *mut sam_hdr_t,
        ref_: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sam_hdr_tid2name(
        h: *const sam_hdr_t,
        tid: ::std::os::raw::c_int,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn sam_hdr_tid2len(h: *const sam_hdr_t, tid: ::std::os::raw::c_int) -> hts_pos_t;
}
extern "C" {
    pub fn sam_hdr_pg_id(
        h: *mut sam_hdr_t,
        name: *const ::std::os::raw::c_char,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn sam_hdr_add_pg(
        h: *mut sam_hdr_t,
        name: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn stringify_argv(
        argc: ::std::os::raw::c_int,
        argv: *mut *mut ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn sam_hdr_incr_ref(h: *mut sam_hdr_t);
}
extern "C" {
    pub fn bam_init1() -> *mut bam1_t;
}
extern "C" {
    pub fn bam_destroy1(b: *mut bam1_t);
}
extern "C" {
    pub fn bam_read1(fp: *mut BGZF, b: *mut bam1_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bam_write1(fp: *mut BGZF, b: *const bam1_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bam_copy1(bdst: *mut bam1_t, bsrc: *const bam1_t) -> *mut bam1_t;
}
extern "C" {
    pub fn bam_dup1(bsrc: *const bam1_t) -> *mut bam1_t;
}
extern "C" {
    pub fn bam_set1(
        bam: *mut bam1_t,
        l_qname: size_t,
        qname: *const ::std::os::raw::c_char,
        flag: u16,
        tid: i32,
        pos: hts_pos_t,
        mapq: u8,
        n_cigar: size_t,
        cigar: *const u32,
        mtid: i32,
        mpos: hts_pos_t,
        isize: hts_pos_t,
        l_seq: size_t,
        seq: *const ::std::os::raw::c_char,
        qual: *const ::std::os::raw::c_char,
        l_aux: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bam_cigar2qlen(n_cigar: ::std::os::raw::c_int, cigar: *const u32) -> hts_pos_t;
}
extern "C" {
    pub fn bam_cigar2rlen(n_cigar: ::std::os::raw::c_int, cigar: *const u32) -> hts_pos_t;
}
extern "C" {
    pub fn bam_endpos(b: *const bam1_t) -> hts_pos_t;
}
extern "C" {
    pub fn bam_str2flag(str: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bam_flag2str(flag: ::std::os::raw::c_int) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn bam_set_qname(
        b: *mut bam1_t,
        qname: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sam_idx_init(
        fp: *mut htsFile,
        h: *mut sam_hdr_t,
        min_shift: ::std::os::raw::c_int,
        fnidx: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sam_idx_save(fp: *mut htsFile) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sam_index_load(fp: *mut htsFile, fn_: *const ::std::os::raw::c_char) -> *mut hts_idx_t;
}
extern "C" {
    pub fn sam_index_load2(
        fp: *mut htsFile,
        fn_: *const ::std::os::raw::c_char,
        fnidx: *const ::std::os::raw::c_char,
    ) -> *mut hts_idx_t;
}
extern "C" {
    pub fn sam_index_load3(
        fp: *mut htsFile,
        fn_: *const ::std::os::raw::c_char,
        fnidx: *const ::std::os::raw::c_char,
        flags: ::std::os::raw::c_int,
    ) -> *mut hts_idx_t;
}
extern "C" {
    pub fn sam_index_build(
        fn_: *const ::std::os::raw::c_char,
        min_shift: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sam_index_build2(
        fn_: *const ::std::os::raw::c_char,
        fnidx: *const ::std::os::raw::c_char,
        min_shift: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sam_index_build3(
        fn_: *const ::std::os::raw::c_char,
        fnidx: *const ::std::os::raw::c_char,
        min_shift: ::std::os::raw::c_int,
        nthreads: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sam_itr_queryi(
        idx: *const hts_idx_t,
        tid: ::std::os::raw::c_int,
        beg: hts_pos_t,
        end: hts_pos_t,
    ) -> *mut hts_itr_t;
}
extern "C" {
    pub fn sam_itr_querys(
        idx: *const hts_idx_t,
        hdr: *mut sam_hdr_t,
        region: *const ::std::os::raw::c_char,
    ) -> *mut hts_itr_t;
}
extern "C" {
    pub fn sam_itr_regions(
        idx: *const hts_idx_t,
        hdr: *mut sam_hdr_t,
        reglist: *mut hts_reglist_t,
        regcount: ::std::os::raw::c_uint,
    ) -> *mut hts_itr_t;
}
extern "C" {
    pub fn sam_itr_regarray(
        idx: *const hts_idx_t,
        hdr: *mut sam_hdr_t,
        regarray: *mut *mut ::std::os::raw::c_char,
        regcount: ::std::os::raw::c_uint,
    ) -> *mut hts_itr_t;
}
extern "C" {
    pub fn sam_parse_region(
        h: *mut sam_hdr_t,
        s: *const ::std::os::raw::c_char,
        tid: *mut ::std::os::raw::c_int,
        beg: *mut hts_pos_t,
        end: *mut hts_pos_t,
        flags: ::std::os::raw::c_int,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn sam_open_mode(
        mode: *mut ::std::os::raw::c_char,
        fn_: *const ::std::os::raw::c_char,
        format: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sam_open_mode_opts(
        fn_: *const ::std::os::raw::c_char,
        mode: *const ::std::os::raw::c_char,
        format: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn sam_hdr_change_HD(
        h: *mut sam_hdr_t,
        key: *const ::std::os::raw::c_char,
        val: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sam_parse1(
        s: *mut kstring_t,
        h: *mut sam_hdr_t,
        b: *mut bam1_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sam_format1(
        h: *const sam_hdr_t,
        b: *const bam1_t,
        str: *mut kstring_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sam_read1(fp: *mut samFile, h: *mut sam_hdr_t, b: *mut bam1_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sam_write1(
        fp: *mut samFile,
        h: *const sam_hdr_t,
        b: *const bam1_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bam_aux_get(b: *const bam1_t, tag: *const ::std::os::raw::c_char) -> *mut u8;
}
extern "C" {
    pub fn bam_aux2i(s: *const u8) -> i64;
}
extern "C" {
    pub fn bam_aux2f(s: *const u8) -> f64;
}
extern "C" {
    pub fn bam_aux2A(s: *const u8) -> ::std::os::raw::c_char;
}
extern "C" {
    pub fn bam_aux2Z(s: *const u8) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn bam_auxB_len(s: *const u8) -> u32;
}
extern "C" {
    pub fn bam_auxB2i(s: *const u8, idx: u32) -> i64;
}
extern "C" {
    pub fn bam_auxB2f(s: *const u8, idx: u32) -> f64;
}
extern "C" {
    pub fn bam_aux_append(
        b: *mut bam1_t,
        tag: *const ::std::os::raw::c_char,
        type_: ::std::os::raw::c_char,
        len: ::std::os::raw::c_int,
        data: *const u8,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bam_aux_del(b: *mut bam1_t, s: *mut u8) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bam_aux_update_str(
        b: *mut bam1_t,
        tag: *const ::std::os::raw::c_char,
        len: ::std::os::raw::c_int,
        data: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bam_aux_update_int(
        b: *mut bam1_t,
        tag: *const ::std::os::raw::c_char,
        val: i64,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bam_aux_update_float(
        b: *mut bam1_t,
        tag: *const ::std::os::raw::c_char,
        val: f32,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bam_aux_update_array(
        b: *mut bam1_t,
        tag: *const ::std::os::raw::c_char,
        type_: u8,
        items: u32,
        data: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union bam_pileup_cd {
    pub p: *mut ::std::os::raw::c_void,
    pub i: i64,
    pub f: f64,
    _bindgen_union_align: u64,
}
#[test]
fn bindgen_test_layout_bam_pileup_cd() {
    assert_eq!(
        ::std::mem::size_of::<bam_pileup_cd>(),
        8usize,
        concat!("Size of: ", stringify!(bam_pileup_cd))
    );
    assert_eq!(
        ::std::mem::align_of::<bam_pileup_cd>(),
        8usize,
        concat!("Alignment of ", stringify!(bam_pileup_cd))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bam_pileup_cd>())).p as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bam_pileup_cd),
            "::",
            stringify!(p)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bam_pileup_cd>())).i as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bam_pileup_cd),
            "::",
            stringify!(i)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bam_pileup_cd>())).f as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bam_pileup_cd),
            "::",
            stringify!(f)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct bam_pileup1_t {
    pub b: *mut bam1_t,
    pub qpos: i32,
    pub indel: ::std::os::raw::c_int,
    pub level: ::std::os::raw::c_int,
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize], u32>,
    pub cd: bam_pileup_cd,
    pub cigar_ind: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_bam_pileup1_t() {
    assert_eq!(
        ::std::mem::size_of::<bam_pileup1_t>(),
        40usize,
        concat!("Size of: ", stringify!(bam_pileup1_t))
    );
    assert_eq!(
        ::std::mem::align_of::<bam_pileup1_t>(),
        8usize,
        concat!("Alignment of ", stringify!(bam_pileup1_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bam_pileup1_t>())).b as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bam_pileup1_t),
            "::",
            stringify!(b)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bam_pileup1_t>())).qpos as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(bam_pileup1_t),
            "::",
            stringify!(qpos)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bam_pileup1_t>())).indel as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(bam_pileup1_t),
            "::",
            stringify!(indel)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bam_pileup1_t>())).level as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(bam_pileup1_t),
            "::",
            stringify!(level)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bam_pileup1_t>())).cd as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(bam_pileup1_t),
            "::",
            stringify!(cd)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bam_pileup1_t>())).cigar_ind as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(bam_pileup1_t),
            "::",
            stringify!(cigar_ind)
        )
    );
}
impl bam_pileup1_t {
    #[inline]
    pub fn is_del(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_is_del(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn is_head(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_is_head(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn is_tail(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_is_tail(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn is_refskip(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_is_refskip(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn aux(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(5usize, 27u8) as u32) }
    }
    #[inline]
    pub fn set_aux(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(5usize, 27u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        is_del: u32,
        is_head: u32,
        is_tail: u32,
        is_refskip: u32,
        aux: u32,
    ) -> __BindgenBitfieldUnit<[u8; 4usize], u32> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize], u32> =
            Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let is_del: u32 = unsafe { ::std::mem::transmute(is_del) };
            is_del as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let is_head: u32 = unsafe { ::std::mem::transmute(is_head) };
            is_head as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let is_tail: u32 = unsafe { ::std::mem::transmute(is_tail) };
            is_tail as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let is_refskip: u32 = unsafe { ::std::mem::transmute(is_refskip) };
            is_refskip as u64
        });
        __bindgen_bitfield_unit.set(5usize, 27u8, {
            let aux: u32 = unsafe { ::std::mem::transmute(aux) };
            aux as u64
        });
        __bindgen_bitfield_unit
    }
}
pub type bam_plp_auto_f = ::std::option::Option<
    unsafe extern "C" fn(
        data: *mut ::std::os::raw::c_void,
        b: *mut bam1_t,
    ) -> ::std::os::raw::c_int,
>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct bam_plp_s {
    _unused: [u8; 0],
}
pub type bam_plp_t = *mut bam_plp_s;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct bam_mplp_s {
    _unused: [u8; 0],
}
pub type bam_mplp_t = *mut bam_mplp_s;
extern "C" {
    pub fn bam_plp_init(func: bam_plp_auto_f, data: *mut ::std::os::raw::c_void) -> bam_plp_t;
}
extern "C" {
    pub fn bam_plp_destroy(iter: bam_plp_t);
}
extern "C" {
    pub fn bam_plp_push(iter: bam_plp_t, b: *const bam1_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bam_plp_next(
        iter: bam_plp_t,
        _tid: *mut ::std::os::raw::c_int,
        _pos: *mut ::std::os::raw::c_int,
        _n_plp: *mut ::std::os::raw::c_int,
    ) -> *const bam_pileup1_t;
}
extern "C" {
    pub fn bam_plp_auto(
        iter: bam_plp_t,
        _tid: *mut ::std::os::raw::c_int,
        _pos: *mut ::std::os::raw::c_int,
        _n_plp: *mut ::std::os::raw::c_int,
    ) -> *const bam_pileup1_t;
}
extern "C" {
    pub fn bam_plp64_next(
        iter: bam_plp_t,
        _tid: *mut ::std::os::raw::c_int,
        _pos: *mut hts_pos_t,
        _n_plp: *mut ::std::os::raw::c_int,
    ) -> *const bam_pileup1_t;
}
extern "C" {
    pub fn bam_plp64_auto(
        iter: bam_plp_t,
        _tid: *mut ::std::os::raw::c_int,
        _pos: *mut hts_pos_t,
        _n_plp: *mut ::std::os::raw::c_int,
    ) -> *const bam_pileup1_t;
}
extern "C" {
    pub fn bam_plp_set_maxcnt(iter: bam_plp_t, maxcnt: ::std::os::raw::c_int);
}
extern "C" {
    pub fn bam_plp_reset(iter: bam_plp_t);
}
extern "C" {
    pub fn bam_plp_constructor(
        plp: bam_plp_t,
        func: ::std::option::Option<
            unsafe extern "C" fn(
                data: *mut ::std::os::raw::c_void,
                b: *const bam1_t,
                cd: *mut bam_pileup_cd,
            ) -> ::std::os::raw::c_int,
        >,
    );
}
extern "C" {
    pub fn bam_plp_destructor(
        plp: bam_plp_t,
        func: ::std::option::Option<
            unsafe extern "C" fn(
                data: *mut ::std::os::raw::c_void,
                b: *const bam1_t,
                cd: *mut bam_pileup_cd,
            ) -> ::std::os::raw::c_int,
        >,
    );
}
extern "C" {
    pub fn bam_plp_insertion(
        p: *const bam_pileup1_t,
        ins: *mut kstring_t,
        del_len: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bam_mplp_init(
        n: ::std::os::raw::c_int,
        func: bam_plp_auto_f,
        data: *mut *mut ::std::os::raw::c_void,
    ) -> bam_mplp_t;
}
extern "C" {
    pub fn bam_mplp_init_overlaps(iter: bam_mplp_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bam_mplp_destroy(iter: bam_mplp_t);
}
extern "C" {
    pub fn bam_mplp_set_maxcnt(iter: bam_mplp_t, maxcnt: ::std::os::raw::c_int);
}
extern "C" {
    pub fn bam_mplp_auto(
        iter: bam_mplp_t,
        _tid: *mut ::std::os::raw::c_int,
        _pos: *mut ::std::os::raw::c_int,
        n_plp: *mut ::std::os::raw::c_int,
        plp: *mut *const bam_pileup1_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bam_mplp64_auto(
        iter: bam_mplp_t,
        _tid: *mut ::std::os::raw::c_int,
        _pos: *mut hts_pos_t,
        n_plp: *mut ::std::os::raw::c_int,
        plp: *mut *const bam_pileup1_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bam_mplp_reset(iter: bam_mplp_t);
}
extern "C" {
    pub fn bam_mplp_constructor(
        iter: bam_mplp_t,
        func: ::std::option::Option<
            unsafe extern "C" fn(
                data: *mut ::std::os::raw::c_void,
                b: *const bam1_t,
                cd: *mut bam_pileup_cd,
            ) -> ::std::os::raw::c_int,
        >,
    );
}
extern "C" {
    pub fn bam_mplp_destructor(
        iter: bam_mplp_t,
        func: ::std::option::Option<
            unsafe extern "C" fn(
                data: *mut ::std::os::raw::c_void,
                b: *const bam1_t,
                cd: *mut bam_pileup_cd,
            ) -> ::std::os::raw::c_int,
        >,
    );
}
extern "C" {
    pub fn sam_cap_mapq(
        b: *mut bam1_t,
        ref_: *const ::std::os::raw::c_char,
        ref_len: hts_pos_t,
        thres: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sam_prob_realn(
        b: *mut bam1_t,
        ref_: *const ::std::os::raw::c_char,
        ref_len: hts_pos_t,
        flag: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
pub const cram_block_method_BM_ERROR: cram_block_method = -1;
pub const cram_block_method_RAW: cram_block_method = 0;
pub const cram_block_method_GZIP: cram_block_method = 1;
pub const cram_block_method_BZIP2: cram_block_method = 2;
pub const cram_block_method_LZMA: cram_block_method = 3;
pub const cram_block_method_RANS: cram_block_method = 4;
pub const cram_block_method_RANS0: cram_block_method = 4;
pub const cram_block_method_RANS1: cram_block_method = 10;
pub const cram_block_method_GZIP_RLE: cram_block_method = 11;
pub type cram_block_method = i32;
pub const cram_content_type_CT_ERROR: cram_content_type = -1;
pub const cram_content_type_FILE_HEADER: cram_content_type = 0;
pub const cram_content_type_COMPRESSION_HEADER: cram_content_type = 1;
pub const cram_content_type_MAPPED_SLICE: cram_content_type = 2;
pub const cram_content_type_UNMAPPED_SLICE: cram_content_type = 3;
pub const cram_content_type_EXTERNAL: cram_content_type = 4;
pub const cram_content_type_CORE: cram_content_type = 5;
pub type cram_content_type = i32;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cram_file_def {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cram_container {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cram_block {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cram_slice {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cram_metrics {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cram_block_slice_hdr {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cram_block_compression_hdr {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct refs_t {
    _unused: [u8; 0],
}
extern "C" {
    pub fn cram_fd_get_header(fd: *mut cram_fd) -> *mut sam_hdr_t;
}
extern "C" {
    pub fn cram_fd_set_header(fd: *mut cram_fd, hdr: *mut sam_hdr_t);
}
extern "C" {
    pub fn cram_fd_get_version(fd: *mut cram_fd) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn cram_fd_set_version(fd: *mut cram_fd, vers: ::std::os::raw::c_int);
}
extern "C" {
    pub fn cram_major_vers(fd: *mut cram_fd) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn cram_minor_vers(fd: *mut cram_fd) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn cram_fd_get_fp(fd: *mut cram_fd) -> *mut hFILE;
}
extern "C" {
    pub fn cram_fd_set_fp(fd: *mut cram_fd, fp: *mut hFILE);
}
extern "C" {
    pub fn cram_container_get_length(c: *mut cram_container) -> i32;
}
extern "C" {
    pub fn cram_container_set_length(c: *mut cram_container, length: i32);
}
extern "C" {
    pub fn cram_container_get_num_blocks(c: *mut cram_container) -> i32;
}
extern "C" {
    pub fn cram_container_set_num_blocks(c: *mut cram_container, num_blocks: i32);
}
extern "C" {
    pub fn cram_container_get_landmarks(
        c: *mut cram_container,
        num_landmarks: *mut i32,
    ) -> *mut i32;
}
extern "C" {
    pub fn cram_container_set_landmarks(
        c: *mut cram_container,
        num_landmarks: i32,
        landmarks: *mut i32,
    );
}
extern "C" {
    pub fn cram_container_is_empty(fd: *mut cram_fd) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn cram_block_get_content_id(b: *mut cram_block) -> i32;
}
extern "C" {
    pub fn cram_block_get_comp_size(b: *mut cram_block) -> i32;
}
extern "C" {
    pub fn cram_block_get_uncomp_size(b: *mut cram_block) -> i32;
}
extern "C" {
    pub fn cram_block_get_crc32(b: *mut cram_block) -> i32;
}
extern "C" {
    pub fn cram_block_get_data(b: *mut cram_block) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn cram_block_get_content_type(b: *mut cram_block) -> cram_content_type;
}
extern "C" {
    pub fn cram_block_set_content_id(b: *mut cram_block, id: i32);
}
extern "C" {
    pub fn cram_block_set_comp_size(b: *mut cram_block, size: i32);
}
extern "C" {
    pub fn cram_block_set_uncomp_size(b: *mut cram_block, size: i32);
}
extern "C" {
    pub fn cram_block_set_crc32(b: *mut cram_block, crc: i32);
}
extern "C" {
    pub fn cram_block_set_data(b: *mut cram_block, data: *mut ::std::os::raw::c_void);
}
extern "C" {
    pub fn cram_block_append(
        b: *mut cram_block,
        data: *const ::std::os::raw::c_void,
        size: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn cram_block_update_size(b: *mut cram_block);
}
extern "C" {
    pub fn cram_block_get_offset(b: *mut cram_block) -> size_t;
}
extern "C" {
    pub fn cram_block_set_offset(b: *mut cram_block, offset: size_t);
}
extern "C" {
    pub fn cram_block_size(b: *mut cram_block) -> u32;
}
extern "C" {
    pub fn cram_transcode_rg(
        in_: *mut cram_fd,
        out: *mut cram_fd,
        c: *mut cram_container,
        nrg: ::std::os::raw::c_int,
        in_rg: *mut ::std::os::raw::c_int,
        out_rg: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn cram_copy_slice(
        in_: *mut cram_fd,
        out: *mut cram_fd,
        num_slice: i32,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn cram_new_block(
        content_type: cram_content_type,
        content_id: ::std::os::raw::c_int,
    ) -> *mut cram_block;
}
extern "C" {
    pub fn cram_read_block(fd: *mut cram_fd) -> *mut cram_block;
}
extern "C" {
    pub fn cram_write_block(fd: *mut cram_fd, b: *mut cram_block) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn cram_free_block(b: *mut cram_block);
}
extern "C" {
    pub fn cram_uncompress_block(b: *mut cram_block) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn cram_compress_block(
        fd: *mut cram_fd,
        b: *mut cram_block,
        metrics: *mut cram_metrics,
        method: ::std::os::raw::c_int,
        level: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn cram_new_container(
        nrec: ::std::os::raw::c_int,
        nslice: ::std::os::raw::c_int,
    ) -> *mut cram_container;
}
extern "C" {
    pub fn cram_free_container(c: *mut cram_container);
}
extern "C" {
    pub fn cram_read_container(fd: *mut cram_fd) -> *mut cram_container;
}
extern "C" {
    pub fn cram_write_container(fd: *mut cram_fd, h: *mut cram_container) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn cram_store_container(
        fd: *mut cram_fd,
        c: *mut cram_container,
        dat: *mut ::std::os::raw::c_char,
        size: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn cram_container_size(c: *mut cram_container) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn cram_open(
        filename: *const ::std::os::raw::c_char,
        mode: *const ::std::os::raw::c_char,
    ) -> *mut cram_fd;
}
extern "C" {
    pub fn cram_dopen(
        fp: *mut hFILE,
        filename: *const ::std::os::raw::c_char,
        mode: *const ::std::os::raw::c_char,
    ) -> *mut cram_fd;
}
extern "C" {
    pub fn cram_close(fd: *mut cram_fd) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn cram_seek(
        fd: *mut cram_fd,
        offset: off_t,
        whence: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn cram_flush(fd: *mut cram_fd) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn cram_eof(fd: *mut cram_fd) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn cram_set_option(fd: *mut cram_fd, opt: hts_fmt_option, ...) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn cram_set_voption(
        fd: *mut cram_fd,
        opt: hts_fmt_option,
        args: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn cram_set_header(fd: *mut cram_fd, hdr: *mut sam_hdr_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn cram_check_EOF(fd: *mut cram_fd) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn int32_put_blk(b: *mut cram_block, val: i32) -> ::std::os::raw::c_int;
}
pub type SAM_hdr = sam_hdr_t;
extern "C" {
    pub fn cram_get_refs(fd: *mut htsFile) -> *mut refs_t;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct bgzf_mtaux_t {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct bgzidx_t {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct bgzf_cache_t {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct z_stream_s {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct BGZF {
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize], u16>,
    pub cache_size: ::std::os::raw::c_int,
    pub block_length: ::std::os::raw::c_int,
    pub block_clength: ::std::os::raw::c_int,
    pub block_offset: ::std::os::raw::c_int,
    pub block_address: i64,
    pub uncompressed_address: i64,
    pub uncompressed_block: *mut ::std::os::raw::c_void,
    pub compressed_block: *mut ::std::os::raw::c_void,
    pub cache: *mut bgzf_cache_t,
    pub fp: *mut hFILE,
    pub mt: *mut bgzf_mtaux_t,
    pub idx: *mut bgzidx_t,
    pub idx_build_otf: ::std::os::raw::c_int,
    pub gz_stream: *mut z_stream_s,
    pub seeked: i64,
}
#[test]
fn bindgen_test_layout_BGZF() {
    assert_eq!(
        ::std::mem::size_of::<BGZF>(),
        112usize,
        concat!("Size of: ", stringify!(BGZF))
    );
    assert_eq!(
        ::std::mem::align_of::<BGZF>(),
        8usize,
        concat!("Alignment of ", stringify!(BGZF))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<BGZF>())).cache_size as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(BGZF),
            "::",
            stringify!(cache_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<BGZF>())).block_length as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(BGZF),
            "::",
            stringify!(block_length)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<BGZF>())).block_clength as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(BGZF),
            "::",
            stringify!(block_clength)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<BGZF>())).block_offset as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(BGZF),
            "::",
            stringify!(block_offset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<BGZF>())).block_address as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(BGZF),
            "::",
            stringify!(block_address)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<BGZF>())).uncompressed_address as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(BGZF),
            "::",
            stringify!(uncompressed_address)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<BGZF>())).uncompressed_block as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(BGZF),
            "::",
            stringify!(uncompressed_block)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<BGZF>())).compressed_block as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(BGZF),
            "::",
            stringify!(compressed_block)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<BGZF>())).cache as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(BGZF),
            "::",
            stringify!(cache)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<BGZF>())).fp as *const _ as usize },
        64usize,
        concat!("Offset of field: ", stringify!(BGZF), "::", stringify!(fp))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<BGZF>())).mt as *const _ as usize },
        72usize,
        concat!("Offset of field: ", stringify!(BGZF), "::", stringify!(mt))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<BGZF>())).idx as *const _ as usize },
        80usize,
        concat!("Offset of field: ", stringify!(BGZF), "::", stringify!(idx))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<BGZF>())).idx_build_otf as *const _ as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(BGZF),
            "::",
            stringify!(idx_build_otf)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<BGZF>())).gz_stream as *const _ as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(BGZF),
            "::",
            stringify!(gz_stream)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<BGZF>())).seeked as *const _ as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(BGZF),
            "::",
            stringify!(seeked)
        )
    );
}
impl BGZF {
    #[inline]
    pub fn errcode(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 16u8) as u32) }
    }
    #[inline]
    pub fn set_errcode(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 16u8, val as u64)
        }
    }
    #[inline]
    pub fn reserved(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(16usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_reserved(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(16usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn is_write(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(17usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_is_write(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(17usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn no_eof_block(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(18usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_no_eof_block(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(18usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn is_be(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(19usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_is_be(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(19usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn compress_level(&self) -> ::std::os::raw::c_int {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(20usize, 9u8) as u32) }
    }
    #[inline]
    pub fn set_compress_level(&mut self, val: ::std::os::raw::c_int) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(20usize, 9u8, val as u64)
        }
    }
    #[inline]
    pub fn last_block_eof(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(29usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_last_block_eof(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(29usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn is_compressed(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(30usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_is_compressed(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(30usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn is_gzip(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(31usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_is_gzip(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(31usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        errcode: ::std::os::raw::c_uint,
        reserved: ::std::os::raw::c_uint,
        is_write: ::std::os::raw::c_uint,
        no_eof_block: ::std::os::raw::c_uint,
        is_be: ::std::os::raw::c_uint,
        compress_level: ::std::os::raw::c_int,
        last_block_eof: ::std::os::raw::c_uint,
        is_compressed: ::std::os::raw::c_uint,
        is_gzip: ::std::os::raw::c_uint,
    ) -> __BindgenBitfieldUnit<[u8; 4usize], u16> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize], u16> =
            Default::default();
        __bindgen_bitfield_unit.set(0usize, 16u8, {
            let errcode: u32 = unsafe { ::std::mem::transmute(errcode) };
            errcode as u64
        });
        __bindgen_bitfield_unit.set(16usize, 1u8, {
            let reserved: u32 = unsafe { ::std::mem::transmute(reserved) };
            reserved as u64
        });
        __bindgen_bitfield_unit.set(17usize, 1u8, {
            let is_write: u32 = unsafe { ::std::mem::transmute(is_write) };
            is_write as u64
        });
        __bindgen_bitfield_unit.set(18usize, 1u8, {
            let no_eof_block: u32 = unsafe { ::std::mem::transmute(no_eof_block) };
            no_eof_block as u64
        });
        __bindgen_bitfield_unit.set(19usize, 1u8, {
            let is_be: u32 = unsafe { ::std::mem::transmute(is_be) };
            is_be as u64
        });
        __bindgen_bitfield_unit.set(20usize, 9u8, {
            let compress_level: u32 = unsafe { ::std::mem::transmute(compress_level) };
            compress_level as u64
        });
        __bindgen_bitfield_unit.set(29usize, 1u8, {
            let last_block_eof: u32 = unsafe { ::std::mem::transmute(last_block_eof) };
            last_block_eof as u64
        });
        __bindgen_bitfield_unit.set(30usize, 1u8, {
            let is_compressed: u32 = unsafe { ::std::mem::transmute(is_compressed) };
            is_compressed as u64
        });
        __bindgen_bitfield_unit.set(31usize, 1u8, {
            let is_gzip: u32 = unsafe { ::std::mem::transmute(is_gzip) };
            is_gzip as u64
        });
        __bindgen_bitfield_unit
    }
}
extern "C" {
    pub fn bgzf_dopen(fd: ::std::os::raw::c_int, mode: *const ::std::os::raw::c_char) -> *mut BGZF;
}
extern "C" {
    pub fn bgzf_open(
        path: *const ::std::os::raw::c_char,
        mode: *const ::std::os::raw::c_char,
    ) -> *mut BGZF;
}
extern "C" {
    pub fn bgzf_hopen(fp: *mut hFILE, mode: *const ::std::os::raw::c_char) -> *mut BGZF;
}
extern "C" {
    pub fn bgzf_close(fp: *mut BGZF) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bgzf_read(fp: *mut BGZF, data: *mut ::std::os::raw::c_void, length: size_t) -> ssize_t;
}
extern "C" {
    pub fn bgzf_write(
        fp: *mut BGZF,
        data: *const ::std::os::raw::c_void,
        length: size_t,
    ) -> ssize_t;
}
extern "C" {
    pub fn bgzf_block_write(
        fp: *mut BGZF,
        data: *const ::std::os::raw::c_void,
        length: size_t,
    ) -> ssize_t;
}
extern "C" {
    pub fn bgzf_peek(fp: *mut BGZF) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bgzf_raw_read(
        fp: *mut BGZF,
        data: *mut ::std::os::raw::c_void,
        length: size_t,
    ) -> ssize_t;
}
extern "C" {
    pub fn bgzf_raw_write(
        fp: *mut BGZF,
        data: *const ::std::os::raw::c_void,
        length: size_t,
    ) -> ssize_t;
}
extern "C" {
    pub fn bgzf_flush(fp: *mut BGZF) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bgzf_seek(fp: *mut BGZF, pos: i64, whence: ::std::os::raw::c_int) -> i64;
}
extern "C" {
    pub fn bgzf_check_EOF(fp: *mut BGZF) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bgzf_compression(fp: *mut BGZF) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bgzf_is_bgzf(fn_: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bgzf_set_cache_size(fp: *mut BGZF, size: ::std::os::raw::c_int);
}
extern "C" {
    pub fn bgzf_flush_try(fp: *mut BGZF, size: ssize_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bgzf_getc(fp: *mut BGZF) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bgzf_getline(
        fp: *mut BGZF,
        delim: ::std::os::raw::c_int,
        str: *mut kstring_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bgzf_read_block(fp: *mut BGZF) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bgzf_thread_pool(
        fp: *mut BGZF,
        pool: *mut hts_tpool,
        qsize: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bgzf_mt(
        fp: *mut BGZF,
        n_threads: ::std::os::raw::c_int,
        n_sub_blks: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bgzf_compress(
        dst: *mut ::std::os::raw::c_void,
        dlen: *mut size_t,
        src: *const ::std::os::raw::c_void,
        slen: size_t,
        level: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bgzf_useek(
        fp: *mut BGZF,
        uoffset: off_t,
        where_: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bgzf_utell(fp: *mut BGZF) -> off_t;
}
extern "C" {
    pub fn bgzf_index_build_init(fp: *mut BGZF) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bgzf_index_load(
        fp: *mut BGZF,
        bname: *const ::std::os::raw::c_char,
        suffix: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bgzf_index_load_hfile(
        fp: *mut BGZF,
        idx: *mut hFILE,
        name: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bgzf_index_dump(
        fp: *mut BGZF,
        bname: *const ::std::os::raw::c_char,
        suffix: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bgzf_index_dump_hfile(
        fp: *mut BGZF,
        idx: *mut hFILE,
        name: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcf_trim_alleles(header: *const bcf_hdr_t, line: *mut bcf1_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcf_remove_alleles(
        header: *const bcf_hdr_t,
        line: *mut bcf1_t,
        mask: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcf_remove_allele_set(
        header: *const bcf_hdr_t,
        line: *mut bcf1_t,
        rm_set: *const kbitset_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcf_calc_ac(
        header: *const bcf_hdr_t,
        line: *mut bcf1_t,
        ac: *mut ::std::os::raw::c_int,
        which: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcf_gt_type(
        fmt_ptr: *mut bcf_fmt_t,
        isample: ::std::os::raw::c_int,
        ial: *mut ::std::os::raw::c_int,
        jal: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct tbx_conf_t {
    pub preset: i32,
    pub sc: i32,
    pub bc: i32,
    pub ec: i32,
    pub meta_char: i32,
    pub line_skip: i32,
}
#[test]
fn bindgen_test_layout_tbx_conf_t() {
    assert_eq!(
        ::std::mem::size_of::<tbx_conf_t>(),
        24usize,
        concat!("Size of: ", stringify!(tbx_conf_t))
    );
    assert_eq!(
        ::std::mem::align_of::<tbx_conf_t>(),
        4usize,
        concat!("Alignment of ", stringify!(tbx_conf_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<tbx_conf_t>())).preset as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(tbx_conf_t),
            "::",
            stringify!(preset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<tbx_conf_t>())).sc as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(tbx_conf_t),
            "::",
            stringify!(sc)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<tbx_conf_t>())).bc as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(tbx_conf_t),
            "::",
            stringify!(bc)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<tbx_conf_t>())).ec as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(tbx_conf_t),
            "::",
            stringify!(ec)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<tbx_conf_t>())).meta_char as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(tbx_conf_t),
            "::",
            stringify!(meta_char)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<tbx_conf_t>())).line_skip as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(tbx_conf_t),
            "::",
            stringify!(line_skip)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct tbx_t {
    pub conf: tbx_conf_t,
    pub idx: *mut hts_idx_t,
    pub dict: *mut ::std::os::raw::c_void,
}
#[test]
fn bindgen_test_layout_tbx_t() {
    assert_eq!(
        ::std::mem::size_of::<tbx_t>(),
        40usize,
        concat!("Size of: ", stringify!(tbx_t))
    );
    assert_eq!(
        ::std::mem::align_of::<tbx_t>(),
        8usize,
        concat!("Alignment of ", stringify!(tbx_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<tbx_t>())).conf as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(tbx_t),
            "::",
            stringify!(conf)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<tbx_t>())).idx as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(tbx_t),
            "::",
            stringify!(idx)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<tbx_t>())).dict as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(tbx_t),
            "::",
            stringify!(dict)
        )
    );
}
extern "C" {
    pub static tbx_conf_gff: tbx_conf_t;
}
extern "C" {
    pub static tbx_conf_bed: tbx_conf_t;
}
extern "C" {
    pub static tbx_conf_psltbl: tbx_conf_t;
}
extern "C" {
    pub static tbx_conf_sam: tbx_conf_t;
}
extern "C" {
    pub static tbx_conf_vcf: tbx_conf_t;
}
extern "C" {
    pub fn tbx_name2id(tbx: *mut tbx_t, ss: *const ::std::os::raw::c_char)
        -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn hts_get_bgzfp(fp: *mut htsFile) -> *mut BGZF;
}
extern "C" {
    pub fn tbx_readrec(
        fp: *mut BGZF,
        tbxv: *mut ::std::os::raw::c_void,
        sv: *mut ::std::os::raw::c_void,
        tid: *mut ::std::os::raw::c_int,
        beg: *mut hts_pos_t,
        end: *mut hts_pos_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn tbx_index(
        fp: *mut BGZF,
        min_shift: ::std::os::raw::c_int,
        conf: *const tbx_conf_t,
    ) -> *mut tbx_t;
}
extern "C" {
    pub fn tbx_index_build(
        fn_: *const ::std::os::raw::c_char,
        min_shift: ::std::os::raw::c_int,
        conf: *const tbx_conf_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn tbx_index_build2(
        fn_: *const ::std::os::raw::c_char,
        fnidx: *const ::std::os::raw::c_char,
        min_shift: ::std::os::raw::c_int,
        conf: *const tbx_conf_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn tbx_index_build3(
        fn_: *const ::std::os::raw::c_char,
        fnidx: *const ::std::os::raw::c_char,
        min_shift: ::std::os::raw::c_int,
        n_threads: ::std::os::raw::c_int,
        conf: *const tbx_conf_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn tbx_index_load(fn_: *const ::std::os::raw::c_char) -> *mut tbx_t;
}
extern "C" {
    pub fn tbx_index_load2(
        fn_: *const ::std::os::raw::c_char,
        fnidx: *const ::std::os::raw::c_char,
    ) -> *mut tbx_t;
}
extern "C" {
    pub fn tbx_index_load3(
        fn_: *const ::std::os::raw::c_char,
        fnidx: *const ::std::os::raw::c_char,
        flags: ::std::os::raw::c_int,
    ) -> *mut tbx_t;
}
extern "C" {
    pub fn tbx_seqnames(
        tbx: *mut tbx_t,
        n: *mut ::std::os::raw::c_int,
    ) -> *mut *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn tbx_destroy(tbx: *mut tbx_t);
}
pub const bcf_sr_opt_t_BCF_SR_REQUIRE_IDX: bcf_sr_opt_t = 0;
pub const bcf_sr_opt_t_BCF_SR_PAIR_LOGIC: bcf_sr_opt_t = 1;
pub const bcf_sr_opt_t_BCF_SR_ALLOW_NO_IDX: bcf_sr_opt_t = 2;
pub type bcf_sr_opt_t = u32;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct bcf_sr_region_t {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct bcf_sr_regions_t {
    pub tbx: *mut tbx_t,
    pub itr: *mut hts_itr_t,
    pub line: kstring_t,
    pub file: *mut htsFile,
    pub fname: *mut ::std::os::raw::c_char,
    pub is_bin: ::std::os::raw::c_int,
    pub als: *mut *mut ::std::os::raw::c_char,
    pub als_str: kstring_t,
    pub nals: ::std::os::raw::c_int,
    pub mals: ::std::os::raw::c_int,
    pub als_type: ::std::os::raw::c_int,
    pub missed_reg_handler: ::std::option::Option<
        unsafe extern "C" fn(arg1: *mut bcf_sr_regions_t, arg2: *mut ::std::os::raw::c_void),
    >,
    pub missed_reg_data: *mut ::std::os::raw::c_void,
    pub regs: *mut bcf_sr_region_t,
    pub seq_hash: *mut ::std::os::raw::c_void,
    pub seq_names: *mut *mut ::std::os::raw::c_char,
    pub nseqs: ::std::os::raw::c_int,
    pub iseq: ::std::os::raw::c_int,
    pub start: hts_pos_t,
    pub end: hts_pos_t,
    pub prev_seq: ::std::os::raw::c_int,
    pub prev_start: hts_pos_t,
    pub prev_end: hts_pos_t,
}
#[test]
fn bindgen_test_layout_bcf_sr_regions_t() {
    assert_eq!(
        ::std::mem::size_of::<bcf_sr_regions_t>(),
        200usize,
        concat!("Size of: ", stringify!(bcf_sr_regions_t))
    );
    assert_eq!(
        ::std::mem::align_of::<bcf_sr_regions_t>(),
        8usize,
        concat!("Alignment of ", stringify!(bcf_sr_regions_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_sr_regions_t>())).tbx as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_sr_regions_t),
            "::",
            stringify!(tbx)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_sr_regions_t>())).itr as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_sr_regions_t),
            "::",
            stringify!(itr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_sr_regions_t>())).line as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_sr_regions_t),
            "::",
            stringify!(line)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_sr_regions_t>())).file as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_sr_regions_t),
            "::",
            stringify!(file)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_sr_regions_t>())).fname as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_sr_regions_t),
            "::",
            stringify!(fname)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_sr_regions_t>())).is_bin as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_sr_regions_t),
            "::",
            stringify!(is_bin)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_sr_regions_t>())).als as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_sr_regions_t),
            "::",
            stringify!(als)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_sr_regions_t>())).als_str as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_sr_regions_t),
            "::",
            stringify!(als_str)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_sr_regions_t>())).nals as *const _ as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_sr_regions_t),
            "::",
            stringify!(nals)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_sr_regions_t>())).mals as *const _ as usize },
        100usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_sr_regions_t),
            "::",
            stringify!(mals)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_sr_regions_t>())).als_type as *const _ as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_sr_regions_t),
            "::",
            stringify!(als_type)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<bcf_sr_regions_t>())).missed_reg_handler as *const _ as usize
        },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_sr_regions_t),
            "::",
            stringify!(missed_reg_handler)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<bcf_sr_regions_t>())).missed_reg_data as *const _ as usize
        },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_sr_regions_t),
            "::",
            stringify!(missed_reg_data)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_sr_regions_t>())).regs as *const _ as usize },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_sr_regions_t),
            "::",
            stringify!(regs)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_sr_regions_t>())).seq_hash as *const _ as usize },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_sr_regions_t),
            "::",
            stringify!(seq_hash)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_sr_regions_t>())).seq_names as *const _ as usize },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_sr_regions_t),
            "::",
            stringify!(seq_names)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_sr_regions_t>())).nseqs as *const _ as usize },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_sr_regions_t),
            "::",
            stringify!(nseqs)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_sr_regions_t>())).iseq as *const _ as usize },
        156usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_sr_regions_t),
            "::",
            stringify!(iseq)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_sr_regions_t>())).start as *const _ as usize },
        160usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_sr_regions_t),
            "::",
            stringify!(start)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_sr_regions_t>())).end as *const _ as usize },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_sr_regions_t),
            "::",
            stringify!(end)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_sr_regions_t>())).prev_seq as *const _ as usize },
        176usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_sr_regions_t),
            "::",
            stringify!(prev_seq)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_sr_regions_t>())).prev_start as *const _ as usize },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_sr_regions_t),
            "::",
            stringify!(prev_start)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_sr_regions_t>())).prev_end as *const _ as usize },
        192usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_sr_regions_t),
            "::",
            stringify!(prev_end)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct bcf_sr_t {
    pub file: *mut htsFile,
    pub tbx_idx: *mut tbx_t,
    pub bcf_idx: *mut hts_idx_t,
    pub header: *mut bcf_hdr_t,
    pub itr: *mut hts_itr_t,
    pub fname: *mut ::std::os::raw::c_char,
    pub buffer: *mut *mut bcf1_t,
    pub nbuffer: ::std::os::raw::c_int,
    pub mbuffer: ::std::os::raw::c_int,
    pub nfilter_ids: ::std::os::raw::c_int,
    pub filter_ids: *mut ::std::os::raw::c_int,
    pub samples: *mut ::std::os::raw::c_int,
    pub n_smpl: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_bcf_sr_t() {
    assert_eq!(
        ::std::mem::size_of::<bcf_sr_t>(),
        96usize,
        concat!("Size of: ", stringify!(bcf_sr_t))
    );
    assert_eq!(
        ::std::mem::align_of::<bcf_sr_t>(),
        8usize,
        concat!("Alignment of ", stringify!(bcf_sr_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_sr_t>())).file as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_sr_t),
            "::",
            stringify!(file)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_sr_t>())).tbx_idx as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_sr_t),
            "::",
            stringify!(tbx_idx)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_sr_t>())).bcf_idx as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_sr_t),
            "::",
            stringify!(bcf_idx)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_sr_t>())).header as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_sr_t),
            "::",
            stringify!(header)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_sr_t>())).itr as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_sr_t),
            "::",
            stringify!(itr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_sr_t>())).fname as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_sr_t),
            "::",
            stringify!(fname)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_sr_t>())).buffer as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_sr_t),
            "::",
            stringify!(buffer)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_sr_t>())).nbuffer as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_sr_t),
            "::",
            stringify!(nbuffer)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_sr_t>())).mbuffer as *const _ as usize },
        60usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_sr_t),
            "::",
            stringify!(mbuffer)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_sr_t>())).nfilter_ids as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_sr_t),
            "::",
            stringify!(nfilter_ids)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_sr_t>())).filter_ids as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_sr_t),
            "::",
            stringify!(filter_ids)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_sr_t>())).samples as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_sr_t),
            "::",
            stringify!(samples)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_sr_t>())).n_smpl as *const _ as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_sr_t),
            "::",
            stringify!(n_smpl)
        )
    );
}
pub const bcf_sr_error_open_failed: bcf_sr_error = 0;
pub const bcf_sr_error_not_bgzf: bcf_sr_error = 1;
pub const bcf_sr_error_idx_load_failed: bcf_sr_error = 2;
pub const bcf_sr_error_file_type_error: bcf_sr_error = 3;
pub const bcf_sr_error_api_usage_error: bcf_sr_error = 4;
pub const bcf_sr_error_header_error: bcf_sr_error = 5;
pub const bcf_sr_error_no_eof: bcf_sr_error = 6;
pub const bcf_sr_error_no_memory: bcf_sr_error = 7;
pub const bcf_sr_error_vcf_parse_error: bcf_sr_error = 8;
pub const bcf_sr_error_bcf_read_error: bcf_sr_error = 9;
pub const bcf_sr_error_noidx_error: bcf_sr_error = 10;
pub type bcf_sr_error = u32;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct bcf_srs_t {
    pub collapse: ::std::os::raw::c_int,
    pub apply_filters: *mut ::std::os::raw::c_char,
    pub require_index: ::std::os::raw::c_int,
    pub max_unpack: ::std::os::raw::c_int,
    pub has_line: *mut ::std::os::raw::c_int,
    pub errnum: bcf_sr_error,
    pub readers: *mut bcf_sr_t,
    pub nreaders: ::std::os::raw::c_int,
    pub streaming: ::std::os::raw::c_int,
    pub explicit_regs: ::std::os::raw::c_int,
    pub samples: *mut *mut ::std::os::raw::c_char,
    pub regions: *mut bcf_sr_regions_t,
    pub targets: *mut bcf_sr_regions_t,
    pub targets_als: ::std::os::raw::c_int,
    pub targets_exclude: ::std::os::raw::c_int,
    pub tmps: kstring_t,
    pub n_smpl: ::std::os::raw::c_int,
    pub n_threads: ::std::os::raw::c_int,
    pub p: *mut htsThreadPool,
    pub aux: *mut ::std::os::raw::c_void,
}
#[test]
fn bindgen_test_layout_bcf_srs_t() {
    assert_eq!(
        ::std::mem::size_of::<bcf_srs_t>(),
        144usize,
        concat!("Size of: ", stringify!(bcf_srs_t))
    );
    assert_eq!(
        ::std::mem::align_of::<bcf_srs_t>(),
        8usize,
        concat!("Alignment of ", stringify!(bcf_srs_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_srs_t>())).collapse as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_srs_t),
            "::",
            stringify!(collapse)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_srs_t>())).apply_filters as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_srs_t),
            "::",
            stringify!(apply_filters)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_srs_t>())).require_index as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_srs_t),
            "::",
            stringify!(require_index)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_srs_t>())).max_unpack as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_srs_t),
            "::",
            stringify!(max_unpack)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_srs_t>())).has_line as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_srs_t),
            "::",
            stringify!(has_line)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_srs_t>())).errnum as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_srs_t),
            "::",
            stringify!(errnum)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_srs_t>())).readers as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_srs_t),
            "::",
            stringify!(readers)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_srs_t>())).nreaders as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_srs_t),
            "::",
            stringify!(nreaders)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_srs_t>())).streaming as *const _ as usize },
        52usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_srs_t),
            "::",
            stringify!(streaming)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_srs_t>())).explicit_regs as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_srs_t),
            "::",
            stringify!(explicit_regs)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_srs_t>())).samples as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_srs_t),
            "::",
            stringify!(samples)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_srs_t>())).regions as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_srs_t),
            "::",
            stringify!(regions)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_srs_t>())).targets as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_srs_t),
            "::",
            stringify!(targets)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_srs_t>())).targets_als as *const _ as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_srs_t),
            "::",
            stringify!(targets_als)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_srs_t>())).targets_exclude as *const _ as usize },
        92usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_srs_t),
            "::",
            stringify!(targets_exclude)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_srs_t>())).tmps as *const _ as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_srs_t),
            "::",
            stringify!(tmps)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_srs_t>())).n_smpl as *const _ as usize },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_srs_t),
            "::",
            stringify!(n_smpl)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_srs_t>())).n_threads as *const _ as usize },
        124usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_srs_t),
            "::",
            stringify!(n_threads)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_srs_t>())).p as *const _ as usize },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_srs_t),
            "::",
            stringify!(p)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_srs_t>())).aux as *const _ as usize },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_srs_t),
            "::",
            stringify!(aux)
        )
    );
}
extern "C" {
    pub fn bcf_sr_init() -> *mut bcf_srs_t;
}
extern "C" {
    pub fn bcf_sr_destroy(readers: *mut bcf_srs_t);
}
extern "C" {
    pub fn bcf_sr_strerror(errnum: ::std::os::raw::c_int) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn bcf_sr_set_opt(readers: *mut bcf_srs_t, opt: bcf_sr_opt_t, ...)
        -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcf_sr_set_threads(
        files: *mut bcf_srs_t,
        n_threads: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcf_sr_destroy_threads(files: *mut bcf_srs_t);
}
extern "C" {
    pub fn bcf_sr_add_reader(
        readers: *mut bcf_srs_t,
        fname: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcf_sr_remove_reader(files: *mut bcf_srs_t, i: ::std::os::raw::c_int);
}
extern "C" {
    pub fn bcf_sr_next_line(readers: *mut bcf_srs_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcf_sr_seek(
        readers: *mut bcf_srs_t,
        seq: *const ::std::os::raw::c_char,
        pos: hts_pos_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcf_sr_set_samples(
        readers: *mut bcf_srs_t,
        samples: *const ::std::os::raw::c_char,
        is_file: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcf_sr_set_targets(
        readers: *mut bcf_srs_t,
        targets: *const ::std::os::raw::c_char,
        is_file: ::std::os::raw::c_int,
        alleles: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcf_sr_set_regions(
        readers: *mut bcf_srs_t,
        regions: *const ::std::os::raw::c_char,
        is_file: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcf_sr_regions_init(
        regions: *const ::std::os::raw::c_char,
        is_file: ::std::os::raw::c_int,
        chr: ::std::os::raw::c_int,
        from: ::std::os::raw::c_int,
        to: ::std::os::raw::c_int,
    ) -> *mut bcf_sr_regions_t;
}
extern "C" {
    pub fn bcf_sr_regions_destroy(regions: *mut bcf_sr_regions_t);
}
extern "C" {
    pub fn bcf_sr_regions_seek(
        regions: *mut bcf_sr_regions_t,
        chr: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcf_sr_regions_next(reg: *mut bcf_sr_regions_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcf_sr_regions_overlap(
        reg: *mut bcf_sr_regions_t,
        seq: *const ::std::os::raw::c_char,
        start: hts_pos_t,
        end: hts_pos_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcf_sr_regions_flush(regs: *mut bcf_sr_regions_t) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct kbitset_t {
    pub n: size_t,
    pub n_max: size_t,
    pub b: [::std::os::raw::c_ulong; 1usize],
}
#[test]
fn bindgen_test_layout_kbitset_t() {
    assert_eq!(
        ::std::mem::size_of::<kbitset_t>(),
        24usize,
        concat!("Size of: ", stringify!(kbitset_t))
    );
    assert_eq!(
        ::std::mem::align_of::<kbitset_t>(),
        8usize,
        concat!("Alignment of ", stringify!(kbitset_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kbitset_t>())).n as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kbitset_t),
            "::",
            stringify!(n)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kbitset_t>())).n_max as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kbitset_t),
            "::",
            stringify!(n_max)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kbitset_t>())).b as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(kbitset_t),
            "::",
            stringify!(b)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct kbitset_iter_t {
    pub mask: ::std::os::raw::c_ulong,
    pub elt: size_t,
    pub i: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_kbitset_iter_t() {
    assert_eq!(
        ::std::mem::size_of::<kbitset_iter_t>(),
        24usize,
        concat!("Size of: ", stringify!(kbitset_iter_t))
    );
    assert_eq!(
        ::std::mem::align_of::<kbitset_iter_t>(),
        8usize,
        concat!("Alignment of ", stringify!(kbitset_iter_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kbitset_iter_t>())).mask as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kbitset_iter_t),
            "::",
            stringify!(mask)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kbitset_iter_t>())).elt as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kbitset_iter_t),
            "::",
            stringify!(elt)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kbitset_iter_t>())).i as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(kbitset_iter_t),
            "::",
            stringify!(i)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct faidx_t {
    _unused: [u8; 0],
}
pub const fai_format_options_FAI_NONE: fai_format_options = 0;
pub const fai_format_options_FAI_FASTA: fai_format_options = 1;
pub const fai_format_options_FAI_FASTQ: fai_format_options = 2;
pub type fai_format_options = u32;
extern "C" {
    pub fn fai_build3(
        fn_: *const ::std::os::raw::c_char,
        fnfai: *const ::std::os::raw::c_char,
        fngzi: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fai_build(fn_: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fai_destroy(fai: *mut faidx_t);
}
pub const fai_load_options_FAI_CREATE: fai_load_options = 1;
pub type fai_load_options = u32;
extern "C" {
    pub fn fai_load3(
        fn_: *const ::std::os::raw::c_char,
        fnfai: *const ::std::os::raw::c_char,
        fngzi: *const ::std::os::raw::c_char,
        flags: ::std::os::raw::c_int,
    ) -> *mut faidx_t;
}
extern "C" {
    pub fn fai_load(fn_: *const ::std::os::raw::c_char) -> *mut faidx_t;
}
extern "C" {
    pub fn fai_load3_format(
        fn_: *const ::std::os::raw::c_char,
        fnfai: *const ::std::os::raw::c_char,
        fngzi: *const ::std::os::raw::c_char,
        flags: ::std::os::raw::c_int,
        format: fai_format_options,
    ) -> *mut faidx_t;
}
extern "C" {
    pub fn fai_load_format(
        fn_: *const ::std::os::raw::c_char,
        format: fai_format_options,
    ) -> *mut faidx_t;
}
extern "C" {
    pub fn fai_fetch(
        fai: *const faidx_t,
        reg: *const ::std::os::raw::c_char,
        len: *mut ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn fai_fetch64(
        fai: *const faidx_t,
        reg: *const ::std::os::raw::c_char,
        len: *mut hts_pos_t,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn fai_fetchqual(
        fai: *const faidx_t,
        reg: *const ::std::os::raw::c_char,
        len: *mut ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn fai_fetchqual64(
        fai: *const faidx_t,
        reg: *const ::std::os::raw::c_char,
        len: *mut hts_pos_t,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn faidx_fetch_nseq(fai: *const faidx_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn faidx_fetch_seq(
        fai: *const faidx_t,
        c_name: *const ::std::os::raw::c_char,
        p_beg_i: ::std::os::raw::c_int,
        p_end_i: ::std::os::raw::c_int,
        len: *mut ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn faidx_fetch_seq64(
        fai: *const faidx_t,
        c_name: *const ::std::os::raw::c_char,
        p_beg_i: hts_pos_t,
        p_end_i: hts_pos_t,
        len: *mut hts_pos_t,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn faidx_fetch_qual(
        fai: *const faidx_t,
        c_name: *const ::std::os::raw::c_char,
        p_beg_i: ::std::os::raw::c_int,
        p_end_i: ::std::os::raw::c_int,
        len: *mut ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn faidx_fetch_qual64(
        fai: *const faidx_t,
        c_name: *const ::std::os::raw::c_char,
        p_beg_i: hts_pos_t,
        p_end_i: hts_pos_t,
        len: *mut hts_pos_t,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn faidx_has_seq(
        fai: *const faidx_t,
        seq: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn faidx_nseq(fai: *const faidx_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn faidx_iseq(
        fai: *const faidx_t,
        i: ::std::os::raw::c_int,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn faidx_seq_len(
        fai: *const faidx_t,
        seq: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fai_parse_region(
        fai: *const faidx_t,
        s: *const ::std::os::raw::c_char,
        tid: *mut ::std::os::raw::c_int,
        beg: *mut hts_pos_t,
        end: *mut hts_pos_t,
        flags: ::std::os::raw::c_int,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn fai_set_cache_size(fai: *mut faidx_t, cache_size: ::std::os::raw::c_int);
}
extern "C" {
    pub fn fai_path(fa: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hts_tpool_process {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hts_tpool_result {
    _unused: [u8; 0],
}
extern "C" {
    pub fn hts_tpool_init(n: ::std::os::raw::c_int) -> *mut hts_tpool;
}
extern "C" {
    pub fn hts_tpool_size(p: *mut hts_tpool) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn hts_tpool_dispatch(
        p: *mut hts_tpool,
        q: *mut hts_tpool_process,
        func: ::std::option::Option<
            unsafe extern "C" fn(arg: *mut ::std::os::raw::c_void) -> *mut ::std::os::raw::c_void,
        >,
        arg: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn hts_tpool_dispatch2(
        p: *mut hts_tpool,
        q: *mut hts_tpool_process,
        func: ::std::option::Option<
            unsafe extern "C" fn(arg: *mut ::std::os::raw::c_void) -> *mut ::std::os::raw::c_void,
        >,
        arg: *mut ::std::os::raw::c_void,
        nonblock: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn hts_tpool_dispatch3(
        p: *mut hts_tpool,
        q: *mut hts_tpool_process,
        exec_func: ::std::option::Option<
            unsafe extern "C" fn(arg: *mut ::std::os::raw::c_void) -> *mut ::std::os::raw::c_void,
        >,
        arg: *mut ::std::os::raw::c_void,
        job_cleanup: ::std::option::Option<unsafe extern "C" fn(arg: *mut ::std::os::raw::c_void)>,
        result_cleanup: ::std::option::Option<
            unsafe extern "C" fn(data: *mut ::std::os::raw::c_void),
        >,
        nonblock: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn hts_tpool_wake_dispatch(q: *mut hts_tpool_process);
}
extern "C" {
    pub fn hts_tpool_process_flush(q: *mut hts_tpool_process) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn hts_tpool_process_reset(
        q: *mut hts_tpool_process,
        free_results: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn hts_tpool_process_qsize(q: *mut hts_tpool_process) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn hts_tpool_destroy(p: *mut hts_tpool);
}
extern "C" {
    pub fn hts_tpool_kill(p: *mut hts_tpool);
}
extern "C" {
    pub fn hts_tpool_next_result(q: *mut hts_tpool_process) -> *mut hts_tpool_result;
}
extern "C" {
    pub fn hts_tpool_next_result_wait(q: *mut hts_tpool_process) -> *mut hts_tpool_result;
}
extern "C" {
    pub fn hts_tpool_delete_result(r: *mut hts_tpool_result, free_data: ::std::os::raw::c_int);
}
extern "C" {
    pub fn hts_tpool_result_data(r: *mut hts_tpool_result) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn hts_tpool_process_init(
        p: *mut hts_tpool,
        qsize: ::std::os::raw::c_int,
        in_only: ::std::os::raw::c_int,
    ) -> *mut hts_tpool_process;
}
extern "C" {
    pub fn hts_tpool_process_destroy(q: *mut hts_tpool_process);
}
extern "C" {
    pub fn hts_tpool_process_empty(q: *mut hts_tpool_process) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn hts_tpool_process_len(q: *mut hts_tpool_process) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn hts_tpool_process_sz(q: *mut hts_tpool_process) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn hts_tpool_process_shutdown(q: *mut hts_tpool_process);
}
extern "C" {
    pub fn hts_tpool_process_is_shutdown(q: *mut hts_tpool_process) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn hts_tpool_process_attach(p: *mut hts_tpool, q: *mut hts_tpool_process);
}
extern "C" {
    pub fn hts_tpool_process_detach(p: *mut hts_tpool, q: *mut hts_tpool_process);
}
extern "C" {
    pub fn hts_tpool_process_ref_incr(q: *mut hts_tpool_process);
}
extern "C" {
    pub fn hts_tpool_process_ref_decr(q: *mut hts_tpool_process);
}
extern "C" {
    #[link_name = "\u{1}_wrap_kbs_init2"]
    pub fn kbs_init2(ni: size_t, fill: ::std::os::raw::c_int) -> *mut kbitset_t;
}
extern "C" {
    #[link_name = "\u{1}_wrap_kbs_init"]
    pub fn kbs_init(ni: size_t) -> *mut kbitset_t;
}
extern "C" {
    #[link_name = "\u{1}_wrap_kbs_insert"]
    pub fn kbs_insert(bs: *mut kbitset_t, i: ::std::os::raw::c_int);
}
extern "C" {
    #[link_name = "\u{1}_wrap_kbs_destroy"]
    pub fn kbs_destroy(bs: *mut kbitset_t);
}
pub type __builtin_va_list = [__va_list_tag; 1usize];
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __va_list_tag {
    pub gp_offset: ::std::os::raw::c_uint,
    pub fp_offset: ::std::os::raw::c_uint,
    pub overflow_arg_area: *mut ::std::os::raw::c_void,
    pub reg_save_area: *mut ::std::os::raw::c_void,
}
#[test]
fn bindgen_test_layout___va_list_tag() {
    assert_eq!(
        ::std::mem::size_of::<__va_list_tag>(),
        24usize,
        concat!("Size of: ", stringify!(__va_list_tag))
    );
    assert_eq!(
        ::std::mem::align_of::<__va_list_tag>(),
        8usize,
        concat!("Alignment of ", stringify!(__va_list_tag))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__va_list_tag>())).gp_offset as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__va_list_tag),
            "::",
            stringify!(gp_offset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__va_list_tag>())).fp_offset as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(__va_list_tag),
            "::",
            stringify!(fp_offset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__va_list_tag>())).overflow_arg_area as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__va_list_tag),
            "::",
            stringify!(overflow_arg_area)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__va_list_tag>())).reg_save_area as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__va_list_tag),
            "::",
            stringify!(reg_save_area)
        )
    );
}
