/* automatically generated by rust-bindgen */

#[repr(C)]
#[derive(Copy, Clone, Debug, Default, Eq, Hash, Ord, PartialEq, PartialOrd)]
pub struct __BindgenBitfieldUnit<Storage, Align> {
    storage: Storage,
    align: [Align; 0],
}
impl<Storage, Align> __BindgenBitfieldUnit<Storage, Align> {
    #[inline]
    pub const fn new(storage: Storage) -> Self {
        Self { storage, align: [] }
    }
}
impl<Storage, Align> __BindgenBitfieldUnit<Storage, Align>
where
    Storage: AsRef<[u8]> + AsMut<[u8]>,
{
    #[inline]
    pub fn get_bit(&self, index: usize) -> bool {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = self.storage.as_ref()[byte_index];
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        byte & mask == mask
    }
    #[inline]
    pub fn set_bit(&mut self, index: usize, val: bool) {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = &mut self.storage.as_mut()[byte_index];
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        if val {
            *byte |= mask;
        } else {
            *byte &= !mask;
        }
    }
    #[inline]
    pub fn get(&self, bit_offset: usize, bit_width: u8) -> u64 {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        let mut val = 0;
        for i in 0..(bit_width as usize) {
            if self.get_bit(i + bit_offset) {
                let index = if cfg!(target_endian = "big") {
                    bit_width as usize - 1 - i
                } else {
                    i
                };
                val |= 1 << index;
            }
        }
        val
    }
    #[inline]
    pub fn set(&mut self, bit_offset: usize, bit_width: u8, val: u64) {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        for i in 0..(bit_width as usize) {
            let mask = 1 << i;
            let val_bit_is_set = val & mask == mask;
            let index = if cfg!(target_endian = "big") {
                bit_width as usize - 1 - i
            } else {
                i
            };
            self.set_bit(index + bit_offset, val_bit_is_set);
        }
    }
}
pub const _STDINT_H: u32 = 1;
pub const _FEATURES_H: u32 = 1;
pub const __USE_ANSI: u32 = 1;
pub const _BSD_SOURCE: u32 = 1;
pub const _SVID_SOURCE: u32 = 1;
pub const __USE_ISOC99: u32 = 1;
pub const __USE_ISOC95: u32 = 1;
pub const _POSIX_SOURCE: u32 = 1;
pub const _POSIX_C_SOURCE: u32 = 200809;
pub const __USE_POSIX_IMPLICITLY: u32 = 1;
pub const __USE_POSIX: u32 = 1;
pub const __USE_POSIX2: u32 = 1;
pub const __USE_POSIX199309: u32 = 1;
pub const __USE_POSIX199506: u32 = 1;
pub const __USE_XOPEN2K: u32 = 1;
pub const __USE_XOPEN2K8: u32 = 1;
pub const _ATFILE_SOURCE: u32 = 1;
pub const __USE_MISC: u32 = 1;
pub const __USE_BSD: u32 = 1;
pub const __USE_SVID: u32 = 1;
pub const __USE_ATFILE: u32 = 1;
pub const __USE_FORTIFY_LEVEL: u32 = 0;
pub const __STDC_IEC_559__: u32 = 1;
pub const __STDC_IEC_559_COMPLEX__: u32 = 1;
pub const __STDC_ISO_10646__: u32 = 200009;
pub const __GNU_LIBRARY__: u32 = 6;
pub const __GLIBC__: u32 = 2;
pub const __GLIBC_MINOR__: u32 = 12;
pub const __GLIBC_HAVE_LONG_LONG: u32 = 1;
pub const _SYS_CDEFS_H: u32 = 1;
pub const __WORDSIZE: u32 = 64;
pub const __WORDSIZE_COMPAT32: u32 = 1;
pub const _BITS_WCHAR_H: u32 = 1;
pub const __WCHAR_MIN: i32 = -2147483648;
pub const __WCHAR_MAX: u32 = 2147483647;
pub const INT8_MIN: i32 = -128;
pub const INT16_MIN: i32 = -32768;
pub const INT32_MIN: i32 = -2147483648;
pub const INT8_MAX: u32 = 127;
pub const INT16_MAX: u32 = 32767;
pub const INT32_MAX: u32 = 2147483647;
pub const UINT8_MAX: u32 = 255;
pub const UINT16_MAX: u32 = 65535;
pub const UINT32_MAX: u32 = 4294967295;
pub const INT_LEAST8_MIN: i32 = -128;
pub const INT_LEAST16_MIN: i32 = -32768;
pub const INT_LEAST32_MIN: i32 = -2147483648;
pub const INT_LEAST8_MAX: u32 = 127;
pub const INT_LEAST16_MAX: u32 = 32767;
pub const INT_LEAST32_MAX: u32 = 2147483647;
pub const UINT_LEAST8_MAX: u32 = 255;
pub const UINT_LEAST16_MAX: u32 = 65535;
pub const UINT_LEAST32_MAX: u32 = 4294967295;
pub const INT_FAST8_MIN: i32 = -128;
pub const INT_FAST16_MIN: i64 = -9223372036854775808;
pub const INT_FAST32_MIN: i64 = -9223372036854775808;
pub const INT_FAST8_MAX: u32 = 127;
pub const INT_FAST16_MAX: u64 = 9223372036854775807;
pub const INT_FAST32_MAX: u64 = 9223372036854775807;
pub const UINT_FAST8_MAX: u32 = 255;
pub const UINT_FAST16_MAX: i32 = -1;
pub const UINT_FAST32_MAX: i32 = -1;
pub const INTPTR_MIN: i64 = -9223372036854775808;
pub const INTPTR_MAX: u64 = 9223372036854775807;
pub const UINTPTR_MAX: i32 = -1;
pub const PTRDIFF_MIN: i64 = -9223372036854775808;
pub const PTRDIFF_MAX: u64 = 9223372036854775807;
pub const SIG_ATOMIC_MIN: i32 = -2147483648;
pub const SIG_ATOMIC_MAX: u32 = 2147483647;
pub const SIZE_MAX: i32 = -1;
pub const WCHAR_MIN: i32 = -2147483648;
pub const WCHAR_MAX: u32 = 2147483647;
pub const WINT_MIN: u32 = 0;
pub const WINT_MAX: u32 = 4294967295;
pub const _INTTYPES_H: u32 = 1;
pub const ____gwchar_t_defined: u32 = 1;
pub const __PRI64_PREFIX: &'static [u8; 2usize] = b"l\0";
pub const __PRIPTR_PREFIX: &'static [u8; 2usize] = b"l\0";
pub const PRId8: &'static [u8; 2usize] = b"d\0";
pub const PRId16: &'static [u8; 2usize] = b"d\0";
pub const PRId32: &'static [u8; 2usize] = b"d\0";
pub const PRId64: &'static [u8; 3usize] = b"ld\0";
pub const PRIdLEAST8: &'static [u8; 2usize] = b"d\0";
pub const PRIdLEAST16: &'static [u8; 2usize] = b"d\0";
pub const PRIdLEAST32: &'static [u8; 2usize] = b"d\0";
pub const PRIdLEAST64: &'static [u8; 3usize] = b"ld\0";
pub const PRIdFAST8: &'static [u8; 2usize] = b"d\0";
pub const PRIdFAST16: &'static [u8; 3usize] = b"ld\0";
pub const PRIdFAST32: &'static [u8; 3usize] = b"ld\0";
pub const PRIdFAST64: &'static [u8; 3usize] = b"ld\0";
pub const PRIi8: &'static [u8; 2usize] = b"i\0";
pub const PRIi16: &'static [u8; 2usize] = b"i\0";
pub const PRIi32: &'static [u8; 2usize] = b"i\0";
pub const PRIi64: &'static [u8; 3usize] = b"li\0";
pub const PRIiLEAST8: &'static [u8; 2usize] = b"i\0";
pub const PRIiLEAST16: &'static [u8; 2usize] = b"i\0";
pub const PRIiLEAST32: &'static [u8; 2usize] = b"i\0";
pub const PRIiLEAST64: &'static [u8; 3usize] = b"li\0";
pub const PRIiFAST8: &'static [u8; 2usize] = b"i\0";
pub const PRIiFAST16: &'static [u8; 3usize] = b"li\0";
pub const PRIiFAST32: &'static [u8; 3usize] = b"li\0";
pub const PRIiFAST64: &'static [u8; 3usize] = b"li\0";
pub const PRIo8: &'static [u8; 2usize] = b"o\0";
pub const PRIo16: &'static [u8; 2usize] = b"o\0";
pub const PRIo32: &'static [u8; 2usize] = b"o\0";
pub const PRIo64: &'static [u8; 3usize] = b"lo\0";
pub const PRIoLEAST8: &'static [u8; 2usize] = b"o\0";
pub const PRIoLEAST16: &'static [u8; 2usize] = b"o\0";
pub const PRIoLEAST32: &'static [u8; 2usize] = b"o\0";
pub const PRIoLEAST64: &'static [u8; 3usize] = b"lo\0";
pub const PRIoFAST8: &'static [u8; 2usize] = b"o\0";
pub const PRIoFAST16: &'static [u8; 3usize] = b"lo\0";
pub const PRIoFAST32: &'static [u8; 3usize] = b"lo\0";
pub const PRIoFAST64: &'static [u8; 3usize] = b"lo\0";
pub const PRIu8: &'static [u8; 2usize] = b"u\0";
pub const PRIu16: &'static [u8; 2usize] = b"u\0";
pub const PRIu32: &'static [u8; 2usize] = b"u\0";
pub const PRIu64: &'static [u8; 3usize] = b"lu\0";
pub const PRIuLEAST8: &'static [u8; 2usize] = b"u\0";
pub const PRIuLEAST16: &'static [u8; 2usize] = b"u\0";
pub const PRIuLEAST32: &'static [u8; 2usize] = b"u\0";
pub const PRIuLEAST64: &'static [u8; 3usize] = b"lu\0";
pub const PRIuFAST8: &'static [u8; 2usize] = b"u\0";
pub const PRIuFAST16: &'static [u8; 3usize] = b"lu\0";
pub const PRIuFAST32: &'static [u8; 3usize] = b"lu\0";
pub const PRIuFAST64: &'static [u8; 3usize] = b"lu\0";
pub const PRIx8: &'static [u8; 2usize] = b"x\0";
pub const PRIx16: &'static [u8; 2usize] = b"x\0";
pub const PRIx32: &'static [u8; 2usize] = b"x\0";
pub const PRIx64: &'static [u8; 3usize] = b"lx\0";
pub const PRIxLEAST8: &'static [u8; 2usize] = b"x\0";
pub const PRIxLEAST16: &'static [u8; 2usize] = b"x\0";
pub const PRIxLEAST32: &'static [u8; 2usize] = b"x\0";
pub const PRIxLEAST64: &'static [u8; 3usize] = b"lx\0";
pub const PRIxFAST8: &'static [u8; 2usize] = b"x\0";
pub const PRIxFAST16: &'static [u8; 3usize] = b"lx\0";
pub const PRIxFAST32: &'static [u8; 3usize] = b"lx\0";
pub const PRIxFAST64: &'static [u8; 3usize] = b"lx\0";
pub const PRIX8: &'static [u8; 2usize] = b"X\0";
pub const PRIX16: &'static [u8; 2usize] = b"X\0";
pub const PRIX32: &'static [u8; 2usize] = b"X\0";
pub const PRIX64: &'static [u8; 3usize] = b"lX\0";
pub const PRIXLEAST8: &'static [u8; 2usize] = b"X\0";
pub const PRIXLEAST16: &'static [u8; 2usize] = b"X\0";
pub const PRIXLEAST32: &'static [u8; 2usize] = b"X\0";
pub const PRIXLEAST64: &'static [u8; 3usize] = b"lX\0";
pub const PRIXFAST8: &'static [u8; 2usize] = b"X\0";
pub const PRIXFAST16: &'static [u8; 3usize] = b"lX\0";
pub const PRIXFAST32: &'static [u8; 3usize] = b"lX\0";
pub const PRIXFAST64: &'static [u8; 3usize] = b"lX\0";
pub const PRIdMAX: &'static [u8; 3usize] = b"ld\0";
pub const PRIiMAX: &'static [u8; 3usize] = b"li\0";
pub const PRIoMAX: &'static [u8; 3usize] = b"lo\0";
pub const PRIuMAX: &'static [u8; 3usize] = b"lu\0";
pub const PRIxMAX: &'static [u8; 3usize] = b"lx\0";
pub const PRIXMAX: &'static [u8; 3usize] = b"lX\0";
pub const PRIdPTR: &'static [u8; 3usize] = b"ld\0";
pub const PRIiPTR: &'static [u8; 3usize] = b"li\0";
pub const PRIoPTR: &'static [u8; 3usize] = b"lo\0";
pub const PRIuPTR: &'static [u8; 3usize] = b"lu\0";
pub const PRIxPTR: &'static [u8; 3usize] = b"lx\0";
pub const PRIXPTR: &'static [u8; 3usize] = b"lX\0";
pub const SCNd8: &'static [u8; 4usize] = b"hhd\0";
pub const SCNd16: &'static [u8; 3usize] = b"hd\0";
pub const SCNd32: &'static [u8; 2usize] = b"d\0";
pub const SCNd64: &'static [u8; 3usize] = b"ld\0";
pub const SCNdLEAST8: &'static [u8; 4usize] = b"hhd\0";
pub const SCNdLEAST16: &'static [u8; 3usize] = b"hd\0";
pub const SCNdLEAST32: &'static [u8; 2usize] = b"d\0";
pub const SCNdLEAST64: &'static [u8; 3usize] = b"ld\0";
pub const SCNdFAST8: &'static [u8; 4usize] = b"hhd\0";
pub const SCNdFAST16: &'static [u8; 3usize] = b"ld\0";
pub const SCNdFAST32: &'static [u8; 3usize] = b"ld\0";
pub const SCNdFAST64: &'static [u8; 3usize] = b"ld\0";
pub const SCNi8: &'static [u8; 4usize] = b"hhi\0";
pub const SCNi16: &'static [u8; 3usize] = b"hi\0";
pub const SCNi32: &'static [u8; 2usize] = b"i\0";
pub const SCNi64: &'static [u8; 3usize] = b"li\0";
pub const SCNiLEAST8: &'static [u8; 4usize] = b"hhi\0";
pub const SCNiLEAST16: &'static [u8; 3usize] = b"hi\0";
pub const SCNiLEAST32: &'static [u8; 2usize] = b"i\0";
pub const SCNiLEAST64: &'static [u8; 3usize] = b"li\0";
pub const SCNiFAST8: &'static [u8; 4usize] = b"hhi\0";
pub const SCNiFAST16: &'static [u8; 3usize] = b"li\0";
pub const SCNiFAST32: &'static [u8; 3usize] = b"li\0";
pub const SCNiFAST64: &'static [u8; 3usize] = b"li\0";
pub const SCNu8: &'static [u8; 4usize] = b"hhu\0";
pub const SCNu16: &'static [u8; 3usize] = b"hu\0";
pub const SCNu32: &'static [u8; 2usize] = b"u\0";
pub const SCNu64: &'static [u8; 3usize] = b"lu\0";
pub const SCNuLEAST8: &'static [u8; 4usize] = b"hhu\0";
pub const SCNuLEAST16: &'static [u8; 3usize] = b"hu\0";
pub const SCNuLEAST32: &'static [u8; 2usize] = b"u\0";
pub const SCNuLEAST64: &'static [u8; 3usize] = b"lu\0";
pub const SCNuFAST8: &'static [u8; 4usize] = b"hhu\0";
pub const SCNuFAST16: &'static [u8; 3usize] = b"lu\0";
pub const SCNuFAST32: &'static [u8; 3usize] = b"lu\0";
pub const SCNuFAST64: &'static [u8; 3usize] = b"lu\0";
pub const SCNo8: &'static [u8; 4usize] = b"hho\0";
pub const SCNo16: &'static [u8; 3usize] = b"ho\0";
pub const SCNo32: &'static [u8; 2usize] = b"o\0";
pub const SCNo64: &'static [u8; 3usize] = b"lo\0";
pub const SCNoLEAST8: &'static [u8; 4usize] = b"hho\0";
pub const SCNoLEAST16: &'static [u8; 3usize] = b"ho\0";
pub const SCNoLEAST32: &'static [u8; 2usize] = b"o\0";
pub const SCNoLEAST64: &'static [u8; 3usize] = b"lo\0";
pub const SCNoFAST8: &'static [u8; 4usize] = b"hho\0";
pub const SCNoFAST16: &'static [u8; 3usize] = b"lo\0";
pub const SCNoFAST32: &'static [u8; 3usize] = b"lo\0";
pub const SCNoFAST64: &'static [u8; 3usize] = b"lo\0";
pub const SCNx8: &'static [u8; 4usize] = b"hhx\0";
pub const SCNx16: &'static [u8; 3usize] = b"hx\0";
pub const SCNx32: &'static [u8; 2usize] = b"x\0";
pub const SCNx64: &'static [u8; 3usize] = b"lx\0";
pub const SCNxLEAST8: &'static [u8; 4usize] = b"hhx\0";
pub const SCNxLEAST16: &'static [u8; 3usize] = b"hx\0";
pub const SCNxLEAST32: &'static [u8; 2usize] = b"x\0";
pub const SCNxLEAST64: &'static [u8; 3usize] = b"lx\0";
pub const SCNxFAST8: &'static [u8; 4usize] = b"hhx\0";
pub const SCNxFAST16: &'static [u8; 3usize] = b"lx\0";
pub const SCNxFAST32: &'static [u8; 3usize] = b"lx\0";
pub const SCNxFAST64: &'static [u8; 3usize] = b"lx\0";
pub const SCNdMAX: &'static [u8; 3usize] = b"ld\0";
pub const SCNiMAX: &'static [u8; 3usize] = b"li\0";
pub const SCNoMAX: &'static [u8; 3usize] = b"lo\0";
pub const SCNuMAX: &'static [u8; 3usize] = b"lu\0";
pub const SCNxMAX: &'static [u8; 3usize] = b"lx\0";
pub const SCNdPTR: &'static [u8; 3usize] = b"ld\0";
pub const SCNiPTR: &'static [u8; 3usize] = b"li\0";
pub const SCNoPTR: &'static [u8; 3usize] = b"lo\0";
pub const SCNuPTR: &'static [u8; 3usize] = b"lu\0";
pub const SCNxPTR: &'static [u8; 3usize] = b"lx\0";
pub const _STDIO_H: u32 = 1;
pub const _BITS_TYPES_H: u32 = 1;
pub const _BITS_TYPESIZES_H: u32 = 1;
pub const __FD_SETSIZE: u32 = 1024;
pub const __FILE_defined: u32 = 1;
pub const ____FILE_defined: u32 = 1;
pub const _G_config_h: u32 = 1;
pub const __mbstate_t_defined: u32 = 1;
pub const _G_HAVE_BOOL: u32 = 1;
pub const _G_HAVE_ATEXIT: u32 = 1;
pub const _G_HAVE_SYS_CDEFS: u32 = 1;
pub const _G_HAVE_SYS_WAIT: u32 = 1;
pub const _G_NEED_STDARG_H: u32 = 1;
pub const _G_HAVE_PRINTF_FP: u32 = 1;
pub const _G_HAVE_MMAP: u32 = 1;
pub const _G_HAVE_MREMAP: u32 = 1;
pub const _G_HAVE_LONG_DOUBLE_IO: u32 = 1;
pub const _G_HAVE_IO_FILE_OPEN: u32 = 1;
pub const _G_HAVE_IO_GETLINE_INFO: u32 = 1;
pub const _G_IO_IO_FILE_VERSION: u32 = 131073;
pub const _G_BUFSIZ: u32 = 8192;
pub const _G_NAMES_HAVE_UNDERSCORE: u32 = 0;
pub const _G_VTABLE_LABEL_HAS_LENGTH: u32 = 1;
pub const _G_USING_THUNKS: u32 = 1;
pub const _G_VTABLE_LABEL_PREFIX: &'static [u8; 6usize] = b"__vt_\0";
pub const _IO_HAVE_SYS_WAIT: u32 = 1;
pub const _IO_BUFSIZ: u32 = 8192;
pub const __GNUC_VA_LIST: u32 = 1;
pub const _IO_UNIFIED_JUMPTABLES: u32 = 1;
pub const EOF: i32 = -1;
pub const _IOS_INPUT: u32 = 1;
pub const _IOS_OUTPUT: u32 = 2;
pub const _IOS_ATEND: u32 = 4;
pub const _IOS_APPEND: u32 = 8;
pub const _IOS_TRUNC: u32 = 16;
pub const _IOS_NOCREATE: u32 = 32;
pub const _IOS_NOREPLACE: u32 = 64;
pub const _IOS_BIN: u32 = 128;
pub const _IO_MAGIC: u32 = 4222418944;
pub const _OLD_STDIO_MAGIC: u32 = 4206624768;
pub const _IO_MAGIC_MASK: u32 = 4294901760;
pub const _IO_USER_BUF: u32 = 1;
pub const _IO_UNBUFFERED: u32 = 2;
pub const _IO_NO_READS: u32 = 4;
pub const _IO_NO_WRITES: u32 = 8;
pub const _IO_EOF_SEEN: u32 = 16;
pub const _IO_ERR_SEEN: u32 = 32;
pub const _IO_DELETE_DONT_CLOSE: u32 = 64;
pub const _IO_LINKED: u32 = 128;
pub const _IO_IN_BACKUP: u32 = 256;
pub const _IO_LINE_BUF: u32 = 512;
pub const _IO_TIED_PUT_GET: u32 = 1024;
pub const _IO_CURRENTLY_PUTTING: u32 = 2048;
pub const _IO_IS_APPENDING: u32 = 4096;
pub const _IO_IS_FILEBUF: u32 = 8192;
pub const _IO_BAD_SEEN: u32 = 16384;
pub const _IO_USER_LOCK: u32 = 32768;
pub const _IO_FLAGS2_MMAP: u32 = 1;
pub const _IO_FLAGS2_NOTCANCEL: u32 = 2;
pub const _IO_FLAGS2_USER_WBUF: u32 = 8;
pub const _IO_SKIPWS: u32 = 1;
pub const _IO_LEFT: u32 = 2;
pub const _IO_RIGHT: u32 = 4;
pub const _IO_INTERNAL: u32 = 8;
pub const _IO_DEC: u32 = 16;
pub const _IO_OCT: u32 = 32;
pub const _IO_HEX: u32 = 64;
pub const _IO_SHOWBASE: u32 = 128;
pub const _IO_SHOWPOINT: u32 = 256;
pub const _IO_UPPERCASE: u32 = 512;
pub const _IO_SHOWPOS: u32 = 1024;
pub const _IO_SCIENTIFIC: u32 = 2048;
pub const _IO_FIXED: u32 = 4096;
pub const _IO_UNITBUF: u32 = 8192;
pub const _IO_STDIO: u32 = 16384;
pub const _IO_DONT_CLOSE: u32 = 32768;
pub const _IO_BOOLALPHA: u32 = 65536;
pub const _IOFBF: u32 = 0;
pub const _IOLBF: u32 = 1;
pub const _IONBF: u32 = 2;
pub const BUFSIZ: u32 = 8192;
pub const SEEK_SET: u32 = 0;
pub const SEEK_CUR: u32 = 1;
pub const SEEK_END: u32 = 2;
pub const P_tmpdir: &'static [u8; 5usize] = b"/tmp\0";
pub const L_tmpnam: u32 = 20;
pub const TMP_MAX: u32 = 238328;
pub const FILENAME_MAX: u32 = 4096;
pub const L_ctermid: u32 = 9;
pub const FOPEN_MAX: u32 = 16;
pub const HTS_PATH_SEPARATOR_CHAR: u8 = 58u8;
pub const HTS_PATH_SEPARATOR_STR: &'static [u8; 2usize] = b":\0";
pub const HTS_RESIZE_CLEAR: u32 = 1;
pub const HTS_IDX_DELIM: &'static [u8; 8usize] = b"##idx##\0";
pub const HTS_VERSION: u32 = 101002;
pub const HTS_IDX_NOCOOR: i32 = -2;
pub const HTS_IDX_START: i32 = -3;
pub const HTS_IDX_REST: i32 = -4;
pub const HTS_IDX_NONE: i32 = -5;
pub const HTS_FMT_CSI: u32 = 0;
pub const HTS_FMT_BAI: u32 = 1;
pub const HTS_FMT_TBI: u32 = 2;
pub const HTS_FMT_CRAI: u32 = 3;
pub const PRIhts_pos: &'static [u8; 3usize] = b"ld\0";
pub const HTS_IDX_SAVE_REMOTE: u32 = 1;
pub const HTS_IDX_SILENT_FAIL: u32 = 2;
pub const HTS_PARSE_THOUSANDS_SEP: u32 = 1;
pub const HTS_PARSE_ONE_COORD: u32 = 2;
pub const HTS_PARSE_LIST: u32 = 4;
pub const FT_UNKN: u32 = 0;
pub const FT_GZ: u32 = 1;
pub const FT_VCF: u32 = 2;
pub const FT_VCF_GZ: u32 = 3;
pub const FT_BCF: u32 = 4;
pub const FT_BCF_GZ: u32 = 5;
pub const FT_STDIN: u32 = 8;
pub const _LIBC_LIMITS_H_: u32 = 1;
pub const MB_LEN_MAX: u32 = 16;
pub const _BITS_POSIX1_LIM_H: u32 = 1;
pub const _POSIX_AIO_LISTIO_MAX: u32 = 2;
pub const _POSIX_AIO_MAX: u32 = 1;
pub const _POSIX_ARG_MAX: u32 = 4096;
pub const _POSIX_CHILD_MAX: u32 = 25;
pub const _POSIX_DELAYTIMER_MAX: u32 = 32;
pub const _POSIX_HOST_NAME_MAX: u32 = 255;
pub const _POSIX_LINK_MAX: u32 = 8;
pub const _POSIX_LOGIN_NAME_MAX: u32 = 9;
pub const _POSIX_MAX_CANON: u32 = 255;
pub const _POSIX_MAX_INPUT: u32 = 255;
pub const _POSIX_MQ_OPEN_MAX: u32 = 8;
pub const _POSIX_MQ_PRIO_MAX: u32 = 32;
pub const _POSIX_NAME_MAX: u32 = 14;
pub const _POSIX_NGROUPS_MAX: u32 = 8;
pub const _POSIX_OPEN_MAX: u32 = 20;
pub const _POSIX_PATH_MAX: u32 = 256;
pub const _POSIX_PIPE_BUF: u32 = 512;
pub const _POSIX_RE_DUP_MAX: u32 = 255;
pub const _POSIX_RTSIG_MAX: u32 = 8;
pub const _POSIX_SEM_NSEMS_MAX: u32 = 256;
pub const _POSIX_SEM_VALUE_MAX: u32 = 32767;
pub const _POSIX_SIGQUEUE_MAX: u32 = 32;
pub const _POSIX_SSIZE_MAX: u32 = 32767;
pub const _POSIX_STREAM_MAX: u32 = 8;
pub const _POSIX_SYMLINK_MAX: u32 = 255;
pub const _POSIX_SYMLOOP_MAX: u32 = 8;
pub const _POSIX_TIMER_MAX: u32 = 32;
pub const _POSIX_TTY_NAME_MAX: u32 = 9;
pub const _POSIX_TZNAME_MAX: u32 = 6;
pub const _POSIX_CLOCKRES_MIN: u32 = 20000000;
pub const NR_OPEN: u32 = 1024;
pub const NGROUPS_MAX: u32 = 65536;
pub const ARG_MAX: u32 = 131072;
pub const LINK_MAX: u32 = 127;
pub const MAX_CANON: u32 = 255;
pub const MAX_INPUT: u32 = 255;
pub const NAME_MAX: u32 = 255;
pub const PATH_MAX: u32 = 4096;
pub const PIPE_BUF: u32 = 4096;
pub const XATTR_NAME_MAX: u32 = 255;
pub const XATTR_SIZE_MAX: u32 = 65536;
pub const XATTR_LIST_MAX: u32 = 65536;
pub const RTSIG_MAX: u32 = 32;
pub const _POSIX_THREAD_KEYS_MAX: u32 = 128;
pub const PTHREAD_KEYS_MAX: u32 = 1024;
pub const _POSIX_THREAD_DESTRUCTOR_ITERATIONS: u32 = 4;
pub const PTHREAD_DESTRUCTOR_ITERATIONS: u32 = 4;
pub const _POSIX_THREAD_THREADS_MAX: u32 = 64;
pub const AIO_PRIO_DELTA_MAX: u32 = 20;
pub const PTHREAD_STACK_MIN: u32 = 16384;
pub const DELAYTIMER_MAX: u32 = 2147483647;
pub const TTY_NAME_MAX: u32 = 32;
pub const LOGIN_NAME_MAX: u32 = 256;
pub const HOST_NAME_MAX: u32 = 64;
pub const MQ_PRIO_MAX: u32 = 32768;
pub const SEM_VALUE_MAX: u32 = 2147483647;
pub const _BITS_POSIX2_LIM_H: u32 = 1;
pub const _POSIX2_BC_BASE_MAX: u32 = 99;
pub const _POSIX2_BC_DIM_MAX: u32 = 2048;
pub const _POSIX2_BC_SCALE_MAX: u32 = 99;
pub const _POSIX2_BC_STRING_MAX: u32 = 1000;
pub const _POSIX2_COLL_WEIGHTS_MAX: u32 = 2;
pub const _POSIX2_EXPR_NEST_MAX: u32 = 32;
pub const _POSIX2_LINE_MAX: u32 = 2048;
pub const _POSIX2_RE_DUP_MAX: u32 = 255;
pub const _POSIX2_CHARCLASS_NAME_MAX: u32 = 14;
pub const BC_BASE_MAX: u32 = 99;
pub const BC_DIM_MAX: u32 = 2048;
pub const BC_SCALE_MAX: u32 = 99;
pub const BC_STRING_MAX: u32 = 1000;
pub const COLL_WEIGHTS_MAX: u32 = 255;
pub const EXPR_NEST_MAX: u32 = 32;
pub const LINE_MAX: u32 = 2048;
pub const CHARCLASS_NAME_MAX: u32 = 2048;
pub const RE_DUP_MAX: u32 = 32767;
pub const _ASSERT_H: u32 = 1;
pub const _ERRNO_H: u32 = 1;
pub const EPERM: u32 = 1;
pub const ENOENT: u32 = 2;
pub const ESRCH: u32 = 3;
pub const EINTR: u32 = 4;
pub const EIO: u32 = 5;
pub const ENXIO: u32 = 6;
pub const E2BIG: u32 = 7;
pub const ENOEXEC: u32 = 8;
pub const EBADF: u32 = 9;
pub const ECHILD: u32 = 10;
pub const EAGAIN: u32 = 11;
pub const ENOMEM: u32 = 12;
pub const EACCES: u32 = 13;
pub const EFAULT: u32 = 14;
pub const ENOTBLK: u32 = 15;
pub const EBUSY: u32 = 16;
pub const EEXIST: u32 = 17;
pub const EXDEV: u32 = 18;
pub const ENODEV: u32 = 19;
pub const ENOTDIR: u32 = 20;
pub const EISDIR: u32 = 21;
pub const EINVAL: u32 = 22;
pub const ENFILE: u32 = 23;
pub const EMFILE: u32 = 24;
pub const ENOTTY: u32 = 25;
pub const ETXTBSY: u32 = 26;
pub const EFBIG: u32 = 27;
pub const ENOSPC: u32 = 28;
pub const ESPIPE: u32 = 29;
pub const EROFS: u32 = 30;
pub const EMLINK: u32 = 31;
pub const EPIPE: u32 = 32;
pub const EDOM: u32 = 33;
pub const ERANGE: u32 = 34;
pub const EDEADLK: u32 = 35;
pub const ENAMETOOLONG: u32 = 36;
pub const ENOLCK: u32 = 37;
pub const ENOSYS: u32 = 38;
pub const ENOTEMPTY: u32 = 39;
pub const ELOOP: u32 = 40;
pub const EWOULDBLOCK: u32 = 11;
pub const ENOMSG: u32 = 42;
pub const EIDRM: u32 = 43;
pub const ECHRNG: u32 = 44;
pub const EL2NSYNC: u32 = 45;
pub const EL3HLT: u32 = 46;
pub const EL3RST: u32 = 47;
pub const ELNRNG: u32 = 48;
pub const EUNATCH: u32 = 49;
pub const ENOCSI: u32 = 50;
pub const EL2HLT: u32 = 51;
pub const EBADE: u32 = 52;
pub const EBADR: u32 = 53;
pub const EXFULL: u32 = 54;
pub const ENOANO: u32 = 55;
pub const EBADRQC: u32 = 56;
pub const EBADSLT: u32 = 57;
pub const EDEADLOCK: u32 = 35;
pub const EBFONT: u32 = 59;
pub const ENOSTR: u32 = 60;
pub const ENODATA: u32 = 61;
pub const ETIME: u32 = 62;
pub const ENOSR: u32 = 63;
pub const ENONET: u32 = 64;
pub const ENOPKG: u32 = 65;
pub const EREMOTE: u32 = 66;
pub const ENOLINK: u32 = 67;
pub const EADV: u32 = 68;
pub const ESRMNT: u32 = 69;
pub const ECOMM: u32 = 70;
pub const EPROTO: u32 = 71;
pub const EMULTIHOP: u32 = 72;
pub const EDOTDOT: u32 = 73;
pub const EBADMSG: u32 = 74;
pub const EOVERFLOW: u32 = 75;
pub const ENOTUNIQ: u32 = 76;
pub const EBADFD: u32 = 77;
pub const EREMCHG: u32 = 78;
pub const ELIBACC: u32 = 79;
pub const ELIBBAD: u32 = 80;
pub const ELIBSCN: u32 = 81;
pub const ELIBMAX: u32 = 82;
pub const ELIBEXEC: u32 = 83;
pub const EILSEQ: u32 = 84;
pub const ERESTART: u32 = 85;
pub const ESTRPIPE: u32 = 86;
pub const EUSERS: u32 = 87;
pub const ENOTSOCK: u32 = 88;
pub const EDESTADDRREQ: u32 = 89;
pub const EMSGSIZE: u32 = 90;
pub const EPROTOTYPE: u32 = 91;
pub const ENOPROTOOPT: u32 = 92;
pub const EPROTONOSUPPORT: u32 = 93;
pub const ESOCKTNOSUPPORT: u32 = 94;
pub const EOPNOTSUPP: u32 = 95;
pub const EPFNOSUPPORT: u32 = 96;
pub const EAFNOSUPPORT: u32 = 97;
pub const EADDRINUSE: u32 = 98;
pub const EADDRNOTAVAIL: u32 = 99;
pub const ENETDOWN: u32 = 100;
pub const ENETUNREACH: u32 = 101;
pub const ENETRESET: u32 = 102;
pub const ECONNABORTED: u32 = 103;
pub const ECONNRESET: u32 = 104;
pub const ENOBUFS: u32 = 105;
pub const EISCONN: u32 = 106;
pub const ENOTCONN: u32 = 107;
pub const ESHUTDOWN: u32 = 108;
pub const ETOOMANYREFS: u32 = 109;
pub const ETIMEDOUT: u32 = 110;
pub const ECONNREFUSED: u32 = 111;
pub const EHOSTDOWN: u32 = 112;
pub const EHOSTUNREACH: u32 = 113;
pub const EALREADY: u32 = 114;
pub const EINPROGRESS: u32 = 115;
pub const ESTALE: u32 = 116;
pub const EUCLEAN: u32 = 117;
pub const ENOTNAM: u32 = 118;
pub const ENAVAIL: u32 = 119;
pub const EISNAM: u32 = 120;
pub const EREMOTEIO: u32 = 121;
pub const EDQUOT: u32 = 122;
pub const ENOMEDIUM: u32 = 123;
pub const EMEDIUMTYPE: u32 = 124;
pub const ECANCELED: u32 = 125;
pub const ENOKEY: u32 = 126;
pub const EKEYEXPIRED: u32 = 127;
pub const EKEYREVOKED: u32 = 128;
pub const EKEYREJECTED: u32 = 129;
pub const EOWNERDEAD: u32 = 130;
pub const ENOTRECOVERABLE: u32 = 131;
pub const ERFKILL: u32 = 132;
pub const ENOTSUP: u32 = 95;
pub const _STDLIB_H: u32 = 1;
pub const WNOHANG: u32 = 1;
pub const WUNTRACED: u32 = 2;
pub const WSTOPPED: u32 = 2;
pub const WEXITED: u32 = 4;
pub const WCONTINUED: u32 = 8;
pub const WNOWAIT: u32 = 16777216;
pub const __WNOTHREAD: u32 = 536870912;
pub const __WALL: u32 = 1073741824;
pub const __WCLONE: u32 = 2147483648;
pub const __W_CONTINUED: u32 = 65535;
pub const __WCOREFLAG: u32 = 128;
pub const _ENDIAN_H: u32 = 1;
pub const __LITTLE_ENDIAN: u32 = 1234;
pub const __BIG_ENDIAN: u32 = 4321;
pub const __PDP_ENDIAN: u32 = 3412;
pub const __BYTE_ORDER: u32 = 1234;
pub const __FLOAT_WORD_ORDER: u32 = 1234;
pub const LITTLE_ENDIAN: u32 = 1234;
pub const BIG_ENDIAN: u32 = 4321;
pub const PDP_ENDIAN: u32 = 3412;
pub const BYTE_ORDER: u32 = 1234;
pub const _BITS_BYTESWAP_H: u32 = 1;
pub const __ldiv_t_defined: u32 = 1;
pub const __lldiv_t_defined: u32 = 1;
pub const RAND_MAX: u32 = 2147483647;
pub const EXIT_FAILURE: u32 = 1;
pub const EXIT_SUCCESS: u32 = 0;
pub const _SYS_TYPES_H: u32 = 1;
pub const __clock_t_defined: u32 = 1;
pub const __time_t_defined: u32 = 1;
pub const __clockid_t_defined: u32 = 1;
pub const __timer_t_defined: u32 = 1;
pub const __BIT_TYPES_DEFINED__: u32 = 1;
pub const _SYS_SELECT_H: u32 = 1;
pub const __FD_ZERO_STOS: &'static [u8; 6usize] = b"stosq\0";
pub const _SIGSET_H_types: u32 = 1;
pub const __timespec_defined: u32 = 1;
pub const _STRUCT_TIMEVAL: u32 = 1;
pub const FD_SETSIZE: u32 = 1024;
pub const _SYS_SYSMACROS_H: u32 = 1;
pub const _BITS_PTHREADTYPES_H: u32 = 1;
pub const __SIZEOF_PTHREAD_ATTR_T: u32 = 56;
pub const __SIZEOF_PTHREAD_MUTEX_T: u32 = 40;
pub const __SIZEOF_PTHREAD_MUTEXATTR_T: u32 = 4;
pub const __SIZEOF_PTHREAD_COND_T: u32 = 48;
pub const __SIZEOF_PTHREAD_CONDATTR_T: u32 = 4;
pub const __SIZEOF_PTHREAD_RWLOCK_T: u32 = 56;
pub const __SIZEOF_PTHREAD_RWLOCKATTR_T: u32 = 8;
pub const __SIZEOF_PTHREAD_BARRIER_T: u32 = 32;
pub const __SIZEOF_PTHREAD_BARRIERATTR_T: u32 = 4;
pub const __PTHREAD_MUTEX_HAVE_PREV: u32 = 1;
pub const _ALLOCA_H: u32 = 1;
pub const _STRING_H: u32 = 1;
pub const _XLOCALE_H: u32 = 1;
pub const HAVE___BUILTIN_CLZ: u32 = 1;
pub const HTS_ALLOW_UNALIGNED: u32 = 1;
pub const BCF_HL_FLT: u32 = 0;
pub const BCF_HL_INFO: u32 = 1;
pub const BCF_HL_FMT: u32 = 2;
pub const BCF_HL_CTG: u32 = 3;
pub const BCF_HL_STR: u32 = 4;
pub const BCF_HL_GEN: u32 = 5;
pub const BCF_HT_FLAG: u32 = 0;
pub const BCF_HT_INT: u32 = 1;
pub const BCF_HT_REAL: u32 = 2;
pub const BCF_HT_STR: u32 = 3;
pub const BCF_HT_LONG: u32 = 257;
pub const BCF_VL_FIXED: u32 = 0;
pub const BCF_VL_VAR: u32 = 1;
pub const BCF_VL_A: u32 = 2;
pub const BCF_VL_G: u32 = 3;
pub const BCF_VL_R: u32 = 4;
pub const BCF_DT_ID: u32 = 0;
pub const BCF_DT_CTG: u32 = 1;
pub const BCF_DT_SAMPLE: u32 = 2;
pub const BCF_BT_NULL: u32 = 0;
pub const BCF_BT_INT8: u32 = 1;
pub const BCF_BT_INT16: u32 = 2;
pub const BCF_BT_INT32: u32 = 3;
pub const BCF_BT_INT64: u32 = 4;
pub const BCF_BT_FLOAT: u32 = 5;
pub const BCF_BT_CHAR: u32 = 7;
pub const VCF_REF: u32 = 0;
pub const VCF_SNP: u32 = 1;
pub const VCF_MNP: u32 = 2;
pub const VCF_INDEL: u32 = 4;
pub const VCF_OTHER: u32 = 8;
pub const VCF_BND: u32 = 16;
pub const VCF_OVERLAP: u32 = 32;
pub const BCF1_DIRTY_ID: u32 = 1;
pub const BCF1_DIRTY_ALS: u32 = 2;
pub const BCF1_DIRTY_FLT: u32 = 4;
pub const BCF1_DIRTY_INF: u32 = 8;
pub const BCF_ERR_CTG_UNDEF: u32 = 1;
pub const BCF_ERR_TAG_UNDEF: u32 = 2;
pub const BCF_ERR_NCOLS: u32 = 4;
pub const BCF_ERR_LIMITS: u32 = 8;
pub const BCF_ERR_CHAR: u32 = 16;
pub const BCF_ERR_CTG_INVALID: u32 = 32;
pub const BCF_ERR_TAG_INVALID: u32 = 64;
pub const BCF_UN_STR: u32 = 1;
pub const BCF_UN_FLT: u32 = 2;
pub const BCF_UN_INFO: u32 = 4;
pub const BCF_UN_SHR: u32 = 7;
pub const BCF_UN_FMT: u32 = 8;
pub const BCF_UN_IND: u32 = 8;
pub const BCF_UN_ALL: u32 = 15;
pub const bcf_gt_missing: u32 = 0;
pub const bcf_int8_vector_end: i32 = -127;
pub const bcf_int16_vector_end: i32 = -32767;
pub const bcf_int32_vector_end: i32 = -2147483647;
pub const bcf_int64_vector_end: i64 = -9223372036854775807;
pub const bcf_str_vector_end: u32 = 0;
pub const bcf_int8_missing: i32 = -128;
pub const bcf_int16_missing: i32 = -32768;
pub const bcf_int32_missing: i32 = -2147483648;
pub const bcf_int64_missing: i64 = -9223372036854775808;
pub const bcf_str_missing: u32 = 7;
pub const BCF_MAX_BT_INT8: u32 = 127;
pub const BCF_MAX_BT_INT16: u32 = 32767;
pub const BCF_MAX_BT_INT32: u32 = 2147483647;
pub const BCF_MIN_BT_INT8: i32 = -120;
pub const BCF_MIN_BT_INT16: i32 = -32760;
pub const BCF_MIN_BT_INT32: i32 = -2147483640;
pub const SAM_FORMAT_VERSION: &'static [u8; 4usize] = b"1.6\0";
pub const BAM_CMATCH: u32 = 0;
pub const BAM_CINS: u32 = 1;
pub const BAM_CDEL: u32 = 2;
pub const BAM_CREF_SKIP: u32 = 3;
pub const BAM_CSOFT_CLIP: u32 = 4;
pub const BAM_CHARD_CLIP: u32 = 5;
pub const BAM_CPAD: u32 = 6;
pub const BAM_CEQUAL: u32 = 7;
pub const BAM_CDIFF: u32 = 8;
pub const BAM_CBACK: u32 = 9;
pub const BAM_CIGAR_STR: &'static [u8; 11usize] = b"MIDNSHP=XB\0";
pub const BAM_CIGAR_SHIFT: u32 = 4;
pub const BAM_CIGAR_MASK: u32 = 15;
pub const BAM_CIGAR_TYPE: u32 = 246183;
pub const BAM_FPAIRED: u32 = 1;
pub const BAM_FPROPER_PAIR: u32 = 2;
pub const BAM_FUNMAP: u32 = 4;
pub const BAM_FMUNMAP: u32 = 8;
pub const BAM_FREVERSE: u32 = 16;
pub const BAM_FMREVERSE: u32 = 32;
pub const BAM_FREAD1: u32 = 64;
pub const BAM_FREAD2: u32 = 128;
pub const BAM_FSECONDARY: u32 = 256;
pub const BAM_FQCFAIL: u32 = 512;
pub const BAM_FDUP: u32 = 1024;
pub const BAM_FSUPPLEMENTARY: u32 = 2048;
pub const BAM_USER_OWNS_STRUCT: u32 = 1;
pub const BAM_USER_OWNS_DATA: u32 = 2;
pub const BGZF_BLOCK_SIZE: u32 = 65280;
pub const BGZF_MAX_BLOCK_SIZE: u32 = 65536;
pub const BGZF_ERR_ZLIB: u32 = 1;
pub const BGZF_ERR_HEADER: u32 = 2;
pub const BGZF_ERR_IO: u32 = 4;
pub const BGZF_ERR_MISUSE: u32 = 8;
pub const BGZF_ERR_MT: u32 = 16;
pub const BGZF_ERR_CRC: u32 = 32;
pub const GT_HOM_RR: u32 = 0;
pub const GT_HOM_AA: u32 = 1;
pub const GT_HET_RA: u32 = 2;
pub const GT_HET_AA: u32 = 3;
pub const GT_HAPL_R: u32 = 4;
pub const GT_HAPL_A: u32 = 5;
pub const GT_UNKN: u32 = 6;
pub const TBX_MAX_SHIFT: u32 = 31;
pub const TBX_GENERIC: u32 = 0;
pub const TBX_SAM: u32 = 1;
pub const TBX_VCF: u32 = 2;
pub const TBX_UCSC: u32 = 65536;
pub const COLLAPSE_NONE: u32 = 0;
pub const COLLAPSE_SNPS: u32 = 1;
pub const COLLAPSE_INDELS: u32 = 2;
pub const COLLAPSE_ANY: u32 = 4;
pub const COLLAPSE_SOME: u32 = 8;
pub const COLLAPSE_BOTH: u32 = 3;
pub const BCF_SR_PAIR_SNPS: u32 = 1;
pub const BCF_SR_PAIR_INDELS: u32 = 2;
pub const BCF_SR_PAIR_ANY: u32 = 4;
pub const BCF_SR_PAIR_SOME: u32 = 8;
pub const BCF_SR_PAIR_SNP_REF: u32 = 16;
pub const BCF_SR_PAIR_INDEL_REF: u32 = 32;
pub const BCF_SR_PAIR_EXACT: u32 = 64;
pub const BCF_SR_PAIR_BOTH: u32 = 3;
pub const BCF_SR_PAIR_BOTH_REF: u32 = 51;
pub type size_t = ::std::os::raw::c_ulong;
pub type wchar_t = ::std::os::raw::c_int;
pub type int_least8_t = ::std::os::raw::c_schar;
pub type int_least16_t = ::std::os::raw::c_short;
pub type int_least32_t = ::std::os::raw::c_int;
pub type int_least64_t = ::std::os::raw::c_long;
pub type uint_least8_t = ::std::os::raw::c_uchar;
pub type uint_least16_t = ::std::os::raw::c_ushort;
pub type uint_least32_t = ::std::os::raw::c_uint;
pub type uint_least64_t = ::std::os::raw::c_ulong;
pub type int_fast8_t = ::std::os::raw::c_schar;
pub type int_fast16_t = ::std::os::raw::c_long;
pub type int_fast32_t = ::std::os::raw::c_long;
pub type int_fast64_t = ::std::os::raw::c_long;
pub type uint_fast8_t = ::std::os::raw::c_uchar;
pub type uint_fast16_t = ::std::os::raw::c_ulong;
pub type uint_fast32_t = ::std::os::raw::c_ulong;
pub type uint_fast64_t = ::std::os::raw::c_ulong;
pub type intmax_t = ::std::os::raw::c_long;
pub type uintmax_t = ::std::os::raw::c_ulong;
pub type __gwchar_t = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct imaxdiv_t {
    pub quot: ::std::os::raw::c_long,
    pub rem: ::std::os::raw::c_long,
}
#[test]
fn bindgen_test_layout_imaxdiv_t() {
    assert_eq!(
        ::std::mem::size_of::<imaxdiv_t>(),
        16usize,
        concat!("Size of: ", stringify!(imaxdiv_t))
    );
    assert_eq!(
        ::std::mem::align_of::<imaxdiv_t>(),
        8usize,
        concat!("Alignment of ", stringify!(imaxdiv_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<imaxdiv_t>())).quot as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(imaxdiv_t),
            "::",
            stringify!(quot)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<imaxdiv_t>())).rem as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(imaxdiv_t),
            "::",
            stringify!(rem)
        )
    );
}
extern "C" {
    pub fn imaxabs(__n: intmax_t) -> intmax_t;
}
extern "C" {
    pub fn imaxdiv(__numer: intmax_t, __denom: intmax_t) -> imaxdiv_t;
}
extern "C" {
    pub fn strtoimax(
        __nptr: *const ::std::os::raw::c_char,
        __endptr: *mut *mut ::std::os::raw::c_char,
        __base: ::std::os::raw::c_int,
    ) -> intmax_t;
}
extern "C" {
    pub fn strtoumax(
        __nptr: *const ::std::os::raw::c_char,
        __endptr: *mut *mut ::std::os::raw::c_char,
        __base: ::std::os::raw::c_int,
    ) -> uintmax_t;
}
extern "C" {
    pub fn wcstoimax(
        __nptr: *const __gwchar_t,
        __endptr: *mut *mut __gwchar_t,
        __base: ::std::os::raw::c_int,
    ) -> intmax_t;
}
extern "C" {
    pub fn wcstoumax(
        __nptr: *const __gwchar_t,
        __endptr: *mut *mut __gwchar_t,
        __base: ::std::os::raw::c_int,
    ) -> uintmax_t;
}
pub type __u_char = ::std::os::raw::c_uchar;
pub type __u_short = ::std::os::raw::c_ushort;
pub type __u_int = ::std::os::raw::c_uint;
pub type __u_long = ::std::os::raw::c_ulong;
pub type __int8_t = ::std::os::raw::c_schar;
pub type __uint8_t = ::std::os::raw::c_uchar;
pub type __int16_t = ::std::os::raw::c_short;
pub type __uint16_t = ::std::os::raw::c_ushort;
pub type __int32_t = ::std::os::raw::c_int;
pub type __uint32_t = ::std::os::raw::c_uint;
pub type __int64_t = ::std::os::raw::c_long;
pub type __uint64_t = ::std::os::raw::c_ulong;
pub type __quad_t = ::std::os::raw::c_long;
pub type __u_quad_t = ::std::os::raw::c_ulong;
pub type __dev_t = ::std::os::raw::c_ulong;
pub type __uid_t = ::std::os::raw::c_uint;
pub type __gid_t = ::std::os::raw::c_uint;
pub type __ino_t = ::std::os::raw::c_ulong;
pub type __ino64_t = ::std::os::raw::c_ulong;
pub type __mode_t = ::std::os::raw::c_uint;
pub type __nlink_t = ::std::os::raw::c_ulong;
pub type __off_t = ::std::os::raw::c_long;
pub type __off64_t = ::std::os::raw::c_long;
pub type __pid_t = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __fsid_t {
    pub __val: [::std::os::raw::c_int; 2usize],
}
#[test]
fn bindgen_test_layout___fsid_t() {
    assert_eq!(
        ::std::mem::size_of::<__fsid_t>(),
        8usize,
        concat!("Size of: ", stringify!(__fsid_t))
    );
    assert_eq!(
        ::std::mem::align_of::<__fsid_t>(),
        4usize,
        concat!("Alignment of ", stringify!(__fsid_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__fsid_t>())).__val as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__fsid_t),
            "::",
            stringify!(__val)
        )
    );
}
pub type __clock_t = ::std::os::raw::c_long;
pub type __rlim_t = ::std::os::raw::c_ulong;
pub type __rlim64_t = ::std::os::raw::c_ulong;
pub type __id_t = ::std::os::raw::c_uint;
pub type __time_t = ::std::os::raw::c_long;
pub type __useconds_t = ::std::os::raw::c_uint;
pub type __suseconds_t = ::std::os::raw::c_long;
pub type __daddr_t = ::std::os::raw::c_int;
pub type __swblk_t = ::std::os::raw::c_long;
pub type __key_t = ::std::os::raw::c_int;
pub type __clockid_t = ::std::os::raw::c_int;
pub type __timer_t = *mut ::std::os::raw::c_void;
pub type __blksize_t = ::std::os::raw::c_long;
pub type __blkcnt_t = ::std::os::raw::c_long;
pub type __blkcnt64_t = ::std::os::raw::c_long;
pub type __fsblkcnt_t = ::std::os::raw::c_ulong;
pub type __fsblkcnt64_t = ::std::os::raw::c_ulong;
pub type __fsfilcnt_t = ::std::os::raw::c_ulong;
pub type __fsfilcnt64_t = ::std::os::raw::c_ulong;
pub type __ssize_t = ::std::os::raw::c_long;
pub type __loff_t = __off64_t;
pub type __qaddr_t = *mut __quad_t;
pub type __caddr_t = *mut ::std::os::raw::c_char;
pub type __intptr_t = ::std::os::raw::c_long;
pub type __socklen_t = ::std::os::raw::c_uint;
pub type FILE = _IO_FILE;
pub type __FILE = _IO_FILE;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct __mbstate_t {
    pub __count: ::std::os::raw::c_int,
    pub __value: __mbstate_t__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union __mbstate_t__bindgen_ty_1 {
    pub __wch: ::std::os::raw::c_uint,
    pub __wchb: [::std::os::raw::c_char; 4usize],
    _bindgen_union_align: u32,
}
#[test]
fn bindgen_test_layout___mbstate_t__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<__mbstate_t__bindgen_ty_1>(),
        4usize,
        concat!("Size of: ", stringify!(__mbstate_t__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<__mbstate_t__bindgen_ty_1>(),
        4usize,
        concat!("Alignment of ", stringify!(__mbstate_t__bindgen_ty_1))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__mbstate_t__bindgen_ty_1>())).__wch as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__mbstate_t__bindgen_ty_1),
            "::",
            stringify!(__wch)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__mbstate_t__bindgen_ty_1>())).__wchb as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__mbstate_t__bindgen_ty_1),
            "::",
            stringify!(__wchb)
        )
    );
}
#[test]
fn bindgen_test_layout___mbstate_t() {
    assert_eq!(
        ::std::mem::size_of::<__mbstate_t>(),
        8usize,
        concat!("Size of: ", stringify!(__mbstate_t))
    );
    assert_eq!(
        ::std::mem::align_of::<__mbstate_t>(),
        4usize,
        concat!("Alignment of ", stringify!(__mbstate_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__mbstate_t>())).__count as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__mbstate_t),
            "::",
            stringify!(__count)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__mbstate_t>())).__value as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(__mbstate_t),
            "::",
            stringify!(__value)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _G_fpos_t {
    pub __pos: __off_t,
    pub __state: __mbstate_t,
}
#[test]
fn bindgen_test_layout__G_fpos_t() {
    assert_eq!(
        ::std::mem::size_of::<_G_fpos_t>(),
        16usize,
        concat!("Size of: ", stringify!(_G_fpos_t))
    );
    assert_eq!(
        ::std::mem::align_of::<_G_fpos_t>(),
        8usize,
        concat!("Alignment of ", stringify!(_G_fpos_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_G_fpos_t>())).__pos as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_G_fpos_t),
            "::",
            stringify!(__pos)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_G_fpos_t>())).__state as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_G_fpos_t),
            "::",
            stringify!(__state)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _G_fpos64_t {
    pub __pos: __off64_t,
    pub __state: __mbstate_t,
}
#[test]
fn bindgen_test_layout__G_fpos64_t() {
    assert_eq!(
        ::std::mem::size_of::<_G_fpos64_t>(),
        16usize,
        concat!("Size of: ", stringify!(_G_fpos64_t))
    );
    assert_eq!(
        ::std::mem::align_of::<_G_fpos64_t>(),
        8usize,
        concat!("Alignment of ", stringify!(_G_fpos64_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_G_fpos64_t>())).__pos as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_G_fpos64_t),
            "::",
            stringify!(__pos)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_G_fpos64_t>())).__state as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_G_fpos64_t),
            "::",
            stringify!(__state)
        )
    );
}
pub type _G_int16_t = ::std::os::raw::c_short;
pub type _G_int32_t = ::std::os::raw::c_int;
pub type _G_uint16_t = ::std::os::raw::c_ushort;
pub type _G_uint32_t = ::std::os::raw::c_uint;
pub type va_list = __builtin_va_list;
pub type __gnuc_va_list = __builtin_va_list;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _IO_jump_t {
    _unused: [u8; 0],
}
pub type _IO_lock_t = ::std::os::raw::c_void;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _IO_marker {
    pub _next: *mut _IO_marker,
    pub _sbuf: *mut _IO_FILE,
    pub _pos: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout__IO_marker() {
    assert_eq!(
        ::std::mem::size_of::<_IO_marker>(),
        24usize,
        concat!("Size of: ", stringify!(_IO_marker))
    );
    assert_eq!(
        ::std::mem::align_of::<_IO_marker>(),
        8usize,
        concat!("Alignment of ", stringify!(_IO_marker))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_marker>()))._next as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_marker),
            "::",
            stringify!(_next)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_marker>()))._sbuf as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_marker),
            "::",
            stringify!(_sbuf)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_marker>()))._pos as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_marker),
            "::",
            stringify!(_pos)
        )
    );
}
pub const __codecvt_result___codecvt_ok: __codecvt_result = 0;
pub const __codecvt_result___codecvt_partial: __codecvt_result = 1;
pub const __codecvt_result___codecvt_error: __codecvt_result = 2;
pub const __codecvt_result___codecvt_noconv: __codecvt_result = 3;
pub type __codecvt_result = u32;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _IO_FILE {
    pub _flags: ::std::os::raw::c_int,
    pub _IO_read_ptr: *mut ::std::os::raw::c_char,
    pub _IO_read_end: *mut ::std::os::raw::c_char,
    pub _IO_read_base: *mut ::std::os::raw::c_char,
    pub _IO_write_base: *mut ::std::os::raw::c_char,
    pub _IO_write_ptr: *mut ::std::os::raw::c_char,
    pub _IO_write_end: *mut ::std::os::raw::c_char,
    pub _IO_buf_base: *mut ::std::os::raw::c_char,
    pub _IO_buf_end: *mut ::std::os::raw::c_char,
    pub _IO_save_base: *mut ::std::os::raw::c_char,
    pub _IO_backup_base: *mut ::std::os::raw::c_char,
    pub _IO_save_end: *mut ::std::os::raw::c_char,
    pub _markers: *mut _IO_marker,
    pub _chain: *mut _IO_FILE,
    pub _fileno: ::std::os::raw::c_int,
    pub _flags2: ::std::os::raw::c_int,
    pub _old_offset: __off_t,
    pub _cur_column: ::std::os::raw::c_ushort,
    pub _vtable_offset: ::std::os::raw::c_schar,
    pub _shortbuf: [::std::os::raw::c_char; 1usize],
    pub _lock: *mut _IO_lock_t,
    pub _offset: __off64_t,
    pub __pad1: *mut ::std::os::raw::c_void,
    pub __pad2: *mut ::std::os::raw::c_void,
    pub __pad3: *mut ::std::os::raw::c_void,
    pub __pad4: *mut ::std::os::raw::c_void,
    pub __pad5: size_t,
    pub _mode: ::std::os::raw::c_int,
    pub _unused2: [::std::os::raw::c_char; 20usize],
}
#[test]
fn bindgen_test_layout__IO_FILE() {
    assert_eq!(
        ::std::mem::size_of::<_IO_FILE>(),
        216usize,
        concat!("Size of: ", stringify!(_IO_FILE))
    );
    assert_eq!(
        ::std::mem::align_of::<_IO_FILE>(),
        8usize,
        concat!("Alignment of ", stringify!(_IO_FILE))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._flags as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._IO_read_ptr as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_IO_read_ptr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._IO_read_end as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_IO_read_end)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._IO_read_base as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_IO_read_base)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._IO_write_base as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_IO_write_base)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._IO_write_ptr as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_IO_write_ptr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._IO_write_end as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_IO_write_end)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._IO_buf_base as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_IO_buf_base)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._IO_buf_end as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_IO_buf_end)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._IO_save_base as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_IO_save_base)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._IO_backup_base as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_IO_backup_base)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._IO_save_end as *const _ as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_IO_save_end)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._markers as *const _ as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_markers)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._chain as *const _ as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_chain)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._fileno as *const _ as usize },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_fileno)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._flags2 as *const _ as usize },
        116usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_flags2)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._old_offset as *const _ as usize },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_old_offset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._cur_column as *const _ as usize },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_cur_column)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._vtable_offset as *const _ as usize },
        130usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_vtable_offset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._shortbuf as *const _ as usize },
        131usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_shortbuf)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._lock as *const _ as usize },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_lock)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._offset as *const _ as usize },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_offset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>())).__pad1 as *const _ as usize },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(__pad1)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>())).__pad2 as *const _ as usize },
        160usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(__pad2)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>())).__pad3 as *const _ as usize },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(__pad3)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>())).__pad4 as *const _ as usize },
        176usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(__pad4)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>())).__pad5 as *const _ as usize },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(__pad5)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._mode as *const _ as usize },
        192usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_mode)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._unused2 as *const _ as usize },
        196usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_unused2)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _IO_FILE_plus {
    _unused: [u8; 0],
}
extern "C" {
    pub static mut _IO_2_1_stdin_: _IO_FILE_plus;
}
extern "C" {
    pub static mut _IO_2_1_stdout_: _IO_FILE_plus;
}
extern "C" {
    pub static mut _IO_2_1_stderr_: _IO_FILE_plus;
}
pub type __io_read_fn = ::std::option::Option<
    unsafe extern "C" fn(
        __cookie: *mut ::std::os::raw::c_void,
        __buf: *mut ::std::os::raw::c_char,
        __nbytes: size_t,
    ) -> __ssize_t,
>;
pub type __io_write_fn = ::std::option::Option<
    unsafe extern "C" fn(
        __cookie: *mut ::std::os::raw::c_void,
        __buf: *const ::std::os::raw::c_char,
        __n: size_t,
    ) -> __ssize_t,
>;
pub type __io_seek_fn = ::std::option::Option<
    unsafe extern "C" fn(
        __cookie: *mut ::std::os::raw::c_void,
        __pos: *mut __off64_t,
        __w: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int,
>;
pub type __io_close_fn = ::std::option::Option<
    unsafe extern "C" fn(__cookie: *mut ::std::os::raw::c_void) -> ::std::os::raw::c_int,
>;
extern "C" {
    pub fn __underflow(arg1: *mut _IO_FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __uflow(arg1: *mut _IO_FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __overflow(arg1: *mut _IO_FILE, arg2: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _IO_getc(__fp: *mut _IO_FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _IO_putc(__c: ::std::os::raw::c_int, __fp: *mut _IO_FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _IO_feof(__fp: *mut _IO_FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _IO_ferror(__fp: *mut _IO_FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _IO_peekc_locked(__fp: *mut _IO_FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _IO_flockfile(arg1: *mut _IO_FILE);
}
extern "C" {
    pub fn _IO_funlockfile(arg1: *mut _IO_FILE);
}
extern "C" {
    pub fn _IO_ftrylockfile(arg1: *mut _IO_FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _IO_vfscanf(
        arg1: *mut _IO_FILE,
        arg2: *const ::std::os::raw::c_char,
        arg3: *mut __va_list_tag,
        arg4: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _IO_vfprintf(
        arg1: *mut _IO_FILE,
        arg2: *const ::std::os::raw::c_char,
        arg3: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _IO_padn(arg1: *mut _IO_FILE, arg2: ::std::os::raw::c_int, arg3: __ssize_t)
        -> __ssize_t;
}
extern "C" {
    pub fn _IO_sgetn(
        arg1: *mut _IO_FILE,
        arg2: *mut ::std::os::raw::c_void,
        arg3: size_t,
    ) -> size_t;
}
extern "C" {
    pub fn _IO_seekoff(
        arg1: *mut _IO_FILE,
        arg2: __off64_t,
        arg3: ::std::os::raw::c_int,
        arg4: ::std::os::raw::c_int,
    ) -> __off64_t;
}
extern "C" {
    pub fn _IO_seekpos(
        arg1: *mut _IO_FILE,
        arg2: __off64_t,
        arg3: ::std::os::raw::c_int,
    ) -> __off64_t;
}
extern "C" {
    pub fn _IO_free_backup_area(arg1: *mut _IO_FILE);
}
pub type off_t = __off_t;
pub type ssize_t = __ssize_t;
pub type fpos_t = _G_fpos_t;
extern "C" {
    pub static mut stdin: *mut _IO_FILE;
}
extern "C" {
    pub static mut stdout: *mut _IO_FILE;
}
extern "C" {
    pub static mut stderr: *mut _IO_FILE;
}
extern "C" {
    pub fn remove(__filename: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rename(
        __old: *const ::std::os::raw::c_char,
        __new: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn renameat(
        __oldfd: ::std::os::raw::c_int,
        __old: *const ::std::os::raw::c_char,
        __newfd: ::std::os::raw::c_int,
        __new: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn tmpfile() -> *mut FILE;
}
extern "C" {
    pub fn tmpnam(__s: *mut ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn tmpnam_r(__s: *mut ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn tempnam(
        __dir: *const ::std::os::raw::c_char,
        __pfx: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn fclose(__stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fflush(__stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fflush_unlocked(__stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fopen(
        __filename: *const ::std::os::raw::c_char,
        __modes: *const ::std::os::raw::c_char,
    ) -> *mut FILE;
}
extern "C" {
    pub fn freopen(
        __filename: *const ::std::os::raw::c_char,
        __modes: *const ::std::os::raw::c_char,
        __stream: *mut FILE,
    ) -> *mut FILE;
}
extern "C" {
    pub fn fdopen(__fd: ::std::os::raw::c_int, __modes: *const ::std::os::raw::c_char)
        -> *mut FILE;
}
extern "C" {
    pub fn fmemopen(
        __s: *mut ::std::os::raw::c_void,
        __len: size_t,
        __modes: *const ::std::os::raw::c_char,
    ) -> *mut FILE;
}
extern "C" {
    pub fn open_memstream(
        __bufloc: *mut *mut ::std::os::raw::c_char,
        __sizeloc: *mut size_t,
    ) -> *mut FILE;
}
extern "C" {
    pub fn setbuf(__stream: *mut FILE, __buf: *mut ::std::os::raw::c_char);
}
extern "C" {
    pub fn setvbuf(
        __stream: *mut FILE,
        __buf: *mut ::std::os::raw::c_char,
        __modes: ::std::os::raw::c_int,
        __n: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn setbuffer(__stream: *mut FILE, __buf: *mut ::std::os::raw::c_char, __size: size_t);
}
extern "C" {
    pub fn setlinebuf(__stream: *mut FILE);
}
extern "C" {
    pub fn fprintf(
        __stream: *mut FILE,
        __format: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn printf(__format: *const ::std::os::raw::c_char, ...) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sprintf(
        __s: *mut ::std::os::raw::c_char,
        __format: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn vfprintf(
        __s: *mut FILE,
        __format: *const ::std::os::raw::c_char,
        __arg: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn vprintf(
        __format: *const ::std::os::raw::c_char,
        __arg: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn vsprintf(
        __s: *mut ::std::os::raw::c_char,
        __format: *const ::std::os::raw::c_char,
        __arg: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snprintf(
        __s: *mut ::std::os::raw::c_char,
        __maxlen: ::std::os::raw::c_ulong,
        __format: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn vsnprintf(
        __s: *mut ::std::os::raw::c_char,
        __maxlen: ::std::os::raw::c_ulong,
        __format: *const ::std::os::raw::c_char,
        __arg: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn vdprintf(
        __fd: ::std::os::raw::c_int,
        __fmt: *const ::std::os::raw::c_char,
        __arg: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn dprintf(
        __fd: ::std::os::raw::c_int,
        __fmt: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fscanf(
        __stream: *mut FILE,
        __format: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn scanf(__format: *const ::std::os::raw::c_char, ...) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sscanf(
        __s: *const ::std::os::raw::c_char,
        __format: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}__isoc99_fscanf"]
    pub fn fscanf1(
        __stream: *mut FILE,
        __format: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}__isoc99_scanf"]
    pub fn scanf1(__format: *const ::std::os::raw::c_char, ...) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}__isoc99_sscanf"]
    pub fn sscanf1(
        __s: *const ::std::os::raw::c_char,
        __format: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn vfscanf(
        __s: *mut FILE,
        __format: *const ::std::os::raw::c_char,
        __arg: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn vscanf(
        __format: *const ::std::os::raw::c_char,
        __arg: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn vsscanf(
        __s: *const ::std::os::raw::c_char,
        __format: *const ::std::os::raw::c_char,
        __arg: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}__isoc99_vfscanf"]
    pub fn vfscanf1(
        __s: *mut FILE,
        __format: *const ::std::os::raw::c_char,
        __arg: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}__isoc99_vscanf"]
    pub fn vscanf1(
        __format: *const ::std::os::raw::c_char,
        __arg: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}__isoc99_vsscanf"]
    pub fn vsscanf1(
        __s: *const ::std::os::raw::c_char,
        __format: *const ::std::os::raw::c_char,
        __arg: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fgetc(__stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getc(__stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getchar() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getc_unlocked(__stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getchar_unlocked() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fgetc_unlocked(__stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fputc(__c: ::std::os::raw::c_int, __stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn putc(__c: ::std::os::raw::c_int, __stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn putchar(__c: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fputc_unlocked(__c: ::std::os::raw::c_int, __stream: *mut FILE)
        -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn putc_unlocked(__c: ::std::os::raw::c_int, __stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn putchar_unlocked(__c: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getw(__stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn putw(__w: ::std::os::raw::c_int, __stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fgets(
        __s: *mut ::std::os::raw::c_char,
        __n: ::std::os::raw::c_int,
        __stream: *mut FILE,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn gets(__s: *mut ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn __getdelim(
        __lineptr: *mut *mut ::std::os::raw::c_char,
        __n: *mut size_t,
        __delimiter: ::std::os::raw::c_int,
        __stream: *mut FILE,
    ) -> __ssize_t;
}
extern "C" {
    pub fn getdelim(
        __lineptr: *mut *mut ::std::os::raw::c_char,
        __n: *mut size_t,
        __delimiter: ::std::os::raw::c_int,
        __stream: *mut FILE,
    ) -> __ssize_t;
}
extern "C" {
    pub fn getline(
        __lineptr: *mut *mut ::std::os::raw::c_char,
        __n: *mut size_t,
        __stream: *mut FILE,
    ) -> __ssize_t;
}
extern "C" {
    pub fn fputs(__s: *const ::std::os::raw::c_char, __stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn puts(__s: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ungetc(__c: ::std::os::raw::c_int, __stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fread(
        __ptr: *mut ::std::os::raw::c_void,
        __size: ::std::os::raw::c_ulong,
        __n: ::std::os::raw::c_ulong,
        __stream: *mut FILE,
    ) -> ::std::os::raw::c_ulong;
}
extern "C" {
    pub fn fwrite(
        __ptr: *const ::std::os::raw::c_void,
        __size: ::std::os::raw::c_ulong,
        __n: ::std::os::raw::c_ulong,
        __s: *mut FILE,
    ) -> ::std::os::raw::c_ulong;
}
extern "C" {
    pub fn fread_unlocked(
        __ptr: *mut ::std::os::raw::c_void,
        __size: size_t,
        __n: size_t,
        __stream: *mut FILE,
    ) -> size_t;
}
extern "C" {
    pub fn fwrite_unlocked(
        __ptr: *const ::std::os::raw::c_void,
        __size: size_t,
        __n: size_t,
        __stream: *mut FILE,
    ) -> size_t;
}
extern "C" {
    pub fn fseek(
        __stream: *mut FILE,
        __off: ::std::os::raw::c_long,
        __whence: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ftell(__stream: *mut FILE) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn rewind(__stream: *mut FILE);
}
extern "C" {
    pub fn fseeko(
        __stream: *mut FILE,
        __off: __off_t,
        __whence: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ftello(__stream: *mut FILE) -> __off_t;
}
extern "C" {
    pub fn fgetpos(__stream: *mut FILE, __pos: *mut fpos_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fsetpos(__stream: *mut FILE, __pos: *const fpos_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn clearerr(__stream: *mut FILE);
}
extern "C" {
    pub fn feof(__stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ferror(__stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn clearerr_unlocked(__stream: *mut FILE);
}
extern "C" {
    pub fn feof_unlocked(__stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ferror_unlocked(__stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn perror(__s: *const ::std::os::raw::c_char);
}
extern "C" {
    pub static mut sys_nerr: ::std::os::raw::c_int;
}
extern "C" {
    pub static mut sys_errlist: [*const ::std::os::raw::c_char; 0usize];
}
extern "C" {
    pub fn fileno(__stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fileno_unlocked(__stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn popen(
        __command: *const ::std::os::raw::c_char,
        __modes: *const ::std::os::raw::c_char,
    ) -> *mut FILE;
}
extern "C" {
    pub fn pclose(__stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ctermid(__s: *mut ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn flockfile(__stream: *mut FILE);
}
extern "C" {
    pub fn ftrylockfile(__stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn funlockfile(__stream: *mut FILE);
}
pub const htsLogLevel_HTS_LOG_OFF: htsLogLevel = 0;
pub const htsLogLevel_HTS_LOG_ERROR: htsLogLevel = 1;
pub const htsLogLevel_HTS_LOG_WARNING: htsLogLevel = 3;
pub const htsLogLevel_HTS_LOG_INFO: htsLogLevel = 4;
pub const htsLogLevel_HTS_LOG_DEBUG: htsLogLevel = 5;
pub const htsLogLevel_HTS_LOG_TRACE: htsLogLevel = 6;
pub type htsLogLevel = u32;
extern "C" {
    pub fn hts_set_log_level(level: htsLogLevel);
}
extern "C" {
    pub fn hts_get_log_level() -> htsLogLevel;
}
extern "C" {
    pub static mut hts_verbose: ::std::os::raw::c_int;
}
extern "C" {
    pub fn hts_log(
        severity: htsLogLevel,
        context: *const ::std::os::raw::c_char,
        format: *const ::std::os::raw::c_char,
        ...
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cram_fd {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hFILE {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hts_tpool {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct kstring_t {
    pub l: size_t,
    pub m: size_t,
    pub s: *mut ::std::os::raw::c_char,
}
#[test]
fn bindgen_test_layout_kstring_t() {
    assert_eq!(
        ::std::mem::size_of::<kstring_t>(),
        24usize,
        concat!("Size of: ", stringify!(kstring_t))
    );
    assert_eq!(
        ::std::mem::align_of::<kstring_t>(),
        8usize,
        concat!("Alignment of ", stringify!(kstring_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kstring_t>())).l as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kstring_t),
            "::",
            stringify!(l)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kstring_t>())).m as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kstring_t),
            "::",
            stringify!(m)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kstring_t>())).s as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(kstring_t),
            "::",
            stringify!(s)
        )
    );
}
extern "C" {
    pub fn hts_resize_array_(
        arg1: size_t,
        arg2: size_t,
        arg3: size_t,
        arg4: *mut ::std::os::raw::c_void,
        arg5: *mut *mut ::std::os::raw::c_void,
        arg6: ::std::os::raw::c_int,
        arg7: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn hts_free(ptr: *mut ::std::os::raw::c_void);
}
pub const htsFormatCategory_unknown_category: htsFormatCategory = 0;
pub const htsFormatCategory_sequence_data: htsFormatCategory = 1;
pub const htsFormatCategory_variant_data: htsFormatCategory = 2;
pub const htsFormatCategory_index_file: htsFormatCategory = 3;
pub const htsFormatCategory_region_list: htsFormatCategory = 4;
pub const htsFormatCategory_category_maximum: htsFormatCategory = 32767;
pub type htsFormatCategory = u32;
pub const htsExactFormat_unknown_format: htsExactFormat = 0;
pub const htsExactFormat_binary_format: htsExactFormat = 1;
pub const htsExactFormat_text_format: htsExactFormat = 2;
pub const htsExactFormat_sam: htsExactFormat = 3;
pub const htsExactFormat_bam: htsExactFormat = 4;
pub const htsExactFormat_bai: htsExactFormat = 5;
pub const htsExactFormat_cram: htsExactFormat = 6;
pub const htsExactFormat_crai: htsExactFormat = 7;
pub const htsExactFormat_vcf: htsExactFormat = 8;
pub const htsExactFormat_bcf: htsExactFormat = 9;
pub const htsExactFormat_csi: htsExactFormat = 10;
pub const htsExactFormat_gzi: htsExactFormat = 11;
pub const htsExactFormat_tbi: htsExactFormat = 12;
pub const htsExactFormat_bed: htsExactFormat = 13;
pub const htsExactFormat_htsget: htsExactFormat = 14;
pub const htsExactFormat_json: htsExactFormat = 14;
pub const htsExactFormat_empty_format: htsExactFormat = 15;
pub const htsExactFormat_fasta_format: htsExactFormat = 16;
pub const htsExactFormat_fastq_format: htsExactFormat = 17;
pub const htsExactFormat_fai_format: htsExactFormat = 18;
pub const htsExactFormat_fqi_format: htsExactFormat = 19;
pub const htsExactFormat_format_maximum: htsExactFormat = 32767;
pub type htsExactFormat = u32;
pub const htsCompression_no_compression: htsCompression = 0;
pub const htsCompression_gzip: htsCompression = 1;
pub const htsCompression_bgzf: htsCompression = 2;
pub const htsCompression_custom: htsCompression = 3;
pub const htsCompression_bzip2_compression: htsCompression = 4;
pub const htsCompression_compression_maximum: htsCompression = 32767;
pub type htsCompression = u32;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct htsFormat {
    pub category: htsFormatCategory,
    pub format: htsExactFormat,
    pub version: htsFormat__bindgen_ty_1,
    pub compression: htsCompression,
    pub compression_level: ::std::os::raw::c_short,
    pub specific: *mut ::std::os::raw::c_void,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct htsFormat__bindgen_ty_1 {
    pub major: ::std::os::raw::c_short,
    pub minor: ::std::os::raw::c_short,
}
#[test]
fn bindgen_test_layout_htsFormat__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<htsFormat__bindgen_ty_1>(),
        4usize,
        concat!("Size of: ", stringify!(htsFormat__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<htsFormat__bindgen_ty_1>(),
        2usize,
        concat!("Alignment of ", stringify!(htsFormat__bindgen_ty_1))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<htsFormat__bindgen_ty_1>())).major as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(htsFormat__bindgen_ty_1),
            "::",
            stringify!(major)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<htsFormat__bindgen_ty_1>())).minor as *const _ as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(htsFormat__bindgen_ty_1),
            "::",
            stringify!(minor)
        )
    );
}
#[test]
fn bindgen_test_layout_htsFormat() {
    assert_eq!(
        ::std::mem::size_of::<htsFormat>(),
        32usize,
        concat!("Size of: ", stringify!(htsFormat))
    );
    assert_eq!(
        ::std::mem::align_of::<htsFormat>(),
        8usize,
        concat!("Alignment of ", stringify!(htsFormat))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<htsFormat>())).category as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(htsFormat),
            "::",
            stringify!(category)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<htsFormat>())).format as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(htsFormat),
            "::",
            stringify!(format)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<htsFormat>())).version as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(htsFormat),
            "::",
            stringify!(version)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<htsFormat>())).compression as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(htsFormat),
            "::",
            stringify!(compression)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<htsFormat>())).compression_level as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(htsFormat),
            "::",
            stringify!(compression_level)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<htsFormat>())).specific as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(htsFormat),
            "::",
            stringify!(specific)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __hts_idx_t {
    _unused: [u8; 0],
}
pub type hts_idx_t = __hts_idx_t;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct htsFile {
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize], u32>,
    pub lineno: i64,
    pub line: kstring_t,
    pub fn_: *mut ::std::os::raw::c_char,
    pub fn_aux: *mut ::std::os::raw::c_char,
    pub fp: htsFile__bindgen_ty_1,
    pub state: *mut ::std::os::raw::c_void,
    pub format: htsFormat,
    pub idx: *mut hts_idx_t,
    pub fnidx: *const ::std::os::raw::c_char,
    pub bam_header: *mut sam_hdr_t,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union htsFile__bindgen_ty_1 {
    pub bgzf: *mut BGZF,
    pub cram: *mut cram_fd,
    pub hfile: *mut hFILE,
    _bindgen_union_align: u64,
}
#[test]
fn bindgen_test_layout_htsFile__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<htsFile__bindgen_ty_1>(),
        8usize,
        concat!("Size of: ", stringify!(htsFile__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<htsFile__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(htsFile__bindgen_ty_1))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<htsFile__bindgen_ty_1>())).bgzf as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(htsFile__bindgen_ty_1),
            "::",
            stringify!(bgzf)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<htsFile__bindgen_ty_1>())).cram as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(htsFile__bindgen_ty_1),
            "::",
            stringify!(cram)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<htsFile__bindgen_ty_1>())).hfile as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(htsFile__bindgen_ty_1),
            "::",
            stringify!(hfile)
        )
    );
}
#[test]
fn bindgen_test_layout_htsFile() {
    assert_eq!(
        ::std::mem::size_of::<htsFile>(),
        128usize,
        concat!("Size of: ", stringify!(htsFile))
    );
    assert_eq!(
        ::std::mem::align_of::<htsFile>(),
        8usize,
        concat!("Alignment of ", stringify!(htsFile))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<htsFile>())).lineno as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(htsFile),
            "::",
            stringify!(lineno)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<htsFile>())).line as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(htsFile),
            "::",
            stringify!(line)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<htsFile>())).fn_ as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(htsFile),
            "::",
            stringify!(fn_)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<htsFile>())).fn_aux as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(htsFile),
            "::",
            stringify!(fn_aux)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<htsFile>())).fp as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(htsFile),
            "::",
            stringify!(fp)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<htsFile>())).state as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(htsFile),
            "::",
            stringify!(state)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<htsFile>())).format as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(htsFile),
            "::",
            stringify!(format)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<htsFile>())).idx as *const _ as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(htsFile),
            "::",
            stringify!(idx)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<htsFile>())).fnidx as *const _ as usize },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(htsFile),
            "::",
            stringify!(fnidx)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<htsFile>())).bam_header as *const _ as usize },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(htsFile),
            "::",
            stringify!(bam_header)
        )
    );
}
impl htsFile {
    #[inline]
    pub fn is_bin(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_is_bin(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn is_write(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_is_write(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn is_be(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_is_be(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn is_cram(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_is_cram(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn is_bgzf(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_is_bgzf(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn dummy(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(5usize, 27u8) as u32) }
    }
    #[inline]
    pub fn set_dummy(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(5usize, 27u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        is_bin: u32,
        is_write: u32,
        is_be: u32,
        is_cram: u32,
        is_bgzf: u32,
        dummy: u32,
    ) -> __BindgenBitfieldUnit<[u8; 4usize], u32> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize], u32> =
            Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let is_bin: u32 = unsafe { ::std::mem::transmute(is_bin) };
            is_bin as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let is_write: u32 = unsafe { ::std::mem::transmute(is_write) };
            is_write as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let is_be: u32 = unsafe { ::std::mem::transmute(is_be) };
            is_be as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let is_cram: u32 = unsafe { ::std::mem::transmute(is_cram) };
            is_cram as u64
        });
        __bindgen_bitfield_unit.set(4usize, 1u8, {
            let is_bgzf: u32 = unsafe { ::std::mem::transmute(is_bgzf) };
            is_bgzf as u64
        });
        __bindgen_bitfield_unit.set(5usize, 27u8, {
            let dummy: u32 = unsafe { ::std::mem::transmute(dummy) };
            dummy as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct htsThreadPool {
    pub pool: *mut hts_tpool,
    pub qsize: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_htsThreadPool() {
    assert_eq!(
        ::std::mem::size_of::<htsThreadPool>(),
        16usize,
        concat!("Size of: ", stringify!(htsThreadPool))
    );
    assert_eq!(
        ::std::mem::align_of::<htsThreadPool>(),
        8usize,
        concat!("Alignment of ", stringify!(htsThreadPool))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<htsThreadPool>())).pool as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(htsThreadPool),
            "::",
            stringify!(pool)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<htsThreadPool>())).qsize as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(htsThreadPool),
            "::",
            stringify!(qsize)
        )
    );
}
pub const sam_fields_SAM_QNAME: sam_fields = 1;
pub const sam_fields_SAM_FLAG: sam_fields = 2;
pub const sam_fields_SAM_RNAME: sam_fields = 4;
pub const sam_fields_SAM_POS: sam_fields = 8;
pub const sam_fields_SAM_MAPQ: sam_fields = 16;
pub const sam_fields_SAM_CIGAR: sam_fields = 32;
pub const sam_fields_SAM_RNEXT: sam_fields = 64;
pub const sam_fields_SAM_PNEXT: sam_fields = 128;
pub const sam_fields_SAM_TLEN: sam_fields = 256;
pub const sam_fields_SAM_SEQ: sam_fields = 512;
pub const sam_fields_SAM_QUAL: sam_fields = 1024;
pub const sam_fields_SAM_AUX: sam_fields = 2048;
pub const sam_fields_SAM_RGAUX: sam_fields = 4096;
pub type sam_fields = u32;
pub const hts_fmt_option_CRAM_OPT_DECODE_MD: hts_fmt_option = 0;
pub const hts_fmt_option_CRAM_OPT_PREFIX: hts_fmt_option = 1;
pub const hts_fmt_option_CRAM_OPT_VERBOSITY: hts_fmt_option = 2;
pub const hts_fmt_option_CRAM_OPT_SEQS_PER_SLICE: hts_fmt_option = 3;
pub const hts_fmt_option_CRAM_OPT_SLICES_PER_CONTAINER: hts_fmt_option = 4;
pub const hts_fmt_option_CRAM_OPT_RANGE: hts_fmt_option = 5;
pub const hts_fmt_option_CRAM_OPT_VERSION: hts_fmt_option = 6;
pub const hts_fmt_option_CRAM_OPT_EMBED_REF: hts_fmt_option = 7;
pub const hts_fmt_option_CRAM_OPT_IGNORE_MD5: hts_fmt_option = 8;
pub const hts_fmt_option_CRAM_OPT_REFERENCE: hts_fmt_option = 9;
pub const hts_fmt_option_CRAM_OPT_MULTI_SEQ_PER_SLICE: hts_fmt_option = 10;
pub const hts_fmt_option_CRAM_OPT_NO_REF: hts_fmt_option = 11;
pub const hts_fmt_option_CRAM_OPT_USE_BZIP2: hts_fmt_option = 12;
pub const hts_fmt_option_CRAM_OPT_SHARED_REF: hts_fmt_option = 13;
pub const hts_fmt_option_CRAM_OPT_NTHREADS: hts_fmt_option = 14;
pub const hts_fmt_option_CRAM_OPT_THREAD_POOL: hts_fmt_option = 15;
pub const hts_fmt_option_CRAM_OPT_USE_LZMA: hts_fmt_option = 16;
pub const hts_fmt_option_CRAM_OPT_USE_RANS: hts_fmt_option = 17;
pub const hts_fmt_option_CRAM_OPT_REQUIRED_FIELDS: hts_fmt_option = 18;
pub const hts_fmt_option_CRAM_OPT_LOSSY_NAMES: hts_fmt_option = 19;
pub const hts_fmt_option_CRAM_OPT_BASES_PER_SLICE: hts_fmt_option = 20;
pub const hts_fmt_option_CRAM_OPT_STORE_MD: hts_fmt_option = 21;
pub const hts_fmt_option_CRAM_OPT_STORE_NM: hts_fmt_option = 22;
pub const hts_fmt_option_HTS_OPT_COMPRESSION_LEVEL: hts_fmt_option = 100;
pub const hts_fmt_option_HTS_OPT_NTHREADS: hts_fmt_option = 101;
pub const hts_fmt_option_HTS_OPT_THREAD_POOL: hts_fmt_option = 102;
pub const hts_fmt_option_HTS_OPT_CACHE_SIZE: hts_fmt_option = 103;
pub const hts_fmt_option_HTS_OPT_BLOCK_SIZE: hts_fmt_option = 104;
pub type hts_fmt_option = u32;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct hts_opt {
    pub arg: *mut ::std::os::raw::c_char,
    pub opt: hts_fmt_option,
    pub val: hts_opt__bindgen_ty_1,
    pub next: *mut hts_opt,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union hts_opt__bindgen_ty_1 {
    pub i: ::std::os::raw::c_int,
    pub s: *mut ::std::os::raw::c_char,
    _bindgen_union_align: u64,
}
#[test]
fn bindgen_test_layout_hts_opt__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<hts_opt__bindgen_ty_1>(),
        8usize,
        concat!("Size of: ", stringify!(hts_opt__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<hts_opt__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(hts_opt__bindgen_ty_1))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hts_opt__bindgen_ty_1>())).i as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(hts_opt__bindgen_ty_1),
            "::",
            stringify!(i)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hts_opt__bindgen_ty_1>())).s as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(hts_opt__bindgen_ty_1),
            "::",
            stringify!(s)
        )
    );
}
#[test]
fn bindgen_test_layout_hts_opt() {
    assert_eq!(
        ::std::mem::size_of::<hts_opt>(),
        32usize,
        concat!("Size of: ", stringify!(hts_opt))
    );
    assert_eq!(
        ::std::mem::align_of::<hts_opt>(),
        8usize,
        concat!("Alignment of ", stringify!(hts_opt))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hts_opt>())).arg as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(hts_opt),
            "::",
            stringify!(arg)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hts_opt>())).opt as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(hts_opt),
            "::",
            stringify!(opt)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hts_opt>())).val as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(hts_opt),
            "::",
            stringify!(val)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hts_opt>())).next as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(hts_opt),
            "::",
            stringify!(next)
        )
    );
}
extern "C" {
    pub fn hts_opt_add(
        opts: *mut *mut hts_opt,
        c_arg: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn hts_opt_apply(fp: *mut htsFile, opts: *mut hts_opt) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn hts_opt_free(opts: *mut hts_opt);
}
extern "C" {
    pub fn hts_parse_format(
        opt: *mut htsFormat,
        str: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn hts_parse_opt_list(
        opt: *mut htsFormat,
        str: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub static seq_nt16_table: [::std::os::raw::c_uchar; 256usize];
}
extern "C" {
    pub static mut seq_nt16_str: [::std::os::raw::c_char; 0usize];
}
extern "C" {
    pub static mut seq_nt16_int: [::std::os::raw::c_int; 0usize];
}
extern "C" {
    pub fn hts_version() -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn hts_detect_format(fp: *mut hFILE, fmt: *mut htsFormat) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn hts_format_description(format: *const htsFormat) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn hts_open(
        fn_: *const ::std::os::raw::c_char,
        mode: *const ::std::os::raw::c_char,
    ) -> *mut htsFile;
}
extern "C" {
    pub fn hts_open_format(
        fn_: *const ::std::os::raw::c_char,
        mode: *const ::std::os::raw::c_char,
        fmt: *const htsFormat,
    ) -> *mut htsFile;
}
extern "C" {
    pub fn hts_hopen(
        fp: *mut hFILE,
        fn_: *const ::std::os::raw::c_char,
        mode: *const ::std::os::raw::c_char,
    ) -> *mut htsFile;
}
extern "C" {
    pub fn hts_close(fp: *mut htsFile) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn hts_get_format(fp: *mut htsFile) -> *const htsFormat;
}
extern "C" {
    pub fn hts_format_file_extension(format: *const htsFormat) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn hts_set_opt(fp: *mut htsFile, opt: hts_fmt_option, ...) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn hts_getline(
        fp: *mut htsFile,
        delimiter: ::std::os::raw::c_int,
        str: *mut kstring_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn hts_readlines(
        fn_: *const ::std::os::raw::c_char,
        _n: *mut ::std::os::raw::c_int,
    ) -> *mut *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn hts_readlist(
        fn_: *const ::std::os::raw::c_char,
        is_file: ::std::os::raw::c_int,
        _n: *mut ::std::os::raw::c_int,
    ) -> *mut *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn hts_set_threads(fp: *mut htsFile, n: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn hts_set_thread_pool(fp: *mut htsFile, p: *mut htsThreadPool) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn hts_set_cache_size(fp: *mut htsFile, n: ::std::os::raw::c_int);
}
extern "C" {
    pub fn hts_set_fai_filename(
        fp: *mut htsFile,
        fn_aux: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn hts_check_EOF(fp: *mut htsFile) -> ::std::os::raw::c_int;
}
pub type hts_pos_t = i64;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hts_pair_pos_t {
    pub beg: hts_pos_t,
    pub end: hts_pos_t,
}
#[test]
fn bindgen_test_layout_hts_pair_pos_t() {
    assert_eq!(
        ::std::mem::size_of::<hts_pair_pos_t>(),
        16usize,
        concat!("Size of: ", stringify!(hts_pair_pos_t))
    );
    assert_eq!(
        ::std::mem::align_of::<hts_pair_pos_t>(),
        8usize,
        concat!("Alignment of ", stringify!(hts_pair_pos_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hts_pair_pos_t>())).beg as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(hts_pair_pos_t),
            "::",
            stringify!(beg)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hts_pair_pos_t>())).end as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(hts_pair_pos_t),
            "::",
            stringify!(end)
        )
    );
}
pub type hts_pair32_t = hts_pair_pos_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hts_pair64_t {
    pub u: u64,
    pub v: u64,
}
#[test]
fn bindgen_test_layout_hts_pair64_t() {
    assert_eq!(
        ::std::mem::size_of::<hts_pair64_t>(),
        16usize,
        concat!("Size of: ", stringify!(hts_pair64_t))
    );
    assert_eq!(
        ::std::mem::align_of::<hts_pair64_t>(),
        8usize,
        concat!("Alignment of ", stringify!(hts_pair64_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hts_pair64_t>())).u as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(hts_pair64_t),
            "::",
            stringify!(u)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hts_pair64_t>())).v as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(hts_pair64_t),
            "::",
            stringify!(v)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hts_pair64_max_t {
    pub u: u64,
    pub v: u64,
    pub max: u64,
}
#[test]
fn bindgen_test_layout_hts_pair64_max_t() {
    assert_eq!(
        ::std::mem::size_of::<hts_pair64_max_t>(),
        24usize,
        concat!("Size of: ", stringify!(hts_pair64_max_t))
    );
    assert_eq!(
        ::std::mem::align_of::<hts_pair64_max_t>(),
        8usize,
        concat!("Alignment of ", stringify!(hts_pair64_max_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hts_pair64_max_t>())).u as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(hts_pair64_max_t),
            "::",
            stringify!(u)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hts_pair64_max_t>())).v as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(hts_pair64_max_t),
            "::",
            stringify!(v)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hts_pair64_max_t>())).max as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(hts_pair64_max_t),
            "::",
            stringify!(max)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hts_reglist_t {
    pub reg: *const ::std::os::raw::c_char,
    pub intervals: *mut hts_pair_pos_t,
    pub tid: ::std::os::raw::c_int,
    pub count: u32,
    pub min_beg: hts_pos_t,
    pub max_end: hts_pos_t,
}
#[test]
fn bindgen_test_layout_hts_reglist_t() {
    assert_eq!(
        ::std::mem::size_of::<hts_reglist_t>(),
        40usize,
        concat!("Size of: ", stringify!(hts_reglist_t))
    );
    assert_eq!(
        ::std::mem::align_of::<hts_reglist_t>(),
        8usize,
        concat!("Alignment of ", stringify!(hts_reglist_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hts_reglist_t>())).reg as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(hts_reglist_t),
            "::",
            stringify!(reg)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hts_reglist_t>())).intervals as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(hts_reglist_t),
            "::",
            stringify!(intervals)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hts_reglist_t>())).tid as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(hts_reglist_t),
            "::",
            stringify!(tid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hts_reglist_t>())).count as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(hts_reglist_t),
            "::",
            stringify!(count)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hts_reglist_t>())).min_beg as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(hts_reglist_t),
            "::",
            stringify!(min_beg)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hts_reglist_t>())).max_end as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(hts_reglist_t),
            "::",
            stringify!(max_end)
        )
    );
}
pub type hts_readrec_func = ::std::option::Option<
    unsafe extern "C" fn(
        fp: *mut BGZF,
        data: *mut ::std::os::raw::c_void,
        r: *mut ::std::os::raw::c_void,
        tid: *mut ::std::os::raw::c_int,
        beg: *mut hts_pos_t,
        end: *mut hts_pos_t,
    ) -> ::std::os::raw::c_int,
>;
pub type hts_seek_func = ::std::option::Option<
    unsafe extern "C" fn(
        fp: *mut ::std::os::raw::c_void,
        offset: i64,
        where_: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int,
>;
pub type hts_tell_func =
    ::std::option::Option<unsafe extern "C" fn(fp: *mut ::std::os::raw::c_void) -> i64>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hts_itr_t {
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize], u32>,
    pub tid: ::std::os::raw::c_int,
    pub n_off: ::std::os::raw::c_int,
    pub i: ::std::os::raw::c_int,
    pub n_reg: ::std::os::raw::c_int,
    pub beg: hts_pos_t,
    pub end: hts_pos_t,
    pub reg_list: *mut hts_reglist_t,
    pub curr_tid: ::std::os::raw::c_int,
    pub curr_reg: ::std::os::raw::c_int,
    pub curr_intv: ::std::os::raw::c_int,
    pub curr_beg: hts_pos_t,
    pub curr_end: hts_pos_t,
    pub curr_off: u64,
    pub nocoor_off: u64,
    pub off: *mut hts_pair64_max_t,
    pub readrec: hts_readrec_func,
    pub seek: hts_seek_func,
    pub tell: hts_tell_func,
    pub bins: hts_itr_t__bindgen_ty_1,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hts_itr_t__bindgen_ty_1 {
    pub n: ::std::os::raw::c_int,
    pub m: ::std::os::raw::c_int,
    pub a: *mut ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_hts_itr_t__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<hts_itr_t__bindgen_ty_1>(),
        16usize,
        concat!("Size of: ", stringify!(hts_itr_t__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<hts_itr_t__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(hts_itr_t__bindgen_ty_1))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hts_itr_t__bindgen_ty_1>())).n as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(hts_itr_t__bindgen_ty_1),
            "::",
            stringify!(n)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hts_itr_t__bindgen_ty_1>())).m as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(hts_itr_t__bindgen_ty_1),
            "::",
            stringify!(m)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hts_itr_t__bindgen_ty_1>())).a as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(hts_itr_t__bindgen_ty_1),
            "::",
            stringify!(a)
        )
    );
}
#[test]
fn bindgen_test_layout_hts_itr_t() {
    assert_eq!(
        ::std::mem::size_of::<hts_itr_t>(),
        144usize,
        concat!("Size of: ", stringify!(hts_itr_t))
    );
    assert_eq!(
        ::std::mem::align_of::<hts_itr_t>(),
        8usize,
        concat!("Alignment of ", stringify!(hts_itr_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hts_itr_t>())).tid as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(hts_itr_t),
            "::",
            stringify!(tid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hts_itr_t>())).n_off as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(hts_itr_t),
            "::",
            stringify!(n_off)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hts_itr_t>())).i as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(hts_itr_t),
            "::",
            stringify!(i)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hts_itr_t>())).n_reg as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(hts_itr_t),
            "::",
            stringify!(n_reg)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hts_itr_t>())).beg as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(hts_itr_t),
            "::",
            stringify!(beg)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hts_itr_t>())).end as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(hts_itr_t),
            "::",
            stringify!(end)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hts_itr_t>())).reg_list as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(hts_itr_t),
            "::",
            stringify!(reg_list)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hts_itr_t>())).curr_tid as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(hts_itr_t),
            "::",
            stringify!(curr_tid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hts_itr_t>())).curr_reg as *const _ as usize },
        52usize,
        concat!(
            "Offset of field: ",
            stringify!(hts_itr_t),
            "::",
            stringify!(curr_reg)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hts_itr_t>())).curr_intv as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(hts_itr_t),
            "::",
            stringify!(curr_intv)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hts_itr_t>())).curr_beg as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(hts_itr_t),
            "::",
            stringify!(curr_beg)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hts_itr_t>())).curr_end as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(hts_itr_t),
            "::",
            stringify!(curr_end)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hts_itr_t>())).curr_off as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(hts_itr_t),
            "::",
            stringify!(curr_off)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hts_itr_t>())).nocoor_off as *const _ as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(hts_itr_t),
            "::",
            stringify!(nocoor_off)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hts_itr_t>())).off as *const _ as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(hts_itr_t),
            "::",
            stringify!(off)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hts_itr_t>())).readrec as *const _ as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(hts_itr_t),
            "::",
            stringify!(readrec)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hts_itr_t>())).seek as *const _ as usize },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(hts_itr_t),
            "::",
            stringify!(seek)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hts_itr_t>())).tell as *const _ as usize },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(hts_itr_t),
            "::",
            stringify!(tell)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hts_itr_t>())).bins as *const _ as usize },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(hts_itr_t),
            "::",
            stringify!(bins)
        )
    );
}
impl hts_itr_t {
    #[inline]
    pub fn read_rest(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_read_rest(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn finished(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_finished(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn is_cram(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_is_cram(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn nocoor(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_nocoor(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn multi(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_multi(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn dummy(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(5usize, 27u8) as u32) }
    }
    #[inline]
    pub fn set_dummy(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(5usize, 27u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        read_rest: u32,
        finished: u32,
        is_cram: u32,
        nocoor: u32,
        multi: u32,
        dummy: u32,
    ) -> __BindgenBitfieldUnit<[u8; 4usize], u32> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize], u32> =
            Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let read_rest: u32 = unsafe { ::std::mem::transmute(read_rest) };
            read_rest as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let finished: u32 = unsafe { ::std::mem::transmute(finished) };
            finished as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let is_cram: u32 = unsafe { ::std::mem::transmute(is_cram) };
            is_cram as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let nocoor: u32 = unsafe { ::std::mem::transmute(nocoor) };
            nocoor as u64
        });
        __bindgen_bitfield_unit.set(4usize, 1u8, {
            let multi: u32 = unsafe { ::std::mem::transmute(multi) };
            multi as u64
        });
        __bindgen_bitfield_unit.set(5usize, 27u8, {
            let dummy: u32 = unsafe { ::std::mem::transmute(dummy) };
            dummy as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct aux_key_t {
    pub key: ::std::os::raw::c_int,
    pub min_off: u64,
    pub max_off: u64,
}
#[test]
fn bindgen_test_layout_aux_key_t() {
    assert_eq!(
        ::std::mem::size_of::<aux_key_t>(),
        24usize,
        concat!("Size of: ", stringify!(aux_key_t))
    );
    assert_eq!(
        ::std::mem::align_of::<aux_key_t>(),
        8usize,
        concat!("Alignment of ", stringify!(aux_key_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<aux_key_t>())).key as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(aux_key_t),
            "::",
            stringify!(key)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<aux_key_t>())).min_off as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(aux_key_t),
            "::",
            stringify!(min_off)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<aux_key_t>())).max_off as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(aux_key_t),
            "::",
            stringify!(max_off)
        )
    );
}
pub type hts_itr_multi_t = hts_itr_t;
extern "C" {
    pub fn hts_idx_init(
        n: ::std::os::raw::c_int,
        fmt: ::std::os::raw::c_int,
        offset0: u64,
        min_shift: ::std::os::raw::c_int,
        n_lvls: ::std::os::raw::c_int,
    ) -> *mut hts_idx_t;
}
extern "C" {
    pub fn hts_idx_destroy(idx: *mut hts_idx_t);
}
extern "C" {
    pub fn hts_idx_push(
        idx: *mut hts_idx_t,
        tid: ::std::os::raw::c_int,
        beg: hts_pos_t,
        end: hts_pos_t,
        offset: u64,
        is_mapped: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn hts_idx_finish(idx: *mut hts_idx_t, final_offset: u64) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn hts_idx_fmt(idx: *mut hts_idx_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn hts_idx_tbi_name(
        idx: *mut hts_idx_t,
        tid: ::std::os::raw::c_int,
        name: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn hts_idx_save(
        idx: *const hts_idx_t,
        fn_: *const ::std::os::raw::c_char,
        fmt: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn hts_idx_save_as(
        idx: *const hts_idx_t,
        fn_: *const ::std::os::raw::c_char,
        fnidx: *const ::std::os::raw::c_char,
        fmt: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn hts_idx_load(
        fn_: *const ::std::os::raw::c_char,
        fmt: ::std::os::raw::c_int,
    ) -> *mut hts_idx_t;
}
extern "C" {
    pub fn hts_idx_load2(
        fn_: *const ::std::os::raw::c_char,
        fnidx: *const ::std::os::raw::c_char,
    ) -> *mut hts_idx_t;
}
extern "C" {
    pub fn hts_idx_load3(
        fn_: *const ::std::os::raw::c_char,
        fnidx: *const ::std::os::raw::c_char,
        fmt: ::std::os::raw::c_int,
        flags: ::std::os::raw::c_int,
    ) -> *mut hts_idx_t;
}
extern "C" {
    pub fn hts_idx_get_meta(idx: *mut hts_idx_t, l_meta: *mut u32) -> *mut u8;
}
extern "C" {
    pub fn hts_idx_set_meta(
        idx: *mut hts_idx_t,
        l_meta: u32,
        meta: *mut u8,
        is_copy: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn hts_idx_get_stat(
        idx: *const hts_idx_t,
        tid: ::std::os::raw::c_int,
        mapped: *mut u64,
        unmapped: *mut u64,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn hts_idx_get_n_no_coor(idx: *const hts_idx_t) -> u64;
}
extern "C" {
    pub fn hts_parse_decimal(
        str: *const ::std::os::raw::c_char,
        strend: *mut *mut ::std::os::raw::c_char,
        flags: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_longlong;
}
pub type hts_name2id_f = ::std::option::Option<
    unsafe extern "C" fn(
        arg1: *mut ::std::os::raw::c_void,
        arg2: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int,
>;
pub type hts_id2name_f = ::std::option::Option<
    unsafe extern "C" fn(
        arg1: *mut ::std::os::raw::c_void,
        arg2: ::std::os::raw::c_int,
    ) -> *const ::std::os::raw::c_char,
>;
extern "C" {
    pub fn hts_parse_reg64(
        str: *const ::std::os::raw::c_char,
        beg: *mut hts_pos_t,
        end: *mut hts_pos_t,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn hts_parse_reg(
        str: *const ::std::os::raw::c_char,
        beg: *mut ::std::os::raw::c_int,
        end: *mut ::std::os::raw::c_int,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn hts_parse_region(
        s: *const ::std::os::raw::c_char,
        tid: *mut ::std::os::raw::c_int,
        beg: *mut hts_pos_t,
        end: *mut hts_pos_t,
        getid: hts_name2id_f,
        hdr: *mut ::std::os::raw::c_void,
        flags: ::std::os::raw::c_int,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn hts_itr_query(
        idx: *const hts_idx_t,
        tid: ::std::os::raw::c_int,
        beg: hts_pos_t,
        end: hts_pos_t,
        readrec: hts_readrec_func,
    ) -> *mut hts_itr_t;
}
extern "C" {
    pub fn hts_itr_destroy(iter: *mut hts_itr_t);
}
pub type hts_itr_query_func = ::std::option::Option<
    unsafe extern "C" fn(
        idx: *const hts_idx_t,
        tid: ::std::os::raw::c_int,
        beg: hts_pos_t,
        end: hts_pos_t,
        readrec: hts_readrec_func,
    ) -> *mut hts_itr_t,
>;
extern "C" {
    pub fn hts_itr_querys(
        idx: *const hts_idx_t,
        reg: *const ::std::os::raw::c_char,
        getid: hts_name2id_f,
        hdr: *mut ::std::os::raw::c_void,
        itr_query: hts_itr_query_func,
        readrec: hts_readrec_func,
    ) -> *mut hts_itr_t;
}
extern "C" {
    pub fn hts_itr_next(
        fp: *mut BGZF,
        iter: *mut hts_itr_t,
        r: *mut ::std::os::raw::c_void,
        data: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn hts_idx_seqnames(
        idx: *const hts_idx_t,
        n: *mut ::std::os::raw::c_int,
        getid: hts_id2name_f,
        hdr: *mut ::std::os::raw::c_void,
    ) -> *mut *const ::std::os::raw::c_char;
}
pub type hts_itr_multi_query_func = ::std::option::Option<
    unsafe extern "C" fn(idx: *const hts_idx_t, itr: *mut hts_itr_t) -> ::std::os::raw::c_int,
>;
extern "C" {
    pub fn hts_itr_multi_bam(idx: *const hts_idx_t, iter: *mut hts_itr_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn hts_itr_multi_cram(idx: *const hts_idx_t, iter: *mut hts_itr_t)
        -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn hts_itr_regions(
        idx: *const hts_idx_t,
        reglist: *mut hts_reglist_t,
        count: ::std::os::raw::c_int,
        getid: hts_name2id_f,
        hdr: *mut ::std::os::raw::c_void,
        itr_specific: hts_itr_multi_query_func,
        readrec: hts_readrec_func,
        seek: hts_seek_func,
        tell: hts_tell_func,
    ) -> *mut hts_itr_t;
}
extern "C" {
    pub fn hts_itr_multi_next(
        fd: *mut htsFile,
        iter: *mut hts_itr_t,
        r: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn hts_reglist_create(
        argv: *mut *mut ::std::os::raw::c_char,
        argc: ::std::os::raw::c_int,
        r_count: *mut ::std::os::raw::c_int,
        hdr: *mut ::std::os::raw::c_void,
        getid: hts_name2id_f,
    ) -> *mut hts_reglist_t;
}
extern "C" {
    pub fn hts_reglist_free(reglist: *mut hts_reglist_t, count: ::std::os::raw::c_int);
}
extern "C" {
    pub fn hts_file_type(fname: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct errmod_t {
    _unused: [u8; 0],
}
extern "C" {
    pub fn errmod_init(depcorr: f64) -> *mut errmod_t;
}
extern "C" {
    pub fn errmod_destroy(em: *mut errmod_t);
}
extern "C" {
    pub fn errmod_cal(
        em: *const errmod_t,
        n: ::std::os::raw::c_int,
        m: ::std::os::raw::c_int,
        bases: *mut u16,
        q: *mut f32,
    ) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct probaln_par_t {
    pub d: f32,
    pub e: f32,
    pub bw: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_probaln_par_t() {
    assert_eq!(
        ::std::mem::size_of::<probaln_par_t>(),
        12usize,
        concat!("Size of: ", stringify!(probaln_par_t))
    );
    assert_eq!(
        ::std::mem::align_of::<probaln_par_t>(),
        4usize,
        concat!("Alignment of ", stringify!(probaln_par_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<probaln_par_t>())).d as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(probaln_par_t),
            "::",
            stringify!(d)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<probaln_par_t>())).e as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(probaln_par_t),
            "::",
            stringify!(e)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<probaln_par_t>())).bw as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(probaln_par_t),
            "::",
            stringify!(bw)
        )
    );
}
extern "C" {
    pub fn probaln_glocal(
        ref_: *const u8,
        l_ref: ::std::os::raw::c_int,
        query: *const u8,
        l_query: ::std::os::raw::c_int,
        iqual: *const u8,
        c: *const probaln_par_t,
        state: *mut ::std::os::raw::c_int,
        q: *mut u8,
    ) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hts_md5_context {
    _unused: [u8; 0],
}
extern "C" {
    pub fn hts_md5_init() -> *mut hts_md5_context;
}
extern "C" {
    pub fn hts_md5_update(
        ctx: *mut hts_md5_context,
        data: *const ::std::os::raw::c_void,
        size: ::std::os::raw::c_ulong,
    );
}
extern "C" {
    pub fn hts_md5_final(digest: *mut ::std::os::raw::c_uchar, ctx: *mut hts_md5_context);
}
extern "C" {
    pub fn hts_md5_reset(ctx: *mut hts_md5_context);
}
extern "C" {
    pub fn hts_md5_hex(hex: *mut ::std::os::raw::c_char, digest: *const ::std::os::raw::c_uchar);
}
extern "C" {
    pub fn hts_md5_destroy(ctx: *mut hts_md5_context);
}
extern "C" {
    pub fn __assert_fail(
        __assertion: *const ::std::os::raw::c_char,
        __file: *const ::std::os::raw::c_char,
        __line: ::std::os::raw::c_uint,
        __function: *const ::std::os::raw::c_char,
    );
}
extern "C" {
    pub fn __assert_perror_fail(
        __errnum: ::std::os::raw::c_int,
        __file: *const ::std::os::raw::c_char,
        __line: ::std::os::raw::c_uint,
        __function: *const ::std::os::raw::c_char,
    );
}
extern "C" {
    pub fn __assert(
        __assertion: *const ::std::os::raw::c_char,
        __file: *const ::std::os::raw::c_char,
        __line: ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn __errno_location() -> *mut ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union wait {
    pub w_status: ::std::os::raw::c_int,
    pub __wait_terminated: wait__bindgen_ty_1,
    pub __wait_stopped: wait__bindgen_ty_2,
    _bindgen_union_align: u32,
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Copy, Clone)]
pub struct wait__bindgen_ty_1 {
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize], u8>,
}
#[test]
fn bindgen_test_layout_wait__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<wait__bindgen_ty_1>(),
        4usize,
        concat!("Size of: ", stringify!(wait__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<wait__bindgen_ty_1>(),
        4usize,
        concat!("Alignment of ", stringify!(wait__bindgen_ty_1))
    );
}
impl wait__bindgen_ty_1 {
    #[inline]
    pub fn __w_termsig(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 7u8) as u32) }
    }
    #[inline]
    pub fn set___w_termsig(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 7u8, val as u64)
        }
    }
    #[inline]
    pub fn __w_coredump(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(7usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set___w_coredump(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(7usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __w_retcode(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(8usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set___w_retcode(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(8usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        __w_termsig: ::std::os::raw::c_uint,
        __w_coredump: ::std::os::raw::c_uint,
        __w_retcode: ::std::os::raw::c_uint,
    ) -> __BindgenBitfieldUnit<[u8; 4usize], u8> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize], u8> =
            Default::default();
        __bindgen_bitfield_unit.set(0usize, 7u8, {
            let __w_termsig: u32 = unsafe { ::std::mem::transmute(__w_termsig) };
            __w_termsig as u64
        });
        __bindgen_bitfield_unit.set(7usize, 1u8, {
            let __w_coredump: u32 = unsafe { ::std::mem::transmute(__w_coredump) };
            __w_coredump as u64
        });
        __bindgen_bitfield_unit.set(8usize, 8u8, {
            let __w_retcode: u32 = unsafe { ::std::mem::transmute(__w_retcode) };
            __w_retcode as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Copy, Clone)]
pub struct wait__bindgen_ty_2 {
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize], u8>,
}
#[test]
fn bindgen_test_layout_wait__bindgen_ty_2() {
    assert_eq!(
        ::std::mem::size_of::<wait__bindgen_ty_2>(),
        4usize,
        concat!("Size of: ", stringify!(wait__bindgen_ty_2))
    );
    assert_eq!(
        ::std::mem::align_of::<wait__bindgen_ty_2>(),
        4usize,
        concat!("Alignment of ", stringify!(wait__bindgen_ty_2))
    );
}
impl wait__bindgen_ty_2 {
    #[inline]
    pub fn __w_stopval(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set___w_stopval(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn __w_stopsig(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(8usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set___w_stopsig(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(8usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        __w_stopval: ::std::os::raw::c_uint,
        __w_stopsig: ::std::os::raw::c_uint,
    ) -> __BindgenBitfieldUnit<[u8; 4usize], u8> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize], u8> =
            Default::default();
        __bindgen_bitfield_unit.set(0usize, 8u8, {
            let __w_stopval: u32 = unsafe { ::std::mem::transmute(__w_stopval) };
            __w_stopval as u64
        });
        __bindgen_bitfield_unit.set(8usize, 8u8, {
            let __w_stopsig: u32 = unsafe { ::std::mem::transmute(__w_stopsig) };
            __w_stopsig as u64
        });
        __bindgen_bitfield_unit
    }
}
#[test]
fn bindgen_test_layout_wait() {
    assert_eq!(
        ::std::mem::size_of::<wait>(),
        4usize,
        concat!("Size of: ", stringify!(wait))
    );
    assert_eq!(
        ::std::mem::align_of::<wait>(),
        4usize,
        concat!("Alignment of ", stringify!(wait))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<wait>())).w_status as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(wait),
            "::",
            stringify!(w_status)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<wait>())).__wait_terminated as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(wait),
            "::",
            stringify!(__wait_terminated)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<wait>())).__wait_stopped as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(wait),
            "::",
            stringify!(__wait_stopped)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union __WAIT_STATUS {
    pub __uptr: *mut wait,
    pub __iptr: *mut ::std::os::raw::c_int,
    _bindgen_union_align: u64,
}
#[test]
fn bindgen_test_layout___WAIT_STATUS() {
    assert_eq!(
        ::std::mem::size_of::<__WAIT_STATUS>(),
        8usize,
        concat!("Size of: ", stringify!(__WAIT_STATUS))
    );
    assert_eq!(
        ::std::mem::align_of::<__WAIT_STATUS>(),
        8usize,
        concat!("Alignment of ", stringify!(__WAIT_STATUS))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__WAIT_STATUS>())).__uptr as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__WAIT_STATUS),
            "::",
            stringify!(__uptr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__WAIT_STATUS>())).__iptr as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__WAIT_STATUS),
            "::",
            stringify!(__iptr)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct div_t {
    pub quot: ::std::os::raw::c_int,
    pub rem: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_div_t() {
    assert_eq!(
        ::std::mem::size_of::<div_t>(),
        8usize,
        concat!("Size of: ", stringify!(div_t))
    );
    assert_eq!(
        ::std::mem::align_of::<div_t>(),
        4usize,
        concat!("Alignment of ", stringify!(div_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<div_t>())).quot as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(div_t),
            "::",
            stringify!(quot)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<div_t>())).rem as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(div_t),
            "::",
            stringify!(rem)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ldiv_t {
    pub quot: ::std::os::raw::c_long,
    pub rem: ::std::os::raw::c_long,
}
#[test]
fn bindgen_test_layout_ldiv_t() {
    assert_eq!(
        ::std::mem::size_of::<ldiv_t>(),
        16usize,
        concat!("Size of: ", stringify!(ldiv_t))
    );
    assert_eq!(
        ::std::mem::align_of::<ldiv_t>(),
        8usize,
        concat!("Alignment of ", stringify!(ldiv_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ldiv_t>())).quot as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(ldiv_t),
            "::",
            stringify!(quot)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ldiv_t>())).rem as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(ldiv_t),
            "::",
            stringify!(rem)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct lldiv_t {
    pub quot: ::std::os::raw::c_longlong,
    pub rem: ::std::os::raw::c_longlong,
}
#[test]
fn bindgen_test_layout_lldiv_t() {
    assert_eq!(
        ::std::mem::size_of::<lldiv_t>(),
        16usize,
        concat!("Size of: ", stringify!(lldiv_t))
    );
    assert_eq!(
        ::std::mem::align_of::<lldiv_t>(),
        8usize,
        concat!("Alignment of ", stringify!(lldiv_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<lldiv_t>())).quot as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lldiv_t),
            "::",
            stringify!(quot)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<lldiv_t>())).rem as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(lldiv_t),
            "::",
            stringify!(rem)
        )
    );
}
extern "C" {
    pub fn __ctype_get_mb_cur_max() -> size_t;
}
extern "C" {
    pub fn atof(__nptr: *const ::std::os::raw::c_char) -> f64;
}
extern "C" {
    pub fn atoi(__nptr: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn atol(__nptr: *const ::std::os::raw::c_char) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn atoll(__nptr: *const ::std::os::raw::c_char) -> ::std::os::raw::c_longlong;
}
extern "C" {
    pub fn strtod(
        __nptr: *const ::std::os::raw::c_char,
        __endptr: *mut *mut ::std::os::raw::c_char,
    ) -> f64;
}
extern "C" {
    pub fn strtof(
        __nptr: *const ::std::os::raw::c_char,
        __endptr: *mut *mut ::std::os::raw::c_char,
    ) -> f32;
}
extern "C" {
    pub fn strtol(
        __nptr: *const ::std::os::raw::c_char,
        __endptr: *mut *mut ::std::os::raw::c_char,
        __base: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn strtoul(
        __nptr: *const ::std::os::raw::c_char,
        __endptr: *mut *mut ::std::os::raw::c_char,
        __base: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_ulong;
}
extern "C" {
    pub fn strtoq(
        __nptr: *const ::std::os::raw::c_char,
        __endptr: *mut *mut ::std::os::raw::c_char,
        __base: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_longlong;
}
extern "C" {
    pub fn strtouq(
        __nptr: *const ::std::os::raw::c_char,
        __endptr: *mut *mut ::std::os::raw::c_char,
        __base: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_ulonglong;
}
extern "C" {
    pub fn strtoll(
        __nptr: *const ::std::os::raw::c_char,
        __endptr: *mut *mut ::std::os::raw::c_char,
        __base: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_longlong;
}
extern "C" {
    pub fn strtoull(
        __nptr: *const ::std::os::raw::c_char,
        __endptr: *mut *mut ::std::os::raw::c_char,
        __base: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_ulonglong;
}
extern "C" {
    pub fn l64a(__n: ::std::os::raw::c_long) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn a64l(__s: *const ::std::os::raw::c_char) -> ::std::os::raw::c_long;
}
pub type u_char = __u_char;
pub type u_short = __u_short;
pub type u_int = __u_int;
pub type u_long = __u_long;
pub type quad_t = __quad_t;
pub type u_quad_t = __u_quad_t;
pub type fsid_t = __fsid_t;
pub type loff_t = __loff_t;
pub type ino_t = __ino_t;
pub type dev_t = __dev_t;
pub type gid_t = __gid_t;
pub type mode_t = __mode_t;
pub type nlink_t = __nlink_t;
pub type uid_t = __uid_t;
pub type pid_t = __pid_t;
pub type id_t = __id_t;
pub type daddr_t = __daddr_t;
pub type caddr_t = __caddr_t;
pub type key_t = __key_t;
pub type clock_t = __clock_t;
pub type time_t = __time_t;
pub type clockid_t = __clockid_t;
pub type timer_t = __timer_t;
pub type ulong = ::std::os::raw::c_ulong;
pub type ushort = ::std::os::raw::c_ushort;
pub type uint = ::std::os::raw::c_uint;
pub type u_int8_t = ::std::os::raw::c_uchar;
pub type u_int16_t = ::std::os::raw::c_ushort;
pub type u_int32_t = ::std::os::raw::c_uint;
pub type u_int64_t = ::std::os::raw::c_ulong;
pub type register_t = ::std::os::raw::c_long;
pub type __sig_atomic_t = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __sigset_t {
    pub __val: [::std::os::raw::c_ulong; 16usize],
}
#[test]
fn bindgen_test_layout___sigset_t() {
    assert_eq!(
        ::std::mem::size_of::<__sigset_t>(),
        128usize,
        concat!("Size of: ", stringify!(__sigset_t))
    );
    assert_eq!(
        ::std::mem::align_of::<__sigset_t>(),
        8usize,
        concat!("Alignment of ", stringify!(__sigset_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sigset_t>())).__val as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__sigset_t),
            "::",
            stringify!(__val)
        )
    );
}
pub type sigset_t = __sigset_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct timespec {
    pub tv_sec: __time_t,
    pub tv_nsec: ::std::os::raw::c_long,
}
#[test]
fn bindgen_test_layout_timespec() {
    assert_eq!(
        ::std::mem::size_of::<timespec>(),
        16usize,
        concat!("Size of: ", stringify!(timespec))
    );
    assert_eq!(
        ::std::mem::align_of::<timespec>(),
        8usize,
        concat!("Alignment of ", stringify!(timespec))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<timespec>())).tv_sec as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(timespec),
            "::",
            stringify!(tv_sec)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<timespec>())).tv_nsec as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(timespec),
            "::",
            stringify!(tv_nsec)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct timeval {
    pub tv_sec: __time_t,
    pub tv_usec: __suseconds_t,
}
#[test]
fn bindgen_test_layout_timeval() {
    assert_eq!(
        ::std::mem::size_of::<timeval>(),
        16usize,
        concat!("Size of: ", stringify!(timeval))
    );
    assert_eq!(
        ::std::mem::align_of::<timeval>(),
        8usize,
        concat!("Alignment of ", stringify!(timeval))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<timeval>())).tv_sec as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(timeval),
            "::",
            stringify!(tv_sec)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<timeval>())).tv_usec as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(timeval),
            "::",
            stringify!(tv_usec)
        )
    );
}
pub type suseconds_t = __suseconds_t;
pub type __fd_mask = ::std::os::raw::c_long;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct fd_set {
    pub __fds_bits: [__fd_mask; 16usize],
}
#[test]
fn bindgen_test_layout_fd_set() {
    assert_eq!(
        ::std::mem::size_of::<fd_set>(),
        128usize,
        concat!("Size of: ", stringify!(fd_set))
    );
    assert_eq!(
        ::std::mem::align_of::<fd_set>(),
        8usize,
        concat!("Alignment of ", stringify!(fd_set))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<fd_set>())).__fds_bits as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(fd_set),
            "::",
            stringify!(__fds_bits)
        )
    );
}
pub type fd_mask = __fd_mask;
extern "C" {
    pub fn select(
        __nfds: ::std::os::raw::c_int,
        __readfds: *mut fd_set,
        __writefds: *mut fd_set,
        __exceptfds: *mut fd_set,
        __timeout: *mut timeval,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pselect(
        __nfds: ::std::os::raw::c_int,
        __readfds: *mut fd_set,
        __writefds: *mut fd_set,
        __exceptfds: *mut fd_set,
        __timeout: *const timespec,
        __sigmask: *const __sigset_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn gnu_dev_major(__dev: ::std::os::raw::c_ulonglong) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn gnu_dev_minor(__dev: ::std::os::raw::c_ulonglong) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn gnu_dev_makedev(
        __major: ::std::os::raw::c_uint,
        __minor: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_ulonglong;
}
pub type blksize_t = __blksize_t;
pub type blkcnt_t = __blkcnt_t;
pub type fsblkcnt_t = __fsblkcnt_t;
pub type fsfilcnt_t = __fsfilcnt_t;
pub type pthread_t = ::std::os::raw::c_ulong;
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_attr_t {
    pub __size: [::std::os::raw::c_char; 56usize],
    pub __align: ::std::os::raw::c_long,
    _bindgen_union_align: [u64; 7usize],
}
#[test]
fn bindgen_test_layout_pthread_attr_t() {
    assert_eq!(
        ::std::mem::size_of::<pthread_attr_t>(),
        56usize,
        concat!("Size of: ", stringify!(pthread_attr_t))
    );
    assert_eq!(
        ::std::mem::align_of::<pthread_attr_t>(),
        8usize,
        concat!("Alignment of ", stringify!(pthread_attr_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_attr_t>())).__size as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_attr_t),
            "::",
            stringify!(__size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_attr_t>())).__align as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_attr_t),
            "::",
            stringify!(__align)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __pthread_internal_list {
    pub __prev: *mut __pthread_internal_list,
    pub __next: *mut __pthread_internal_list,
}
#[test]
fn bindgen_test_layout___pthread_internal_list() {
    assert_eq!(
        ::std::mem::size_of::<__pthread_internal_list>(),
        16usize,
        concat!("Size of: ", stringify!(__pthread_internal_list))
    );
    assert_eq!(
        ::std::mem::align_of::<__pthread_internal_list>(),
        8usize,
        concat!("Alignment of ", stringify!(__pthread_internal_list))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__pthread_internal_list>())).__prev as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_internal_list),
            "::",
            stringify!(__prev)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__pthread_internal_list>())).__next as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_internal_list),
            "::",
            stringify!(__next)
        )
    );
}
pub type __pthread_list_t = __pthread_internal_list;
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_mutex_t {
    pub __data: pthread_mutex_t___pthread_mutex_s,
    pub __size: [::std::os::raw::c_char; 40usize],
    pub __align: ::std::os::raw::c_long,
    _bindgen_union_align: [u64; 5usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct pthread_mutex_t___pthread_mutex_s {
    pub __lock: ::std::os::raw::c_int,
    pub __count: ::std::os::raw::c_uint,
    pub __owner: ::std::os::raw::c_int,
    pub __nusers: ::std::os::raw::c_uint,
    pub __kind: ::std::os::raw::c_int,
    pub __spins: ::std::os::raw::c_int,
    pub __list: __pthread_list_t,
}
#[test]
fn bindgen_test_layout_pthread_mutex_t___pthread_mutex_s() {
    assert_eq!(
        ::std::mem::size_of::<pthread_mutex_t___pthread_mutex_s>(),
        40usize,
        concat!("Size of: ", stringify!(pthread_mutex_t___pthread_mutex_s))
    );
    assert_eq!(
        ::std::mem::align_of::<pthread_mutex_t___pthread_mutex_s>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(pthread_mutex_t___pthread_mutex_s)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pthread_mutex_t___pthread_mutex_s>())).__lock as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_mutex_t___pthread_mutex_s),
            "::",
            stringify!(__lock)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pthread_mutex_t___pthread_mutex_s>())).__count as *const _
                as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_mutex_t___pthread_mutex_s),
            "::",
            stringify!(__count)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pthread_mutex_t___pthread_mutex_s>())).__owner as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_mutex_t___pthread_mutex_s),
            "::",
            stringify!(__owner)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pthread_mutex_t___pthread_mutex_s>())).__nusers as *const _
                as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_mutex_t___pthread_mutex_s),
            "::",
            stringify!(__nusers)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pthread_mutex_t___pthread_mutex_s>())).__kind as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_mutex_t___pthread_mutex_s),
            "::",
            stringify!(__kind)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pthread_mutex_t___pthread_mutex_s>())).__spins as *const _
                as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_mutex_t___pthread_mutex_s),
            "::",
            stringify!(__spins)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pthread_mutex_t___pthread_mutex_s>())).__list as *const _
                as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_mutex_t___pthread_mutex_s),
            "::",
            stringify!(__list)
        )
    );
}
#[test]
fn bindgen_test_layout_pthread_mutex_t() {
    assert_eq!(
        ::std::mem::size_of::<pthread_mutex_t>(),
        40usize,
        concat!("Size of: ", stringify!(pthread_mutex_t))
    );
    assert_eq!(
        ::std::mem::align_of::<pthread_mutex_t>(),
        8usize,
        concat!("Alignment of ", stringify!(pthread_mutex_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_mutex_t>())).__data as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_mutex_t),
            "::",
            stringify!(__data)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_mutex_t>())).__size as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_mutex_t),
            "::",
            stringify!(__size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_mutex_t>())).__align as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_mutex_t),
            "::",
            stringify!(__align)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_mutexattr_t {
    pub __size: [::std::os::raw::c_char; 4usize],
    pub __align: ::std::os::raw::c_int,
    _bindgen_union_align: u32,
}
#[test]
fn bindgen_test_layout_pthread_mutexattr_t() {
    assert_eq!(
        ::std::mem::size_of::<pthread_mutexattr_t>(),
        4usize,
        concat!("Size of: ", stringify!(pthread_mutexattr_t))
    );
    assert_eq!(
        ::std::mem::align_of::<pthread_mutexattr_t>(),
        4usize,
        concat!("Alignment of ", stringify!(pthread_mutexattr_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_mutexattr_t>())).__size as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_mutexattr_t),
            "::",
            stringify!(__size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_mutexattr_t>())).__align as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_mutexattr_t),
            "::",
            stringify!(__align)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_cond_t {
    pub __data: pthread_cond_t__bindgen_ty_1,
    pub __size: [::std::os::raw::c_char; 48usize],
    pub __align: ::std::os::raw::c_longlong,
    _bindgen_union_align: [u64; 6usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct pthread_cond_t__bindgen_ty_1 {
    pub __lock: ::std::os::raw::c_int,
    pub __futex: ::std::os::raw::c_uint,
    pub __total_seq: ::std::os::raw::c_ulonglong,
    pub __wakeup_seq: ::std::os::raw::c_ulonglong,
    pub __woken_seq: ::std::os::raw::c_ulonglong,
    pub __mutex: *mut ::std::os::raw::c_void,
    pub __nwaiters: ::std::os::raw::c_uint,
    pub __broadcast_seq: ::std::os::raw::c_uint,
}
#[test]
fn bindgen_test_layout_pthread_cond_t__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<pthread_cond_t__bindgen_ty_1>(),
        48usize,
        concat!("Size of: ", stringify!(pthread_cond_t__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<pthread_cond_t__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(pthread_cond_t__bindgen_ty_1))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pthread_cond_t__bindgen_ty_1>())).__lock as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_cond_t__bindgen_ty_1),
            "::",
            stringify!(__lock)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pthread_cond_t__bindgen_ty_1>())).__futex as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_cond_t__bindgen_ty_1),
            "::",
            stringify!(__futex)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pthread_cond_t__bindgen_ty_1>())).__total_seq as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_cond_t__bindgen_ty_1),
            "::",
            stringify!(__total_seq)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pthread_cond_t__bindgen_ty_1>())).__wakeup_seq as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_cond_t__bindgen_ty_1),
            "::",
            stringify!(__wakeup_seq)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pthread_cond_t__bindgen_ty_1>())).__woken_seq as *const _
                as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_cond_t__bindgen_ty_1),
            "::",
            stringify!(__woken_seq)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pthread_cond_t__bindgen_ty_1>())).__mutex as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_cond_t__bindgen_ty_1),
            "::",
            stringify!(__mutex)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pthread_cond_t__bindgen_ty_1>())).__nwaiters as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_cond_t__bindgen_ty_1),
            "::",
            stringify!(__nwaiters)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pthread_cond_t__bindgen_ty_1>())).__broadcast_seq as *const _
                as usize
        },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_cond_t__bindgen_ty_1),
            "::",
            stringify!(__broadcast_seq)
        )
    );
}
#[test]
fn bindgen_test_layout_pthread_cond_t() {
    assert_eq!(
        ::std::mem::size_of::<pthread_cond_t>(),
        48usize,
        concat!("Size of: ", stringify!(pthread_cond_t))
    );
    assert_eq!(
        ::std::mem::align_of::<pthread_cond_t>(),
        8usize,
        concat!("Alignment of ", stringify!(pthread_cond_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_cond_t>())).__data as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_cond_t),
            "::",
            stringify!(__data)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_cond_t>())).__size as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_cond_t),
            "::",
            stringify!(__size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_cond_t>())).__align as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_cond_t),
            "::",
            stringify!(__align)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_condattr_t {
    pub __size: [::std::os::raw::c_char; 4usize],
    pub __align: ::std::os::raw::c_int,
    _bindgen_union_align: u32,
}
#[test]
fn bindgen_test_layout_pthread_condattr_t() {
    assert_eq!(
        ::std::mem::size_of::<pthread_condattr_t>(),
        4usize,
        concat!("Size of: ", stringify!(pthread_condattr_t))
    );
    assert_eq!(
        ::std::mem::align_of::<pthread_condattr_t>(),
        4usize,
        concat!("Alignment of ", stringify!(pthread_condattr_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_condattr_t>())).__size as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_condattr_t),
            "::",
            stringify!(__size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_condattr_t>())).__align as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_condattr_t),
            "::",
            stringify!(__align)
        )
    );
}
pub type pthread_key_t = ::std::os::raw::c_uint;
pub type pthread_once_t = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_rwlock_t {
    pub __data: pthread_rwlock_t__bindgen_ty_1,
    pub __size: [::std::os::raw::c_char; 56usize],
    pub __align: ::std::os::raw::c_long,
    _bindgen_union_align: [u64; 7usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct pthread_rwlock_t__bindgen_ty_1 {
    pub __lock: ::std::os::raw::c_int,
    pub __nr_readers: ::std::os::raw::c_uint,
    pub __readers_wakeup: ::std::os::raw::c_uint,
    pub __writer_wakeup: ::std::os::raw::c_uint,
    pub __nr_readers_queued: ::std::os::raw::c_uint,
    pub __nr_writers_queued: ::std::os::raw::c_uint,
    pub __writer: ::std::os::raw::c_int,
    pub __shared: ::std::os::raw::c_int,
    pub __pad1: ::std::os::raw::c_ulong,
    pub __pad2: ::std::os::raw::c_ulong,
    pub __flags: ::std::os::raw::c_uint,
}
#[test]
fn bindgen_test_layout_pthread_rwlock_t__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<pthread_rwlock_t__bindgen_ty_1>(),
        56usize,
        concat!("Size of: ", stringify!(pthread_rwlock_t__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<pthread_rwlock_t__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(pthread_rwlock_t__bindgen_ty_1))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pthread_rwlock_t__bindgen_ty_1>())).__lock as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_rwlock_t__bindgen_ty_1),
            "::",
            stringify!(__lock)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pthread_rwlock_t__bindgen_ty_1>())).__nr_readers as *const _
                as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_rwlock_t__bindgen_ty_1),
            "::",
            stringify!(__nr_readers)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pthread_rwlock_t__bindgen_ty_1>())).__readers_wakeup as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_rwlock_t__bindgen_ty_1),
            "::",
            stringify!(__readers_wakeup)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pthread_rwlock_t__bindgen_ty_1>())).__writer_wakeup as *const _
                as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_rwlock_t__bindgen_ty_1),
            "::",
            stringify!(__writer_wakeup)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pthread_rwlock_t__bindgen_ty_1>())).__nr_readers_queued
                as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_rwlock_t__bindgen_ty_1),
            "::",
            stringify!(__nr_readers_queued)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pthread_rwlock_t__bindgen_ty_1>())).__nr_writers_queued
                as *const _ as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_rwlock_t__bindgen_ty_1),
            "::",
            stringify!(__nr_writers_queued)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pthread_rwlock_t__bindgen_ty_1>())).__writer as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_rwlock_t__bindgen_ty_1),
            "::",
            stringify!(__writer)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pthread_rwlock_t__bindgen_ty_1>())).__shared as *const _ as usize
        },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_rwlock_t__bindgen_ty_1),
            "::",
            stringify!(__shared)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pthread_rwlock_t__bindgen_ty_1>())).__pad1 as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_rwlock_t__bindgen_ty_1),
            "::",
            stringify!(__pad1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pthread_rwlock_t__bindgen_ty_1>())).__pad2 as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_rwlock_t__bindgen_ty_1),
            "::",
            stringify!(__pad2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pthread_rwlock_t__bindgen_ty_1>())).__flags as *const _ as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_rwlock_t__bindgen_ty_1),
            "::",
            stringify!(__flags)
        )
    );
}
#[test]
fn bindgen_test_layout_pthread_rwlock_t() {
    assert_eq!(
        ::std::mem::size_of::<pthread_rwlock_t>(),
        56usize,
        concat!("Size of: ", stringify!(pthread_rwlock_t))
    );
    assert_eq!(
        ::std::mem::align_of::<pthread_rwlock_t>(),
        8usize,
        concat!("Alignment of ", stringify!(pthread_rwlock_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_rwlock_t>())).__data as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_rwlock_t),
            "::",
            stringify!(__data)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_rwlock_t>())).__size as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_rwlock_t),
            "::",
            stringify!(__size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_rwlock_t>())).__align as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_rwlock_t),
            "::",
            stringify!(__align)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_rwlockattr_t {
    pub __size: [::std::os::raw::c_char; 8usize],
    pub __align: ::std::os::raw::c_long,
    _bindgen_union_align: u64,
}
#[test]
fn bindgen_test_layout_pthread_rwlockattr_t() {
    assert_eq!(
        ::std::mem::size_of::<pthread_rwlockattr_t>(),
        8usize,
        concat!("Size of: ", stringify!(pthread_rwlockattr_t))
    );
    assert_eq!(
        ::std::mem::align_of::<pthread_rwlockattr_t>(),
        8usize,
        concat!("Alignment of ", stringify!(pthread_rwlockattr_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_rwlockattr_t>())).__size as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_rwlockattr_t),
            "::",
            stringify!(__size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_rwlockattr_t>())).__align as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_rwlockattr_t),
            "::",
            stringify!(__align)
        )
    );
}
pub type pthread_spinlock_t = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_barrier_t {
    pub __size: [::std::os::raw::c_char; 32usize],
    pub __align: ::std::os::raw::c_long,
    _bindgen_union_align: [u64; 4usize],
}
#[test]
fn bindgen_test_layout_pthread_barrier_t() {
    assert_eq!(
        ::std::mem::size_of::<pthread_barrier_t>(),
        32usize,
        concat!("Size of: ", stringify!(pthread_barrier_t))
    );
    assert_eq!(
        ::std::mem::align_of::<pthread_barrier_t>(),
        8usize,
        concat!("Alignment of ", stringify!(pthread_barrier_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_barrier_t>())).__size as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_barrier_t),
            "::",
            stringify!(__size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_barrier_t>())).__align as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_barrier_t),
            "::",
            stringify!(__align)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_barrierattr_t {
    pub __size: [::std::os::raw::c_char; 4usize],
    pub __align: ::std::os::raw::c_int,
    _bindgen_union_align: u32,
}
#[test]
fn bindgen_test_layout_pthread_barrierattr_t() {
    assert_eq!(
        ::std::mem::size_of::<pthread_barrierattr_t>(),
        4usize,
        concat!("Size of: ", stringify!(pthread_barrierattr_t))
    );
    assert_eq!(
        ::std::mem::align_of::<pthread_barrierattr_t>(),
        4usize,
        concat!("Alignment of ", stringify!(pthread_barrierattr_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_barrierattr_t>())).__size as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_barrierattr_t),
            "::",
            stringify!(__size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_barrierattr_t>())).__align as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_barrierattr_t),
            "::",
            stringify!(__align)
        )
    );
}
extern "C" {
    pub fn random() -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn srandom(__seed: ::std::os::raw::c_uint);
}
extern "C" {
    pub fn initstate(
        __seed: ::std::os::raw::c_uint,
        __statebuf: *mut ::std::os::raw::c_char,
        __statelen: size_t,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn setstate(__statebuf: *mut ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct random_data {
    pub fptr: *mut i32,
    pub rptr: *mut i32,
    pub state: *mut i32,
    pub rand_type: ::std::os::raw::c_int,
    pub rand_deg: ::std::os::raw::c_int,
    pub rand_sep: ::std::os::raw::c_int,
    pub end_ptr: *mut i32,
}
#[test]
fn bindgen_test_layout_random_data() {
    assert_eq!(
        ::std::mem::size_of::<random_data>(),
        48usize,
        concat!("Size of: ", stringify!(random_data))
    );
    assert_eq!(
        ::std::mem::align_of::<random_data>(),
        8usize,
        concat!("Alignment of ", stringify!(random_data))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<random_data>())).fptr as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(random_data),
            "::",
            stringify!(fptr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<random_data>())).rptr as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(random_data),
            "::",
            stringify!(rptr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<random_data>())).state as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(random_data),
            "::",
            stringify!(state)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<random_data>())).rand_type as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(random_data),
            "::",
            stringify!(rand_type)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<random_data>())).rand_deg as *const _ as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(random_data),
            "::",
            stringify!(rand_deg)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<random_data>())).rand_sep as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(random_data),
            "::",
            stringify!(rand_sep)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<random_data>())).end_ptr as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(random_data),
            "::",
            stringify!(end_ptr)
        )
    );
}
extern "C" {
    pub fn random_r(__buf: *mut random_data, __result: *mut i32) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn srandom_r(
        __seed: ::std::os::raw::c_uint,
        __buf: *mut random_data,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn initstate_r(
        __seed: ::std::os::raw::c_uint,
        __statebuf: *mut ::std::os::raw::c_char,
        __statelen: size_t,
        __buf: *mut random_data,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn setstate_r(
        __statebuf: *mut ::std::os::raw::c_char,
        __buf: *mut random_data,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rand() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn srand(__seed: ::std::os::raw::c_uint);
}
extern "C" {
    pub fn rand_r(__seed: *mut ::std::os::raw::c_uint) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn drand48() -> f64;
}
extern "C" {
    pub fn erand48(__xsubi: *mut ::std::os::raw::c_ushort) -> f64;
}
extern "C" {
    pub fn lrand48() -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn nrand48(__xsubi: *mut ::std::os::raw::c_ushort) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn mrand48() -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn jrand48(__xsubi: *mut ::std::os::raw::c_ushort) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn srand48(__seedval: ::std::os::raw::c_long);
}
extern "C" {
    pub fn seed48(__seed16v: *mut ::std::os::raw::c_ushort) -> *mut ::std::os::raw::c_ushort;
}
extern "C" {
    pub fn lcong48(__param: *mut ::std::os::raw::c_ushort);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drand48_data {
    pub __x: [::std::os::raw::c_ushort; 3usize],
    pub __old_x: [::std::os::raw::c_ushort; 3usize],
    pub __c: ::std::os::raw::c_ushort,
    pub __init: ::std::os::raw::c_ushort,
    pub __a: ::std::os::raw::c_ulonglong,
}
#[test]
fn bindgen_test_layout_drand48_data() {
    assert_eq!(
        ::std::mem::size_of::<drand48_data>(),
        24usize,
        concat!("Size of: ", stringify!(drand48_data))
    );
    assert_eq!(
        ::std::mem::align_of::<drand48_data>(),
        8usize,
        concat!("Alignment of ", stringify!(drand48_data))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<drand48_data>())).__x as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(drand48_data),
            "::",
            stringify!(__x)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<drand48_data>())).__old_x as *const _ as usize },
        6usize,
        concat!(
            "Offset of field: ",
            stringify!(drand48_data),
            "::",
            stringify!(__old_x)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<drand48_data>())).__c as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(drand48_data),
            "::",
            stringify!(__c)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<drand48_data>())).__init as *const _ as usize },
        14usize,
        concat!(
            "Offset of field: ",
            stringify!(drand48_data),
            "::",
            stringify!(__init)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<drand48_data>())).__a as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(drand48_data),
            "::",
            stringify!(__a)
        )
    );
}
extern "C" {
    pub fn drand48_r(__buffer: *mut drand48_data, __result: *mut f64) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn erand48_r(
        __xsubi: *mut ::std::os::raw::c_ushort,
        __buffer: *mut drand48_data,
        __result: *mut f64,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn lrand48_r(
        __buffer: *mut drand48_data,
        __result: *mut ::std::os::raw::c_long,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn nrand48_r(
        __xsubi: *mut ::std::os::raw::c_ushort,
        __buffer: *mut drand48_data,
        __result: *mut ::std::os::raw::c_long,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mrand48_r(
        __buffer: *mut drand48_data,
        __result: *mut ::std::os::raw::c_long,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn jrand48_r(
        __xsubi: *mut ::std::os::raw::c_ushort,
        __buffer: *mut drand48_data,
        __result: *mut ::std::os::raw::c_long,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn srand48_r(
        __seedval: ::std::os::raw::c_long,
        __buffer: *mut drand48_data,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn seed48_r(
        __seed16v: *mut ::std::os::raw::c_ushort,
        __buffer: *mut drand48_data,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn lcong48_r(
        __param: *mut ::std::os::raw::c_ushort,
        __buffer: *mut drand48_data,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn malloc(__size: ::std::os::raw::c_ulong) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn calloc(
        __nmemb: ::std::os::raw::c_ulong,
        __size: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn realloc(
        __ptr: *mut ::std::os::raw::c_void,
        __size: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn free(__ptr: *mut ::std::os::raw::c_void);
}
extern "C" {
    pub fn cfree(__ptr: *mut ::std::os::raw::c_void);
}
extern "C" {
    pub fn alloca(__size: ::std::os::raw::c_ulong) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn valloc(__size: size_t) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn posix_memalign(
        __memptr: *mut *mut ::std::os::raw::c_void,
        __alignment: size_t,
        __size: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn abort();
}
extern "C" {
    pub fn atexit(__func: ::std::option::Option<unsafe extern "C" fn()>) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn on_exit(
        __func: ::std::option::Option<
            unsafe extern "C" fn(
                __status: ::std::os::raw::c_int,
                __arg: *mut ::std::os::raw::c_void,
            ),
        >,
        __arg: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn exit(__status: ::std::os::raw::c_int);
}
extern "C" {
    pub fn _Exit(__status: ::std::os::raw::c_int);
}
extern "C" {
    pub fn getenv(__name: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn __secure_getenv(__name: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn putenv(__string: *mut ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn setenv(
        __name: *const ::std::os::raw::c_char,
        __value: *const ::std::os::raw::c_char,
        __replace: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn unsetenv(__name: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn clearenv() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mktemp(__template: *mut ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn mkstemp(__template: *mut ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mkstemps(
        __template: *mut ::std::os::raw::c_char,
        __suffixlen: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mkdtemp(__template: *mut ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn system(__command: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn realpath(
        __name: *const ::std::os::raw::c_char,
        __resolved: *mut ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
pub type __compar_fn_t = ::std::option::Option<
    unsafe extern "C" fn(
        arg1: *const ::std::os::raw::c_void,
        arg2: *const ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int,
>;
extern "C" {
    pub fn bsearch(
        __key: *const ::std::os::raw::c_void,
        __base: *const ::std::os::raw::c_void,
        __nmemb: size_t,
        __size: size_t,
        __compar: __compar_fn_t,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn qsort(
        __base: *mut ::std::os::raw::c_void,
        __nmemb: size_t,
        __size: size_t,
        __compar: __compar_fn_t,
    );
}
extern "C" {
    pub fn abs(__x: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn labs(__x: ::std::os::raw::c_long) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn llabs(__x: ::std::os::raw::c_longlong) -> ::std::os::raw::c_longlong;
}
extern "C" {
    pub fn div(__numer: ::std::os::raw::c_int, __denom: ::std::os::raw::c_int) -> div_t;
}
extern "C" {
    pub fn ldiv(__numer: ::std::os::raw::c_long, __denom: ::std::os::raw::c_long) -> ldiv_t;
}
extern "C" {
    pub fn lldiv(
        __numer: ::std::os::raw::c_longlong,
        __denom: ::std::os::raw::c_longlong,
    ) -> lldiv_t;
}
extern "C" {
    pub fn ecvt(
        __value: f64,
        __ndigit: ::std::os::raw::c_int,
        __decpt: *mut ::std::os::raw::c_int,
        __sign: *mut ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn fcvt(
        __value: f64,
        __ndigit: ::std::os::raw::c_int,
        __decpt: *mut ::std::os::raw::c_int,
        __sign: *mut ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn gcvt(
        __value: f64,
        __ndigit: ::std::os::raw::c_int,
        __buf: *mut ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn qecvt(
        __value: u128,
        __ndigit: ::std::os::raw::c_int,
        __decpt: *mut ::std::os::raw::c_int,
        __sign: *mut ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn qfcvt(
        __value: u128,
        __ndigit: ::std::os::raw::c_int,
        __decpt: *mut ::std::os::raw::c_int,
        __sign: *mut ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn qgcvt(
        __value: u128,
        __ndigit: ::std::os::raw::c_int,
        __buf: *mut ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn ecvt_r(
        __value: f64,
        __ndigit: ::std::os::raw::c_int,
        __decpt: *mut ::std::os::raw::c_int,
        __sign: *mut ::std::os::raw::c_int,
        __buf: *mut ::std::os::raw::c_char,
        __len: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fcvt_r(
        __value: f64,
        __ndigit: ::std::os::raw::c_int,
        __decpt: *mut ::std::os::raw::c_int,
        __sign: *mut ::std::os::raw::c_int,
        __buf: *mut ::std::os::raw::c_char,
        __len: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn qecvt_r(
        __value: u128,
        __ndigit: ::std::os::raw::c_int,
        __decpt: *mut ::std::os::raw::c_int,
        __sign: *mut ::std::os::raw::c_int,
        __buf: *mut ::std::os::raw::c_char,
        __len: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn qfcvt_r(
        __value: u128,
        __ndigit: ::std::os::raw::c_int,
        __decpt: *mut ::std::os::raw::c_int,
        __sign: *mut ::std::os::raw::c_int,
        __buf: *mut ::std::os::raw::c_char,
        __len: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mblen(__s: *const ::std::os::raw::c_char, __n: size_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mbtowc(
        __pwc: *mut wchar_t,
        __s: *const ::std::os::raw::c_char,
        __n: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn wctomb(__s: *mut ::std::os::raw::c_char, __wchar: wchar_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mbstowcs(
        __pwcs: *mut wchar_t,
        __s: *const ::std::os::raw::c_char,
        __n: size_t,
    ) -> size_t;
}
extern "C" {
    pub fn wcstombs(
        __s: *mut ::std::os::raw::c_char,
        __pwcs: *const wchar_t,
        __n: size_t,
    ) -> size_t;
}
extern "C" {
    pub fn rpmatch(__response: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getsubopt(
        __optionp: *mut *mut ::std::os::raw::c_char,
        __tokens: *const *mut ::std::os::raw::c_char,
        __valuep: *mut *mut ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getloadavg(__loadavg: *mut f64, __nelem: ::std::os::raw::c_int)
        -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn memcpy(
        __dest: *mut ::std::os::raw::c_void,
        __src: *const ::std::os::raw::c_void,
        __n: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn memmove(
        __dest: *mut ::std::os::raw::c_void,
        __src: *const ::std::os::raw::c_void,
        __n: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn memccpy(
        __dest: *mut ::std::os::raw::c_void,
        __src: *const ::std::os::raw::c_void,
        __c: ::std::os::raw::c_int,
        __n: size_t,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn memset(
        __s: *mut ::std::os::raw::c_void,
        __c: ::std::os::raw::c_int,
        __n: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn memcmp(
        __s1: *const ::std::os::raw::c_void,
        __s2: *const ::std::os::raw::c_void,
        __n: ::std::os::raw::c_ulong,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn memchr(
        __s: *const ::std::os::raw::c_void,
        __c: ::std::os::raw::c_int,
        __n: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn strcpy(
        __dest: *mut ::std::os::raw::c_char,
        __src: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strncpy(
        __dest: *mut ::std::os::raw::c_char,
        __src: *const ::std::os::raw::c_char,
        __n: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strcat(
        __dest: *mut ::std::os::raw::c_char,
        __src: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strncat(
        __dest: *mut ::std::os::raw::c_char,
        __src: *const ::std::os::raw::c_char,
        __n: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strcmp(
        __s1: *const ::std::os::raw::c_char,
        __s2: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn strncmp(
        __s1: *const ::std::os::raw::c_char,
        __s2: *const ::std::os::raw::c_char,
        __n: ::std::os::raw::c_ulong,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn strcoll(
        __s1: *const ::std::os::raw::c_char,
        __s2: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn strxfrm(
        __dest: *mut ::std::os::raw::c_char,
        __src: *const ::std::os::raw::c_char,
        __n: ::std::os::raw::c_ulong,
    ) -> ::std::os::raw::c_ulong;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __locale_struct {
    pub __locales: [*mut __locale_data; 13usize],
    pub __ctype_b: *const ::std::os::raw::c_ushort,
    pub __ctype_tolower: *const ::std::os::raw::c_int,
    pub __ctype_toupper: *const ::std::os::raw::c_int,
    pub __names: [*const ::std::os::raw::c_char; 13usize],
}
#[test]
fn bindgen_test_layout___locale_struct() {
    assert_eq!(
        ::std::mem::size_of::<__locale_struct>(),
        232usize,
        concat!("Size of: ", stringify!(__locale_struct))
    );
    assert_eq!(
        ::std::mem::align_of::<__locale_struct>(),
        8usize,
        concat!("Alignment of ", stringify!(__locale_struct))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__locale_struct>())).__locales as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__locale_struct),
            "::",
            stringify!(__locales)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__locale_struct>())).__ctype_b as *const _ as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(__locale_struct),
            "::",
            stringify!(__ctype_b)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__locale_struct>())).__ctype_tolower as *const _ as usize },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(__locale_struct),
            "::",
            stringify!(__ctype_tolower)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__locale_struct>())).__ctype_toupper as *const _ as usize },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(__locale_struct),
            "::",
            stringify!(__ctype_toupper)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__locale_struct>())).__names as *const _ as usize },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(__locale_struct),
            "::",
            stringify!(__names)
        )
    );
}
pub type __locale_t = *mut __locale_struct;
pub type locale_t = __locale_t;
extern "C" {
    pub fn strcoll_l(
        __s1: *const ::std::os::raw::c_char,
        __s2: *const ::std::os::raw::c_char,
        __l: __locale_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn strxfrm_l(
        __dest: *mut ::std::os::raw::c_char,
        __src: *const ::std::os::raw::c_char,
        __n: size_t,
        __l: __locale_t,
    ) -> size_t;
}
extern "C" {
    pub fn strdup(__s: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strndup(
        __string: *const ::std::os::raw::c_char,
        __n: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strchr(
        __s: *const ::std::os::raw::c_char,
        __c: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strrchr(
        __s: *const ::std::os::raw::c_char,
        __c: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strcspn(
        __s: *const ::std::os::raw::c_char,
        __reject: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_ulong;
}
extern "C" {
    pub fn strspn(
        __s: *const ::std::os::raw::c_char,
        __accept: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_ulong;
}
extern "C" {
    pub fn strpbrk(
        __s: *const ::std::os::raw::c_char,
        __accept: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strstr(
        __haystack: *const ::std::os::raw::c_char,
        __needle: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strtok(
        __s: *mut ::std::os::raw::c_char,
        __delim: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn __strtok_r(
        __s: *mut ::std::os::raw::c_char,
        __delim: *const ::std::os::raw::c_char,
        __save_ptr: *mut *mut ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strtok_r(
        __s: *mut ::std::os::raw::c_char,
        __delim: *const ::std::os::raw::c_char,
        __save_ptr: *mut *mut ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strlen(__s: *const ::std::os::raw::c_char) -> ::std::os::raw::c_ulong;
}
extern "C" {
    pub fn strnlen(__string: *const ::std::os::raw::c_char, __maxlen: size_t) -> size_t;
}
extern "C" {
    pub fn strerror(__errnum: ::std::os::raw::c_int) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    #[link_name = "\u{1}__xpg_strerror_r"]
    pub fn strerror_r(
        __errnum: ::std::os::raw::c_int,
        __buf: *mut ::std::os::raw::c_char,
        __buflen: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn strerror_l(
        __errnum: ::std::os::raw::c_int,
        __l: __locale_t,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn __bzero(__s: *mut ::std::os::raw::c_void, __n: size_t);
}
extern "C" {
    pub fn bcopy(
        __src: *const ::std::os::raw::c_void,
        __dest: *mut ::std::os::raw::c_void,
        __n: size_t,
    );
}
extern "C" {
    pub fn bzero(__s: *mut ::std::os::raw::c_void, __n: ::std::os::raw::c_ulong);
}
extern "C" {
    pub fn bcmp(
        __s1: *const ::std::os::raw::c_void,
        __s2: *const ::std::os::raw::c_void,
        __n: ::std::os::raw::c_ulong,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn index(
        __s: *const ::std::os::raw::c_char,
        __c: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn rindex(
        __s: *const ::std::os::raw::c_char,
        __c: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn ffs(__i: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn strcasecmp(
        __s1: *const ::std::os::raw::c_char,
        __s2: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn strncasecmp(
        __s1: *const ::std::os::raw::c_char,
        __s2: *const ::std::os::raw::c_char,
        __n: ::std::os::raw::c_ulong,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn strsep(
        __stringp: *mut *mut ::std::os::raw::c_char,
        __delim: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strsignal(__sig: ::std::os::raw::c_int) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn __stpcpy(
        __dest: *mut ::std::os::raw::c_char,
        __src: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn stpcpy(
        __dest: *mut ::std::os::raw::c_char,
        __src: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn __stpncpy(
        __dest: *mut ::std::os::raw::c_char,
        __src: *const ::std::os::raw::c_char,
        __n: size_t,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn stpncpy(
        __dest: *mut ::std::os::raw::c_char,
        __src: *const ::std::os::raw::c_char,
        __n: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_char;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ks_tokaux_t {
    pub tab: [u64; 4usize],
    pub sep: ::std::os::raw::c_int,
    pub finished: ::std::os::raw::c_int,
    pub p: *const ::std::os::raw::c_char,
}
#[test]
fn bindgen_test_layout_ks_tokaux_t() {
    assert_eq!(
        ::std::mem::size_of::<ks_tokaux_t>(),
        48usize,
        concat!("Size of: ", stringify!(ks_tokaux_t))
    );
    assert_eq!(
        ::std::mem::align_of::<ks_tokaux_t>(),
        8usize,
        concat!("Alignment of ", stringify!(ks_tokaux_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ks_tokaux_t>())).tab as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(ks_tokaux_t),
            "::",
            stringify!(tab)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ks_tokaux_t>())).sep as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(ks_tokaux_t),
            "::",
            stringify!(sep)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ks_tokaux_t>())).finished as *const _ as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(ks_tokaux_t),
            "::",
            stringify!(finished)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ks_tokaux_t>())).p as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(ks_tokaux_t),
            "::",
            stringify!(p)
        )
    );
}
extern "C" {
    pub fn kvsprintf(
        s: *mut kstring_t,
        fmt: *const ::std::os::raw::c_char,
        ap: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ksprintf(
        s: *mut kstring_t,
        fmt: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn kputd(d: f64, s: *mut kstring_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ksplit_core(
        s: *mut ::std::os::raw::c_char,
        delimiter: ::std::os::raw::c_int,
        _max: *mut ::std::os::raw::c_int,
        _offsets: *mut *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn kstrstr(
        str: *const ::std::os::raw::c_char,
        pat: *const ::std::os::raw::c_char,
        _prep: *mut *mut ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn kstrnstr(
        str: *const ::std::os::raw::c_char,
        pat: *const ::std::os::raw::c_char,
        n: ::std::os::raw::c_int,
        _prep: *mut *mut ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn kmemmem(
        _str: *const ::std::os::raw::c_void,
        n: ::std::os::raw::c_int,
        _pat: *const ::std::os::raw::c_void,
        m: ::std::os::raw::c_int,
        _prep: *mut *mut ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn kstrtok(
        str: *const ::std::os::raw::c_char,
        sep: *const ::std::os::raw::c_char,
        aux: *mut ks_tokaux_t,
    ) -> *mut ::std::os::raw::c_char;
}
pub type kgets_func = ::std::option::Option<
    unsafe extern "C" fn(
        arg1: *mut ::std::os::raw::c_char,
        arg2: ::std::os::raw::c_int,
        arg3: *mut ::std::os::raw::c_void,
    ) -> *mut ::std::os::raw::c_char,
>;
extern "C" {
    pub fn kgetline(
        s: *mut kstring_t,
        fgets: kgets_func,
        fp: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
pub type kgets_func2 = ::std::option::Option<
    unsafe extern "C" fn(
        arg1: *mut ::std::os::raw::c_char,
        arg2: size_t,
        arg3: *mut ::std::os::raw::c_void,
    ) -> ssize_t,
>;
extern "C" {
    pub fn kgetline2(
        s: *mut kstring_t,
        fgets: kgets_func2,
        fp: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
pub type uint16_u = u16;
pub type uint32_u = u32;
pub type uint64_u = u64;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct bcf_hrec_t {
    pub type_: ::std::os::raw::c_int,
    pub key: *mut ::std::os::raw::c_char,
    pub value: *mut ::std::os::raw::c_char,
    pub nkeys: ::std::os::raw::c_int,
    pub keys: *mut *mut ::std::os::raw::c_char,
    pub vals: *mut *mut ::std::os::raw::c_char,
}
#[test]
fn bindgen_test_layout_bcf_hrec_t() {
    assert_eq!(
        ::std::mem::size_of::<bcf_hrec_t>(),
        48usize,
        concat!("Size of: ", stringify!(bcf_hrec_t))
    );
    assert_eq!(
        ::std::mem::align_of::<bcf_hrec_t>(),
        8usize,
        concat!("Alignment of ", stringify!(bcf_hrec_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_hrec_t>())).type_ as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_hrec_t),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_hrec_t>())).key as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_hrec_t),
            "::",
            stringify!(key)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_hrec_t>())).value as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_hrec_t),
            "::",
            stringify!(value)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_hrec_t>())).nkeys as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_hrec_t),
            "::",
            stringify!(nkeys)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_hrec_t>())).keys as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_hrec_t),
            "::",
            stringify!(keys)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_hrec_t>())).vals as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_hrec_t),
            "::",
            stringify!(vals)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct bcf_idinfo_t {
    pub info: [u64; 3usize],
    pub hrec: [*mut bcf_hrec_t; 3usize],
    pub id: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_bcf_idinfo_t() {
    assert_eq!(
        ::std::mem::size_of::<bcf_idinfo_t>(),
        56usize,
        concat!("Size of: ", stringify!(bcf_idinfo_t))
    );
    assert_eq!(
        ::std::mem::align_of::<bcf_idinfo_t>(),
        8usize,
        concat!("Alignment of ", stringify!(bcf_idinfo_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_idinfo_t>())).info as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_idinfo_t),
            "::",
            stringify!(info)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_idinfo_t>())).hrec as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_idinfo_t),
            "::",
            stringify!(hrec)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_idinfo_t>())).id as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_idinfo_t),
            "::",
            stringify!(id)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct bcf_idpair_t {
    pub key: *const ::std::os::raw::c_char,
    pub val: *const bcf_idinfo_t,
}
#[test]
fn bindgen_test_layout_bcf_idpair_t() {
    assert_eq!(
        ::std::mem::size_of::<bcf_idpair_t>(),
        16usize,
        concat!("Size of: ", stringify!(bcf_idpair_t))
    );
    assert_eq!(
        ::std::mem::align_of::<bcf_idpair_t>(),
        8usize,
        concat!("Alignment of ", stringify!(bcf_idpair_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_idpair_t>())).key as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_idpair_t),
            "::",
            stringify!(key)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_idpair_t>())).val as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_idpair_t),
            "::",
            stringify!(val)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct bcf_hdr_t {
    pub n: [i32; 3usize],
    pub id: [*mut bcf_idpair_t; 3usize],
    pub dict: [*mut ::std::os::raw::c_void; 3usize],
    pub samples: *mut *mut ::std::os::raw::c_char,
    pub hrec: *mut *mut bcf_hrec_t,
    pub nhrec: ::std::os::raw::c_int,
    pub dirty: ::std::os::raw::c_int,
    pub ntransl: ::std::os::raw::c_int,
    pub transl: [*mut ::std::os::raw::c_int; 2usize],
    pub nsamples_ori: ::std::os::raw::c_int,
    pub keep_samples: *mut u8,
    pub mem: kstring_t,
    pub m: [i32; 3usize],
}
#[test]
fn bindgen_test_layout_bcf_hdr_t() {
    assert_eq!(
        ::std::mem::size_of::<bcf_hdr_t>(),
        168usize,
        concat!("Size of: ", stringify!(bcf_hdr_t))
    );
    assert_eq!(
        ::std::mem::align_of::<bcf_hdr_t>(),
        8usize,
        concat!("Alignment of ", stringify!(bcf_hdr_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_hdr_t>())).n as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_hdr_t),
            "::",
            stringify!(n)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_hdr_t>())).id as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_hdr_t),
            "::",
            stringify!(id)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_hdr_t>())).dict as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_hdr_t),
            "::",
            stringify!(dict)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_hdr_t>())).samples as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_hdr_t),
            "::",
            stringify!(samples)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_hdr_t>())).hrec as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_hdr_t),
            "::",
            stringify!(hrec)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_hdr_t>())).nhrec as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_hdr_t),
            "::",
            stringify!(nhrec)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_hdr_t>())).dirty as *const _ as usize },
        84usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_hdr_t),
            "::",
            stringify!(dirty)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_hdr_t>())).ntransl as *const _ as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_hdr_t),
            "::",
            stringify!(ntransl)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_hdr_t>())).transl as *const _ as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_hdr_t),
            "::",
            stringify!(transl)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_hdr_t>())).nsamples_ori as *const _ as usize },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_hdr_t),
            "::",
            stringify!(nsamples_ori)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_hdr_t>())).keep_samples as *const _ as usize },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_hdr_t),
            "::",
            stringify!(keep_samples)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_hdr_t>())).mem as *const _ as usize },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_hdr_t),
            "::",
            stringify!(mem)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_hdr_t>())).m as *const _ as usize },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_hdr_t),
            "::",
            stringify!(m)
        )
    );
}
extern "C" {
    pub static mut bcf_type_shift: [u8; 0usize];
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct variant_t {
    pub type_: ::std::os::raw::c_int,
    pub n: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_variant_t() {
    assert_eq!(
        ::std::mem::size_of::<variant_t>(),
        8usize,
        concat!("Size of: ", stringify!(variant_t))
    );
    assert_eq!(
        ::std::mem::align_of::<variant_t>(),
        4usize,
        concat!("Alignment of ", stringify!(variant_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<variant_t>())).type_ as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(variant_t),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<variant_t>())).n as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(variant_t),
            "::",
            stringify!(n)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct bcf_fmt_t {
    pub id: ::std::os::raw::c_int,
    pub n: ::std::os::raw::c_int,
    pub size: ::std::os::raw::c_int,
    pub type_: ::std::os::raw::c_int,
    pub p: *mut u8,
    pub p_len: u32,
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize], u32>,
}
#[test]
fn bindgen_test_layout_bcf_fmt_t() {
    assert_eq!(
        ::std::mem::size_of::<bcf_fmt_t>(),
        32usize,
        concat!("Size of: ", stringify!(bcf_fmt_t))
    );
    assert_eq!(
        ::std::mem::align_of::<bcf_fmt_t>(),
        8usize,
        concat!("Alignment of ", stringify!(bcf_fmt_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_fmt_t>())).id as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_fmt_t),
            "::",
            stringify!(id)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_fmt_t>())).n as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_fmt_t),
            "::",
            stringify!(n)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_fmt_t>())).size as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_fmt_t),
            "::",
            stringify!(size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_fmt_t>())).type_ as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_fmt_t),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_fmt_t>())).p as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_fmt_t),
            "::",
            stringify!(p)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_fmt_t>())).p_len as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_fmt_t),
            "::",
            stringify!(p_len)
        )
    );
}
impl bcf_fmt_t {
    #[inline]
    pub fn p_off(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 31u8) as u32) }
    }
    #[inline]
    pub fn set_p_off(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 31u8, val as u64)
        }
    }
    #[inline]
    pub fn p_free(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(31usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_p_free(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(31usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(p_off: u32, p_free: u32) -> __BindgenBitfieldUnit<[u8; 4usize], u32> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize], u32> =
            Default::default();
        __bindgen_bitfield_unit.set(0usize, 31u8, {
            let p_off: u32 = unsafe { ::std::mem::transmute(p_off) };
            p_off as u64
        });
        __bindgen_bitfield_unit.set(31usize, 1u8, {
            let p_free: u32 = unsafe { ::std::mem::transmute(p_free) };
            p_free as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct bcf_info_t {
    pub key: ::std::os::raw::c_int,
    pub type_: ::std::os::raw::c_int,
    pub v1: bcf_info_t__bindgen_ty_1,
    pub vptr: *mut u8,
    pub vptr_len: u32,
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize], u32>,
    pub len: ::std::os::raw::c_int,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union bcf_info_t__bindgen_ty_1 {
    pub i: i64,
    pub f: f32,
    _bindgen_union_align: u64,
}
#[test]
fn bindgen_test_layout_bcf_info_t__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<bcf_info_t__bindgen_ty_1>(),
        8usize,
        concat!("Size of: ", stringify!(bcf_info_t__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<bcf_info_t__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(bcf_info_t__bindgen_ty_1))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_info_t__bindgen_ty_1>())).i as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_info_t__bindgen_ty_1),
            "::",
            stringify!(i)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_info_t__bindgen_ty_1>())).f as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_info_t__bindgen_ty_1),
            "::",
            stringify!(f)
        )
    );
}
#[test]
fn bindgen_test_layout_bcf_info_t() {
    assert_eq!(
        ::std::mem::size_of::<bcf_info_t>(),
        40usize,
        concat!("Size of: ", stringify!(bcf_info_t))
    );
    assert_eq!(
        ::std::mem::align_of::<bcf_info_t>(),
        8usize,
        concat!("Alignment of ", stringify!(bcf_info_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_info_t>())).key as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_info_t),
            "::",
            stringify!(key)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_info_t>())).type_ as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_info_t),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_info_t>())).v1 as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_info_t),
            "::",
            stringify!(v1)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_info_t>())).vptr as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_info_t),
            "::",
            stringify!(vptr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_info_t>())).vptr_len as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_info_t),
            "::",
            stringify!(vptr_len)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_info_t>())).len as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_info_t),
            "::",
            stringify!(len)
        )
    );
}
impl bcf_info_t {
    #[inline]
    pub fn vptr_off(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 31u8) as u32) }
    }
    #[inline]
    pub fn set_vptr_off(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 31u8, val as u64)
        }
    }
    #[inline]
    pub fn vptr_free(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(31usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_vptr_free(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(31usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        vptr_off: u32,
        vptr_free: u32,
    ) -> __BindgenBitfieldUnit<[u8; 4usize], u32> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize], u32> =
            Default::default();
        __bindgen_bitfield_unit.set(0usize, 31u8, {
            let vptr_off: u32 = unsafe { ::std::mem::transmute(vptr_off) };
            vptr_off as u64
        });
        __bindgen_bitfield_unit.set(31usize, 1u8, {
            let vptr_free: u32 = unsafe { ::std::mem::transmute(vptr_free) };
            vptr_free as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct bcf_dec_t {
    pub m_fmt: ::std::os::raw::c_int,
    pub m_info: ::std::os::raw::c_int,
    pub m_id: ::std::os::raw::c_int,
    pub m_als: ::std::os::raw::c_int,
    pub m_allele: ::std::os::raw::c_int,
    pub m_flt: ::std::os::raw::c_int,
    pub n_flt: ::std::os::raw::c_int,
    pub flt: *mut ::std::os::raw::c_int,
    pub id: *mut ::std::os::raw::c_char,
    pub als: *mut ::std::os::raw::c_char,
    pub allele: *mut *mut ::std::os::raw::c_char,
    pub info: *mut bcf_info_t,
    pub fmt: *mut bcf_fmt_t,
    pub var: *mut variant_t,
    pub n_var: ::std::os::raw::c_int,
    pub var_type: ::std::os::raw::c_int,
    pub shared_dirty: ::std::os::raw::c_int,
    pub indiv_dirty: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_bcf_dec_t() {
    assert_eq!(
        ::std::mem::size_of::<bcf_dec_t>(),
        104usize,
        concat!("Size of: ", stringify!(bcf_dec_t))
    );
    assert_eq!(
        ::std::mem::align_of::<bcf_dec_t>(),
        8usize,
        concat!("Alignment of ", stringify!(bcf_dec_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_dec_t>())).m_fmt as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_dec_t),
            "::",
            stringify!(m_fmt)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_dec_t>())).m_info as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_dec_t),
            "::",
            stringify!(m_info)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_dec_t>())).m_id as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_dec_t),
            "::",
            stringify!(m_id)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_dec_t>())).m_als as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_dec_t),
            "::",
            stringify!(m_als)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_dec_t>())).m_allele as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_dec_t),
            "::",
            stringify!(m_allele)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_dec_t>())).m_flt as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_dec_t),
            "::",
            stringify!(m_flt)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_dec_t>())).n_flt as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_dec_t),
            "::",
            stringify!(n_flt)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_dec_t>())).flt as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_dec_t),
            "::",
            stringify!(flt)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_dec_t>())).id as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_dec_t),
            "::",
            stringify!(id)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_dec_t>())).als as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_dec_t),
            "::",
            stringify!(als)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_dec_t>())).allele as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_dec_t),
            "::",
            stringify!(allele)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_dec_t>())).info as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_dec_t),
            "::",
            stringify!(info)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_dec_t>())).fmt as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_dec_t),
            "::",
            stringify!(fmt)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_dec_t>())).var as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_dec_t),
            "::",
            stringify!(var)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_dec_t>())).n_var as *const _ as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_dec_t),
            "::",
            stringify!(n_var)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_dec_t>())).var_type as *const _ as usize },
        92usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_dec_t),
            "::",
            stringify!(var_type)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_dec_t>())).shared_dirty as *const _ as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_dec_t),
            "::",
            stringify!(shared_dirty)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_dec_t>())).indiv_dirty as *const _ as usize },
        100usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_dec_t),
            "::",
            stringify!(indiv_dirty)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct bcf1_t {
    pub pos: hts_pos_t,
    pub rlen: hts_pos_t,
    pub rid: i32,
    pub qual: f32,
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 8usize], u32>,
    pub shared: kstring_t,
    pub indiv: kstring_t,
    pub d: bcf_dec_t,
    pub max_unpack: ::std::os::raw::c_int,
    pub unpacked: ::std::os::raw::c_int,
    pub unpack_size: [::std::os::raw::c_int; 3usize],
    pub errcode: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_bcf1_t() {
    assert_eq!(
        ::std::mem::size_of::<bcf1_t>(),
        208usize,
        concat!("Size of: ", stringify!(bcf1_t))
    );
    assert_eq!(
        ::std::mem::align_of::<bcf1_t>(),
        8usize,
        concat!("Alignment of ", stringify!(bcf1_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf1_t>())).pos as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf1_t),
            "::",
            stringify!(pos)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf1_t>())).rlen as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf1_t),
            "::",
            stringify!(rlen)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf1_t>())).rid as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf1_t),
            "::",
            stringify!(rid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf1_t>())).qual as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf1_t),
            "::",
            stringify!(qual)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf1_t>())).shared as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf1_t),
            "::",
            stringify!(shared)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf1_t>())).indiv as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf1_t),
            "::",
            stringify!(indiv)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf1_t>())).d as *const _ as usize },
        80usize,
        concat!("Offset of field: ", stringify!(bcf1_t), "::", stringify!(d))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf1_t>())).max_unpack as *const _ as usize },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf1_t),
            "::",
            stringify!(max_unpack)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf1_t>())).unpacked as *const _ as usize },
        188usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf1_t),
            "::",
            stringify!(unpacked)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf1_t>())).unpack_size as *const _ as usize },
        192usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf1_t),
            "::",
            stringify!(unpack_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf1_t>())).errcode as *const _ as usize },
        204usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf1_t),
            "::",
            stringify!(errcode)
        )
    );
}
impl bcf1_t {
    #[inline]
    pub fn n_info(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 16u8) as u32) }
    }
    #[inline]
    pub fn set_n_info(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 16u8, val as u64)
        }
    }
    #[inline]
    pub fn n_allele(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(16usize, 16u8) as u32) }
    }
    #[inline]
    pub fn set_n_allele(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(16usize, 16u8, val as u64)
        }
    }
    #[inline]
    pub fn n_fmt(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(32usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_n_fmt(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(32usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn n_sample(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(40usize, 24u8) as u32) }
    }
    #[inline]
    pub fn set_n_sample(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(40usize, 24u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        n_info: u32,
        n_allele: u32,
        n_fmt: u32,
        n_sample: u32,
    ) -> __BindgenBitfieldUnit<[u8; 8usize], u32> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 8usize], u32> =
            Default::default();
        __bindgen_bitfield_unit.set(0usize, 16u8, {
            let n_info: u32 = unsafe { ::std::mem::transmute(n_info) };
            n_info as u64
        });
        __bindgen_bitfield_unit.set(16usize, 16u8, {
            let n_allele: u32 = unsafe { ::std::mem::transmute(n_allele) };
            n_allele as u64
        });
        __bindgen_bitfield_unit.set(32usize, 8u8, {
            let n_fmt: u32 = unsafe { ::std::mem::transmute(n_fmt) };
            n_fmt as u64
        });
        __bindgen_bitfield_unit.set(40usize, 24u8, {
            let n_sample: u32 = unsafe { ::std::mem::transmute(n_sample) };
            n_sample as u64
        });
        __bindgen_bitfield_unit
    }
}
extern "C" {
    pub fn bcf_hdr_init(mode: *const ::std::os::raw::c_char) -> *mut bcf_hdr_t;
}
extern "C" {
    pub fn bcf_hdr_destroy(h: *mut bcf_hdr_t);
}
extern "C" {
    pub fn bcf_init() -> *mut bcf1_t;
}
extern "C" {
    pub fn bcf_destroy(v: *mut bcf1_t);
}
extern "C" {
    pub fn bcf_empty(v: *mut bcf1_t);
}
extern "C" {
    pub fn bcf_clear(v: *mut bcf1_t);
}
pub type vcfFile = htsFile;
extern "C" {
    pub fn bcf_hdr_read(fp: *mut htsFile) -> *mut bcf_hdr_t;
}
extern "C" {
    pub fn bcf_hdr_set_samples(
        hdr: *mut bcf_hdr_t,
        samples: *const ::std::os::raw::c_char,
        is_file: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcf_subset_format(hdr: *const bcf_hdr_t, rec: *mut bcf1_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcf_hdr_write(fp: *mut htsFile, h: *mut bcf_hdr_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn vcf_parse(
        s: *mut kstring_t,
        h: *const bcf_hdr_t,
        v: *mut bcf1_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn vcf_format(
        h: *const bcf_hdr_t,
        v: *const bcf1_t,
        s: *mut kstring_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcf_read(fp: *mut htsFile, h: *const bcf_hdr_t, v: *mut bcf1_t)
        -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcf_unpack(b: *mut bcf1_t, which: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcf_dup(src: *mut bcf1_t) -> *mut bcf1_t;
}
extern "C" {
    pub fn bcf_copy(dst: *mut bcf1_t, src: *mut bcf1_t) -> *mut bcf1_t;
}
extern "C" {
    pub fn bcf_write(fp: *mut htsFile, h: *mut bcf_hdr_t, v: *mut bcf1_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn vcf_hdr_read(fp: *mut htsFile) -> *mut bcf_hdr_t;
}
extern "C" {
    pub fn vcf_hdr_write(fp: *mut htsFile, h: *const bcf_hdr_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn vcf_read(fp: *mut htsFile, h: *const bcf_hdr_t, v: *mut bcf1_t)
        -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn vcf_write(
        fp: *mut htsFile,
        h: *const bcf_hdr_t,
        v: *mut bcf1_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcf_readrec(
        fp: *mut BGZF,
        null: *mut ::std::os::raw::c_void,
        v: *mut ::std::os::raw::c_void,
        tid: *mut ::std::os::raw::c_int,
        beg: *mut hts_pos_t,
        end: *mut hts_pos_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn vcf_write_line(fp: *mut htsFile, line: *mut kstring_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcf_hdr_dup(hdr: *const bcf_hdr_t) -> *mut bcf_hdr_t;
}
extern "C" {
    pub fn bcf_hdr_combine(dst: *mut bcf_hdr_t, src: *const bcf_hdr_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcf_hdr_merge(dst: *mut bcf_hdr_t, src: *const bcf_hdr_t) -> *mut bcf_hdr_t;
}
extern "C" {
    pub fn bcf_hdr_add_sample(
        hdr: *mut bcf_hdr_t,
        sample: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcf_hdr_set(
        hdr: *mut bcf_hdr_t,
        fname: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcf_hdr_format(
        hdr: *const bcf_hdr_t,
        is_bcf: ::std::os::raw::c_int,
        str: *mut kstring_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcf_hdr_fmt_text(
        hdr: *const bcf_hdr_t,
        is_bcf: ::std::os::raw::c_int,
        len: *mut ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn bcf_hdr_append(
        h: *mut bcf_hdr_t,
        line: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcf_hdr_printf(
        h: *mut bcf_hdr_t,
        format: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcf_hdr_get_version(hdr: *const bcf_hdr_t) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn bcf_hdr_set_version(
        hdr: *mut bcf_hdr_t,
        version: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcf_hdr_remove(
        h: *mut bcf_hdr_t,
        type_: ::std::os::raw::c_int,
        key: *const ::std::os::raw::c_char,
    );
}
extern "C" {
    pub fn bcf_hdr_subset(
        h0: *const bcf_hdr_t,
        n: ::std::os::raw::c_int,
        samples: *const *mut ::std::os::raw::c_char,
        imap: *mut ::std::os::raw::c_int,
    ) -> *mut bcf_hdr_t;
}
extern "C" {
    pub fn bcf_hdr_seqnames(
        h: *const bcf_hdr_t,
        nseqs: *mut ::std::os::raw::c_int,
    ) -> *mut *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn bcf_hdr_parse(
        hdr: *mut bcf_hdr_t,
        htxt: *mut ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcf_hdr_sync(h: *mut bcf_hdr_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcf_hdr_parse_line(
        h: *const bcf_hdr_t,
        line: *const ::std::os::raw::c_char,
        len: *mut ::std::os::raw::c_int,
    ) -> *mut bcf_hrec_t;
}
extern "C" {
    pub fn bcf_hrec_format(hrec: *const bcf_hrec_t, str: *mut kstring_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcf_hdr_add_hrec(hdr: *mut bcf_hdr_t, hrec: *mut bcf_hrec_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcf_hdr_get_hrec(
        hdr: *const bcf_hdr_t,
        type_: ::std::os::raw::c_int,
        key: *const ::std::os::raw::c_char,
        value: *const ::std::os::raw::c_char,
        str_class: *const ::std::os::raw::c_char,
    ) -> *mut bcf_hrec_t;
}
extern "C" {
    pub fn bcf_hrec_dup(hrec: *mut bcf_hrec_t) -> *mut bcf_hrec_t;
}
extern "C" {
    pub fn bcf_hrec_add_key(
        hrec: *mut bcf_hrec_t,
        str: *const ::std::os::raw::c_char,
        len: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcf_hrec_set_val(
        hrec: *mut bcf_hrec_t,
        i: ::std::os::raw::c_int,
        str: *const ::std::os::raw::c_char,
        len: size_t,
        is_quoted: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcf_hrec_find_key(
        hrec: *mut bcf_hrec_t,
        key: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn hrec_add_idx(hrec: *mut bcf_hrec_t, idx: ::std::os::raw::c_int)
        -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcf_hrec_destroy(hrec: *mut bcf_hrec_t);
}
extern "C" {
    pub fn bcf_subset(
        h: *const bcf_hdr_t,
        v: *mut bcf1_t,
        n: ::std::os::raw::c_int,
        imap: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcf_translate(
        dst_hdr: *const bcf_hdr_t,
        src_hdr: *mut bcf_hdr_t,
        src_line: *mut bcf1_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcf_get_variant_types(rec: *mut bcf1_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcf_get_variant_type(
        rec: *mut bcf1_t,
        ith_allele: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcf_is_snp(v: *mut bcf1_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcf_update_filter(
        hdr: *const bcf_hdr_t,
        line: *mut bcf1_t,
        flt_ids: *mut ::std::os::raw::c_int,
        n: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcf_add_filter(
        hdr: *const bcf_hdr_t,
        line: *mut bcf1_t,
        flt_id: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcf_remove_filter(
        hdr: *const bcf_hdr_t,
        line: *mut bcf1_t,
        flt_id: ::std::os::raw::c_int,
        pass: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcf_has_filter(
        hdr: *const bcf_hdr_t,
        line: *mut bcf1_t,
        filter: *mut ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcf_update_alleles(
        hdr: *const bcf_hdr_t,
        line: *mut bcf1_t,
        alleles: *mut *const ::std::os::raw::c_char,
        nals: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcf_update_alleles_str(
        hdr: *const bcf_hdr_t,
        line: *mut bcf1_t,
        alleles_string: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcf_update_id(
        hdr: *const bcf_hdr_t,
        line: *mut bcf1_t,
        id: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcf_add_id(
        hdr: *const bcf_hdr_t,
        line: *mut bcf1_t,
        id: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcf_update_info(
        hdr: *const bcf_hdr_t,
        line: *mut bcf1_t,
        key: *const ::std::os::raw::c_char,
        values: *const ::std::os::raw::c_void,
        n: ::std::os::raw::c_int,
        type_: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcf_update_format_string(
        hdr: *const bcf_hdr_t,
        line: *mut bcf1_t,
        key: *const ::std::os::raw::c_char,
        values: *mut *const ::std::os::raw::c_char,
        n: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcf_update_format(
        hdr: *const bcf_hdr_t,
        line: *mut bcf1_t,
        key: *const ::std::os::raw::c_char,
        values: *const ::std::os::raw::c_void,
        n: ::std::os::raw::c_int,
        type_: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcf_get_fmt(
        hdr: *const bcf_hdr_t,
        line: *mut bcf1_t,
        key: *const ::std::os::raw::c_char,
    ) -> *mut bcf_fmt_t;
}
extern "C" {
    pub fn bcf_get_info(
        hdr: *const bcf_hdr_t,
        line: *mut bcf1_t,
        key: *const ::std::os::raw::c_char,
    ) -> *mut bcf_info_t;
}
extern "C" {
    pub fn bcf_get_fmt_id(line: *mut bcf1_t, id: ::std::os::raw::c_int) -> *mut bcf_fmt_t;
}
extern "C" {
    pub fn bcf_get_info_id(line: *mut bcf1_t, id: ::std::os::raw::c_int) -> *mut bcf_info_t;
}
extern "C" {
    pub fn bcf_get_info_values(
        hdr: *const bcf_hdr_t,
        line: *mut bcf1_t,
        tag: *const ::std::os::raw::c_char,
        dst: *mut *mut ::std::os::raw::c_void,
        ndst: *mut ::std::os::raw::c_int,
        type_: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcf_get_format_string(
        hdr: *const bcf_hdr_t,
        line: *mut bcf1_t,
        tag: *const ::std::os::raw::c_char,
        dst: *mut *mut *mut ::std::os::raw::c_char,
        ndst: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcf_get_format_values(
        hdr: *const bcf_hdr_t,
        line: *mut bcf1_t,
        tag: *const ::std::os::raw::c_char,
        dst: *mut *mut ::std::os::raw::c_void,
        ndst: *mut ::std::os::raw::c_int,
        type_: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcf_hdr_id2int(
        hdr: *const bcf_hdr_t,
        type_: ::std::os::raw::c_int,
        id: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcf_fmt_array(
        s: *mut kstring_t,
        n: ::std::os::raw::c_int,
        type_: ::std::os::raw::c_int,
        data: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcf_fmt_sized_array(s: *mut kstring_t, ptr: *mut u8) -> *mut u8;
}
extern "C" {
    pub fn bcf_enc_vchar(
        s: *mut kstring_t,
        l: ::std::os::raw::c_int,
        a: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcf_enc_vint(
        s: *mut kstring_t,
        n: ::std::os::raw::c_int,
        a: *mut i32,
        wsize: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcf_enc_vfloat(
        s: *mut kstring_t,
        n: ::std::os::raw::c_int,
        a: *mut f32,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcf_index_load2(
        fn_: *const ::std::os::raw::c_char,
        fnidx: *const ::std::os::raw::c_char,
    ) -> *mut hts_idx_t;
}
extern "C" {
    pub fn bcf_index_load3(
        fn_: *const ::std::os::raw::c_char,
        fnidx: *const ::std::os::raw::c_char,
        flags: ::std::os::raw::c_int,
    ) -> *mut hts_idx_t;
}
extern "C" {
    pub fn bcf_index_build(
        fn_: *const ::std::os::raw::c_char,
        min_shift: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcf_index_build2(
        fn_: *const ::std::os::raw::c_char,
        fnidx: *const ::std::os::raw::c_char,
        min_shift: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcf_index_build3(
        fn_: *const ::std::os::raw::c_char,
        fnidx: *const ::std::os::raw::c_char,
        min_shift: ::std::os::raw::c_int,
        n_threads: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcf_idx_init(
        fp: *mut htsFile,
        h: *mut bcf_hdr_t,
        min_shift: ::std::os::raw::c_int,
        fnidx: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcf_idx_save(fp: *mut htsFile) -> ::std::os::raw::c_int;
}
extern "C" {
    pub static mut bcf_float_vector_end: u32;
}
extern "C" {
    pub static mut bcf_float_missing: u32;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct sam_hrecs_t {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct sam_hdr_t {
    pub n_targets: i32,
    pub ignore_sam_err: i32,
    pub l_text: size_t,
    pub target_len: *mut u32,
    pub cigar_tab: *const i8,
    pub target_name: *mut *mut ::std::os::raw::c_char,
    pub text: *mut ::std::os::raw::c_char,
    pub sdict: *mut ::std::os::raw::c_void,
    pub hrecs: *mut sam_hrecs_t,
    pub ref_count: u32,
}
#[test]
fn bindgen_test_layout_sam_hdr_t() {
    assert_eq!(
        ::std::mem::size_of::<sam_hdr_t>(),
        72usize,
        concat!("Size of: ", stringify!(sam_hdr_t))
    );
    assert_eq!(
        ::std::mem::align_of::<sam_hdr_t>(),
        8usize,
        concat!("Alignment of ", stringify!(sam_hdr_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sam_hdr_t>())).n_targets as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(sam_hdr_t),
            "::",
            stringify!(n_targets)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sam_hdr_t>())).ignore_sam_err as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(sam_hdr_t),
            "::",
            stringify!(ignore_sam_err)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sam_hdr_t>())).l_text as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(sam_hdr_t),
            "::",
            stringify!(l_text)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sam_hdr_t>())).target_len as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(sam_hdr_t),
            "::",
            stringify!(target_len)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sam_hdr_t>())).cigar_tab as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(sam_hdr_t),
            "::",
            stringify!(cigar_tab)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sam_hdr_t>())).target_name as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(sam_hdr_t),
            "::",
            stringify!(target_name)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sam_hdr_t>())).text as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(sam_hdr_t),
            "::",
            stringify!(text)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sam_hdr_t>())).sdict as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(sam_hdr_t),
            "::",
            stringify!(sdict)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sam_hdr_t>())).hrecs as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(sam_hdr_t),
            "::",
            stringify!(hrecs)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sam_hdr_t>())).ref_count as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(sam_hdr_t),
            "::",
            stringify!(ref_count)
        )
    );
}
pub type bam_hdr_t = sam_hdr_t;
extern "C" {
    pub static bam_cigar_table: [i8; 256usize];
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct bam1_core_t {
    pub pos: hts_pos_t,
    pub tid: i32,
    pub bin: u16,
    pub qual: u8,
    pub l_extranul: u8,
    pub flag: u16,
    pub l_qname: u16,
    pub n_cigar: u32,
    pub l_qseq: i32,
    pub mtid: i32,
    pub mpos: hts_pos_t,
    pub isize: hts_pos_t,
}
#[test]
fn bindgen_test_layout_bam1_core_t() {
    assert_eq!(
        ::std::mem::size_of::<bam1_core_t>(),
        48usize,
        concat!("Size of: ", stringify!(bam1_core_t))
    );
    assert_eq!(
        ::std::mem::align_of::<bam1_core_t>(),
        8usize,
        concat!("Alignment of ", stringify!(bam1_core_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bam1_core_t>())).pos as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bam1_core_t),
            "::",
            stringify!(pos)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bam1_core_t>())).tid as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(bam1_core_t),
            "::",
            stringify!(tid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bam1_core_t>())).bin as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(bam1_core_t),
            "::",
            stringify!(bin)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bam1_core_t>())).qual as *const _ as usize },
        14usize,
        concat!(
            "Offset of field: ",
            stringify!(bam1_core_t),
            "::",
            stringify!(qual)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bam1_core_t>())).l_extranul as *const _ as usize },
        15usize,
        concat!(
            "Offset of field: ",
            stringify!(bam1_core_t),
            "::",
            stringify!(l_extranul)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bam1_core_t>())).flag as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(bam1_core_t),
            "::",
            stringify!(flag)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bam1_core_t>())).l_qname as *const _ as usize },
        18usize,
        concat!(
            "Offset of field: ",
            stringify!(bam1_core_t),
            "::",
            stringify!(l_qname)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bam1_core_t>())).n_cigar as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(bam1_core_t),
            "::",
            stringify!(n_cigar)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bam1_core_t>())).l_qseq as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(bam1_core_t),
            "::",
            stringify!(l_qseq)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bam1_core_t>())).mtid as *const _ as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(bam1_core_t),
            "::",
            stringify!(mtid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bam1_core_t>())).mpos as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(bam1_core_t),
            "::",
            stringify!(mpos)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bam1_core_t>())).isize as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(bam1_core_t),
            "::",
            stringify!(isize)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct bam1_t {
    pub core: bam1_core_t,
    pub id: u64,
    pub data: *mut u8,
    pub l_data: ::std::os::raw::c_int,
    pub m_data: u32,
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize], u8>,
    pub __bindgen_padding_0: u32,
}
#[test]
fn bindgen_test_layout_bam1_t() {
    assert_eq!(
        ::std::mem::size_of::<bam1_t>(),
        80usize,
        concat!("Size of: ", stringify!(bam1_t))
    );
    assert_eq!(
        ::std::mem::align_of::<bam1_t>(),
        8usize,
        concat!("Alignment of ", stringify!(bam1_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bam1_t>())).core as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bam1_t),
            "::",
            stringify!(core)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bam1_t>())).id as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(bam1_t),
            "::",
            stringify!(id)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bam1_t>())).data as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(bam1_t),
            "::",
            stringify!(data)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bam1_t>())).l_data as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(bam1_t),
            "::",
            stringify!(l_data)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bam1_t>())).m_data as *const _ as usize },
        68usize,
        concat!(
            "Offset of field: ",
            stringify!(bam1_t),
            "::",
            stringify!(m_data)
        )
    );
}
impl bam1_t {
    #[inline]
    pub fn mempolicy(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 2u8) as u32) }
    }
    #[inline]
    pub fn set_mempolicy(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(mempolicy: u32) -> __BindgenBitfieldUnit<[u8; 4usize], u8> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize], u8> =
            Default::default();
        __bindgen_bitfield_unit.set(0usize, 2u8, {
            let mempolicy: u32 = unsafe { ::std::mem::transmute(mempolicy) };
            mempolicy as u64
        });
        __bindgen_bitfield_unit
    }
}
extern "C" {
    pub fn sam_hdr_init() -> *mut sam_hdr_t;
}
extern "C" {
    pub fn bam_hdr_read(fp: *mut BGZF) -> *mut sam_hdr_t;
}
extern "C" {
    pub fn bam_hdr_write(fp: *mut BGZF, h: *const sam_hdr_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sam_hdr_destroy(h: *mut sam_hdr_t);
}
extern "C" {
    pub fn sam_hdr_dup(h0: *const sam_hdr_t) -> *mut sam_hdr_t;
}
pub type samFile = htsFile;
extern "C" {
    pub fn sam_hdr_parse(l_text: size_t, text: *const ::std::os::raw::c_char) -> *mut sam_hdr_t;
}
extern "C" {
    pub fn sam_hdr_read(fp: *mut samFile) -> *mut sam_hdr_t;
}
extern "C" {
    pub fn sam_hdr_write(fp: *mut samFile, h: *const sam_hdr_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sam_hdr_length(h: *mut sam_hdr_t) -> size_t;
}
extern "C" {
    pub fn sam_hdr_str(h: *mut sam_hdr_t) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn sam_hdr_nref(h: *const sam_hdr_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sam_hdr_add_lines(
        h: *mut sam_hdr_t,
        lines: *const ::std::os::raw::c_char,
        len: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sam_hdr_add_line(
        h: *mut sam_hdr_t,
        type_: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sam_hdr_find_line_id(
        h: *mut sam_hdr_t,
        type_: *const ::std::os::raw::c_char,
        ID_key: *const ::std::os::raw::c_char,
        ID_val: *const ::std::os::raw::c_char,
        ks: *mut kstring_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sam_hdr_find_line_pos(
        h: *mut sam_hdr_t,
        type_: *const ::std::os::raw::c_char,
        pos: ::std::os::raw::c_int,
        ks: *mut kstring_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sam_hdr_remove_line_id(
        h: *mut sam_hdr_t,
        type_: *const ::std::os::raw::c_char,
        ID_key: *const ::std::os::raw::c_char,
        ID_value: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sam_hdr_remove_line_pos(
        h: *mut sam_hdr_t,
        type_: *const ::std::os::raw::c_char,
        position: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sam_hdr_update_line(
        h: *mut sam_hdr_t,
        type_: *const ::std::os::raw::c_char,
        ID_key: *const ::std::os::raw::c_char,
        ID_value: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sam_hdr_remove_except(
        h: *mut sam_hdr_t,
        type_: *const ::std::os::raw::c_char,
        ID_key: *const ::std::os::raw::c_char,
        ID_value: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sam_hdr_remove_lines(
        h: *mut sam_hdr_t,
        type_: *const ::std::os::raw::c_char,
        id: *const ::std::os::raw::c_char,
        rh: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sam_hdr_count_lines(
        h: *mut sam_hdr_t,
        type_: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sam_hdr_line_index(
        bh: *mut sam_hdr_t,
        type_: *const ::std::os::raw::c_char,
        key: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sam_hdr_line_name(
        bh: *mut sam_hdr_t,
        type_: *const ::std::os::raw::c_char,
        pos: ::std::os::raw::c_int,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn sam_hdr_find_tag_id(
        h: *mut sam_hdr_t,
        type_: *const ::std::os::raw::c_char,
        ID_key: *const ::std::os::raw::c_char,
        ID_value: *const ::std::os::raw::c_char,
        key: *const ::std::os::raw::c_char,
        ks: *mut kstring_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sam_hdr_find_tag_pos(
        h: *mut sam_hdr_t,
        type_: *const ::std::os::raw::c_char,
        pos: ::std::os::raw::c_int,
        key: *const ::std::os::raw::c_char,
        ks: *mut kstring_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sam_hdr_remove_tag_id(
        h: *mut sam_hdr_t,
        type_: *const ::std::os::raw::c_char,
        ID_key: *const ::std::os::raw::c_char,
        ID_value: *const ::std::os::raw::c_char,
        key: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sam_hdr_name2tid(
        h: *mut sam_hdr_t,
        ref_: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sam_hdr_tid2name(
        h: *const sam_hdr_t,
        tid: ::std::os::raw::c_int,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn sam_hdr_tid2len(h: *const sam_hdr_t, tid: ::std::os::raw::c_int) -> hts_pos_t;
}
extern "C" {
    pub fn sam_hdr_pg_id(
        h: *mut sam_hdr_t,
        name: *const ::std::os::raw::c_char,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn sam_hdr_add_pg(
        h: *mut sam_hdr_t,
        name: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn stringify_argv(
        argc: ::std::os::raw::c_int,
        argv: *mut *mut ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn sam_hdr_incr_ref(h: *mut sam_hdr_t);
}
extern "C" {
    pub fn bam_init1() -> *mut bam1_t;
}
extern "C" {
    pub fn bam_destroy1(b: *mut bam1_t);
}
extern "C" {
    pub fn bam_read1(fp: *mut BGZF, b: *mut bam1_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bam_write1(fp: *mut BGZF, b: *const bam1_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bam_copy1(bdst: *mut bam1_t, bsrc: *const bam1_t) -> *mut bam1_t;
}
extern "C" {
    pub fn bam_dup1(bsrc: *const bam1_t) -> *mut bam1_t;
}
extern "C" {
    pub fn bam_cigar2qlen(n_cigar: ::std::os::raw::c_int, cigar: *const u32) -> hts_pos_t;
}
extern "C" {
    pub fn bam_cigar2rlen(n_cigar: ::std::os::raw::c_int, cigar: *const u32) -> hts_pos_t;
}
extern "C" {
    pub fn bam_endpos(b: *const bam1_t) -> hts_pos_t;
}
extern "C" {
    pub fn bam_str2flag(str: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bam_flag2str(flag: ::std::os::raw::c_int) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn bam_set_qname(
        b: *mut bam1_t,
        qname: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sam_idx_init(
        fp: *mut htsFile,
        h: *mut sam_hdr_t,
        min_shift: ::std::os::raw::c_int,
        fnidx: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sam_idx_save(fp: *mut htsFile) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sam_index_load(fp: *mut htsFile, fn_: *const ::std::os::raw::c_char) -> *mut hts_idx_t;
}
extern "C" {
    pub fn sam_index_load2(
        fp: *mut htsFile,
        fn_: *const ::std::os::raw::c_char,
        fnidx: *const ::std::os::raw::c_char,
    ) -> *mut hts_idx_t;
}
extern "C" {
    pub fn sam_index_load3(
        fp: *mut htsFile,
        fn_: *const ::std::os::raw::c_char,
        fnidx: *const ::std::os::raw::c_char,
        flags: ::std::os::raw::c_int,
    ) -> *mut hts_idx_t;
}
extern "C" {
    pub fn sam_index_build(
        fn_: *const ::std::os::raw::c_char,
        min_shift: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sam_index_build2(
        fn_: *const ::std::os::raw::c_char,
        fnidx: *const ::std::os::raw::c_char,
        min_shift: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sam_index_build3(
        fn_: *const ::std::os::raw::c_char,
        fnidx: *const ::std::os::raw::c_char,
        min_shift: ::std::os::raw::c_int,
        nthreads: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sam_itr_queryi(
        idx: *const hts_idx_t,
        tid: ::std::os::raw::c_int,
        beg: hts_pos_t,
        end: hts_pos_t,
    ) -> *mut hts_itr_t;
}
extern "C" {
    pub fn sam_itr_querys(
        idx: *const hts_idx_t,
        hdr: *mut sam_hdr_t,
        region: *const ::std::os::raw::c_char,
    ) -> *mut hts_itr_t;
}
extern "C" {
    pub fn sam_itr_regions(
        idx: *const hts_idx_t,
        hdr: *mut sam_hdr_t,
        reglist: *mut hts_reglist_t,
        regcount: ::std::os::raw::c_uint,
    ) -> *mut hts_itr_t;
}
extern "C" {
    pub fn sam_itr_regarray(
        idx: *const hts_idx_t,
        hdr: *mut sam_hdr_t,
        regarray: *mut *mut ::std::os::raw::c_char,
        regcount: ::std::os::raw::c_uint,
    ) -> *mut hts_itr_t;
}
extern "C" {
    pub fn sam_parse_region(
        h: *mut sam_hdr_t,
        s: *const ::std::os::raw::c_char,
        tid: *mut ::std::os::raw::c_int,
        beg: *mut hts_pos_t,
        end: *mut hts_pos_t,
        flags: ::std::os::raw::c_int,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn sam_open_mode(
        mode: *mut ::std::os::raw::c_char,
        fn_: *const ::std::os::raw::c_char,
        format: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sam_open_mode_opts(
        fn_: *const ::std::os::raw::c_char,
        mode: *const ::std::os::raw::c_char,
        format: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn sam_hdr_change_HD(
        h: *mut sam_hdr_t,
        key: *const ::std::os::raw::c_char,
        val: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sam_parse1(
        s: *mut kstring_t,
        h: *mut sam_hdr_t,
        b: *mut bam1_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sam_format1(
        h: *const sam_hdr_t,
        b: *const bam1_t,
        str: *mut kstring_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sam_read1(fp: *mut samFile, h: *mut sam_hdr_t, b: *mut bam1_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sam_write1(
        fp: *mut samFile,
        h: *const sam_hdr_t,
        b: *const bam1_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bam_aux_get(b: *const bam1_t, tag: *const ::std::os::raw::c_char) -> *mut u8;
}
extern "C" {
    pub fn bam_aux2i(s: *const u8) -> i64;
}
extern "C" {
    pub fn bam_aux2f(s: *const u8) -> f64;
}
extern "C" {
    pub fn bam_aux2A(s: *const u8) -> ::std::os::raw::c_char;
}
extern "C" {
    pub fn bam_aux2Z(s: *const u8) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn bam_auxB_len(s: *const u8) -> u32;
}
extern "C" {
    pub fn bam_auxB2i(s: *const u8, idx: u32) -> i64;
}
extern "C" {
    pub fn bam_auxB2f(s: *const u8, idx: u32) -> f64;
}
extern "C" {
    pub fn bam_aux_append(
        b: *mut bam1_t,
        tag: *const ::std::os::raw::c_char,
        type_: ::std::os::raw::c_char,
        len: ::std::os::raw::c_int,
        data: *const u8,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bam_aux_del(b: *mut bam1_t, s: *mut u8) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bam_aux_update_str(
        b: *mut bam1_t,
        tag: *const ::std::os::raw::c_char,
        len: ::std::os::raw::c_int,
        data: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bam_aux_update_int(
        b: *mut bam1_t,
        tag: *const ::std::os::raw::c_char,
        val: i64,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bam_aux_update_float(
        b: *mut bam1_t,
        tag: *const ::std::os::raw::c_char,
        val: f32,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bam_aux_update_array(
        b: *mut bam1_t,
        tag: *const ::std::os::raw::c_char,
        type_: u8,
        items: u32,
        data: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union bam_pileup_cd {
    pub p: *mut ::std::os::raw::c_void,
    pub i: i64,
    pub f: f64,
    _bindgen_union_align: u64,
}
#[test]
fn bindgen_test_layout_bam_pileup_cd() {
    assert_eq!(
        ::std::mem::size_of::<bam_pileup_cd>(),
        8usize,
        concat!("Size of: ", stringify!(bam_pileup_cd))
    );
    assert_eq!(
        ::std::mem::align_of::<bam_pileup_cd>(),
        8usize,
        concat!("Alignment of ", stringify!(bam_pileup_cd))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bam_pileup_cd>())).p as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bam_pileup_cd),
            "::",
            stringify!(p)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bam_pileup_cd>())).i as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bam_pileup_cd),
            "::",
            stringify!(i)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bam_pileup_cd>())).f as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bam_pileup_cd),
            "::",
            stringify!(f)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct bam_pileup1_t {
    pub b: *mut bam1_t,
    pub qpos: i32,
    pub indel: ::std::os::raw::c_int,
    pub level: ::std::os::raw::c_int,
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize], u32>,
    pub cd: bam_pileup_cd,
    pub cigar_ind: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_bam_pileup1_t() {
    assert_eq!(
        ::std::mem::size_of::<bam_pileup1_t>(),
        40usize,
        concat!("Size of: ", stringify!(bam_pileup1_t))
    );
    assert_eq!(
        ::std::mem::align_of::<bam_pileup1_t>(),
        8usize,
        concat!("Alignment of ", stringify!(bam_pileup1_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bam_pileup1_t>())).b as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bam_pileup1_t),
            "::",
            stringify!(b)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bam_pileup1_t>())).qpos as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(bam_pileup1_t),
            "::",
            stringify!(qpos)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bam_pileup1_t>())).indel as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(bam_pileup1_t),
            "::",
            stringify!(indel)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bam_pileup1_t>())).level as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(bam_pileup1_t),
            "::",
            stringify!(level)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bam_pileup1_t>())).cd as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(bam_pileup1_t),
            "::",
            stringify!(cd)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bam_pileup1_t>())).cigar_ind as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(bam_pileup1_t),
            "::",
            stringify!(cigar_ind)
        )
    );
}
impl bam_pileup1_t {
    #[inline]
    pub fn is_del(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_is_del(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn is_head(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_is_head(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn is_tail(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_is_tail(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn is_refskip(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_is_refskip(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn aux(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(5usize, 27u8) as u32) }
    }
    #[inline]
    pub fn set_aux(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(5usize, 27u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        is_del: u32,
        is_head: u32,
        is_tail: u32,
        is_refskip: u32,
        aux: u32,
    ) -> __BindgenBitfieldUnit<[u8; 4usize], u32> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize], u32> =
            Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let is_del: u32 = unsafe { ::std::mem::transmute(is_del) };
            is_del as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let is_head: u32 = unsafe { ::std::mem::transmute(is_head) };
            is_head as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let is_tail: u32 = unsafe { ::std::mem::transmute(is_tail) };
            is_tail as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let is_refskip: u32 = unsafe { ::std::mem::transmute(is_refskip) };
            is_refskip as u64
        });
        __bindgen_bitfield_unit.set(5usize, 27u8, {
            let aux: u32 = unsafe { ::std::mem::transmute(aux) };
            aux as u64
        });
        __bindgen_bitfield_unit
    }
}
pub type bam_plp_auto_f = ::std::option::Option<
    unsafe extern "C" fn(
        data: *mut ::std::os::raw::c_void,
        b: *mut bam1_t,
    ) -> ::std::os::raw::c_int,
>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __bam_plp_t {
    _unused: [u8; 0],
}
pub type bam_plp_t = *mut __bam_plp_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __bam_mplp_t {
    _unused: [u8; 0],
}
pub type bam_mplp_t = *mut __bam_mplp_t;
extern "C" {
    pub fn bam_plp_init(func: bam_plp_auto_f, data: *mut ::std::os::raw::c_void) -> bam_plp_t;
}
extern "C" {
    pub fn bam_plp_destroy(iter: bam_plp_t);
}
extern "C" {
    pub fn bam_plp_push(iter: bam_plp_t, b: *const bam1_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bam_plp_next(
        iter: bam_plp_t,
        _tid: *mut ::std::os::raw::c_int,
        _pos: *mut ::std::os::raw::c_int,
        _n_plp: *mut ::std::os::raw::c_int,
    ) -> *const bam_pileup1_t;
}
extern "C" {
    pub fn bam_plp_auto(
        iter: bam_plp_t,
        _tid: *mut ::std::os::raw::c_int,
        _pos: *mut ::std::os::raw::c_int,
        _n_plp: *mut ::std::os::raw::c_int,
    ) -> *const bam_pileup1_t;
}
extern "C" {
    pub fn bam_plp64_next(
        iter: bam_plp_t,
        _tid: *mut ::std::os::raw::c_int,
        _pos: *mut hts_pos_t,
        _n_plp: *mut ::std::os::raw::c_int,
    ) -> *const bam_pileup1_t;
}
extern "C" {
    pub fn bam_plp64_auto(
        iter: bam_plp_t,
        _tid: *mut ::std::os::raw::c_int,
        _pos: *mut hts_pos_t,
        _n_plp: *mut ::std::os::raw::c_int,
    ) -> *const bam_pileup1_t;
}
extern "C" {
    pub fn bam_plp_set_maxcnt(iter: bam_plp_t, maxcnt: ::std::os::raw::c_int);
}
extern "C" {
    pub fn bam_plp_reset(iter: bam_plp_t);
}
extern "C" {
    pub fn bam_plp_constructor(
        plp: bam_plp_t,
        func: ::std::option::Option<
            unsafe extern "C" fn(
                data: *mut ::std::os::raw::c_void,
                b: *const bam1_t,
                cd: *mut bam_pileup_cd,
            ) -> ::std::os::raw::c_int,
        >,
    );
}
extern "C" {
    pub fn bam_plp_destructor(
        plp: bam_plp_t,
        func: ::std::option::Option<
            unsafe extern "C" fn(
                data: *mut ::std::os::raw::c_void,
                b: *const bam1_t,
                cd: *mut bam_pileup_cd,
            ) -> ::std::os::raw::c_int,
        >,
    );
}
extern "C" {
    pub fn bam_plp_insertion(
        p: *const bam_pileup1_t,
        ins: *mut kstring_t,
        del_len: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bam_mplp_init(
        n: ::std::os::raw::c_int,
        func: bam_plp_auto_f,
        data: *mut *mut ::std::os::raw::c_void,
    ) -> bam_mplp_t;
}
extern "C" {
    pub fn bam_mplp_init_overlaps(iter: bam_mplp_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bam_mplp_destroy(iter: bam_mplp_t);
}
extern "C" {
    pub fn bam_mplp_set_maxcnt(iter: bam_mplp_t, maxcnt: ::std::os::raw::c_int);
}
extern "C" {
    pub fn bam_mplp_auto(
        iter: bam_mplp_t,
        _tid: *mut ::std::os::raw::c_int,
        _pos: *mut ::std::os::raw::c_int,
        n_plp: *mut ::std::os::raw::c_int,
        plp: *mut *const bam_pileup1_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bam_mplp64_auto(
        iter: bam_mplp_t,
        _tid: *mut ::std::os::raw::c_int,
        _pos: *mut hts_pos_t,
        n_plp: *mut ::std::os::raw::c_int,
        plp: *mut *const bam_pileup1_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bam_mplp_reset(iter: bam_mplp_t);
}
extern "C" {
    pub fn bam_mplp_constructor(
        iter: bam_mplp_t,
        func: ::std::option::Option<
            unsafe extern "C" fn(
                data: *mut ::std::os::raw::c_void,
                b: *const bam1_t,
                cd: *mut bam_pileup_cd,
            ) -> ::std::os::raw::c_int,
        >,
    );
}
extern "C" {
    pub fn bam_mplp_destructor(
        iter: bam_mplp_t,
        func: ::std::option::Option<
            unsafe extern "C" fn(
                data: *mut ::std::os::raw::c_void,
                b: *const bam1_t,
                cd: *mut bam_pileup_cd,
            ) -> ::std::os::raw::c_int,
        >,
    );
}
extern "C" {
    pub fn sam_cap_mapq(
        b: *mut bam1_t,
        ref_: *const ::std::os::raw::c_char,
        ref_len: hts_pos_t,
        thres: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sam_prob_realn(
        b: *mut bam1_t,
        ref_: *const ::std::os::raw::c_char,
        ref_len: hts_pos_t,
        flag: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
pub const cram_block_method_BM_ERROR: cram_block_method = -1;
pub const cram_block_method_RAW: cram_block_method = 0;
pub const cram_block_method_GZIP: cram_block_method = 1;
pub const cram_block_method_BZIP2: cram_block_method = 2;
pub const cram_block_method_LZMA: cram_block_method = 3;
pub const cram_block_method_RANS: cram_block_method = 4;
pub const cram_block_method_RANS0: cram_block_method = 4;
pub const cram_block_method_RANS1: cram_block_method = 10;
pub const cram_block_method_GZIP_RLE: cram_block_method = 11;
pub type cram_block_method = i32;
pub const cram_content_type_CT_ERROR: cram_content_type = -1;
pub const cram_content_type_FILE_HEADER: cram_content_type = 0;
pub const cram_content_type_COMPRESSION_HEADER: cram_content_type = 1;
pub const cram_content_type_MAPPED_SLICE: cram_content_type = 2;
pub const cram_content_type_UNMAPPED_SLICE: cram_content_type = 3;
pub const cram_content_type_EXTERNAL: cram_content_type = 4;
pub const cram_content_type_CORE: cram_content_type = 5;
pub type cram_content_type = i32;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cram_file_def {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cram_container {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cram_block {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cram_slice {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cram_metrics {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cram_block_slice_hdr {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cram_block_compression_hdr {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct refs_t {
    _unused: [u8; 0],
}
extern "C" {
    pub fn cram_fd_get_header(fd: *mut cram_fd) -> *mut sam_hdr_t;
}
extern "C" {
    pub fn cram_fd_set_header(fd: *mut cram_fd, hdr: *mut sam_hdr_t);
}
extern "C" {
    pub fn cram_fd_get_version(fd: *mut cram_fd) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn cram_fd_set_version(fd: *mut cram_fd, vers: ::std::os::raw::c_int);
}
extern "C" {
    pub fn cram_major_vers(fd: *mut cram_fd) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn cram_minor_vers(fd: *mut cram_fd) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn cram_fd_get_fp(fd: *mut cram_fd) -> *mut hFILE;
}
extern "C" {
    pub fn cram_fd_set_fp(fd: *mut cram_fd, fp: *mut hFILE);
}
extern "C" {
    pub fn cram_container_get_length(c: *mut cram_container) -> i32;
}
extern "C" {
    pub fn cram_container_set_length(c: *mut cram_container, length: i32);
}
extern "C" {
    pub fn cram_container_get_num_blocks(c: *mut cram_container) -> i32;
}
extern "C" {
    pub fn cram_container_set_num_blocks(c: *mut cram_container, num_blocks: i32);
}
extern "C" {
    pub fn cram_container_get_landmarks(
        c: *mut cram_container,
        num_landmarks: *mut i32,
    ) -> *mut i32;
}
extern "C" {
    pub fn cram_container_set_landmarks(
        c: *mut cram_container,
        num_landmarks: i32,
        landmarks: *mut i32,
    );
}
extern "C" {
    pub fn cram_container_is_empty(fd: *mut cram_fd) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn cram_block_get_content_id(b: *mut cram_block) -> i32;
}
extern "C" {
    pub fn cram_block_get_comp_size(b: *mut cram_block) -> i32;
}
extern "C" {
    pub fn cram_block_get_uncomp_size(b: *mut cram_block) -> i32;
}
extern "C" {
    pub fn cram_block_get_crc32(b: *mut cram_block) -> i32;
}
extern "C" {
    pub fn cram_block_get_data(b: *mut cram_block) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn cram_block_get_content_type(b: *mut cram_block) -> cram_content_type;
}
extern "C" {
    pub fn cram_block_set_content_id(b: *mut cram_block, id: i32);
}
extern "C" {
    pub fn cram_block_set_comp_size(b: *mut cram_block, size: i32);
}
extern "C" {
    pub fn cram_block_set_uncomp_size(b: *mut cram_block, size: i32);
}
extern "C" {
    pub fn cram_block_set_crc32(b: *mut cram_block, crc: i32);
}
extern "C" {
    pub fn cram_block_set_data(b: *mut cram_block, data: *mut ::std::os::raw::c_void);
}
extern "C" {
    pub fn cram_block_append(
        b: *mut cram_block,
        data: *const ::std::os::raw::c_void,
        size: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn cram_block_update_size(b: *mut cram_block);
}
extern "C" {
    pub fn cram_block_get_offset(b: *mut cram_block) -> size_t;
}
extern "C" {
    pub fn cram_block_set_offset(b: *mut cram_block, offset: size_t);
}
extern "C" {
    pub fn cram_block_size(b: *mut cram_block) -> u32;
}
extern "C" {
    pub fn cram_transcode_rg(
        in_: *mut cram_fd,
        out: *mut cram_fd,
        c: *mut cram_container,
        nrg: ::std::os::raw::c_int,
        in_rg: *mut ::std::os::raw::c_int,
        out_rg: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn cram_copy_slice(
        in_: *mut cram_fd,
        out: *mut cram_fd,
        num_slice: i32,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn cram_new_block(
        content_type: cram_content_type,
        content_id: ::std::os::raw::c_int,
    ) -> *mut cram_block;
}
extern "C" {
    pub fn cram_read_block(fd: *mut cram_fd) -> *mut cram_block;
}
extern "C" {
    pub fn cram_write_block(fd: *mut cram_fd, b: *mut cram_block) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn cram_free_block(b: *mut cram_block);
}
extern "C" {
    pub fn cram_uncompress_block(b: *mut cram_block) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn cram_compress_block(
        fd: *mut cram_fd,
        b: *mut cram_block,
        metrics: *mut cram_metrics,
        method: ::std::os::raw::c_int,
        level: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn cram_new_container(
        nrec: ::std::os::raw::c_int,
        nslice: ::std::os::raw::c_int,
    ) -> *mut cram_container;
}
extern "C" {
    pub fn cram_free_container(c: *mut cram_container);
}
extern "C" {
    pub fn cram_read_container(fd: *mut cram_fd) -> *mut cram_container;
}
extern "C" {
    pub fn cram_write_container(fd: *mut cram_fd, h: *mut cram_container) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn cram_store_container(
        fd: *mut cram_fd,
        c: *mut cram_container,
        dat: *mut ::std::os::raw::c_char,
        size: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn cram_container_size(c: *mut cram_container) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn cram_open(
        filename: *const ::std::os::raw::c_char,
        mode: *const ::std::os::raw::c_char,
    ) -> *mut cram_fd;
}
extern "C" {
    pub fn cram_dopen(
        fp: *mut hFILE,
        filename: *const ::std::os::raw::c_char,
        mode: *const ::std::os::raw::c_char,
    ) -> *mut cram_fd;
}
extern "C" {
    pub fn cram_close(fd: *mut cram_fd) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn cram_seek(
        fd: *mut cram_fd,
        offset: off_t,
        whence: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn cram_flush(fd: *mut cram_fd) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn cram_eof(fd: *mut cram_fd) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn cram_set_option(fd: *mut cram_fd, opt: hts_fmt_option, ...) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn cram_set_voption(
        fd: *mut cram_fd,
        opt: hts_fmt_option,
        args: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn cram_set_header(fd: *mut cram_fd, hdr: *mut sam_hdr_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn cram_check_EOF(fd: *mut cram_fd) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn int32_put_blk(b: *mut cram_block, val: i32) -> ::std::os::raw::c_int;
}
pub type SAM_hdr = sam_hdr_t;
extern "C" {
    pub fn cram_get_refs(fd: *mut htsFile) -> *mut refs_t;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct bgzf_mtaux_t {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __bgzidx_t {
    _unused: [u8; 0],
}
pub type bgzidx_t = __bgzidx_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct bgzf_cache_t {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct z_stream_s {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct BGZF {
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize], u16>,
    pub cache_size: ::std::os::raw::c_int,
    pub block_length: ::std::os::raw::c_int,
    pub block_clength: ::std::os::raw::c_int,
    pub block_offset: ::std::os::raw::c_int,
    pub block_address: i64,
    pub uncompressed_address: i64,
    pub uncompressed_block: *mut ::std::os::raw::c_void,
    pub compressed_block: *mut ::std::os::raw::c_void,
    pub cache: *mut bgzf_cache_t,
    pub fp: *mut hFILE,
    pub mt: *mut bgzf_mtaux_t,
    pub idx: *mut bgzidx_t,
    pub idx_build_otf: ::std::os::raw::c_int,
    pub gz_stream: *mut z_stream_s,
    pub seeked: i64,
}
#[test]
fn bindgen_test_layout_BGZF() {
    assert_eq!(
        ::std::mem::size_of::<BGZF>(),
        112usize,
        concat!("Size of: ", stringify!(BGZF))
    );
    assert_eq!(
        ::std::mem::align_of::<BGZF>(),
        8usize,
        concat!("Alignment of ", stringify!(BGZF))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<BGZF>())).cache_size as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(BGZF),
            "::",
            stringify!(cache_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<BGZF>())).block_length as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(BGZF),
            "::",
            stringify!(block_length)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<BGZF>())).block_clength as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(BGZF),
            "::",
            stringify!(block_clength)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<BGZF>())).block_offset as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(BGZF),
            "::",
            stringify!(block_offset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<BGZF>())).block_address as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(BGZF),
            "::",
            stringify!(block_address)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<BGZF>())).uncompressed_address as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(BGZF),
            "::",
            stringify!(uncompressed_address)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<BGZF>())).uncompressed_block as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(BGZF),
            "::",
            stringify!(uncompressed_block)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<BGZF>())).compressed_block as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(BGZF),
            "::",
            stringify!(compressed_block)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<BGZF>())).cache as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(BGZF),
            "::",
            stringify!(cache)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<BGZF>())).fp as *const _ as usize },
        64usize,
        concat!("Offset of field: ", stringify!(BGZF), "::", stringify!(fp))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<BGZF>())).mt as *const _ as usize },
        72usize,
        concat!("Offset of field: ", stringify!(BGZF), "::", stringify!(mt))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<BGZF>())).idx as *const _ as usize },
        80usize,
        concat!("Offset of field: ", stringify!(BGZF), "::", stringify!(idx))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<BGZF>())).idx_build_otf as *const _ as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(BGZF),
            "::",
            stringify!(idx_build_otf)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<BGZF>())).gz_stream as *const _ as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(BGZF),
            "::",
            stringify!(gz_stream)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<BGZF>())).seeked as *const _ as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(BGZF),
            "::",
            stringify!(seeked)
        )
    );
}
impl BGZF {
    #[inline]
    pub fn errcode(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 16u8) as u32) }
    }
    #[inline]
    pub fn set_errcode(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 16u8, val as u64)
        }
    }
    #[inline]
    pub fn reserved(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(16usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_reserved(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(16usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn is_write(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(17usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_is_write(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(17usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn no_eof_block(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(18usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_no_eof_block(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(18usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn is_be(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(19usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_is_be(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(19usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn compress_level(&self) -> ::std::os::raw::c_int {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(20usize, 9u8) as u32) }
    }
    #[inline]
    pub fn set_compress_level(&mut self, val: ::std::os::raw::c_int) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(20usize, 9u8, val as u64)
        }
    }
    #[inline]
    pub fn last_block_eof(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(29usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_last_block_eof(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(29usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn is_compressed(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(30usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_is_compressed(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(30usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn is_gzip(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(31usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_is_gzip(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(31usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        errcode: ::std::os::raw::c_uint,
        reserved: ::std::os::raw::c_uint,
        is_write: ::std::os::raw::c_uint,
        no_eof_block: ::std::os::raw::c_uint,
        is_be: ::std::os::raw::c_uint,
        compress_level: ::std::os::raw::c_int,
        last_block_eof: ::std::os::raw::c_uint,
        is_compressed: ::std::os::raw::c_uint,
        is_gzip: ::std::os::raw::c_uint,
    ) -> __BindgenBitfieldUnit<[u8; 4usize], u16> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize], u16> =
            Default::default();
        __bindgen_bitfield_unit.set(0usize, 16u8, {
            let errcode: u32 = unsafe { ::std::mem::transmute(errcode) };
            errcode as u64
        });
        __bindgen_bitfield_unit.set(16usize, 1u8, {
            let reserved: u32 = unsafe { ::std::mem::transmute(reserved) };
            reserved as u64
        });
        __bindgen_bitfield_unit.set(17usize, 1u8, {
            let is_write: u32 = unsafe { ::std::mem::transmute(is_write) };
            is_write as u64
        });
        __bindgen_bitfield_unit.set(18usize, 1u8, {
            let no_eof_block: u32 = unsafe { ::std::mem::transmute(no_eof_block) };
            no_eof_block as u64
        });
        __bindgen_bitfield_unit.set(19usize, 1u8, {
            let is_be: u32 = unsafe { ::std::mem::transmute(is_be) };
            is_be as u64
        });
        __bindgen_bitfield_unit.set(20usize, 9u8, {
            let compress_level: u32 = unsafe { ::std::mem::transmute(compress_level) };
            compress_level as u64
        });
        __bindgen_bitfield_unit.set(29usize, 1u8, {
            let last_block_eof: u32 = unsafe { ::std::mem::transmute(last_block_eof) };
            last_block_eof as u64
        });
        __bindgen_bitfield_unit.set(30usize, 1u8, {
            let is_compressed: u32 = unsafe { ::std::mem::transmute(is_compressed) };
            is_compressed as u64
        });
        __bindgen_bitfield_unit.set(31usize, 1u8, {
            let is_gzip: u32 = unsafe { ::std::mem::transmute(is_gzip) };
            is_gzip as u64
        });
        __bindgen_bitfield_unit
    }
}
extern "C" {
    pub fn bgzf_dopen(fd: ::std::os::raw::c_int, mode: *const ::std::os::raw::c_char) -> *mut BGZF;
}
extern "C" {
    pub fn bgzf_open(
        path: *const ::std::os::raw::c_char,
        mode: *const ::std::os::raw::c_char,
    ) -> *mut BGZF;
}
extern "C" {
    pub fn bgzf_hopen(fp: *mut hFILE, mode: *const ::std::os::raw::c_char) -> *mut BGZF;
}
extern "C" {
    pub fn bgzf_close(fp: *mut BGZF) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bgzf_read(fp: *mut BGZF, data: *mut ::std::os::raw::c_void, length: size_t) -> ssize_t;
}
extern "C" {
    pub fn bgzf_write(
        fp: *mut BGZF,
        data: *const ::std::os::raw::c_void,
        length: size_t,
    ) -> ssize_t;
}
extern "C" {
    pub fn bgzf_block_write(
        fp: *mut BGZF,
        data: *const ::std::os::raw::c_void,
        length: size_t,
    ) -> ssize_t;
}
extern "C" {
    pub fn bgzf_peek(fp: *mut BGZF) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bgzf_raw_read(
        fp: *mut BGZF,
        data: *mut ::std::os::raw::c_void,
        length: size_t,
    ) -> ssize_t;
}
extern "C" {
    pub fn bgzf_raw_write(
        fp: *mut BGZF,
        data: *const ::std::os::raw::c_void,
        length: size_t,
    ) -> ssize_t;
}
extern "C" {
    pub fn bgzf_flush(fp: *mut BGZF) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bgzf_seek(fp: *mut BGZF, pos: i64, whence: ::std::os::raw::c_int) -> i64;
}
extern "C" {
    pub fn bgzf_check_EOF(fp: *mut BGZF) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bgzf_compression(fp: *mut BGZF) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bgzf_is_bgzf(fn_: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bgzf_set_cache_size(fp: *mut BGZF, size: ::std::os::raw::c_int);
}
extern "C" {
    pub fn bgzf_flush_try(fp: *mut BGZF, size: ssize_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bgzf_getc(fp: *mut BGZF) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bgzf_getline(
        fp: *mut BGZF,
        delim: ::std::os::raw::c_int,
        str: *mut kstring_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bgzf_read_block(fp: *mut BGZF) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bgzf_thread_pool(
        fp: *mut BGZF,
        pool: *mut hts_tpool,
        qsize: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bgzf_mt(
        fp: *mut BGZF,
        n_threads: ::std::os::raw::c_int,
        n_sub_blks: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bgzf_compress(
        dst: *mut ::std::os::raw::c_void,
        dlen: *mut size_t,
        src: *const ::std::os::raw::c_void,
        slen: size_t,
        level: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bgzf_useek(
        fp: *mut BGZF,
        uoffset: off_t,
        where_: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bgzf_utell(fp: *mut BGZF) -> off_t;
}
extern "C" {
    pub fn bgzf_index_build_init(fp: *mut BGZF) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bgzf_index_load(
        fp: *mut BGZF,
        bname: *const ::std::os::raw::c_char,
        suffix: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bgzf_index_load_hfile(
        fp: *mut BGZF,
        idx: *mut hFILE,
        name: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bgzf_index_dump(
        fp: *mut BGZF,
        bname: *const ::std::os::raw::c_char,
        suffix: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bgzf_index_dump_hfile(
        fp: *mut BGZF,
        idx: *mut hFILE,
        name: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcf_trim_alleles(header: *const bcf_hdr_t, line: *mut bcf1_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcf_remove_alleles(
        header: *const bcf_hdr_t,
        line: *mut bcf1_t,
        mask: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcf_remove_allele_set(
        header: *const bcf_hdr_t,
        line: *mut bcf1_t,
        rm_set: *const kbitset_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcf_calc_ac(
        header: *const bcf_hdr_t,
        line: *mut bcf1_t,
        ac: *mut ::std::os::raw::c_int,
        which: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcf_gt_type(
        fmt_ptr: *mut bcf_fmt_t,
        isample: ::std::os::raw::c_int,
        ial: *mut ::std::os::raw::c_int,
        jal: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct tbx_conf_t {
    pub preset: i32,
    pub sc: i32,
    pub bc: i32,
    pub ec: i32,
    pub meta_char: i32,
    pub line_skip: i32,
}
#[test]
fn bindgen_test_layout_tbx_conf_t() {
    assert_eq!(
        ::std::mem::size_of::<tbx_conf_t>(),
        24usize,
        concat!("Size of: ", stringify!(tbx_conf_t))
    );
    assert_eq!(
        ::std::mem::align_of::<tbx_conf_t>(),
        4usize,
        concat!("Alignment of ", stringify!(tbx_conf_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<tbx_conf_t>())).preset as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(tbx_conf_t),
            "::",
            stringify!(preset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<tbx_conf_t>())).sc as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(tbx_conf_t),
            "::",
            stringify!(sc)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<tbx_conf_t>())).bc as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(tbx_conf_t),
            "::",
            stringify!(bc)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<tbx_conf_t>())).ec as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(tbx_conf_t),
            "::",
            stringify!(ec)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<tbx_conf_t>())).meta_char as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(tbx_conf_t),
            "::",
            stringify!(meta_char)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<tbx_conf_t>())).line_skip as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(tbx_conf_t),
            "::",
            stringify!(line_skip)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct tbx_t {
    pub conf: tbx_conf_t,
    pub idx: *mut hts_idx_t,
    pub dict: *mut ::std::os::raw::c_void,
}
#[test]
fn bindgen_test_layout_tbx_t() {
    assert_eq!(
        ::std::mem::size_of::<tbx_t>(),
        40usize,
        concat!("Size of: ", stringify!(tbx_t))
    );
    assert_eq!(
        ::std::mem::align_of::<tbx_t>(),
        8usize,
        concat!("Alignment of ", stringify!(tbx_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<tbx_t>())).conf as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(tbx_t),
            "::",
            stringify!(conf)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<tbx_t>())).idx as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(tbx_t),
            "::",
            stringify!(idx)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<tbx_t>())).dict as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(tbx_t),
            "::",
            stringify!(dict)
        )
    );
}
extern "C" {
    pub static tbx_conf_gff: tbx_conf_t;
}
extern "C" {
    pub static tbx_conf_bed: tbx_conf_t;
}
extern "C" {
    pub static tbx_conf_psltbl: tbx_conf_t;
}
extern "C" {
    pub static tbx_conf_sam: tbx_conf_t;
}
extern "C" {
    pub static tbx_conf_vcf: tbx_conf_t;
}
extern "C" {
    pub fn tbx_name2id(tbx: *mut tbx_t, ss: *const ::std::os::raw::c_char)
        -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn hts_get_bgzfp(fp: *mut htsFile) -> *mut BGZF;
}
extern "C" {
    pub fn tbx_readrec(
        fp: *mut BGZF,
        tbxv: *mut ::std::os::raw::c_void,
        sv: *mut ::std::os::raw::c_void,
        tid: *mut ::std::os::raw::c_int,
        beg: *mut hts_pos_t,
        end: *mut hts_pos_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn tbx_index(
        fp: *mut BGZF,
        min_shift: ::std::os::raw::c_int,
        conf: *const tbx_conf_t,
    ) -> *mut tbx_t;
}
extern "C" {
    pub fn tbx_index_build(
        fn_: *const ::std::os::raw::c_char,
        min_shift: ::std::os::raw::c_int,
        conf: *const tbx_conf_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn tbx_index_build2(
        fn_: *const ::std::os::raw::c_char,
        fnidx: *const ::std::os::raw::c_char,
        min_shift: ::std::os::raw::c_int,
        conf: *const tbx_conf_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn tbx_index_build3(
        fn_: *const ::std::os::raw::c_char,
        fnidx: *const ::std::os::raw::c_char,
        min_shift: ::std::os::raw::c_int,
        n_threads: ::std::os::raw::c_int,
        conf: *const tbx_conf_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn tbx_index_load(fn_: *const ::std::os::raw::c_char) -> *mut tbx_t;
}
extern "C" {
    pub fn tbx_index_load2(
        fn_: *const ::std::os::raw::c_char,
        fnidx: *const ::std::os::raw::c_char,
    ) -> *mut tbx_t;
}
extern "C" {
    pub fn tbx_index_load3(
        fn_: *const ::std::os::raw::c_char,
        fnidx: *const ::std::os::raw::c_char,
        flags: ::std::os::raw::c_int,
    ) -> *mut tbx_t;
}
extern "C" {
    pub fn tbx_seqnames(
        tbx: *mut tbx_t,
        n: *mut ::std::os::raw::c_int,
    ) -> *mut *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn tbx_destroy(tbx: *mut tbx_t);
}
pub const bcf_sr_opt_t_BCF_SR_REQUIRE_IDX: bcf_sr_opt_t = 0;
pub const bcf_sr_opt_t_BCF_SR_PAIR_LOGIC: bcf_sr_opt_t = 1;
pub type bcf_sr_opt_t = u32;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _bcf_sr_regions_t {
    pub tbx: *mut tbx_t,
    pub itr: *mut hts_itr_t,
    pub line: kstring_t,
    pub file: *mut htsFile,
    pub fname: *mut ::std::os::raw::c_char,
    pub is_bin: ::std::os::raw::c_int,
    pub als: *mut *mut ::std::os::raw::c_char,
    pub als_str: kstring_t,
    pub nals: ::std::os::raw::c_int,
    pub mals: ::std::os::raw::c_int,
    pub als_type: ::std::os::raw::c_int,
    pub missed_reg_handler: ::std::option::Option<
        unsafe extern "C" fn(arg1: *mut _bcf_sr_regions_t, arg2: *mut ::std::os::raw::c_void),
    >,
    pub missed_reg_data: *mut ::std::os::raw::c_void,
    pub regs: *mut _region_t,
    pub seq_hash: *mut ::std::os::raw::c_void,
    pub seq_names: *mut *mut ::std::os::raw::c_char,
    pub nseqs: ::std::os::raw::c_int,
    pub iseq: ::std::os::raw::c_int,
    pub start: hts_pos_t,
    pub end: hts_pos_t,
    pub prev_seq: ::std::os::raw::c_int,
    pub prev_start: hts_pos_t,
    pub prev_end: hts_pos_t,
}
#[test]
fn bindgen_test_layout__bcf_sr_regions_t() {
    assert_eq!(
        ::std::mem::size_of::<_bcf_sr_regions_t>(),
        200usize,
        concat!("Size of: ", stringify!(_bcf_sr_regions_t))
    );
    assert_eq!(
        ::std::mem::align_of::<_bcf_sr_regions_t>(),
        8usize,
        concat!("Alignment of ", stringify!(_bcf_sr_regions_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_bcf_sr_regions_t>())).tbx as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_bcf_sr_regions_t),
            "::",
            stringify!(tbx)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_bcf_sr_regions_t>())).itr as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_bcf_sr_regions_t),
            "::",
            stringify!(itr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_bcf_sr_regions_t>())).line as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_bcf_sr_regions_t),
            "::",
            stringify!(line)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_bcf_sr_regions_t>())).file as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(_bcf_sr_regions_t),
            "::",
            stringify!(file)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_bcf_sr_regions_t>())).fname as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(_bcf_sr_regions_t),
            "::",
            stringify!(fname)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_bcf_sr_regions_t>())).is_bin as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(_bcf_sr_regions_t),
            "::",
            stringify!(is_bin)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_bcf_sr_regions_t>())).als as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(_bcf_sr_regions_t),
            "::",
            stringify!(als)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_bcf_sr_regions_t>())).als_str as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(_bcf_sr_regions_t),
            "::",
            stringify!(als_str)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_bcf_sr_regions_t>())).nals as *const _ as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(_bcf_sr_regions_t),
            "::",
            stringify!(nals)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_bcf_sr_regions_t>())).mals as *const _ as usize },
        100usize,
        concat!(
            "Offset of field: ",
            stringify!(_bcf_sr_regions_t),
            "::",
            stringify!(mals)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_bcf_sr_regions_t>())).als_type as *const _ as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(_bcf_sr_regions_t),
            "::",
            stringify!(als_type)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_bcf_sr_regions_t>())).missed_reg_handler as *const _ as usize
        },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(_bcf_sr_regions_t),
            "::",
            stringify!(missed_reg_handler)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_bcf_sr_regions_t>())).missed_reg_data as *const _ as usize
        },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(_bcf_sr_regions_t),
            "::",
            stringify!(missed_reg_data)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_bcf_sr_regions_t>())).regs as *const _ as usize },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(_bcf_sr_regions_t),
            "::",
            stringify!(regs)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_bcf_sr_regions_t>())).seq_hash as *const _ as usize },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(_bcf_sr_regions_t),
            "::",
            stringify!(seq_hash)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_bcf_sr_regions_t>())).seq_names as *const _ as usize },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(_bcf_sr_regions_t),
            "::",
            stringify!(seq_names)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_bcf_sr_regions_t>())).nseqs as *const _ as usize },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(_bcf_sr_regions_t),
            "::",
            stringify!(nseqs)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_bcf_sr_regions_t>())).iseq as *const _ as usize },
        156usize,
        concat!(
            "Offset of field: ",
            stringify!(_bcf_sr_regions_t),
            "::",
            stringify!(iseq)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_bcf_sr_regions_t>())).start as *const _ as usize },
        160usize,
        concat!(
            "Offset of field: ",
            stringify!(_bcf_sr_regions_t),
            "::",
            stringify!(start)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_bcf_sr_regions_t>())).end as *const _ as usize },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(_bcf_sr_regions_t),
            "::",
            stringify!(end)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_bcf_sr_regions_t>())).prev_seq as *const _ as usize },
        176usize,
        concat!(
            "Offset of field: ",
            stringify!(_bcf_sr_regions_t),
            "::",
            stringify!(prev_seq)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_bcf_sr_regions_t>())).prev_start as *const _ as usize },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(_bcf_sr_regions_t),
            "::",
            stringify!(prev_start)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_bcf_sr_regions_t>())).prev_end as *const _ as usize },
        192usize,
        concat!(
            "Offset of field: ",
            stringify!(_bcf_sr_regions_t),
            "::",
            stringify!(prev_end)
        )
    );
}
pub type bcf_sr_regions_t = _bcf_sr_regions_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct bcf_sr_t {
    pub file: *mut htsFile,
    pub tbx_idx: *mut tbx_t,
    pub bcf_idx: *mut hts_idx_t,
    pub header: *mut bcf_hdr_t,
    pub itr: *mut hts_itr_t,
    pub fname: *mut ::std::os::raw::c_char,
    pub buffer: *mut *mut bcf1_t,
    pub nbuffer: ::std::os::raw::c_int,
    pub mbuffer: ::std::os::raw::c_int,
    pub nfilter_ids: ::std::os::raw::c_int,
    pub filter_ids: *mut ::std::os::raw::c_int,
    pub samples: *mut ::std::os::raw::c_int,
    pub n_smpl: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_bcf_sr_t() {
    assert_eq!(
        ::std::mem::size_of::<bcf_sr_t>(),
        96usize,
        concat!("Size of: ", stringify!(bcf_sr_t))
    );
    assert_eq!(
        ::std::mem::align_of::<bcf_sr_t>(),
        8usize,
        concat!("Alignment of ", stringify!(bcf_sr_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_sr_t>())).file as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_sr_t),
            "::",
            stringify!(file)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_sr_t>())).tbx_idx as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_sr_t),
            "::",
            stringify!(tbx_idx)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_sr_t>())).bcf_idx as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_sr_t),
            "::",
            stringify!(bcf_idx)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_sr_t>())).header as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_sr_t),
            "::",
            stringify!(header)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_sr_t>())).itr as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_sr_t),
            "::",
            stringify!(itr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_sr_t>())).fname as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_sr_t),
            "::",
            stringify!(fname)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_sr_t>())).buffer as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_sr_t),
            "::",
            stringify!(buffer)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_sr_t>())).nbuffer as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_sr_t),
            "::",
            stringify!(nbuffer)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_sr_t>())).mbuffer as *const _ as usize },
        60usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_sr_t),
            "::",
            stringify!(mbuffer)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_sr_t>())).nfilter_ids as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_sr_t),
            "::",
            stringify!(nfilter_ids)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_sr_t>())).filter_ids as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_sr_t),
            "::",
            stringify!(filter_ids)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_sr_t>())).samples as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_sr_t),
            "::",
            stringify!(samples)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_sr_t>())).n_smpl as *const _ as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_sr_t),
            "::",
            stringify!(n_smpl)
        )
    );
}
pub const bcf_sr_error_open_failed: bcf_sr_error = 0;
pub const bcf_sr_error_not_bgzf: bcf_sr_error = 1;
pub const bcf_sr_error_idx_load_failed: bcf_sr_error = 2;
pub const bcf_sr_error_file_type_error: bcf_sr_error = 3;
pub const bcf_sr_error_api_usage_error: bcf_sr_error = 4;
pub const bcf_sr_error_header_error: bcf_sr_error = 5;
pub const bcf_sr_error_no_eof: bcf_sr_error = 6;
pub const bcf_sr_error_no_memory: bcf_sr_error = 7;
pub const bcf_sr_error_vcf_parse_error: bcf_sr_error = 8;
pub const bcf_sr_error_bcf_read_error: bcf_sr_error = 9;
pub type bcf_sr_error = u32;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct bcf_srs_t {
    pub collapse: ::std::os::raw::c_int,
    pub apply_filters: *mut ::std::os::raw::c_char,
    pub require_index: ::std::os::raw::c_int,
    pub max_unpack: ::std::os::raw::c_int,
    pub has_line: *mut ::std::os::raw::c_int,
    pub errnum: bcf_sr_error,
    pub readers: *mut bcf_sr_t,
    pub nreaders: ::std::os::raw::c_int,
    pub streaming: ::std::os::raw::c_int,
    pub explicit_regs: ::std::os::raw::c_int,
    pub samples: *mut *mut ::std::os::raw::c_char,
    pub regions: *mut bcf_sr_regions_t,
    pub targets: *mut bcf_sr_regions_t,
    pub targets_als: ::std::os::raw::c_int,
    pub targets_exclude: ::std::os::raw::c_int,
    pub tmps: kstring_t,
    pub n_smpl: ::std::os::raw::c_int,
    pub n_threads: ::std::os::raw::c_int,
    pub p: *mut htsThreadPool,
    pub aux: *mut ::std::os::raw::c_void,
}
#[test]
fn bindgen_test_layout_bcf_srs_t() {
    assert_eq!(
        ::std::mem::size_of::<bcf_srs_t>(),
        144usize,
        concat!("Size of: ", stringify!(bcf_srs_t))
    );
    assert_eq!(
        ::std::mem::align_of::<bcf_srs_t>(),
        8usize,
        concat!("Alignment of ", stringify!(bcf_srs_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_srs_t>())).collapse as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_srs_t),
            "::",
            stringify!(collapse)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_srs_t>())).apply_filters as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_srs_t),
            "::",
            stringify!(apply_filters)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_srs_t>())).require_index as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_srs_t),
            "::",
            stringify!(require_index)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_srs_t>())).max_unpack as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_srs_t),
            "::",
            stringify!(max_unpack)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_srs_t>())).has_line as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_srs_t),
            "::",
            stringify!(has_line)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_srs_t>())).errnum as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_srs_t),
            "::",
            stringify!(errnum)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_srs_t>())).readers as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_srs_t),
            "::",
            stringify!(readers)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_srs_t>())).nreaders as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_srs_t),
            "::",
            stringify!(nreaders)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_srs_t>())).streaming as *const _ as usize },
        52usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_srs_t),
            "::",
            stringify!(streaming)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_srs_t>())).explicit_regs as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_srs_t),
            "::",
            stringify!(explicit_regs)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_srs_t>())).samples as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_srs_t),
            "::",
            stringify!(samples)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_srs_t>())).regions as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_srs_t),
            "::",
            stringify!(regions)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_srs_t>())).targets as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_srs_t),
            "::",
            stringify!(targets)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_srs_t>())).targets_als as *const _ as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_srs_t),
            "::",
            stringify!(targets_als)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_srs_t>())).targets_exclude as *const _ as usize },
        92usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_srs_t),
            "::",
            stringify!(targets_exclude)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_srs_t>())).tmps as *const _ as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_srs_t),
            "::",
            stringify!(tmps)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_srs_t>())).n_smpl as *const _ as usize },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_srs_t),
            "::",
            stringify!(n_smpl)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_srs_t>())).n_threads as *const _ as usize },
        124usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_srs_t),
            "::",
            stringify!(n_threads)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_srs_t>())).p as *const _ as usize },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_srs_t),
            "::",
            stringify!(p)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcf_srs_t>())).aux as *const _ as usize },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(bcf_srs_t),
            "::",
            stringify!(aux)
        )
    );
}
extern "C" {
    pub fn bcf_sr_init() -> *mut bcf_srs_t;
}
extern "C" {
    pub fn bcf_sr_destroy(readers: *mut bcf_srs_t);
}
extern "C" {
    pub fn bcf_sr_strerror(errnum: ::std::os::raw::c_int) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn bcf_sr_set_opt(readers: *mut bcf_srs_t, opt: bcf_sr_opt_t, ...)
        -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcf_sr_set_threads(
        files: *mut bcf_srs_t,
        n_threads: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcf_sr_destroy_threads(files: *mut bcf_srs_t);
}
extern "C" {
    pub fn bcf_sr_add_reader(
        readers: *mut bcf_srs_t,
        fname: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcf_sr_remove_reader(files: *mut bcf_srs_t, i: ::std::os::raw::c_int);
}
extern "C" {
    pub fn bcf_sr_next_line(readers: *mut bcf_srs_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcf_sr_seek(
        readers: *mut bcf_srs_t,
        seq: *const ::std::os::raw::c_char,
        pos: hts_pos_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcf_sr_set_samples(
        readers: *mut bcf_srs_t,
        samples: *const ::std::os::raw::c_char,
        is_file: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcf_sr_set_targets(
        readers: *mut bcf_srs_t,
        targets: *const ::std::os::raw::c_char,
        is_file: ::std::os::raw::c_int,
        alleles: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcf_sr_set_regions(
        readers: *mut bcf_srs_t,
        regions: *const ::std::os::raw::c_char,
        is_file: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcf_sr_regions_init(
        regions: *const ::std::os::raw::c_char,
        is_file: ::std::os::raw::c_int,
        chr: ::std::os::raw::c_int,
        from: ::std::os::raw::c_int,
        to: ::std::os::raw::c_int,
    ) -> *mut bcf_sr_regions_t;
}
extern "C" {
    pub fn bcf_sr_regions_destroy(regions: *mut bcf_sr_regions_t);
}
extern "C" {
    pub fn bcf_sr_regions_seek(
        regions: *mut bcf_sr_regions_t,
        chr: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcf_sr_regions_next(reg: *mut bcf_sr_regions_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcf_sr_regions_overlap(
        reg: *mut bcf_sr_regions_t,
        seq: *const ::std::os::raw::c_char,
        start: hts_pos_t,
        end: hts_pos_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcf_sr_regions_flush(regs: *mut bcf_sr_regions_t) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct kbitset_t {
    pub n: size_t,
    pub n_max: size_t,
    pub b: [::std::os::raw::c_ulong; 1usize],
}
#[test]
fn bindgen_test_layout_kbitset_t() {
    assert_eq!(
        ::std::mem::size_of::<kbitset_t>(),
        24usize,
        concat!("Size of: ", stringify!(kbitset_t))
    );
    assert_eq!(
        ::std::mem::align_of::<kbitset_t>(),
        8usize,
        concat!("Alignment of ", stringify!(kbitset_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kbitset_t>())).n as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kbitset_t),
            "::",
            stringify!(n)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kbitset_t>())).n_max as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kbitset_t),
            "::",
            stringify!(n_max)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kbitset_t>())).b as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(kbitset_t),
            "::",
            stringify!(b)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct kbitset_iter_t {
    pub mask: ::std::os::raw::c_ulong,
    pub elt: size_t,
    pub i: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_kbitset_iter_t() {
    assert_eq!(
        ::std::mem::size_of::<kbitset_iter_t>(),
        24usize,
        concat!("Size of: ", stringify!(kbitset_iter_t))
    );
    assert_eq!(
        ::std::mem::align_of::<kbitset_iter_t>(),
        8usize,
        concat!("Alignment of ", stringify!(kbitset_iter_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kbitset_iter_t>())).mask as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kbitset_iter_t),
            "::",
            stringify!(mask)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kbitset_iter_t>())).elt as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kbitset_iter_t),
            "::",
            stringify!(elt)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kbitset_iter_t>())).i as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(kbitset_iter_t),
            "::",
            stringify!(i)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __faidx_t {
    _unused: [u8; 0],
}
pub type faidx_t = __faidx_t;
pub const fai_format_options_FAI_NONE: fai_format_options = 0;
pub const fai_format_options_FAI_FASTA: fai_format_options = 1;
pub const fai_format_options_FAI_FASTQ: fai_format_options = 2;
pub type fai_format_options = u32;
extern "C" {
    pub fn fai_build3(
        fn_: *const ::std::os::raw::c_char,
        fnfai: *const ::std::os::raw::c_char,
        fngzi: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fai_build(fn_: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fai_destroy(fai: *mut faidx_t);
}
pub const fai_load_options_FAI_CREATE: fai_load_options = 1;
pub type fai_load_options = u32;
extern "C" {
    pub fn fai_load3(
        fn_: *const ::std::os::raw::c_char,
        fnfai: *const ::std::os::raw::c_char,
        fngzi: *const ::std::os::raw::c_char,
        flags: ::std::os::raw::c_int,
    ) -> *mut faidx_t;
}
extern "C" {
    pub fn fai_load(fn_: *const ::std::os::raw::c_char) -> *mut faidx_t;
}
extern "C" {
    pub fn fai_load3_format(
        fn_: *const ::std::os::raw::c_char,
        fnfai: *const ::std::os::raw::c_char,
        fngzi: *const ::std::os::raw::c_char,
        flags: ::std::os::raw::c_int,
        format: fai_format_options,
    ) -> *mut faidx_t;
}
extern "C" {
    pub fn fai_load_format(
        fn_: *const ::std::os::raw::c_char,
        format: fai_format_options,
    ) -> *mut faidx_t;
}
extern "C" {
    pub fn fai_fetch(
        fai: *const faidx_t,
        reg: *const ::std::os::raw::c_char,
        len: *mut ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn fai_fetch64(
        fai: *const faidx_t,
        reg: *const ::std::os::raw::c_char,
        len: *mut hts_pos_t,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn fai_fetchqual(
        fai: *const faidx_t,
        reg: *const ::std::os::raw::c_char,
        len: *mut ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn fai_fetchqual64(
        fai: *const faidx_t,
        reg: *const ::std::os::raw::c_char,
        len: *mut hts_pos_t,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn faidx_fetch_nseq(fai: *const faidx_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn faidx_fetch_seq(
        fai: *const faidx_t,
        c_name: *const ::std::os::raw::c_char,
        p_beg_i: ::std::os::raw::c_int,
        p_end_i: ::std::os::raw::c_int,
        len: *mut ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn faidx_fetch_seq64(
        fai: *const faidx_t,
        c_name: *const ::std::os::raw::c_char,
        p_beg_i: hts_pos_t,
        p_end_i: hts_pos_t,
        len: *mut hts_pos_t,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn faidx_fetch_qual(
        fai: *const faidx_t,
        c_name: *const ::std::os::raw::c_char,
        p_beg_i: ::std::os::raw::c_int,
        p_end_i: ::std::os::raw::c_int,
        len: *mut ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn faidx_fetch_qual64(
        fai: *const faidx_t,
        c_name: *const ::std::os::raw::c_char,
        p_beg_i: hts_pos_t,
        p_end_i: hts_pos_t,
        len: *mut hts_pos_t,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn faidx_has_seq(
        fai: *const faidx_t,
        seq: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn faidx_nseq(fai: *const faidx_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn faidx_iseq(
        fai: *const faidx_t,
        i: ::std::os::raw::c_int,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn faidx_seq_len(
        fai: *const faidx_t,
        seq: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fai_parse_region(
        fai: *const faidx_t,
        s: *const ::std::os::raw::c_char,
        tid: *mut ::std::os::raw::c_int,
        beg: *mut hts_pos_t,
        end: *mut hts_pos_t,
        flags: ::std::os::raw::c_int,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn fai_set_cache_size(fai: *mut faidx_t, cache_size: ::std::os::raw::c_int);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hts_tpool_process {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hts_tpool_result {
    _unused: [u8; 0],
}
extern "C" {
    pub fn hts_tpool_init(n: ::std::os::raw::c_int) -> *mut hts_tpool;
}
extern "C" {
    pub fn hts_tpool_size(p: *mut hts_tpool) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn hts_tpool_dispatch(
        p: *mut hts_tpool,
        q: *mut hts_tpool_process,
        func: ::std::option::Option<
            unsafe extern "C" fn(arg: *mut ::std::os::raw::c_void) -> *mut ::std::os::raw::c_void,
        >,
        arg: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn hts_tpool_dispatch2(
        p: *mut hts_tpool,
        q: *mut hts_tpool_process,
        func: ::std::option::Option<
            unsafe extern "C" fn(arg: *mut ::std::os::raw::c_void) -> *mut ::std::os::raw::c_void,
        >,
        arg: *mut ::std::os::raw::c_void,
        nonblock: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn hts_tpool_dispatch3(
        p: *mut hts_tpool,
        q: *mut hts_tpool_process,
        exec_func: ::std::option::Option<
            unsafe extern "C" fn(arg: *mut ::std::os::raw::c_void) -> *mut ::std::os::raw::c_void,
        >,
        arg: *mut ::std::os::raw::c_void,
        job_cleanup: ::std::option::Option<unsafe extern "C" fn(arg: *mut ::std::os::raw::c_void)>,
        result_cleanup: ::std::option::Option<
            unsafe extern "C" fn(data: *mut ::std::os::raw::c_void),
        >,
        nonblock: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn hts_tpool_wake_dispatch(q: *mut hts_tpool_process);
}
extern "C" {
    pub fn hts_tpool_process_flush(q: *mut hts_tpool_process) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn hts_tpool_process_reset(
        q: *mut hts_tpool_process,
        free_results: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn hts_tpool_process_qsize(q: *mut hts_tpool_process) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn hts_tpool_destroy(p: *mut hts_tpool);
}
extern "C" {
    pub fn hts_tpool_kill(p: *mut hts_tpool);
}
extern "C" {
    pub fn hts_tpool_next_result(q: *mut hts_tpool_process) -> *mut hts_tpool_result;
}
extern "C" {
    pub fn hts_tpool_next_result_wait(q: *mut hts_tpool_process) -> *mut hts_tpool_result;
}
extern "C" {
    pub fn hts_tpool_delete_result(r: *mut hts_tpool_result, free_data: ::std::os::raw::c_int);
}
extern "C" {
    pub fn hts_tpool_result_data(r: *mut hts_tpool_result) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn hts_tpool_process_init(
        p: *mut hts_tpool,
        qsize: ::std::os::raw::c_int,
        in_only: ::std::os::raw::c_int,
    ) -> *mut hts_tpool_process;
}
extern "C" {
    pub fn hts_tpool_process_destroy(q: *mut hts_tpool_process);
}
extern "C" {
    pub fn hts_tpool_process_empty(q: *mut hts_tpool_process) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn hts_tpool_process_len(q: *mut hts_tpool_process) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn hts_tpool_process_sz(q: *mut hts_tpool_process) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn hts_tpool_process_shutdown(q: *mut hts_tpool_process);
}
extern "C" {
    pub fn hts_tpool_process_attach(p: *mut hts_tpool, q: *mut hts_tpool_process);
}
extern "C" {
    pub fn hts_tpool_process_detach(p: *mut hts_tpool, q: *mut hts_tpool_process);
}
extern "C" {
    pub fn hts_tpool_process_ref_incr(q: *mut hts_tpool_process);
}
extern "C" {
    pub fn hts_tpool_process_ref_decr(q: *mut hts_tpool_process);
}
extern "C" {
    #[link_name = "\u{1}wrap_kbs_init2"]
    pub fn kbs_init2(ni: size_t, fill: ::std::os::raw::c_int) -> *mut kbitset_t;
}
extern "C" {
    #[link_name = "\u{1}wrap_kbs_init"]
    pub fn kbs_init(ni: size_t) -> *mut kbitset_t;
}
extern "C" {
    #[link_name = "\u{1}wrap_kbs_insert"]
    pub fn kbs_insert(bs: *mut kbitset_t, i: ::std::os::raw::c_int);
}
extern "C" {
    #[link_name = "\u{1}wrap_kbs_destroy"]
    pub fn kbs_destroy(bs: *mut kbitset_t);
}
pub type __builtin_va_list = [__va_list_tag; 1usize];
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __va_list_tag {
    pub gp_offset: ::std::os::raw::c_uint,
    pub fp_offset: ::std::os::raw::c_uint,
    pub overflow_arg_area: *mut ::std::os::raw::c_void,
    pub reg_save_area: *mut ::std::os::raw::c_void,
}
#[test]
fn bindgen_test_layout___va_list_tag() {
    assert_eq!(
        ::std::mem::size_of::<__va_list_tag>(),
        24usize,
        concat!("Size of: ", stringify!(__va_list_tag))
    );
    assert_eq!(
        ::std::mem::align_of::<__va_list_tag>(),
        8usize,
        concat!("Alignment of ", stringify!(__va_list_tag))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__va_list_tag>())).gp_offset as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__va_list_tag),
            "::",
            stringify!(gp_offset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__va_list_tag>())).fp_offset as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(__va_list_tag),
            "::",
            stringify!(fp_offset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__va_list_tag>())).overflow_arg_area as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__va_list_tag),
            "::",
            stringify!(overflow_arg_area)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__va_list_tag>())).reg_save_area as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__va_list_tag),
            "::",
            stringify!(reg_save_area)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __locale_data {
    pub _address: u8,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _region_t {
    pub _address: u8,
}
