// Copyright 2014-2017 The html5ever Project Developers. See the
// COPYRIGHT file at the top-level directory of this distribution.
//
// Licensed under the Apache License, Version 2.0 <LICENSE-APACHE or
// http://www.apache.org/licenses/LICENSE-2.0> or the MIT license
// <LICENSE-MIT or http://opensource.org/licenses/MIT>, at your
// option. This file may not be copied, modified, or distributed
// except according to those terms.

#![doc = include_str!("../README.md")]
#![crate_type = "dylib"]
#![cfg_attr(test, deny(warnings))]
#![cfg_attr(docsrs, feature(doc_cfg))]
#![allow(unused_parens)]

#[macro_use]
mod macros;

/// Create a [`SmallCharSet`], with each space-separated number stored in the set.
///
/// [`SmallCharSet`]: struct.SmallCharSet.html
macro_rules! small_char_set ( ($($e:expr)+) => (
    $ crate ::util::smallcharset::SmallCharSet {
        bits: $( (1 << ($e as usize)) )|+
    }
));

mod util {
    pub mod buffer_queue;
    pub mod smallcharset;
    pub mod str;
}

mod tokenizer;

#[doc(inline)]
pub use tokenizer::*;
