// Copyright 2014-2017 The html5ever Project Developers. See the
// COPYRIGHT file at the top-level directory of this distribution.
//
// Licensed under the Apache License, Version 2.0 <LICENSE-APACHE or
// http://www.apache.org/licenses/LICENSE-2.0> or the MIT license
// <LICENSE-MIT or http://opensource.org/licenses/MIT>, at your
// option. This file may not be copied, modified, or distributed
// except according to those terms.

// Run a single benchmark once.  For use with profiling tools.

extern crate html5tokenizer;

use std::default::Default;
use std::io;

use html5tokenizer::{BufferQueue, Token, TokenSink, TokenSinkResult, Tokenizer};
use io::Read;

struct Sink(Vec<Token>);

impl TokenSink for Sink {
    type Handle = ();

    fn process_token(&mut self, token: Token, _line_number: u64) -> TokenSinkResult<()> {
        // Don't use the token, but make sure we don't get
        // optimized out entirely.
        self.0.push(token);
        TokenSinkResult::Continue
    }
}

fn main() {
    let mut chunk = Vec::new();
    io::stdin().read_to_end(&mut chunk).unwrap();
    let mut input = BufferQueue::new();
    input.push_back(std::str::from_utf8(&chunk).unwrap().to_string());

    let mut tok = Tokenizer::new(Sink(Vec::new()), Default::default());
    let _ = tok.feed(&mut input);
    assert!(input.is_empty());
    tok.end();
}
