# Rune

[![Continuous integration](https://github.com/hotg-ai/rune/actions/workflows/main.yml/badge.svg)](https://github.com/hotg-ai/rune/actions/workflows/main.yml)
![Total Downloads](https://img.shields.io/github/downloads/hotg-ai/rune/total.svg)

**[Nightly Release][nightly] | [API Docs][api-docs] | [Runefile Schema][schema]**

Rune is a technology for deploying TinyML applications.

To get started, check out [our developer website][dev].

To learn how to start contributing to the Rune project, check out
[our contributing guide][contributing].

## License

This project is licensed under either of

 * Apache License, Version 2.0, ([LICENSE-APACHE](LICENSE-APACHE.md) or
   http://www.apache.org/licenses/LICENSE-2.0)
 * MIT license ([LICENSE-MIT](LICENSE-MIT.md) or
   http://opensource.org/licenses/MIT)

at your option.

It is recommended to always use [cargo-crev][crev] to verify the
trustworthiness of each of your dependencies, including this one.

The intent of this crate is to be free of soundness bugs. The developers will
do their best to avoid them, and welcome help in analysing and fixing them.

### Contribution

Unless you explicitly state otherwise, any contribution intentionally
submitted for inclusion in the work by you, as defined in the Apache-2.0
license, shall be dual licensed as above, without any additional terms or
conditions.

[crev]: https://github.com/crev-dev/cargo-crev
[nightly]: https://github.com/hotg-ai/rune/releases/tag/nightly
[api-docs]: https://hotg-ai.github.io/rune/
[schema]: https://hotg-ai.github.io/rune/schema/schema.html
[rustup]: https://rustup.rs/
[whats-in-a-rune]: https://tinyverse.substack.com/p/whats-in-a-rune
[contributing]: CONTRIBUTING.md
[dev]: https://hotg.dev/docs/

