# File Locations

This page explains what files are generated by `hoard` and where they can be found.

In general, `hoard` uses the [`directories`](https://docs.rs/directories) library,
using the `config_dir` and the `data_dir` of the `ProjectDirs` struct.

## Config Directory

The configuration directory holds the configuration file (`config.toml`, `config.yaml`, or `config.yml`) as well as 
other local-only configuration data.

- Linux/BSD: `$XDG_CONFIG_HOME/hoard/` or `$HOME/.config/hoard/`
- macos: `$HOME/Library/Application Support/com.shadow53.hoard/`
- Windows: `%AppData%\shadow53\hoard\`

### Config File

The [configuration file](./config/index.md) (`config.toml`) contains the environment and hoard definitions, along
with all related configuration. Follow the link in the previous sentence for more about the
configuration file format. 

### UUID File

The UUID file (`uuid`) contains a unique identifier for the current system. This is used when performing
pre-operation checks. Files relating to this UUID are synchronized between machines using whatever
synchronization mechanism you use to synchronize hoards between machines, but **nowhere else**. This UUID
is *not* used to identify your machines to any service, only the `hoard` program.

## Hoard Data Directory

The hoard data directory contains all backed up hoard files, along with other files that should be
synchronized with the hoard files.

- Linux/BSD: `$XDG_DATA_HOME/hoard/` or `/home/$USER/.local/share/hoard/`
- macos: `$HOME/Library/Application Support/com.shadow53.hoard/`
- Windows: `%AppData%\shadow53\hoard\data\`

### Hoard Files

All files backed up by `hoard` are stored in the data directory, in a subdirectory called `hoards`.

The files are organized according to the names of the hoard and pile they are configured under.

As an example, consider the following real configuration:

```toml
[hoards.custom_fonts]
    "unix" = "/home/shadow53/.local/share/fonts"

[hoards.fish]
    [hoards.fish.confdir]
        "unix" = "/home/shadow53/.config/fish/conf.d"
    [hoards.fish.functions]
        "unix" = "/home/shadow53/.config/fish/functions"

[hoards.newsboat]
    "unix" = "/home/shadow53/.newsboat/config"

[hoards.qemu]
    [hoards.qemu.script]
        "unix" = "/home/shadow53/.bin/vm"
    [hoards.qemu.configs]
        "unix" = "/home/shadow53/.config/qemu"
```

These hoards/piles are stored in the following locations:

```ignore
$data_dir
├─ custom_fonts/
├─ fish
│   ├─ confdir/
│   └─ functions/
├─ newsboat/
└─ qemu/
    ├─ script
    └─ configs/
```

### History Files

There are currently two types of history-related files stored by `hoard`, both of which are used
in pre-operation consistency checks. All history-related files are stored in a subdirectory `history/{uuid}`
in the data directory, where `uuid` is the generated uuid of the current system.

- [Last Paths](./cli/checks.md#last-paths): a single file `last_paths.json`.
- [Operations](./cli/checks.md#remote-operations): date-stamped JSON files with details of which files were modified
  during a given operation and what the checksum was for each file.
