/*a Copyright

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

@file    reader.rs
@brief   Reader traits and types
 */

//a Documentation
/*!

# Reader module

This module provides common types for sources of data for reading markup languages.

A source of data for a reader provides streams of characters, the
position of which within a stream can be determined. Error messages
can by generated by the markup language reader referring to these
positions; a [Span] is a stretch of characters between two such
positions.

!*/

//a Imports
mod error;
mod span;
mod traits;

//a Exports
pub use error::{ReaderError, Result};
pub use span::Span;
pub use traits::{Character, Error, Position, Reader};
