use crate::utils::into_v16;
use lazy_static::lazy_static;
use std::collections::HashMap;

type Color = (u8, u8, u8);

lazy_static! {
    pub static ref COLORS: HashMap<Vec<u16>, Color> = {
        let mut result = HashMap::new();

        result.insert(into_v16("red"), (192, 32, 32));
        result.insert(into_v16("orange"), (255, 165, 0));
        result.insert(into_v16("aqua"), (64, 192, 192));
        result.insert(into_v16("green"), (32, 192, 32));
        result.insert(into_v16("blue"), (32, 128, 255));
        result.insert(into_v16("lime"), (0, 255, 0));
        result.insert(into_v16("yellow"), (192, 192, 32));
        result.insert(into_v16("violet"), (187, 134, 252));
        result.insert(into_v16("white"), (255, 255, 255));

        result
    };

    pub static ref COLOR_NAMES: Vec<Vec<u16>> = COLORS.keys().map(|k| k.to_vec()).collect();
}