use std::collections::HashMap;
use crate::utils::into_v16;
use crate::consts::*;


// this file is auto-generated by a Python file!
pub fn data() -> HashMap<Vec<u16>, Vec<u16>> {

    let mut result = HashMap::with_capacity(100);

    // ^

    result
}


fn format_xmlns() -> Vec<u16> {
    vec![]
}


fn format_size(n: usize) -> Vec<u16> {
    into_v16(&format!("width=\"{}\" height=\"{}\"", n, n))
}


fn format_color(r: u8, g: u8, b: u8) -> Vec<u16> {
    into_v16(&format!("fill=\"rgb({}, {}, {})\"", r, g, b))
}


pub fn format(icon: &Vec<u16>, size: usize, color: Option<(u8, u8, u8)>) -> Vec<u16> {

    let mut result = Vec::with_capacity(icon.len() + 60);

    for c in icon.iter() {

        if *c < XMLNS {
            result.push(*c);
        }

        else if *c == COLOR {

            match color {
                None => {
                    result.push(U16_SPACE);
                }
                Some((r, g, b)) => {
                    for color_char in format_color(r, g, b) {
                        result.push(color_char);
                    }
                }
            }

        }

        else if *c == SIZE {

            for size_char in format_size(size) {
                result.push(size_char);
            }

        }

        else if *c == XMLNS {

            for xmlns_char in format_xmlns() {
                result.push(xmlns_char);
            }

        }

    }

    result
}
