mod render;

use lazy_static::lazy_static;
use std::collections::HashMap;


lazy_static! {
    static ref ICONS: HashMap<Vec<u16>, Vec<u16>> = self::render::data();
}


pub fn get_icon(name: &Vec<u16>, size: usize, color: Option<(u8, u8, u8)>, standalone: bool) -> Option<Vec<u16>> {

    match ICONS.get(name) {
        Some(s) => Some(self::render::format(s, size, color, standalone)),
        _ => None
    }

}