use crate::markdown::line::{Line, LineType};
use crate::markdown::math::render_math;
use self::decoration::*;
use self::tag::render_tag;
use self::link::render_link;

mod decoration;
pub mod link;
pub mod tag;


/*
I can't figure out nice way to deal with multiple nested inline elements. I can't understand [this article](https://github.github.com/gfm/#delimiter-run). So this is detour I chose.

# precedence

*inlines are rendered sequentially, in this order*

code span
math
link & image
italic
bold
underline   // it has to be rendered before subscript
del
subscript
superscript
alignment & color & size & box & special chars & svg
--- implemented so far
footnote
collapsible
*/


pub fn render_inlines(lines: Vec<Line>) -> Vec<Line> {

    lines.into_iter().map(render_inline).collect()
}


pub fn render_inline(mut line: Line) -> Line {
    
    match line.line_type {
        LineType::FencedCode | LineType::CodeFence | LineType::ThematicBreak
        | LineType::Empty | LineType::TableDelimiter | LineType::RenderedTable
        | LineType::Tag | LineType::Toc => line,

        LineType::Paragraph | LineType::Header | LineType::Blockquote(_)
        | LineType::OrderedList | LineType::UnorderedList => {
            let new_content = render_inline_raw(&line.content);
            line.content = new_content;

            line
        }
    }
}


pub fn render_inline_raw(content: &Vec<u16>) -> Vec<u16> {
    let mut content = render_code_spans(content);
    content = render_math(&content);
    content = render_link(&content);
    content = render_bold_and_italic(&content);
    content = render_italic(&content);
    content = render_bold(&content);
    content = render_underline(&content);
    content = render_subscript_and_del(&content);
    content = render_del(&content);
    content = render_subscript(&content);
    content = render_superscript(&content);
    content = render_tag(&content);

    content
}