mod line;
mod predicates;
mod code_fence;
mod list;
mod table;
mod blockquote;
mod paragraph;
mod toc;
mod inline;
mod escape;
mod syntax_highlighter;
mod icon;
mod colors;

use crate::utils::into_v16;
use escape::*;
use inline::render_inlines;
use inline::tag::render_independent_tag;
use line::{code_to_lines, render_lines};
use code_fence::merge_code_fence;
use paragraph::merge_paragraph;
use table::merge_table;
use blockquote::merge_blockquote;
use list::merge_list;
use toc::{collect_headers, render_toc};


pub fn render(content: &String) -> Result<String, ()> {

    let syntax_highlighter = self::syntax_highlighter::SyntaxHighlighter::new();

    let mut u16_content = into_v16(content);
    u16_content = escape_backslashes(&u16_content);
    u16_content = escape_htmls(&u16_content);

    let mut lines = code_to_lines(&u16_content);
    lines = merge_code_fence(&lines, &syntax_highlighter);

    let headers = collect_headers(&lines);

    lines = render_toc(&lines, &headers);
    lines = render_independent_tag(&lines);
    lines = render_inlines(lines);

    // `merge_paragraph` must be called after `merge_table`
    // because unused `TableDelimiter`s must be turned into `Paragraph`s.
    lines = merge_table(&lines);
    lines = merge_paragraph(&lines);

    lines = merge_list(&lines);
    lines = merge_blockquote(&lines);

    let mut result = render_lines(&lines);
    result = render_backslash_escape(&result);

    Ok(String::from_utf16_lossy(&result))
}