Rust hexchat-plugin
===================

`hexchat-plugin` provides safe and rusty API bindings for developing native
HexChat plugins.

To get started, implement `hexchat_plugin::Plugin` on a struct and use the
`hexchat_plugin!(impl Plugin)` macro in your `lib.rs`. Do not provide a `main`,
as it will not work. Make sure to use the `cdylib` crate-type, or it will also
not work.

Also note that plugins may be loaded multiple times. It's recommended to avoid
using global state (statics, thread locals) so as to not cause issues with it.

Examples
--------

For a production-grade plugin using this crate, take a look at
<https://github.com/SoniEx2/cw2-hexchat>.

License
-------

```text
Hexchat Plugin API Bindings for Rust
Copyright (C) 2018, 2021 Soni L.

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU Affero General Public License as
published by the Free Software Foundation, either version 3 of the
License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Affero General Public License for more details.

You should have received a copy of the GNU Affero General Public License
along with this program.  If not, see <https://www.gnu.org/licenses/>.
```
