#![cfg_attr(not(any(feature = "std", test)), no_std)]
#![deny(clippy::all, clippy::cargo)]
#![allow(clippy::missing_safety_doc)] // TODO

#[allow(unused_macros)]
macro_rules! item_group {
    ($($item:item)*) => {
        $($item)*
    }
}

#[cfg(feature = "alloc")]
extern crate alloc;

//
//
//
//
//

#[macro_use]
mod generic;

pub mod fallback;

#[cfg(any(target_arch = "x86", target_arch = "x86_64"))]
item_group! {
    pub mod avx2;
    pub mod sse41;
}

mod auto;
pub use self::auto::*;

#[cfg(test)]
mod tests;

//
//
//
//
//

use core::fmt;
use core::mem::MaybeUninit;

#[derive(Debug)]
pub struct Error(());

pub(crate) const ERROR: Error = Error(());

impl fmt::Display for Error {
    fn fmt(&self, f: &mut fmt::Formatter<'_>) -> fmt::Result {
        f.write_str("HexError")
    }
}

#[cfg(feature = "std")]
impl std::error::Error for Error {}

pub use simd_abstraction::generic::hex::AsciiCase;

//
//
//
//
//

#[inline(always)]
fn uninit_slice_as_mut_ptr<T>(slice: &mut [MaybeUninit<T>]) -> *mut T {
    slice.as_mut_ptr().cast()
}
