use std::sync::atomic::Ordering;

/// The interface to a collection of metrics
pub trait Hesione: Default {
    /// Gathers all the inner metrics and converts them into a string that
    /// Prometheus can understand
    ///
    /// * `order` decides the atomic ordering in which reads will be performed
    ///   on the individual metrics
    /// * `capacity` decides the size in bytes of the initial allocation for
    ///   the string to be returned. The default value is `2048`, which should
    ///   be enough for around 50-100 metrics depending on cardinality and
    ///   amount of help text.
    fn to_prometheus_lines(
        &self,
        order: Ordering,
        capacity: Option<usize>,
    ) -> String;
}
